/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.MapEditorController;
import net.sf.freecol.client.control.MapTransform;
import net.sf.freecol.client.gui.ChoiceItem;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.IndianNationType;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Resource;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.SettlementType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.server.model.ServerIndianSettlement;

public final class MapEditorTransformPanel
extends FreeColPanel {
    private static final Logger logger = Logger.getLogger(MapEditorTransformPanel.class.getName());
    private static Nation nativeNation;
    private final JPanel listPanel = new JPanel(new GridLayout(2, 0));
    private JToggleButton settlementButton;
    private final ButtonGroup group = new ButtonGroup();

    public MapEditorTransformPanel(FreeColClient freeColClient) {
        super(freeColClient, null, new BorderLayout());
        this.group.add(new JToggleButton());
        this.buildList();
        JScrollPane sl = new JScrollPane(this.listPanel, 20, 30);
        sl.getViewport().setOpaque(false);
        this.add(sl);
    }

    private Nation getNativeNation() {
        if (nativeNation == null) {
            nativeNation = CollectionUtils.first(this.getSpecification().getIndianNations());
        }
        return nativeNation;
    }

    public static void setNativeNation(Nation newNativeNation) {
        nativeNation = newNativeNation;
    }

    private void buildList() {
        Specification spec = this.getSpecification();
        Dimension terrainSize = ImageLibrary.scaleDimension(ImageLibrary.TILE_OVERLAY_SIZE, 0.5f);
        Dimension riverSize = ImageLibrary.scaleDimension(ImageLibrary.TILE_SIZE, 0.5f);
        for (TileType type : spec.getTileTypeList()) {
            BufferedImage tileImage = this.getImageLibrary().getTileImageWithOverlayAndForest(type, terrainSize);
            this.listPanel.add(this.buildButton(tileImage, Messages.getName(type), new TileTypeTransform(type)));
        }
        this.listPanel.add(this.buildButton(this.getImageLibrary().getRiverImage("0101", riverSize), Messages.message("mapEditorTransformPanel.minorRiver"), new RiverTransform(1)));
        this.listPanel.add(this.buildButton(this.getImageLibrary().getRiverImage("0202", riverSize), Messages.message("mapEditorTransformPanel.majorRiver"), new RiverTransform(2)));
        this.listPanel.add(this.buildButton(this.getImageLibrary().getRiverImage("2022", riverSize), Messages.message("mapEditorTransformPanel.changeRiverConnections"), new RiverStyleTransform(0)));
        this.listPanel.add(this.buildButton(this.getImageLibrary().getRiverImage("1022", riverSize), Messages.message("mapEditorTransformPanel.setRiverStyle"), new RiverStyleTransform(1)));
        ResourceType rt = CollectionUtils.first(spec.getResourceTypeList());
        this.listPanel.add(this.buildButton(this.getImageLibrary().getResourceTypeImage(rt, riverSize, false), Messages.message("mapEditorTransformPanel.resource"), new ResourceTransform()));
        this.listPanel.add(this.buildButton(this.getImageLibrary().getLCRImage(riverSize), Messages.getName(ModelMessage.MessageType.LOST_CITY_RUMOUR), new LostCityRumourTransform()));
        SettlementType settlementType = this.getNativeNation().getType().getCapitalType();
        this.listPanel.add(this.buildButton(this.getImageLibrary().getSettlementTypeImage(settlementType, riverSize), Messages.message("settlement"), new SettlementTransform()));
    }

    private JToggleButton buildButton(Image image, String text, MapTransform mt) {
        MapEditorController ctlr = this.getFreeColClient().getMapEditorController();
        JPanel descriptionPanel = new JPanel(new BorderLayout());
        descriptionPanel.add((Component)new JLabel(new ImageIcon(image)), "Center");
        descriptionPanel.add((Component)new JLabel(text, 0), "Last");
        descriptionPanel.setBackground(Color.RED);
        mt.setDescriptionPanel(descriptionPanel);
        ImageIcon icon = new ImageIcon(image);
        JToggleButton button = new JToggleButton(icon);
        button.setToolTipText(text);
        button.setOpaque(false);
        this.group.add(button);
        button.addActionListener(ae -> {
            MapTransform newMapTransform = null;
            if (ctlr.getMapTransform() != mt) {
                if (mt instanceof RiverStyleTransform) {
                    RiverStyleTransform rst = (RiverStyleTransform)mt;
                    boolean all = rst.getType() != 0;
                    String style = this.getGUI().showRiverStyleDialog(ImageLibrary.getRiverStyleKeys(all));
                    if (style != null) {
                        rst.setStyle(style);
                    }
                }
                newMapTransform = mt;
            }
            ctlr.setMapTransform(newMapTransform);
            if (newMapTransform == null && mt != null) {
                this.group.setSelected(this.group.getElements().nextElement().getModel(), true);
            }
        });
        button.setBorder(null);
        return button;
    }

    private ResourceType getResourceChoice(List<ResourceType> resources) {
        Function<ResourceType, ChoiceItem> mapper = rt -> new ChoiceItem<ResourceType>(Messages.getName(rt), (ResourceType)rt);
        StringTemplate tmpl = StringTemplate.template("mapEditorTransformPanel.chooseResource");
        return (ResourceType)this.getGUI().getChoice(tmpl, "cancel", CollectionUtils.transform(resources, CollectionUtils.alwaysTrue(), mapper));
    }

    public static final class TileTypeTransform
    extends MapTransform {
        private final TileType tileType;

        private TileTypeTransform(TileType tileType) {
            this.tileType = tileType;
        }

        public TileType getTileType() {
            return this.tileType;
        }

        @Override
        public void transform(Tile t) {
            t.changeType(this.tileType);
            t.removeLostCityRumour();
        }
    }

    private class SettlementTransform
    extends MapTransform {
        private SettlementTransform() {
        }

        @Override
        public void transform(Tile t) {
            if (!t.isLand() || t.hasSettlement()) {
                return;
            }
            UnitType skill = CollectionUtils.first(((IndianNationType)MapEditorTransformPanel.this.getNativeNation().getType()).getSkills()).getObject();
            Player nativePlayer = MapEditorTransformPanel.this.getGame().getPlayerByNation(MapEditorTransformPanel.this.getNativeNation());
            if (nativePlayer == null) {
                return;
            }
            String name = nativePlayer.getSettlementName(null);
            ServerIndianSettlement sis = new ServerIndianSettlement(t.getGame(), nativePlayer, name, t, false, skill, null);
            nativePlayer.addSettlement(sis);
            sis.placeSettlement(true);
            sis.addUnits(null);
            logger.info("Add settlement " + sis.getName() + " to tile " + t);
        }
    }

    private static class LostCityRumourTransform
    extends MapTransform {
        private LostCityRumourTransform() {
        }

        @Override
        public void transform(Tile t) {
            if (t.isLand()) {
                LostCityRumour rumour = t.getLostCityRumour();
                if (rumour == null) {
                    t.addLostCityRumour(new LostCityRumour(t.getGame(), t));
                } else {
                    t.removeLostCityRumour();
                }
            }
        }
    }

    private class ResourceTransform
    extends MapTransform {
        private ResourceTransform() {
        }

        @Override
        public void transform(Tile t) {
            Resource resource = null;
            if (t.getTileItemContainer() != null) {
                resource = t.getTileItemContainer().getResource();
            }
            if (resource != null) {
                t.getTileItemContainer().removeTileItem(resource);
            } else {
                List<ResourceType> resList = t.getType().getResourceTypeValues();
                switch (resList.size()) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        ResourceType resourceType = CollectionUtils.first(resList);
                        t.addResource(new Resource(t.getGame(), t, resourceType, resourceType.getMaxValue()));
                        return;
                    }
                }
                ResourceType choice = MapEditorTransformPanel.this.getResourceChoice(resList);
                if (choice != null) {
                    t.addResource(new Resource(t.getGame(), t, choice, choice.getMaxValue()));
                }
            }
        }
    }

    private static final class RiverStyleTransform
    extends MapTransform {
        public static final int CHANGE_CONNECTIONS = 0;
        public static final int SET_STYLE = 1;
        private String style = null;
        private int type;

        private RiverStyleTransform(int type) {
            this.type = type;
        }

        public void setStyle(String style) {
            this.style = style;
        }

        public int getType() {
            return this.type;
        }

        @Override
        public void transform(Tile tile) {
            TileImprovement river = tile.getRiver();
            if (river != null) {
                if (this.type == 0) {
                    river.updateRiverConnections(this.style);
                } else {
                    river.setRiverStyle(this.style);
                }
            }
        }
    }

    private static final class RiverTransform
    extends MapTransform {
        private final int magnitude;

        private RiverTransform(int magnitude) {
            this.magnitude = magnitude;
        }

        @Override
        public void transform(Tile tile) {
            TileImprovementType riverType = tile.getSpecification().getTileImprovementType("model.improvement.river");
            if (!riverType.isTileTypeAllowed(tile.getType())) {
                return;
            }
            if (tile.hasRiver()) {
                tile.removeRiver();
            } else {
                StringBuilder sb = new StringBuilder(64);
                for (Direction direction : Direction.longSides) {
                    TileImprovement otherRiver;
                    Tile t = tile.getNeighbourOrNull(direction);
                    TileImprovement tileImprovement = otherRiver = t == null ? null : t.getRiver();
                    if (t == null || t.isLand() && otherRiver == null) {
                        sb.append('0');
                        continue;
                    }
                    sb.append(this.magnitude);
                }
                tile.addRiver(this.magnitude, sb.toString());
            }
        }
    }
}

