/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.io.File;
import java.util.Objects;
import java.util.TreeSet;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.internal.impl.LocalPathComposer;
import org.eclipse.aether.internal.impl.SimpleDigest;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.LocalArtifactRegistration;
import org.eclipse.aether.repository.LocalArtifactRequest;
import org.eclipse.aether.repository.LocalArtifactResult;
import org.eclipse.aether.repository.LocalMetadataRegistration;
import org.eclipse.aether.repository.LocalMetadataRequest;
import org.eclipse.aether.repository.LocalMetadataResult;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;

class SimpleLocalRepositoryManager
implements LocalRepositoryManager {
    private final LocalRepository repository;
    private final LocalPathComposer localPathComposer;

    SimpleLocalRepositoryManager(File basedir, String type2, LocalPathComposer localPathComposer) {
        Objects.requireNonNull(basedir, "base directory cannot be null");
        this.repository = new LocalRepository(basedir.getAbsoluteFile(), type2);
        this.localPathComposer = Objects.requireNonNull(localPathComposer);
    }

    @Override
    public LocalRepository getRepository() {
        return this.repository;
    }

    @Override
    public String getPathForLocalArtifact(Artifact artifact) {
        Objects.requireNonNull(artifact, "artifact cannot be null");
        return this.localPathComposer.getPathForArtifact(artifact, true);
    }

    @Override
    public String getPathForRemoteArtifact(Artifact artifact, RemoteRepository repository, String context) {
        Objects.requireNonNull(artifact, "artifact cannot be null");
        Objects.requireNonNull(repository, "repository cannot be null");
        return this.localPathComposer.getPathForArtifact(artifact, false);
    }

    @Override
    public String getPathForLocalMetadata(Metadata metadata) {
        Objects.requireNonNull(metadata, "metadata cannot be null");
        return this.localPathComposer.getPathForMetadata(metadata, "local");
    }

    @Override
    public String getPathForRemoteMetadata(Metadata metadata, RemoteRepository repository, String context) {
        Objects.requireNonNull(metadata, "metadata cannot be null");
        Objects.requireNonNull(repository, "repository cannot be null");
        return this.localPathComposer.getPathForMetadata(metadata, this.getRepositoryKey(repository, context));
    }

    protected String getRepositoryKey(RemoteRepository repository, String context) {
        String key2;
        if (repository.isRepositoryManager()) {
            StringBuilder buffer2 = new StringBuilder(128);
            buffer2.append(repository.getId());
            buffer2.append('-');
            TreeSet<String> subKeys = new TreeSet<String>();
            for (RemoteRepository mirroredRepo : repository.getMirroredRepositories()) {
                subKeys.add(mirroredRepo.getId());
            }
            SimpleDigest digest = new SimpleDigest();
            digest.update(context);
            for (String subKey : subKeys) {
                digest.update(subKey);
            }
            buffer2.append(digest.digest());
            key2 = buffer2.toString();
        } else {
            key2 = repository.getId();
        }
        return key2;
    }

    @Override
    public LocalArtifactResult find(RepositorySystemSession session2, LocalArtifactRequest request) {
        File file2;
        String path2;
        Objects.requireNonNull(session2, "session cannot be null");
        Objects.requireNonNull(request, "request cannot be null");
        Artifact artifact = request.getArtifact();
        LocalArtifactResult result = new LocalArtifactResult(request);
        if (Objects.equals(artifact.getVersion(), artifact.getBaseVersion())) {
            path2 = this.getPathForLocalArtifact(artifact);
            file2 = new File(this.getRepository().getBasedir(), path2);
            if (file2.isFile()) {
                result.setFile(file2);
                result.setAvailable(true);
            }
        }
        if (!result.isAvailable()) {
            for (RemoteRepository repository : request.getRepositories()) {
                path2 = this.getPathForRemoteArtifact(artifact, repository, request.getContext());
                file2 = new File(this.getRepository().getBasedir(), path2);
                if (!file2.isFile()) continue;
                result.setFile(file2);
                result.setAvailable(true);
                break;
            }
        }
        return result;
    }

    @Override
    public void add(RepositorySystemSession session2, LocalArtifactRegistration request) {
        Objects.requireNonNull(session2, "session cannot be null");
        Objects.requireNonNull(request, "request cannot be null");
    }

    @Override
    public LocalMetadataResult find(RepositorySystemSession session2, LocalMetadataRequest request) {
        Objects.requireNonNull(session2, "session cannot be null");
        Objects.requireNonNull(request, "request cannot be null");
        LocalMetadataResult result = new LocalMetadataResult(request);
        Metadata metadata = request.getMetadata();
        String context = request.getContext();
        RemoteRepository remote = request.getRepository();
        String path2 = remote != null ? this.getPathForRemoteMetadata(metadata, remote, context) : this.getPathForLocalMetadata(metadata);
        File file2 = new File(this.getRepository().getBasedir(), path2);
        if (file2.isFile()) {
            result.setFile(file2);
        }
        return result;
    }

    @Override
    public void add(RepositorySystemSession session2, LocalMetadataRegistration request) {
        Objects.requireNonNull(session2, "session cannot be null");
        Objects.requireNonNull(request, "request cannot be null");
    }

    public String toString() {
        return String.valueOf(this.getRepository());
    }
}

