/* hypertextview.c generated by valac 0.56.14, the Vala compiler
 * generated from hypertextview.vala, do not modify */

/*
 *  Notes - panel plugin for Xfce Desktop Environment
 *  Copyright (c) 2009-2010  Mike Massonnet <mmassonnet@xfce.org>
 *  Copyright (c) 2009       Cornelius Hald <hald@icandy.de>
 *  Copyright (c) 2023       Arthur Demchenkov <spinal.by@gmail.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include "libnotes.h"
#include <gdk/gdk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <pango/pango.h>
#include <gio/gio.h>

enum  {
	XNP_HYPERTEXT_VIEW_0_PROPERTY,
	XNP_HYPERTEXT_VIEW_FONT_PROPERTY,
	XNP_HYPERTEXT_VIEW_NUM_PROPERTIES
};
static GParamSpec* xnp_hypertext_view_properties[XNP_HYPERTEXT_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
#define __vala_PangoTabArray_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoTabArray_free (var), NULL)))

struct _XnpHypertextViewPrivate {
	GdkCursor* hand_cursor;
	GdkCursor* regular_cursor;
	gboolean cursor_over_link;
	gint cursor_position;
	guint undo_timeout;
	gchar* undo_text;
	gchar* redo_text;
	gint undo_cursor_pos;
	gint redo_cursor_pos;
	GtkTextTag* tag_link;
	GRegex* regex_link;
	gchar* _font;
};

static gint XnpHypertextView_private_offset;
static gpointer xnp_hypertext_view_parent_class = NULL;

static void xnp_hypertext_view_style_updated_cb (XnpHypertextView* self,
                                          GtkWidget* hypertextview);
static void _xnp_hypertext_view_style_updated_cb_gtk_widget_style_updated (GtkWidget* _sender,
                                                                    gpointer self);
static gboolean xnp_hypertext_view_button_release_event_cb (XnpHypertextView* self,
                                                     GtkWidget* hypertextview,
                                                     GdkEventButton* event);
static gboolean _xnp_hypertext_view_button_release_event_cb_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                                      GdkEventButton* event,
                                                                                      gpointer self);
static gboolean xnp_hypertext_view_motion_notify_event_cb (XnpHypertextView* self,
                                                    GtkWidget* hypertextview,
                                                    GdkEventMotion* event);
static gboolean _xnp_hypertext_view_motion_notify_event_cb_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                                    GdkEventMotion* event,
                                                                                    gpointer self);
static void xnp_hypertext_view_state_flags_changed_cb (XnpHypertextView* self);
static void _xnp_hypertext_view_state_flags_changed_cb_gtk_widget_state_flags_changed (GtkWidget* _sender,
                                                                                GtkStateFlags previous_state_flags,
                                                                                gpointer self);
static void xnp_hypertext_view_move_cursor_cb (XnpHypertextView* self);
static void _xnp_hypertext_view_move_cursor_cb_g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self);
static void xnp_hypertext_view_buffer_changed_cb (XnpHypertextView* self);
static void _xnp_hypertext_view_buffer_changed_cb_gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                                                    gpointer self);
static void xnp_hypertext_view_insert_text_cb (XnpHypertextView* self,
                                        GtkTextBuffer* buffer,
                                        GtkTextIter* location,
                                        const gchar* text,
                                        gint len);
static void _xnp_hypertext_view_insert_text_cb_gtk_text_buffer_insert_text (GtkTextBuffer* _sender,
                                                                     GtkTextIter* pos,
                                                                     const gchar* new_text,
                                                                     gint new_text_length,
                                                                     gpointer self);
static void xnp_hypertext_view_delete_range_cb (XnpHypertextView* self,
                                         GtkTextBuffer* buffer,
                                         GtkTextIter* start,
                                         GtkTextIter* end);
static void _xnp_hypertext_view_delete_range_cb_gtk_text_buffer_delete_range (GtkTextBuffer* _sender,
                                                                       GtkTextIter* start,
                                                                       GtkTextIter* end,
                                                                       gpointer self);
static gboolean xnp_hypertext_view_undo_snapshot (XnpHypertextView* self);
static gboolean _xnp_hypertext_view_undo_snapshot_gsource_func (gpointer self);
static void xnp_hypertext_view_auto_highlight_urls (XnpHypertextView* self,
                                             GtkTextIter* start,
                                             GtkTextIter* end);
static void xnp_hypertext_view_extend_block (XnpHypertextView* self,
                                      GtkTextIter* start_iter,
                                      GtkTextIter* end_iter,
                                      gint max_len);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static GObject * xnp_hypertext_view_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static void _vala_PangoTabArray_free (PangoTabArray* self);
static void xnp_hypertext_view_finalize (GObject * obj);
static GType xnp_hypertext_view_get_type_once (void);
static void _vala_xnp_hypertext_view_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_xnp_hypertext_view_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);

static inline gpointer
xnp_hypertext_view_get_instance_private (XnpHypertextView* self)
{
	return G_STRUCT_MEMBER_P (self, XnpHypertextView_private_offset);
}

static void
_xnp_hypertext_view_style_updated_cb_gtk_widget_style_updated (GtkWidget* _sender,
                                                               gpointer self)
{
	xnp_hypertext_view_style_updated_cb ((XnpHypertextView*) self, _sender);
}

static gboolean
_xnp_hypertext_view_button_release_event_cb_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                             GdkEventButton* event,
                                                                             gpointer self)
{
	gboolean result;
	result = xnp_hypertext_view_button_release_event_cb ((XnpHypertextView*) self, _sender, event);
	return result;
}

static gboolean
_xnp_hypertext_view_motion_notify_event_cb_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                           GdkEventMotion* event,
                                                                           gpointer self)
{
	gboolean result;
	result = xnp_hypertext_view_motion_notify_event_cb ((XnpHypertextView*) self, _sender, event);
	return result;
}

static void
_xnp_hypertext_view_state_flags_changed_cb_gtk_widget_state_flags_changed (GtkWidget* _sender,
                                                                           GtkStateFlags previous_state_flags,
                                                                           gpointer self)
{
	xnp_hypertext_view_state_flags_changed_cb ((XnpHypertextView*) self);
}

static void
_xnp_hypertext_view_move_cursor_cb_g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self)
{
	xnp_hypertext_view_move_cursor_cb ((XnpHypertextView*) self);
}

static void
_xnp_hypertext_view_buffer_changed_cb_gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                                               gpointer self)
{
	xnp_hypertext_view_buffer_changed_cb ((XnpHypertextView*) self);
}

static void
_xnp_hypertext_view_insert_text_cb_gtk_text_buffer_insert_text (GtkTextBuffer* _sender,
                                                                GtkTextIter* pos,
                                                                const gchar* new_text,
                                                                gint new_text_length,
                                                                gpointer self)
{
	xnp_hypertext_view_insert_text_cb ((XnpHypertextView*) self, _sender, pos, new_text, new_text_length);
}

static void
_xnp_hypertext_view_delete_range_cb_gtk_text_buffer_delete_range (GtkTextBuffer* _sender,
                                                                  GtkTextIter* start,
                                                                  GtkTextIter* end,
                                                                  gpointer self)
{
	xnp_hypertext_view_delete_range_cb ((XnpHypertextView*) self, _sender, start, end);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

XnpHypertextView*
xnp_hypertext_view_construct (GType object_type)
{
	XnpHypertextView * self = NULL;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextBuffer* _tmp4_;
	GtkTextBuffer* _tmp5_;
	GtkTextBuffer* _tmp6_;
	GtkTextBuffer* _tmp7_;
	GtkTextBuffer* _tmp8_;
	GtkTextBuffer* _tmp9_;
	GtkTextTag* _tmp10_;
	GtkTextTag* _tmp11_;
	self = (XnpHypertextView*) g_object_new (object_type, NULL);
	g_signal_connect_object ((GtkWidget*) self, "style-updated", (GCallback) _xnp_hypertext_view_style_updated_cb_gtk_widget_style_updated, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "button-release-event", (GCallback) _xnp_hypertext_view_button_release_event_cb_gtk_widget_button_release_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "motion-notify-event", (GCallback) _xnp_hypertext_view_motion_notify_event_cb_gtk_widget_motion_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "state-flags-changed", (GCallback) _xnp_hypertext_view_state_flags_changed_cb_gtk_widget_state_flags_changed, self, 0);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	g_signal_connect_object ((GObject*) _tmp1_, "notify::cursor-position", (GCallback) _xnp_hypertext_view_move_cursor_cb_g_object_notify, self, 0);
	_tmp2_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp3_ = _tmp2_;
	g_signal_connect_object (_tmp3_, "changed", (GCallback) _xnp_hypertext_view_buffer_changed_cb_gtk_text_buffer_changed, self, 0);
	_tmp4_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp5_ = _tmp4_;
	g_signal_connect_object (_tmp5_, "insert-text", (GCallback) _xnp_hypertext_view_insert_text_cb_gtk_text_buffer_insert_text, self, G_CONNECT_AFTER);
	_tmp6_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp7_ = _tmp6_;
	g_signal_connect_object (_tmp7_, "delete-range", (GCallback) _xnp_hypertext_view_delete_range_cb_gtk_text_buffer_delete_range, self, G_CONNECT_AFTER);
	_tmp8_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp9_ = _tmp8_;
	_tmp10_ = gtk_text_buffer_create_tag (_tmp9_, "link", "foreground", "blue", "underline", PANGO_UNDERLINE_SINGLE, NULL, NULL);
	_tmp11_ = _g_object_ref0 (_tmp10_);
	_g_object_unref0 (self->priv->tag_link);
	self->priv->tag_link = _tmp11_;
	return self;
}

XnpHypertextView*
xnp_hypertext_view_new (void)
{
	return xnp_hypertext_view_construct (XNP_TYPE_HYPERTEXT_VIEW);
}

/**
 * style_updated_cb:
 *
 * Get the link color from the css.
 */
static void
xnp_hypertext_view_style_updated_cb (XnpHypertextView* self,
                                     GtkWidget* hypertextview)
{
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkStateFlags state = 0U;
	GtkTextTag* _tmp2_;
	GdkRGBA _tmp3_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (hypertextview != NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	context = _tmp1_;
	state = gtk_style_context_get_state (context);
	state &= ~GTK_STATE_FLAG_VISITED;
	state |= GTK_STATE_FLAG_LINK;
	gtk_style_context_save (context);
	gtk_style_context_set_state (context, state);
	gtk_style_context_remove_class (context, GTK_STYLE_CLASS_VIEW);
	_tmp2_ = self->priv->tag_link;
	gtk_style_context_get_color (context, state, &_tmp3_);
	g_object_set (_tmp2_, "foreground-rgba", &_tmp3_, NULL);
	gtk_style_context_restore (context);
	_g_object_unref0 (context);
}

/**
 * button_release_event_cb:
 *
 * Event to open links.
 */
static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gboolean
xnp_hypertext_view_button_release_event_cb (XnpHypertextView* self,
                                            GtkWidget* hypertextview,
                                            GdkEventButton* event)
{
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter iter = {0};
	gchar* link = NULL;
	gint x = 0;
	gint y = 0;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextIter _tmp2_ = {0};
	GtkTextIter _tmp3_ = {0};
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GtkTextIter _tmp6_ = {0};
	GtkTextTag* _tmp7_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (hypertextview != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->button != ((guint) GDK_BUTTON_PRIMARY)) {
		result = FALSE;
		_g_free0 (link);
		return result;
	}
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	gtk_text_buffer_get_selection_bounds (_tmp1_, &_tmp2_, &_tmp3_);
	start = _tmp2_;
	end = _tmp3_;
	if (gtk_text_iter_get_offset (&start) != gtk_text_iter_get_offset (&end)) {
		result = FALSE;
		_g_free0 (link);
		return result;
	}
	gtk_text_view_window_to_buffer_coords ((GtkTextView*) self, GTK_TEXT_WINDOW_WIDGET, (gint) event->x, (gint) event->y, &_tmp4_, &_tmp5_);
	x = _tmp4_;
	y = _tmp5_;
	gtk_text_view_get_iter_at_location ((GtkTextView*) self, &_tmp6_, x, y);
	iter = _tmp6_;
	_tmp7_ = self->priv->tag_link;
	if (gtk_text_iter_has_tag (&iter, _tmp7_)) {
		GtkTextIter _tmp8_;
		GtkTextIter _tmp9_;
		GtkTextTag* _tmp10_;
		GtkTextTag* _tmp12_;
		GtkTextIter _tmp13_;
		gchar* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gboolean _tmp18_;
		_tmp8_ = iter;
		end = _tmp8_;
		_tmp9_ = end;
		start = _tmp9_;
		_tmp10_ = self->priv->tag_link;
		if (!gtk_text_iter_starts_tag (&start, _tmp10_)) {
			GtkTextTag* _tmp11_;
			_tmp11_ = self->priv->tag_link;
			gtk_text_iter_backward_to_tag_toggle (&start, _tmp11_);
		}
		_tmp12_ = self->priv->tag_link;
		gtk_text_iter_forward_to_tag_toggle (&end, _tmp12_);
		_tmp13_ = end;
		_tmp14_ = gtk_text_iter_get_text (&start, &_tmp13_);
		_g_free0 (link);
		link = _tmp14_;
		_tmp15_ = link;
		_tmp16_ = string_slice (_tmp15_, (glong) 0, (glong) 2);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strcmp0 (_tmp17_, "~/") == 0;
		_g_free0 (_tmp17_);
		if (_tmp18_) {
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			_tmp19_ = g_get_home_dir ();
			_tmp20_ = link;
			_tmp21_ = string_substring (_tmp20_, (glong) 2, (glong) -1);
			_tmp22_ = _tmp21_;
			_tmp23_ = g_strdup_printf ("%s/%s", _tmp19_, _tmp22_);
			_g_free0 (link);
			link = _tmp23_;
			_g_free0 (_tmp22_);
		}
		{
			const gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp24_ = link;
			_tmp25_ = g_strconcat ("exo-open ", _tmp24_, NULL);
			_tmp26_ = _tmp25_;
			g_spawn_command_line_async (_tmp26_, &_inner_error0_);
			_g_free0 (_tmp26_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			result = FALSE;
			_g_free0 (link);
			return result;
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp27_ = FALSE;
			_g_free0 (link);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp27_;
		}
		{
			const gchar* _tmp28_;
			_tmp28_ = link;
			g_app_info_launch_default_for_uri (_tmp28_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			result = FALSE;
			_g_free0 (link);
			return result;
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp29_;
			const gchar* _tmp30_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp29_ = e;
			_tmp30_ = _tmp29_->message;
			g_message ("hypertextview.vala:154: Unable to open link with default handler: %s", _tmp30_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp31_ = FALSE;
			_g_free0 (link);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp31_;
		}
		{
			const gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			_tmp32_ = link;
			_tmp33_ = g_strconcat ("xdg-open ", _tmp32_, NULL);
			_tmp34_ = _tmp33_;
			g_spawn_command_line_async (_tmp34_, &_inner_error0_);
			_g_free0 (_tmp34_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch2_g_error;
			}
			result = FALSE;
			_g_free0 (link);
			return result;
		}
		goto __finally2;
		__catch2_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally2:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp35_ = FALSE;
			_g_free0 (link);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp35_;
		}
		{
			const gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			_tmp36_ = link;
			_tmp37_ = g_strconcat ("firefox ", _tmp36_, NULL);
			_tmp38_ = _tmp37_;
			g_spawn_command_line_async (_tmp38_, &_inner_error0_);
			_g_free0 (_tmp38_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch3_g_error;
			}
			result = FALSE;
			_g_free0 (link);
			return result;
		}
		goto __finally3;
		__catch3_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally3:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp39_ = FALSE;
			_g_free0 (link);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp39_;
		}
		g_message ("hypertextview.vala:169: Unable to find an appropriate fallback to open" \
" the link");
	}
	result = FALSE;
	_g_free0 (link);
	return result;
}

/**
 * motion_notify_event_cb:
 *
 * Event to update the cursor of the pointer.
 */
static gboolean
xnp_hypertext_view_motion_notify_event_cb (XnpHypertextView* self,
                                           GtkWidget* hypertextview,
                                           GdkEventMotion* event)
{
	GtkTextIter iter = {0};
	GdkWindow* win = NULL;
	gboolean over_link = FALSE;
	gint x = 0;
	gint y = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GtkTextIter _tmp2_ = {0};
	GtkTextTag* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (hypertextview != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	gtk_text_view_window_to_buffer_coords ((GtkTextView*) self, GTK_TEXT_WINDOW_WIDGET, (gint) event->x, (gint) event->y, &_tmp0_, &_tmp1_);
	x = _tmp0_;
	y = _tmp1_;
	gtk_text_view_get_iter_at_location ((GtkTextView*) self, &_tmp2_, x, y);
	iter = _tmp2_;
	_tmp3_ = self->priv->tag_link;
	over_link = gtk_text_iter_has_tag (&iter, _tmp3_);
	if (over_link != self->priv->cursor_over_link) {
		GdkWindow* _tmp4_;
		GdkWindow* _tmp5_;
		GdkCursor* _tmp6_ = NULL;
		GdkWindow* _tmp9_;
		self->priv->cursor_over_link = over_link;
		_tmp4_ = gtk_text_view_get_window ((GtkTextView*) self, GTK_TEXT_WINDOW_TEXT);
		_tmp5_ = _g_object_ref0 (_tmp4_);
		_g_object_unref0 (win);
		win = _tmp5_;
		if (over_link) {
			GdkCursor* _tmp7_;
			_tmp7_ = self->priv->hand_cursor;
			_tmp6_ = _tmp7_;
		} else {
			GdkCursor* _tmp8_;
			_tmp8_ = self->priv->regular_cursor;
			_tmp6_ = _tmp8_;
		}
		_tmp9_ = win;
		gdk_window_set_cursor (_tmp9_, _tmp6_);
	}
	result = FALSE;
	_g_object_unref0 (win);
	return result;
}

/**
 * state_flags_changed_cb:
 *
 * Fix mouse cursor behavior after clicking on a link.
 */
static void
xnp_hypertext_view_state_flags_changed_cb (XnpHypertextView* self)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (gtk_widget_get_realized ((GtkWidget*) self)) {
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = gtk_widget_get_sensitive ((GtkWidget*) self);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GdkWindow* win = NULL;
		GdkWindow* _tmp3_;
		GdkWindow* _tmp4_;
		GdkCursor* _tmp5_ = NULL;
		GdkWindow* _tmp8_;
		_tmp3_ = gtk_text_view_get_window ((GtkTextView*) self, GTK_TEXT_WINDOW_TEXT);
		_tmp4_ = _g_object_ref0 (_tmp3_);
		win = _tmp4_;
		if (self->priv->cursor_over_link) {
			GdkCursor* _tmp6_;
			_tmp6_ = self->priv->hand_cursor;
			_tmp5_ = _tmp6_;
		} else {
			GdkCursor* _tmp7_;
			_tmp7_ = self->priv->regular_cursor;
			_tmp5_ = _tmp7_;
		}
		_tmp8_ = win;
		gdk_window_set_cursor (_tmp8_, _tmp5_);
		_g_object_unref0 (win);
	}
}

/**
 * move_cursor_cb:
 *
 * Destroys existing timeouts and executes the actions immediately.
 */
static void
xnp_hypertext_view_move_cursor_cb (XnpHypertextView* self)
{
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GtkTextBuffer* _tmp4_;
	GtkTextBuffer* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	g_object_get (_tmp1_, "cursor-position", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if (self->priv->cursor_position == _tmp3_) {
		return;
	}
	if (self->priv->undo_timeout > ((guint) 0)) {
		xnp_hypertext_view_undo_snapshot (self);
	}
	_tmp4_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp5_ = _tmp4_;
	g_object_get (_tmp5_, "cursor-position", &_tmp6_, NULL);
	_tmp7_ = _tmp6_;
	self->priv->cursor_position = _tmp7_;
}

/**
 * buffer_changed_cb:
 *
 * Initializes timeouts to postpone actions.
 */
static gboolean
_xnp_hypertext_view_undo_snapshot_gsource_func (gpointer self)
{
	gboolean result;
	result = xnp_hypertext_view_undo_snapshot ((XnpHypertextView*) self);
	return result;
}

static void
xnp_hypertext_view_buffer_changed_cb (XnpHypertextView* self)
{
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	if (self->priv->undo_timeout > ((guint) 0)) {
		g_source_remove (self->priv->undo_timeout);
		self->priv->undo_timeout = (guint) 0;
	} else {
		self->priv->redo_cursor_pos = self->priv->cursor_position;
	}
	self->priv->undo_timeout = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 2, _xnp_hypertext_view_undo_snapshot_gsource_func, g_object_ref (self), g_object_unref);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	g_object_get (_tmp1_, "cursor-position", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	self->priv->cursor_position = _tmp3_;
}

/**
 * insert_text_cb:
 *
 * Event to create and update existing tags within the buffer.
 */
static void
xnp_hypertext_view_insert_text_cb (XnpHypertextView* self,
                                   GtkTextBuffer* buffer,
                                   GtkTextIter* location,
                                   const gchar* text,
                                   gint len)
{
	GtkTextIter end_iter = {0};
	GtkTextIter _tmp0_;
	GtkTextIter _tmp1_;
	GtkTextIter _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (buffer != NULL);
	g_return_if_fail (location != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = *location;
	end_iter = _tmp0_;
	gtk_text_iter_forward_chars (&end_iter, g_utf8_strlen (text, (gssize) -1));
	_tmp1_ = *location;
	_tmp2_ = end_iter;
	xnp_hypertext_view_auto_highlight_urls (self, &_tmp1_, &_tmp2_);
}

/**
 * delete_range_cb:
 *
 * Event to delete and update existing tags within the buffer.
 */
static void
xnp_hypertext_view_delete_range_cb (XnpHypertextView* self,
                                    GtkTextBuffer* buffer,
                                    GtkTextIter* start,
                                    GtkTextIter* end)
{
	GtkTextIter _tmp0_;
	GtkTextIter _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (buffer != NULL);
	g_return_if_fail (start != NULL);
	g_return_if_fail (end != NULL);
	_tmp0_ = *start;
	_tmp1_ = *end;
	xnp_hypertext_view_auto_highlight_urls (self, &_tmp0_, &_tmp1_);
}

/**
 * init_undo:
 *
 * Initialize the undo stack after loading a note.
 */
void
xnp_hypertext_view_init_undo (XnpHypertextView* self)
{
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_g_free0 (self->priv->undo_text);
	self->priv->undo_text = NULL;
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	g_object_get (_tmp1_, "text", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (self->priv->redo_text);
	self->priv->redo_text = _tmp3_;
	if (self->priv->undo_timeout > ((guint) 0)) {
		g_source_remove (self->priv->undo_timeout);
		self->priv->undo_timeout = (guint) 0;
	}
}

/**
 * undo_snapshot:
 *
 * Makes a snapshot of the current buffer and swaps undo/redo texts.
 */
static gboolean
xnp_hypertext_view_undo_snapshot (XnpHypertextView* self)
{
	gchar* text = NULL;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	g_object_get (_tmp1_, "text", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	text = _tmp3_;
	_tmp4_ = text;
	_tmp5_ = self->priv->redo_text;
	if (g_strcmp0 (_tmp4_, _tmp5_) != 0) {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp6_ = self->priv->redo_text;
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (self->priv->undo_text);
		self->priv->undo_text = _tmp7_;
		_tmp8_ = text;
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (self->priv->redo_text);
		self->priv->redo_text = _tmp9_;
		self->priv->undo_cursor_pos = self->priv->redo_cursor_pos;
		self->priv->redo_cursor_pos = self->priv->cursor_position;
	}
	if (self->priv->undo_timeout > ((guint) 0)) {
		g_source_remove (self->priv->undo_timeout);
		self->priv->undo_timeout = (guint) 0;
	}
	result = FALSE;
	_g_free0 (text);
	return result;
}

/**
 * undo:
 *
 * Revert the buffer to the undo text and swaps undo/redo texts.
 */
void
xnp_hypertext_view_undo (XnpHypertextView* self)
{
	GtkTextIter iter = {0};
	const gchar* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	guint _tmp3_;
	GtkTextBuffer* _tmp4_;
	GtkTextBuffer* _tmp5_;
	const gchar* _tmp6_;
	GtkTextBuffer* _tmp7_;
	GtkTextBuffer* _tmp8_;
	GtkTextBuffer* _tmp9_;
	GtkTextBuffer* _tmp10_;
	GtkTextIter _tmp11_ = {0};
	GtkTextBuffer* _tmp12_;
	GtkTextBuffer* _tmp13_;
	GtkTextIter _tmp14_;
	GtkTextIter _tmp15_;
	gchar* undo_text = NULL;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gint undo_cursor_pos = 0;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	g_return_if_fail (self != NULL);
	if (self->priv->undo_timeout > ((guint) 0)) {
		xnp_hypertext_view_undo_snapshot (self);
	}
	_tmp0_ = self->priv->undo_text;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp2_ = _tmp1_;
	g_signal_parse_name ("changed", gtk_text_buffer_get_type (), &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _xnp_hypertext_view_buffer_changed_cb_gtk_text_buffer_changed, self);
	_tmp4_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->undo_text;
	g_object_set (_tmp5_, "text", _tmp6_, NULL);
	_tmp7_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp8_ = _tmp7_;
	g_signal_connect_object (_tmp8_, "changed", (GCallback) _xnp_hypertext_view_buffer_changed_cb_gtk_text_buffer_changed, self, 0);
	_tmp9_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp10_ = _tmp9_;
	gtk_text_buffer_get_iter_at_offset (_tmp10_, &_tmp11_, self->priv->undo_cursor_pos);
	iter = _tmp11_;
	self->priv->cursor_position = self->priv->undo_cursor_pos;
	_tmp12_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp13_ = _tmp12_;
	_tmp14_ = iter;
	gtk_text_buffer_place_cursor (_tmp13_, &_tmp14_);
	_tmp15_ = iter;
	gtk_text_view_scroll_to_iter ((GtkTextView*) self, &_tmp15_, 0.0, FALSE, 0.5, 0.5);
	_tmp16_ = self->priv->undo_text;
	_tmp17_ = g_strdup (_tmp16_);
	undo_text = _tmp17_;
	undo_cursor_pos = self->priv->undo_cursor_pos;
	_tmp18_ = self->priv->redo_text;
	_tmp19_ = g_strdup (_tmp18_);
	_g_free0 (self->priv->undo_text);
	self->priv->undo_text = _tmp19_;
	self->priv->undo_cursor_pos = self->priv->redo_cursor_pos;
	_tmp20_ = undo_text;
	_tmp21_ = g_strdup (_tmp20_);
	_g_free0 (self->priv->redo_text);
	self->priv->redo_text = _tmp21_;
	self->priv->redo_cursor_pos = undo_cursor_pos;
	if (self->priv->undo_timeout > ((guint) 0)) {
		g_source_remove (self->priv->undo_timeout);
		self->priv->undo_timeout = (guint) 0;
	}
	xnp_hypertext_view_update_tags (self);
	_g_free0 (undo_text);
}

/**
 * update_tags:
 *
 * Goes through the entire document to search for untagged links and tag them.
 */
void
xnp_hypertext_view_update_tags (XnpHypertextView* self)
{
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextIter _tmp2_ = {0};
	GtkTextBuffer* _tmp3_;
	GtkTextBuffer* _tmp4_;
	GtkTextIter _tmp5_ = {0};
	GtkTextIter _tmp6_;
	GtkTextIter _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	gtk_text_buffer_get_start_iter (_tmp1_, &_tmp2_);
	start = _tmp2_;
	_tmp3_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp4_ = _tmp3_;
	gtk_text_buffer_get_end_iter (_tmp4_, &_tmp5_);
	end = _tmp5_;
	_tmp6_ = start;
	_tmp7_ = end;
	xnp_hypertext_view_auto_highlight_urls (self, &_tmp6_, &_tmp7_);
}

static void
xnp_hypertext_view_auto_highlight_urls (XnpHypertextView* self,
                                        GtkTextIter* start,
                                        GtkTextIter* end)
{
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextTag* _tmp2_;
	GtkTextIter _tmp3_;
	GtkTextIter _tmp4_;
	gchar* str = NULL;
	GtkTextIter _tmp5_;
	gchar* _tmp6_;
	GMatchInfo* match_info = NULL;
	GRegex* _tmp7_;
	const gchar* _tmp8_;
	GMatchInfo* _tmp9_ = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (start != NULL);
	g_return_if_fail (end != NULL);
	xnp_hypertext_view_extend_block (self, start, end, 256);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->tag_link;
	_tmp3_ = *start;
	_tmp4_ = *end;
	gtk_text_buffer_remove_tag (_tmp1_, _tmp2_, &_tmp3_, &_tmp4_);
	_tmp5_ = *end;
	_tmp6_ = gtk_text_iter_get_slice (start, &_tmp5_);
	str = _tmp6_;
	_tmp7_ = self->priv->regex_link;
	_tmp8_ = str;
	g_regex_match (_tmp7_, _tmp8_, 0, &_tmp9_);
	_g_match_info_unref0 (match_info);
	match_info = _tmp9_;
	{
		while (TRUE) {
			GMatchInfo* _tmp10_;
			gint start_pos = 0;
			gint end_pos = 0;
			GMatchInfo* _tmp11_;
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
			GtkTextIter xstart = {0};
			GtkTextIter _tmp14_;
			const gchar* _tmp15_;
			GtkTextIter xend = {0};
			GtkTextIter _tmp16_;
			const gchar* _tmp17_;
			GtkTextBuffer* _tmp18_;
			GtkTextBuffer* _tmp19_;
			GtkTextTag* _tmp20_;
			GtkTextIter _tmp21_;
			GtkTextIter _tmp22_;
			GMatchInfo* _tmp23_;
			_tmp10_ = match_info;
			if (!g_match_info_matches (_tmp10_)) {
				break;
			}
			_tmp11_ = match_info;
			g_match_info_fetch_pos (_tmp11_, 0, &_tmp12_, &_tmp13_);
			start_pos = _tmp12_;
			end_pos = _tmp13_;
			_tmp14_ = *start;
			xstart = _tmp14_;
			_tmp15_ = str;
			gtk_text_iter_forward_chars (&xstart, g_utf8_strlen (_tmp15_, (gssize) start_pos));
			_tmp16_ = *start;
			xend = _tmp16_;
			_tmp17_ = str;
			gtk_text_iter_forward_chars (&xend, g_utf8_strlen (_tmp17_, (gssize) end_pos));
			_tmp18_ = gtk_text_view_get_buffer ((GtkTextView*) self);
			_tmp19_ = _tmp18_;
			_tmp20_ = self->priv->tag_link;
			_tmp21_ = xstart;
			_tmp22_ = xend;
			gtk_text_buffer_apply_tag (_tmp19_, _tmp20_, &_tmp21_, &_tmp22_);
			_tmp23_ = match_info;
			g_match_info_next (_tmp23_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch0_g_regex_error;
				}
				_g_match_info_unref0 (match_info);
				_g_free0 (str);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp24_;
		const gchar* _tmp25_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp24_ = e;
		_tmp25_ = _tmp24_->message;
		g_warning ("hypertextview.vala:394: %s", _tmp25_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_match_info_unref0 (match_info);
		_g_free0 (str);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_match_info_unref0 (match_info);
	_g_free0 (str);
}

static void
xnp_hypertext_view_extend_block (XnpHypertextView* self,
                                 GtkTextIter* start_iter,
                                 GtkTextIter* end_iter,
                                 gint max_len)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (start_iter != NULL);
	g_return_if_fail (end_iter != NULL);
	if ((gtk_text_iter_get_line_offset (start_iter) - max_len) > 0) {
		GtkTextTag* _tmp0_;
		gtk_text_iter_backward_chars (start_iter, max_len);
		_tmp0_ = self->priv->tag_link;
		if (gtk_text_iter_has_tag (start_iter, _tmp0_)) {
			GtkTextTag* _tmp1_;
			_tmp1_ = self->priv->tag_link;
			gtk_text_iter_backward_to_tag_toggle (start_iter, _tmp1_);
		}
	} else {
		gtk_text_iter_set_line_offset (start_iter, 0);
	}
	if (!gtk_text_iter_ends_line (end_iter)) {
		if ((gtk_text_iter_get_line_offset (end_iter) + max_len) < gtk_text_iter_get_chars_in_line (end_iter)) {
			GtkTextTag* _tmp2_;
			gtk_text_iter_forward_chars (end_iter, max_len);
			_tmp2_ = self->priv->tag_link;
			if (gtk_text_iter_has_tag (end_iter, _tmp2_)) {
				GtkTextTag* _tmp3_;
				_tmp3_ = self->priv->tag_link;
				gtk_text_iter_forward_to_tag_toggle (end_iter, _tmp3_);
			}
		} else {
			gtk_text_iter_forward_to_line_end (end_iter);
		}
	}
}

const gchar*
xnp_hypertext_view_get_font (XnpHypertextView* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_font;
	result = _tmp0_;
	return result;
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

void
xnp_hypertext_view_set_font (XnpHypertextView* self,
                             const gchar* value)
{
	gchar* _tmp0_;
	PangoFontDescription* font_descr = NULL;
	PangoFontDescription* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_font);
	self->priv->_font = _tmp0_;
	_tmp1_ = pango_font_description_from_string (value);
	font_descr = _tmp1_;
	gtk_widget_override_font ((GtkWidget*) self, font_descr);
	__vala_PangoFontDescription_free0 (font_descr);
	g_object_notify_by_pspec ((GObject *) self, xnp_hypertext_view_properties[XNP_HYPERTEXT_VIEW_FONT_PROPERTY]);
}

static void
_vala_PangoTabArray_free (PangoTabArray* self)
{
	g_boxed_free (pango_tab_array_get_type (), self);
}

static GObject *
xnp_hypertext_view_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	XnpHypertextView * self;
	PangoTabArray* _tmp0_;
	PangoTabArray* _tmp1_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (xnp_hypertext_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XNP_TYPE_HYPERTEXT_VIEW, XnpHypertextView);
	xnp_hypertext_view_set_font (self, "Sans 13");
	_tmp0_ = pango_tab_array_new_with_positions (1, TRUE, PANGO_TAB_LEFT, 12, NULL);
	_tmp1_ = _tmp0_;
	gtk_text_view_set_tabs ((GtkTextView*) self, _tmp1_);
	__vala_PangoTabArray_free0 (_tmp1_);
	{
		GRegex* _tmp2_ = NULL;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		_tmp3_ = g_regex_new ("((\\b((news|http|https|ftp|file|irc)://|mailto:|(www|ftp)\\." "|\\S*@\\S*\\.)|(?<=^|\\s)/\\S+/|(?<=^|\\s)~/\\S+)\\S*\\b/?)", G_REGEX_CASELESS | G_REGEX_OPTIMIZE, 0, &_inner_error0_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		_tmp4_ = _tmp2_;
		_tmp2_ = NULL;
		_g_regex_unref0 (self->priv->regex_link);
		self->priv->regex_link = _tmp4_;
		_g_regex_unref0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_critical ("hypertextview.vala:64: %s", _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	return obj;
}

static void
xnp_hypertext_view_class_init (XnpHypertextViewClass * klass,
                               gpointer klass_data)
{
	xnp_hypertext_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &XnpHypertextView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_xnp_hypertext_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_xnp_hypertext_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = xnp_hypertext_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = xnp_hypertext_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_HYPERTEXT_VIEW_FONT_PROPERTY, xnp_hypertext_view_properties[XNP_HYPERTEXT_VIEW_FONT_PROPERTY] = g_param_spec_string ("font", "font", "font", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
xnp_hypertext_view_instance_init (XnpHypertextView * self,
                                  gpointer klass)
{
	GdkDisplay* _tmp0_;
	GdkCursor* _tmp1_;
	GdkDisplay* _tmp2_;
	GdkCursor* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	self->priv = xnp_hypertext_view_get_instance_private (self);
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = gdk_cursor_new_for_display (_tmp0_, GDK_HAND2);
	self->priv->hand_cursor = _tmp1_;
	_tmp2_ = gdk_display_get_default ();
	_tmp3_ = gdk_cursor_new_for_display (_tmp2_, GDK_XTERM);
	self->priv->regular_cursor = _tmp3_;
	self->priv->cursor_over_link = FALSE;
	self->priv->cursor_position = 0;
	self->priv->undo_timeout = (guint) 0;
	_tmp4_ = g_strdup ("");
	self->priv->undo_text = _tmp4_;
	_tmp5_ = g_strdup ("");
	self->priv->redo_text = _tmp5_;
}

static void
xnp_hypertext_view_finalize (GObject * obj)
{
	XnpHypertextView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XNP_TYPE_HYPERTEXT_VIEW, XnpHypertextView);
	if (self->priv->undo_timeout != ((guint) 0)) {
		g_source_remove (self->priv->undo_timeout);
	}
	_g_object_unref0 (self->priv->hand_cursor);
	_g_object_unref0 (self->priv->regular_cursor);
	_g_free0 (self->priv->undo_text);
	_g_free0 (self->priv->redo_text);
	_g_object_unref0 (self->priv->tag_link);
	_g_regex_unref0 (self->priv->regex_link);
	_g_free0 (self->priv->_font);
	G_OBJECT_CLASS (xnp_hypertext_view_parent_class)->finalize (obj);
}

static GType
xnp_hypertext_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (XnpHypertextViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xnp_hypertext_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XnpHypertextView), 0, (GInstanceInitFunc) xnp_hypertext_view_instance_init, NULL };
	GType xnp_hypertext_view_type_id;
	xnp_hypertext_view_type_id = g_type_register_static (gtk_text_view_get_type (), "XnpHypertextView", &g_define_type_info, 0);
	XnpHypertextView_private_offset = g_type_add_instance_private (xnp_hypertext_view_type_id, sizeof (XnpHypertextViewPrivate));
	return xnp_hypertext_view_type_id;
}

GType
xnp_hypertext_view_get_type (void)
{
	static volatile gsize xnp_hypertext_view_type_id__once = 0;
	if (g_once_init_enter (&xnp_hypertext_view_type_id__once)) {
		GType xnp_hypertext_view_type_id;
		xnp_hypertext_view_type_id = xnp_hypertext_view_get_type_once ();
		g_once_init_leave (&xnp_hypertext_view_type_id__once, xnp_hypertext_view_type_id);
	}
	return xnp_hypertext_view_type_id__once;
}

static void
_vala_xnp_hypertext_view_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	XnpHypertextView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, XNP_TYPE_HYPERTEXT_VIEW, XnpHypertextView);
	switch (property_id) {
		case XNP_HYPERTEXT_VIEW_FONT_PROPERTY:
		g_value_set_string (value, xnp_hypertext_view_get_font (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_xnp_hypertext_view_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	XnpHypertextView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, XNP_TYPE_HYPERTEXT_VIEW, XnpHypertextView);
	switch (property_id) {
		case XNP_HYPERTEXT_VIEW_FONT_PROPERTY:
		xnp_hypertext_view_set_font (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

