/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.feedback;

import ancestris.core.CoreOptions;
import ancestris.modules.feedback.FeedBackOptionsPanelController;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.windows.WindowManager;

final class FeedBackOptionPanel
extends JPanel
implements PropertyChangeListener {
    private final FeedBackOptionsPanelController controller;
    private boolean changeInProgress = false;
    private JCheckBox SSLEncryptioncheckBox;
    private JCheckBox TLSEncryptioncheckBox;
    private ButtonGroup buttonGroup1;
    private JCheckBox checkBoxAuthenticationRequired;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel labelEmailAddress;
    private JLabel labelLoginName;
    private JLabel labelName;
    private JLabel labelSMTPHost;
    private JCheckBox noEncryptioncheckBox;
    JFormattedTextField textFieldEmailAddress;
    private JTextField textFieldLoginName;
    JFormattedTextField textFieldName;
    JFormattedTextField textFieldSMTPHost;
    private JTextField textFieldSMTPPort;

    FeedBackOptionPanel(FeedBackOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        DocumentChangeListener listener = new DocumentChangeListener();
        this.textFieldName.getDocument().putProperty("owner", "username");
        this.textFieldName.getDocument().addDocumentListener(listener);
        this.textFieldEmailAddress.getDocument().putProperty("owner", "useremail");
        this.textFieldEmailAddress.getDocument().addDocumentListener(listener);
        CoreOptions.getInstance().addPropertyChangeListener((PropertyChangeListener)this);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.labelName = new JLabel();
        this.textFieldName = new JFormattedTextField();
        this.labelEmailAddress = new JLabel();
        this.textFieldEmailAddress = new JFormattedTextField();
        this.labelSMTPHost = new JLabel();
        this.textFieldSMTPHost = new JFormattedTextField();
        this.jLabel1 = new JLabel();
        this.textFieldSMTPPort = new JTextField();
        this.SSLEncryptioncheckBox = new JCheckBox();
        this.TLSEncryptioncheckBox = new JCheckBox();
        this.checkBoxAuthenticationRequired = new JCheckBox();
        this.labelLoginName = new JLabel();
        this.textFieldLoginName = new JTextField();
        this.noEncryptioncheckBox = new JCheckBox();
        this.jLabel2 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.labelName, (String)NbBundle.getMessage(FeedBackOptionPanel.class, (String)"FeedBackOptionPanel.labelName.text"));
        this.textFieldName.setText(NbBundle.getMessage(FeedBackOptionPanel.class, (String)"FeedBackOptionPanel.textFieldName.text"));
        Mnemonics.setLocalizedText((JLabel)this.labelEmailAddress, (String)NbBundle.getMessage(FeedBackOptionPanel.class, (String)"FeedBackOptionPanel.labelEmailAddress.text"));
        this.textFieldEmailAddress.setText(NbBundle.getMessage(FeedBackOptionPanel.class, (String)"FeedBackOptionPanel.textFieldEmailAddress.text"));
        Mnemonics.setLocalizedText((JLabel)this.labelSMTPHost, (String)NbBundle.getMessage(FeedBackOptionPanel.class, (String)"FeedBackOptionPanel.labelSMTPHost.text"));
        this.textFieldSMTPHost.setText(NbBundle.getMessage(FeedBackOptionPanel.class, (String)"FeedBackOptionPanel.textFieldSMTPHost.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(FeedBackOptionPanel.class, (String)"FeedBackOptionPanel.jLabel1.text"));
        this.textFieldSMTPPort.setText(NbBundle.getMessage(FeedBackOptionPanel.class, (String)"FeedBackOptionPanel.textFieldSMTPPort.text"));
        this.buttonGroup1.add(this.SSLEncryptioncheckBox);
        Mnemonics.setLocalizedText((AbstractButton)this.SSLEncryptioncheckBox, (String)NbBundle.getMessage(FeedBackOptionPanel.class, (String)"FeedBackOptionPanel.SSLEncryptioncheckBox.text"));
        this.SSLEncryptioncheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeedBackOptionPanel.this.SSLEncryptioncheckBoxActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.TLSEncryptioncheckBox);
        Mnemonics.setLocalizedText((AbstractButton)this.TLSEncryptioncheckBox, (String)NbBundle.getMessage(FeedBackOptionPanel.class, (String)"FeedBackOptionPanel.TLSEncryptioncheckBox.text"));
        this.TLSEncryptioncheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeedBackOptionPanel.this.TLSEncryptioncheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.checkBoxAuthenticationRequired, (String)NbBundle.getMessage(FeedBackOptionPanel.class, (String)"FeedBackOptionPanel.checkBoxAuthenticationRequired.text"));
        this.checkBoxAuthenticationRequired.setHorizontalAlignment(11);
        this.checkBoxAuthenticationRequired.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeedBackOptionPanel.this.checkBoxAuthenticationRequiredActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.labelLoginName, (String)NbBundle.getMessage(FeedBackOptionPanel.class, (String)"FeedBackOptionPanel.labelLoginName.text"));
        this.labelLoginName.setEnabled(false);
        this.textFieldLoginName.setText(NbBundle.getMessage(FeedBackOptionPanel.class, (String)"FeedBackOptionPanel.textFieldLoginName.text"));
        this.textFieldLoginName.setEnabled(false);
        this.buttonGroup1.add(this.noEncryptioncheckBox);
        Mnemonics.setLocalizedText((AbstractButton)this.noEncryptioncheckBox, (String)NbBundle.getMessage(FeedBackOptionPanel.class, (String)"FeedBackOptionPanel.noEncryptioncheckBox.text"));
        this.noEncryptioncheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeedBackOptionPanel.this.noEncryptioncheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(FeedBackOptionPanel.class, (String)"FeedBackOptionPanel.jLabel2.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.labelLoginName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textFieldLoginName, -1, 379, Short.MAX_VALUE)).addComponent(this.checkBoxAuthenticationRequired).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelEmailAddress).addComponent(this.labelName).addComponent(this.labelSMTPHost).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.textFieldSMTPPort, -2, 90, -2).addGroup(layout.createSequentialGroup().addComponent(this.noEncryptioncheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.TLSEncryptioncheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.SSLEncryptioncheckBox)).addComponent(this.textFieldSMTPHost, -1, 326, Short.MAX_VALUE).addComponent(this.textFieldEmailAddress, -1, 326, Short.MAX_VALUE).addComponent(this.textFieldName, -1, 326, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.textFieldName, -2, -1, -2).addComponent(this.labelName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.textFieldEmailAddress, -2, -1, -2).addComponent(this.labelEmailAddress)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.textFieldSMTPHost, -2, -1, -2).addComponent(this.labelSMTPHost)).addGap(4, 4, 4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.noEncryptioncheckBox).addComponent(this.TLSEncryptioncheckBox).addComponent(this.SSLEncryptioncheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.textFieldSMTPPort, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxAuthenticationRequired).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelLoginName).addComponent(this.textFieldLoginName, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void checkBoxAuthenticationRequiredActionPerformed(ActionEvent evt) {
        if (this.checkBoxAuthenticationRequired.isSelected()) {
            this.labelLoginName.setEnabled(true);
            this.textFieldLoginName.setEnabled(true);
        } else {
            this.labelLoginName.setEnabled(false);
            this.textFieldLoginName.setEnabled(false);
            this.textFieldLoginName.setText("");
        }
    }

    private void noEncryptioncheckBoxActionPerformed(ActionEvent evt) {
        this.textFieldSMTPPort.setText("25");
    }

    private void TLSEncryptioncheckBoxActionPerformed(ActionEvent evt) {
        this.textFieldSMTPPort.setText("587");
    }

    private void SSLEncryptioncheckBoxActionPerformed(ActionEvent evt) {
        this.textFieldSMTPPort.setText("465");
    }

    void load() {
        Preferences modulePreferences = NbPreferences.forModule(FeedBackOptionPanel.class);
        this.textFieldName.setText(modulePreferences.get("mail.name", NbBundle.getMessage(FeedBackOptionPanel.class, (String)"FeedBackOptionPanel.textFieldName.text")));
        this.textFieldEmailAddress.setText(modulePreferences.get("mail.address", NbBundle.getMessage(FeedBackOptionPanel.class, (String)"FeedBackOptionPanel.textFieldEmailAddress.text")));
        this.textFieldSMTPHost.setText(modulePreferences.get("mail.host", NbBundle.getMessage(FeedBackOptionPanel.class, (String)"FeedBackOptionPanel.labelSMTPHost.text")));
        this.textFieldSMTPPort.setText(modulePreferences.get("mail.host.port", NbBundle.getMessage(FeedBackOptionPanel.class, (String)"FeedBackOptionPanel.textFieldSMTPPort.text")));
        this.noEncryptioncheckBox.setSelected(modulePreferences.getBoolean("mail.host.NoEncryption", true));
        this.TLSEncryptioncheckBox.setSelected(modulePreferences.getBoolean("mail.host.TLSEncryption", false));
        this.SSLEncryptioncheckBox.setSelected(modulePreferences.getBoolean("mail.host.SSLEncryption", false));
        this.checkBoxAuthenticationRequired.setSelected(modulePreferences.getBoolean("mail.host.AuthenticationRequired", false));
        if (this.checkBoxAuthenticationRequired.isSelected()) {
            this.labelLoginName.setEnabled(true);
            this.textFieldLoginName.setEnabled(true);
            this.textFieldLoginName.setText(modulePreferences.get("mail.host.login", NbBundle.getMessage(FeedBackOptionPanel.class, (String)"FeedBackOptionPanel.textFieldLoginName.text")));
        } else {
            this.labelLoginName.setEnabled(false);
            this.textFieldLoginName.setEnabled(false);
            this.textFieldLoginName.setText("");
        }
    }

    void store() {
        Preferences modulePreferences = NbPreferences.forModule(FeedBackOptionPanel.class);
        modulePreferences.put("mail.name", this.textFieldName.getText());
        modulePreferences.put("mail.address", this.textFieldEmailAddress.getText());
        modulePreferences.put("mail.host", this.textFieldSMTPHost.getText());
        modulePreferences.put("mail.host.port", this.textFieldSMTPPort.getText());
        modulePreferences.putBoolean("mail.host.NoEncryption", this.noEncryptioncheckBox.isSelected());
        modulePreferences.putBoolean("mail.host.TLSEncryption", this.TLSEncryptioncheckBox.isSelected());
        modulePreferences.putBoolean("mail.host.SSLEncryption", this.SSLEncryptioncheckBox.isSelected());
        modulePreferences.putBoolean("mail.host.AuthenticationRequired", this.checkBoxAuthenticationRequired.isSelected());
        if (this.checkBoxAuthenticationRequired.isSelected()) {
            modulePreferences.put("mail.host.login", this.textFieldLoginName.getText());
        } else {
            modulePreferences.put("mail.host.login", "");
            modulePreferences.put("mail.host.password", "");
        }
    }

    boolean valid() {
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.changeInProgress) {
            if (evt.getPropertyName().equals("username")) {
                this.textFieldName.setText((String)evt.getNewValue());
            } else if (evt.getPropertyName().equals("useremail")) {
                this.textFieldEmailAddress.setText((String)evt.getNewValue());
            }
        }
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                FeedBackOptionPanel.this.changeInProgress = false;
            }
        });
    }

    private class DocumentChangeListener
    implements DocumentListener {
        private DocumentChangeListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateOption(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateOption(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updateOption(e);
        }

        private void updateOption(DocumentEvent e) {
            String property = (String)e.getDocument().getProperty("owner");
            String oldValue = "";
            String newValue = "";
            try {
                newValue = e.getDocument().getText(0, e.getDocument().getLength());
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            FeedBackOptionPanel.this.changeInProgress = true;
            CoreOptions.getInstance().fireOptionChange(property, (Object)oldValue, (Object)newValue);
        }
    }
}

