import sys
import os
import signal
import chestnut_dialer.config

class Chat:
  def __init__(self):
    self.pid = 0
    signal.signal(signal.SIGINT, self.sig_hdl)
    signal.signal(signal.SIGTERM, self.sig_hdl)
  def sig_hdl(self, signum, *args):
    if self.pid > 0: os.kill(signum, self.pid)
    sys.exit(0)
  def chat(self, *args):
    self.pid = os.fork()
    if self.pid < 0:
      sys.stderr.write("%s: cannot fork\n" % sys.argv[0])
      self.pid = 0
      return -1
    if self.pid == 0:
      os.execvp(chestnut_dialer.config.chat,
          [chestnut_dialer.config.chat] +
          map(lambda x: x, args))
      sys.stderr.write("%s: cannot execvp\n" % sys.argv[0])
      return -1
    try:
      p, s = os.waitpid(self.pid, 0)
      self.pid = 0
      return s / 256
    except OSError: pass
    self.pid = 0
    return -1
