# Copyright 2006-2010 The FLWOR Foundation.
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
# http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# - Config file for the Zorba package
# It defines the following variables
#  Zorba_INCLUDE_DIRS - include directories for Zorba
#  Zorba_LIBRARY_DIRS - library directories for Zorba (normally not used!)
#  Zorba_LIBRARIES    - libraries to link against QQQ
#  Zorba_EXE          - the Zorba executable (or .bat script inside Zorba build)
#  Zorba_TESTDRIVER   - the Zorba testdriver executable
#  ZORBA_STORE_NAME   - the name of the store in this installation
#  Zorba_USE_FILE     - file which projects depending on Zorba should INCLUDE()
#  Zorba_EXTERNALMODULECONFIG_FILE - file which modules should use to
#    export their module paths for dependent modules

MACRO (SET_NORMALIZED VARNAME VALUE)
  SET (_tmp)
  FOREACH (_path ${VALUE})
    GET_FILENAME_COMPONENT (_abspath ${_path} ABSOLUTE)
    LIST (APPEND _tmp ${_abspath})
  ENDFOREACH (_path)
  SET (${VARNAME} ${_tmp} ${ARGN})
ENDMACRO (SET_NORMALIZED)

# Pass through some variables from main Zorba CMake configuration.
SET (ZORBA_VERSION "3.1.0" CACHE STRING "Zorba's version" FORCE)
SET (ZORBA_STORE_NAME "simplestore" CACHE STRING
  "Name of the store implementation this Zorba was built with" FORCE)

# Tell the user project where to find our headers, libraries, and
# CMake modules
SET_NORMALIZED (Zorba_INCLUDE_DIRS "${Zorba_DIR}/../../../include")
SET_NORMALIZED (Zorba_LIBRARY_DIRS "${Zorba_DIR}/../../../lib")
SET_NORMALIZED (Zorba_CMAKE_MODULES_DIR "${Zorba_DIR}/../../../share/cmake/zorba-3.1.0")
SET_NORMALIZED (Zorba_TESTDRIVER "${Zorba_DIR}/../../../bin/testdriver" CACHE PATH
  "Path to Zorba's testdriver" FORCE)
SET_NORMALIZED (Zorba_EXE "${Zorba_DIR}/../../../bin/zorba" CACHE PATH "Path to Zorba executable" FORCE)

# Tell the user project where (non-core) modules are installed. Note:
# These variables are all-uppercase because they are also used
# internally by Zorba's build.
SET (ZORBA_NONCORE_URI_DIR "${Zorba_DIR}/../../../share/zorba/uris"
  CACHE STRING "Path to Zorba to non-core modules/schemas in this Zorba installation" FORCE)
SET (ZORBA_NONCORE_LIB_DIR "${Zorba_DIR}/../../../lib/zorba"
  CACHE STRING "Path to Zorba to non-core libraries in this Zorba installation" FORCE)

# Tell the user project where to find the "USE" file.
# This file uses the above settings to configure the user project.
SET_NORMALIZED (Zorba_USE_FILE "${Zorba_DIR}/../../../share/cmake/zorba-3.1.0/ZorbaUse.cmake")

# Set the path to ExternalModuleConfig.cmake.in, used by module
# projects to export their module paths.
SET_NORMALIZED (Zorba_EXTERNALMODULECONFIG_FILE
  "${Zorba_DIR}/../../../share/cmake/zorba-3.1.0/ExternalModuleConfig.cmake.in")

IF(NOT Zorba_FIND_QUIETLY)
  MESSAGE(STATUS "Found Zorba 3.1.0 (store: ${ZORBA_STORE_NAME})")
  MESSAGE(STATUS " - Include dirs: ${Zorba_INCLUDE_DIRS}")
  MESSAGE(STATUS " - Library dirs: ${Zorba_LIBRARY_DIRS}")
ENDIF(NOT Zorba_FIND_QUIETLY)
