# This file was automatically generated by bifcl from /opt/local/var/macports/build/zeek-c10ab06c/work/zeek-8.0.4/src/analyzer/protocol/tcp/events.bif (plugin mode).

export {

## Generated when reassembly starts for a TCP connection. This event is raised
## at the moment when Zeek's TCP analyzer enables stream reassembly for a
## connection.
##
## c: The connection.
##
## .. zeek:see:: connection_EOF connection_SYN_packet connection_attempt
##    connection_established connection_finished
##    connection_first_ACK connection_half_finished connection_partial_close
##    connection_pending connection_rejected connection_reset connection_reused
##    connection_state_remove connection_status_update connection_timeout
##    scheduled_analyzer_applied new_connection partial_connection
global new_connection_contents: event(c: connection );


## Generated for an unsuccessful connection attempt. This event is raised when
## an originator unsuccessfully attempted to establish a connection.
## "Unsuccessful" is defined as at least :zeek:id:`tcp_attempt_delay` seconds
## having elapsed since the originator first sent a connection establishment
## packet to the destination without seeing a reply.
##
## c: The connection.
##
## .. zeek:see:: connection_EOF connection_SYN_packet connection_established
##    connection_finished connection_first_ACK
##    connection_half_finished connection_partial_close connection_pending
##    connection_rejected connection_reset connection_reused connection_state_remove
##    connection_status_update connection_timeout scheduled_analyzer_applied
##    new_connection new_connection_contents partial_connection
global connection_attempt: event(c: connection );


## Generated when seeing a SYN-ACK packet from the responder in a TCP
## handshake.  An associated SYN packet was not seen from the originator
## side if its state is not set to :zeek:see:`TCP_ESTABLISHED`.
## The final ACK of the handshake in response to SYN-ACK may
## or may not occur later, one way to tell is to check the *history* field of
## :zeek:type:`connection` to see if the originator sent an ACK, indicated by
## 'A' in the history string.
##
## c: The connection.
##
## .. zeek:see:: connection_EOF connection_SYN_packet connection_attempt
##    connection_finished connection_first_ACK
##    connection_half_finished connection_partial_close connection_pending
##    connection_rejected connection_reset connection_reused connection_state_remove
##    connection_status_update connection_timeout scheduled_analyzer_applied
##    new_connection new_connection_contents partial_connection
global connection_established: event(c: connection );


## Generated for a new active TCP connection if Zeek did not see the initial
## handshake. This event is raised when Zeek has observed traffic from each
## endpoint, but the activity did not begin with the usual connection
## establishment.
##
## c: The connection.
##
## .. zeek:see:: connection_EOF connection_SYN_packet connection_attempt
##    connection_established connection_finished
##    connection_first_ACK connection_half_finished connection_partial_close
##    connection_pending connection_rejected connection_reset connection_reused
##    connection_state_remove connection_status_update connection_timeout
##    scheduled_analyzer_applied new_connection new_connection_contents
##
global partial_connection: event(c: connection );


## Generated when a previously inactive endpoint attempts to close a TCP
## connection via a normal FIN handshake or an abort RST sequence. When the
## endpoint sent one of these packets, Zeek waits
## :zeek:id:`tcp_partial_close_delay` prior to generating the event, to give
## the other endpoint a chance to close the connection normally.
##
## c: The connection.
##
## .. zeek:see:: connection_EOF connection_SYN_packet connection_attempt
##    connection_established connection_finished
##    connection_first_ACK connection_half_finished connection_pending
##    connection_rejected connection_reset connection_reused connection_state_remove
##    connection_status_update connection_timeout scheduled_analyzer_applied
##    new_connection new_connection_contents partial_connection
global connection_partial_close: event(c: connection );


## Generated for a TCP connection that finished normally. The event is raised
## when a regular FIN handshake from both endpoints was observed.
##
## c: The connection.
##
## .. zeek:see:: connection_EOF connection_SYN_packet connection_attempt
##    connection_established connection_first_ACK
##    connection_half_finished connection_partial_close connection_pending
##    connection_rejected connection_reset connection_reused connection_state_remove
##    connection_status_update connection_timeout scheduled_analyzer_applied
##    new_connection new_connection_contents partial_connection
global connection_finished: event(c: connection );


## Generated when one endpoint of a TCP connection attempted to gracefully close
## the connection, but the other endpoint is in the TCP_INACTIVE state. This can
## happen due to split routing, in which Zeek only sees one side of a connection.
##
## c: The connection.
##
## .. zeek:see:: connection_EOF connection_SYN_packet connection_attempt
##    connection_established connection_finished
##    connection_first_ACK  connection_partial_close connection_pending
##    connection_rejected connection_reset connection_reused connection_state_remove
##    connection_status_update connection_timeout scheduled_analyzer_applied
##    new_connection new_connection_contents partial_connection
global connection_half_finished: event(c: connection );


## Generated for a rejected TCP connection. This event is raised when an
## originator attempted to setup a TCP connection but the responder replied
## with a RST packet denying it.
##
## c: The connection.
##
## .. zeek:see:: connection_EOF connection_SYN_packet connection_attempt
##    connection_established connection_finished
##    connection_first_ACK connection_half_finished connection_partial_close
##    connection_pending  connection_reset connection_reused connection_state_remove
##    connection_status_update connection_timeout scheduled_analyzer_applied
##    new_connection new_connection_contents partial_connection
##
## .. note::
##
##    If the responder does not respond at all, :zeek:id:`connection_attempt` is
##    raised instead. If the responder initially accepts the connection but
##    aborts it later, Zeek first generates :zeek:id:`connection_established`
##    and then :zeek:id:`connection_reset`.
global connection_rejected: event(c: connection );


## Generated when an endpoint aborted a TCP connection. The event is raised
## when one endpoint of an established TCP connection aborted by sending a RST
## packet.
##
## c: The connection.
##
## .. zeek:see:: connection_EOF connection_SYN_packet connection_attempt
##    connection_established connection_finished
##    connection_first_ACK connection_half_finished connection_partial_close
##    connection_pending connection_rejected  connection_reused
##    connection_state_remove connection_status_update connection_timeout
##    scheduled_analyzer_applied new_connection new_connection_contents
##    partial_connection
global connection_reset: event(c: connection );


## Generated for each still-open TCP connection when Zeek terminates.
##
## c: The connection.
##
## .. zeek:see:: connection_EOF connection_SYN_packet connection_attempt
##    connection_established connection_finished
##    connection_first_ACK connection_half_finished connection_partial_close
##    connection_rejected connection_reset connection_reused connection_state_remove
##    connection_status_update connection_timeout scheduled_analyzer_applied
##    new_connection new_connection_contents partial_connection zeek_done
global connection_pending: event(c: connection );


## Generated for a SYN packet. Zeek raises this event for every SYN packet seen
## by its TCP analyzer. This includes packets that have other flags set - like
## in the case of SYN-ACK packets.
##
## c: The connection.
##
## pkt: Information extracted from the SYN packet.
##
## .. zeek:see:: connection_EOF  connection_attempt connection_established
##    connection_finished connection_first_ACK
##    connection_half_finished connection_partial_close connection_pending
##    connection_rejected connection_reset connection_reused connection_state_remove
##    connection_status_update connection_timeout scheduled_analyzer_applied
##    new_connection new_connection_contents partial_connection
##
## .. note::
##
##    This event has quite low-level semantics and can potentially be expensive
##    to generate. It should only be used if one really needs the specific
##    information passed into the handler via the ``pkt`` argument. If not,
##    handling one of the other ``connection_*`` events is typically the
##    better approach.
global connection_SYN_packet: event(c: connection , pkt: SYN_packet );


## Generated for the first ACK packet seen for a TCP connection from
## its *originator*.
##
## c: The connection.
##
## .. zeek:see:: connection_EOF connection_SYN_packet connection_attempt
##    connection_established connection_finished
##    connection_half_finished connection_partial_close connection_pending
##    connection_rejected connection_reset connection_reused connection_state_remove
##    connection_status_update connection_timeout scheduled_analyzer_applied
##    new_connection new_connection_contents partial_connection
##
## .. note::
##
##    This event has quite low-level semantics and should be used only rarely.
global connection_first_ACK: event(c: connection );


## Generated at the end of reassembled TCP connections. The TCP reassembler
## raised the event once for each endpoint of a connection when it finished
## reassembling the corresponding side of the communication.
##
## c: The connection.
##
## is_orig: True if the event is raised for the originator side.
##
## .. zeek:see::  connection_SYN_packet connection_attempt connection_established
##    connection_finished connection_first_ACK
##    connection_half_finished connection_partial_close connection_pending
##    connection_rejected connection_reset connection_reused connection_state_remove
##    connection_status_update connection_timeout scheduled_analyzer_applied
##    new_connection new_connection_contents partial_connection
global connection_EOF: event(c: connection , is_orig: bool );


## Generated for every TCP packet. This is a very low-level and expensive event
## that should be avoided when at all possible. It's usually infeasible to
## handle when processing even medium volumes of traffic in real-time.  It's
## slightly better than :zeek:id:`new_packet` because it affects only TCP, but
## not much. That said, if you work from a trace and want to do some
## packet-level analysis, it may come in handy.
##
## c: The connection the packet is part of.
##
## is_orig: True if the packet was sent by the connection's originator.
##
## flags: A string with the packet's TCP flags. In the string, each character
##        corresponds to one set flag, as follows: ``S`` -> SYN; ``F`` -> FIN;
##        ``R`` -> RST; ``A`` -> ACK; ``P`` -> PUSH; ``U`` -> URGENT.
##
## seq: The packet's relative TCP sequence number.
##
## ack: If the ACK flag is set for the packet, the packet's relative ACK
##      number, else zero.
##
## len: The length of the TCP payload, as specified in the packet header.
##
## payload: The raw TCP payload. Note that this may be shorter than *len* if
##          the packet was not fully captured.
##
## .. zeek:see:: new_packet packet_contents tcp_option tcp_contents tcp_rexmit
global tcp_packet: event(c: connection , is_orig: bool , flags: string , seq: count , ack: count , len: count , payload: string );


## Generated for each option found in a TCP header. Like many of the ``tcp_*``
## events, this is a very low-level event and potentially expensive as it may
## be raised very often.
##
## c: The connection the packet is part of.
##
## is_orig: True if the packet was sent by the connection's originator.
##
## opt: The numerical option number, as found in the TCP header.
##
## optlen: The length of the options value.
##
## .. zeek:see:: tcp_packet tcp_contents tcp_rexmit tcp_options
##
## .. note:: To inspect the actual option values, if any, use :zeek:see:`tcp_options`.
global tcp_option: event(c: connection , is_orig: bool , opt: count , optlen: count );


## Generated for each TCP header that contains TCP options.  This is a very
## low-level event and potentially expensive as it may be raised very often.
##
## c: The connection the packet is part of.
##
## is_orig: True if the packet was sent by the connection's originator.
##
## options: The list of options parsed out of the TCP header.
##
## .. zeek:see:: tcp_packet tcp_contents tcp_rexmit tcp_option
global tcp_options: event(c: connection , is_orig: bool , options: TCP::OptionList );


## Generated for each chunk of reassembled TCP payload. When content delivery is
## enabled for a TCP connection (via :zeek:id:`tcp_content_delivery_ports_orig`,
## :zeek:id:`tcp_content_delivery_ports_resp`,
## :zeek:id:`tcp_content_deliver_all_orig`,
## :zeek:id:`tcp_content_deliver_all_resp`), this event is raised for each chunk
## of in-order payload reconstructed from the packet stream. Note that this
## event is potentially expensive if many connections carry significant amounts
## of data as then all that data needs to be passed on to the scripting layer.
##
## c: The connection the payload is part of.
##
## is_orig: True if the packet was sent by the connection's originator.
##
## seq: The sequence number corresponding to the first byte of the payload
##      chunk.
##
## contents: The raw payload, which will be non-empty.
##
## .. zeek:see:: tcp_packet tcp_option tcp_rexmit
##    tcp_content_delivery_ports_orig tcp_content_delivery_ports_resp
##    tcp_content_deliver_all_resp tcp_content_deliver_all_orig
##
## .. note::
##
##    The payload received by this event is the same that is also passed into
##    application-layer protocol analyzers internally. Subsequent invocations of
##    this event for the same connection receive non-overlapping in-order chunks
##    of its TCP payload stream. It is however undefined what size each chunk
##    has; while Zeek passes the data on as soon as possible, specifics depend on
##    network-level effects such as latency, acknowledgements, reordering, etc.
global tcp_contents: event(c: connection , is_orig: bool , seq: count , contents: string );


## Generated for each detected TCP segment retransmission.
##
## c: The connection the packet is part of.
##
## is_orig: True if the packet was sent by the connection's originator.
##
## seq: The segment's relative TCP sequence number.
##
## len: The length of the TCP segment, as specified in the packet header.
##
## data_in_flight: The number of bytes corresponding to the difference between
##                 the last sequence number and last acknowledgement number
##                 we've seen for a given endpoint.
##
## window: the TCP window size.
global tcp_rexmit: event(c: connection , is_orig: bool , seq: count , len: count , data_in_flight: count , window: count );


## Generated if a TCP flow crosses a checksum-error threshold, per
## 'C'/'c' history reporting.
##
## c: The connection record for the TCP connection.
##
## is_orig: True if the event is raised for the originator side.
##
## threshold: the threshold that was crossed
##
## .. zeek:see::  udp_multiple_checksum_errors
##    tcp_multiple_zero_windows tcp_multiple_retransmissions tcp_multiple_gap
global tcp_multiple_checksum_errors: event(c: connection , is_orig: bool , threshold: count );


## Generated if a TCP flow crosses a zero-window threshold, per
## 'W'/'w' history reporting.
##
## c: The connection record for the TCP connection.
##
## is_orig: True if the event is raised for the originator side.
##
## threshold: the threshold that was crossed
##
## .. zeek:see::  tcp_multiple_checksum_errors tcp_multiple_retransmissions tcp_multiple_gap
global tcp_multiple_zero_windows: event(c: connection , is_orig: bool , threshold: count );


## Generated if a TCP flow crosses a retransmission threshold, per
## 'T'/'t' history reporting.
##
## c: The connection record for the TCP connection.
##
## is_orig: True if the event is raised for the originator side.
##
## threshold: the threshold that was crossed
##
## .. zeek:see::  tcp_multiple_checksum_errors tcp_multiple_zero_windows tcp_multiple_gap
global tcp_multiple_retransmissions: event(c: connection , is_orig: bool , threshold: count );


## Generated if a TCP flow crosses a gap threshold, per 'G'/'g' history
## reporting.
##
## c: The connection record for the TCP connection.
##
## is_orig: True if the event is raised for the originator side.
##
## threshold: the threshold that was crossed
##
## .. zeek:see::  tcp_multiple_checksum_errors tcp_multiple_zero_windows tcp_multiple_retransmissions
global tcp_multiple_gap: event(c: connection , is_orig: bool , threshold: count );


## Generated when failing to write contents of a TCP stream to a file.
##
## c: The connection whose contents are being recorded.
##
## is_orig: Which side of the connection encountered a failure to write.
##
## msg: A reason or description for the failure.
##
## .. zeek:see:: set_contents_file get_contents_file
global contents_file_write_failure: event(c: connection , is_orig: bool , msg: string );

} # end of export section
module GLOBAL;
