/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.cfg.context;

import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collections;
import org.hibernate.validator.cfg.ConstraintDef;
import org.hibernate.validator.cfg.context.ConstructorConstraintMappingContext;
import org.hibernate.validator.cfg.context.MethodConstraintMappingContext;
import org.hibernate.validator.cfg.context.PropertyConstraintMappingContext;
import org.hibernate.validator.internal.cfg.context.CascadableConstraintMappingContextImplBase;
import org.hibernate.validator.internal.cfg.context.ConfiguredConstraint;
import org.hibernate.validator.internal.cfg.context.TypeConstraintMappingContextImpl;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.metadata.raw.ConfigurationSource;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.metadata.raw.ConstrainedExecutable;
import org.hibernate.validator.internal.metadata.raw.ConstrainedField;
import org.hibernate.validator.internal.metadata.raw.ExecutableElement;

final class PropertyConstraintMappingContextImpl
extends CascadableConstraintMappingContextImplBase<PropertyConstraintMappingContext>
implements PropertyConstraintMappingContext {
    private final TypeConstraintMappingContextImpl<?> typeContext;
    private final Member member;

    PropertyConstraintMappingContextImpl(TypeConstraintMappingContextImpl<?> typeContext, Member member) {
        super(typeContext.getConstraintMapping());
        this.typeContext = typeContext;
        this.member = member;
    }

    @Override
    protected PropertyConstraintMappingContextImpl getThis() {
        return this;
    }

    @Override
    public PropertyConstraintMappingContext constraint(ConstraintDef<?, ?> definition) {
        if (this.member instanceof Field) {
            super.addConstraint(ConfiguredConstraint.forProperty(definition, this.member));
        } else {
            super.addConstraint(ConfiguredConstraint.forExecutable(definition, ExecutableElement.forMethod((Method)this.member)));
        }
        return this;
    }

    @Override
    public PropertyConstraintMappingContext ignoreAnnotations() {
        return this.ignoreAnnotations(true);
    }

    @Override
    public PropertyConstraintMappingContext ignoreAnnotations(boolean ignoreAnnotations) {
        this.mapping.getAnnotationProcessingOptions().ignoreConstraintAnnotationsOnMember(this.member, ignoreAnnotations);
        return this;
    }

    @Override
    public PropertyConstraintMappingContext property(String property, ElementType elementType) {
        return this.typeContext.property(property, elementType);
    }

    @Override
    public ConstructorConstraintMappingContext constructor(Class<?> ... parameterTypes) {
        return this.typeContext.constructor(parameterTypes);
    }

    @Override
    public MethodConstraintMappingContext method(String name, Class<?> ... parameterTypes) {
        return this.typeContext.method(name, parameterTypes);
    }

    ConstrainedElement build(ConstraintHelper constraintHelper) {
        if (this.member instanceof Field) {
            return new ConstrainedField(ConfigurationSource.API, ConstraintLocation.forProperty(this.member), this.getConstraints(constraintHelper), Collections.<MetaConstraint<?>>emptySet(), this.groupConversions, this.isCascading, this.unwrapMode());
        }
        return new ConstrainedExecutable(ConfigurationSource.API, ConstraintLocation.forProperty(this.member), this.getConstraints(constraintHelper), this.groupConversions, this.isCascading, this.unwrapMode());
    }

    @Override
    protected ConstraintDescriptorImpl.ConstraintType getConstraintType() {
        return ConstraintDescriptorImpl.ConstraintType.GENERIC;
    }
}

