/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.config;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.zanata.client.config.CommandHook;
import org.zanata.client.config.FileMappingRule;
import org.zanata.client.config.LocaleList;
import org.zanata.client.config.LocaleMapping;

@XmlType(name="configType", propOrder={"url", "project", "projectVersion", "projectType", "srcDir", "transDir", "includes", "excludes", "hooks", "locales", "rules"})
@XmlRootElement(name="config")
public class ZanataConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private LocaleList locales = new LocaleList();
    private String project;
    private URL url;
    private String projectType;
    private String projectVersion;
    private String srcDir = ".";
    private String transDir = ".";
    private String includes;
    private String excludes;
    private List<CommandHook> hooks = new ArrayList<CommandHook>();
    private transient Splitter splitter = Splitter.on((String)",").omitEmptyStrings().trimResults();
    private List<FileMappingRule> rules = new ArrayList<FileMappingRule>();

    @XmlElementWrapper(name="locales", required=false)
    @XmlElementRef(type=LocaleMapping.class, name="locale")
    public LocaleList getLocales() {
        return this.locales;
    }

    public void setLocales(LocaleList locales) {
        this.locales = locales;
    }

    @XmlElementWrapper(name="hooks", required=false)
    @XmlElement(name="hook")
    public List<CommandHook> getHooks() {
        return this.hooks;
    }

    public void setHooks(List<CommandHook> commandHooks) {
        this.hooks = commandHooks;
    }

    @XmlElement(name="project")
    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    @XmlElement(name="url")
    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    @XmlElement(name="project-type")
    public String getProjectType() {
        return this.projectType;
    }

    public void setProjectType(String type) {
        this.projectType = type;
    }

    @XmlElement(name="project-version")
    public String getProjectVersion() {
        return this.projectVersion;
    }

    public void setProjectVersion(String version) {
        this.projectVersion = version;
    }

    @XmlElement(name="src-dir")
    public String getSrcDir() {
        return this.srcDir;
    }

    public void setSrcDir(String srcDir) {
        this.srcDir = srcDir;
    }

    @XmlElement(name="trans-dir")
    public String getTransDir() {
        return this.transDir;
    }

    public void setTransDir(String transDir) {
        this.transDir = transDir;
    }

    @XmlElement
    public String getIncludes() {
        return this.includes;
    }

    public void setIncludes(String includes) {
        this.includes = includes;
    }

    @XmlElement
    public String getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    @XmlTransient
    public File getSrcDirAsFile() {
        return new File(this.srcDir);
    }

    @XmlTransient
    public File getTransDirAsFile() {
        return new File(this.transDir);
    }

    @XmlTransient
    public ImmutableList<String> getIncludesAsList() {
        if (this.includes != null) {
            return ImmutableList.copyOf((Iterable)this.splitter.split((CharSequence)this.includes));
        }
        return ImmutableList.of();
    }

    @XmlTransient
    public ImmutableList<String> getExcludesAsList() {
        if (this.excludes != null) {
            return ImmutableList.copyOf((Iterable)this.splitter.split((CharSequence)this.excludes));
        }
        return ImmutableList.of();
    }

    @XmlElementWrapper(name="rules", required=false)
    @XmlElement(name="rule")
    public List<FileMappingRule> getRules() {
        return this.rules;
    }

    public void setRules(List<FileMappingRule> rules) {
        this.rules = rules;
    }
}

