/*
 * Decompiled with CFR 0.152.
 */
package org.fedorahosted.tennera.jgettext.catalog.parse;

import antlr.CommonToken;
import antlr.StringUtils;
import antlr.Token;
import antlr.TokenStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fedorahosted.tennera.jgettext.catalog.parse.CatalogTokenTypes;
import org.fedorahosted.tennera.jgettext.catalog.parse.ParseException;
import org.fedorahosted.tennera.jgettext.catalog.parse.UnexpectedTokenException;
import org.fedorahosted.tennera.jgettext.catalog.util.StringUtil;

public class CatalogLexer
implements TokenStream,
CatalogTokenTypes {
    private final Tokenizer tokenizer;

    public CatalogLexer(File file) throws FileNotFoundException, IOException {
        this.tokenizer = new Tokenizer(file);
    }

    public CatalogLexer(Reader reader) {
        this.tokenizer = new Tokenizer(reader);
    }

    public CatalogLexer(InputStream inputStream) throws IOException {
        this.tokenizer = new Tokenizer(inputStream);
    }

    public CatalogLexer(InputStream inputStream, Charset charset) {
        this.tokenizer = new Tokenizer(inputStream, charset);
    }

    public Token nextToken() {
        if (!this.tokenizer.hasNext()) {
            return new CommonToken(1, "<eof>");
        }
        return this.tokenizer.next();
    }

    static String readGettextCharset(InputStream markableStream) throws IOException, UnsupportedEncodingException {
        String charset = "UTF-8";
        int limit = 4096;
        markableStream.mark(limit);
        byte[] buf = new byte[limit];
        int count = markableStream.read(buf);
        markableStream.reset();
        if (count < 0) {
            throw new RuntimeException();
        }
        String s = new String(buf, 0, count, "ASCII");
        Pattern pat = Pattern.compile("\"Content-Type:.*charset=([^ \t\\\\]*)[ \t\\\\]");
        Matcher matcher = pat.matcher(s);
        if (matcher.find()) {
            charset = matcher.group(1);
        } else {
            pat = Pattern.compile("charset=([^ \t\\\\]*)[ \t\\\\]");
            if (matcher.find()) {
                charset = matcher.group(1);
            }
        }
        if (charset.equals("CHARSET")) {
            charset = "ASCII";
        }
        return charset;
    }

    private static abstract class EntryCollector {
        private final StringBuilder buffer = new StringBuilder();
        private boolean previous;

        private EntryCollector() {
        }

        public void collect(String entry) {
            this.buffer.append(entry);
        }

        protected abstract void wrapUp(String var1, boolean var2);

        public void wrapUp() {
            this.wrapUp(this.buffer.toString(), this.previous);
        }
    }

    private static class Tokenizer
    implements Iterator<antlr.Token> {
        public static final String DOMAIN_TXT = "domain";
        public static final String MSGCTXT_TXT = "msgctxt";
        public static final String MSGID_TXT = "msgid";
        public static final String MSGID_PLURAL_TXT = "msgid_plural";
        public static final String MSGSTR_TXT = "msgstr";
        public static final String MSGSTR_PLURAL_TXT = "msgstr[";
        private boolean eof = false;
        private final Queue<antlr.Token> tokenQueue = new LinkedList<antlr.Token>();
        private final LineNumberReader ioReader;
        private final String filename;
        private int column;
        private EntryCollector entryCollector;

        public Tokenizer(File file) throws FileNotFoundException, IOException {
            this(file.getName(), Tokenizer.lineNumberReaderForCharset(new FileInputStream(file)));
        }

        public Tokenizer(String filename, LineNumberReader ioReader) {
            this.filename = filename;
            this.ioReader = ioReader;
        }

        public Tokenizer(Reader reader) {
            this.ioReader = reader instanceof LineNumberReader ? (LineNumberReader)reader : new LineNumberReader(reader);
            this.filename = null;
        }

        public Tokenizer(InputStream inputStream) throws IOException {
            this(Tokenizer.lineNumberReaderForCharset(inputStream));
        }

        public Tokenizer(InputStream inputStream, Charset charset) {
            this(new LineNumberReader(new InputStreamReader(inputStream, charset)));
        }

        private static LineNumberReader lineNumberReaderForCharset(InputStream inputStream) throws IOException {
            InputStream markableStream;
            if (inputStream.markSupported()) {
                markableStream = inputStream;
            } else {
                markableStream = new BufferedInputStream(inputStream);
                assert (markableStream.markSupported());
            }
            String charset = CatalogLexer.readGettextCharset(markableStream);
            return new LineNumberReader(new InputStreamReader(markableStream, charset));
        }

        @Override
        public boolean hasNext() {
            if (!this.eof && this.tokenQueue.isEmpty()) {
                this.readToken();
            }
            return !this.tokenQueue.isEmpty();
        }

        private void readToken() {
            try {
                while (!this.eof && this.tokenQueue.isEmpty()) {
                    String line = this.readLine();
                    if (line != null) {
                        this.resetColumn();
                        this.processLine(line);
                        continue;
                    }
                    this.eof = true;
                    this.wrapUpandResetEntryCollector();
                    this.ioReader.close();
                }
            }
            catch (IOException e) {
                try {
                    this.ioReader.close();
                }
                catch (IOException e2) {
                    throw new ParseException(e2.getMessage(), e2, this.lineNumber());
                }
                throw new ParseException(e.getMessage(), e, this.lineNumber());
            }
        }

        private void wrapUpandResetEntryCollector() {
            if (this.entryCollector != null) {
                this.entryCollector.wrapUp();
                this.entryCollector = null;
            }
        }

        @Override
        public antlr.Token next() {
            if (this.hasNext()) {
                return this.tokenQueue.remove();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void addToken(Token token) {
            this.tokenQueue.add((antlr.Token)token);
        }

        private void resetColumn() {
            this.column = -1;
        }

        private String readLine() {
            try {
                String line = this.ioReader.readLine();
                return line;
            }
            catch (IOException e) {
                throw new ParseException("unable to read line", e, this.lineNumber());
            }
        }

        private int lineNumber() {
            return this.ioReader.getLineNumber();
        }

        private void processLine(String line) {
            if ((line = StringUtils.stripFront((String)line, (String)" \t")).length() == 0) {
                return;
            }
            if ('\"' == line.charAt(0)) {
                this.processContinuation(line);
                return;
            }
            if ('#' == line.charAt(0)) {
                this.processComment(line);
            } else {
                this.processEntry(line);
            }
        }

        private String stripFirstSpace(String str) {
            if (str.length() == 0) {
                return str;
            }
            if (str.charAt(0) == ' ') {
                return str.substring(1);
            }
            return str;
        }

        private void processComment(String line) {
            if (line.length() == 1) {
                this.processCatalogComment("");
                return;
            }
            switch (line.charAt(1)) {
                case ',': {
                    this.processFlag(line.substring(2));
                    break;
                }
                case ':': {
                    this.processReference(line.substring(2).trim());
                    break;
                }
                case '.': {
                    this.processExtractedComment(this.stripFirstSpace(line.substring(2)));
                    break;
                }
                case '|': {
                    this.processPreviousEntry(this.stripFirstSpace(line.substring(2)));
                    break;
                }
                case '~': {
                    this.processObsolete(this.stripFirstSpace(line.substring(2)));
                    break;
                }
                default: {
                    this.processCatalogComment(this.stripFirstSpace(line.substring(1)));
                }
            }
        }

        private void processFlag(String flag) {
            this.wrapUpandResetEntryCollector();
            this.addToken(new Token(7, flag));
        }

        private void processReference(String sourceRef) {
            this.wrapUpandResetEntryCollector();
            this.addToken(new Token(6, sourceRef));
        }

        private void processPreviousEntry(String entry) {
            this.processLine(entry);
            this.entryCollector.previous = true;
        }

        private void processObsolete(String entry) {
            if ((entry = entry.trim()).length() == 0) {
                return;
            }
            if ('\"' == entry.charAt(0)) {
                this.processContinuation(entry);
                return;
            }
            if ('|' == entry.charAt(0)) {
                this.processPreviousEntry(this.stripFirstSpace(entry.substring(2)));
                return;
            }
            this.wrapUpandResetEntryCollector();
            this.addToken(new Token(17, "<obsolete>"));
            this.processEntry(entry);
        }

        private void processExtractedComment(String comment) {
            this.wrapUpandResetEntryCollector();
            this.addToken(new Token(5, comment));
        }

        private void processCatalogComment(String comment) {
            this.wrapUpandResetEntryCollector();
            this.addToken(new Token(4, comment));
        }

        private void processContinuation(String line) {
            if (this.entryCollector == null) {
                throw new ParseException("expecting continuation context", this.lineNumber());
            }
            this.entryCollector.collect(this.interpretString(line));
        }

        private void processEntry(String line) {
            this.wrapUpandResetEntryCollector();
            if (line.startsWith(DOMAIN_TXT)) {
                this.processDomain(this.interpretString(line.substring(DOMAIN_TXT.length())));
            } else if (line.startsWith(MSGCTXT_TXT)) {
                this.processMessageContext(this.interpretString(line.substring(MSGCTXT_TXT.length())));
            } else if (line.startsWith(MSGID_PLURAL_TXT)) {
                this.processMsgidPlural(this.interpretString(line.substring(MSGID_PLURAL_TXT.length())));
            } else if (line.startsWith(MSGSTR_PLURAL_TXT)) {
                int pos = line.indexOf(93);
                String n = line.substring(MSGSTR_PLURAL_TXT.length(), pos);
                this.processTranslationPlural(Integer.parseInt(n), this.interpretString(line.substring(pos + 1)));
            } else if (line.startsWith(MSGSTR_TXT)) {
                this.processTranslation(this.interpretString(line.substring(MSGSTR_TXT.length())));
            } else if (line.startsWith(MSGID_TXT)) {
                this.processMsgid(this.interpretString(line.substring(MSGID_TXT.length())));
            } else {
                throw new UnexpectedTokenException("unrecognized entry directive [" + line + "]", this.lineNumber());
            }
        }

        private void processDomain(String domain) {
            this.addToken(new Token(8, domain));
        }

        private void processMessageContext(String msgctxt) {
            this.newEntryCollection(new MsgctxtCollector(msgctxt));
        }

        private void processMsgid(String msgid) {
            this.newEntryCollection(new MsgidCollector(msgid));
        }

        private void processMsgidPlural(String msgidPlural) {
            this.newEntryCollection(new MsgidPluralCollector(msgidPlural));
        }

        private void processTranslationPlural(int n, String translation) {
            this.newEntryCollection(new MsgstrPluralCollector(n, translation));
        }

        private void processTranslation(String translation) {
            this.newEntryCollection(new MsgstrCollector(translation));
        }

        private void newEntryCollection(EntryCollector entryCollector) {
            if (this.entryCollector != null) {
                throw new ParseException("illegal state; continuation collector encountered on new collectible entry start", this.lineNumber());
            }
            this.entryCollector = entryCollector;
        }

        private String interpretString(String quotedString) {
            if ((quotedString = quotedString.trim()).charAt(0) != '\"') {
                throw new UnexpectedTokenException("missing start-quote", this.lineNumber());
            }
            if (quotedString.charAt(quotedString.length() - 1) != '\"') {
                throw new UnexpectedTokenException("missing end-quote", this.lineNumber());
            }
            quotedString = quotedString.substring(1, quotedString.length() - 1);
            try {
                return StringUtil.removeEscapes(quotedString);
            }
            catch (UnexpectedTokenException e) {
                throw new UnexpectedTokenException(e.getMessage(), this.lineNumber());
            }
        }

        private class MsgstrPluralCollector
        extends EntryCollector {
            private final int n;

            private MsgstrPluralCollector(int n, String initial) {
                this.n = n;
                this.collect(initial);
            }

            @Override
            protected void wrapUp(String entry, boolean isPrevious) {
                if (isPrevious) {
                    throw new ParseException("translation does not allow previous entry according to PO schematic", Tokenizer.this.lineNumber());
                }
                Tokenizer.this.addToken(new Token(13, entry));
                Tokenizer.this.addToken(new Token(18, Integer.toString(this.n)));
            }
        }

        private class MsgstrCollector
        extends EntryCollector {
            private MsgstrCollector(String initial) {
                this.collect(initial);
            }

            @Override
            protected void wrapUp(String entry, boolean isPrevious) {
                if (isPrevious) {
                    throw new ParseException("translation does not allow previous entry according to PO schematic", Tokenizer.this.lineNumber());
                }
                Tokenizer.this.addToken(new Token(12, entry));
            }
        }

        private class MsgidPluralCollector
        extends EntryCollector {
            private MsgidPluralCollector(String initial) {
                this.collect(initial);
            }

            @Override
            protected void wrapUp(String entry, boolean isPrevious) {
                if (isPrevious) {
                    Tokenizer.this.addToken(new Token(16, entry));
                } else {
                    Tokenizer.this.addToken(new Token(11, entry));
                }
            }
        }

        private class MsgidCollector
        extends EntryCollector {
            private MsgidCollector(String initial) {
                this.collect(initial);
            }

            @Override
            protected void wrapUp(String entry, boolean isPrevious) {
                if (isPrevious) {
                    Tokenizer.this.addToken(new Token(15, entry));
                } else {
                    Tokenizer.this.addToken(new Token(10, entry));
                }
            }
        }

        private class MsgctxtCollector
        extends EntryCollector {
            private MsgctxtCollector(String initial) {
                this.collect(initial);
            }

            @Override
            protected void wrapUp(String entry, boolean isPrevious) {
                if (isPrevious) {
                    Tokenizer.this.addToken(new Token(14, entry));
                } else {
                    Tokenizer.this.addToken(new Token(9, entry));
                }
            }
        }

        private class Token
        extends CommonToken {
            private Token(int i, String s) {
                super(i, s);
                super.setFilename(Tokenizer.this.filename);
                super.setLine(Tokenizer.this.lineNumber());
                super.setColumn(Tokenizer.this.column);
            }
        }
    }
}

