/*
 * Decompiled with CFR 0.152.
 */
package org.fedorahosted.tennera.jgettext;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import org.fedorahosted.tennera.jgettext.Catalog;
import org.fedorahosted.tennera.jgettext.HeaderUtil;
import org.fedorahosted.tennera.jgettext.Message;

public class PoWriter {
    private boolean generateHeader = false;
    private boolean wrap = true;
    private final boolean encodeTabs;

    public PoWriter(boolean encodeTabs) {
        this.encodeTabs = encodeTabs;
    }

    public PoWriter() {
        this(true);
    }

    public void setGenerateHeader(boolean generateHeader) {
        this.generateHeader = generateHeader;
    }

    public void write(Catalog catalog, File file) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        this.write(catalog, (Writer)writer);
    }

    public void write(Catalog catalog, Writer writer) throws IOException {
        Message header = catalog.locateHeader();
        boolean wroteHeader = false;
        if (header != null) {
            this.write(header, writer);
            wroteHeader = true;
        } else if (this.generateHeader) {
            this.write(HeaderUtil.generateDefaultHeader(), writer);
            wroteHeader = true;
        }
        boolean isFirst = true;
        for (Message message : catalog) {
            if (message.isHeader()) continue;
            if (isFirst) {
                isFirst = false;
                if (wroteHeader) {
                    writer.write(10);
                }
            } else {
                writer.write(10);
            }
            this.write(message, writer);
        }
    }

    public void write(Catalog catalog, OutputStream outputStream) throws IOException {
        this.write(catalog, outputStream, Charset.forName("UTF-8"));
    }

    public void write(Catalog catalog, OutputStream outputStream, Charset charset) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(outputStream), charset);
        this.write(catalog, (Writer)writer);
    }

    public void write(Message message, File file) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        this.write(message, (Writer)writer);
    }

    public void write(Message message, Writer writer) throws IOException {
        String string;
        for (String string2 : message.getComments()) {
            this.writeComment("# ", string2, writer);
        }
        for (String string3 : message.getExtractedComments()) {
            this.writeComment("#. ", string3, writer);
        }
        for (String string4 : message.getSourceReferences()) {
            this.writeComment("#: ", string4, writer);
        }
        Collection<String> formats = message.getFormats();
        if (!formats.isEmpty()) {
            writer.write("#");
            for (String format : formats) {
                writer.write(", ");
                writer.write(format);
            }
            writer.write(10);
        }
        if (message.getPrevMsgctx() != null) {
            this.writeMsgctxt("#| ", message.getPrevMsgctx(), writer);
        }
        if (message.getPrevMsgid() != null) {
            this.writeMsgid("#| ", message.getPrevMsgid(), writer);
        }
        if (message.getPrevMsgidPlural() != null) {
            this.writeMsgidPlural("#| ", message.getPrevMsgidPlural(), writer);
        }
        String string5 = string = message.isObsolete() ? "#~ " : "";
        if (message.getMsgctxt() != null) {
            this.writeMsgctxt(string, message.getMsgctxt(), writer);
        }
        if (message.isPlural()) {
            this.writeMsgid(string, message.getMsgid(), writer);
            this.writeMsgidPlural(string, message.getMsgidPlural(), writer);
            this.writeMsgstrPlurals(string, message.getMsgstrPlural(), writer);
        } else {
            this.writeMsgid(string, message.getMsgid(), writer);
            this.writeMsgstr(string, message.getMsgstr(), writer);
        }
        writer.flush();
    }

    public void write(Message message, OutputStream outputStream) throws IOException {
        this.write(message, outputStream, Charset.forName("UTF-8"));
    }

    public void write(Message message, OutputStream outputStream, Charset charset) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(outputStream), charset);
        this.write(message, (Writer)writer);
    }

    protected void writeComment(String prefix, String comment, Writer writer) throws IOException {
        String[] lines;
        for (String line : lines = comment.split("\n")) {
            writer.write(prefix);
            writer.write(line);
            writer.write(10);
        }
    }

    protected void writeString(String prefix, String s, Writer writer, int firstLineContextWidth, int colWidth, int indent) throws IOException {
        boolean firstline = true;
        writer.write(34);
        int firstLineEnd = s.indexOf(10);
        if (this.wrap && (firstLineEnd != -1 && firstLineEnd > colWidth - firstLineContextWidth - 4 || s.length() > colWidth - firstLineContextWidth - 4)) {
            firstline = false;
            writer.write(34);
            writer.write(10);
            if (prefix.isEmpty()) {
                writer.write(34);
            }
        }
        StringBuilder currentLine = new StringBuilder(100);
        int lastSpacePos = 0;
        for (int i = 0; i < s.length(); ++i) {
            char currentChar = s.charAt(i);
            switch (currentChar) {
                case '\n': {
                    currentLine.append('\\');
                    currentLine.append('n');
                    if (!this.wrap || i == s.length() - 1) break;
                    if (!prefix.isEmpty() && !firstline) {
                        writer.write(prefix);
                        writer.write(34);
                        writer.write(currentLine.toString());
                        writer.write(34);
                        writer.write(10);
                    }
                    if (!prefix.isEmpty() && firstline) {
                        writer.write(currentLine.toString());
                        writer.write(34);
                        writer.write(10);
                        firstline = false;
                    }
                    if (prefix.isEmpty()) {
                        writer.write(currentLine.toString());
                        writer.write(34);
                        writer.write(10);
                        writer.write(34);
                    }
                    lastSpacePos = 0;
                    currentLine.delete(0, currentLine.length());
                    break;
                }
                case '\\': {
                    currentLine.append(currentChar);
                    currentLine.append(currentChar);
                    break;
                }
                case '\r': {
                    currentLine.append('\\');
                    currentLine.append('r');
                    break;
                }
                case '\t': {
                    if (this.encodeTabs) {
                        currentLine.append('\\');
                        currentLine.append('t');
                        break;
                    }
                    currentLine.append(currentChar);
                    break;
                }
                case '\"': {
                    currentLine.append('\\');
                    currentLine.append(currentChar);
                    break;
                }
                case ' ': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case '=': {
                    lastSpacePos = currentLine.length();
                    currentLine.append(currentChar);
                    break;
                }
                default: {
                    currentLine.append(currentChar);
                }
            }
            if (!this.wrap || currentLine.length() <= colWidth - 4 || lastSpacePos == 0) continue;
            if (!prefix.isEmpty() && !firstline) {
                writer.write(prefix);
                writer.write(34);
                writer.write(currentLine.substring(0, lastSpacePos + 1));
                writer.write(34);
                writer.write(10);
            }
            if (!prefix.isEmpty() && firstline) {
                writer.write(currentLine.substring(0, lastSpacePos + 1));
                writer.write(34);
                writer.write(10);
                firstline = false;
            }
            if (prefix.isEmpty()) {
                writer.write(currentLine.substring(0, lastSpacePos + 1));
                writer.write(34);
                writer.write(10);
                writer.write(34);
            }
            currentLine.delete(0, lastSpacePos + 1);
            lastSpacePos = 0;
        }
        if (!prefix.isEmpty() && !firstline) {
            writer.write(prefix);
            writer.write(34);
            writer.write(currentLine.toString());
            writer.write(34);
            writer.write(10);
        }
        if (!prefix.isEmpty() && firstline) {
            writer.write(currentLine.toString());
            writer.write(34);
            writer.write(10);
            firstline = false;
        }
        if (prefix.isEmpty()) {
            writer.write(currentLine.toString());
            writer.write(34);
            writer.write(10);
        }
    }

    protected void writeString(String prefix, String s, Writer writer, int firstLineContextWidth) throws IOException {
        this.writeString(prefix, s, writer, firstLineContextWidth, 80, 0);
    }

    protected void writeMsgctxt(String prefix, String ctxt, Writer writer) throws IOException {
        String msgSpace = "msgctxt ";
        writer.write(prefix + msgSpace);
        this.writeString(prefix, ctxt, writer, msgSpace.length());
    }

    protected void writeMsgid(String prefix, String msgid, Writer writer) throws IOException {
        String msgSpace = "msgid ";
        writer.write(prefix + msgSpace);
        this.writeString(prefix, msgid, writer, msgSpace.length());
    }

    protected void writeMsgidPlural(String prefix, String msgidPlural, Writer writer) throws IOException {
        String msgSpace = "msgid_plural ";
        writer.write(prefix + msgSpace);
        this.writeString(prefix, msgidPlural, writer, msgSpace.length());
    }

    protected void writeMsgstr(String prefix, String msgstr, Writer writer) throws IOException {
        if (msgstr == null) {
            msgstr = "";
        }
        String msgSpace = "msgstr ";
        writer.write(prefix + msgSpace);
        this.writeString(prefix, msgstr, writer, msgSpace.length());
    }

    protected void writeMsgStrPlural(String prefix, String msgstr, int i, Writer writer) throws IOException {
        String msgSpace = "msgstr[" + i + "] ";
        writer.write(prefix + msgSpace);
        this.writeString(prefix, msgstr, writer, msgSpace.length());
    }

    protected void writeMsgstrPlurals(String prefix, List<String> msgstrPlurals, Writer writer) throws IOException {
        if (msgstrPlurals.isEmpty()) {
            this.writeMsgStrPlural(prefix, "", 0, writer);
        } else {
            int i = 0;
            for (String msgstr : msgstrPlurals) {
                this.writeMsgStrPlural(prefix, msgstr, i, writer);
                ++i;
            }
        }
    }
}

