(define (host) "i686-apple-darwin13.0.0")

(define (machine-vendor-os)
  (let ((match (regexp-search (rx (submatch (+ (~ #\-))) "-"
                                  (submatch (+ (~ #\-))) "-"
                                  (submatch (+ any)))
                              (host))))
    (list (match:substring match 1)
          (match:substring match 2)
          (match:substring match 3))))

(define (machine)
  (car (machine-vendor-os)))

(define (vendor)
  (cadr (machine-vendor-os)))

(define (os)
  (caddr (machine-vendor-os)))

(define (prefix) "/opt/local")

(define (exec-prefix) "/opt/local")

(define (bin-dir) "/opt/local/bin")

(define (lib-dir) "/opt/local/lib")

(define (include-dir) "/opt/local/include")

(define (man-dir) "/opt/local/share/man/man1")

(define (lib-dirs-list) (quote ("/opt/local/lib/scsh/modules" "/opt/local/lib/scsh/modules/0.6")))

(define (libs) "-ldl -lm ")

(define (defs) "-DHAVE_CONFIG_H")

(define (cflags) "-pipe -Os -arch i386")

(define (cppflags) "")

(define (ldflags) "-L/opt/local/lib -Wl,-headerpad_max_install_names -arch i386 -rdynamic")

(define (compiler-flags)
  (string-join (list "-I" (include-dir) (defs))))

(define (linker-flags)
  (string-join (list "-L" (lib-dir) (libs) "-lscsh") " "))

;;; Local Variables: 
;;; mode: Scheme
;;; End: 
