private rule architecture {
	meta:
		bits = 32
		endianness = "little"
		architecture = "x86"
	condition:
		true
}

rule function_362_0 {
	meta:
		name = "Succeeded"
		size = 9
	strings:
		$1 = { A9 00 00 00 80 0F 94 C0 C3 }
	condition:
		$1
}

rule function_363_0 {
	meta:
		name = "Failed"
		size = 9
	strings:
		$1 = { A9 00 00 00 80 0F 95 C0 C3 }
	condition:
		$1
}

rule function_364_0 {
	meta:
		name = "HResultCode"
		size = 6
		altNames = "ResultCode"
	strings:
		$1 = { 25 FF FF 00 00 C3 }
	condition:
		$1
}

rule function_365_0 {
	meta:
		name = "HResultFacility"
		size = 9
		altNames = "ResultFacility"
	strings:
		$1 = { C1 E8 10 25 FF 1F 00 00 C3 }
	condition:
		$1
}

rule function_366_0 {
	meta:
		name = "ResultSeverity"
		size = 4
	strings:
		$1 = { C1 E8 1F C3 }
	condition:
		$1
}

rule function_367_0 {
	meta:
		name = "MakeResult"
		size = 13
	strings:
		$1 = { C1 E0 1F C1 E2 10 0B C2 0B C8 8B C1 C3 }
	condition:
		$1
}

rule function_368_0 {
	meta:
		name = "LHashValOfName"
		size = 10
		refs = "0005 LHashValOfNameSys"
	strings:
		$1 = { 52 50 6A 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_369_0 {
	meta:
		name = "WHashValOfLHashVal"
		size = 5
	strings:
		$1 = { 66 25 FF FF C3 }
	condition:
		$1
}

rule function_370_0 {
	meta:
		name = "IsHashValCompatible"
		size = 17
	strings:
		$1 = { 25 00 00 FF 00 81 E2 00 00 FF 00 3B C2 0F 94 C0 C3 }
	condition:
		$1
}

rule function_374_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_3 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_13618_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_31 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_13000_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_13004_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_13020_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_13194_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_9 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_13492_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_31 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_13502_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_13505_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_13512_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_13574_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_31 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_12973_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_01 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_13642_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_13761_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_13835_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_14135_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_14179_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_14535_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_14546_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_12030_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_11214_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_11646_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_32 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_11666_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_11668_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_11932_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_6 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_11948_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_15074_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_6 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_12078_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_7 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_12249_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_12464_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_7 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_12563_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_12585_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_12750_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_81 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_12778_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_12853_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_6 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_12855_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_19443_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_02 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_17406_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_31 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_17696_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_32 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_17698_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_17777_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_6 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_17779_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_18755_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_18945_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_9 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_18970_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_18972_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_18985_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_8 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_19031_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_19035_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_17381_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_19616_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_19641_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_19719_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_19743_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_19825_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_19846_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_19848_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_22068_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_22256_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_16107_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_15228_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_15250_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_6 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_15269_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_15607_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_01 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_15609_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_15614_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_15775_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_71 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_15790_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_15898_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_21 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_16072_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_11102_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_16765_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_16911_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_41 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_16996_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_01 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_17235_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_81 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_17251_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_17260_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_4811_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_4813_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_4839_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_5646_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_21 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_5714_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_5745_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_6008_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_01 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_6070_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_6072_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_6491_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_22 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_4802_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_6798_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_9 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_6815_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_6926_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_6949_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_6957_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_7706_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_6 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_7741_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_7863_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_7865_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_7990_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_11 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_8203_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_1152_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_1186_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_1281_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_41 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_1292_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_8211_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_1433_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_2281_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_2285_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_3779_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_4630_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10494_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10502_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10515_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10529_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10620_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_31 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10631_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10755_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_9 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10769_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10822_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10374_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10856_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_7 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10860_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10908_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_6 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10910_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10957_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_81 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_11016_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_9 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_11041_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_8 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_11054_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_11062_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_11066_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_11085_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_11089_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10050_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_8218_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_8231_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_8343_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_51 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_8557_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_61 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_8671_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_8683_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_8690_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_8695_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_9875_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_9 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10026_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_438_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_7 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10054_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10182_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10270_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10368_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_32 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_375_0 {
	meta:
		name = "ActiveX"
		size = 8
		refs = "0002 _DV_3"
		altNames = "Exptintf ExtDlgs IdAntiFreezeBase IdDICTServer IdEMailAddress IdException IdFTP IdHTTP IdHTTPServer IdHostnameServer IdIMAP4Server IdIPWatch IdIntercept IdIrcServer IdLogDebug IdMappedPortTCP IdNetworkCalculator IdRawHeaders IdSSLIntercept ImgList MPlayer MidasCon NMFtp NMHTML NMMSG NMSTRM NMUDP NMsmtp Printers QRLablEd StdActns StdCtrls Tabnotbk TeePrevi TypInfo WinSpool isp3 mxpbar mxpivsrc mxqparse mxstore"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_439_0 {
	meta:
		name = "ActnList"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_816_0 {
	meta:
		name = "AxMaxMin"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_811_0 {
	meta:
		name = "AxisIncr"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_1282_0 {
	meta:
		name = "BISmtp"
		size = 8
		refs = "0002 _DV_41"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_1153_0 {
	meta:
		name = "Bde"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_1155_0 {
	meta:
		name = "BdeConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_1293_0 {
	meta:
		name = "BrushDlg"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_4819_0 {
	meta:
		name = "CPL"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_1434_0 {
	meta:
		name = "Calendar"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_2280_0 {
	meta:
		name = "ColorGrd"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_2282_0 {
	meta:
		name = "ComConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_2286_0 {
	meta:
		name = "ComCorba"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_3439_0 {
	meta:
		name = "ComCtrls"
		size = 8
		refs = "0002 _DV_15"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_3970_0 {
	meta:
		name = "ComStrs"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_3810_0 {
	meta:
		name = "CommDlg"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_3780_0 {
	meta:
		name = "Commctrl"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_3972_0 {
	meta:
		name = "Consts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_4631_0 {
	meta:
		name = "CopyPrsr"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_4814_0 {
	meta:
		name = "CorbCnst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_4654_0 {
	meta:
		name = "CorbaCon"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_4775_0 {
	meta:
		name = "CorbaRdm"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_4812_0 {
	meta:
		name = "CorbaVCL"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_5647_0 {
	meta:
		name = "DBActns"
		size = 8
		refs = "0002 _DV_21"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_5715_0 {
	meta:
		name = "DBCGrids"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_5746_0 {
	meta:
		name = "DBChart"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_6009_0 {
	meta:
		name = "DBClient"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_6071_0 {
	meta:
		name = "DBCommon"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_6799_0 {
	meta:
		name = "DBGrids"
		size = 8
		refs = "0002 _DV_9"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_6816_0 {
	meta:
		name = "DBLogDlg"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_6927_0 {
	meta:
		name = "DBLookup"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_6958_0 {
	meta:
		name = "DBPWDlg"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_7600_0 {
	meta:
		name = "DBWeb"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_7991_0 {
	meta:
		name = "DRTable"
		size = 8
		refs = "0002 _DV_11"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8210_0 {
	meta:
		name = "DSIntf"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8219_0 {
	meta:
		name = "DSProd"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_5621_0 {
	meta:
		name = "Db"
		size = 8
		refs = "0002 _DV_25"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_6073_0 {
	meta:
		name = "DbConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_6950_0 {
	meta:
		name = "DbOleCtl"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_6522_0 {
	meta:
		name = "Dbexcept"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_7742_0 {
	meta:
		name = "Ddeml"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_7864_0 {
	meta:
		name = "DirOutln"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_7866_0 {
	meta:
		name = "Dlgs"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8184_0 {
	meta:
		name = "DsgnIntf"
		size = 8
		refs = "0002 _DV_53"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8204_0 {
	meta:
		name = "DsgnWnds"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8212_0 {
	meta:
		name = "DsnDBCst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8232_0 {
	meta:
		name = "EditChar"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8344_0 {
	meta:
		name = "EditIntf"
		size = 8
		refs = "0002 _DV_51"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8558_0 {
	meta:
		name = "ExtCtrls"
		size = 8
		refs = "0002 _DV_61"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8672_0 {
	meta:
		name = "FileCtrl"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8684_0 {
	meta:
		name = "FileIntf"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_9178_0 {
	meta:
		name = "Gauges"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_9876_0 {
	meta:
		name = "Grids"
		size = 8
		refs = "0002 _DV_9"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10025_0 {
	meta:
		name = "HTTPApp"
		size = 8
		refs = "0002 _DV_02"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10027_0 {
	meta:
		name = "IBConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10051_0 {
	meta:
		name = "IBCtrls"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10057_0 {
	meta:
		name = "IBPROC32"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11667_0 {
	meta:
		name = "IStreams"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10055_0 {
	meta:
		name = "Ibevnts"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10060_0 {
	meta:
		name = "IdAntiFreeze"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10069_0 {
	meta:
		name = "IdBaseComponent"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10073_0 {
	meta:
		name = "IdChargenServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10271_0 {
	meta:
		name = "IdDayTime"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10275_0 {
	meta:
		name = "IdDayTimeServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10285_0 {
	meta:
		name = "IdDiscardServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10349_0 {
	meta:
		name = "IdEcho"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10353_0 {
	meta:
		name = "IdEchoServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10375_0 {
	meta:
		name = "IdFinger"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10379_0 {
	meta:
		name = "IdFingerServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10493_0 {
	meta:
		name = "IdGopher"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10495_0 {
	meta:
		name = "IdGopherConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10503_0 {
	meta:
		name = "IdGopherServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10516_0 {
	meta:
		name = "IdHeaderCoder"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10530_0 {
	meta:
		name = "IdHeaderList"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10632_0 {
	meta:
		name = "IdIcmpClient"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10705_0 {
	meta:
		name = "IdLogBase"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10770_0 {
	meta:
		name = "IdMessageClient"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10817_0 {
	meta:
		name = "IdRawBase"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10819_0 {
	meta:
		name = "IdRawClient"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10823_0 {
	meta:
		name = "IdResourceStrings"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10831_0 {
	meta:
		name = "IdSimpleServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10857_0 {
	meta:
		name = "IdSocketHandle"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10861_0 {
	meta:
		name = "IdSocks"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10909_0 {
	meta:
		name = "IdStack"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10911_0 {
	meta:
		name = "IdStackConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10958_0 {
	meta:
		name = "IdTCPClient"
		size = 8
		refs = "0002 _DV_81"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11017_0 {
	meta:
		name = "IdTCPConnection"
		size = 8
		refs = "0002 _DV_9"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11042_0 {
	meta:
		name = "IdTCPServer"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11055_0 {
	meta:
		name = "IdThread"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11063_0 {
	meta:
		name = "IdThreadMgr"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11067_0 {
	meta:
		name = "IdThreadMgrDefault"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11086_0 {
	meta:
		name = "IdUDPBase"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11090_0 {
	meta:
		name = "IdUDPClient"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11103_0 {
	meta:
		name = "IdURI"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11118_0 {
	meta:
		name = "IdWinsock"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11215_0 {
	meta:
		name = "Imagehlp"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11365_0 {
	meta:
		name = "Imm"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11415_0 {
	meta:
		name = "IniFiles"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11417_0 {
	meta:
		name = "Isapi"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11419_0 {
	meta:
		name = "Isapi2"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11849_0 {
	meta:
		name = "LZExpand"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11836_0 {
	meta:
		name = "LibHelp"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12079_0 {
	meta:
		name = "MConnect"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12465_0 {
	meta:
		name = "MMSystem"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12549_0 {
	meta:
		name = "MSrvr"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11865_0 {
	meta:
		name = "Mapi"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11933_0 {
	meta:
		name = "Mask"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11949_0 {
	meta:
		name = "Masks"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12031_0 {
	meta:
		name = "Math"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12250_0 {
	meta:
		name = "Messages"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12260_0 {
	meta:
		name = "MidConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12577_0 {
	meta:
		name = "MtsRdm"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12564_0 {
	meta:
		name = "Mtsobj"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12586_0 {
	meta:
		name = "Mtx"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13506_0 {
	meta:
		name = "NB30"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13508_0 {
	meta:
		name = "NMConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13513_0 {
	meta:
		name = "NMDayTim"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13518_0 {
	meta:
		name = "NMEcho"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13523_0 {
	meta:
		name = "NMExtstr"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13528_0 {
	meta:
		name = "NMFngr"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13643_0 {
	meta:
		name = "NMHttp"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13700_0 {
	meta:
		name = "NMNNTP"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13762_0 {
	meta:
		name = "NMTime"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13788_0 {
	meta:
		name = "NMURL"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13800_0 {
	meta:
		name = "NMUUE"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13723_0 {
	meta:
		name = "NMpop3"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13836_0 {
	meta:
		name = "NS30Fix"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14113_0 {
	meta:
		name = "NSApi"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14178_0 {
	meta:
		name = "OCXReg"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14919_0 {
	meta:
		name = "ORBPAS"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14136_0 {
	meta:
		name = "ObjBrkr"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14180_0 {
	meta:
		name = "OleConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14536_0 {
	meta:
		name = "OleCtrls"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14547_0 {
	meta:
		name = "OleDlg"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15075_0 {
	meta:
		name = "Outline"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15090_0 {
	meta:
		name = "PenDlg"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15229_0 {
	meta:
		name = "PenWin"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15251_0 {
	meta:
		name = "PicEdit"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15511_0 {
	meta:
		name = "Provider"
		size = 8
		refs = "0002 _DV_51"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15791_0 {
	meta:
		name = "QREnvEd"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15830_0 {
	meta:
		name = "QRExpbld"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15899_0 {
	meta:
		name = "QRExport"
		size = 8
		refs = "0002 _DV_21"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_16108_0 {
	meta:
		name = "QRPrev"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_16112_0 {
	meta:
		name = "QRPrgres"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15637_0 {
	meta:
		name = "Qrcomped"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15776_0 {
	meta:
		name = "Qrctrls"
		size = 8
		refs = "0002 _DV_71"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_16766_0 {
	meta:
		name = "RegStr"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_16764_0 {
	meta:
		name = "Registry"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_16768_0 {
	meta:
		name = "RichEdit"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_16997_0 {
	meta:
		name = "SConnect"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_17333_0 {
	meta:
		name = "SMIntf"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_16912_0 {
	meta:
		name = "ScktComp"
		size = 8
		refs = "0002 _DV_41"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_17306_0 {
	meta:
		name = "ShellAPI"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_17329_0 {
	meta:
		name = "ShlObj"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_17382_0 {
	meta:
		name = "Spin"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_17699_0 {
	meta:
		name = "StdVCL"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_17778_0 {
	meta:
		name = "SyncObjs"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_17780_0 {
	meta:
		name = "SysConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_17804_0 {
	meta:
		name = "SysInit"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_19642_0 {
	meta:
		name = "TLHelp32"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_18756_0 {
	meta:
		name = "Tabs"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_18946_0 {
	meta:
		name = "TeCanvas"
		size = 8
		refs = "0002 _DV_9"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_19623_0 {
	meta:
		name = "TeExport"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_18971_0 {
	meta:
		name = "TeeAbout"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_18986_0 {
	meta:
		name = "TeeFunci"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_19032_0 {
	meta:
		name = "TeeGally"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_19036_0 {
	meta:
		name = "TeeLisB"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_19720_0 {
	meta:
		name = "ToolIntf"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_19744_0 {
	meta:
		name = "ToolWin"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_19826_0 {
	meta:
		name = "UrlMon"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_19847_0 {
	meta:
		name = "VirtIntf"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_19849_0 {
	meta:
		name = "WebConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_22257_0 {
	meta:
		name = "WinInet"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_22320_0 {
	meta:
		name = "WinSock"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_22527_0 {
	meta:
		name = "WinSvc"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_22069_0 {
	meta:
		name = "Windows"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11669_0 {
	meta:
		name = "jconsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12856_0 {
	meta:
		name = "mxConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12974_0 {
	meta:
		name = "mxDB"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12779_0 {
	meta:
		name = "mxbutton"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12854_0 {
	meta:
		name = "mxcommon"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13001_0 {
	meta:
		name = "mxdcube"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13005_0 {
	meta:
		name = "mxdsql"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13021_0 {
	meta:
		name = "mxgraph"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13108_0 {
	meta:
		name = "mxgrid"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13195_0 {
	meta:
		name = "mxqedcom"
		size = 8
		refs = "0002 _DV_9"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13503_0 {
	meta:
		name = "mxtables"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15610_0 {
	meta:
		name = "qr3const"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15615_0 {
	meta:
		name = "qrabout"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_17331_0 {
	meta:
		name = "smconsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_18973_0 {
	meta:
		name = "teeconst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_376_0 {
	meta:
		name = "RegisterActions"
		size = 109
		refs = "000a RegisterActions 0016 RegisterActionsProc 002d SInvalidActionRegistration 0032 LoadResString 003c _Dn_Exception 0041 Exception.Create 0046 @RaiseExcept 005b @LStrClr 0061 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 33 DB 55 68 ?? ?? ?? ?? 64 FF 33 64 89 23 83 3D ?? ?? ?? ?? 00 74 0C 8B 5D 08 53 FF 15 ?? ?? ?? ?? EB 21 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_377_0 {
	meta:
		name = "UnRegisterActions"
		size = 101
		refs = "0009 UnRegisterActions 0015 UnRegisterActionsProc 0028 SInvalidActionUnregistration 002d LoadResString 0037 _Dn_Exception 003c Exception.Create 0041 @RaiseExcept 0056 @LStrClr 005c @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C9 55 68 ?? ?? ?? ?? 64 FF 31 64 89 21 83 3D ?? ?? ?? ?? 00 74 08 FF 15 ?? ?? ?? ?? EB 21 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_378_0 {
	meta:
		name = "EnumRegisteredActions"
		size = 109
		refs = "0009 EnumRegisteredActions 0015 EnumRegisteredActionsProc 002e SInvalidActionEnumeration 0033 LoadResString 003d _Dn_Exception 0042 Exception.Create 0047 @RaiseExcept 005c @LStrClr 0062 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 83 3D ?? ?? ?? ?? 00 74 0E FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? EB 21 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C2 08 00 }
	condition:
		$1
}

rule function_379_0 {
	meta:
		name = "CreateAction"
		size = 107
		refs = "000a CreateAction 0016 CreateActionProc 002b SInvalidActionCreation 0030 LoadResString 003a _Dn_Exception 003f Exception.Create 0044 @RaiseExcept 0059 @LStrClr 005f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 33 C9 55 68 ?? ?? ?? ?? 64 FF 31 64 89 21 83 3D ?? ?? ?? ?? 00 74 0A FF 15 ?? ?? ?? ?? 8B D8 EB 21 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 }
	condition:
		$1
}

rule function_380_0 {
	meta:
		name = "TContainedAction.Destroy"
		size = 51
		refs = "0003 @BeforeDestruction 0015 TCustomActionList.RemoveAction 0021 TBasicAction.Destroy 002c @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 44 85 C0 74 07 8B D6 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_381_0 {
	meta:
		name = "TContainedAction.GetIndex"
		size = 21
		refs = "000c TList.IndexOf"
	strings:
		$1 = { 8B 50 44 85 D2 74 0A 8B 52 24 92 E8 ?? ?? ?? ?? C3 83 C8 FF C3 }
	condition:
		$1
}

rule function_383_0 {
	meta:
		name = "TContainedAction.GetParentComponent"
		size = 16
		refs = "000b TComponent.GetParentComponent"
	strings:
		$1 = { 8B 50 44 85 D2 74 03 8B C2 C3 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_384_0 {
	meta:
		name = "TContainedAction.HasParent"
		size = 15
		refs = "000a TComponent.HasParent"
	strings:
		$1 = { 83 78 44 00 74 03 B0 01 C3 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_385_0 {
	meta:
		name = "TContainedAction.ReadState"
		size = 49
		refs = "000c TComponent.ReadState 0017 _DV_TCustomActionList 001c @IsClass 0029 TContainedAction.SetActionList"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 7E 28 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 09 8B D7 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2358_0 {
	meta:
		name = "TTabSheet.ReadState"
		size = 49
		refs = "000c TWinControl.ReadState 0017 _DV_TPageControl 001c @IsClass 0029 TTabSheet.SetPageControl"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 7E 28 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 09 8B D7 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_386_0 {
	meta:
		name = "TContainedAction.SetIndex"
		size = 71
		refs = "000a TContainedAction.GetIndex 0030 TList.Delete 003f TList.Insert"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 85 C0 7C 31 8B 53 44 8B 7A 24 8B 57 08 85 F6 7D 02 33 F6 3B D6 7F 03 8B F2 4E 3B C6 74 17 8B D7 92 E8 ?? ?? ?? ?? 8B 43 44 8B 40 24 8B CB 8B D6 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_387_0 {
	meta:
		name = "TContainedAction.SetCategory"
		size = 43
		refs = "000c @LStrCmp 0018 @LStrAsg"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 53 40 E8 ?? ?? ?? ?? 74 16 8D 43 40 8B D6 E8 ?? ?? ?? ?? 8B 43 44 85 C0 74 05 8B 10 FF 52 30 5E 5B C3 }
	condition:
		$1
}

rule function_388_0 {
	meta:
		name = "TContainedAction.SetActionList"
		size = 40
		refs = "0014 TCustomActionList.RemoveAction 0021 TCustomActionList.AddAction"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 43 44 3B F0 74 18 85 C0 74 07 8B D3 E8 ?? ?? ?? ?? 85 F6 74 09 8B D3 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_389_0 {
	meta:
		name = "TContainedAction.SetParentComponent"
		size = 41
		refs = "0010 _DV_TCustomActionList 0015 @IsClass 0022 TContainedAction.SetActionList"
	strings:
		$1 = { 53 56 8B F2 8B D8 F6 43 20 01 75 1A 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 09 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_390_0 {
	meta:
		name = "TContainedAction.Execute"
		size = 85
		refs = "0015 @CallDynaInst 001e Application 0027 TApplication.ExecuteAction 0032 TBasicAction.Execute 0044 SendAppMessage"
	strings:
		$1 = { 53 56 57 8B F0 8B 7E 44 85 FF 74 11 8B D6 8B C7 66 BB F4 FF E8 ?? ?? ?? ?? 84 C0 75 32 A1 ?? ?? ?? ?? 8B 00 8B D6 E8 ?? ?? ?? ?? 84 C0 75 20 8B C6 E8 ?? ?? ?? ?? 84 C0 75 15 8B CE 33 D2 B8 40 B0 00 00 E8 ?? ?? ?? ?? 48 74 04 33 C0 EB 02 B0 01 5F 5E 5B C3 }
	condition:
		$1
}

rule function_391_0 {
	meta:
		name = "TContainedAction.Update"
		size = 85
		refs = "0015 @CallDynaInst 001e Application 0027 TApplication.UpdateAction 0032 TBasicAction.Update 0044 SendAppMessage"
	strings:
		$1 = { 53 56 57 8B F0 8B 7E 44 85 FF 74 11 8B D6 8B C7 66 BB F1 FF E8 ?? ?? ?? ?? 84 C0 75 32 A1 ?? ?? ?? ?? 8B 00 8B D6 E8 ?? ?? ?? ?? 84 C0 75 20 8B C6 E8 ?? ?? ?? ?? 84 C0 75 15 8B CE 33 D2 B8 3F B0 00 00 E8 ?? ?? ?? ?? 48 74 04 33 C0 EB 02 B0 01 5F 5E 5B C3 }
	condition:
		$1
}

rule function_392_0 {
	meta:
		name = "TCustomActionList.Create"
		size = 104
		refs = "000e @ClassCreate 001c TComponent.Create 0023 _Dn_TList 0028 TObject.Create 0032 _Dn_TChangeLink 0046 TCustomActionList.ImageListChange 0053 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B D8 33 D2 8B C3 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 43 24 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 73 28 89 5E 0C C7 46 08 ?? ?? ?? ?? 8B C3 80 7D FF 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_393_0 {
	meta:
		name = "TCustomActionList.Destroy"
		size = 78
		refs = "0004 @BeforeDestruction 0010 TObject.Free 0019 TList.Last 003b TComponent.Destroy 0046 @ClassDestroy"
	strings:
		$1 = { 53 56 57 E8 ?? ?? ?? ?? 8B DA 8B F8 8B 47 28 E8 ?? ?? ?? ?? EB 0C 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 77 24 83 7E 08 00 7F EB 8B 47 24 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C7 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_394_0 {
	meta:
		name = "TCustomActionList.GetChildren"
		size = 72
		refs = "0028 TList.Get"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 89 55 F8 89 45 FC 8B 45 FC 8B 40 24 8B 58 08 4B 85 DB 7C 24 43 33 F6 8B 45 FC 8B 40 24 8B D6 E8 ?? ?? ?? ?? 8B 50 04 3B 55 F8 75 08 8B D0 8B 45 0C FF 55 08 46 4B 75 DF 5E 5B 59 59 5D C2 08 00 }
	condition:
		$1
}

rule function_395_0 {
	meta:
		name = "TCustomActionList.SetChildOrder"
		size = 47
		refs = "000f TList.IndexOf 001b _DV_TContainedAction 0020 @AsClass 0027 TContainedAction.SetIndex"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B 43 24 E8 ?? ?? ?? ?? 85 C0 7C 14 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_396_0 {
	meta:
		name = "TCustomActionList.GetAction"
		size = 19
		refs = "000c TList.Get"
		altNames = "TDatabase.GetDataSet"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 24 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_397_0 {
	meta:
		name = "TCustomActionList.GetActionCount"
		size = 7
		altNames = "TDatabase.GetDataSetCount"
	strings:
		$1 = { 8B 40 24 8B 40 08 C3 }
	condition:
		$1
}

rule function_398_0 {
	meta:
		name = "TCustomActionList.SetAction"
		size = 30
		refs = "000f TList.Get"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B 43 24 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_399_0 {
	meta:
		name = "TCustomActionList.SetImages"
		size = 51
		refs = "0011 TCustomImageList.UnRegisterChanges 0022 TCustomImageList.RegisterChanges 002c TComponent.FreeNotification"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 43 2C 85 C0 74 08 8B 53 28 E8 ?? ?? ?? ?? 8B C6 89 43 2C 85 C0 74 12 8B 53 28 E8 ?? ?? ?? ?? 8B D3 8B 43 2C E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_400_0 {
	meta:
		name = "TCustomActionList.ImageListChange"
		size = 11
	strings:
		$1 = { 3B 50 2C 75 05 8B 10 FF 52 30 C3 }
	condition:
		$1
}

rule function_401_0 {
	meta:
		name = "TCustomActionList.Notification"
		size = 71
		refs = "0010 TComponent.Notification 0023 TCustomActionList.SetImages 002d _DV_TContainedAction 0032 @IsClass 003f TCustomActionList.RemoveAction"
	strings:
		$1 = { 53 56 57 8B D9 8B FA 8B F0 8B CB 8B D7 8B C6 E8 ?? ?? ?? ?? 80 FB 01 75 2A 3B 7E 2C 75 0B 33 D2 8B C6 E8 ?? ?? ?? ?? EB 1A 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 09 8B D7 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_402_0 {
	meta:
		name = "TCustomActionList.AddAction"
		size = 31
		refs = "000c TList.Add 0018 TComponent.FreeNotification"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 24 E8 ?? ?? ?? ?? 89 5E 44 8B D3 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_403_0 {
	meta:
		name = "TCustomActionList.RemoveAction"
		size = 28
		refs = "000c TList.Remove"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 24 E8 ?? ?? ?? ?? 85 C0 7C 05 33 C0 89 46 44 5E 5B C3 }
	condition:
		$1
}

rule function_404_0 {
	meta:
		name = "TCustomActionList.Change"
		size = 103
		refs = "0028 TList.Get 0042 _Dn_TForm 0047 @IsClass"
	strings:
		$1 = { 53 56 57 8B D8 66 83 7B 32 00 74 08 8B D3 8B 43 34 FF 53 30 8B 43 24 8B 70 08 4E 85 F6 7C 16 46 33 FF 8B D7 8B 43 24 E8 ?? ?? ?? ?? 8B 10 FF 52 30 47 4E 75 ED F6 43 20 10 74 28 8B 73 04 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 14 83 BE 30 02 00 00 00 74 0B 8B 86 30 02 00 00 8B 10 FF 52 0C 5F 5E 5B C3 }
	condition:
		$1
}

rule function_405_0 {
	meta:
		name = "TCustomActionList.IsShortCut"
		size = 122
		refs = "000d KeyDataToShiftState 001a ShortCut 0034 TList.Get 0063 @CallDynaInst"
	strings:
		$1 = { 53 56 57 55 51 8B F2 8B F8 8B 46 08 E8 ?? ?? ?? ?? 8B D8 66 8B 46 04 8B D3 E8 ?? ?? ?? ?? 8B E8 8B 47 24 8B 70 08 4E 85 F6 7C 42 46 33 DB 8B 47 24 8B D3 E8 ?? ?? ?? ?? 66 3B 68 60 75 2B 8B 47 24 8B D3 E8 ?? ?? ?? ?? 8A 40 51 88 04 24 80 3C 24 00 74 1D 8B 47 24 8B D3 E8 ?? ?? ?? ?? 66 BB F0 FF E8 ?? ?? ?? ?? EB 08 43 4E 75 C1 C6 04 24 00 8A 04 24 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_406_0 {
	meta:
		name = "TCustomActionList.ExecuteAction"
		size = 29
	strings:
		$1 = { 53 51 C6 04 24 00 66 83 78 3A 00 74 0A 8B CC 8B D8 8B 43 3C FF 53 38 8A 04 24 5A 5B C3 }
	condition:
		$1
}

rule function_407_0 {
	meta:
		name = "TCustomActionList.UpdateAction"
		size = 29
	strings:
		$1 = { 53 51 C6 04 24 00 66 83 78 42 00 74 0A 8B CC 8B D8 8B 43 44 FF 53 40 8A 04 24 5A 5B C3 }
	condition:
		$1
}

rule function_408_0 {
	meta:
		name = "TActionLink.IsCaptionLinked"
		size = 19
		refs = "0008 _DV_TCustomAction 000d @IsClass"
		altNames = "TActionLink.IsCheckedLinked TActionLink.IsEnabledLinked TActionLink.IsHelpContextLinked TActionLink.IsHintLinked TActionLink.IsImageIndexLinked TActionLink.IsShortCutLinked TActionLink.IsVisibleLinked"
	strings:
		$1 = { 53 8B D8 8B 43 0C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_424_0 {
	meta:
		name = "TCustomAction.Create"
		size = 72
		refs = "000a @ClassCreate 0017 TBasicAction.Create 0035 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? C6 46 48 01 C6 46 51 01 C7 46 5C FF FF FF FF C6 46 62 01 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_425_0 {
	meta:
		name = "TCustomAction.Destroy"
		size = 53
		refs = "0003 @BeforeDestruction 000f TObject.Free 0023 TContainedAction.Destroy 002e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 6C E8 ?? ?? ?? ?? 8B 46 70 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_426_0 {
	meta:
		name = "TCustomAction.AssignTo"
		size = 122
		refs = "000b _DV_TCustomAction 0010 @IsClass 0020 TCustomAction.SetCaption 002a TCustomAction.SetChecked 0034 TCustomAction.SetEnabled 003e TCustomAction.SetHelpContext 0048 TCustomAction.SetHint 0052 TCustomAction.SetImageIndex 005d TCustomAction.SetShortCut 0067 TCustomAction.SetVisible 0072 TPersistent.AssignTo"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 55 8B 53 4C 8B FE 8B C7 E8 ?? ?? ?? ?? 8A 53 50 8B C7 E8 ?? ?? ?? ?? 8A 53 51 8B C7 E8 ?? ?? ?? ?? 8B 53 54 8B C7 E8 ?? ?? ?? ?? 8B 53 58 8B C7 E8 ?? ?? ?? ?? 8B 53 5C 8B C7 E8 ?? ?? ?? ?? 66 8B 53 60 8B C7 E8 ?? ?? ?? ?? 8A 53 62 8B C7 E8 ?? ?? ?? ?? EB 09 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_427_0 {
	meta:
		name = "TCustomAction.SetCaption"
		size = 102
		refs = "000e @LStrCmp 0028 TList.Get 002e _DV_TActionLink 0033 @IsClass 0056 @LStrAsg"
	strings:
		$1 = { 53 56 57 55 8B EA 8B D8 8B C5 8B 53 4C E8 ?? ?? ?? ?? 74 4D 8B 43 3C 8B 78 08 4F 85 FF 7C 31 47 33 F6 8B D6 8B 43 3C E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 11 8B D6 8B 43 3C E8 ?? ?? ?? ?? 8B D5 8B 08 FF 51 3C 46 4F 75 D2 8D 43 4C 8B D5 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 30 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_428_0 {
	meta:
		name = "TCustomAction.SetChecked"
		size = 88
		refs = "0021 TList.Get 0027 _DV_TActionLink 002c @IsClass"
	strings:
		$1 = { 53 56 57 55 8B DA 8B E8 3A 5D 50 74 46 8B 45 3C 8B 78 08 4F 85 FF 7C 31 47 33 F6 8B D6 8B 45 3C E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 11 8B D6 8B 45 3C E8 ?? ?? ?? ?? 8B D3 8B 08 FF 51 40 46 4F 75 D2 88 5D 50 8B C5 8B 10 FF 52 30 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_429_0 {
	meta:
		name = "TCustomAction.SetEnabled"
		size = 88
		refs = "0021 TList.Get 0027 _DV_TActionLink 002c @IsClass"
	strings:
		$1 = { 53 56 57 55 8B DA 8B E8 3A 5D 51 74 46 8B 45 3C 8B 78 08 4F 85 FF 7C 31 47 33 F6 8B D6 8B 45 3C E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 11 8B D6 8B 45 3C E8 ?? ?? ?? ?? 8B D3 8B 08 FF 51 44 46 4F 75 D2 88 5D 51 8B C5 8B 10 FF 52 30 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_430_0 {
	meta:
		name = "TCustomAction.SetHelpContext"
		size = 88
		refs = "0021 TList.Get 0027 _DV_TActionLink 002c @IsClass"
	strings:
		$1 = { 53 56 57 55 8B EA 8B D8 3B 6B 54 74 46 8B 43 3C 8B 78 08 4F 85 FF 7C 31 47 33 F6 8B D6 8B 43 3C E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 11 8B D6 8B 43 3C E8 ?? ?? ?? ?? 8B D5 8B 08 FF 51 48 46 4F 75 D2 89 6B 54 8B C3 8B 10 FF 52 30 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_431_0 {
	meta:
		name = "TCustomAction.SetHint"
		size = 102
		refs = "000e @LStrCmp 0028 TList.Get 002e _DV_TActionLink 0033 @IsClass 0056 @LStrAsg"
	strings:
		$1 = { 53 56 57 55 8B EA 8B D8 8B C5 8B 53 58 E8 ?? ?? ?? ?? 74 4D 8B 43 3C 8B 78 08 4F 85 FF 7C 31 47 33 F6 8B D6 8B 43 3C E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 11 8B D6 8B 43 3C E8 ?? ?? ?? ?? 8B D5 8B 08 FF 51 4C 46 4F 75 D2 8D 43 58 8B D5 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 30 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_432_0 {
	meta:
		name = "TCustomAction.SetImageIndex"
		size = 88
		refs = "0021 TList.Get 0027 _DV_TActionLink 002c @IsClass"
	strings:
		$1 = { 53 56 57 55 8B EA 8B D8 3B 6B 5C 74 46 8B 43 3C 8B 78 08 4F 85 FF 7C 31 47 33 F6 8B D6 8B 43 3C E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 11 8B D6 8B 43 3C E8 ?? ?? ?? ?? 8B D5 8B 08 FF 51 50 46 4F 75 D2 89 6B 5C 8B C3 8B 10 FF 52 30 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_433_0 {
	meta:
		name = "TCustomAction.SetShortCut"
		size = 90
		refs = "0022 TList.Get 0028 _DV_TActionLink 002d @IsClass"
	strings:
		$1 = { 53 56 57 55 8B EA 8B D8 66 3B 6B 60 74 47 8B 43 3C 8B 78 08 4F 85 FF 7C 31 47 33 F6 8B D6 8B 43 3C E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 11 8B D6 8B 43 3C E8 ?? ?? ?? ?? 8B D5 8B 08 FF 51 54 46 4F 75 D2 66 89 6B 60 8B C3 8B 10 FF 52 30 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_434_0 {
	meta:
		name = "TCustomAction.SetVisible"
		size = 88
		refs = "0021 TList.Get 0027 _DV_TActionLink 002c @IsClass"
	strings:
		$1 = { 53 56 57 55 8B DA 8B E8 3A 5D 62 74 46 8B 45 3C 8B 78 08 4F 85 FF 7C 31 47 33 F6 8B D6 8B 45 3C E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 11 8B D6 8B 45 3C E8 ?? ?? ?? ?? 8B D3 8B 08 FF 51 58 46 4F 75 D2 88 5D 62 8B C5 8B 10 FF 52 30 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_435_0 {
	meta:
		name = "TCustomAction.SetName"
		size = 76
		refs = "000e @LStrCmp 002e TComponent.SetName 0044 TCustomAction.SetCaption"
	strings:
		$1 = { 53 56 57 8B FA 8B F0 8B 46 08 8B 56 4C E8 ?? ?? ?? ?? 75 0D 8B 5E 04 85 DB 74 0A F6 43 20 01 74 04 33 C0 EB 02 B0 01 8B D8 8B D7 8B C6 E8 ?? ?? ?? ?? 84 DB 74 12 8B 46 3C 83 78 08 00 75 09 8B D7 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_436_0 {
	meta:
		name = "TCustomAction.DoHint"
		size = 29
	strings:
		$1 = { 53 51 C6 04 24 01 66 83 78 66 00 74 0A 8B CC 8B D8 8B 43 68 FF 53 64 8A 04 24 5A 5B C3 }
	condition:
		$1
}

rule function_437_0 {
	meta:
		name = "TCustomAction.Execute"
		size = 35
		refs = "0013 TContainedAction.Execute"
	strings:
		$1 = { 53 8B D8 8B C3 8B 10 FF 52 44 80 7B 51 00 74 0B 8B C3 E8 ?? ?? ?? ?? 84 C0 75 04 33 C0 5B C3 B0 01 5B C3 }
	condition:
		$1
}

rule function_440_0 {
	meta:
		name = "TAreaSeriesEditor.FormShow"
		size = 114
		refs = "0005 Screen 000e TScreen.SetCursor 002c TCustomRadioGroup.SetItemIndex 0050 TCustomComboBox.SetItemIndex 006b TAreaSeriesEditor.RefreshShape"
	strings:
		$1 = { 53 56 8B D8 A1 ?? ?? ?? ?? 8B 00 33 D2 E8 ?? ?? ?? ?? 8B 43 0C 89 83 F0 02 00 00 8B F0 33 D2 8A 96 2C 01 00 00 8B 83 C4 02 00 00 E8 ?? ?? ?? ?? 8A 56 2C 8B 83 E4 02 00 00 8B 08 FF 91 BC 00 00 00 33 D2 8A 96 E0 00 00 00 8B 83 D4 02 00 00 E8 ?? ?? ?? ?? 8A 96 FC 00 00 00 8B 83 D0 02 00 00 8B 08 FF 91 BC 00 00 00 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_441_0 {
	meta:
		name = "TAreaSeriesEditor.RefreshShape"
		size = 82
		refs = "0017 TControl.SetVisible 003e TAreaSeriesEditor.GetAreaColor 004b TBrush.SetColor"
	strings:
		$1 = { 53 56 8B D8 8B 83 F0 02 00 00 8A 50 2C 80 F2 01 8B 83 EC 02 00 00 E8 ?? ?? ?? ?? 8B 83 EC 02 00 00 8A 50 47 8B 83 E8 02 00 00 8B 08 FF 51 60 8B B3 EC 02 00 00 80 7E 47 00 74 14 8B C3 E8 ?? ?? ?? ?? 8B D0 8B 86 1C 01 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_442_0 {
	meta:
		name = "TAreaSeriesEditor.RGMultiAreaClick"
		size = 24
		refs = "0013 TAreaSeries.SetMultiArea"
	strings:
		$1 = { 8B 90 C4 02 00 00 8A 92 F8 01 00 00 8B 80 F0 02 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_443_0 {
	meta:
		name = "TAreaSeriesEditor.CBColorEachClick"
		size = 39
		refs = "0021 TAreaSeriesEditor.RefreshShape"
	strings:
		$1 = { 53 8B D8 8B 83 E4 02 00 00 8B 10 FF 92 B8 00 00 00 8B D0 8B 83 F0 02 00 00 8B 08 FF 51 78 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_444_0 {
	meta:
		name = "TAreaSeriesEditor.GetAreaColor"
		size = 27
	strings:
		$1 = { 8B 80 F0 02 00 00 8B 90 E4 00 00 00 81 FA 00 00 00 80 75 04 8B 40 28 C3 8B C2 C3 }
	condition:
		$1
}

rule function_445_0 {
	meta:
		name = "TAreaSeriesEditor.BAreaColorClick"
		size = 44
		refs = "0006 TAreaSeriesEditor.GetAreaColor 000f EditColor 0026 TAreaSeriesEditor.RefreshShape"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 8B D0 8B 83 F0 02 00 00 8B 08 FF 91 80 00 00 00 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_446_0 {
	meta:
		name = "TAreaSeriesEditor.CBStairsClick"
		size = 32
		refs = "001a TCustomSeries.SetStairs"
	strings:
		$1 = { 53 8B D8 8B 83 D0 02 00 00 8B 10 FF 92 B8 00 00 00 8B D0 8B 83 F0 02 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_447_0 {
	meta:
		name = "TAreaSeriesEditor.CBAreaBrushChange"
		size = 29
		refs = "000a TCustomComboBox.GetItemIndex 0017 TCustomSeries.SetAreaBrush"
	strings:
		$1 = { 53 8B D8 8B 83 D4 02 00 00 E8 ?? ?? ?? ?? 8B D0 8B 83 F0 02 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_448_0 {
	meta:
		name = "TAreaSeriesEditor.BAreaLinesPenClick"
		size = 18
		refs = "000d EditChartPen"
	strings:
		$1 = { 8B 90 F0 02 00 00 8B 92 E8 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_449_0 {
	meta:
		name = "TAreaSeriesEditor.SHAreaColorMouseUp"
		size = 14
		refs = "0006 TAreaSeriesEditor.BAreaColorClick"
	strings:
		$1 = { 55 8B EC 8B D0 E8 ?? ?? ?? ?? 5D C2 0C 00 }
	condition:
		$1
}

rule function_483_0 {
	meta:
		name = "TArrowSeriesEditor.SHArrowColorMouseUp"
		size = 14
		refs = "0006 TArrowSeriesEditor.BArrowColorClick"
	strings:
		$1 = { 55 8B EC 8B D0 E8 ?? ?? ?? ?? 5D C2 0C 00 }
	condition:
		$1
}

rule function_831_0 {
	meta:
		name = "TBarSeriesEditor.SHBarColorMouseUp"
		size = 14
		refs = "0006 TBarSeriesEditor.BBarColorClick"
	strings:
		$1 = { 55 8B EC 8B D0 E8 ?? ?? ?? ?? 5D C2 0C 00 }
	condition:
		$1
}

rule function_1289_0 {
	meta:
		name = "TBrushDialog.SHColorMouseUp"
		size = 14
		refs = "0006 TBrushDialog.BColorClick"
	strings:
		$1 = { 55 8B EC 8B D0 E8 ?? ?? ?? ?? 5D C2 0C 00 }
	condition:
		$1
}

rule function_17239_0 {
	meta:
		name = "TChartShapeEditor.Shape1MouseUp"
		size = 14
		refs = "0006 TChartShapeEditor.BShapeColorClick"
	strings:
		$1 = { 55 8B EC 8B D0 E8 ?? ?? ?? ?? 5D C2 0C 00 }
	condition:
		$1
}

rule function_15085_0 {
	meta:
		name = "TPenDialog.SHColorMouseUp"
		size = 14
		refs = "0006 TPenDialog.BColorClick"
	strings:
		$1 = { 55 8B EC 8B D0 E8 ?? ?? ?? ?? 5D C2 0C 00 }
	condition:
		$1
}

rule function_450_0 {
	meta:
		name = "TAreaSeriesEditor.BAreaLinePenClick"
		size = 18
		refs = "000d EditChartPen"
	strings:
		$1 = { 8B 90 F0 02 00 00 8B 92 F4 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_452_0 {
	meta:
		name = "AreaEdit"
		size = 20
		refs = "0002 _DV_2 000a _DV_TAreaSeriesEditor 000f RegisterClass"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_486_0 {
	meta:
		name = "Arrowedi"
		size = 20
		refs = "0002 _DV_2 000a _DV_TArrowSeriesEditor 000f RegisterClass"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_835_0 {
	meta:
		name = "BarEdit"
		size = 20
		refs = "0002 _DV_2 000a _DV_TBarSeriesEditor 000f RegisterClass"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1319_0 {
	meta:
		name = "BubblEdi"
		size = 20
		refs = "0002 _DV_2 000a _DV_TBubbleSeriesEditor 000f RegisterClass"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4840_0 {
	meta:
		name = "CustEdit"
		size = 20
		refs = "0002 _DV_2 000a _DV_TCustomSeriesEditor 000f RegisterClass"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_8696_0 {
	meta:
		name = "FLineEdi"
		size = 20
		refs = "0002 _DV_2 000a _DV_TFastLineSeriesEditor 000f RegisterClass"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_9155_0 {
	meta:
		name = "GanttEdi"
		size = 20
		refs = "0002 _DV_2 000a _DV_TGanttSeriesEditor 000f RegisterClass"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_15270_0 {
	meta:
		name = "PieEdit"
		size = 20
		refs = "0002 _DV_2 000a _DV_TPieSeriesEditor 000f RegisterClass"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_16329_0 {
	meta:
		name = "QrTee"
		size = 20
		refs = "0002 _DV_3 000a _DV_TQRDBChart 000f RegisterClass"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_17252_0 {
	meta:
		name = "ShapeEdi"
		size = 20
		refs = "0002 _DV_2 000a _DV_TChartShapeEditor 000f RegisterClass"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_453_0 {
	meta:
		name = "TArrowSeries.Create"
		size = 251
		refs = "0015 @ClassCreate 0022 TArrowSeries.Create 0031 TPointSeries.Create 0042 TChartValueList.SetDateTime 004a TeeMsg_ValuesArrowEndX 004f LoadResString 005c _Dn_TChartValueList 0061 TChartValueList.Create 007a TeeMsg_ValuesArrowEndY 00a4 TSeriesPointer.SetInflateMargins 00b1 TChartPen.SetVisible 00bb TSeriesMarks.SetBackTransparent 00d0 @LStrClr 00d6 @HandleFinally 00e5 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 DB 89 5D F8 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B C3 E8 ?? ?? ?? ?? C6 83 D0 00 00 00 00 B2 01 8B 43 70 E8 ?? ?? ?? ?? 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F8 50 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 2C 01 00 00 B2 01 8B C6 E8 ?? ?? ?? ?? 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F8 50 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 30 01 00 00 33 D2 8B 83 F8 00 00 00 E8 ?? ?? ?? ?? 8B 43 50 8B 40 14 33 D2 E8 ?? ?? ?? ?? B2 01 8B 43 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 80 7D FF 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_454_0 {
	meta:
		name = "TArrowSeries.SetEndXValues"
		size = 14
		refs = "0009 TChartSeries.SetChartValueList"
		altNames = "TBubbleSeries.SetRadiusValues TGanttSeries.SetEndValues"
	strings:
		$1 = { 8D 88 2C 01 00 00 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_455_0 {
	meta:
		name = "TArrowSeries.SetEndYValues"
		size = 14
		refs = "0009 TChartSeries.SetChartValueList"
		altNames = "TGanttSeries.SetNextTask"
	strings:
		$1 = { 8D 88 30 01 00 00 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1295_0 {
	meta:
		name = "TBubbleSeries.SetSquared"
		size = 14
		refs = "0009 TChartSeries.SetBooleanProperty"
	strings:
		$1 = { 8D 88 30 01 00 00 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_456_0 {
	meta:
		name = "TArrowSeries.AddArrow"
		size = 95
	strings:
		$1 = { 55 8B EC 51 53 56 89 4D FC 8B F0 FF 75 24 FF 75 20 FF 75 1C FF 75 18 8B 4D FC 8B C6 8B 18 FF 93 8C 00 00 00 8B D8 8B 86 2C 01 00 00 8B 55 10 89 50 30 8B 55 14 89 50 34 8B 86 30 01 00 00 8B 55 08 89 50 30 8B 55 0C 89 50 34 8B D3 8B C6 8B 08 FF 91 D8 00 00 00 8B C3 5E 5B 59 5D C2 20 00 }
	condition:
		$1
}

rule function_457_0 {
	meta:
		name = "TArrowSeries.FillSampleValues"
		size = 245
		refs = "0035 TChartSeries.CalcRandomBounds 003e @ROUND 0060 @RandInt 00db TArrowSeries.AddArrow 00e9 TChartSeries.RefreshSeries"
	strings:
		$1 = { 53 56 57 55 83 C4 BC 89 14 24 8B E8 8B C5 8B 10 FF 92 90 00 00 00 8D 44 24 24 50 8D 44 24 20 50 8D 44 24 34 50 8D 44 24 40 50 8D 4C 24 24 8B 54 24 10 8B C5 E8 ?? ?? ?? ?? DD 44 24 34 E8 ?? ?? ?? ?? 8B F8 8B 34 24 85 F6 0F 8E 97 00 00 00 DB 04 24 DC 4C 24 24 E8 ?? ?? ?? ?? 8B D8 8B C3 E8 ?? ?? ?? ?? 89 44 24 3C DB 44 24 3C DC 44 24 14 DD 5C 24 04 9B 8B C7 E8 ?? ?? ?? ?? 89 44 24 3C DB 44 24 3C DC 44 24 2C DD 5C 24 0C 9B FF 74 24 08 FF 74 24 08 FF 74 24 18 FF 74 24 18 8B C3 E8 ?? ?? ?? ?? 89 44 24 4C DB 44 24 4C DC 44 24 14 83 C4 F8 DD 1C 24 9B 8B C7 E8 ?? ?? ?? ?? 89 44 24 58 DB 44 24 58 DC 44 24 24 83 C4 F8 DD 1C 24 9B B9 00 00 00 80 33 D2 8B C5 E8 ?? ?? ?? ?? 4E 0F 85 69 FF FF FF 8B C5 E8 ?? ?? ?? ?? 83 C4 44 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_458_0 {
	meta:
		name = "TArrowSeries.GetArrowWidth"
		size = 10
	strings:
		$1 = { 8B 80 F8 00 00 00 8B 40 0C C3 }
	condition:
		$1
}

rule function_459_0 {
	meta:
		name = "TArrowSeries.GetArrowHeight"
		size = 10
	strings:
		$1 = { 8B 80 F8 00 00 00 8B 40 20 C3 }
	condition:
		$1
}

rule function_460_0 {
	meta:
		name = "TArrowSeries.SetArrowWidth"
		size = 12
		refs = "0007 TSeriesPointer.SetHorizSize"
	strings:
		$1 = { 8B 80 F8 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_461_0 {
	meta:
		name = "TArrowSeries.SetArrowHeight"
		size = 12
		refs = "0007 TSeriesPointer.SetVertSize"
	strings:
		$1 = { 8B 80 F8 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_462_0 {
	meta:
		name = "TArrowSeries.DrawValue"
		size = 235
		refs = "0033 TChartValueList.GetValue 0041 TChartSeries.CalcXPosValue 0060 TChartSeries.CalcYPosValue 0088 TSeriesPointer.PrepareCanvas 00ab TPen.SetColor 00b7 TArrowSeries.GetArrowWidth 00bf TArrowSeries.GetArrowHeight"
	strings:
		$1 = { 53 56 57 55 83 C4 F0 8B F2 8B D8 8B D6 8B C3 8B 08 FF 91 D0 00 00 00 89 04 24 8B D6 8B C3 8B 08 FF 91 D4 00 00 00 89 44 24 04 8B D6 8B 83 2C 01 00 00 E8 ?? ?? ?? ?? 83 C4 F8 DD 1C 24 9B 8B C3 E8 ?? ?? ?? ?? 89 44 24 08 8B D6 8B 83 30 01 00 00 E8 ?? ?? ?? ?? 83 C4 F8 DD 1C 24 9B 8B C3 E8 ?? ?? ?? ?? 89 44 24 0C 8B D6 8B C3 8B 08 FF 51 60 8B F8 8B 73 54 80 BE 4C 02 00 00 00 74 0F 8B D7 8B 83 F8 00 00 00 E8 ?? ?? ?? ?? EB 21 8B AE 5C 02 00 00 8B 83 F8 00 00 00 8B 50 18 8B 45 0C 8B 08 FF 51 08 8B 45 0C 8B D7 E8 ?? ?? ?? ?? 8D 44 24 08 50 8B C3 E8 ?? ?? ?? ?? 50 8B C3 E8 ?? ?? ?? ?? 50 8B 83 D8 00 00 00 50 8D 4C 24 10 8A 96 4C 02 00 00 8B 86 5C 02 00 00 8B 18 FF 93 BC 00 00 00 83 C4 10 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_463_0 {
	meta:
		name = "TArrowSeries.MaxXValue"
		size = 48
		refs = "0009 TChartSeries.MaxXValue 0021 MaxDouble"
		altNames = "TGanttSeries.MaxXValue"
	strings:
		$1 = { 53 83 C4 F8 8B D8 8B C3 E8 ?? ?? ?? ?? 83 C4 F8 DD 1C 24 9B 8B 83 2C 01 00 00 FF 70 10 FF 70 0C E8 ?? ?? ?? ?? DD 1C 24 9B DD 04 24 59 5A 5B C3 }
	condition:
		$1
}

rule function_464_0 {
	meta:
		name = "TArrowSeries.MinXValue"
		size = 48
		refs = "0009 TChartSeries.MinXValue 0021 MinDouble"
	strings:
		$1 = { 53 83 C4 F8 8B D8 8B C3 E8 ?? ?? ?? ?? 83 C4 F8 DD 1C 24 9B 8B 83 2C 01 00 00 FF 70 18 FF 70 14 E8 ?? ?? ?? ?? DD 1C 24 9B DD 04 24 59 5A 5B C3 }
	condition:
		$1
}

rule function_465_0 {
	meta:
		name = "TArrowSeries.MaxYValue"
		size = 48
		refs = "0009 TChartSeries.MaxYValue 0021 MaxDouble"
	strings:
		$1 = { 53 83 C4 F8 8B D8 8B C3 E8 ?? ?? ?? ?? 83 C4 F8 DD 1C 24 9B 8B 83 30 01 00 00 FF 70 10 FF 70 0C E8 ?? ?? ?? ?? DD 1C 24 9B DD 04 24 59 5A 5B C3 }
	condition:
		$1
}

rule function_466_0 {
	meta:
		name = "TArrowSeries.MinYValue"
		size = 48
		refs = "0009 TChartSeries.MinYValue 0021 MinDouble"
	strings:
		$1 = { 53 83 C4 F8 8B D8 8B C3 E8 ?? ?? ?? ?? 83 C4 F8 DD 1C 24 9B 8B 83 30 01 00 00 FF 70 18 FF 70 14 E8 ?? ?? ?? ?? DD 1C 24 9B DD 04 24 59 5A 5B C3 }
	condition:
		$1
}

rule function_467_0 {
	meta:
		name = "TArrowSeries.GetEditorClass"
		size = 48
		refs = "0006 TArrowSeries.GetEditorClass 000b @LStrLAsg"
	strings:
		$1 = { 53 8B DA 8B C3 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 00 00 00 FF FF FF FF 12 00 00 00 54 41 72 72 6F 77 53 65 72 69 65 73 45 64 69 74 6F 72 00 00 }
	condition:
		$1
}

rule function_468_0 {
	meta:
		name = "TArrowSeries.GetStartXValues"
		size = 4
		altNames = "TControl.GetPopupMenu TGanttSeries.GetStartValues THorizBarSeries.MandatoryValueList"
	strings:
		$1 = { 8B 40 70 C3 }
	condition:
		$1
}

rule function_470_0 {
	meta:
		name = "TArrowSeries.GetStartYValues"
		size = 4
		altNames = "TChartSeries.MandatoryValueList TDataSetTableProducer.GetDataSet TPieSeries.GetPieValues TQueryTableProducer.GetDataSet"
	strings:
		$1 = { 8B 40 78 C3 }
	condition:
		$1
}

rule function_472_0 {
	meta:
		name = "TArrowSeries.PrepareForGallery"
		size = 51
		refs = "0006 TPointSeries.PrepareForGallery 0021 TArrowSeries.SetArrowWidth 002d TArrowSeries.SetArrowHeight"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? BA 03 00 00 00 8B C3 8B 08 FF 91 9C 00 00 00 BA 0C 00 00 00 8B C3 E8 ?? ?? ?? ?? BA 0C 00 00 00 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_473_0 {
	meta:
		name = "TArrowSeries.IsValidSourceOf"
		size = 18
		refs = "0007 _DV_TArrowSeries 000c @IsClass"
	strings:
		$1 = { 53 8B DA 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1304_0 {
	meta:
		name = "TBubbleSeries.IsValidSourceOf"
		size = 18
		refs = "0007 _DV_TBubbleSeries 000c @IsClass"
	strings:
		$1 = { 53 8B DA 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_19609_0 {
	meta:
		name = "TChartShape.IsValidSourceOf"
		size = 18
		refs = "0007 _DV_TChartShape 000c @IsClass"
	strings:
		$1 = { 53 8B DA 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_15403_0 {
	meta:
		name = "TCustomProvider.FetchParams"
		size = 18
		refs = "0007 Null 000c @OleVarFromVar"
	strings:
		$1 = { 53 8B DA 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_17384_0 {
	meta:
		name = "TEditAction.GetControl"
		size = 18
		refs = "0007 _Dn_TCustomEdit 000c @AsClass"
	strings:
		$1 = { 53 8B DA 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_9137_0 {
	meta:
		name = "TGanttSeries.IsValidSourceOf"
		size = 18
		refs = "0007 _DV_TGanttSeries 000c @IsClass"
	strings:
		$1 = { 53 8B DA 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_17393_0 {
	meta:
		name = "TWindowAction.GetForm"
		size = 18
		refs = "0007 _Dn_TForm 000c @AsClass"
	strings:
		$1 = { 53 8B DA 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_475_0 {
	meta:
		name = "ArrowCha"
		size = 114
		refs = "000b ArrowCha 0017 _DV_2 0024 TeeMsg_GalleryStandard 0029 LoadResString 0035 TeeMsg_GalleryArrow 0042 _DV_TArrowSeries 0048 RegisterTeeSeries 0062 @LStrArrayClr 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 2D ?? ?? ?? ?? 01 73 2E 6A 02 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 50 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 A1 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 59 59 5D C3 }
	condition:
		$1
}

rule function_1307_0 {
	meta:
		name = "BubbleCh"
		size = 114
		refs = "000b BubbleCh 0017 _DV_2 0024 TeeMsg_GalleryStandard 0029 LoadResString 0035 TeeMsg_GalleryBubble 0042 _DV_TBubbleSeries 0048 RegisterTeeSeries 0062 @LStrArrayClr 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 2D ?? ?? ?? ?? 01 73 2E 6A 02 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 50 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 A1 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 59 59 5D C3 }
	condition:
		$1
}

rule function_19617_0 {
	meta:
		name = "TeeShape"
		size = 114
		refs = "000b TeeShape 0017 _DV_2 0024 TeeMsg_GalleryStandard 0029 LoadResString 0035 TeeMsg_GalleryShape 0042 _DV_TChartShape 0048 RegisterTeeSeries 0062 @LStrArrayClr 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 2D ?? ?? ?? ?? 01 73 2E 6A 02 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 50 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 A1 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 59 59 5D C3 }
	condition:
		$1
}

rule function_476_0 {
	meta:
		name = "TArrowSeriesEditor.CBColorEachClick"
		size = 110
		refs = "0050 TBrush.SetColor 0068 TControl.SetVisible"
	strings:
		$1 = { 53 8B D8 8B 83 E0 02 00 00 8B 10 FF 92 B8 00 00 00 8B D0 8B 83 F8 02 00 00 8B 08 FF 51 78 8B 83 F8 02 00 00 8A 50 2C 80 F2 01 8B 83 E4 02 00 00 8B 08 FF 51 60 8B 83 F8 02 00 00 80 78 2C 00 74 13 8B 80 F8 00 00 00 8B 40 08 BA 00 00 00 80 E8 ?? ?? ?? ?? 8B 83 E4 02 00 00 8B 10 FF 52 50 8B D0 8B 83 E8 02 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_477_0 {
	meta:
		name = "TArrowSeriesEditor.BArrowColorClick"
		size = 55
		refs = "0010 EditColor 0030 TBrush.SetColor"
	strings:
		$1 = { 53 56 8B D8 8B B3 F8 02 00 00 8B 56 28 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C6 8B 08 FF 91 80 00 00 00 8B 83 E8 02 00 00 8B 80 1C 01 00 00 8B 56 28 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_478_0 {
	meta:
		name = "TArrowSeriesEditor.BPenClick"
		size = 21
		refs = "0010 EditChartPen"
	strings:
		$1 = { 8B 90 F8 02 00 00 8B 92 F8 00 00 00 8B 52 18 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_479_0 {
	meta:
		name = "TArrowSeriesEditor.BBrushClick"
		size = 21
		refs = "0010 EditChartBrush"
	strings:
		$1 = { 8B 90 F8 02 00 00 8B 92 F8 00 00 00 8B 52 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_480_0 {
	meta:
		name = "TArrowSeriesEditor.SEArrowWidthChange"
		size = 39
		refs = "0013 TCustomUpDown.GetPosition 0021 TArrowSeries.SetArrowWidth"
	strings:
		$1 = { 53 8B D8 80 BB F4 02 00 00 00 75 19 8B 83 EC 02 00 00 E8 ?? ?? ?? ?? 0F BF D0 8B 83 F8 02 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_481_0 {
	meta:
		name = "TArrowSeriesEditor.SEArrowHeightChange"
		size = 39
		refs = "0013 TCustomUpDown.GetPosition 0021 TArrowSeries.SetArrowHeight"
	strings:
		$1 = { 53 8B D8 80 BB F4 02 00 00 00 75 19 8B 83 F0 02 00 00 E8 ?? ?? ?? ?? 0F BF D0 8B 83 F8 02 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_482_0 {
	meta:
		name = "TArrowSeriesEditor.FormShow"
		size = 116
		refs = "0005 Screen 000e TScreen.SetCursor 0031 TArrowSeries.GetArrowWidth 003e TCustomUpDown.SetPosition 0045 TArrowSeries.GetArrowHeight 0066 TBrush.SetColor"
	strings:
		$1 = { 53 56 8B D8 A1 ?? ?? ?? ?? 8B 00 33 D2 E8 ?? ?? ?? ?? 8B 43 0C 89 83 F8 02 00 00 8B F0 8A 56 2C 8B 83 E0 02 00 00 8B 08 FF 91 BC 00 00 00 8B C6 E8 ?? ?? ?? ?? 8B D0 8B 83 EC 02 00 00 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B D0 8B 83 F0 02 00 00 E8 ?? ?? ?? ?? 8B 83 E8 02 00 00 8B 80 1C 01 00 00 8B 56 28 E8 ?? ?? ?? ?? C6 83 F4 02 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_484_0 {
	meta:
		name = "TArrowSeriesEditor.FormCreate"
		size = 8
	strings:
		$1 = { C6 80 F4 02 00 00 01 C3 }
	condition:
		$1
}

rule function_487_0 {
	meta:
		name = "_NF__31E"
		size = 148
		refs = "0007 TConnectionPoint.GetConnectionInterface 0011 TConnectionPoint.GetConnectionPointContainer 001b TConnectionPoint.Advise 0025 TConnectionPoint.Unadvise 002f TConnectionPoint.EnumConnections 0046 TAggregatedObject._AddRef 0050 TAggregatedObject._Release 0054 _NF__31E"
	strings:
		$1 = { CC 83 44 24 04 D0 E9 ?? ?? ?? ?? 83 44 24 04 D0 E9 ?? ?? ?? ?? 83 44 24 04 D0 E9 ?? ?? ?? ?? 83 44 24 04 D0 E9 ?? ?? ?? ?? 83 44 24 04 D0 E9 ?? ?? ?? ?? 83 44 24 04 D0 8B 44 24 04 8B 00 FF 20 83 44 24 04 D0 E9 ?? ?? ?? ?? 83 44 24 04 D0 E9 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 00 00 00 86 B2 96 B1 B4 BA 1A 10 B6 9C 00 AA 00 34 1D 07 ?? ?? ?? ?? 30 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_488_0 {
	meta:
		name = "_NF__325"
		size = 2808
		refs = "0007 TActiveXControl.ViewObjectGetExtent 0011 TActiveXControl.Draw 001b TActiveXControl.GetColorSet 0025 TActiveXControl.Freeze 002f TActiveXControl.Unfreeze 0039 TActiveXControl.SetAdvise 0043 TActiveXControl.GetAdvise 004d TComObject.QueryInterface 0057 TComObject._AddRef 0061 TComObject._Release 00e3 TActiveXControl.GetPages 0117 TActiveXControl.PreMessageFilter 0124 TActiveXControl.PostMessageFilter 0158 TActiveXControl.QuickActivate 0165 TActiveXControl.SetContentExtent 0172 TActiveXControl.GetContentExtent 01a6 TActiveXControl.InitNew 01b3 TActiveXControl.IsDirty 01c0 TActiveXControl.PersistStreamLoad 01cd TActiveXControl.PersistStreamSave 01da TActiveXControl.GetSizeMax 01e7 TActiveXControl.GetClassID 0228 TActiveXControl.PersistStorageInitNew 0235 TActiveXControl.PersistStorageLoad 0242 TActiveXControl.PersistStorageSave 024f TActiveXControl.SaveCompleted 025c TActiveXControl.HandsOffStorage 029d TActiveXControl.PersistPropBagInitNew 02aa TActiveXControl.PersistPropBagLoad 02b7 TActiveXControl.PersistPropBagSave 02f8 TActiveXControl.GetDisplayString 0305 TActiveXControl.MapPropertyToPage 0312 TActiveXControl.GetPredefinedStrings 031f TActiveXControl.GetPredefinedValue 0353 TActiveXControl.SetClientSite 0360 TActiveXControl.GetClientSite 036d TActiveXControl.SetHostNames 037a TActiveXControl.Close 0387 TActiveXControl.SetMoniker 0394 TActiveXControl.GetMoniker 03a1 TActiveXControl.InitFromData 03ae TActiveXControl.GetClipboardData 03bb TActiveXControl.DoVerb 03c8 TActiveXControl.EnumVerbs 03d5 TActiveXControl.Update 03e2 TActiveXControl.IsUpToDate 03ef TActiveXControl.GetUserClassID 03fc TActiveXControl.GetUserType 0409 TActiveXControl.SetExtent 0416 TActiveXControl.GetExtent 0423 TActiveXControl.Advise 0430 TActiveXControl.Unadvise 043d TActiveXControl.EnumAdvise 044a TActiveXControl.GetMiscStatus 0457 TActiveXControl.SetColorScheme 048b TActiveXControl.InPlaceDeactivate 0498 TActiveXControl.UIDeactivate 04a5 TActiveXControl.SetObjectRects 04b2 TActiveXControl.ReactivateAndUndo 04bf TActiveXControl.GetWindow 04cc TActiveXControl.ContextSensitiveHelp 0500 TActiveXControl.TranslateAccelerator 050d TActiveXControl.OnFrameWindowActivate 051a TActiveXControl.OnDocWindowActivate 0527 TActiveXControl.ResizeBorder 0534 TActiveXControl.EnableModeless 0582 TActiveXControl.GetControlInfo 058f TActiveXControl.OnMnemonic 059c TActiveXControl.OnAmbientPropertyChange 05a9 TActiveXControl.FreezeEvents 0626 TActiveXControl.GetData 0633 TActiveXControl.GetDataHere 0640 TActiveXControl.QueryGetData 064d TActiveXControl.GetCanonicalFormatEtc 065a TActiveXControl.SetData 0667 TActiveXControl.EnumFormatEtc 0674 TActiveXControl.DAdvise 0681 TActiveXControl.DUnadvise 068e TActiveXControl.EnumDAdvise 06c8 TConnectionPoints.EnumConnectionPoints 06db TConnectionPoints.FindConnectionPoint 0708 _NF__325"
	strings:
		$1 = { CC 83 44 24 04 80 E9 ?? ?? ?? ?? 83 44 24 04 80 E9 ?? ?? ?? ?? 83 44 24 04 80 E9 ?? ?? ?? ?? 83 44 24 04 80 E9 ?? ?? ?? ?? 83 44 24 04 80 E9 ?? ?? ?? ?? 83 44 24 04 80 E9 ?? ?? ?? ?? 83 44 24 04 80 E9 ?? ?? ?? ?? 83 44 24 04 80 E9 ?? ?? ?? ?? 83 44 24 04 80 E9 ?? ?? ?? ?? 83 44 24 04 80 E9 ?? ?? ?? ?? 81 44 24 04 7C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 7C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 7C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 7C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 7C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 7C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 7C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 7C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 7C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 78 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 78 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 78 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 78 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 74 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 74 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 74 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 74 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 74 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 70 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 70 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 70 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 70 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 70 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 70 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 6C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 6C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 6C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 6C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 6C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 6C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 6C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 6C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 6C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 68 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 68 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 68 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 68 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 68 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 68 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 68 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 68 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 68 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 68 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 64 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 64 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 64 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 64 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 64 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 64 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 64 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 60 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 60 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 60 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 60 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 60 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 60 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 60 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 5C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 5C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 5C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 5C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 5C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 5C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 5C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 5C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 5C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 5C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 5C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 5C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 5C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 5C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 5C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 5C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 5C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 5C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 5C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 5C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 5C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 5C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 5C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 5C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 58 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 58 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 58 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 58 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 58 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 58 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 58 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 58 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 58 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 54 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 54 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 54 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 54 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 54 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 54 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 54 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 54 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 54 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 54 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 50 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 50 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 50 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 50 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 50 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 50 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 50 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 4C FF FF FF 8B 44 24 04 8B 00 FF 60 24 81 44 24 04 4C FF FF FF 8B 44 24 04 8B 00 FF 60 28 81 44 24 04 4C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 4C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 4C FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 48 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 48 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 48 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 48 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 48 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 48 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 48 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 48 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 48 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 48 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 48 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 48 FF FF FF E9 ?? ?? ?? ?? 8B 44 24 04 8B 80 78 FF FF FF 89 44 24 04 E9 ?? ?? ?? ?? 8B 44 24 04 8B 80 78 FF FF FF 89 44 24 04 E9 ?? ?? ?? ?? 81 44 24 04 44 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 44 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 44 FF FF FF E9 ?? ?? ?? ?? CC CC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 10 00 00 00 27 01 00 00 00 00 00 00 C0 00 00 00 00 00 00 46 ?? ?? ?? ?? 80 00 00 00 00 00 00 00 0D 01 00 00 00 00 00 00 C0 00 00 00 00 00 00 46 ?? ?? ?? ?? 84 00 00 00 00 00 00 00 8B B2 96 B1 B4 BA 1A 10 B6 9C 00 AA 00 34 1D 07 ?? ?? ?? ?? 88 00 00 00 00 00 00 00 01 0E 2B 74 E6 14 1B 10 91 4E 00 AA 00 30 0C AB ?? ?? ?? ?? 8C 00 00 00 00 00 00 00 10 ED 51 CF FE 62 CF 11 BF 86 00 A0 C9 03 48 36 ?? ?? ?? ?? 90 00 00 00 00 00 00 00 80 23 D5 7F 07 4E 1B 10 AE 2D 08 00 2B 2E C7 13 ?? ?? ?? ?? 94 00 00 00 00 00 00 00 0A 01 00 00 00 00 00 00 C0 00 00 00 00 00 00 46 ?? ?? ?? ?? 98 00 00 00 00 00 00 00 60 4F D8 37 CB 42 CE 11 81 35 00 AA 00 4B B8 51 ?? ?? ?? ?? 9C 00 00 00 00 00 00 00 AA D3 6B 37 45 38 1B 10 84 ED 08 00 2B 2E C7 13 ?? ?? ?? ?? A0 00 00 00 00 00 00 00 12 01 00 00 00 00 00 00 C0 00 00 00 00 00 00 46 ?? ?? ?? ?? A4 00 00 00 00 00 00 00 13 01 00 00 00 00 00 00 C0 00 00 00 00 00 00 46 ?? ?? ?? ?? A8 00 00 00 00 00 00 00 17 01 00 00 00 00 00 00 C0 00 00 00 00 00 00 46 ?? ?? ?? ?? AC 00 00 00 00 00 00 00 88 B2 96 B1 B4 BA 1A 10 B6 9C 00 AA 00 34 1D 07 ?? ?? ?? ?? B0 00 00 00 00 00 00 00 81 DC 5B CB C1 93 CF 11 8F 20 00 80 5F 2C D0 64 ?? ?? ?? ?? B4 00 00 00 00 00 00 00 0E 01 00 00 00 00 00 00 C0 00 00 00 00 00 00 46 ?? ?? ?? ?? B8 00 00 00 00 00 00 00 84 B2 96 B1 B4 BA 1A 10 B6 9C 00 AA 00 34 1D 07 ?? ?? ?? ?? BC 00 00 00 34 00 00 FF }
	condition:
		$1
}

rule function_489_0 {
	meta:
		name = "_NF__32B"
		size = 202
		refs = "005a TActiveFormControl.FreeOnRelease 0067 TComObject.QueryInterface 0074 TComObject._AddRef 0081 TComObject._Release 0086 _NF__32B"
	strings:
		$1 = { CC 81 44 24 04 40 FF FF FF 8B 44 24 04 8B 00 FF 60 18 81 44 24 04 40 FF FF FF 8B 44 24 04 8B 00 FF 60 14 81 44 24 04 40 FF FF FF 8B 44 24 04 8B 00 FF 60 10 81 44 24 04 40 FF FF FF 8B 44 24 04 8B 00 FF 60 1C 05 40 FF FF FF 50 8B 00 8B 40 E0 87 04 24 C3 05 40 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 40 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 40 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 40 FF FF FF E9 ?? ?? ?? ?? CC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 00 00 00 A0 92 78 E0 2F F5 CF 11 BD 2F 00 20 AF 0E 5B 81 ?? ?? ?? ?? C0 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_490_0 {
	meta:
		name = "_NF__336"
		size = 302
		refs = "0007 TPropertyPageImpl.EditProperty 0011 TPropertyPageImpl.SetPageSite 001b TPropertyPageImpl.Activate 0025 TPropertyPageImpl.Deactivate 002f TPropertyPageImpl.GetPageInfo 0039 TPropertyPageImpl.SetObjects 0043 TPropertyPageImpl.Show 004d TPropertyPageImpl.Move 0057 TPropertyPageImpl.IsPageDirty 0061 TPropertyPageImpl.Apply 006b TPropertyPageImpl.Help 0075 TPropertyPageImpl.TranslateAccelerator 007f TAggregatedObject.QueryInterface 0089 TAggregatedObject._AddRef 0093 TAggregatedObject._Release 009a _NF__336"
	strings:
		$1 = { CC 83 44 24 04 EC E9 ?? ?? ?? ?? 83 44 24 04 EC E9 ?? ?? ?? ?? 83 44 24 04 EC E9 ?? ?? ?? ?? 83 44 24 04 EC E9 ?? ?? ?? ?? 83 44 24 04 EC E9 ?? ?? ?? ?? 83 44 24 04 EC E9 ?? ?? ?? ?? 83 44 24 04 EC E9 ?? ?? ?? ?? 83 44 24 04 EC E9 ?? ?? ?? ?? 83 44 24 04 EC E9 ?? ?? ?? ?? 83 44 24 04 EC E9 ?? ?? ?? ?? 83 44 24 04 EC E9 ?? ?? ?? ?? 83 44 24 04 EC E9 ?? ?? ?? ?? 83 44 24 04 EC E9 ?? ?? ?? ?? 83 44 24 04 EC E9 ?? ?? ?? ?? 83 44 24 04 EC E9 ?? ?? ?? ?? CC CC CC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 00 00 00 65 46 E4 01 AC 24 1B 10 84 ED 08 00 2B 2E C7 13 ?? ?? ?? ?? 14 00 00 00 00 00 00 00 8D B2 96 B1 B4 BA 1A 10 B6 9C 00 AA 00 34 1D 07 ?? ?? ?? ?? 14 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 C0 00 00 00 00 00 00 46 ?? ?? ?? ?? 14 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_14198_0 {
	meta:
		name = "_NF__28B"
		size = 201
		refs = "0007 TOleUILinkInfo.GetLastUpdate 0011 TOleUILinkInfo.GetNextLink 001b TOleUILinkInfo.SetLinkUpdateOptions 0025 TOleUILinkInfo.GetLinkUpdateOptions 002f TOleUILinkInfo.SetLinkSource 0039 TOleUILinkInfo.GetLinkSource 0043 TOleUILinkInfo.OpenLinkSource 004d TOleUILinkInfo.UpdateLink 0057 TOleUILinkInfo.CancelLink 0061 TInterfacedObject.QueryInterface 006b TInterfacedObject._AddRef 0075 TInterfacedObject._Release 0079 _NF__28B"
	strings:
		$1 = { CC 83 44 24 04 EC E9 ?? ?? ?? ?? 83 44 24 04 EC E9 ?? ?? ?? ?? 83 44 24 04 EC E9 ?? ?? ?? ?? 83 44 24 04 EC E9 ?? ?? ?? ?? 83 44 24 04 EC E9 ?? ?? ?? ?? 83 44 24 04 EC E9 ?? ?? ?? ?? 83 44 24 04 EC E9 ?? ?? ?? ?? 83 44 24 04 EC E9 ?? ?? ?? ?? 83 44 24 04 EC E9 ?? ?? ?? ?? 83 44 24 04 EC E9 ?? ?? ?? ?? 83 44 24 04 EC E9 ?? ?? ?? ?? 83 44 24 04 EC E9 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? 14 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_491_0 {
	meta:
		name = "_NF__339"
		size = 641
		refs = "000d TPropertyPageImpl.EditProperty 001d TPropertyPageImpl.SetPageSite 002d TPropertyPageImpl.Activate 003d TPropertyPageImpl.Deactivate 004d TPropertyPageImpl.GetPageInfo 005d TPropertyPageImpl.SetObjects 006d TPropertyPageImpl.Show 007d TPropertyPageImpl.Move 008d TPropertyPageImpl.IsPageDirty 009d TPropertyPageImpl.Apply 00ad TPropertyPageImpl.Help 00bd TPropertyPageImpl.TranslateAccelerator 00cd TAggregatedObject.QueryInterface 00dd TAggregatedObject._AddRef 00ed TAggregatedObject._Release 01d1 _NF__339"
	strings:
		$1 = { CC 8B 44 24 04 8B 40 FC 89 44 24 04 E9 ?? ?? ?? ?? 8B 44 24 04 8B 40 FC 89 44 24 04 E9 ?? ?? ?? ?? 8B 44 24 04 8B 40 FC 89 44 24 04 E9 ?? ?? ?? ?? 8B 44 24 04 8B 40 FC 89 44 24 04 E9 ?? ?? ?? ?? 8B 44 24 04 8B 40 FC 89 44 24 04 E9 ?? ?? ?? ?? 8B 44 24 04 8B 40 FC 89 44 24 04 E9 ?? ?? ?? ?? 8B 44 24 04 8B 40 FC 89 44 24 04 E9 ?? ?? ?? ?? 8B 44 24 04 8B 40 FC 89 44 24 04 E9 ?? ?? ?? ?? 8B 44 24 04 8B 40 FC 89 44 24 04 E9 ?? ?? ?? ?? 8B 44 24 04 8B 40 FC 89 44 24 04 E9 ?? ?? ?? ?? 8B 44 24 04 8B 40 FC 89 44 24 04 E9 ?? ?? ?? ?? 8B 44 24 04 8B 40 FC 89 44 24 04 E9 ?? ?? ?? ?? 8B 44 24 04 8B 40 FC 89 44 24 04 E9 ?? ?? ?? ?? 8B 44 24 04 8B 40 FC 89 44 24 04 E9 ?? ?? ?? ?? 8B 44 24 04 8B 40 FC 89 44 24 04 E9 ?? ?? ?? ?? 8B 44 24 04 8B 40 F8 89 44 24 04 E9 ?? ?? ?? ?? 8B 44 24 04 8B 40 F8 89 44 24 04 E9 ?? ?? ?? ?? 8B 44 24 04 8B 40 F8 89 44 24 04 E9 ?? ?? ?? ?? 8B 44 24 04 8B 40 F8 89 44 24 04 E9 ?? ?? ?? ?? 8B 44 24 04 8B 40 F8 89 44 24 04 E9 ?? ?? ?? ?? 8B 44 24 04 8B 40 F8 89 44 24 04 E9 ?? ?? ?? ?? 8B 44 24 04 8B 40 F8 89 44 24 04 E9 ?? ?? ?? ?? 8B 44 24 04 8B 40 F8 89 44 24 04 E9 ?? ?? ?? ?? 8B 44 24 04 8B 40 F8 89 44 24 04 E9 ?? ?? ?? ?? 8B 44 24 04 8B 40 F8 89 44 24 04 E9 ?? ?? ?? ?? 8B 44 24 04 8B 40 F8 89 44 24 04 E9 ?? ?? ?? ?? 8B 44 24 04 8B 40 F8 89 44 24 04 E9 ?? ?? ?? ?? 8B 44 24 04 8B 40 F8 89 44 24 04 E9 ?? ?? ?? ?? 8B 44 24 04 8B 40 F8 89 44 24 04 E9 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 02 00 00 00 65 46 E4 01 AC 24 1B 10 84 ED 08 00 2B 2E C7 13 ?? ?? ?? ?? 24 00 00 00 20 00 00 FF 8D B2 96 B1 B4 BA 1A 10 B6 9C 00 AA 00 34 1D 07 ?? ?? ?? ?? 28 00 00 00 20 00 00 FF }
	condition:
		$1
}

rule function_493_0 {
	meta:
		name = "_NF__342"
		size = 106
		refs = "0007 TAdapterNotifier.OnChanged 0011 TAdapterNotifier.OnRequestEdit 001b TInterfacedObject.QueryInterface 0025 TInterfacedObject._AddRef 002f TInterfacedObject._Release 0036 _NF__342"
	strings:
		$1 = { CC 83 44 24 04 F0 E9 ?? ?? ?? ?? 83 44 24 04 F0 E9 ?? ?? ?? ?? 83 44 24 04 F0 E9 ?? ?? ?? ?? 83 44 24 04 F0 E9 ?? ?? ?? ?? 83 44 24 04 F0 E9 ?? ?? ?? ?? CC CC CC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 00 00 00 02 BC FB 9B F1 EF 1A 10 84 ED 00 AA 00 34 1D 07 ?? ?? ?? ?? 10 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_494_0 {
	meta:
		name = "_NF__346"
		size = 185
		refs = "0005 TFontAdapter.GetOleFont 000d TFontAdapter.SetOleFont 0017 TInterfacedObject.QueryInterface 0021 TInterfacedObject._AddRef 002b TInterfacedObject._Release 0059 _NF__346"
	strings:
		$1 = { CC 83 C0 E0 E9 ?? ?? ?? ?? 83 C0 E0 E9 ?? ?? ?? ?? 83 44 24 04 E0 E9 ?? ?? ?? ?? 83 44 24 04 E0 E9 ?? ?? ?? ?? 83 44 24 04 E0 E9 ?? ?? ?? ?? 83 C0 DC 50 8B 00 8B 00 87 04 24 C3 83 44 24 04 DC E9 ?? ?? ?? ?? 83 44 24 04 DC E9 ?? ?? ?? ?? 83 44 24 04 DC E9 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 02 00 00 00 A0 5C A5 CB 57 0E D0 11 BD 2F 00 20 AF 0E 5B 81 ?? ?? ?? ?? 20 00 00 00 00 00 00 00 21 23 B6 1F A7 44 D0 11 9E 93 00 20 AF 3D 82 DA ?? ?? ?? ?? 24 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_495_0 {
	meta:
		name = "_NF__34A"
		size = 186
		refs = "0005 TPictureAdapter.GetOlePicture 000d TPictureAdapter.SetOlePicture 0017 TInterfacedObject.QueryInterface 0021 TInterfacedObject._AddRef 002b TInterfacedObject._Release 005a _NF__34A"
	strings:
		$1 = { CC 83 C0 E0 E9 ?? ?? ?? ?? 83 C0 E0 E9 ?? ?? ?? ?? 83 44 24 04 E0 E9 ?? ?? ?? ?? 83 44 24 04 E0 E9 ?? ?? ?? ?? 83 44 24 04 E0 E9 ?? ?? ?? ?? 83 C0 DC 50 8B 00 8B 00 87 04 24 C3 83 44 24 04 DC E9 ?? ?? ?? ?? 83 44 24 04 DC E9 ?? ?? ?? ?? 83 44 24 04 DC E9 ?? ?? ?? ?? CC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 02 00 00 00 31 4D 5D 79 D7 43 D0 11 9E 92 00 20 AF 3D 82 DA ?? ?? ?? ?? 20 00 00 00 00 00 00 00 21 23 B6 1F A7 44 D0 11 9E 93 00 20 AF 3D 82 DA ?? ?? ?? ?? 24 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_496_0 {
	meta:
		name = "_NF__34F"
		size = 352
		refs = "0005 TStringsAdapter.ReferenceStrings 000d TStringsAdapter.ReleaseStrings 0017 TInterfacedObject.QueryInterface 0021 TInterfacedObject._AddRef 002b TInterfacedObject._Release 0035 TStringsAdapter.Get_ControlDefault 003f TStringsAdapter.Set_ControlDefault 0049 TStringsAdapter.Count 0053 TStringsAdapter.Get_Item 005d TStringsAdapter.Set_Item 0067 TStringsAdapter.Remove 0071 TStringsAdapter.Clear 007b TStringsAdapter.Add 0085 TStringsAdapter._NewEnum 008f TAutoIntfObject.GetTypeInfoCount 0099 TAutoIntfObject.GetTypeInfo 00a3 TAutoIntfObject.GetIDsOfNames 00ad TAutoIntfObject.Invoke 00d0 _NF__34F"
	strings:
		$1 = { CC 83 C0 D0 E9 ?? ?? ?? ?? 83 C0 D0 E9 ?? ?? ?? ?? 83 44 24 04 D0 E9 ?? ?? ?? ?? 83 44 24 04 D0 E9 ?? ?? ?? ?? 83 44 24 04 D0 E9 ?? ?? ?? ?? 83 44 24 04 CC E9 ?? ?? ?? ?? 83 44 24 04 CC E9 ?? ?? ?? ?? 83 44 24 04 CC E9 ?? ?? ?? ?? 83 44 24 04 CC E9 ?? ?? ?? ?? 83 44 24 04 CC E9 ?? ?? ?? ?? 83 44 24 04 CC E9 ?? ?? ?? ?? 83 44 24 04 CC E9 ?? ?? ?? ?? 83 44 24 04 CC E9 ?? ?? ?? ?? 83 44 24 04 CC E9 ?? ?? ?? ?? 83 44 24 04 CC E9 ?? ?? ?? ?? 83 44 24 04 CC E9 ?? ?? ?? ?? 83 44 24 04 CC E9 ?? ?? ?? ?? 83 44 24 04 CC E9 ?? ?? ?? ?? 83 44 24 04 CC E9 ?? ?? ?? ?? 83 44 24 04 CC E9 ?? ?? ?? ?? 83 44 24 04 CC E9 ?? ?? ?? ?? CC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 02 00 00 00 34 2F 9C 73 EC 52 D0 11 9E A6 00 20 AF 3D 82 DA ?? ?? ?? ?? 30 00 00 00 00 00 00 00 E2 DF 05 EE 49 55 D0 11 9E A9 00 20 AF 3D 82 DA ?? ?? ?? ?? 34 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_497_0 {
	meta:
		name = "ParkingWindowProc"
		size = 133
		refs = "006d SendMessage 007b DefWindowProc"
	strings:
		$1 = { 55 8B EC 53 56 8B 55 14 8B 4D 10 8B 45 0C 8B D8 83 C3 D5 83 EB 03 72 0D 83 EB 0B 74 08 81 EB D8 00 00 00 75 4E 8B D8 83 FB 2D 7F 0C 74 1E 83 EB 2B 74 1E 4B 74 20 EB 27 83 EB 39 74 0A 81 EB D8 00 00 00 74 16 EB 18 8B 72 04 EB 17 8B 72 04 EB 12 8B 72 04 EB 0D 8B 72 04 EB 08 8B F2 EB 04 33 C0 EB 1C 52 51 05 00 20 00 00 50 56 E8 ?? ?? ?? ?? EB 0C 52 51 50 8B 45 08 50 E8 ?? ?? ?? ?? 5E 5B 5D C2 10 00 }
	condition:
		$1
}

rule function_498_0 {
	meta:
		name = "ParkingWindow"
		size = 312
		refs = "0010 ParkingWindow 001c xParkingWindow 0033 @FillChar 0041 HInstance 0049 GetClassInfo 005e ParkingWindowProc 006f RegisterClass 007c SWindowClass 0081 LoadResString 008b _Dn_EOutOfResources 0090 Exception.Create 0095 @RaiseExcept 00ae GetSystemMetrics 00da CreateWindowEx 00f6 SetWindowPos 0111 @LStrClr 0117 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 D4 53 33 C0 89 45 D4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 1D ?? ?? ?? ?? 85 DB 0F 85 D8 00 00 00 8D 45 D8 33 C9 BA 28 00 00 00 E8 ?? ?? ?? ?? 8D 45 D8 50 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 00 50 E8 ?? ?? ?? ?? 85 C0 75 48 A1 ?? ?? ?? ?? 8B 00 89 45 E8 C7 45 DC ?? ?? ?? ?? B8 ?? ?? ?? ?? 89 45 FC 8D 45 D8 50 E8 ?? ?? ?? ?? 66 85 C0 75 21 8D 55 D4 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D D4 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 A1 ?? ?? ?? ?? 8B 00 50 6A 00 6A 00 6A 00 6A 00 6A 01 E8 ?? ?? ?? ?? D1 F8 79 03 83 D0 00 50 6A 00 E8 ?? ?? ?? ?? D1 F8 79 03 83 D0 00 50 68 00 00 00 80 6A 00 8B 45 FC 50 68 80 00 00 00 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 6A 5C 6A 00 6A 00 6A 00 6A 00 6A 00 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 D4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 8B E5 5D C3 44 41 58 50 61 72 6B 69 6E 67 57 69 6E 64 6F 77 00 00 00 00 }
	condition:
		$1
}

rule function_499_0 {
	meta:
		name = "HandleException"
		size = 43
		refs = "0002 ExceptObject 000c _Dn_EOleSysError 0011 @IsClass"
	strings:
		$1 = { 53 E8 ?? ?? ?? ?? 8B D8 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0B 83 7B 0C 00 7D 05 8B 43 0C 5B C3 B8 FF FF 00 80 5B C3 }
	condition:
		$1
}

rule function_500_0 {
	meta:
		name = "FreeObjects"
		size = 36
		refs = "0012 TList.Get 0017 TObject.Free"
	strings:
		$1 = { 53 56 8B F0 8B 5E 08 4B 83 FB 00 7C 14 8B D3 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 4B 83 FB FF 75 EC 5E 5B C3 }
	condition:
		$1
}

rule function_501_0 {
	meta:
		name = "FreeObjectList"
		size = 23
		refs = "000a FreeObjects 0011 TObject.Free"
	strings:
		$1 = { 53 8B D8 85 DB 74 0E 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_502_0 {
	meta:
		name = "CoAllocMem"
		size = 42
		refs = "0006 CoTaskMemAlloc 0016 OleError 0021 @FillChar"
	strings:
		$1 = { 53 56 8B F0 56 E8 ?? ?? ?? ?? 8B D8 85 DB 75 0A B8 0E 00 07 80 E8 ?? ?? ?? ?? 8B C3 33 C9 8B D6 E8 ?? ?? ?? ?? 8B C3 5E 5B C3 }
	condition:
		$1
}

rule function_503_0 {
	meta:
		name = "CoFreeMem"
		size = 11
		refs = "0006 CoTaskMemFree"
	strings:
		$1 = { 85 C0 74 06 50 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_504_0 {
	meta:
		name = "CoAllocString"
		size = 108
		refs = "000d CoAllocString 001d @WStrFromLStr 0025 @WStrLen 0031 CoAllocMem 003b @WStrToPWChar 0044 Move 0059 @WStrClr 005f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 8B D3 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 40 8B D8 03 DB 8B C3 E8 ?? ?? ?? ?? 8B F0 8B 45 FC E8 ?? ?? ?? ?? 8B D6 8B CB E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_505_0 {
	meta:
		name = "GetDispatchPropValue"
		size = 158
		refs = "0013 @IntfAddRef 001c tagEXCEPINFO 0021 @InitializeRecord 0029 GetDispatchPropValue 003e @FillChar 0052 GUID_NULL 0069 DispatchInvokeError 0084 @FinalizeRecord 008c @IntfClear 0092 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 CC 53 56 8B F1 8B DA 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 8D 45 DC 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 CC 33 C9 BA 10 00 00 00 E8 ?? ?? ?? ?? 6A 00 8D 45 DC 50 56 8D 45 CC 50 6A 02 6A 00 A1 ?? ?? ?? ?? 50 53 8B 45 FC 50 8B 00 FF 50 18 85 C0 74 08 8D 55 DC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E2 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_506_0 {
	meta:
		name = "SetDispatchPropValue"
		size = 168
		refs = "0013 @IntfAddRef 001c tagEXCEPINFO 0021 @InitializeRecord 0029 SetDispatchPropValue 0039 DispIDArgs 005c GUID_NULL 0073 DispatchInvokeError 008e @FinalizeRecord 0096 @IntfClear 009c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 CC 53 56 8B F1 8B DA 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 8D 45 DC 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 89 75 CC C7 45 D0 ?? ?? ?? ?? C7 45 D4 01 00 00 00 C7 45 D8 01 00 00 00 6A 00 8D 45 DC 50 6A 00 8D 45 CC 50 6A 04 6A 00 A1 ?? ?? ?? ?? 50 53 8B 45 FC 50 8B 00 FF 50 18 85 C0 74 08 8D 55 DC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E2 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_507_0 {
	meta:
		name = "SaveName"
		size = 141
		refs = "000f SaveName 0031 OleCheck 0040 TStrings.IndexOfObject 004e @LStrFromWStr 0073 @LStrClr 007b @WStrClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 6A 00 6A 00 6A 00 8D 45 FC 50 53 8B 45 08 8B 40 FC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 8B 45 08 8B 40 08 8B F3 8B D6 E8 ?? ?? ?? ?? 40 75 1B 8D 45 F8 8B 55 FC E8 ?? ?? ?? ?? 8B 55 F8 8B 45 08 8B 40 08 8B CE 8B 18 FF 53 38 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_508_0 {
	meta:
		name = "IsPropType"
		size = 332
		refs = "0015 IsPropType 0020 GUID_NULL 002d IsEqualGUID 0080 @IntfClear 008f OleCheck 0107 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 33 C9 89 4D F8 8B DA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? 50 8B 45 08 83 C0 EC 50 E8 ?? ?? ?? ?? 84 C0 74 09 8B 55 08 83 7A E8 00 74 04 33 D2 EB 02 B2 01 88 55 FF 80 7D FF 00 0F 85 D5 00 00 00 66 8B 53 04 66 83 EA 1A 74 0B 66 83 EA 03 74 1B E9 A7 00 00 00 8B 45 08 50 8B 13 8B C6 E8 ?? ?? ?? ?? 59 88 45 FF E9 AA 00 00 00 8D 45 F8 E8 ?? ?? ?? ?? 50 8B 03 50 56 8B 06 FF 50 38 E8 ?? ?? ?? ?? 8D 45 F4 50 8B 45 F8 50 8B 00 FF 50 0C E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 83 C0 EC 50 8B 45 F4 50 E8 ?? ?? ?? ?? 88 45 FF 80 7D FF 00 75 1F 8B 45 F4 83 78 28 06 75 16 8B 45 08 50 8B 45 F4 8D 50 3C 8B 45 F8 E8 ?? ?? ?? ?? 59 88 45 FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F4 50 8B 45 F8 50 8B 00 FF 50 4C C3 E9 ?? ?? ?? ?? EB EB 84 C0 74 0C 0F B7 43 04 8B 55 08 3B 42 E8 74 04 33 C0 EB 02 B0 01 88 45 FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8A 45 FF 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_509_0 {
	meta:
		name = "HasMember"
		size = 148
		refs = "002f OleCheck 0037 HasMember 0059 @TryFinallyExit 007b @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 89 4D F8 89 45 FC 4A 85 D2 7C 77 42 89 55 EC C7 45 F4 00 00 00 00 8D 45 F0 50 8B 45 F4 50 8B 45 FC 50 8B 00 FF 50 14 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F0 8B 00 3B 45 F8 75 14 8B 45 F0 8B 40 10 23 45 08 74 09 B3 01 E8 ?? ?? ?? ?? EB 2C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F0 50 8B 45 FC 50 8B 00 FF 50 50 C3 E9 ?? ?? ?? ?? EB EB FF 45 F4 FF 4D EC 75 94 33 DB 8B C3 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_510_0 {
	meta:
		name = "EnumDispatchProperties"
		size = 595
		refs = "0026 @IntfAddRef 002e EnumDispatchProperties 003c @IntfClear 004f OleCheck 00d0 IsPropType 00e0 SaveName 0101 @HandleFinally 0169 HasMember"
	strings:
		$1 = { 55 8B EC 83 C4 D0 53 56 57 33 DB 89 5D FC 8B F2 8D 7D EC 51 B9 04 00 00 00 F3 A5 59 89 4D E8 89 45 E4 8B 45 E4 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 50 6A 00 6A 00 8B 45 E4 50 8B 00 FF 50 10 E8 ?? ?? ?? ?? 83 7D FC 00 0F 84 C8 01 00 00 8D 45 DC 50 8B 45 FC 50 8B 00 FF 50 0C E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 DC 0F B7 40 2E 48 85 C0 0F 8C 82 00 00 00 40 89 45 D0 C7 45 E0 00 00 00 00 8D 45 D4 50 8B 45 E0 50 8B 45 FC 50 8B 00 FF 50 18 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 D4 F6 40 1C 01 74 20 55 8B 45 D4 8D 50 0C 8B 45 FC E8 ?? ?? ?? ?? 59 84 C0 74 0C 55 8B 45 D4 8B 00 E8 ?? ?? ?? ?? 59 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 D4 50 8B 45 FC 50 8B 00 FF 50 54 C3 E9 ?? ?? ?? ?? EB EB FF 45 E0 FF 4D D0 75 89 8B 45 DC 0F B7 40 2C 48 85 C0 0F 8C E4 00 00 00 40 89 45 D0 C7 45 E0 00 00 00 00 8D 45 D8 50 8B 45 E0 50 8B 45 FC 50 8B 00 FF 50 14 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 D8 83 78 10 02 75 2E 6A 0C 8B 45 D8 8B 08 8B 45 DC 0F B7 50 2C 8B 45 FC E8 ?? ?? ?? ?? 84 C0 74 14 55 8B 45 D8 8D 50 20 8B 45 FC E8 ?? ?? ?? ?? 59 84 C0 75 44 8B 45 D8 F6 40 10 0C 74 47 6A 02 8B 45 D8 8B 08 8B 45 DC 0F B7 50 2C 8B 45 FC E8 ?? ?? ?? ?? 84 C0 74 2D 55 8B 45 D8 0F BF 40 18 03 C0 8B 55 D8 8B 52 08 8D 54 C2 F0 8B 45 FC E8 ?? ?? ?? ?? 59 84 C0 74 0C 55 8B 45 D8 8B 00 E8 ?? ?? ?? ?? 59 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 D8 50 8B 45 FC 50 8B 00 FF 50 50 C3 E9 ?? ?? ?? ?? EB EB FF 45 E0 FF 4D D0 0F 85 27 FF FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 DC 50 8B 45 FC 50 8B 00 FF 50 4C C3 E9 ?? ?? ?? ?? EB EB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_511_0 {
	meta:
		name = "GetFontAccess"
		size = 80
		refs = "0011 _DV_TFontAdapter 0016 TFontAdapter.Create 0027 @IntfCopy 0031 GetFontAccess 0036 @IntfCast"
	strings:
		$1 = { 53 56 8B F2 8B D8 83 7B 1C 00 75 1F 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 85 D2 74 03 83 EA DC 8D 43 1C E8 ?? ?? ?? ?? 8B C6 8B 53 1C B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 00 00 00 A0 5C A5 CB 57 0E D0 11 BD 2F 00 20 AF 0E 5B 81 }
	condition:
		$1
}

rule function_512_0 {
	meta:
		name = "GetPictureAccess"
		size = 80
		refs = "0011 _DV_TPictureAdapter 0016 TPictureAdapter.Create 0027 @IntfCopy 0031 GetPictureAccess 0036 @IntfCast"
	strings:
		$1 = { 53 56 8B F2 8B D8 83 7B 10 00 75 1F 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 85 D2 74 03 83 EA DC 8D 43 10 E8 ?? ?? ?? ?? 8B C6 8B 53 10 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 00 00 00 31 4D 5D 79 D7 43 D0 11 9E 92 00 20 AF 3D 82 DA }
	condition:
		$1
}

rule function_513_0 {
	meta:
		name = "GetOleFont"
		size = 79
		refs = "000f GetOleFont 001f GetFontAccess 003e @IntfClear 0044 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 8B D6 8B 08 FF 51 0C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_515_0 {
	meta:
		name = "GetOlePicture"
		size = 79
		refs = "000f GetOlePicture 001f GetPictureAccess 003e @IntfClear 0044 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 8B D6 8B 08 FF 51 0C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_514_0 {
	meta:
		name = "SetOleFont"
		size = 102
		refs = "0015 @IntfAddRef 001d SetOleFont 002d GetFontAccess 004d @IntfClear 005b @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 C9 89 4D F8 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 8B 55 FC 8B 08 FF 51 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_516_0 {
	meta:
		name = "SetOlePicture"
		size = 102
		refs = "0015 @IntfAddRef 001d SetOlePicture 002d GetPictureAccess 004d @IntfClear 005b @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 C9 89 4D F8 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 8B 55 FC 8B 08 FF 51 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_517_0 {
	meta:
		name = "GetKeyModifiers"
		size = 54
		refs = "0006 GetKeyState"
	strings:
		$1 = { 53 33 DB 6A 10 E8 ?? ?? ?? ?? 66 85 C0 7D 05 BB 01 00 00 00 6A 11 E8 ?? ?? ?? ?? 66 85 C0 7D 03 83 CB 02 6A 12 E8 ?? ?? ?? ?? 66 85 C0 7D 03 83 CB 04 8B C3 5B C3 }
	condition:
		$1
}

rule function_518_0 {
	meta:
		name = "GetEventShift"
		size = 23
		refs = "0011 ShiftMap"
	strings:
		$1 = { 51 88 04 24 8A 04 24 24 07 25 FF 00 00 00 0F B6 80 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule function_519_0 {
	meta:
		name = "GetEventButton"
		size = 10
	strings:
		$1 = { 8B C8 B8 01 00 00 00 D3 E0 C3 }
	condition:
		$1
}

rule function_520_0 {
	meta:
		name = "TOleStream.Create"
		size = 58
		refs = "000b @ClassCreate 001b @IntfCopy 0026 @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 8D 47 04 8B D6 E8 ?? ?? ?? ?? 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_18563_0 {
	meta:
		name = "Exception.Create"
		size = 58
		refs = "000b @ClassCreate 001b @LStrAsg 0026 @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 8D 47 04 8B D6 E8 ?? ?? ?? ?? 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_11374_0 {
	meta:
		name = "TCustomIniFile.Create"
		size = 58
		refs = "000b @ClassCreate 001b @LStrAsg 0026 @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 8D 47 04 8B D6 E8 ?? ?? ?? ?? 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_521_0 {
	meta:
		name = "TOleStream.Read"
		size = 35
		refs = "0017 OleCheck"
	strings:
		$1 = { 53 56 57 51 8B F9 8B F2 8B D8 54 57 56 8B 43 04 50 8B 00 FF 50 0C E8 ?? ?? ?? ?? 8B 04 24 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_522_0 {
	meta:
		name = "TOleStream.Seek"
		size = 45
		refs = "0020 OleCheck"
	strings:
		$1 = { 53 56 57 83 C4 F8 8B F9 8B F2 8B D8 54 0F B7 C7 50 8B C6 99 52 50 8B 43 04 50 8B 00 FF 50 14 E8 ?? ?? ?? ?? 8B 04 24 59 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_523_0 {
	meta:
		name = "TOleStream.Write"
		size = 35
		refs = "0017 OleCheck"
	strings:
		$1 = { 53 56 57 51 8B F9 8B F2 8B D8 54 57 56 8B 43 04 50 8B 00 FF 50 10 E8 ?? ?? ?? ?? 8B 04 24 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_524_0 {
	meta:
		name = "TAggregatedObject.GetController"
		size = 19
		refs = "000c @IntfCopy"
		altNames = "TComObject.GetController TConnectionPoints.GetController TOleStream.GetIStream"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 53 04 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_4660_0 {
	meta:
		name = "ECorbaException.GetMessage"
		size = 19
		refs = "000c @LStrLAsg"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 53 04 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_525_0 {
	meta:
		name = "_NF__3D4"
		size = 137
		refs = "0007 TEnumConnections.Next 0011 TEnumConnections.Skip 001b TEnumConnections.Reset 0025 TEnumConnections.Clone 003c TAggregatedObject._AddRef 0046 TAggregatedObject._Release 004d _NF__3D4"
	strings:
		$1 = { CC 83 44 24 04 E8 E9 ?? ?? ?? ?? 83 44 24 04 E8 E9 ?? ?? ?? ?? 83 44 24 04 E8 E9 ?? ?? ?? ?? 83 44 24 04 E8 E9 ?? ?? ?? ?? 83 44 24 04 E8 8B 44 24 04 8B 00 FF 20 83 44 24 04 E8 E9 ?? ?? ?? ?? 83 44 24 04 E8 E9 ?? ?? ?? ?? CC CC CC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 00 00 00 87 B2 96 B1 B4 BA 1A 10 B6 9C 00 AA 00 34 1D 07 ?? ?? ?? ?? 18 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_526_0 {
	meta:
		name = "TEnumConnections.Create"
		size = 140
		refs = "0010 @ClassCreate 001e TEnumConnections.Create 002e TAggregatedObject.GetController 003a TAggregatedObject.Create 0061 @IntfClear 0067 @HandleFinally 0074 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C6 E8 ?? ?? ?? ?? 8B 4D FC 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 0C 8B 45 08 89 47 10 8B 46 20 8B 40 08 89 47 14 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_527_0 {
	meta:
		name = "TEnumConnections.Next"
		size = 114
		refs = "001b TList.Get 0034 @IntfCopy"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B 7D 10 8B 5D 08 33 F6 EB 33 8B 43 0C 8B 40 20 8B 53 10 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 74 19 33 C0 89 04 F7 8D 04 F7 8B 55 FC E8 ?? ?? ?? ?? 8B 43 10 40 89 44 F7 04 46 FF 43 10 3B 75 0C 7D 08 8B 43 10 3B 43 14 7C C0 83 7D 14 00 74 05 8B 45 14 89 30 3B 75 0C 75 04 33 C0 EB 05 B8 01 00 00 00 5F 5E 5B 59 5D C2 10 00 }
	condition:
		$1
}

rule function_528_0 {
	meta:
		name = "TEnumConnections.Skip"
		size = 68
		refs = "001d TList.Get"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 75 0C 8B 5D 08 BF 01 00 00 00 EB 16 8B 43 0C 8B 40 20 8B 53 10 E8 ?? ?? ?? ?? 85 C0 74 01 4E FF 43 10 85 F6 7E 08 8B 43 10 3B 43 14 7C DE 85 F6 75 02 33 FF 8B C7 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_529_0 {
	meta:
		name = "TEnumConnectionPoints.Reset"
		size = 17
		altNames = "TEnumConnections.Reset"
	strings:
		$1 = { 55 8B EC 8B 45 08 33 D2 89 50 10 33 C0 5D C2 04 00 }
	condition:
		$1
}

rule function_530_0 {
	meta:
		name = "TEnumConnections.Clone"
		size = 106
		refs = "0018 TEnumConnections.Clone 002c _DV_TEnumConnections 0031 TEnumConnections.Create 0042 @IntfCopy 0053 @HandleAnyException 005d @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 5D 08 8B 45 0C 85 C0 74 04 33 D2 89 10 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 43 10 50 8B 4B 0C B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 85 D2 74 03 83 EA E8 8B 45 0C E8 ?? ?? ?? ?? 33 DB 33 C0 5A 59 59 64 89 10 EB 0F E9 ?? ?? ?? ?? BB FF FF 00 80 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_531_0 {
	meta:
		name = "TConnectionPoint.Create"
		size = 134
		refs = "000f @ClassCreate 0022 TAggregatedObject.Create 0031 TList.Add 0038 _Dn_TList 003d TObject.Create 006e @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 88 55 FF 8B D8 8B 4E 04 33 D2 8B C3 E8 ?? ?? ?? ?? 8B C6 89 43 0C 8B 40 08 8B D3 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 43 20 8B 45 14 8B F0 8D 7B 10 B9 04 00 00 00 F3 A5 8A 45 10 88 43 2C 8B 45 08 89 43 24 8B 45 0C 89 43 28 8B C3 80 7D FF 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5F 5E 5B 59 5D C2 10 00 }
	condition:
		$1
}

rule function_532_0 {
	meta:
		name = "TConnectionPoint.Destroy"
		size = 111
		refs = "0005 @BeforeDestruction 001a TList.Remove 0036 TList.Get 0043 TConnectionPoint.RemoveSink 004f TObject.Free 005b TObject.Destroy 0066 @ClassDestroy"
	strings:
		$1 = { 53 56 57 55 E8 ?? ?? ?? ?? 8B DA 8B E8 8B 45 0C 85 C0 74 0A 8B 40 08 8B D5 E8 ?? ?? ?? ?? 8B 45 20 85 C0 74 2E 8B 78 08 4F 85 FF 7C 1E 47 33 F6 8B D6 8B 45 20 E8 ?? ?? ?? ?? 85 C0 74 09 8B D6 8B C5 E8 ?? ?? ?? ?? 46 4F 75 E5 8B 45 20 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C5 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C5 E8 ?? ?? ?? ?? 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_533_0 {
	meta:
		name = "TConnectionPoint.AddSink"
		size = 74
		refs = "0011 TList.Get 002d TList.Add 0038 TList.Put"
	strings:
		$1 = { 53 56 57 55 8B EA 8B F0 33 DB EB 0E 8B D3 8B C7 E8 ?? ?? ?? ?? 85 C0 74 09 43 8B 7E 20 3B 5F 08 7C EA 8B 46 20 3B 58 08 7C 09 8B D5 E8 ?? ?? ?? ?? EB 09 8B CD 8B D3 E8 ?? ?? ?? ?? 55 8B 45 00 FF 50 04 8B C3 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_534_0 {
	meta:
		name = "TConnectionPoint.RemoveSink"
		size = 49
		refs = "0010 TList.Get 001f TList.Put"
	strings:
		$1 = { 55 8B EC 51 53 56 8B F2 8B D8 8B D6 8B 43 20 E8 ?? ?? ?? ?? 89 45 FC 33 C9 8B D6 8B 43 20 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 08 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_535_0 {
	meta:
		name = "TConnectionPoint.GetConnectionInterface"
		size = 31
	strings:
		$1 = { 55 8B EC 56 57 8B 45 08 8B 55 0C 8B FA 8D 70 10 B9 04 00 00 00 F3 A5 33 C0 5F 5E 5D C2 08 00 }
	condition:
		$1
}

rule function_536_0 {
	meta:
		name = "TConnectionPoint.GetConnectionPointContainer"
		size = 60
		refs = "001c TConnectionPoint.GetConnectionPointContainer 0021 @IntfCast"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 8B 45 0C 85 C0 74 04 33 D2 89 10 8B 45 0C 8B 53 0C 8B 52 04 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5B 5D C2 08 00 84 B2 96 B1 B4 BA 1A 10 B6 9C 00 AA 00 34 1D 07 }
	condition:
		$1
}

rule function_537_0 {
	meta:
		name = "TConnectionPoint.Advise"
		size = 132
		refs = "0021 TList.Get 0034 TConnectionPoint.Advise 0054 TConnectionPoint.AddSink 006b @HandleAnyException 0070 HandleException 0077 @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 75 0C 8B 5D 08 80 7B 2C 00 75 1E 8B 43 20 83 78 08 00 7E 15 8B 43 20 33 D2 E8 ?? ?? ?? ?? 85 C0 74 07 BB 02 02 04 80 EB 4B 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 66 83 7B 26 00 74 0A B1 01 8B D6 8B 43 28 FF 53 24 8B D6 8B C3 E8 ?? ?? ?? ?? 40 8B 55 10 89 02 33 DB 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 0C 00 }
	condition:
		$1
}

rule function_538_0 {
	meta:
		name = "TConnectionPoint.Unadvise"
		size = 134
		refs = "001f TList.Get 0032 TConnectionPoint.Unadvise 005c TConnectionPoint.RemoveSink 006d @HandleAnyException 0072 HandleException 0079 @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 75 0C 8B 5D 08 4E 85 F6 7C 16 8B 43 20 3B 70 08 7D 0E 8B 43 20 8B D6 E8 ?? ?? ?? ?? 85 C0 75 07 BB 00 02 04 80 EB 4F 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 66 83 7B 26 00 74 14 8B 43 20 8B D6 E8 ?? ?? ?? ?? 8B D0 33 C9 8B 43 28 FF 53 24 8B D6 8B C3 E8 ?? ?? ?? ?? 33 DB 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_539_0 {
	meta:
		name = "TConnectionPoint.EnumConnections"
		size = 105
		refs = "0018 TConnectionPoint.EnumConnections 0029 _DV_TEnumConnections 002e TEnumConnections.Create 003f @IntfCopy 0050 @HandleAnyException 0055 HandleException 005c @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 5D 08 8B 45 0C 85 C0 74 04 33 D2 89 10 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 6A 00 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 85 D2 74 03 83 EA E8 8B 45 0C E8 ?? ?? ?? ?? 33 DB 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_540_0 {
	meta:
		name = "_NF__419"
		size = 135
		refs = "0007 TEnumConnectionPoints.Next 0011 TEnumConnectionPoints.Skip 001b TEnumConnectionPoints.Reset 0025 TEnumConnectionPoints.Clone 003c TAggregatedObject._AddRef 0046 TAggregatedObject._Release 004b _NF__419"
	strings:
		$1 = { CC 83 44 24 04 EC E9 ?? ?? ?? ?? 83 44 24 04 EC E9 ?? ?? ?? ?? 83 44 24 04 EC E9 ?? ?? ?? ?? 83 44 24 04 EC E9 ?? ?? ?? ?? 83 44 24 04 EC 8B 44 24 04 8B 00 FF 20 83 44 24 04 EC E9 ?? ?? ?? ?? 83 44 24 04 EC E9 ?? ?? ?? ?? CC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 00 00 00 85 B2 96 B1 B4 BA 1A 10 B6 9C 00 AA 00 34 1D 07 ?? ?? ?? ?? 14 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_541_0 {
	meta:
		name = "TEnumConnectionPoints.Create"
		size = 78
		refs = "000e @ClassCreate 0023 TAggregatedObject.Create 0037 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 8B 47 0C 8B 48 04 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 0C 8B 45 08 89 47 10 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_542_0 {
	meta:
		name = "TEnumConnectionPoints.Next"
		size = 113
		refs = "001b TList.Get"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B 7D 0C 8B 5D 08 33 F6 EB 2E 8B 43 0C 8B 40 08 8B 53 10 E8 ?? ?? ?? ?? 85 C0 74 03 83 E8 D0 89 45 FC 8B 45 FC 50 8B 00 FF 50 04 8B 45 10 8B 55 FC 89 14 B0 46 FF 43 10 3B FE 7E 0E 8B 43 0C 8B 40 08 8B 40 08 3B 43 10 7F C0 83 7D 14 00 74 05 8B 45 14 89 30 3B FE 75 04 33 C0 EB 05 B8 01 00 00 00 5F 5E 5B 59 5D C2 10 00 }
	condition:
		$1
}

rule function_543_0 {
	meta:
		name = "TEnumConnectionPoints.Skip"
		size = 48
	strings:
		$1 = { 55 8B EC 53 8B 55 0C 8B 45 08 8B 48 0C 8B 49 08 8B 49 08 8B 58 10 03 DA 3B CB 7C 07 01 50 10 33 C0 EB 08 89 48 10 B8 01 00 00 00 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_545_0 {
	meta:
		name = "TEnumConnectionPoints.Clone"
		size = 106
		refs = "0018 TEnumConnectionPoints.Clone 002c _DV_TEnumConnectionPoints 0031 TEnumConnectionPoints.Create 0042 @IntfCopy 0053 @HandleAnyException 005d @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 5D 08 8B 45 0C 85 C0 74 04 33 D2 89 10 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 43 10 50 8B 4B 0C B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 85 D2 74 03 83 EA EC 8B 45 0C E8 ?? ?? ?? ?? 33 DB 33 C0 5A 59 59 64 89 10 EB 0F E9 ?? ?? ?? ?? BB FF FF 00 80 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_546_0 {
	meta:
		name = "TConnectionPoints.Create"
		size = 62
		refs = "000a @ClassCreate 0018 _Dn_TList 001d TObject.Create 002b @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 89 4E 04 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 08 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1795_0 {
	meta:
		name = "TCollection.Create"
		size = 62
		refs = "000a @ClassCreate 0018 _DV_TList 001d TObject.Create 002b @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 89 4E 04 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 08 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_547_0 {
	meta:
		name = "TConnectionPoints.Destroy"
		size = 45
		refs = "0003 @BeforeDestruction 000f FreeObjectList 001b TObject.Destroy 0026 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 08 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_19558_0 {
	meta:
		name = "TChartFontObject.Destroy"
		size = 45
		refs = "0003 @BeforeDestruction 000f TObject.Free 001b TPersistent.Destroy 0026 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 08 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_19045_0 {
	meta:
		name = "TChartValueList.Destroy"
		size = 45
		refs = "0003 @BeforeDestruction 000f TObject.Free 001b TPersistent.Destroy 0026 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 08 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_3835_0 {
	meta:
		name = "TComClassManager.Destroy"
		size = 45
		refs = "0003 @BeforeDestruction 000f TObject.Free 001b TObject.Destroy 0026 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 08 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_11684_0 {
	meta:
		name = "TJPEGData.Destroy"
		size = 45
		refs = "0003 @BeforeDestruction 000f TObject.Free 001b TObject.Destroy 0026 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 08 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_15929_0 {
	meta:
		name = "TQREvElementFunction.Destroy"
		size = 45
		refs = "0003 @BeforeDestruction 000f TObject.Free 001b TObject.Destroy 0026 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 08 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_16009_0 {
	meta:
		name = "TQREvEmbeddedFunction.Destroy"
		size = 45
		refs = "0003 @BeforeDestruction 000f TObject.Free 001b TObject.Destroy 0026 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 08 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_16744_0 {
	meta:
		name = "TRegistryIniFile.Destroy"
		size = 45
		refs = "0003 @BeforeDestruction 000f TObject.Free 001b TObject.Destroy 0026 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 08 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_548_0 {
	meta:
		name = "TConnectionPoints.CreateConnectionPoint"
		size = 31
		refs = "000d _DV_TConnectionPoint 0017 TConnectionPoint.Create"
	strings:
		$1 = { 55 8B EC 52 51 FF 75 0C FF 75 08 8B 15 ?? ?? ?? ?? B1 01 92 87 CA E8 ?? ?? ?? ?? 5D C2 08 00 }
	condition:
		$1
}

rule function_549_0 {
	meta:
		name = "TConnectionPoints.EnumConnectionPoints"
		size = 103
		refs = "0018 TConnectionPoints.EnumConnectionPoints 0029 _DV_TEnumConnectionPoints 002e TEnumConnectionPoints.Create 003f @IntfCopy 0050 @HandleAnyException 005a @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 5D 08 8B 45 0C 85 C0 74 04 33 D2 89 10 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 6A 00 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 85 D2 74 03 83 EA EC 8B 45 0C E8 ?? ?? ?? ?? 33 DB 33 C0 5A 59 59 64 89 10 EB 0F E9 ?? ?? ?? ?? BB FF FF 00 80 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_550_0 {
	meta:
		name = "TConnectionPoints.FindConnectionPoint"
		size = 103
		refs = "002b TList.Get 003a IsEqualGUID 004f @IntfCopy"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 45 10 85 C0 74 04 33 D2 89 10 8B 45 08 8B 40 08 8B 70 08 4E 85 F6 7C 3C 46 33 FF 8B 45 08 8B 40 08 8B D7 E8 ?? ?? ?? ?? 8B D8 8B 45 0C 50 8D 43 10 50 E8 ?? ?? ?? ?? 84 C0 74 15 8B 45 10 8B D3 85 D2 74 03 83 EA D0 E8 ?? ?? ?? ?? 33 C0 EB 09 47 4E 75 C7 B8 00 02 04 80 5F 5E 5B 5D C2 0C 00 }
	condition:
		$1
}

rule function_552_0 {
	meta:
		name = "TReflectorWindow.Create"
		size = 222
		refs = "000f @ClassCreate 001f TWinControl.CreateParented 003d TReflectorWindow.Create 008e @HandleFinally 00c6 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FB 89 45 FC 33 D2 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 8B 55 08 89 90 EC 01 00 00 8B 45 FC C6 80 F0 01 00 00 01 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 FC 8B 80 EC 01 00 00 8B 55 FC 8B 08 FF 51 64 8B 45 FC 8B 80 EC 01 00 00 8B 50 38 52 8B 50 3C 52 33 C9 33 D2 8B 18 FF 93 80 00 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC C6 80 F0 01 00 00 00 C3 E9 ?? ?? ?? ?? EB EE 8B 45 FC 8B 80 EC 01 00 00 8B 50 38 52 8B 40 3C 50 8B 45 FC 8B 48 34 8B 45 FC 8B 50 30 8B 45 FC 8B 18 FF 93 80 00 00 00 8B 45 FC 80 7D FB 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B 45 FC 5B 59 59 5D C2 04 00 }
	condition:
		$1
}

rule function_553_0 {
	meta:
		name = "TReflectorWindow.WMGetDlgCode"
		size = 16
	strings:
		$1 = { 56 8B F0 8B 86 EC 01 00 00 8B 08 FF 51 70 5E C3 }
	condition:
		$1
}

rule function_554_0 {
	meta:
		name = "TReflectorWindow.WMSetFocus"
		size = 58
		refs = "0011 _Dn_TWinControl 0016 @IsClass 0021 TWinControl.GetHandle 0027 SetFocus 0032 TWinControl.WMSetFocus"
	strings:
		$1 = { 53 56 57 8B FA 8B D8 8B B3 EC 01 00 00 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0F 8B C6 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? EB 09 8B D7 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_555_0 {
	meta:
		name = "TReflectorWindow.WMSize"
		size = 177
		refs = "002b TReflectorWindow.WMSize 009b @HandleFinally 00a8 TWinControl.WMSize"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 89 55 F8 89 45 FC 8B 45 FC 80 B8 F0 01 00 00 00 0F 85 84 00 00 00 8B 45 FC C6 80 F0 01 00 00 01 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 F8 0F B7 40 08 50 8B 45 F8 0F B7 40 0A 50 8B 45 FC 8B 80 EC 01 00 00 33 C9 33 D2 8B 18 FF 93 80 00 00 00 8B 45 FC 8B 80 EC 01 00 00 8B 50 38 52 8B 40 3C 50 8B 45 FC 8B 48 34 8B 45 FC 8B 50 30 8B 45 FC 8B 18 FF 93 80 00 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC C6 80 F0 01 00 00 00 C3 E9 ?? ?? ?? ?? EB EE 8B 55 F8 8B 45 FC E8 ?? ?? ?? ?? 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_556_0 {
	meta:
		name = "_NF__45E"
		size = 257
		refs = "0007 TOleLinkStub.SetUpdateOptions 0011 TOleLinkStub.GetUpdateOptions 001b TOleLinkStub.SetSourceMoniker 0025 TOleLinkStub.GetSourceMoniker 002f TOleLinkStub.SetSourceDisplayName 0039 TOleLinkStub.GetSourceDisplayName 0043 TOleLinkStub.BindToSource 004d TOleLinkStub.BindIfRunning 0057 TOleLinkStub.GetBoundSource 0061 TOleLinkStub.UnbindSource 006b TOleLinkStub.Update 0075 TOleLinkStub.QueryInterface 007f TInterfacedObject._AddRef 0089 TInterfacedObject._Release 008d _NF__45E"
	strings:
		$1 = { CC 83 44 24 04 F0 E9 ?? ?? ?? ?? 83 44 24 04 F0 E9 ?? ?? ?? ?? 83 44 24 04 F0 E9 ?? ?? ?? ?? 83 44 24 04 F0 E9 ?? ?? ?? ?? 83 44 24 04 F0 E9 ?? ?? ?? ?? 83 44 24 04 F0 E9 ?? ?? ?? ?? 83 44 24 04 F0 E9 ?? ?? ?? ?? 83 44 24 04 F0 E9 ?? ?? ?? ?? 83 44 24 04 F0 E9 ?? ?? ?? ?? 83 44 24 04 F0 E9 ?? ?? ?? ?? 83 44 24 04 F0 E9 ?? ?? ?? ?? 83 44 24 04 F0 E9 ?? ?? ?? ?? 83 44 24 04 F0 E9 ?? ?? ?? ?? 83 44 24 04 F0 E9 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 02 00 00 00 1D 01 00 00 00 00 00 00 C0 00 00 00 00 00 00 46 ?? ?? ?? ?? 10 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 C0 00 00 00 00 00 00 46 ?? ?? ?? ?? 10 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_557_0 {
	meta:
		name = "TOleLinkStub.Create"
		size = 124
		refs = "000e @ClassCreate 001d @IntfAddRef 0025 TOleLinkStub.Create 0034 TObject.Create 003f @IntfCopy 0054 @IntfClear 005a @HandleFinally 0067 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D FC 8B DA 8B F0 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B C6 E8 ?? ?? ?? ?? 8D 46 0C 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_558_0 {
	meta:
		name = "TOleLinkStub.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TObject.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_13019_0 {
	meta:
		name = "TDecisionGraphDataLink.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TDecisionDataLink.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_13092_0 {
	meta:
		name = "TDecisionGridDataLink.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TDecisionDataLink.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_10108_0 {
	meta:
		name = "TId3To4Coder.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TIdCoder.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_10120_0 {
	meta:
		name = "TIdBase64Decoder.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TId3To4Coder.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_10115_0 {
	meta:
		name = "TIdBase64Encoder.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TId3To4Coder.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_10211_0 {
	meta:
		name = "TIdDateTimeStamp.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TComponent.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_10157_0 {
	meta:
		name = "TIdIMFUUDecoder.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TIdIMFDecoder.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_10192_0 {
	meta:
		name = "TIdQuotedPrintableDecoder.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TIdCoder.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_10185_0 {
	meta:
		name = "TIdQuotedPrintableEncoder.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TIdCoder.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_10131_0 {
	meta:
		name = "TIdUUDecoder.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TId3To4Coder.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_10124_0 {
	meta:
		name = "TIdUUEncoder.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TId3To4Coder.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_10140_0 {
	meta:
		name = "TIdXXDecoder.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TIdUUDecoder.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_10138_0 {
	meta:
		name = "TIdXXEncoder.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TIdUUEncoder.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_13321_0 {
	meta:
		name = "TMultiDimDataLink.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TDataLink.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_13782_0 {
	meta:
		name = "TNMURL.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TComponent.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_13145_0 {
	meta:
		name = "TPivotDataLink.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TDecisionDataLink.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_16610_0 {
	meta:
		name = "TQuickRep.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TCustomQuickRep.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_559_0 {
	meta:
		name = "TOleLinkStub.QueryInterface"
		size = 26
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 55 10 52 8B 55 0C 52 8B 40 0C 50 8B 00 FF 10 5D C2 0C 00 }
	condition:
		$1
}

rule function_560_0 {
	meta:
		name = "TActiveXControl.ContextSensitiveHelp"
		size = 12
		altNames = "TActiveXControl.GetSizeMax TActiveXControl.QueryGetData TActiveXControl.SetColorScheme TActiveXControl.Unfreeze TCorbaDispatchStub.GetTypeInfoCount TOleControl.LockInPlaceActive TOleControl.OnFocus TOleControl.SetBorderSpace TOleLinkStub.GetUpdateOptions TOleLinkStub.SetSourceDisplayName TOleLinkStub.SetUpdateOptions TOleLinkStub.Update TPropertyPageImpl.EditProperty TPropertyPageImpl.Help"
	strings:
		$1 = { 55 8B EC B8 01 40 00 80 5D C2 08 00 }
	condition:
		$1
}

rule function_562_0 {
	meta:
		name = "TActiveXControl.GetCanonicalFormatEtc"
		size = 12
		altNames = "TActiveXControl.GetDataHere TActiveXControl.SetMoniker TOleContainer.ConvertObject TOleContainer.Scroll TOleControl.OleControlSite_TranslateAccelerator TOleControl.Scroll TOleLinkStub.BindToSource TOleLinkStub.SetSourceMoniker"
	strings:
		$1 = { 55 8B EC B8 01 40 00 80 5D C2 0C 00 }
	condition:
		$1
}

rule function_563_0 {
	meta:
		name = "TOleControl.GetExtendedControl"
		size = 23
		altNames = "TOleLinkStub.GetBoundSource TOleLinkStub.GetSourceMoniker TStreamAdapter.Clone"
	strings:
		$1 = { 55 8B EC 8B 45 0C 85 C0 74 04 33 D2 89 10 B8 01 40 00 80 5D C2 08 00 }
	condition:
		$1
}

rule function_565_0 {
	meta:
		name = "TOleLinkStub.GetSourceDisplayName"
		size = 19
	strings:
		$1 = { 55 8B EC 8B 45 0C 33 D2 89 10 B8 05 40 00 80 5D C2 08 00 }
	condition:
		$1
}

rule function_567_0 {
	meta:
		name = "TActiveXControl.HandsOffStorage"
		size = 9
		altNames = "TActiveXControl.IsUpToDate TActiveXControl.PersistPropBagInitNew TActiveXControl.Update TDataSet.Locate TDragDockObject.GetDragCursor TMtsAutoObject.CanBePooled TMtsDataModule.CanBePooled TOleContainer.ShowObject TOleControl.CanInPlaceActivate TOleControl.SaveObject TOleLinkStub.BindIfRunning"
	strings:
		$1 = { 55 8B EC 33 C0 5D C2 04 00 }
	condition:
		$1
}

rule function_569_0 {
	meta:
		name = "TActiveXControl.ReactivateAndUndo"
		size = 12
		altNames = "TOleContainer.DiscardUndoState TOleContainer.RequestNewObjectLayout TOleControl.DiscardUndoState TOleControl.OnControlInfoChanged TOleControl.ShowPropertyFrame TOleLinkStub.UnbindSource"
	strings:
		$1 = { 55 8B EC B8 01 40 00 80 5D C2 04 00 }
	condition:
		$1
}

rule function_571_0 {
	meta:
		name = "TActiveXControl.Initialize"
		size = 220
		refs = "0007 TAutoObject.Initialize 0017 _DV_TConnectionPoints 001c TConnectionPoints.Create 0028 _DV_TActiveXControlFactory 002d @AsClass 003e TAutoObject.EventConnect 004b TConnectionPoints.CreateConnectionPoint 0054 TActiveXControl.Initialize 0066 ParkingWindow 0075 TWinControl.CreateParented 0092 _DV_TReflectorWindow 0097 TReflectorWindow.Create"
	strings:
		$1 = { 53 56 8B D8 8B C3 E8 ?? ?? ?? ?? 8B CB 85 C9 74 03 83 E9 E4 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 43 34 8B 43 08 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 73 30 83 7E 68 00 74 13 53 68 ?? ?? ?? ?? 8D 56 58 33 C9 8B 43 34 E8 ?? ?? ?? ?? 6A 00 6A 00 BA ?? ?? ?? ?? B1 01 8B 43 34 E8 ?? ?? ?? ?? 89 43 38 E8 ?? ?? ?? ?? 8B C8 8B 43 30 8B 40 6C B2 01 E8 ?? ?? ?? ?? 8B F0 89 73 6C F6 46 41 40 74 1C 8B 43 6C 50 E8 ?? ?? ?? ?? 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 43 78 EB 03 89 73 78 8B 43 6C 8B 50 28 89 53 70 8B 50 2C 89 53 74 8B 43 6C 89 58 2C 8B 13 8B 52 54 89 50 28 8B C3 8B 10 FF 52 40 5E 5B C3 00 00 02 BC FB 9B F1 EF 1A 10 84 ED 00 AA 00 34 1D 07 }
	condition:
		$1
}

rule function_572_0 {
	meta:
		name = "TActiveXControl.Destroy"
		size = 88
		refs = "0003 @BeforeDestruction 0025 TObject.Free 0046 TComObject.Destroy 0051 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 66 83 7E 72 00 74 0F 8B 46 6C 8B 56 70 89 50 28 8B 56 74 89 50 2C 8B 46 6C E8 ?? ?? ?? ?? 8B 46 78 3B 46 6C 74 05 E8 ?? ?? ?? ?? 8B 46 34 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_573_0 {
	meta:
		name = "TActiveXControl.CreateAdviseHolder"
		size = 29
		refs = "000d @IntfClear 0013 CreateOleAdviseHolder"
	strings:
		$1 = { 53 8B D8 83 7B 5C 00 75 10 8D 43 5C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5B C3 33 C0 5B C3 }
	condition:
		$1
}

rule function_574_0 {
	meta:
		name = "TActiveForm.DefinePropertyPages"
		size = 7
		altNames = "TActiveXControl.DefinePropertyPages TBasicActionLink.SetOnExecute TChartSeries.DoSeriesMouseUp TComponent.GetChildren TCustomChart.FillSeriesSourceItems TCustomRadioGroup.GetChildren TCustomRemoteServer.GetProviderNames TDBNavigator.GetChildren TDragObject.Finished TOleContainer.OnRename TPropertyEditor.GetProperties TPropertyEditor.GetValues TSpinEdit.GetChildren TTabSet.GetChildren"
	strings:
		$1 = { 55 8B EC 5D C2 08 00 }
	condition:
		$1
}

rule function_577_0 {
	meta:
		name = "TActiveXControl.GetPropFromBag"
		size = 196
		refs = "001a @IntfAddRef 002a TActiveXControl.GetPropFromBag 003f @WStrToPWChar 0063 @IntfCast 0070 SetDispatchPropValue 0085 @IntfClear 008d @VarClr 00a3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 8B 45 0C E8 ?? ?? ?? ?? 8B 45 08 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 50 8D 45 F0 50 8B C6 E8 ?? ?? ?? ?? 50 8B 45 0C 50 8B 00 FF 50 0C 85 C0 75 23 8D 45 EC 8B D3 85 D2 74 03 83 EA E4 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 EC 8D 4D F0 8B D7 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 08 E8 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D8 5F 5E 5B 8B E5 5D C2 08 00 00 00 00 04 02 00 00 00 00 00 C0 00 00 00 00 00 00 46 }
	condition:
		$1
}

rule function_578_0 {
	meta:
		name = "TActiveXControl.PutPropInBag"
		size = 172
		refs = "001a @IntfAddRef 0022 TActiveXControl.PutPropInBag 003e @IntfCast 004b GetDispatchPropValue 0056 @WStrToPWChar 0075 @IntfClear 007d @VarClr 008b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 8B 45 08 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 EC 8B D3 85 D2 74 03 83 EA E4 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 EC 8D 4D F0 8B D7 E8 ?? ?? ?? ?? 8D 45 F0 50 8B C6 E8 ?? ?? ?? ?? 50 8B 45 08 50 8B 00 FF 50 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 08 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5F 5E 5B 8B E5 5D C2 04 00 00 00 00 04 02 00 00 00 00 00 C0 00 00 00 00 00 00 46 }
	condition:
		$1
}

rule function_579_0 {
	meta:
		name = "TActiveXControl.GetPropertyValue"
		size = 7
		altNames = "TBaseProvider.UpdateRecord TChartSeries.DoSeriesMouseMove TChartSeries.PrepareLegendCanvas TComponent.UpdateRegistry TCustomAxisPanel.FormattedValueLegend TCustomGrid.SetEditText TOleContainer.OnClose TOleContainer.OnSave TQRExportFilter.Start"
	strings:
		$1 = { 55 8B EC 5D C2 04 00 }
	condition:
		$1
}

rule function_581_0 {
	meta:
		name = "TActiveXControl.InPlaceActivate"
		size = 716
		refs = "0018 TActiveXControl.InPlaceActivate 002d TControl.SetVisible 005f OleError 006a @IntfClear 0080 OleCheck 0146 TWinControl.SetParentWindow 0175 @HandleAnyException 01b4 HandleException 01bb @DoneExcept 01fa TWinControl.GetHandle 0200 SetFocus 0219 @IntfCast 029b @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 BC 53 56 57 33 C9 89 4D BC 88 55 FB 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 F6 8B 45 FC 8B 40 78 B2 01 E8 ?? ?? ?? ?? C6 45 FA 00 8B 45 FC 80 78 7D 00 0F 85 87 01 00 00 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 FC 83 78 40 00 75 0A B8 05 40 00 80 E8 ?? ?? ?? ?? 8B 45 FC 83 C0 50 E8 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 8B 45 FC 8B 40 40 50 8B 00 FF 10 E8 ?? ?? ?? ?? 8B 45 FC 8B 40 50 50 8B 00 FF 50 14 85 C0 74 0A B8 05 40 00 80 E8 ?? ?? ?? ?? 8B 45 FC 8B 40 50 50 8B 00 FF 50 18 E8 ?? ?? ?? ?? C6 45 FA 01 8D 45 F4 50 8B 45 FC 8B 40 50 50 8B 00 FF 50 0C E8 ?? ?? ?? ?? C7 45 C0 14 00 00 00 8D 45 C0 50 8D 45 D4 50 8D 45 E4 50 8B 45 FC 83 C0 58 E8 ?? ?? ?? ?? 50 8B 45 FC 83 C0 54 E8 ?? ?? ?? ?? 50 8B 45 FC 8B 40 50 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 8B 45 FC 83 78 54 00 75 0A B8 05 40 00 80 E8 ?? ?? ?? ?? 8B 55 EC 8B 7D E4 2B D7 52 8B 55 F0 8B 45 E8 2B D0 52 8B 55 FC 8B 52 78 8B C8 8B C7 92 8B 18 FF 93 80 00 00 00 8B 45 FC 8B 40 78 8B 55 F4 E8 ?? ?? ?? ?? 8B 45 FC 8B 40 78 B2 01 E8 ?? ?? ?? ?? 8B 45 FC C6 40 7D 01 8B 45 FC 8B 40 40 50 8B 00 FF 50 18 33 C0 5A 59 59 64 89 10 EB 55 E9 ?? ?? ?? ?? 8B 45 FC C6 40 7D 00 8B 45 FC 83 C0 58 E8 ?? ?? ?? ?? 8B 45 FC 83 C0 54 E8 ?? ?? ?? ?? 80 7D FA 00 74 0C 8B 45 FC 8B 40 50 50 8B 00 FF 50 2C 8B 45 FC 83 C0 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 E8 ?? ?? ?? ?? E9 C0 00 00 00 E8 ?? ?? ?? ?? 80 7D FB 00 0F 84 B1 00 00 00 8B 45 FC 80 78 7E 00 0F 85 A4 00 00 00 8B 45 FC C6 40 7E 01 8B 45 FC 8B 40 50 50 8B 00 FF 50 1C 8B 45 FC 8B 40 78 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 6A 00 8D 45 BC 8B 55 FC 85 D2 74 03 83 EA E4 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 BC 50 8B 45 FC 8B 40 54 50 8B 00 FF 50 20 8B 45 FC 83 78 58 00 74 29 6A 00 8D 45 BC 8B 55 FC 85 D2 74 03 83 EA E4 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 BC 50 8B 45 FC 8B 40 58 50 8B 00 FF 50 20 6A 00 8B 45 FC 8B 40 54 50 8B 00 FF 50 1C 8B 45 FC 83 78 58 00 74 0E 6A 00 8B 45 FC 8B 40 58 50 8B 00 FF 50 1C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 BC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 5F 5E 5B 8B E5 5D C3 00 00 19 01 00 00 00 00 00 00 C0 00 00 00 00 00 00 46 17 01 00 00 00 00 00 00 C0 00 00 00 00 00 00 46 }
	condition:
		$1
}

rule function_582_0 {
	meta:
		name = "TActiveXControl.LoadFromStream"
		size = 82
		refs = "000a _DV_TOleStream 0011 TOleStream.Create 001c TActiveXControl.LoadFromStream 002d TStream.ReadComponent 0042 TObject.Free 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B D8 8B CA A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 53 6C 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_583_0 {
	meta:
		name = "TActiveXControl.ObjQueryInterface"
		size = 164
		refs = "000d TActiveXControl.ObjQueryInterface 0013 IsEqualGUID 0032 TComObject.ObjQueryInterface 005e _DV_TOleLinkStub 0063 TOleLinkStub.Create 0074 @IntfCopy"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 75 0C 8B 5D 08 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 84 C0 74 10 8B 43 30 F6 40 72 01 75 07 BF 02 40 00 80 EB 4D 8B 45 10 50 56 53 E8 ?? ?? ?? ?? 8B F8 85 FF 74 3C 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 84 C0 74 2D 8B 45 10 33 D2 89 10 8B CB 85 C9 74 03 83 E9 E4 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 85 D2 74 03 83 EA F0 8B 45 10 E8 ?? ?? ?? ?? 8B C7 5F 5E 5B 5D C2 0C 00 00 00 00 01 0E 2B 74 E6 14 1B 10 91 4E 00 AA 00 30 0C AB 1D 01 00 00 00 00 00 00 C0 00 00 00 00 00 00 46 }
	condition:
		$1
}

rule function_585_0 {
	meta:
		name = "TActiveXControl.GetPropertyID"
		size = 79
		refs = "000c @WStrToPWChar 0019 @WStrCmp 002a GetThreadLocale 0037 GUID_NULL 0043 OleCheck"
	strings:
		$1 = { 53 56 83 C4 F8 8B DA 8B F0 8B C3 E8 ?? ?? ?? ?? 89 44 24 04 8B C3 33 D2 E8 ?? ?? ?? ?? 75 09 C7 04 24 FF FF FF FF EB 1F 54 E8 ?? ?? ?? ?? 50 6A 01 8D 44 24 10 50 A1 ?? ?? ?? ?? 50 56 8B 06 FF 50 10 E8 ?? ?? ?? ?? 8B 04 24 59 5A 5E 5B C3 }
	condition:
		$1
}

rule function_586_0 {
	meta:
		name = "TActiveXControl.PropChanged"
		size = 21
		refs = "0006 TActiveXControl.GetPropertyID 000f TActiveXControl.PropChanged"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_588_0 {
	meta:
		name = "TActiveXControl.PropRequestEdit"
		size = 21
		refs = "0006 TActiveXControl.GetPropertyID 000f TActiveXControl.PropRequestEdit"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_6151_0 {
	meta:
		name = "TDBCheckBox.DataChange"
		size = 21
		refs = "0006 TDBCheckBox.GetFieldState 000f TCustomCheckBox.SetState"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_6149_0 {
	meta:
		name = "TDBCheckBox.UseRightToLeftAlignment"
		size = 21
		refs = "0006 TDBCheckBox.GetField 000f DBUseRightToLeftAlignment"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_6201_0 {
	meta:
		name = "TDBComboBox.UseRightToLeftAlignment"
		size = 21
		refs = "0006 TDBComboBox.GetField 000f DBUseRightToLeftAlignment"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_6103_0 {
	meta:
		name = "TDBEdit.UseRightToLeftAlignment"
		size = 21
		refs = "0006 TDBEdit.GetField 000f DBUseRightToLeftAlignment"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_6208_0 {
	meta:
		name = "TDBListBox.UseRightToLeftAlignment"
		size = 21
		refs = "0006 TDBListBox.GetField 000f DBUseRightToLeftAlignment"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_6254_0 {
	meta:
		name = "TDBMemo.UseRightToLeftAlignment"
		size = 21
		refs = "0006 TDBMemo.GetField 000f DBUseRightToLeftAlignment"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_6229_0 {
	meta:
		name = "TDBRadioGroup.UseRightToLeftAlignment"
		size = 21
		refs = "0006 TDBRadioGroup.GetField 000f DBUseRightToLeftAlignment"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_6465_0 {
	meta:
		name = "TDBRichEdit.UseRightToLeftAlignment"
		size = 21
		refs = "0006 TDBRichEdit.GetField 000f DBUseRightToLeftAlignment"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_6133_0 {
	meta:
		name = "TDBText.UseRightToLeftAlignment"
		size = 21
		refs = "0006 TDBText.GetField 000f DBUseRightToLeftAlignment"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_587_0 {
	meta:
		name = "TActiveXControl.PropChanged"
		size = 216
		refs = "0019 tagCONNECTDATA 001e @InitializeRecord 0026 TActiveXControl.PropChanged 0034 @IntfClear 003e TConnectionPoint.EnumConnections 0043 OleCheck 0056 @IntfCast 0079 @FinalizeRecord 00ba @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 33 C9 89 4D EC 89 4D FC 8B DA 8B F0 8D 45 F4 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 50 8B 46 38 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 22 53 8D 45 EC 8B 55 F4 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 0C 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F0 50 8B 15 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 50 6A 01 8B 45 FC 50 8B 00 FF 50 0C 85 C0 74 BC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F4 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DA 5E 5B 8B E5 5D C3 00 00 02 BC FB 9B F1 EF 1A 10 84 ED 00 AA 00 34 1D 07 }
	condition:
		$1
}

rule function_589_0 {
	meta:
		name = "TActiveXControl.PropRequestEdit"
		size = 232
		refs = "001a tagCONNECTDATA 001f @InitializeRecord 0027 TActiveXControl.PropRequestEdit 0037 @IntfClear 0041 TConnectionPoint.EnumConnections 0046 OleCheck 0059 @IntfCast 0085 @FinalizeRecord 00c6 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 89 4D FC 8B F2 8B F8 8D 45 F4 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B3 01 8D 45 FC E8 ?? ?? ?? ?? 50 8B 47 38 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 2B 56 8D 45 EC 8B 55 F4 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 10 85 C0 0F 94 C3 8D 45 F4 E8 ?? ?? ?? ?? 84 DB 74 22 8D 45 F0 50 8D 45 F4 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 6A 01 8B 45 FC 50 8B 00 FF 50 0C 85 C0 74 B3 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F4 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DA 8B C3 5F 5E 5B 8B E5 5D C3 00 00 00 02 BC FB 9B F1 EF 1A 10 84 ED 00 AA 00 34 1D 07 }
	condition:
		$1
}

rule function_590_0 {
	meta:
		name = "TActiveXControl.RecreateWnd"
		size = 94
		refs = "0009 TWinControl.HandleAllocated 001a TWinControl.GetHandle 0020 GetWindow 0028 TActiveXControl.InPlaceDeactivate 0030 TWinControl.DestroyHandle 0039 TActiveXControl.InPlaceActivate 0056 SetWindowPos"
	strings:
		$1 = { 53 56 57 8B F0 8B 46 78 E8 ?? ?? ?? ?? 84 C0 74 49 8A 5E 7E 6A 03 8B 46 78 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B F8 56 E8 ?? ?? ?? ?? 8B 46 78 E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 85 C0 75 19 6A 13 6A 00 6A 00 6A 00 6A 00 57 8B 46 78 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_591_0 {
	meta:
		name = "TActiveXControl.SaveToStream"
		size = 160
		refs = "000c _DV_TOleStream 0013 TOleStream.Create 001e TActiveXControl.SaveToStream 0033 _Dn_TWriter 0038 TFiler.Create 005d TWriter.WriteDescendent 0072 TObject.Free 0078 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 8B D8 8B CA A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 68 00 10 00 00 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 C6 40 20 01 8B 53 6C 33 C9 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_592_0 {
	meta:
		name = "TActiveXControl.ShowPropertyDialog"
		size = 364
		refs = "0015 TActiveXControl.ShowPropertyDialog 0045 TActiveXControl.GetPages 004a OleCheck 0099 @IntfCopy 00ae @IntfDispCall 00b9 @WStrToPWChar 00cd GetSystemDefaultLCID 00d7 GetActiveWindow 00e6 OleCreatePropertyFrame 0115 @HandleFinally 012c CoFreeMem 0149 @WStrClr 0151 @IntfClear"
	strings:
		$1 = { 55 8B EC 83 C4 EC 33 D2 89 55 EC 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 83 78 44 00 74 14 8B 45 FC 8B 40 44 50 8B 00 FF 50 24 85 C0 0F 84 FC 00 00 00 8D 45 F0 50 8B 45 FC 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 7D F0 00 0F 8E B5 00 00 00 8B 45 FC 83 78 54 00 74 0E 6A 00 8B 45 FC 8B 40 54 50 8B 00 FF 50 34 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F8 8B 55 FC 85 D2 74 03 83 EA E4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 FC 8B 40 4C 50 8D 45 EC 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 EC E8 ?? ?? ?? ?? 50 6A 01 8D 45 F8 50 8B 45 F0 50 8B 45 F4 50 E8 ?? ?? ?? ?? 50 6A 00 6A 00 E8 ?? ?? ?? ?? B9 10 00 00 00 BA 10 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 83 78 54 00 74 0E 6A FF 8B 45 FC 8B 40 54 50 8B 00 FF 50 34 C3 E9 ?? ?? ?? ?? EB E1 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 00 00 00 42 FD FF FF 08 02 00 00 }
	condition:
		$1
}

rule function_593_0 {
	meta:
		name = "TActiveXControl.StdClickEvent"
		size = 36
		refs = "0007 TActiveXControl.StdClickEvent 0012 @IntfDispCall"
	strings:
		$1 = { 83 78 24 00 74 13 68 ?? ?? ?? ?? 8B 40 24 50 6A 00 E8 ?? ?? ?? ?? 83 C4 0C C3 00 00 A8 FD FF FF 00 01 00 00 }
	condition:
		$1
}

rule function_594_0 {
	meta:
		name = "TActiveXControl.StdDblClickEvent"
		size = 36
		refs = "0007 TActiveXControl.StdDblClickEvent 0012 @IntfDispCall"
	strings:
		$1 = { 83 78 24 00 74 13 68 ?? ?? ?? ?? 8B 40 24 50 6A 00 E8 ?? ?? ?? ?? 83 C4 0C C3 00 00 A7 FD FF FF 00 01 00 00 }
	condition:
		$1
}

rule function_595_0 {
	meta:
		name = "TActiveXControl.StdKeyDownEvent"
		size = 64
		refs = "0013 GetEventShift 001a TActiveXControl.StdKeyDownEvent 0025 @IntfDispCall"
	strings:
		$1 = { 55 8B EC 53 56 8B F1 8B D8 83 7B 24 00 74 1D 8A 45 08 E8 ?? ?? ?? ?? 50 56 68 ?? ?? ?? ?? 8B 43 24 50 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5E 5B 5D C2 04 00 00 00 A6 FD FF FF 00 01 02 00 82 02 00 00 }
	condition:
		$1
}

rule function_597_0 {
	meta:
		name = "TActiveXControl.StdKeyUpEvent"
		size = 64
		refs = "0013 GetEventShift 001a TActiveXControl.StdKeyUpEvent 0025 @IntfDispCall"
	strings:
		$1 = { 55 8B EC 53 56 8B F1 8B D8 83 7B 24 00 74 1D 8A 45 08 E8 ?? ?? ?? ?? 50 56 68 ?? ?? ?? ?? 8B 43 24 50 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5E 5B 5D C2 04 00 00 00 A6 FD FF FF 00 01 02 00 82 02 00 00 }
	condition:
		$1
}

rule function_596_0 {
	meta:
		name = "TActiveXControl.StdKeyPressEvent"
		size = 60
		refs = "0014 TActiveXControl.StdKeyPressEvent 001f @IntfDispCall"
	strings:
		$1 = { 53 51 8B D9 83 78 24 00 74 22 33 D2 8A 13 66 89 14 24 54 68 ?? ?? ?? ?? 8B 40 24 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 66 8B 04 24 88 03 5A 5B C3 00 A5 FD FF FF 00 01 01 00 82 00 00 00 }
	condition:
		$1
}

rule function_598_0 {
	meta:
		name = "TActiveXControl.StdMouseDownEvent"
		size = 80
		refs = "001b GetEventShift 0023 GetEventButton 0029 TActiveXControl.StdMouseDownEvent 0034 @IntfDispCall"
	strings:
		$1 = { 55 8B EC 53 56 8B D9 8B F0 83 7E 24 00 74 2C 8B 45 08 50 8B 45 0C 50 8A 45 10 E8 ?? ?? ?? ?? 50 8B C3 E8 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 8B 46 24 50 6A 00 E8 ?? ?? ?? ?? 83 C4 1C 5E 5B 5D C2 0C 00 00 00 00 A3 FD FF FF 00 01 04 00 02 02 03 03 }
	condition:
		$1
}

rule function_599_0 {
	meta:
		name = "TActiveXControl.StdMouseMoveEvent"
		size = 84
		refs = "001c GetEventShift 002f TActiveXControl.StdMouseMoveEvent 003a @IntfDispCall"
	strings:
		$1 = { 55 8B EC 51 53 88 4D FF 8B D8 83 7B 24 00 74 31 8B 45 08 50 8B 45 0C 50 8A 45 FF E8 ?? ?? ?? ?? 50 33 C0 8A 45 FF C1 E8 03 66 83 E0 07 50 68 ?? ?? ?? ?? 8B 43 24 50 6A 00 E8 ?? ?? ?? ?? 83 C4 1C 5B 59 5D C2 08 00 00 A2 FD FF FF 00 01 04 00 02 02 03 03 }
	condition:
		$1
}

rule function_600_0 {
	meta:
		name = "TActiveXControl.StdMouseUpEvent"
		size = 80
		refs = "001b GetEventShift 0023 GetEventButton 0029 TActiveXControl.StdMouseUpEvent 0034 @IntfDispCall"
	strings:
		$1 = { 55 8B EC 53 56 8B D9 8B F0 83 7E 24 00 74 2C 8B 45 08 50 8B 45 0C 50 8A 45 10 E8 ?? ?? ?? ?? 50 8B C3 E8 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 8B 46 24 50 6A 00 E8 ?? ?? ?? ?? 83 C4 1C 5E 5B 5D C2 0C 00 00 00 00 A1 FD FF FF 00 01 04 00 02 02 03 03 }
	condition:
		$1
}

rule function_601_0 {
	meta:
		name = "TActiveXControl.ViewChanged"
		size = 38
		refs = "0020 @IntfClear"
	strings:
		$1 = { 53 8B D8 83 7B 64 00 74 1B 6A FF 6A 01 8B 43 64 50 8B 00 FF 50 10 F6 43 68 04 74 08 8D 43 64 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_602_0 {
	meta:
		name = "ControlWndProc"
		size = 73
	strings:
		$1 = { 55 8B EC 53 56 8B 5D 08 8B 5B FC 8B 03 3D 00 20 00 00 72 0D 3D 00 24 00 00 73 06 81 03 00 9C 00 00 8B 45 08 8B 70 F8 8B D3 8B 46 74 FF 56 70 8B 03 3D 00 BC 00 00 72 0D 3D 00 C0 00 00 73 06 81 2B 00 9C 00 00 5E 5B 5D C3 }
	condition:
		$1
}

rule function_603_0 {
	meta:
		name = "TActiveXControl.WndProc"
		size = 580
		refs = "00cd ControlWndProc 0112 TControl.SetVisible 0127 TActiveXControl.UIDeactivate 0152 TActiveXControl.RecreateWnd 0166 TActiveXControl.ViewChanged 01d6 TActiveXControl.WndProc 01e4 @IntfDispCall 01f6 TActiveXControl.InPlaceActivate"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 89 55 FC 89 45 F8 8B 45 F8 8B 40 6C 8B B8 40 01 00 00 8B 75 FC 8B 36 81 FE 00 B0 00 00 72 0B 8B 45 FC 81 FE 00 C0 00 00 72 12 8B 45 F8 83 78 48 00 74 09 8B 45 F8 80 78 7D 00 75 04 33 DB EB 02 B3 01 84 DB 74 33 8D 45 F4 50 8B 45 FC 83 C0 0C 50 8B 45 FC 8B 40 08 50 8B 45 FC 8B 40 04 50 8B 45 FC 56 57 8B 45 F8 8B 40 48 50 8B 00 FF 50 0C 83 F8 01 0F 84 B1 01 00 00 8B 45 FC 8B 00 3D 84 00 00 00 7F 25 0F 84 F9 00 00 00 83 C0 F9 83 E8 02 72 2F 83 E8 03 0F 84 CA 00 00 00 83 E8 15 0F 84 FB 00 00 00 E9 49 01 00 00 2D 0B B0 00 00 74 44 83 E8 28 74 78 48 0F 84 A9 00 00 00 E9 31 01 00 00 55 E8 ?? ?? ?? ?? 59 8B 45 F8 83 78 44 00 0F 84 24 01 00 00 8B 45 FC 83 38 07 0F 94 C0 F6 D8 1B C0 50 8B 45 F8 8B 40 44 50 8B 00 FF 50 20 E9 05 01 00 00 8B 45 F8 8B 40 78 8B 55 F8 8B 52 6C 3B C2 74 08 8A 52 47 E8 ?? ?? ?? ?? 8B 45 F8 8B 40 78 80 78 47 00 75 09 8B 45 F8 50 E8 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 E9 CC 00 00 00 8B 45 F8 80 78 7D 00 74 1B 8B 45 F8 8B 40 6C 8B 55 F8 3B 42 78 75 0D 8B 45 F8 E8 ?? ?? ?? ?? E9 A8 00 00 00 55 E8 ?? ?? ?? ?? 59 8B 45 F8 E8 ?? ?? ?? ?? E9 94 00 00 00 55 E8 ?? ?? ?? ?? 59 8B 45 F8 80 78 7D 00 0F 85 80 00 00 00 8B 45 F8 E8 ?? ?? ?? ?? EB 76 55 E8 ?? ?? ?? ?? 59 8B 45 FC 83 78 0C FF 75 66 8B 45 FC C7 40 0C 01 00 00 00 EB 5A 55 E8 ?? ?? ?? ?? 59 8B 45 F8 80 78 7E 00 75 4A 8B 75 FC 8B 76 0C 83 FE 01 74 08 8B 45 FC 83 FE 02 75 37 8B 45 F8 83 78 4C 00 74 2E 68 ?? ?? ?? ?? 8B 45 F8 8B 40 4C 50 6A 00 E8 ?? ?? ?? ?? 83 C4 0C 66 85 C0 74 13 B2 01 8B 45 F8 E8 ?? ?? ?? ?? EB 07 55 E8 ?? ?? ?? ?? 59 84 DB 74 2C 8B 45 F4 50 8B 45 FC 83 C0 0C 50 8B 45 FC 8B 40 08 50 8B 45 FC 8B 40 04 50 8B 45 FC 8B 00 50 57 8B 45 F8 8B 40 48 50 8B 00 FF 50 10 5F 5E 5B 8B E5 5D C3 00 00 3B FD FF FF 0B 02 00 00 }
	condition:
		$1
}

rule function_604_0 {
	meta:
		name = "TActiveXControl.Get_BackColor"
		size = 62
		refs = "000e TActiveXControl.Get_BackColor 0031 @HandleAutoException"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 45 08 50 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 40 6C 8B 40 64 8B 55 0C 89 02 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_605_0 {
	meta:
		name = "TActiveXControl.Get_Caption"
		size = 95
		refs = "001b TActiveXControl.Get_Caption 002c TControl.GetText 0037 @WStrFromLStr 0049 @HandleAutoException 0051 @LStrClr"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B 5D 08 8B 45 0C 85 C0 74 04 33 D2 89 10 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B 43 6C E8 ?? ?? ?? ?? 8B 55 FC 8B 45 0C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_611_0 {
	meta:
		name = "TActiveXControl.Get_Text"
		size = 95
		refs = "001b TActiveXControl.Get_Text 002c TControl.GetText 0037 @WStrFromLStr 0049 @HandleAutoException 0051 @LStrClr"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B 5D 08 8B 45 0C 85 C0 74 04 33 D2 89 10 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B 43 6C E8 ?? ?? ?? ?? 8B 55 FC 8B 45 0C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_606_0 {
	meta:
		name = "TActiveXControl.Get_Enabled"
		size = 69
		refs = "000e TActiveXControl.Get_Enabled 0038 @HandleAutoException"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 5D 08 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 43 6C 8B 10 FF 52 50 F6 D8 1B C0 8B 55 0C 66 89 02 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_607_0 {
	meta:
		name = "TActiveXControl.Get_Font"
		size = 76
		refs = "0019 TActiveXControl.Get_Font 002d GetOleFont 003f @HandleAutoException"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 5D 08 8B 45 0C 85 C0 74 04 33 D2 89 10 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 0C 8B 43 6C 8B 40 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_608_0 {
	meta:
		name = "TActiveXControl.Get_ForeColor"
		size = 65
		refs = "000e TActiveXControl.Get_ForeColor 0034 @HandleAutoException"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 45 08 50 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 40 6C 8B 40 58 8B 40 14 8B 55 0C 89 02 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_609_0 {
	meta:
		name = "TActiveXControl.Get_HWnd"
		size = 64
		refs = "000e TActiveXControl.Get_HWnd 001c TWinControl.GetHandle 0033 @HandleAutoException"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 5D 08 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 43 6C E8 ?? ?? ?? ?? 8B 55 0C 89 02 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_610_0 {
	meta:
		name = "TActiveXControl.Get_TabStop"
		size = 70
		refs = "000e TActiveXControl.Get_TabStop 0039 @HandleAutoException"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 45 08 50 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 40 6C 8A 80 78 01 00 00 F6 D8 1B C0 8B 55 0C 66 89 02 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_612_0 {
	meta:
		name = "TActiveXControl.Set_BackColor"
		size = 62
		refs = "000e TActiveXControl.Set_BackColor 001f TControl.SetColor 0031 @HandleAutoException"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 45 08 50 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 55 0C 8B 40 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_613_0 {
	meta:
		name = "TActiveXControl.Set_Caption"
		size = 84
		refs = "0010 TActiveXControl.Set_Caption 0021 @LStrFromWStr 002c TControl.SetText 003e @HandleAutoException 0046 @LStrClr"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B 5D 08 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 8B 55 0C E8 ?? ?? ?? ?? 8B 55 FC 8B 43 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_618_0 {
	meta:
		name = "TActiveXControl.Set_Text"
		size = 84
		refs = "0010 TActiveXControl.Set_Text 0021 @LStrFromWStr 002c TControl.SetText 003e @HandleAutoException 0046 @LStrClr"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B 5D 08 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 8B 55 0C E8 ?? ?? ?? ?? 8B 55 FC 8B 43 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_614_0 {
	meta:
		name = "TActiveXControl.Set_Enabled"
		size = 70
		refs = "000e TActiveXControl.Set_Enabled 0039 @HandleAutoException"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 45 08 50 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 66 8B 55 0C 66 F7 DA 1B D2 F7 DA 8B 40 6C 8B 08 FF 51 60 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_615_0 {
	meta:
		name = "TActiveXControl.Set_Font"
		size = 65
		refs = "000e TActiveXControl.Set_Font 0022 SetOleFont 0034 @HandleAutoException"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 45 08 50 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 40 6C 8B 40 58 8B 55 0C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_616_0 {
	meta:
		name = "TActiveXControl.Set_ForeColor"
		size = 65
		refs = "000e TActiveXControl.Set_ForeColor 0022 TFont.SetColor 0034 @HandleAutoException"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 45 08 50 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 40 6C 8B 40 58 8B 55 0C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_617_0 {
	meta:
		name = "TActiveXControl.Set_TabStop"
		size = 70
		refs = "000e TActiveXControl.Set_TabStop 0027 TWinControl.SetTabStop 0039 @HandleAutoException"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 45 08 50 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 66 8B 55 0C 66 F7 DA 1B D2 F7 DA 8B 40 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_619_0 {
	meta:
		name = "TActiveXControl.GetClassID"
		size = 34
		altNames = "TActiveXControl.GetUserClassID"
	strings:
		$1 = { 55 8B EC 56 57 8B 45 08 8B 40 08 8B 55 0C 8D 70 10 8B FA B9 04 00 00 00 F3 A5 33 C0 5F 5E 5D C2 08 00 }
	condition:
		$1
}

rule function_621_0 {
	meta:
		name = "TActiveXControl.PersistPropBagLoad"
		size = 452
		refs = "0018 TActiveXControl.PersistPropBagLoad 004b _Dn_TStringList 0050 TObject.Create 007c @IntfCast 0085 GUID_NULL 008c EnumDispatchProperties 00d7 @WStrFromLStr 0100 @HandleAnyException 0105 ExceptObject 010b _Dn_EAbort 0110 @IsClass 011e @DoneExcept 0123 @TryFinallyExit 0153 TObject.Free 0159 @HandleFinally 0171 HandleException 018d @LStrClr 0195 @WStrClr 019d @IntfClear"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 56 57 33 C0 89 45 EC 89 45 E8 89 45 F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 7D 0C 00 75 12 BB 03 40 00 80 33 C0 5A 59 59 64 89 10 E9 34 01 00 00 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 50 8D 45 F0 8B 55 08 85 D2 74 03 83 EA E4 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F0 8B 15 ?? ?? ?? ?? 33 C9 E8 ?? ?? ?? ?? 8B 45 FC 8B 10 FF 52 14 48 85 C0 0F 8C A1 00 00 00 40 89 45 F4 C7 45 F8 00 00 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 0C 50 8B 45 10 50 8D 4D E8 8B 55 F8 8B 45 FC 8B 18 FF 53 0C 8B 55 E8 8D 45 EC E8 ?? ?? ?? ?? 8B 45 EC 50 8B 55 F8 8B 45 FC 8B 08 FF 51 18 8B C8 8B 45 08 5A 8B 18 FF 53 3C 33 C0 5A 59 59 64 89 10 EB 37 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 19 BB 05 40 00 80 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 4B E8 ?? ?? ?? ?? FF 45 F8 FF 4D F4 0F 85 6A FF FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 DB 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 8B C3 5F 5E 5B 8B E5 5D C2 0C 00 00 04 02 00 00 00 00 00 C0 00 00 00 00 00 00 46 }
	condition:
		$1
}

rule function_622_0 {
	meta:
		name = "TActiveXControl.PersistPropBagSave"
		size = 356
		refs = "0010 TActiveXControl.PersistPropBagSave 0043 _Dn_TStringList 0048 TObject.Create 0074 @IntfCast 007d GUID_NULL 0084 EnumDispatchProperties 00b2 @WStrFromLStr 00e4 TObject.Free 00ea @HandleFinally 010a @HandleAnyException 010f HandleException 0116 @DoneExcept 012b @LStrClr 0133 @WStrClr 013b @IntfClear"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 53 56 57 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 7D 0C 00 75 12 BB 03 40 00 80 33 C0 5A 59 59 64 89 10 E9 DA 00 00 00 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 50 8D 45 F8 8B 55 08 85 D2 74 03 83 EA E4 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F8 8B 15 ?? ?? ?? ?? 33 C9 E8 ?? ?? ?? ?? 8B 45 FC 8B 10 FF 52 14 8B F0 4E 85 F6 7C 3C 46 33 DB 8B 45 0C 50 8D 4D F0 8B D3 8B 45 FC 8B 38 FF 57 0C 8B 55 F0 8D 45 F4 E8 ?? ?? ?? ?? 8B 45 F4 50 8B D3 8B 45 FC 8B 08 FF 51 18 8B C8 8B 45 08 5A 8B 38 FF 57 4C 43 4E 75 C7 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 83 7D 10 00 74 07 8B 45 08 C6 40 7C 00 33 DB 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 8B C3 5F 5E 5B 8B E5 5D C2 10 00 00 00 00 04 02 00 00 00 00 00 C0 00 00 00 00 00 00 46 }
	condition:
		$1
}

rule function_623_0 {
	meta:
		name = "TActiveXControl.IsDirty"
		size = 25
	strings:
		$1 = { 55 8B EC 8B 45 08 80 78 7C 00 74 04 33 C0 EB 05 B8 01 00 00 00 5D C2 04 00 }
	condition:
		$1
}

rule function_624_0 {
	meta:
		name = "TActiveXControl.PersistStreamLoad"
		size = 75
		refs = "000d TActiveXControl.PersistStreamLoad 0032 @HandleAnyException 0037 HandleException 003e @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 5D 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 0C 8B C3 8B 08 FF 51 44 C6 43 7C 00 33 DB 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_625_0 {
	meta:
		name = "TActiveXControl.PersistStreamSave"
		size = 81
		refs = "000d TActiveXControl.PersistStreamSave 0038 @HandleAnyException 003d HandleException 0044 @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 5D 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 0C 8B C3 8B 08 FF 51 50 83 7D 10 00 74 04 C6 43 7C 00 33 DB 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 0C 00 }
	condition:
		$1
}

rule function_627_0 {
	meta:
		name = "TActiveXControl.InitNew"
		size = 65
		refs = "000d TActiveXControl.InitNew 0028 @HandleAnyException 002d HandleException 0034 @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 45 08 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 C6 40 7C 00 33 DB 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_628_0 {
	meta:
		name = "TActiveXControl.PersistStorageInitNew"
		size = 16
		refs = "0008 TActiveXControl.InitNew"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 5D C2 08 00 }
	condition:
		$1
}

rule function_629_0 {
	meta:
		name = "TActiveXControl.PersistStorageLoad"
		size = 196
		refs = "000f TActiveXControl.PersistStorageLoad 002b @IntfClear 0045 OleCheck 0064 @HandleAnyException 0069 HandleException 0070 @DoneExcept 008b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B 5D 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 50 6A 00 6A 10 6A 00 68 ?? ?? ?? ?? 8B 45 0C 50 8B 00 FF 50 10 E8 ?? ?? ?? ?? 8B 55 FC 8B C3 8B 08 FF 51 44 C6 43 7C 00 33 DB 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5F 5E 5B 59 5D C2 08 00 00 43 00 4F 00 4E 00 54 00 52 00 4F 00 4C 00 53 00 41 00 56 00 45 00 53 00 54 00 52 00 45 00 41 00 4D 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_630_0 {
	meta:
		name = "TActiveXControl.PersistStorageSave"
		size = 196
		refs = "000f TActiveXControl.PersistStorageSave 002b @IntfClear 0048 OleCheck 0063 @HandleAnyException 0068 HandleException 006f @DoneExcept 008a @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B 5D 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 50 6A 00 6A 00 68 11 10 00 00 68 ?? ?? ?? ?? 8B 45 0C 50 8B 00 FF 50 0C E8 ?? ?? ?? ?? 8B 55 FC 8B C3 8B 08 FF 51 50 33 DB 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5F 5E 5B 59 5D C2 0C 00 00 00 43 00 4F 00 4E 00 54 00 52 00 4F 00 4C 00 53 00 41 00 56 00 45 00 53 00 54 00 52 00 45 00 41 00 4D 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_631_0 {
	meta:
		name = "TActiveXControl.SaveCompleted"
		size = 16
	strings:
		$1 = { 55 8B EC 8B 45 08 C6 40 7C 00 33 C0 5D C2 08 00 }
	condition:
		$1
}

rule function_633_0 {
	meta:
		name = "TActiveXControl.GetInterfaceSafetyOptions"
		size = 139
		refs = "0012 TActiveXControl.GetInterfaceSafetyOptions 0031 @IntfClear 003c TComObject.QueryInterface 007b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B 7D 10 8B 5D 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 FF 74 06 83 7D 14 00 75 07 BE 03 40 00 80 EB 37 8D 45 FC E8 ?? ?? ?? ?? 50 8B 45 0C 50 53 E8 ?? ?? ?? ?? 8B F0 85 F6 75 13 C7 07 03 00 00 00 8B 43 3C 83 E0 03 8B 55 14 89 02 EB 0B 33 C0 89 07 8B 45 14 33 D2 89 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 5F 5E 5B 59 5D C2 10 00 }
	condition:
		$1
}

rule function_634_0 {
	meta:
		name = "TActiveXControl.SetInterfaceSafetyOptions"
		size = 96
		refs = "000e TActiveXControl.SetInterfaceSafetyOptions 001c @IntfClear 0027 TComObject.QueryInterface 0051 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B 5D 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 50 8B 45 0C 50 53 E8 ?? ?? ?? ?? 8B F0 85 F6 75 09 8B 45 14 23 45 10 89 43 3C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 5E 5B 59 5D C2 10 00 }
	condition:
		$1
}

rule function_635_0 {
	meta:
		name = "TActiveXControl.SetClientSite"
		size = 204
		refs = "0022 @IntfCopy 002a @IntfClear 0030 TActiveXControl.SetClientSite 006c TActiveXControl.OnAmbientPropertyChange"
	strings:
		$1 = { 55 8B EC 53 56 8B 75 0C 8B 5D 08 85 F6 74 63 83 7B 40 00 74 07 B8 05 40 00 80 EB 78 8D 43 40 8B D6 E8 ?? ?? ?? ?? 8D 43 44 E8 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 56 8B 06 FF 10 8B 43 30 F6 40 72 01 74 13 8D 43 48 E8 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 56 8B 06 FF 10 8D 43 4C E8 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 56 8B 06 FF 10 6A 00 53 E8 ?? ?? ?? ?? EB 20 8D 43 4C E8 ?? ?? ?? ?? 8D 43 48 E8 ?? ?? ?? ?? 8D 43 44 E8 ?? ?? ?? ?? 8D 43 40 E8 ?? ?? ?? ?? 33 C0 5E 5B 5D C2 08 00 00 00 89 B2 96 B1 B4 BA 1A 10 B6 9C 00 AA 00 34 1D 07 01 0E 2B 74 E6 14 1B 10 91 4E 00 AA 00 30 0C AB 00 04 02 00 00 00 00 00 C0 00 00 00 00 00 00 46 }
	condition:
		$1
}

rule function_636_0 {
	meta:
		name = "TActiveXControl.GetClientSite"
		size = 36
		refs = "0019 @IntfCopy"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 8B 45 0C 85 C0 74 04 33 D2 89 10 8B 45 0C 8B 53 40 E8 ?? ?? ?? ?? 33 C0 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_637_0 {
	meta:
		name = "TActiveXControl.SetHostNames"
		size = 9
		altNames = "TDataSet.CurrToBCD TOleControl.SetActiveObject TOleUILinkInfo.GetLastUpdate"
	strings:
		$1 = { 55 8B EC 33 C0 5D C2 0C 00 }
	condition:
		$1
}

rule function_638_0 {
	meta:
		name = "TActiveXControl.Close"
		size = 45
		refs = "0024 TActiveXControl.InPlaceDeactivate"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 83 7D 0C 01 74 15 80 7B 7C 00 74 0F 83 7B 40 00 74 09 8B 43 40 50 8B 00 FF 50 0C 53 E8 ?? ?? ?? ?? 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_640_0 {
	meta:
		name = "TActiveXControl.GetMoniker"
		size = 23
		altNames = "TOleControl.GetMoniker"
	strings:
		$1 = { 55 8B EC 8B 45 14 85 C0 74 04 33 D2 89 10 B8 01 40 00 80 5D C2 10 00 }
	condition:
		$1
}

rule function_641_0 {
	meta:
		name = "TActiveXControl.InitFromData"
		size = 12
		altNames = "TActiveXControl.SetData TCorbaDispatchStub.GetTypeInfo TDataObject.SetData"
	strings:
		$1 = { 55 8B EC B8 01 40 00 80 5D C2 10 00 }
	condition:
		$1
}

rule function_642_0 {
	meta:
		name = "TActiveXControl.EnumFormatEtc"
		size = 23
		altNames = "TActiveXControl.GetClipboardData"
	strings:
		$1 = { 55 8B EC 8B 45 10 85 C0 74 04 33 D2 89 10 B8 01 40 00 80 5D C2 0C 00 }
	condition:
		$1
}

rule function_643_0 {
	meta:
		name = "TActiveXControl.DoVerb"
		size = 197
		refs = "0010 TActiveXControl.DoVerb 0050 TActiveXControl.InPlaceActivate 006b TControl.SetVisible 0076 TActiveXControl.ShowPropertyDialog 0087 TStrings.IndexOfObject 00ac @HandleAnyException 00b1 HandleException 00b8 @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 75 0C 8B 5D 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 83 C0 07 83 F8 07 77 5A FF 24 85 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? B2 01 8B C3 E8 ?? ?? ?? ?? 8B D8 EB 49 33 D2 8B C3 E8 ?? ?? ?? ?? 8B D8 EB 3C 8B 43 78 33 D2 E8 ?? ?? ?? ?? 33 DB EB 2E 8B C3 E8 ?? ?? ?? ?? 33 DB EB 23 8B 43 30 8B 40 78 8B D6 E8 ?? ?? ?? ?? 85 C0 7C 0D 8B D6 8B C3 8B 08 FF 51 48 33 DB EB 05 BB 80 01 04 00 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 1C 00 }
	condition:
		$1
}

rule function_644_0 {
	meta:
		name = "TActiveXControl.EnumVerbs"
		size = 44
		refs = "0016 @IntfClear 0023 OleRegEnumVerbs"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 8B 45 0C 85 C0 74 04 33 D2 89 10 8B 45 0C E8 ?? ?? ?? ?? 50 8B 43 08 83 C0 10 50 E8 ?? ?? ?? ?? 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_648_0 {
	meta:
		name = "TActiveXControl.GetUserType"
		size = 30
		refs = "0016 OleRegGetUserType"
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 55 10 52 8B 55 0C 52 8B 40 08 83 C0 10 50 E8 ?? ?? ?? ?? 5D C2 0C 00 }
	condition:
		$1
}

rule function_649_0 {
	meta:
		name = "TActiveXControl.SetExtent"
		size = 152
		refs = "0010 TActiveXControl.SetExtent 0026 OleError 0030 Screen 003e MulDiv 007f @HandleAnyException 0084 HandleException 008b @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 75 10 8B 5D 08 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 83 7D 0C 01 74 0A B8 6B 00 04 80 E8 ?? ?? ?? ?? 68 EC 09 00 00 A1 ?? ?? ?? ?? 8B 00 8B 40 34 50 8B 06 50 E8 ?? ?? ?? ?? 8B F8 68 EC 09 00 00 A1 ?? ?? ?? ?? 8B 00 8B 40 34 50 8B 46 04 50 E8 ?? ?? ?? ?? 8B F0 8B 43 78 57 56 8B 48 34 8B 50 30 8B 18 FF 93 80 00 00 00 33 DB 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 0C 00 }
	condition:
		$1
}

rule function_650_0 {
	meta:
		name = "TActiveXControl.GetExtent"
		size = 93
		refs = "0019 Screen 0030 MulDiv"
	strings:
		$1 = { 55 8B EC 53 56 8B 75 10 8B 5D 08 83 7D 0C 01 74 07 B8 6B 00 04 80 EB 3F A1 ?? ?? ?? ?? 8B 00 8B 40 34 50 68 EC 09 00 00 8B 43 78 8B 40 38 50 E8 ?? ?? ?? ?? 89 06 A1 ?? ?? ?? ?? 8B 00 8B 40 34 50 68 EC 09 00 00 8B 43 78 8B 40 3C 50 E8 ?? ?? ?? ?? 89 46 04 33 C0 5E 5B 5D C2 0C 00 }
	condition:
		$1
}

rule function_651_0 {
	meta:
		name = "TActiveXControl.Advise"
		size = 40
		refs = "000a TActiveXControl.CreateAdviseHolder"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 8B C3 E8 ?? ?? ?? ?? 85 C0 75 11 8B 45 10 50 8B 45 0C 50 8B 43 5C 50 8B 00 FF 50 0C 5B 5D C2 0C 00 }
	condition:
		$1
}

rule function_652_0 {
	meta:
		name = "TActiveXControl.Unadvise"
		size = 36
		refs = "000a TActiveXControl.CreateAdviseHolder"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 8B C3 E8 ?? ?? ?? ?? 85 C0 75 0D 8B 45 0C 50 8B 43 5C 50 8B 00 FF 50 10 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_653_0 {
	meta:
		name = "TActiveXControl.EnumAdvise"
		size = 52
		refs = "0015 TActiveXControl.CreateAdviseHolder 0021 @IntfClear"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 8B 45 0C 85 C0 74 04 33 D2 89 10 8B C3 E8 ?? ?? ?? ?? 85 C0 75 12 8B 45 0C E8 ?? ?? ?? ?? 50 8B 43 5C 50 8B 00 FF 50 14 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_654_0 {
	meta:
		name = "TActiveXControl.GetMiscStatus"
		size = 36
	strings:
		$1 = { 55 8B EC 8B 45 08 83 7D 0C 01 74 07 B8 6B 00 04 80 EB 0D 8B 40 30 8B 40 70 8B 55 10 89 02 33 C0 5D C2 0C 00 }
	condition:
		$1
}

rule function_656_0 {
	meta:
		name = "TActiveXControl.GetControlInfo"
		size = 34
	strings:
		$1 = { 55 8B EC 8B 45 0C C7 00 10 00 00 00 33 D2 89 50 04 66 C7 40 08 00 00 33 D2 89 50 0C 33 C0 5D C2 08 00 }
	condition:
		$1
}

rule function_657_0 {
	meta:
		name = "TActiveXControl.OnDocWindowActivate"
		size = 17
		refs = "0009 TActiveXControl.InPlaceActivate"
		altNames = "TActiveXControl.OnMnemonic"
	strings:
		$1 = { 55 8B EC 8B 45 08 B2 01 E8 ?? ?? ?? ?? 5D C2 08 00 }
	condition:
		$1
}

rule function_658_0 {
	meta:
		name = "TActiveXControl.OnAmbientPropertyChange"
		size = 368
		refs = "0012 TActiveXControl.OnAmbientPropertyChange 0054 @IntfDispCall 0069 TControl.Perform 0078 @HandleAnyException 007d @DoneExcept 009b _Dn_TFont 00a0 TFont.Create 00d1 TFont.SetColor 00f4 SetOleFont 0129 TObject.Free 0140 @IntfClear 0146 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 33 C0 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 58 78 85 DB 0F 84 03 01 00 00 8B 45 08 83 78 4C 00 0F 84 F6 00 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 68 ?? ?? ?? ?? 8B 45 08 8B 40 4C 50 6A 00 E8 ?? ?? ?? ?? 83 C4 0C 50 8B C3 B9 01 00 00 00 BA 09 B0 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 0A E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 01 8B 45 08 8B 40 78 B9 01 00 00 00 BA 11 B0 00 00 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 68 ?? ?? ?? ?? 8B 45 08 8B 40 4C 50 6A 00 E8 ?? ?? ?? ?? 83 C4 0C 8B D0 8B 45 FC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 08 8B 40 4C 50 8D 45 F8 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 F8 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 50 8B 45 08 8B 40 78 B9 01 00 00 00 BA 08 B0 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 0A E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5F 5E 5B 59 59 5D C2 08 00 00 43 FD FF FF 03 02 00 00 40 FD FF FF 03 02 00 00 41 FD FF FF 09 02 00 00 }
	condition:
		$1
}

rule function_659_0 {
	meta:
		name = "TActiveXControl.FreezeEvents"
		size = 24
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 55 0C F7 DA 1B D2 F7 DA 88 50 7F 33 C0 5D C2 08 00 }
	condition:
		$1
}

rule function_660_0 {
	meta:
		name = "TActiveXControl.GetWindow"
		size = 46
		refs = "000b TWinControl.HandleAllocated 0017 TWinControl.GetHandle"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 8B 43 78 E8 ?? ?? ?? ?? 84 C0 74 11 8B 43 78 E8 ?? ?? ?? ?? 8B 55 0C 89 02 33 C0 EB 05 B8 05 40 00 80 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_662_0 {
	meta:
		name = "TActiveXControl.InPlaceDeactivate"
		size = 98
		refs = "000f TActiveXControl.UIDeactivate 001d TControl.SetVisible 0022 ParkingWindow 002c TWinControl.SetParentWindow 0034 @IntfClear"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 80 7B 7D 00 74 44 53 E8 ?? ?? ?? ?? C6 43 7D 00 33 D2 8B 43 78 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B 43 78 E8 ?? ?? ?? ?? 8D 43 58 E8 ?? ?? ?? ?? 8D 43 54 E8 ?? ?? ?? ?? 8B 43 50 50 8B 00 FF 50 2C 8D 43 50 E8 ?? ?? ?? ?? 33 D2 8B 43 78 E8 ?? ?? ?? ?? 33 C0 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_663_0 {
	meta:
		name = "TActiveXControl.UIDeactivate"
		size = 67
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 80 7B 7E 00 74 2F 83 7B 58 00 74 0D 6A 00 6A 00 8B 43 58 50 8B 00 FF 50 20 6A 00 6A 00 8B 43 54 50 8B 00 FF 50 20 6A 00 8B 43 50 50 8B 00 FF 50 28 C6 43 7E 00 33 C0 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_664_0 {
	meta:
		name = "TActiveXControl.SetObjectRects"
		size = 72
		refs = "000d TActiveXControl.SetObjectRects 001e TControl.SetBoundsRect 002f @HandleAnyException 0034 HandleException 003b @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 45 08 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 55 0C 8B 40 78 E8 ?? ?? ?? ?? 33 DB 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 0C 00 }
	condition:
		$1
}

rule function_666_0 {
	meta:
		name = "TActiveXControl.TranslateAccelerator"
		size = 348
		refs = "0026 FindControl 0034 GetParent 0065 TControl.Perform 00eb TranslateMessage 00f1 DispatchMessage 0109 GetParentForm 0137 GetKeyModifiers"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B 5D 0C 8B 43 04 3D 00 01 00 00 0F 82 15 01 00 00 3D 08 01 00 00 0F 87 0A 01 00 00 8B 03 E8 ?? ?? ?? ?? 8B F8 85 FF 75 1F 8B 33 56 E8 ?? ?? ?? ?? 8B F0 85 F6 74 09 8B C6 E8 ?? ?? ?? ?? 8B F8 85 F6 74 04 85 FF 74 E3 85 FF 0F 84 D6 00 00 00 33 F6 57 8B 4B 08 BA 2E B0 00 00 8B C7 E8 ?? ?? ?? ?? 85 C0 0F 85 E1 00 00 00 33 C0 89 45 FC 8B 43 08 83 F8 1B 7F 13 74 32 83 E8 03 74 2D 83 E8 06 74 16 83 E8 04 74 23 EB 28 83 C0 DF 83 E8 08 72 10 83 E8 02 74 14 EB 19 C7 45 FC 02 00 00 00 EB 10 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 04 00 00 00 83 7D FC 00 74 38 6A 00 8B 4B 08 BA 1E B0 00 00 8B C7 E8 ?? ?? ?? ?? 85 C0 75 15 6A 00 33 C9 BA 87 00 00 00 8B C7 E8 ?? ?? ?? ?? 23 45 FC 74 0E 53 E8 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? EB 5B 81 7B 04 00 01 00 00 75 11 83 7F 24 00 74 0B 8B C7 E8 ?? ?? ?? ?? 8B F8 EB 02 33 FF 85 FF 74 16 8B 43 0C 50 8B 4B 08 BA 05 B0 00 00 8B C7 E8 ?? ?? ?? ?? 48 74 25 8B 45 08 83 78 44 00 74 17 E8 ?? ?? ?? ?? 50 53 8B 45 08 8B 40 44 50 8B 00 FF 50 1C 8B F0 EB 05 BE 01 00 00 00 8B C6 5F 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_667_0 {
	meta:
		name = "TActiveXControl.OnFrameWindowActivate"
		size = 49
		refs = "000d TActiveXControl.InPlaceActivate 0016 Succeeded"
	strings:
		$1 = { 55 8B EC 53 56 8B 5D 08 B2 01 8B C3 E8 ?? ?? ?? ?? 8B F0 8B C6 E8 ?? ?? ?? ?? 84 C0 74 0B 8B 43 78 8B 10 FF 92 B4 00 00 00 8B C6 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_669_0 {
	meta:
		name = "TActiveXControl.ResizeBorder"
		size = 9
	strings:
		$1 = { 55 8B EC 33 C0 5D C2 10 00 }
	condition:
		$1
}

rule function_670_0 {
	meta:
		name = "TActiveXControl.EnableModeless"
		size = 9
		altNames = "TAdapterNotifier.OnRequestEdit TOleContainer.ContextSensitiveHelp TOleControl.ContextSensitiveHelp TOleControl.EnableModeless TOleControl.OnRequestEdit TOleControl.OnShowWindow TOleControl.SetStatusText TOleForm.ContextSensitiveHelp TOleForm.EnableModeless TStreamAdapter.Commit"
	strings:
		$1 = { 55 8B EC 33 C0 5D C2 08 00 }
	condition:
		$1
}

rule function_671_0 {
	meta:
		name = "TActiveXControl.Draw"
		size = 318
		refs = "000d TActiveXControl.Draw 0023 OleError 0044 TControl.SetVisible 0051 TWinControl.GetHandle 0057 ShowWindow 0075 LPtoDP 007e SaveDC 009e SetViewportOrgEx 00ad SetWindowOrgEx 00b8 SetMapMode 00cd TWinControl.PaintTo 00e7 RestoreDC 00ed @HandleFinally 0123 @HandleAnyException 0128 HandleException 012f @DoneExcept"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 56 57 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 83 7D 0C 01 74 0A B8 6B 00 04 80 E8 ?? ?? ?? ?? 8B 45 08 8B 40 6C 8A 50 47 88 55 FB 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 B2 01 E8 ?? ?? ?? ?? 6A 01 8B 45 08 8B 40 78 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 45 24 8B F0 8D 7D E8 B9 04 00 00 00 F3 A5 6A 02 8D 45 E8 50 8B 45 20 50 E8 ?? ?? ?? ?? 8B 45 20 50 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 6A 00 6A 00 6A 00 8B 45 20 50 E8 ?? ?? ?? ?? 6A 00 6A 00 6A 00 8B 45 20 50 E8 ?? ?? ?? ?? 6A 01 8B 45 20 50 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 45 08 8B 40 6C 8B 4D E8 8B 55 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 50 8B 45 20 50 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 08 8B 40 6C 8A 55 FB E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EA 33 DB 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 8B E5 5D C2 2C 00 }
	condition:
		$1
}

rule function_672_0 {
	meta:
		name = "TActiveXControl.GetColorSet"
		size = 12
	strings:
		$1 = { 55 8B EC B8 01 40 00 80 5D C2 1C 00 }
	condition:
		$1
}

rule function_673_0 {
	meta:
		name = "TActiveXControl.Freeze"
		size = 12
	strings:
		$1 = { 55 8B EC B8 01 40 00 80 5D C2 14 00 }
	condition:
		$1
}

rule function_675_0 {
	meta:
		name = "TActiveXControl.SetAdvise"
		size = 57
		refs = "0021 @IntfCopy 002e TActiveXControl.ViewChanged"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 F6 45 0C 01 75 07 B8 6B 00 04 80 EB 20 8B 45 10 89 43 68 8D 43 64 8B 55 14 E8 ?? ?? ?? ?? F6 43 68 02 74 07 8B C3 E8 ?? ?? ?? ?? 33 C0 5B 5D C2 10 00 }
	condition:
		$1
}

rule function_676_0 {
	meta:
		name = "TActiveXControl.GetAdvise"
		size = 72
		refs = "003b @IntfCopy"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 7D 10 8B 75 0C 8B 5D 08 8B 45 14 85 C0 74 04 33 D2 89 10 85 F6 74 06 C7 06 01 00 00 00 85 FF 74 05 8B 43 68 89 07 8B 45 14 85 C0 74 0B 8B 45 14 8B 53 64 E8 ?? ?? ?? ?? 33 C0 5F 5E 5B 5D C2 10 00 }
	condition:
		$1
}

rule function_677_0 {
	meta:
		name = "TActiveXControl.ViewObjectGetExtent"
		size = 24
		refs = "0010 TActiveXControl.GetExtent"
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 55 18 52 8B 55 0C 52 50 E8 ?? ?? ?? ?? 5D C2 14 00 }
	condition:
		$1
}

rule function_678_0 {
	meta:
		name = "TActiveXControl.GetDisplayString"
		size = 108
		refs = "0019 TActiveXControl.GetDisplayString 0040 @WStrFromLStr 0057 @LStrClr 005d @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B 5D 08 8B 45 10 85 C0 74 04 33 D2 89 10 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 BE 01 40 00 80 8D 4D FC 8B 55 0C 8B C3 8B 18 FF 53 30 84 C0 74 0D 8B 45 10 8B 55 FC E8 ?? ?? ?? ?? 33 F6 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 5E 5B 59 5D C2 0C 00 }
	condition:
		$1
}

rule function_679_0 {
	meta:
		name = "TActiveXControl.MapPropertyToPage"
		size = 40
		refs = "000e GUID_NULL"
	strings:
		$1 = { 55 8B EC 56 57 8B 45 10 85 C0 74 11 8B 15 ?? ?? ?? ?? 8B F2 8B F8 B9 04 00 00 00 F3 A5 B8 01 40 00 80 5F 5E 5D C2 0C 00 }
	condition:
		$1
}

rule function_680_0 {
	meta:
		name = "TActiveXControl.GetPredefinedStrings"
		size = 455
		refs = "0015 TActiveXControl.GetPredefinedStrings 0077 _Dn_TStringList 007c TObject.Create 00ba CoAllocMem 00e7 CoAllocString 0146 TObject.Free 014c @HandleFinally 015d @HandleAnyException 0179 CoFreeMem 0192 HandleException 019a @DoneExcept 01af @LStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 56 57 33 C0 89 45 E8 8B 5D 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 89 45 F8 33 C0 89 45 F4 33 C0 89 45 EC 8B 45 10 85 C0 74 07 8B 45 14 85 C0 75 0C C7 45 FC 03 40 00 80 E9 56 01 00 00 8B 45 10 33 D2 89 10 8B 45 10 33 D2 89 50 04 8B 45 14 33 D2 89 10 8B 45 14 33 D2 89 50 04 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 4D F0 8B 55 0C 8B C3 8B 18 FF 53 34 84 C0 0F 84 88 00 00 00 8B 45 F0 8B 10 FF 52 14 89 45 EC 8B 5D EC C1 E3 02 8B C3 E8 ?? ?? ?? ?? 89 45 F8 8B C3 E8 ?? ?? ?? ?? 89 45 F4 8B 75 EC 4E 85 F6 7C 32 46 33 DB 8D 4D E8 8B D3 8B 45 F0 8B 38 FF 57 0C 8B 45 E8 E8 ?? ?? ?? ?? 8B 55 F8 89 04 9A 8B D3 8B 45 F0 8B 08 FF 51 18 8B 55 F4 89 04 9A 43 4E 75 D1 8B 45 10 8B 55 EC 89 10 8B 45 10 8B 55 F8 89 50 04 8B 45 14 8B 55 EC 89 10 8B 45 14 8B 55 F4 89 50 04 33 C0 89 45 FC EB 07 C7 45 FC 01 40 00 80 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 EB 42 E9 ?? ?? ?? ?? 83 7D F8 00 74 1A 8B 75 EC 4E 85 F6 7C 12 46 33 DB 8B 45 F8 8B 04 98 E8 ?? ?? ?? ?? 43 4E 75 F1 8B 45 F4 E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 FC 5F 5E 5B 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule function_681_0 {
	meta:
		name = "TActiveXControl.GetPredefinedValue"
		size = 118
		refs = "0028 TActiveXControl.GetPredefinedValue 004a @VarCopy 0061 @VarClr 0067 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 53 8B 5D 08 8B 45 14 8B 55 14 85 D2 74 0D 33 C9 89 4A 0C 89 4A 08 89 4A 04 89 0A 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 50 8B 4D 10 8B 55 0C 8B C3 8B 18 FF 53 38 8B 45 14 8D 55 F0 E8 ?? ?? ?? ?? 33 DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule function_682_0 {
	meta:
		name = "TPropPages.ProcessPage"
		size = 34
	strings:
		$1 = { 53 56 57 8B 58 04 85 DB 74 11 8B 48 08 03 C9 8D 3C CB 8B F2 B9 04 00 00 00 F3 A5 FF 40 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_683_0 {
	meta:
		name = "TActiveXControl.GetPages"
		size = 224
		refs = "0011 TActiveXControl.GetPages 001e _DV_TPropPages 0023 TObject.Create 003d TPropPages.ProcessPage 0052 CoAllocMem 00a5 CoFreeMem 00ad TObject.Free 00b3 @HandleFinally 00c6 @HandleAnyException 00cb HandleException 00d2 @DoneExcept"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B 75 0C 8B 5D 08 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 FC 50 68 ?? ?? ?? ?? 8B C3 8B 10 FF 52 2C 8B 45 FC 8B 40 08 C1 E0 04 E8 ?? ?? ?? ?? 8B 55 FC 89 42 04 8B 45 FC 33 D2 89 50 08 8B 45 FC 50 68 ?? ?? ?? ?? 8B C3 8B 10 FF 52 2C 8B 45 FC 8B 40 08 89 06 8B 45 FC 8B 40 04 89 46 04 8B 45 FC 33 D2 89 50 04 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 40 04 85 C0 74 05 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E1 33 DB 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_684_0 {
	meta:
		name = "TActiveXControl.PreMessageFilter"
		size = 53
	strings:
		$1 = { 55 8B EC 8B 45 08 83 78 48 00 74 23 8B 55 20 52 8B 55 1C 52 8B 55 18 52 8B 55 14 52 8B 55 10 52 8B 55 0C 52 8B 40 48 50 8B 00 FF 50 0C EB 02 33 C0 5D C2 1C 00 }
	condition:
		$1
}

rule function_685_0 {
	meta:
		name = "TActiveXControl.PostMessageFilter"
		size = 53
	strings:
		$1 = { 55 8B EC 8B 45 08 83 78 48 00 74 23 8B 55 20 52 8B 55 1C 52 8B 55 18 52 8B 55 14 52 8B 55 10 52 8B 55 0C 52 8B 40 48 50 8B 00 FF 50 10 EB 02 33 C0 5D C2 1C 00 }
	condition:
		$1
}

rule function_686_0 {
	meta:
		name = "TActiveXControl.QuickActivate"
		size = 332
		refs = "0019 TActiveXControl.QuickActivate 003c @FillChar 004c TActiveXControl.SetClientSite 0060 TActiveXControl.SetAdvise 0076 @IntfCast 0084 @IntfClear 00e8 TActiveXControl.GetMiscStatus 0100 IConnectionPoint 010a @FinalizeArray 0118 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 53 56 57 8B 7D 10 8B 5D 0C 8B 75 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 3F 18 7D 0A BB FF FF 00 80 E9 BC 00 00 00 8B C7 33 C9 BA 18 00 00 00 E8 ?? ?? ?? ?? C7 07 18 00 00 00 8B 43 04 50 56 E8 ?? ?? ?? ?? 83 7B 08 00 74 0E 8B 43 08 50 6A 00 6A 01 56 E8 ?? ?? ?? ?? 8D 45 FC 8B D6 85 D2 74 03 83 EA E4 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 7B 0C 00 74 2C 8D 45 F8 E8 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 10 85 C0 75 11 8D 47 10 50 8B 43 0C 50 8B 45 F8 50 8B 00 FF 50 14 83 7B 10 00 74 2E 8D 45 F4 E8 ?? ?? ?? ?? 50 8B 46 30 83 C0 58 50 8B 45 FC 50 8B 00 FF 50 10 85 C0 75 11 8D 47 0C 50 8B 43 10 50 8B 45 F4 50 8B 00 FF 50 14 8D 47 04 50 6A 01 56 E8 ?? ?? ?? ?? 33 DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DD 8B C3 5F 5E 5B 8B E5 5D C2 0C 00 00 00 00 84 B2 96 B1 B4 BA 1A 10 B6 9C 00 AA 00 34 1D 07 02 BC FB 9B F1 EF 1A 10 84 ED 00 AA 00 34 1D 07 }
	condition:
		$1
}

rule function_687_0 {
	meta:
		name = "TActiveXControl.SetContentExtent"
		size = 22
		refs = "000e TActiveXControl.SetExtent"
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 55 0C 52 6A 01 50 E8 ?? ?? ?? ?? 5D C2 08 00 }
	condition:
		$1
}

rule function_688_0 {
	meta:
		name = "TActiveXControl.GetContentExtent"
		size = 22
		refs = "000e TActiveXControl.GetExtent"
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 55 0C 52 6A 01 50 E8 ?? ?? ?? ?? 5D C2 08 00 }
	condition:
		$1
}

rule function_689_0 {
	meta:
		name = "TActiveXControl.GetData"
		size = 457
		refs = "0026 TActiveXControl.GetExtent 002d CreateMetaFile 003f SetWindowOrgEx 0052 SetWindowExtEx 0066 TActiveXControl.GetData 0073 TControl.SetVisible 007a _Dn_TBitmap 007f TBitmap.Create 00bc TBitmap.GetCanvas 00c1 TCanvas.GetHandle 00d0 TWinControl.PaintTo 010e StretchBlt 0123 TObject.Free 0129 @HandleFinally 0157 CloseMetaFile 0170 GlobalAlloc 017c DeleteMetaFile 0189 GlobalLock 01a4 GlobalUnlock"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 8B 45 0C F6 40 10 20 75 0A B8 64 00 04 80 E9 A6 01 00 00 8D 45 F8 50 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 6A 00 E8 ?? ?? ?? ?? 89 45 F4 6A 00 6A 00 6A 00 8B 45 F4 50 E8 ?? ?? ?? ?? 6A 00 8B 45 FC 50 8B 45 F8 50 8B 45 F4 50 E8 ?? ?? ?? ?? 8B 45 08 8B 40 6C 8A 50 47 88 55 F3 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 B2 01 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 6C 8B 50 38 8B 45 EC 8B 08 FF 51 40 8B 45 08 8B 40 6C 8B 50 3C 8B 45 EC 8B 08 FF 51 34 6A 00 8B 45 EC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B 45 08 8B 40 6C 33 C9 E8 ?? ?? ?? ?? 68 20 00 CC 00 8B 45 EC 8B 10 FF 52 20 50 8B 45 EC 8B 10 FF 52 2C 50 6A 00 6A 00 8B 45 EC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8B 45 FC 50 8B 45 F8 50 6A 00 6A 00 8B 45 F4 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 EC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 08 8B 40 6C 8A 55 F3 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EA 8B 45 F4 50 E8 ?? ?? ?? ?? 8B F0 85 F6 75 07 B8 FF FF 00 80 EB 59 6A 10 68 02 20 00 00 E8 ?? ?? ?? ?? 8B D8 85 DB 75 0D 56 E8 ?? ?? ?? ?? B8 70 00 03 80 EB 3A 53 E8 ?? ?? ?? ?? 89 70 0C C7 00 08 00 00 00 8B 55 F8 89 50 04 8B 55 FC 89 50 08 53 E8 ?? ?? ?? ?? 8B 45 10 C7 00 20 00 00 00 8B 45 10 89 58 04 8B 45 10 33 D2 89 50 08 33 C0 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_695_0 {
	meta:
		name = "TActiveXControl.DAdvise"
		size = 75
		refs = "0013 @IntfClear 0019 CreateDataAdviseHolder"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 33 C0 83 7B 60 00 75 0E 8D 43 60 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 75 25 8B 45 18 50 8B 45 14 50 8B 45 10 50 8B 45 0C 50 8B C3 85 C0 74 05 2D 48 FF FF FF 50 8B 43 60 50 8B 00 FF 50 0C 5B 5D C2 14 00 }
	condition:
		$1
}

rule function_696_0 {
	meta:
		name = "TActiveXControl.DUnadvise"
		size = 36
	strings:
		$1 = { 55 8B EC 8B 45 08 83 78 60 00 75 07 B8 04 00 04 80 EB 0D 8B 55 0C 52 8B 40 60 50 8B 00 FF 50 10 5D C2 08 00 }
	condition:
		$1
}

rule function_697_0 {
	meta:
		name = "TActiveXControl.EnumDAdvise"
		size = 54
		refs = "0023 @IntfClear"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 8B 45 0C 85 C0 74 04 33 D2 89 10 83 7B 60 00 75 07 B8 05 40 00 80 EB 12 8B 45 0C E8 ?? ?? ?? ?? 50 8B 43 60 50 8B 00 FF 50 14 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_698_0 {
	meta:
		name = "TActiveXControlFactory.Create"
		size = 244
		refs = "0015 @ClassCreate 0025 TActiveXControlFactory.Create 0048 TAutoObjectFactory.Create 0070 _Dn_TStringList 0075 TObject.Create 0080 SPropertiesVerb 0085 LoadResString 0091 TActiveXControlFactory.AddVerb 009b @WStrFromLStr 00c7 @LStrClr 00cd @HandleFinally 00dc @AfterConstruction"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 DB 89 5D F8 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B D8 8B 75 10 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 1C 89 43 6C 8B 45 20 50 8B 45 18 50 6A 02 8A 45 08 50 33 D2 8B C3 E8 ?? ?? ?? ?? 8B 45 0C 83 C8 01 83 C8 10 0D 80 00 00 00 0D 00 01 00 00 0D 00 00 02 00 89 43 70 8B 45 14 89 43 74 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 43 78 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D F8 33 D2 8B C3 E8 ?? ?? ?? ?? 8D 43 3C 8B D6 E8 ?? ?? ?? ?? 85 F6 0F 95 C0 88 43 45 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 43 7C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 80 7D FF 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5E 5B 59 59 5D C2 1C 00 }
	condition:
		$1
}

rule function_699_0 {
	meta:
		name = "TActiveXControlFactory.Destroy"
		size = 53
		refs = "0003 @BeforeDestruction 000f TObject.Free 0023 TComObjectFactory.Destroy 002e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 78 E8 ?? ?? ?? ?? 8B 46 7C E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_700_0 {
	meta:
		name = "TActiveXControlFactory.AddVerb"
		size = 13
	strings:
		$1 = { 53 8B 40 78 87 CA 8B 18 FF 53 38 5B C3 }
	condition:
		$1
}

rule function_701_0 {
	meta:
		name = "TActiveXControlFactory.GetLicenseFileName"
		size = 104
		refs = "000f TActiveXControlFactory.GetLicenseFileName 002f ChangeFileExt 0044 @LStrClr 004a @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B 43 08 8B 08 FF 51 0C 8B 45 FC 8B CE BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 00 00 00 FF FF FF FF 04 00 00 00 2E 6C 69 63 00 00 00 00 }
	condition:
		$1
}

rule function_702_0 {
	meta:
		name = "TActiveXControlFactory.HasMachineLicense"
		size = 243
		refs = "0013 TActiveXControlFactory.HasMachineLicense 0074 @HandleAnyException 007b @DoneExcept 00a0 @WStrFromLStr 00d6 @WStrClr 00de @LStrClr 00e4 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 53 56 57 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B3 01 8B 45 FC 80 78 45 00 0F 84 99 00 00 00 8B 45 FC 80 B8 80 00 00 00 00 75 47 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 F8 8B 45 FC 8B 08 FF 51 1C 8B 55 F8 8B 45 FC 8B 40 7C 8B 08 FF 51 58 8B 45 FC C6 80 80 00 00 00 01 33 C0 5A 59 59 64 89 10 EB 0C E9 ?? ?? ?? ?? 33 DB E8 ?? ?? ?? ?? 84 DB 74 42 33 F6 33 DB EB 29 8D 4D F8 8B 45 FC 8B 40 7C 8B D6 8B 18 FF 53 0C 8B 55 F8 8D 45 F4 E8 ?? ?? ?? ?? 8B 55 F4 8B 45 FC 8B 08 FF 51 0C 8B D8 46 8B 45 FC 8B 40 7C 8B 10 FF 52 14 3B F0 7D 04 84 DB 74 C4 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_703_0 {
	meta:
		name = "TActiveXControlFactory.UpdateRegistry"
		size = 840
		refs = "0017 TActiveXControlFactory.UpdateRegistry 0028 GUIDToString 0038 @LStrCat3 004c TTypedComObjectFactory.UpdateRegistry 006b CreateRegKey 0076 IntToStr 00c3 @LStrCatN 014b @LStrCat 01d4 DeleteRegKey 0276 @LStrArrayClr 027e @LStrClr 0284 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 51 53 56 57 88 55 FF 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 F0 8D 43 10 E8 ?? ?? ?? ?? 8B 4D F0 8D 45 F8 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 80 7D FF 00 0F 84 4D 01 00 00 8A 55 FF 8B C3 E8 ?? ?? ?? ?? 8D 45 F0 B9 ?? ?? ?? ?? 8B 55 F8 E8 ?? ?? ?? ?? 8B 45 F0 B9 ?? ?? ?? ?? 33 D2 E8 ?? ?? ?? ?? 8D 55 F0 8B 43 70 E8 ?? ?? ?? ?? 8B 45 F0 50 8D 45 EC B9 ?? ?? ?? ?? 8B 55 F8 E8 ?? ?? ?? ?? 8B 45 EC 33 D2 59 E8 ?? ?? ?? ?? 8D 55 EC 8B 43 08 8B 08 FF 51 0C FF 75 EC 68 ?? ?? ?? ?? 8D 55 E8 8B 43 74 E8 ?? ?? ?? ?? FF 75 E8 8D 45 F0 BA 03 00 00 00 E8 ?? ?? ?? ?? 8B 45 F0 50 8D 45 EC B9 ?? ?? ?? ?? 8B 55 F8 E8 ?? ?? ?? ?? 8B 45 EC 33 D2 59 E8 ?? ?? ?? ?? 8D 45 F0 B9 ?? ?? ?? ?? 8B 55 F8 E8 ?? ?? ?? ?? 8B 45 F0 33 C9 33 D2 E8 ?? ?? ?? ?? 8D 45 F0 B9 ?? ?? ?? ?? 8B 55 F8 E8 ?? ?? ?? ?? 8B 45 F0 33 C9 33 D2 E8 ?? ?? ?? ?? 8B 43 78 8B 10 FF 52 14 48 85 C0 0F 8C 31 01 00 00 40 89 45 F4 33 F6 8D 4D F0 8B D6 8B 43 78 8B 38 FF 57 0C 8D 45 F0 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F0 50 FF 75 F8 68 ?? ?? ?? ?? 8B D6 8B 43 78 8B 08 FF 51 18 8D 55 E8 E8 ?? ?? ?? ?? FF 75 E8 8D 45 EC BA 03 00 00 00 E8 ?? ?? ?? ?? 8B 45 EC 33 D2 59 E8 ?? ?? ?? ?? 46 FF 4D F4 75 A7 E9 CD 00 00 00 8B 43 78 8B 10 FF 52 14 48 85 C0 7C 3E 40 89 45 F4 33 F6 FF 75 F8 68 ?? ?? ?? ?? 8B D6 8B 43 78 8B 08 FF 51 18 8D 55 EC E8 ?? ?? ?? ?? FF 75 EC 8D 45 F0 BA 03 00 00 00 E8 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? 46 FF 4D F4 75 C8 8D 45 F0 B9 ?? ?? ?? ?? 8B 55 F8 E8 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? 8D 45 F0 B9 ?? ?? ?? ?? 8B 55 F8 E8 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? 8D 45 F0 B9 ?? ?? ?? ?? 8B 55 F8 E8 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? 8D 45 F0 B9 ?? ?? ?? ?? 8B 55 F8 E8 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? 8D 45 F0 B9 ?? ?? ?? ?? 8B 55 F8 E8 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? 8A 55 FF 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 BA 03 00 00 00 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E3 5F 5E 5B 8B E5 5D C3 00 00 00 FF FF FF FF 06 00 00 00 43 4C 53 49 44 5C 00 00 FF FF FF FF 0B 00 00 00 5C 4D 69 73 63 53 74 61 74 75 73 00 FF FF FF FF 01 00 00 00 30 00 00 00 FF FF FF FF 0D 00 00 00 5C 4D 69 73 63 53 74 61 74 75 73 5C 31 00 00 00 FF FF FF FF 01 00 00 00 2C 00 00 00 FF FF FF FF 10 00 00 00 5C 54 6F 6F 6C 62 6F 78 42 69 74 6D 61 70 33 32 00 00 00 00 FF FF FF FF 08 00 00 00 5C 43 6F 6E 74 72 6F 6C 00 00 00 00 FF FF FF FF 05 00 00 00 5C 56 65 72 62 00 00 00 FF FF FF FF 04 00 00 00 2C 30 2C 32 00 00 00 00 FF FF FF FF 06 00 00 00 5C 56 65 72 62 5C 00 00 }
	condition:
		$1
}

rule function_704_0 {
	meta:
		name = "TActiveFormControl.DefinePropertyPages"
		size = 49
		refs = "000e _DV_TActiveForm 0013 @IsClass"
	strings:
		$1 = { 55 8B EC 53 56 8B D8 8B 73 6C 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 10 FF 75 0C FF 75 08 8B C6 8B 10 FF 92 D4 00 00 00 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_706_0 {
	meta:
		name = "TActiveFormControl.InitializeControl"
		size = 144
		refs = "000d TActiveFormControl.InitializeControl 001a TActiveXControl.InitializeControl 0030 @IntfCast 0041 _DV_TActiveForm 0046 @IsClass 006f @IntfClear 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 8D 45 FC 8B D3 85 D2 74 03 83 EA E4 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 8B 73 6C 89 46 1C 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 10 89 9E C8 02 00 00 8B C6 8B 10 FF 92 DC 00 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 A0 92 78 E0 2F F5 CF 11 BD 2F 00 20 AF 0E 5B 81 }
	condition:
		$1
}

rule function_707_0 {
	meta:
		name = "TActiveFormControl.Invoke"
		size = 67
	strings:
		$1 = { 55 8B EC 53 8B 55 18 8B 45 08 F6 C2 0C 74 04 66 BA 0C 00 8B 5D 28 53 8B 5D 24 53 8B 5D 20 53 8B 5D 1C 53 52 8B 55 0C 52 8B 48 08 8B 51 54 8B 52 14 03 50 6C 52 8B 41 50 50 8B 00 FF 50 2C 5B 5D C2 24 00 }
	condition:
		$1
}

rule function_708_0 {
	meta:
		name = "TActiveFormControl.ObjQueryInterface"
		size = 59
		refs = "001d TObject.GetInterface 0029 TActiveXControl.ObjQueryInterface"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B 7D 10 8B 75 0C 8B 5D 08 33 C0 89 45 FC 8B CF 8B D6 8B 43 6C E8 ?? ?? ?? ?? 84 C0 75 0B 57 56 53 E8 ?? ?? ?? ?? 89 45 FC 8B 45 FC 5F 5E 5B 59 5D C2 0C 00 }
	condition:
		$1
}

rule function_709_0 {
	meta:
		name = "TActiveFormControl.EventSinkChanged"
		size = 43
		refs = "000e _DV_TActiveForm 0013 @IsClass"
	strings:
		$1 = { 53 56 57 8B FA 8B D8 8B 73 6C 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0C 8B D7 8B C6 8B 08 FF 91 D8 00 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_713_0 {
	meta:
		name = "TActiveFormFactory.GetIntfEntry"
		size = 33
		refs = "0017 TObject.GetInterfaceEntry"
	strings:
		$1 = { 56 57 83 C4 F0 8B F2 8D 3C 24 B9 04 00 00 00 F3 A5 8B D4 8B 40 6C E8 ?? ?? ?? ?? 83 C4 10 5F 5E C3 }
	condition:
		$1
}

rule function_714_0 {
	meta:
		name = "TPropertyPage.Create"
		size = 71
		refs = "000a @ClassCreate 0017 TCustomForm.Create 001e _Dn_TInterfaceList 0023 TInterfaceList.Create 0034 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 86 D8 02 00 00 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_715_0 {
	meta:
		name = "TPropertyPage.Destroy"
		size = 48
		refs = "0003 @BeforeDestruction 0012 TObject.Free 001e TCustomForm.Destroy 0029 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 86 D8 02 00 00 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_717_0 {
	meta:
		name = "TPropertyPage.Modified"
		size = 18
		refs = "000d TPropertyPageImpl.Modified"
	strings:
		$1 = { 8B 90 C4 02 00 00 85 D2 74 07 8B C2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_719_0 {
	meta:
		name = "TPropertyPage.EnumCtlProps"
		size = 156
		refs = "0027 TPropertyPage.EnumCtlProps 003c @VarToIntf 004c @IntfCast 0059 EnumDispatchProperties 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 56 57 33 DB 89 5D EC 89 5D E8 8B F2 8D 7D F0 51 B9 04 00 00 00 F3 A5 59 8B F1 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 45 E8 8D 93 C8 02 00 00 E8 ?? ?? ?? ?? 8B 55 E8 8D 45 EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 EC 33 C9 8D 55 F0 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 00 00 00 00 04 02 00 00 00 00 00 C0 00 00 00 00 00 00 46 }
	condition:
		$1
}

rule function_721_0 {
	meta:
		name = "TActiveXPropertyPage.Destroy"
		size = 44
		refs = "0003 @BeforeDestruction 0012 TObject.Free 0025 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 20 8B 40 08 E8 ?? ?? ?? ?? 8B 46 20 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_722_0 {
	meta:
		name = "TActiveXPropertyPage.Initialize"
		size = 56
		refs = "0010 _DV_TPropertyPageImpl 0015 TAggregatedObject.Create"
	strings:
		$1 = { 53 56 8B D8 8B CB 85 C9 74 03 83 E9 E4 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 43 20 8B 43 08 8B 40 0C 33 C9 B2 01 FF 50 2C 8B 73 20 89 46 08 8B C6 8B 10 FF 12 5E 5B C3 }
	condition:
		$1
}

rule function_723_0 {
	meta:
		name = "TPropertyPageImpl.InitPropertyPage"
		size = 31
		refs = "000f TCustomForm.SetBorderStyle 0019 TCustomForm.SetPosition"
	strings:
		$1 = { 53 8B D8 8B 43 08 89 98 C4 02 00 00 33 D2 E8 ?? ?? ?? ?? 33 D2 8B 43 08 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_724_0 {
	meta:
		name = "TPropertyPageImpl.Modified"
		size = 28
	strings:
		$1 = { 80 78 10 00 74 15 C6 40 11 01 83 78 0C 00 74 0B 6A 03 8B 40 0C 50 8B 00 FF 50 0C C3 }
	condition:
		$1
}

rule function_725_0 {
	meta:
		name = "TPropertyPageImpl.SetPageSite"
		size = 25
		refs = "000e @IntfCopy"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 8D 43 0C 8B 55 0C E8 ?? ?? ?? ?? 33 C0 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_726_0 {
	meta:
		name = "TPropertyPageImpl.Activate"
		size = 119
		refs = "000d TPropertyPageImpl.Activate 001e TControl.SetBoundsRect 0029 TWinControl.SetParentWindow 0036 VarIsNull 005e @HandleAnyException 0063 HandleException 006a @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 5D 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 10 8B 43 08 E8 ?? ?? ?? ?? 8B 43 08 8B 55 0C E8 ?? ?? ?? ?? 8B 43 08 05 C8 02 00 00 E8 ?? ?? ?? ?? 84 C0 75 0B 8B 43 08 8B 10 FF 92 D8 00 00 00 C6 43 10 01 C6 43 11 00 33 DB 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 10 00 }
	condition:
		$1
}

rule function_727_0 {
	meta:
		name = "TPropertyPageImpl.Deactivate"
		size = 83
		refs = "000d TPropertyPageImpl.Deactivate 001f TCustomForm.Hide 0029 TWinControl.SetParentWindow 003a @HandleAnyException 003f HandleException 0046 @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 5D 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C6 43 10 00 8B 43 08 E8 ?? ?? ?? ?? 8B 43 08 33 D2 E8 ?? ?? ?? ?? 33 DB 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_728_0 {
	meta:
		name = "TPropertyPageImpl.GetPageInfo"
		size = 165
		refs = "0012 TPropertyPageImpl.GetPageInfo 0035 @FillChar 0040 TControl.GetText 0048 CoAllocString 006e @HandleAnyException 0073 HandleException 007a @DoneExcept 008f @LStrClr 0095 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B 75 0C 8B 5D 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 46 04 33 C9 BA 18 00 00 00 E8 ?? ?? ?? ?? 8D 55 FC 8B 43 08 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 89 46 04 8B 43 08 8B 40 38 89 46 08 8B 43 08 8B 40 3C 89 46 0C 33 DB 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5F 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_729_0 {
	meta:
		name = "TPropertyPageImpl.SetObjects"
		size = 248
		refs = "0012 TPropertyPageImpl.SetObjects 0035 Null 003a @OleVarFromVar 0045 TInterfaceList.Clear 007a TInterfaceList.Add 0090 @IntfCast 00a0 @VarFromDisp 00b1 @HandleAnyException 00b6 HandleException 00bd @DoneExcept 00d2 @IntfClear 00d8 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B 75 0C 8B 5D 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 7B 08 8D 87 C8 02 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 87 D8 02 00 00 E8 ?? ?? ?? ?? 83 7D 10 00 75 0F BB 03 40 00 80 33 C0 5A 59 59 64 89 10 EB 63 85 F6 7E 42 4E 85 F6 7C 1B 46 33 FF 8B 45 10 8B 14 B8 8B 43 08 8B 80 D8 02 00 00 E8 ?? ?? ?? ?? 47 4E 75 E8 8D 45 FC 8B 55 10 8B 12 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B 43 08 05 C8 02 00 00 E8 ?? ?? ?? ?? 33 DB 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5F 5E 5B 59 5D C2 0C 00 00 04 02 00 00 00 00 00 C0 00 00 00 00 00 00 46 }
	condition:
		$1
}

rule function_730_0 {
	meta:
		name = "TPropertyPageImpl.Show"
		size = 76
		refs = "000d TPropertyPageImpl.Show 0022 TCustomForm.SetVisible 0033 @HandleAnyException 0038 HandleException 003f @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 45 08 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 83 7D 0C 00 0F 95 C2 8B 40 08 E8 ?? ?? ?? ?? 33 DB 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_731_0 {
	meta:
		name = "TPropertyPageImpl.Move"
		size = 72
		refs = "000d TPropertyPageImpl.Move 001e TControl.SetBoundsRect 002f @HandleAnyException 0034 HandleException 003b @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 45 08 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 55 0C 8B 40 08 E8 ?? ?? ?? ?? 33 DB 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_732_0 {
	meta:
		name = "TPropertyPageImpl.IsPageDirty"
		size = 25
	strings:
		$1 = { 55 8B EC 8B 45 08 80 78 11 00 74 04 33 C0 EB 05 B8 01 00 00 00 5D C2 04 00 }
	condition:
		$1
}

rule function_733_0 {
	meta:
		name = "NotifyContainerOfApply"
		size = 324
		refs = "0012 tagCONNECTDATA 0017 @InitializeRecord 001f NotifyContainerOfApply 003c @VarToIntf 0044 @IntfClear 0088 OleCheck 009c @IntfCast 00bf @FinalizeRecord 0118 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 51 51 51 8D 45 E8 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 8B 55 08 8B 52 08 8B 52 08 81 C2 C8 02 00 00 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 10 85 C0 75 79 8D 45 F4 E8 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 10 85 C0 75 5E 8D 45 F0 E8 ?? ?? ?? ?? 50 8B 45 F4 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? EB 23 6A FF 8D 45 E0 8B 55 E8 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 E0 50 8B 00 FF 50 0C 8D 45 E8 E8 ?? ?? ?? ?? 8D 45 E4 50 8D 45 E8 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 6A 01 8B 45 F0 50 8B 00 FF 50 0C 85 C0 74 BB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 E8 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB C2 8B E5 5D C3 00 00 84 B2 96 B1 B4 BA 1A 10 B6 9C 00 AA 00 34 1D 07 02 BC FB 9B F1 EF 1A 10 84 ED 00 AA 00 34 1D 07 }
	condition:
		$1
}

rule function_734_0 {
	meta:
		name = "TPropertyPageImpl.Apply"
		size = 86
		refs = "000a TPropertyPageImpl.Apply 002b NotifyContainerOfApply 003d @HandleAnyException 0042 HandleException 0049 @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 08 8B 10 FF 92 D4 00 00 00 8B 45 08 C6 40 11 00 55 E8 ?? ?? ?? ?? 59 33 DB 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_736_0 {
	meta:
		name = "TPropertyPageImpl.TranslateAccelerator"
		size = 113
		refs = "000d TPropertyPageImpl.TranslateAccelerator 0029 TWinControl.GetHandle 002f GetWindowLong 0044 SetWindowLong 0058 @HandleAnyException 005d HandleException 0064 @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 5D 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 73 08 83 BE 40 01 00 00 00 74 25 6A EC 8B 43 08 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 0D 00 00 01 00 50 6A EC 8B C6 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? BB 01 00 00 00 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_738_0 {
	meta:
		name = "TActiveXPropertyPageFactory.Create"
		size = 216
		refs = "0019 @ClassCreate 002b TActiveXPropertyPageFactory.Create 0049 TObject.ClassName 0065 Format 0078 TComObjectFactory.Create 008d @LStrClr 0093 @HandleFinally 00a2 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 81 C4 F0 FE FF FF 53 56 57 33 DB 89 5D F8 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F9 88 55 FF 8B D8 8B 75 0C 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8B 45 08 50 6A 00 8D 45 F8 50 8D 95 F0 FE FF FF 8B C6 E8 ?? ?? ?? ?? 8D 85 F0 FE FF FF 89 45 F0 C6 45 F4 04 8D 55 F0 33 C9 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F8 50 6A 02 6A 00 8B CF 33 D2 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 80 7D FF 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5F 5E 5B 8B E5 5D C2 08 00 00 FF FF FF FF 10 00 00 00 25 73 20 70 72 6F 70 65 72 74 79 20 70 61 67 65 00 00 00 00 }
	condition:
		$1
}

rule function_739_0 {
	meta:
		name = "TActiveXPropertyPageFactory.CreateComObject"
		size = 16
		refs = "0004 _DV_TActiveXPropertyPage 000b TComObject.CreateFromFactory"
	strings:
		$1 = { 52 8B C8 A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_19836_0 {
	meta:
		name = "TComponentFactory.CreateComObject"
		size = 16
		refs = "0004 _DV_TVCLAutoObject 000b TComObject.CreateFromFactory"
	strings:
		$1 = { 52 8B C8 A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_740_0 {
	meta:
		name = "TCustomAdapter.Create"
		size = 75
		refs = "000a @ClassCreate 0017 _DV_TAdapterNotifier 001c TAdapterNotifier.Create 002d @IntfCopy 0038 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 8B CE B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 85 D2 74 03 83 EA F8 8D 46 14 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_741_0 {
	meta:
		name = "TCustomAdapter.Destroy"
		size = 32
		refs = "0003 @BeforeDestruction 000e TCustomAdapter.ReleaseOleObject 0019 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_6093_0 {
	meta:
		name = "TPaintControl.Destroy"
		size = 32
		refs = "0003 @BeforeDestruction 000e TPaintControl.DestroyHandle 0019 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_742_0 {
	meta:
		name = "TCustomAdapter.Changed"
		size = 12
		refs = "0007 TCustomAdapter.ReleaseOleObject"
	strings:
		$1 = { 80 78 18 00 75 05 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_743_0 {
	meta:
		name = "TCustomAdapter.ConnectOleObject"
		size = 132
		refs = "000e @IntfAddRef 0016 TCustomAdapter.ConnectOleObject 0029 TCustomAdapter.ReleaseOleObject 0043 InterfaceConnect 004e @IntfCopy 0063 @IntfClear 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 7B 0C 00 74 07 8B C3 E8 ?? ?? ?? ?? 83 7D FC 00 74 14 8D 43 10 50 BA ?? ?? ?? ?? 8B 4B 14 8B 45 FC E8 ?? ?? ?? ?? 8D 43 0C 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 00 02 BC FB 9B F1 EF 1A 10 84 ED 00 AA 00 34 1D 07 }
	condition:
		$1
}

rule function_744_0 {
	meta:
		name = "TCustomAdapter.ReleaseOleObject"
		size = 48
		refs = "0007 TCustomAdapter.ReleaseOleObject 000f InterfaceDisconnect 0017 @IntfClear"
	strings:
		$1 = { 53 8B D8 8D 4B 10 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 8D 43 0C E8 ?? ?? ?? ?? 5B C3 00 00 00 02 BC FB 9B F1 EF 1A 10 84 ED 00 AA 00 34 1D 07 }
	condition:
		$1
}

rule function_745_0 {
	meta:
		name = "TAdapterNotifier.Create"
		size = 35
		refs = "0008 @ClassCreate 0014 @AfterConstruction"
		altNames = "TDecisionGraphDataLink.Create TDecisionGridDataLink.Create TPivotDataLink.Create TQueryConstraintValidator.Create"
	strings:
		$1 = { 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 48 0C 84 D2 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C C3 }
	condition:
		$1
}

rule function_746_0 {
	meta:
		name = "TAdapterNotifier.OnChanged"
		size = 69
		refs = "000d TAdapterNotifier.OnChanged 002c @HandleAnyException 0031 HandleException 0038 @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 45 08 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 40 0C 8B 10 FF 52 04 33 DB 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_748_0 {
	meta:
		name = "TFontAdapter.Create"
		size = 60
		refs = "000b @ClassCreate 001a TCustomAdapter.Create 0028 @AfterConstruction"
		altNames = "TPictureAdapter.Create"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 1C 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_7536_0 {
	meta:
		name = "THTTPDataLink.Create"
		size = 60
		refs = "000b @ClassCreate 001a TDataLink.Create 0028 @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 1C 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_7405_0 {
	meta:
		name = "TQueryDataLink.Create"
		size = 60
		refs = "000b @ClassCreate 001a TDataLink.Create 0028 @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 1C 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_749_0 {
	meta:
		name = "TFontAdapter.Update"
		size = 456
		refs = "0019 TFontAdapter.Update 003f @IntfCast 0051 @WStrClr 00da _Dn_TFont 00df TFont.Create 0110 @LStrFromWStr 011b TFont.SetName 0129 @ROUND 0133 TFont.SetSize 013d TFont.SetStyle 0148 TFont.SetCharset 0172 TObject.Free 0178 @HandleFinally 018f @LStrClr 0197 @IntfClear"
	strings:
		$1 = { 55 8B EC 83 C4 DC 53 33 D2 89 55 DC 89 55 F4 89 55 E0 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 80 78 18 00 0F 85 4E 01 00 00 8D 45 E0 8B 55 FC 8B 52 0C B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 7D E0 00 0F 84 31 01 00 00 8D 45 F4 E8 ?? ?? ?? ?? 50 8B 45 E0 50 8B 00 FF 50 0C 8D 45 EC 50 8B 45 E0 50 8B 00 FF 50 14 8A 1D ?? ?? ?? ?? 8D 45 E8 50 8B 45 E0 50 8B 00 FF 50 1C 83 7D E8 00 74 03 80 CB 01 8D 45 E8 50 8B 45 E0 50 8B 00 FF 50 24 83 7D E8 00 74 03 80 CB 02 8D 45 E8 50 8B 45 E0 50 8B 00 FF 50 2C 83 7D E8 00 74 03 80 CB 04 8D 45 E8 50 8B 45 E0 50 8B 00 FF 50 34 83 7D E8 00 74 03 80 CB 08 8D 45 E6 50 8B 45 E0 50 8B 00 FF 50 44 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F8 8B 45 FC C6 40 18 01 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 50 1C 8B 45 F8 8B 08 FF 51 08 8D 45 DC 8B 55 F4 E8 ?? ?? ?? ?? 8B 55 DC 8B 45 F8 E8 ?? ?? ?? ?? DF 6D EC D8 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B 45 F8 E8 ?? ?? ?? ?? 8B D3 8B 45 F8 E8 ?? ?? ?? ?? 8A 55 E6 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 FC 8B 40 1C 8B 55 F8 8B 08 FF 51 08 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC C6 40 18 00 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E9 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5B 8B E5 5D C3 02 E0 F6 BE 74 A8 1A 10 8B BA 00 AA 00 30 0C AB 00 00 00 00 00 40 1C 46 }
	condition:
		$1
}

rule function_750_0 {
	meta:
		name = "TFontAdapter.Changed"
		size = 416
		refs = "0011 TFontAdapter.Changed 0059 @IntfCast 0067 TFont.GetName 0072 @WStrFromLStr 008a TFont.GetSize 00b1 TFont.GetStyle 0129 TFont.GetCharset 0152 @HandleFinally 0169 @LStrClr 0171 @WStrClr 0179 @IntfClear"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 80 78 18 00 0F 85 30 01 00 00 8B 45 FC 83 78 0C 00 0F 84 23 01 00 00 8B 45 FC C6 40 18 01 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F8 8B 55 FC 8B 52 0C B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 55 F0 8B 45 FC 8B 40 1C E8 ?? ?? ?? ?? 8B 55 F0 8D 45 F4 E8 ?? ?? ?? ?? 8B 45 F4 50 8B 45 F8 50 8B 00 FF 50 10 8B 45 FC 8B 40 1C E8 ?? ?? ?? ?? 89 45 EC DB 45 EC D8 0D ?? ?? ?? ?? 83 C4 F8 DF 3C 24 9B 8B 45 F8 50 8B 00 FF 50 18 8B 45 FC 8B 40 1C E8 ?? ?? ?? ?? A8 01 0F 95 C0 F6 D8 1B C0 50 8B 45 F8 50 8B 00 FF 50 20 8B 45 FC 8B 40 1C E8 ?? ?? ?? ?? A8 02 0F 95 C0 F6 D8 1B C0 50 8B 45 F8 50 8B 00 FF 50 28 8B 45 FC 8B 40 1C E8 ?? ?? ?? ?? A8 04 0F 95 C0 F6 D8 1B C0 50 8B 45 F8 50 8B 00 FF 50 30 8B 45 FC 8B 40 1C E8 ?? ?? ?? ?? A8 08 0F 95 C0 F6 D8 1B C0 50 8B 45 F8 50 8B 00 FF 50 38 8B 45 FC 8B 40 1C E8 ?? ?? ?? ?? 25 FF 00 00 00 50 8B 45 F8 50 8B 00 FF 50 48 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC C6 40 18 00 C3 E9 ?? ?? ?? ?? EB F1 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 8B E5 5D C3 00 00 00 02 E0 F6 BE 74 A8 1A 10 8B BA 00 AA 00 30 0C AB 00 40 1C 46 }
	condition:
		$1
}

rule function_751_0 {
	meta:
		name = "TFontAdapter.GetOleFont"
		size = 356
		refs = "001b TFontAdapter.GetOleFont 0036 TFont.GetName 0041 @WStrFromLStr 0050 @WStrToPWChar 005b TFont.GetSize 0073 TFont.GetStyle 008d TFont.GetCharset 00da @IntfClear 00e9 OleCreateFontIndirect 00ee OleCheck 00f8 TCustomAdapter.ConnectOleObject 0107 @IntfCast 011c @LStrClr 012c @WStrClr 0132 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 D0 53 56 33 C9 89 4D D4 89 4D FC 89 4D F8 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 7B 0C 00 0F 85 CD 00 00 00 8D 55 D4 8B 43 1C E8 ?? ?? ?? ?? 8B 55 D4 8D 45 FC E8 ?? ?? ?? ?? C7 45 D8 20 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 89 45 DC 8B 43 1C E8 ?? ?? ?? ?? 89 45 D0 DB 45 D0 D8 0D ?? ?? ?? ?? DF 7D E0 9B 8B 43 1C E8 ?? ?? ?? ?? A8 01 74 08 66 C7 45 E8 BC 02 EB 06 66 C7 45 E8 90 01 8B 43 1C E8 ?? ?? ?? ?? 25 FF 00 00 00 66 89 45 EA 8B 43 1C E8 ?? ?? ?? ?? A8 02 0F 95 C0 F6 D8 1B C0 89 45 EC 8B 43 1C E8 ?? ?? ?? ?? A8 04 0F 95 C0 F6 D8 1B C0 89 45 F0 8B 43 1C E8 ?? ?? ?? ?? A8 08 0F 95 C0 F6 D8 1B C0 89 45 F4 8D 45 F8 E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8D 45 D8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 53 0C B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 D4 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 00 00 40 1C 46 02 E0 F6 BE 74 A8 1A 10 8B BA 00 AA 00 30 0C AB 03 E0 F6 BE 74 A8 1A 10 8B BA 00 AA 00 30 0C AB }
	condition:
		$1
}

rule function_752_0 {
	meta:
		name = "TFontAdapter.SetOleFont"
		size = 108
		refs = "000f TFontAdapter.SetOleFont 0024 @IntfCast 002e TCustomAdapter.ConnectOleObject 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 8B D6 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 04 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 00 02 E0 F6 BE 74 A8 1A 10 8B BA 00 AA 00 30 0C AB }
	condition:
		$1
}

rule function_754_0 {
	meta:
		name = "TPictureAdapter.Update"
		size = 140
		refs = "0013 _DV_TOleGraphic 0018 TGraphic.Create 0023 TPictureAdapter.Update 003f @IntfCast 004d TPicture.SetGraphic 0069 TObject.Free 006f @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 89 45 FC 8B 45 FC C6 40 18 01 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 83 C0 18 8B 55 FC 8B 52 0C B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 8B 40 1C 8B 55 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC C6 40 18 00 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E9 59 59 5D C3 00 00 00 80 09 F8 7B 32 BF 1A 10 8B BB 00 AA 00 30 0C AB }
	condition:
		$1
}

rule function_755_0 {
	meta:
		name = "TPictureAdapter.GetOlePicture"
		size = 564
		refs = "0033 _Dn_TBitmap 0038 @IsClass 004f TBitmap.Create 005a TPictureAdapter.GetOlePicture 0079 TBitmap.ReleaseHandle 0084 TBitmap.ReleasePalette 00a0 TObject.Free 00a6 @HandleFinally 00b0 _Dn_TIcon 00c7 TPicture.GetIcon 00cc TIcon.GetHandle 00e3 _Dn_TMetafile 00fc TMetafile.Create 0118 TPicture.GetWidth 012d TPicture.GetHeight 0143 _Dn_TMetafileCanvas 0148 TMetafileCanvas.Create 016f TCanvas.Draw 0194 TMetafile.ReleaseHandle 01bf TPicture.GetMetafile 01c4 TMetafile.GetHandle 01cf @IntfClear 01e4 OleCreatePictureIndirect 01e9 OleCheck 01f6 TCustomAdapter.ConnectOleObject 0209 @IntfCast"
	strings:
		$1 = { 55 8B EC 83 C4 D4 53 56 89 55 F8 89 45 FC 8B 45 FC 83 78 0C 00 0F 85 DF 01 00 00 C6 45 F7 00 C7 45 D4 14 00 00 00 8B 45 FC 8B 70 1C 8B 5E 04 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 6C C7 45 D8 01 00 00 00 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 40 1C 8B 50 04 8B 45 EC 8B 08 FF 51 08 8B 45 EC E8 ?? ?? ?? ?? 89 45 DC 8B 45 EC E8 ?? ?? ?? ?? 89 45 E0 C6 45 F7 01 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 EC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 1B C7 45 D8 03 00 00 00 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 DC E9 F3 00 00 00 C7 45 D8 04 00 00 00 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 85 C8 00 00 00 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 40 1C E8 ?? ?? ?? ?? 8B D0 8B 45 F0 8B 08 FF 51 40 8B 45 FC 8B 40 1C E8 ?? ?? ?? ?? 8B D0 8B 45 F0 8B 08 FF 51 34 6A 00 8B 4D F0 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 40 1C 8B 40 04 50 33 C9 33 D2 8B 45 E8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 E8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 F0 E8 ?? ?? ?? ?? 89 45 DC C6 45 F7 01 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 DC 8B 45 F8 E8 ?? ?? ?? ?? 50 8A 45 F7 F6 D8 1B C9 BA ?? ?? ?? ?? 8D 45 D4 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 8B 12 8B 45 FC E8 ?? ?? ?? ?? 8B 45 F8 8B 55 FC 8B 52 0C B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B 8B E5 5D C3 00 80 09 F8 7B 32 BF 1A 10 8B BB 00 AA 00 30 0C AB 81 09 F8 7B 32 BF 1A 10 8B BB 00 AA 00 30 0C AB }
	condition:
		$1
}

rule function_756_0 {
	meta:
		name = "TPictureAdapter.SetOlePicture"
		size = 19
		refs = "0006 TCustomAdapter.ConnectOleObject"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 04 5B C3 }
	condition:
		$1
}

rule function_757_0 {
	meta:
		name = "TOleGraphic.Assign"
		size = 49
		refs = "000a _DV_TOleGraphic 000f @IsClass 001e @IntfCopy 002a TPersistent.Assign"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0E 8D 43 18 8B 56 18 E8 ?? ?? ?? ?? 5E 5B C3 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_759_0 {
	meta:
		name = "TOleGraphic.Draw"
		size = 271
		refs = "001f TCanvas.Lock 0027 TOleGraphic.Draw 0035 TCanvas.GetHandle 0051 SelectPalette 0059 RealizePalette 008c PlayEnhMetaFile 0099 TOleGraphic.GetMMHeight 00a3 TOleGraphic.GetMMWidth 00d8 OleCheck 00fc TCanvas.Unlock 0102 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 89 4D F8 89 55 FC 8B D8 83 7B 18 00 0F 84 ED 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 8B F0 8B C3 8B 10 FF 52 24 8B F8 C6 45 F7 00 85 FF 74 15 6A FF 57 56 E8 ?? ?? ?? ?? 8B F8 56 E8 ?? ?? ?? ?? C6 45 F7 01 8D 45 F4 50 8B 43 18 50 8B 00 FF 50 14 66 83 7D F4 04 75 1D 8D 45 F0 50 8B 43 18 50 8B 00 FF 50 0C 8B 45 F8 50 8B 45 F0 50 56 E8 ?? ?? ?? ?? EB 4A 8B 45 F8 50 8B C3 E8 ?? ?? ?? ?? F7 D8 50 8B C3 E8 ?? ?? ?? ?? 50 8B C3 E8 ?? ?? ?? ?? 50 6A 00 8B 45 F8 8B 40 0C 50 8B 45 F8 8B 40 08 50 8B 45 F8 8B 40 04 50 8B 45 F8 8B 00 50 56 8B 43 18 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 80 7D F7 00 74 09 6A FF 57 56 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_760_0 {
	meta:
		name = "TOleGraphic.GetEmpty"
		size = 41
	strings:
		$1 = { 53 51 8B D8 83 7B 18 00 74 1A 54 8B 43 18 50 8B 00 FF 50 14 85 C0 75 0C 66 83 3C 24 00 7E 05 33 C0 5A 5B C3 B0 01 5A 5B C3 }
	condition:
		$1
}

rule function_761_0 {
	meta:
		name = "HIMETRICtoDP"
		size = 70
		refs = "0012 GetDC 001c SetMapMode 0034 LPtoDP 003c ReleaseDC"
	strings:
		$1 = { 53 56 57 83 C4 F8 8B F0 8D 3C 24 A5 A5 8B DA 6A 00 E8 ?? ?? ?? ?? 8B F0 6A 03 56 E8 ?? ?? ?? ?? 8B 04 24 89 03 8B 44 24 04 89 43 04 F7 5B 04 6A 01 53 56 E8 ?? ?? ?? ?? 56 6A 00 E8 ?? ?? ?? ?? 59 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_762_0 {
	meta:
		name = "TOleGraphic.GetHeight"
		size = 46
		refs = "0009 TOleGraphic.GetMMHeight 0016 Point 0021 HIMETRICtoDP"
	strings:
		$1 = { 53 83 C4 F0 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D0 8D 4C 24 08 33 C0 E8 ?? ?? ?? ?? 8D 44 24 08 8B D4 E8 ?? ?? ?? ?? 8B 44 24 04 83 C4 10 5B C3 }
	condition:
		$1
}

rule function_763_0 {
	meta:
		name = "TOleGraphic.GetMMHeight"
		size = 27
	strings:
		$1 = { 51 33 D2 89 14 24 83 78 18 00 74 0A 54 8B 40 18 50 8B 00 FF 50 1C 8B 04 24 5A C3 }
	condition:
		$1
}

rule function_764_0 {
	meta:
		name = "TOleGraphic.GetMMWidth"
		size = 27
	strings:
		$1 = { 51 33 D2 89 14 24 83 78 18 00 74 0A 54 8B 40 18 50 8B 00 FF 50 18 8B 04 24 5A C3 }
	condition:
		$1
}

rule function_765_0 {
	meta:
		name = "TOleGraphic.GetPalette"
		size = 26
	strings:
		$1 = { 51 33 D2 83 78 18 00 74 0D 54 8B 40 18 50 8B 00 FF 50 10 8B 14 24 8B C2 5A C3 }
	condition:
		$1
}

rule function_766_0 {
	meta:
		name = "TOleGraphic.GetTransparent"
		size = 30
	strings:
		$1 = { 51 33 D2 83 78 18 00 74 11 54 8B 40 18 50 8B 00 FF 50 40 F6 04 24 02 0F 95 C2 8B C2 5A C3 }
	condition:
		$1
}

rule function_767_0 {
	meta:
		name = "TOleGraphic.GetWidth"
		size = 43
		refs = "0009 TOleGraphic.GetMMWidth 0014 Point 001f HIMETRICtoDP"
	strings:
		$1 = { 53 83 C4 F0 8B D8 8B C3 E8 ?? ?? ?? ?? 8D 4C 24 08 33 D2 E8 ?? ?? ?? ?? 8D 44 24 08 8B D4 E8 ?? ?? ?? ?? 8B 04 24 83 C4 10 5B C3 }
	condition:
		$1
}

rule function_768_0 {
	meta:
		name = "InvalidOperation"
		size = 24
		refs = "0008 _Dn_EInvalidGraphicOperation 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_11950_0 {
	meta:
		name = "ArgError"
		size = 24
		refs = "0008 _DV_EInvalidArgument 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_18370_0 {
	meta:
		name = "ConvertError"
		size = 24
		refs = "0008 _DV_EConvertError 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_6988_0 {
	meta:
		name = "DbiError"
		size = 24
		refs = "0008 _DV_EDBEngineError 000d EDBEngineError.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_12081_0 {
	meta:
		name = "Error"
		size = 24
		refs = "0008 _DV_EMenuError 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_9320_0 {
	meta:
		name = "InvalidGraphic"
		size = 24
		refs = "0008 _DV_EInvalidGraphic 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_9560_0 {
	meta:
		name = "InvalidOp"
		size = 24
		refs = "0008 _DV_EInvalidGridOperation 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_9319_0 {
	meta:
		name = "InvalidOperation"
		size = 24
		refs = "0008 _DV_EInvalidGraphicOperation 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_15272_0 {
	meta:
		name = "RaiseError"
		size = 24
		refs = "0008 _DV_EPrinter 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_6523_0 {
	meta:
		name = "RaiseGridError"
		size = 24
		refs = "0008 _Dn_EInvalidGridOperation 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1945_0 {
	meta:
		name = "ReadError"
		size = 24
		refs = "0008 _DV_EReadError 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2299_0 {
	meta:
		name = "TabControlError"
		size = 24
		refs = "0008 _Dn_EListError 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_7498_0 {
	meta:
		name = "TableError"
		size = 24
		refs = "0008 _Dn_Exception 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2497_0 {
	meta:
		name = "TreeViewError"
		size = 24
		refs = "0008 _DV_ETreeViewError 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_769_0 {
	meta:
		name = "TOleGraphic.SetHeight"
		size = 72
		refs = "0009 TOleGraphic.SetHeight 0017 SOleGraphic 001c LoadResString 0024 InvalidOperation 0039 @LStrClr 003f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_12082_0 {
	meta:
		name = "IndexError"
		size = 72
		refs = "0009 IndexError 0017 SMenuIndexError 001c LoadResString 0024 Error 0039 @LStrClr 003f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_9321_0 {
	meta:
		name = "InvalidBitmap"
		size = 72
		refs = "0009 InvalidBitmap 0017 SInvalidBitmap 001c LoadResString 0024 InvalidGraphic 0039 @LStrClr 003f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_9322_0 {
	meta:
		name = "InvalidIcon"
		size = 72
		refs = "0009 InvalidIcon 0017 SInvalidIcon 001c LoadResString 0024 InvalidGraphic 0039 @LStrClr 003f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_9323_0 {
	meta:
		name = "InvalidMetafile"
		size = 72
		refs = "0009 InvalidMetafile 0017 SInvalidMetafile 001c LoadResString 0024 InvalidGraphic 0039 @LStrClr 003f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_1946_0 {
	meta:
		name = "PropValueError"
		size = 72
		refs = "0009 PropValueError 0017 SInvalidPropertyValue 001c LoadResString 0024 ReadError 0039 @LStrClr 003f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_1947_0 {
	meta:
		name = "PropertyNotFound"
		size = 72
		refs = "0009 PropertyNotFound 0017 SUnknownProperty 001c LoadResString 0024 ReadError 0039 @LStrClr 003f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_9537_0 {
	meta:
		name = "TIcon.SetHeight"
		size = 72
		refs = "0009 TIcon.SetHeight 0017 SChangeIconSize 001c LoadResString 0024 InvalidOperation 0039 @LStrClr 003f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_9539_0 {
	meta:
		name = "TIcon.SetWidth"
		size = 72
		refs = "0009 TIcon.SetWidth 0017 SChangeIconSize 001c LoadResString 0024 InvalidOperation 0039 @LStrClr 003f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_11718_0 {
	meta:
		name = "TJPEGImage.SetHeight"
		size = 72
		refs = "0009 TJPEGImage.SetHeight 0017 sChangeJPGSize 001c LoadResString 0024 InvalidOperation 0039 @LStrClr 003f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_11724_0 {
	meta:
		name = "TJPEGImage.SetWidth"
		size = 72
		refs = "0009 TJPEGImage.SetWidth 0017 sChangeJPGSize 001c LoadResString 0024 InvalidOperation 0039 @LStrClr 003f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_771_0 {
	meta:
		name = "TOleGraphic.SetWidth"
		size = 72
		refs = "0009 TOleGraphic.SetWidth 0017 SOleGraphic 001c LoadResString 0024 InvalidOperation 0039 @LStrClr 003f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_9843_0 {
	meta:
		name = "TStringGridStrings.Delete"
		size = 72
		refs = "0009 TStringGridStrings.Delete 0017 SInvalidStringGridOp 001c LoadResString 0024 InvalidOp 0039 @LStrClr 003f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_770_0 {
	meta:
		name = "TOleGraphic.SetPalette"
		size = 30
		refs = "0017 OleCheck"
	strings:
		$1 = { 53 56 8B F2 8B D8 83 7B 18 00 74 0F 56 8B 43 18 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_773_0 {
	meta:
		name = "TOleGraphic.LoadFromStream"
		size = 80
		refs = "0007 TOleGraphic.LoadFromStream 000f @IntfClear 001b _Dn_TStreamAdapter 0020 TStreamAdapter.Create 0031 OleLoadPicture 0036 OleCheck"
	strings:
		$1 = { 53 56 8B F2 8B D8 68 ?? ?? ?? ?? 8D 43 18 E8 ?? ?? ?? ?? 50 6A 00 8B CE B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 03 83 E8 EC 83 C9 FF 33 D2 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 00 00 00 80 09 F8 7B 32 BF 1A 10 8B BB 00 AA 00 30 0C AB }
	condition:
		$1
}

rule function_774_0 {
	meta:
		name = "TOleGraphic.SaveToStream"
		size = 132
		refs = "000f TOleGraphic.SaveToStream 0022 _Dn_TStreamAdapter 0027 TStreamAdapter.Create 003f @IntfCast 004d OleCheck 0062 @IntfClear 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 6A FF 6A 00 8B CE B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 03 83 E8 EC 50 8D 45 FC 8B 53 18 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 18 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 00 09 01 00 00 00 00 00 00 C0 00 00 00 00 00 00 46 }
	condition:
		$1
}

rule function_775_0 {
	meta:
		name = "TOleGraphic.LoadFromClipboardFormat"
		size = 76
		refs = "000a TOleGraphic.LoadFromClipboardFormat 0018 SOleGraphic 001d LoadResString 0025 InvalidOperation 003a @LStrClr 0040 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_9541_0 {
	meta:
		name = "TIcon.LoadFromClipboardFormat"
		size = 76
		refs = "000a TIcon.LoadFromClipboardFormat 0018 SIconToClipboard 001d LoadResString 0025 InvalidOperation 003a @LStrClr 0040 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_9542_0 {
	meta:
		name = "TIcon.SaveToClipboardFormat"
		size = 76
		refs = "000a TIcon.SaveToClipboardFormat 0018 SIconToClipboard 001d LoadResString 0025 InvalidOperation 003a @LStrClr 0040 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_776_0 {
	meta:
		name = "TOleGraphic.SaveToClipboardFormat"
		size = 76
		refs = "000a TOleGraphic.SaveToClipboardFormat 0018 SOleGraphic 001d LoadResString 0025 InvalidOperation 003a @LStrClr 0040 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_777_0 {
	meta:
		name = "_NF__837"
		size = 137
		refs = "0007 TStringsEnumerator.Next 0011 TStringsEnumerator.Skip 001b TStringsEnumerator.Reset 0025 TStringsEnumerator.Clone 003c TAggregatedObject._AddRef 0046 TAggregatedObject._Release 004d _NF__837"
	strings:
		$1 = { CC 83 44 24 04 EC E9 ?? ?? ?? ?? 83 44 24 04 EC E9 ?? ?? ?? ?? 83 44 24 04 EC E9 ?? ?? ?? ?? 83 44 24 04 EC E9 ?? ?? ?? ?? 83 44 24 04 EC 8B 44 24 04 8B 00 FF 20 83 44 24 04 EC E9 ?? ?? ?? ?? 83 44 24 04 EC E9 ?? ?? ?? ?? CC CC CC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 00 00 00 01 01 00 00 00 00 00 00 C0 00 00 00 00 00 00 46 ?? ?? ?? ?? 14 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_778_0 {
	meta:
		name = "TStringsEnumerator.Create"
		size = 69
		refs = "000b @ClassCreate 001c TAggregatedObject.Create 0026 @IntfCopy 0031 @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 8B CE 33 D2 8B C7 E8 ?? ?? ?? ?? 8D 47 10 8B D6 E8 ?? ?? ?? ?? 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_779_0 {
	meta:
		name = "TStringsEnumerator.Next"
		size = 193
		refs = "0018 TStringsEnumerator.Next 002a @VarClr 003a @CheckAutoResult 0045 @VarToWStr 004d @WStrToPWChar 00aa @WStrClr 00b0 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 51 53 56 57 8B 7D 0C 8B 75 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 DB EB 35 8D 45 EC E8 ?? ?? ?? ?? 50 53 8B 46 10 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 8D 55 EC 8D 45 FC E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B 55 10 89 04 9A 43 FF 46 0C 3B FB 7E 1A 8D 45 E8 50 8B 46 10 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 8B 45 E8 3B 46 0C 7F AD 83 7D 14 00 74 05 8B 45 14 89 18 3B FB 75 04 33 DB EB 05 BB 01 00 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule function_780_0 {
	meta:
		name = "TStringsEnumerator.Skip"
		size = 85
		refs = "001a @CheckAutoResult"
	strings:
		$1 = { 55 8B EC 51 53 56 8B 75 0C 8B 5D 08 8D 45 FC 50 8B 43 10 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 8B 45 FC 8B 53 0C 03 D6 3B C2 7C 07 01 73 0C 33 C0 EB 1D 8D 45 FC 50 8B 43 10 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 8B 45 FC 89 43 0C B8 01 00 00 00 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_781_0 {
	meta:
		name = "TStringsEnumerator.Reset"
		size = 17
	strings:
		$1 = { 55 8B EC 8B 45 08 33 D2 89 50 0C 33 C0 5D C2 04 00 }
	condition:
		$1
}

rule function_782_0 {
	meta:
		name = "TStringsEnumerator.Clone"
		size = 102
		refs = "0018 TStringsEnumerator.Clone 0028 _DV_TStringsEnumerator 002d TStringsEnumerator.Create 003e @IntfCopy 004f @HandleAnyException 0059 @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 5D 08 8B 45 0C 85 C0 74 04 33 D2 89 10 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 4B 10 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 85 D2 74 03 83 EA EC 8B 45 0C E8 ?? ?? ?? ?? 33 DB 33 C0 5A 59 59 64 89 10 EB 0F E9 ?? ?? ?? ?? BB FF FF 00 80 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_783_0 {
	meta:
		name = "TStringsAdapter.Create"
		size = 168
		refs = "0010 @ClassCreate 001e TStringsAdapter.Create 002c @IntfClear 0038 LIBID_StdVCL 003e LoadRegTypeLib 0043 OleCheck 0054 TAutoIntfObject.Create 0072 @HandleFinally 007f @AfterConstruction"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 50 6A 00 6A 00 6A 01 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 4D FC 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 2C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B 59 5D C3 00 00 00 E2 DF 05 EE 49 55 D0 11 9E A9 00 20 AF 3D 82 DA }
	condition:
		$1
}

rule function_784_0 {
	meta:
		name = "TDimension.SetRange"
		size = 4
		altNames = "TStringsAdapter.ReferenceStrings"
	strings:
		$1 = { 89 50 2C C3 }
	condition:
		$1
}

rule function_785_0 {
	meta:
		name = "TStringsAdapter.ReleaseStrings"
		size = 6
	strings:
		$1 = { 33 D2 89 50 2C C3 }
	condition:
		$1
}

rule function_786_0 {
	meta:
		name = "TStringsAdapter.Get_ControlDefault"
		size = 98
		refs = "0025 TStringsAdapter.Get_ControlDefault 0033 @VarClr 003e TStringsAdapter.Get_Item 0043 @CheckAutoResult 0055 @HandleAutoException"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 5D 08 8B 45 10 8B 55 10 85 D2 74 0D 33 C9 89 4A 0C 89 4A 08 89 4A 04 89 0A 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 10 E8 ?? ?? ?? ?? 50 8B 45 0C 50 53 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 0C 00 }
	condition:
		$1
}

rule function_787_0 {
	meta:
		name = "TStringsAdapter.Set_ControlDefault"
		size = 94
		refs = "000d @VarAddRef 0016 TStringsAdapter.Set_ControlDefault 0032 TStringsAdapter.Set_Item 0037 @CheckAutoResult 0049 @HandleAutoException 0051 @VarClr"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 5D 08 8D 45 10 E8 ?? ?? ?? ?? 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 1C FF 75 18 FF 75 14 FF 75 10 8B 45 0C 50 53 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8D 45 10 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 18 00 }
	condition:
		$1
}

rule function_788_0 {
	meta:
		name = "TStringsAdapter.Count"
		size = 74
		refs = "0011 TStringsAdapter.Count 003d @HandleAutoException"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 75 0C 8B 5D 08 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 89 06 8B 7B 2C 85 FF 74 09 8B C7 8B 10 FF 52 14 89 06 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_789_0 {
	meta:
		name = "TStringsAdapter.Get_Item"
		size = 152
		refs = "0029 TStringsAdapter.Get_Item 0038 Null 003d @OleVarFromVar 005c @WStrFromLStr 0067 @VarFromWStr 0079 @HandleAutoException 0081 @LStrClr 0089 @WStrClr"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 57 8B 5D 08 8B 45 10 8B 55 10 85 D2 74 0D 33 C9 89 4A 0C 89 4A 08 89 4A 04 89 0A 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 10 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 73 2C 85 F6 74 23 8D 4D F8 8B 55 0C 8B C6 8B 18 FF 53 0C 8B 55 F8 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 10 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 59 59 5D C2 0C 00 }
	condition:
		$1
}

rule function_790_0 {
	meta:
		name = "TStringsAdapter.Set_Item"
		size = 109
		refs = "000f @VarAddRef 0018 TStringsAdapter.Set_Item 0030 @VarToLStr 004f @HandleAutoException 0057 @LStrClr 005f @VarClr"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B 5D 08 8D 45 10 E8 ?? ?? ?? ?? 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 73 2C 85 F6 74 18 8D 45 FC 8D 55 10 E8 ?? ?? ?? ?? 8B 4D FC 8B 55 0C 8B C6 8B 18 FF 53 20 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? 8D 45 10 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 59 5D C2 18 00 }
	condition:
		$1
}

rule function_791_0 {
	meta:
		name = "TStringsAdapter.Remove"
		size = 68
		refs = "000e TStringsAdapter.Remove 0037 @HandleAutoException"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 45 08 50 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 70 2C 85 F6 74 0A 8B 55 0C 8B C6 8B 08 FF 51 44 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_792_0 {
	meta:
		name = "TStringsAdapter.Clear"
		size = 65
		refs = "000e TStringsAdapter.Clear 0034 @HandleAutoException"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 45 08 50 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 70 2C 85 F6 74 07 8B C6 8B 10 FF 52 40 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_793_0 {
	meta:
		name = "TStringsAdapter.Add"
		size = 117
		refs = "0012 @VarAddRef 001b TStringsAdapter.Add 0039 @VarToLStr 0057 @HandleAutoException 005f @LStrClr 0067 @VarClr"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B 75 1C 8B 5D 08 8D 45 0C E8 ?? ?? ?? ?? 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C7 06 FF FF FF FF 8B 7B 2C 85 FF 74 17 8D 45 FC 8D 55 0C E8 ?? ?? ?? ?? 8B 55 FC 8B C7 8B 08 FF 51 34 89 06 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 59 5D C2 18 00 }
	condition:
		$1
}

rule function_794_0 {
	meta:
		name = "TStringsAdapter._NewEnum"
		size = 100
		refs = "0019 TStringsAdapter._NewEnum 002f _DV_TStringsEnumerator 0034 TStringsEnumerator.Create 0045 @IntfCopy 0057 @HandleAutoException"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 5D 08 8B 45 0C 85 C0 74 04 33 D2 89 10 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B CB 85 C9 74 03 83 E9 CC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 85 D2 74 03 83 EA F8 8B 45 0C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_795_0 {
	meta:
		name = "GetOleStrings"
		size = 88
		refs = "0009 @IntfClear 001c _DV_TStringsAdapter 0021 TStringsAdapter.Create 0031 TStrings.SetStringsAdapter 003b GetOleStrings 0040 @IntfCast"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 E8 ?? ?? ?? ?? 85 DB 74 33 83 7B 08 00 75 1E 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 85 D2 74 03 83 EA D0 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 53 08 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 00 E2 DF 05 EE 49 55 D0 11 9E A9 00 20 AF 3D 82 DA }
	condition:
		$1
}

rule function_796_0 {
	meta:
		name = "SetOleStrings"
		size = 242
		refs = "0019 @IntfAddRef 0021 SetOleStrings 0039 TStrings.BeginUpdate 0061 @CheckAutoResult 0074 @VarClr 008f @VarToLStr 00b3 TStrings.EndUpdate 00b9 @HandleFinally 00d8 @LStrClr 00e0 @IntfClear"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 51 51 51 53 56 89 55 F8 89 45 FC 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 7D FC 00 0F 84 8A 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 10 FF 52 40 8D 45 F4 50 8B 45 F8 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 8B 5D F4 4B 85 DB 7C 35 43 33 F6 8D 45 E0 E8 ?? ?? ?? ?? 50 56 8B 45 F8 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 8D 55 E0 8D 45 F0 E8 ?? ?? ?? ?? 8B 55 F0 8B 45 FC 8B 08 FF 51 34 46 4B 75 CE 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_797_0 {
	meta:
		name = "InitOlePro32"
		size = 292
		refs = "000a SetErrorMode 0015 InitOlePro32 0021 OlePro32DLL 002e LoadLibrary 004c GetProcAddress 0051 _OleCreatePropertyFrame 0066 _OleCreateFontIndirect 007b _OleCreatePictureIndirect 0090 _OleLoadPicture 00ac @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 68 00 80 00 00 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 3D ?? ?? ?? ?? 00 75 6C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 54 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 50 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EF 59 5D C3 00 00 00 6F 6C 65 70 72 6F 33 32 2E 64 6C 6C 00 00 00 00 4F 6C 65 43 72 65 61 74 65 50 72 6F 70 65 72 74 79 46 72 61 6D 65 00 00 4F 6C 65 43 72 65 61 74 65 46 6F 6E 74 49 6E 64 69 72 65 63 74 00 00 00 4F 6C 65 43 72 65 61 74 65 50 69 63 74 75 72 65 49 6E 64 69 72 65 63 74 00 00 00 00 4F 6C 65 4C 6F 61 64 50 69 63 74 75 72 65 00 00 }
	condition:
		$1
}

rule function_798_0 {
	meta:
		name = "OleCreatePropertyFrame"
		size = 66
		refs = "0006 _OleCreatePropertyFrame"
	strings:
		$1 = { 55 8B EC 53 83 3D ?? ?? ?? ?? 00 74 2B 8B 5D 08 53 8B 5D 0C 53 8B 5D 10 53 8B 5D 14 53 8B 5D 18 53 8B 5D 1C 53 8B 5D 20 53 8B 5D 24 53 51 52 50 FF 15 ?? ?? ?? ?? EB 05 B8 FF FF 00 80 5B 5D C2 20 00 }
	condition:
		$1
}

rule function_799_0 {
	meta:
		name = "OleCreateFontIndirect"
		size = 25
		refs = "0002 _OleCreateFontIndirect"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 0A 51 52 50 FF 15 ?? ?? ?? ?? C3 B8 FF FF 00 80 C3 }
	condition:
		$1
}

rule function_800_0 {
	meta:
		name = "OleCreatePictureIndirect"
		size = 38
		refs = "0006 _OleCreatePictureIndirect"
	strings:
		$1 = { 55 8B EC 53 83 3D ?? ?? ?? ?? 00 74 0F 8B 5D 08 53 51 52 50 FF 15 ?? ?? ?? ?? EB 05 B8 FF FF 00 80 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_801_0 {
	meta:
		name = "OleLoadPicture"
		size = 111
		refs = "0011 @IntfAddRef 0019 OleLoadPicture 0025 _OleLoadPicture 005a @IntfClear 0060 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 8B F1 8B DA 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 3D ?? ?? ?? ?? 00 74 18 8B 45 08 50 8B 45 0C 50 56 53 8B 45 FC 50 FF 15 ?? ?? ?? ?? 8B D8 EB 05 BB FF FF 00 80 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_802_0 {
	meta:
		name = "Finalization"
		size = 94
		refs = "0007 Finalization 0013 _DV_02 001b xParkingWindow 002f SendMessage 0035 OlePro32DLL 0043 FreeLibrary 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 2E 83 3D ?? ?? ?? ?? 00 74 11 6A 00 6A 00 6A 10 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 0B A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_803_0 {
	meta:
		name = "AxCtrls"
		size = 35
		refs = "0002 _DV_02 000a _DV_TOleGraphic 0014 _Dn_TPicture 0019 TPicture.RegisterFileFormat 001e InitOlePro32"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 19 A1 ?? ?? ?? ?? 50 33 C9 33 D2 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_804_0 {
	meta:
		name = "TAxisIncrement.FormShow"
		size = 463
		refs = "000d TAxisIncrement.FormShow 0018 Screen 0021 TScreen.SetCursor 0032 TControl.SetVisible 007c TeeMsg_EnterDateTime 0081 LoadResString 0088 TAxisIncrement.SetEditText 00a7 TCustomRadioGroup.SetItemIndex 00ba TCustomComboBox.SetItemIndex 00c7 TControl.SetText 0142 @LStrClr 0157 FloatToStr 0185 TControl.SetTop 01c4 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? 8B 00 33 D2 E8 ?? ?? ?? ?? 8A 93 E0 02 00 00 8B 83 DC 02 00 00 E8 ?? ?? ?? ?? 8B 83 C4 02 00 00 83 B8 F8 01 00 00 00 0F 94 C2 8B 83 DC 02 00 00 8B 08 FF 51 60 8A 93 E1 02 00 00 8B 83 DC 02 00 00 8B 08 FF 91 BC 00 00 00 80 BB E0 02 00 00 00 0F 84 9C 00 00 00 8B 83 CC 02 00 00 8D 50 74 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 80 BB E1 02 00 00 00 74 56 80 BB EC 02 00 00 19 74 4D 33 D2 8B 83 C4 02 00 00 E8 ?? ?? ?? ?? 33 D2 8A 93 EC 02 00 00 8B 83 C8 02 00 00 E8 ?? ?? ?? ?? 33 D2 8B 83 CC 02 00 00 E8 ?? ?? ?? ?? 33 D2 8B 83 CC 02 00 00 8B 08 FF 51 60 8B 83 C8 02 00 00 8B 10 FF 92 B4 00 00 00 E9 C2 00 00 00 BA 01 00 00 00 8B 83 C4 02 00 00 E8 ?? ?? ?? ?? 83 CA FF 8B 83 C8 02 00 00 E8 ?? ?? ?? ?? E9 9F 00 00 00 33 D2 8B 83 C8 02 00 00 E8 ?? ?? ?? ?? 33 D2 8B 83 C4 02 00 00 E8 ?? ?? ?? ?? BA 01 00 00 00 8B 83 C4 02 00 00 E8 ?? ?? ?? ?? 8B 83 CC 02 00 00 83 C0 74 E8 ?? ?? ?? ?? DD 83 E4 02 00 00 83 C4 F4 DB 3C 24 9B 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 83 CC 02 00 00 E8 ?? ?? ?? ?? 8B 83 CC 02 00 00 8B 70 34 8B 93 D8 02 00 00 2B 72 34 8B 93 D0 02 00 00 8B 52 34 E8 ?? ?? ?? ?? 8B 83 CC 02 00 00 8B 50 34 2B D6 8B 83 D8 02 00 00 E8 ?? ?? ?? ?? 8B 83 CC 02 00 00 8B 10 FF 92 B4 00 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_805_0 {
	meta:
		name = "TAxisIncrement.SetEditText"
		size = 344
		refs = "0011 TAxisIncrement.SetEditText 002d DateTimeStep 003a TimeToStr 0048 TControl.SetText 006d @INT 007c FloatToStr 0095 @FRAC 00b0 TControl.GetText 00e2 @LStrCatN 012a @LStrArrayClr 0132 @LStrClr 0138 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 53 56 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 DD 83 E4 02 00 00 D8 1D ?? ?? ?? ?? DF E0 9E 77 25 A1 ?? ?? ?? ?? FF 70 04 FF 30 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 83 CC 02 00 00 E8 ?? ?? ?? ?? E9 C3 00 00 00 DD 83 E4 02 00 00 D8 1D ?? ?? ?? ?? DF E0 9E 0F 82 8C 00 00 00 DD 83 E4 02 00 00 E8 ?? ?? ?? ?? 83 C4 F4 DB 3C 24 9B 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 83 CC 02 00 00 E8 ?? ?? ?? ?? DD 83 E4 02 00 00 E8 ?? ?? ?? ?? D8 1D ?? ?? ?? ?? DF E0 9E 74 70 8D 55 F4 8B B3 CC 02 00 00 8B C6 E8 ?? ?? ?? ?? FF 75 F4 68 ?? ?? ?? ?? DD 83 E4 02 00 00 E8 ?? ?? ?? ?? 83 C4 F8 DD 1C 24 9B 8D 45 FC E8 ?? ?? ?? ?? FF 75 FC 8D 45 F8 BA 03 00 00 00 E8 ?? ?? ?? ?? 8B 55 F8 8B C6 E8 ?? ?? ?? ?? EB 22 FF B3 E8 02 00 00 FF B3 E4 02 00 00 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 83 CC 02 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E3 5E 5B 8B E5 5D C3 00 00 00 00 00 00 80 3F FF FF FF FF 01 00 00 00 20 00 00 00 }
	condition:
		$1
}

rule function_806_0 {
	meta:
		name = "TAxisIncrement.RadioGroup1Click"
		size = 230
		refs = "006e TCustomComboBox.SetItemIndex 00d2 TAxisIncrement.SetEditText"
	strings:
		$1 = { 53 8B D8 8B 83 C4 02 00 00 8B 80 F8 01 00 00 83 E8 01 72 07 74 7B E9 C9 00 00 00 33 D2 8B 83 CC 02 00 00 8B 08 FF 51 60 B2 01 8B 83 DC 02 00 00 8B 08 FF 91 BC 00 00 00 C6 83 E1 02 00 00 01 B2 01 8B 83 DC 02 00 00 8B 08 FF 51 60 B2 01 8B 83 C8 02 00 00 8B 08 FF 51 60 8A 83 EC 02 00 00 3C 19 74 11 33 D2 8A D0 8B 83 C8 02 00 00 E8 ?? ?? ?? ?? EB 0D 33 D2 8B 83 C8 02 00 00 E8 ?? ?? ?? ?? 8B 83 C8 02 00 00 8B 10 FF 92 B4 00 00 00 5B C3 33 D2 8B 83 DC 02 00 00 8B 08 FF 51 60 33 D2 8B 83 DC 02 00 00 8B 08 FF 91 BC 00 00 00 C6 83 E1 02 00 00 00 33 D2 8B 83 C8 02 00 00 8B 08 FF 51 60 B2 01 8B 83 CC 02 00 00 8B 08 FF 51 60 8B C3 E8 ?? ?? ?? ?? 8B 83 CC 02 00 00 8B 10 FF 92 B4 00 00 00 5B C3 }
	condition:
		$1
}

rule function_807_0 {
	meta:
		name = "TAxisIncrement.BitBtn1Click"
		size = 608
		refs = "001e TAxisIncrement.BitBtn1Click 0062 TCustomComboBox.GetItemIndex 006b DateTimeStep 0097 TControl.GetText 00a4 AnsiPos 00d1 StrToTime 00ed @HandleOnException 00f5 _Dn_Exception 0112 StrToFloat 0121 @DoneExcept 014b @LStrCopy 01ee TeeMsg_IncorrectMaxMinValue 01f3 LoadResString 020c Format 0214 ShowMessage 0233 @LStrArrayClr 0246 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 D8 53 56 57 33 C9 89 4D E4 89 4D E0 89 4D F8 89 4D F4 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 80 B8 E0 02 00 00 00 0F 84 53 01 00 00 8B 45 FC 8B 80 C4 02 00 00 83 B8 F8 01 00 00 00 75 32 8B 45 FC 8B 80 C8 02 00 00 E8 ?? ?? ?? ?? 83 E0 7F 8B 15 ?? ?? ?? ?? 8B 4D FC 8B 1C C2 89 99 E4 02 00 00 8B 5C C2 04 89 99 E8 02 00 00 E9 32 01 00 00 8D 55 F8 8B 45 FC 8B 80 CC 02 00 00 E8 ?? ?? ?? ?? 8B 55 F8 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 85 DB 75 7C 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 F8 8B 45 FC 8B 80 CC 02 00 00 E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 FC DD 98 E4 02 00 00 9B 33 C0 5A 59 59 64 89 10 E9 D0 00 00 00 E9 ?? ?? ?? ?? 01 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 8D 55 F8 8B 45 FC 8B 80 CC 02 00 00 E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 FC DD 98 E4 02 00 00 9B E8 ?? ?? ?? ?? E9 92 00 00 00 8D 45 F8 50 8D 55 F4 8B 45 FC 8B 80 CC 02 00 00 E8 ?? ?? ?? ?? 8B 45 F4 8B CB 49 BA 01 00 00 00 E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? DB 7D E8 9B 8D 45 F8 50 8D 55 F4 8B 45 FC 8B 80 CC 02 00 00 E8 ?? ?? ?? ?? 8B 45 F4 8D 53 01 B9 FF 00 00 00 E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? DB 6D E8 DE C1 8B 45 FC DD 98 E4 02 00 00 9B EB 23 8D 55 F8 8B 45 FC 8B 80 CC 02 00 00 E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 FC DD 98 E4 02 00 00 9B 8B 45 FC C7 80 2C 02 00 00 01 00 00 00 33 C0 5A 59 59 64 89 10 EB 4A E9 ?? ?? ?? ?? 01 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 89 C3 8D 45 E4 50 8D 55 E0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 E0 50 8B 43 04 89 45 D8 C6 45 DC 0B 8D 55 D8 33 C9 58 E8 ?? ?? ?? ?? 8B 45 E4 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E0 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 F4 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DE 5F 5E 5B 8B E5 5D C3 00 FF FF FF FF 01 00 00 00 20 00 00 00 }
	condition:
		$1
}

rule function_808_0 {
	meta:
		name = "TAxisIncrement.CBExactClick"
		size = 83
		refs = "002a TCustomRadioGroup.SetItemIndex 003e TAxisIncrement.SetEditText"
	strings:
		$1 = { 53 56 8B F0 8B 86 DC 02 00 00 8B 10 FF 92 B8 00 00 00 8B D8 88 9E E1 02 00 00 84 DB 75 32 BA 01 00 00 00 8B 86 C4 02 00 00 E8 ?? ?? ?? ?? B2 01 8B 86 CC 02 00 00 8B 08 FF 51 60 8B C6 E8 ?? ?? ?? ?? 8B 86 CC 02 00 00 8B 10 FF 92 B4 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_809_0 {
	meta:
		name = "TAxisIncrement.CBStepsChange"
		size = 22
		refs = "000a TCustomComboBox.GetItemIndex"
	strings:
		$1 = { 53 8B D8 8B 83 C8 02 00 00 E8 ?? ?? ?? ?? 88 83 EC 02 00 00 5B C3 }
	condition:
		$1
}

rule function_812_0 {
	meta:
		name = "TAxisMaxMin.FormShow"
		size = 316
		refs = "000c TAxisMaxMin.FormShow 0017 Screen 0020 TScreen.SetCursor 004e DateToStr 005c TControl.SetText 006b TControl.SetVisible 008c TimeToStr 00aa @LStrClr 00c0 TeeMsg_AxisDlgValue 00c5 LoadResString 00e8 FloatToStr 012b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? 8B 00 33 D2 E8 ?? ?? ?? ?? 80 BB DC 02 00 00 00 74 73 DD 83 E0 02 00 00 D8 1D ?? ?? ?? ?? DF E0 9E 72 24 FF B3 E4 02 00 00 FF B3 E0 02 00 00 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 83 CC 02 00 00 E8 ?? ?? ?? ?? EB 1A 33 D2 8B 83 D4 02 00 00 E8 ?? ?? ?? ?? 33 D2 8B 83 CC 02 00 00 E8 ?? ?? ?? ?? FF B3 E4 02 00 00 FF B3 E0 02 00 00 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 83 D0 02 00 00 E8 ?? ?? ?? ?? EB 74 8B 83 CC 02 00 00 83 C0 74 E8 ?? ?? ?? ?? 8B 83 D0 02 00 00 83 C0 74 E8 ?? ?? ?? ?? 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B 83 D4 02 00 00 E8 ?? ?? ?? ?? DD 83 E0 02 00 00 83 C4 F4 DB 3C 24 9B 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 83 CC 02 00 00 E8 ?? ?? ?? ?? 33 D2 8B 83 D8 02 00 00 E8 ?? ?? ?? ?? 33 D2 8B 83 D0 02 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 00 00 00 00 00 80 3F }
	condition:
		$1
}

rule function_813_0 {
	meta:
		name = "TAxisMaxMin.BitBtn1Click"
		size = 352
		refs = "0015 TAxisMaxMin.BitBtn1Click 0048 TControl.GetText 006e @LStrCatN 0076 StrToDateTime 0095 StrToTime 00b4 StrToFloat 00d4 @HandleOnException 00dc _Dn_Exception 00ee TeeMsg_IncorrectMaxMinValue 00f3 LoadResString 010c Format 0114 ShowMessage 0119 @DoneExcept 0133 @LStrArrayClr 0146 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 51 51 53 56 57 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 80 BB DC 02 00 00 00 74 6C 8B B3 CC 02 00 00 80 7E 47 00 74 41 8D 55 F8 8B C6 E8 ?? ?? ?? ?? FF 75 F8 68 ?? ?? ?? ?? 8D 55 F4 8B 83 D0 02 00 00 E8 ?? ?? ?? ?? FF 75 F4 8D 45 FC BA 03 00 00 00 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? DD 9B E0 02 00 00 9B EB 3C 8D 55 FC 8B 83 D0 02 00 00 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? DD 9B E0 02 00 00 9B EB 1D 8D 55 FC 8B 83 CC 02 00 00 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? DD 9B E0 02 00 00 9B C7 83 2C 02 00 00 01 00 00 00 33 C0 5A 59 59 64 89 10 EB 4A E9 ?? ?? ?? ?? 01 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 89 C3 8D 45 F0 50 8D 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 EC 50 8B 43 04 89 45 E4 C6 45 E8 0B 8D 55 E4 33 C9 58 E8 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 F4 BA 03 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DE 5F 5E 5B 8B E5 5D C3 00 FF FF FF FF 01 00 00 00 20 00 00 00 }
	condition:
		$1
}

rule function_814_0 {
	meta:
		name = "TAxisMaxMin.BitBtn2Click"
		size = 11
		altNames = "TChartEditForm.BCloseClick"
	strings:
		$1 = { C7 80 2C 02 00 00 02 00 00 00 C3 }
	condition:
		$1
}

rule function_817_0 {
	meta:
		name = "TBarSeriesEditor.FormShow"
		size = 319
		refs = "000d TBarSeriesEditor.FormShow 0018 Screen 0021 TScreen.SetCursor 003f TCustomComboBox.SetItemIndex 0051 TCustomUpDown.SetPosition 008c FloatToStr 009a TControl.SetText 00be TCustomRadioGroup.SetItemIndex 0112 TBarSeriesEditor.RefreshShape 012e @LStrClr 0134 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? 8B 00 33 D2 E8 ?? ?? ?? ?? 8B 43 0C 89 83 1C 03 00 00 8B F0 33 D2 8A 96 EC 00 00 00 8B 83 CC 02 00 00 E8 ?? ?? ?? ?? 66 8B 96 F0 00 00 00 8B 83 10 03 00 00 E8 ?? ?? ?? ?? 66 8B 96 FC 00 00 00 8B 83 14 03 00 00 E8 ?? ?? ?? ?? 8A 96 01 01 00 00 8B 83 DC 02 00 00 8B 08 FF 91 BC 00 00 00 DD 86 04 01 00 00 83 C4 F4 DB 3C 24 9B 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 83 E0 02 00 00 E8 ?? ?? ?? ?? 8A 96 01 01 00 00 8B 83 E0 02 00 00 8B 08 FF 51 60 33 D2 8A 96 F9 00 00 00 8B 83 E4 02 00 00 E8 ?? ?? ?? ?? 8A 56 2C 8B 83 04 03 00 00 8B 08 FF 91 BC 00 00 00 8A 96 E0 00 00 00 8B 83 0C 03 00 00 8B 08 FF 91 BC 00 00 00 8A 96 F8 00 00 00 8B 83 F4 02 00 00 8B 08 FF 91 BC 00 00 00 8A 96 00 01 00 00 8B 83 F8 02 00 00 8B 08 FF 91 BC 00 00 00 8B C3 E8 ?? ?? ?? ?? C6 83 18 03 00 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_818_0 {
	meta:
		name = "TBarSeriesEditor.RefreshShape"
		size = 80
		refs = "0016 TControl.SetVisible 004a TBrush.SetColor"
	strings:
		$1 = { 53 8B D8 8B 83 1C 03 00 00 8A 50 2C 80 F2 01 8B 83 00 03 00 00 E8 ?? ?? ?? ?? 8B 83 00 03 00 00 8A 50 47 8B 83 08 03 00 00 8B 08 FF 51 60 8B 83 00 03 00 00 80 78 47 00 74 14 8B 93 1C 03 00 00 8B 52 28 8B 80 1C 01 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_819_0 {
	meta:
		name = "TBarSeriesEditor.SEBarwidthChange"
		size = 39
		refs = "0013 TCustomUpDown.GetPosition 0021 TCustomBarSeries.SetBarWidthPercent"
	strings:
		$1 = { 53 8B D8 80 BB 18 03 00 00 00 75 19 8B 83 10 03 00 00 E8 ?? ?? ?? ?? 0F BF D0 8B 83 1C 03 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_820_0 {
	meta:
		name = "TBarSeriesEditor.CBYOriginClick"
		size = 93
		refs = "0023 TCustomBarSeries.SetUseYOrigin"
	strings:
		$1 = { 53 8B D8 80 BB 18 03 00 00 00 75 4F 8B 83 DC 02 00 00 8B 10 FF 92 B8 00 00 00 8B D0 8B 83 1C 03 00 00 E8 ?? ?? ?? ?? 8B 83 1C 03 00 00 8A 90 01 01 00 00 8B 83 E0 02 00 00 8B 08 FF 51 60 8B 83 E0 02 00 00 8B 10 FF 52 50 84 C0 74 0E 8B 83 E0 02 00 00 8B 10 FF 92 B4 00 00 00 5B C3 }
	condition:
		$1
}

rule function_821_0 {
	meta:
		name = "TBarSeriesEditor.EYOriginChange"
		size = 124
		refs = "000c TBarSeriesEditor.EYOriginChange 0029 TControl.GetText 0045 StrToFloat 0057 TCustomBarSeries.SetYOrigin 006c @LStrClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 80 BB 18 03 00 00 00 75 3C 8D 55 FC 8B 83 E0 02 00 00 E8 ?? ?? ?? ?? 83 7D FC 00 74 28 8D 55 FC 8B 83 E0 02 00 00 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 83 C4 F8 DD 1C 24 9B 8B 83 1C 03 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_822_0 {
	meta:
		name = "TBarSeriesEditor.CBBarStyleChange"
		size = 38
		refs = "0013 TCustomComboBox.GetItemIndex 0020 TCustomBarSeries.SetBarStyle"
	strings:
		$1 = { 53 8B D8 80 BB 18 03 00 00 00 75 18 8B 83 CC 02 00 00 E8 ?? ?? ?? ?? 8B D0 8B 83 1C 03 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_823_0 {
	meta:
		name = "TBarSeriesEditor.BBarPenClick"
		size = 18
		refs = "000d EditChartPen"
	strings:
		$1 = { 8B 90 1C 03 00 00 8B 92 E8 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_824_0 {
	meta:
		name = "TBarSeriesEditor.BBarBrushClick"
		size = 18
		refs = "000d EditChartBrush"
	strings:
		$1 = { 8B 90 1C 03 00 00 8B 92 E4 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_825_0 {
	meta:
		name = "TBarSeriesEditor.RGMultiBarClick"
		size = 33
		refs = "001c TCustomBarSeries.SetMultiBar"
	strings:
		$1 = { 80 B8 18 03 00 00 00 75 17 8B 90 E4 02 00 00 8A 92 F8 01 00 00 8B 80 1C 03 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_826_0 {
	meta:
		name = "TBarSeriesEditor.CBColorEachClick"
		size = 48
		refs = "002a TBarSeriesEditor.RefreshShape"
	strings:
		$1 = { 53 8B D8 80 BB 18 03 00 00 00 75 22 8B 83 04 03 00 00 8B 10 FF 92 B8 00 00 00 8B D0 8B 83 1C 03 00 00 8B 08 FF 51 78 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_827_0 {
	meta:
		name = "TBarSeriesEditor.BBarColorClick"
		size = 58
		refs = "0010 EditColor 0033 TBarSeriesEditor.RefreshShape"
	strings:
		$1 = { 53 56 8B D8 8B B3 1C 03 00 00 8B 56 28 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C6 8B 08 FF 91 80 00 00 00 33 D2 8B 83 04 03 00 00 8B 08 FF 91 BC 00 00 00 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_828_0 {
	meta:
		name = "TBarSeriesEditor.CBDarkBarClick"
		size = 41
		refs = "0023 TCustomBarSeries.SetDark3d"
	strings:
		$1 = { 53 8B D8 80 BB 18 03 00 00 00 75 1B 8B 83 F4 02 00 00 8B 10 FF 92 B8 00 00 00 8B D0 8B 83 1C 03 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_829_0 {
	meta:
		name = "TBarSeriesEditor.CBBarSideMarginsClick"
		size = 41
		refs = "0023 TCustomBarSeries.SetSideMargins"
	strings:
		$1 = { 53 8B D8 80 BB 18 03 00 00 00 75 1B 8B 83 F8 02 00 00 8B 10 FF 92 B8 00 00 00 8B D0 8B 83 1C 03 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_830_0 {
	meta:
		name = "TBarSeriesEditor.SEBarOffsetChange"
		size = 39
		refs = "0013 TCustomUpDown.GetPosition 0021 TCustomBarSeries.SetOffsetPercent"
	strings:
		$1 = { 53 8B D8 80 BB 18 03 00 00 00 75 19 8B 83 14 03 00 00 E8 ?? ?? ?? ?? 0F BF D0 8B 83 1C 03 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_832_0 {
	meta:
		name = "TBarSeriesEditor.CBMarksAutoPositionClick"
		size = 32
		refs = "001a TCustomBarSeries.SetAutoMarkPosition"
	strings:
		$1 = { 53 8B D8 8B 83 0C 03 00 00 8B 10 FF 92 B8 00 00 00 8B D0 8B 83 1C 03 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_833_0 {
	meta:
		name = "TBarSeriesEditor.FormCreate"
		size = 8
	strings:
		$1 = { C6 80 18 03 00 00 01 C3 }
	condition:
		$1
}

rule function_836_0 {
	meta:
		name = "ErrCat"
		size = 7
		altNames = "HiByte"
	strings:
		$1 = { 0F B7 C0 C1 E8 08 C3 }
	condition:
		$1
}

rule function_837_0 {
	meta:
		name = "ErrCode"
		size = 5
	strings:
		$1 = { 66 25 FF 00 C3 }
	condition:
		$1
}

rule function_838_0 {
	meta:
		name = "DbiInit"
		size = 21
		refs = "000d DbiInitFn"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 68 F4 01 00 00 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule function_839_0 {
	meta:
		name = "_DF_"
		size = 6184
		refs = "000b _DF_ 0010 _DV_ 0028 __LOADFUNC"
	strings:
		$1 = { 57 56 52 0F B7 C0 8B D0 03 C0 BE ?? ?? ?? ?? BF ?? ?? ?? ?? 89 57 04 66 8B 14 06 0F B7 D2 89 57 08 8B C7 5A 5E 5F 50 E8 ?? ?? ?? ?? A9 00 00 FF FF 74 01 50 C3 EB C9 66 B8 00 00 EB F8 66 B8 01 00 EB F2 66 B8 02 00 EB EC 66 B8 03 00 EB E6 66 B8 04 00 EB E0 66 B8 05 00 EB DA 66 B8 06 00 EB D4 66 B8 07 00 EB CE 66 B8 08 00 EB C8 66 B8 09 00 EB C2 66 B8 0A 00 EB BC 66 B8 0B 00 EB B6 66 B8 0C 00 EB B0 66 B8 0D 00 EB AA 66 B8 0E 00 EB A4 66 B8 0F 00 EB 9E 66 B8 10 00 EB 98 66 B8 11 00 EB 92 66 B8 12 00 EB 8C 66 B8 13 00 EB 86 E9 4C FF FF FF 66 B8 14 00 EB F5 66 B8 15 00 EB EF 66 B8 16 00 EB E9 66 B8 17 00 EB E3 66 B8 18 00 EB DD 66 B8 19 00 EB D7 66 B8 1A 00 EB D1 66 B8 1B 00 EB CB 66 B8 1C 00 EB C5 66 B8 1D 00 EB BF 66 B8 1E 00 EB B9 66 B8 1F 00 EB B3 66 B8 20 00 EB AD 66 B8 21 00 EB A7 66 B8 22 00 EB A1 66 B8 23 00 EB 9B 66 B8 24 00 EB 95 66 B8 25 00 EB 8F 66 B8 26 00 EB 89 66 B8 27 00 EB 83 E9 CF FE FF FF 66 B8 28 00 EB F5 66 B8 29 00 EB EF 66 B8 2A 00 EB E9 66 B8 2B 00 EB E3 66 B8 2C 00 EB DD 66 B8 2D 00 EB D7 66 B8 2E 00 EB D1 66 B8 2F 00 EB CB 66 B8 30 00 EB C5 66 B8 31 00 EB BF 66 B8 32 00 EB B9 66 B8 33 00 EB B3 66 B8 34 00 EB AD 66 B8 35 00 EB A7 66 B8 36 00 EB A1 66 B8 37 00 EB 9B 66 B8 38 00 EB 95 66 B8 39 00 EB 8F 66 B8 3A 00 EB 89 66 B8 3B 00 EB 83 E9 52 FE FF FF 66 B8 3C 00 EB F5 66 B8 3D 00 EB EF 66 B8 3E 00 EB E9 66 B8 3F 00 EB E3 66 B8 40 00 EB DD 66 B8 41 00 EB D7 66 B8 42 00 EB D1 66 B8 43 00 EB CB 66 B8 44 00 EB C5 66 B8 45 00 EB BF 66 B8 46 00 EB B9 66 B8 47 00 EB B3 66 B8 48 00 EB AD 66 B8 49 00 EB A7 66 B8 4A 00 EB A1 66 B8 4B 00 EB 9B 66 B8 4C 00 EB 95 66 B8 4D 00 EB 8F 66 B8 4E 00 EB 89 66 B8 4F 00 EB 83 E9 D5 FD FF FF 66 B8 50 00 EB F5 66 B8 51 00 EB EF 66 B8 52 00 EB E9 66 B8 53 00 EB E3 66 B8 54 00 EB DD 66 B8 55 00 EB D7 66 B8 56 00 EB D1 66 B8 57 00 EB CB 66 B8 58 00 EB C5 66 B8 59 00 EB BF 66 B8 5A 00 EB B9 66 B8 5B 00 EB B3 66 B8 5C 00 EB AD 66 B8 5D 00 EB A7 66 B8 5E 00 EB A1 66 B8 5F 00 EB 9B 66 B8 60 00 EB 95 66 B8 61 00 EB 8F 66 B8 62 00 EB 89 66 B8 63 00 EB 83 E9 58 FD FF FF 66 B8 64 00 EB F5 66 B8 65 00 EB EF 66 B8 66 00 EB E9 66 B8 67 00 EB E3 66 B8 68 00 EB DD 66 B8 69 00 EB D7 66 B8 6A 00 EB D1 66 B8 6B 00 EB CB 66 B8 6C 00 EB C5 66 B8 6D 00 EB BF 66 B8 6E 00 EB B9 66 B8 6F 00 EB B3 66 B8 70 00 EB AD 66 B8 71 00 EB A7 66 B8 72 00 EB A1 66 B8 73 00 EB 9B 66 B8 74 00 EB 95 66 B8 75 00 EB 8F 66 B8 76 00 EB 89 66 B8 77 00 EB 83 E9 DB FC FF FF 66 B8 78 00 EB F5 66 B8 79 00 EB EF 66 B8 7A 00 EB E9 66 B8 7B 00 EB E3 66 B8 7C 00 EB DD 66 B8 7D 00 EB D7 66 B8 7E 00 EB D1 66 B8 7F 00 EB CB 66 B8 80 00 EB C5 66 B8 81 00 EB BF 66 B8 82 00 EB B9 66 B8 83 00 EB B3 66 B8 84 00 EB AD 66 B8 85 00 EB A7 66 B8 86 00 EB A1 66 B8 87 00 EB 9B 66 B8 88 00 EB 95 66 B8 89 00 EB 8F 66 B8 8A 00 EB 89 66 B8 8B 00 EB 83 E9 5E FC FF FF 66 B8 8C 00 EB F5 66 B8 8D 00 EB EF 66 B8 8E 00 EB E9 66 B8 8F 00 EB E3 66 B8 90 00 EB DD 66 B8 91 00 EB D7 66 B8 92 00 EB D1 66 B8 93 00 EB CB 66 B8 94 00 EB C5 66 B8 95 00 EB BF 66 B8 96 00 EB B9 66 B8 97 00 EB B3 66 B8 98 00 EB AD 66 B8 99 00 EB A7 66 B8 9A 00 EB A1 66 B8 9B 00 EB 9B 66 B8 9C 00 EB 95 66 B8 9D 00 EB 8F 66 B8 9E 00 EB 89 66 B8 9F 00 EB 83 E9 E1 FB FF FF 66 B8 A0 00 EB F5 66 B8 A1 00 EB EF 66 B8 A2 00 EB E9 66 B8 A3 00 EB E3 66 B8 A4 00 EB DD 66 B8 A5 00 EB D7 66 B8 A6 00 EB D1 66 B8 A7 00 EB CB 66 B8 A8 00 EB C5 66 B8 A9 00 EB BF 66 B8 AA 00 EB B9 66 B8 AB 00 EB B3 66 B8 AC 00 EB AD 66 B8 AD 00 EB A7 66 B8 AE 00 EB A1 66 B8 AF 00 EB 9B 66 B8 B0 00 EB 95 66 B8 B1 00 EB 8F 66 B8 B2 00 EB 89 66 B8 B3 00 EB 83 E9 64 FB FF FF 66 B8 B4 00 EB F5 66 B8 B5 00 EB EF 66 B8 B6 00 EB E9 66 B8 B7 00 EB E3 66 B8 B8 00 EB DD 66 B8 B9 00 EB D7 66 B8 BA 00 EB D1 66 B8 BB 00 EB CB 66 B8 BC 00 EB C5 66 B8 BD 00 EB BF 66 B8 BE 00 EB B9 66 B8 BF 00 EB B3 66 B8 C0 00 EB AD 66 B8 C1 00 EB A7 66 B8 C2 00 EB A1 66 B8 C3 00 EB 9B 66 B8 C4 00 EB 95 66 B8 C5 00 EB 8F 66 B8 C6 00 EB 89 66 B8 C7 00 EB 83 E9 E7 FA FF FF 66 B8 C8 00 EB F5 66 B8 C9 00 EB EF 66 B8 CA 00 EB E9 66 B8 CB 00 EB E3 66 B8 CC 00 EB DD 66 B8 CD 00 EB D7 66 B8 CE 00 EB D1 66 B8 CF 00 EB CB 66 B8 D0 00 EB C5 66 B8 D1 00 EB BF 66 B8 D2 00 EB B9 66 B8 D3 00 EB B3 66 B8 D4 00 EB AD 66 B8 D5 00 EB A7 66 B8 D6 00 EB A1 66 B8 D7 00 EB 9B 66 B8 D8 00 EB 95 66 B8 D9 00 EB 8F 66 B8 DA 00 EB 89 66 B8 DB 00 EB 83 E9 6A FA FF FF 66 B8 DC 00 EB F5 66 B8 DD 00 EB EF 66 B8 DE 00 EB E9 66 B8 DF 00 EB E3 66 B8 E0 00 EB DD 66 B8 E1 00 EB D7 66 B8 E2 00 EB D1 66 B8 E3 00 EB CB 66 B8 E4 00 EB C5 66 B8 E5 00 EB BF 66 B8 E6 00 EB B9 66 B8 E7 00 EB B3 66 B8 E8 00 EB AD 66 B8 E9 00 EB A7 66 B8 EA 00 EB A1 66 B8 EB 00 EB 9B 66 B8 EC 00 EB 95 66 B8 ED 00 EB 8F 66 B8 EE 00 EB 89 66 B8 EF 00 EB 83 E9 ED F9 FF FF 66 B8 F0 00 EB F5 66 B8 F1 00 EB EF 66 B8 F2 00 EB E9 66 B8 F3 00 EB E3 66 B8 F4 00 EB DD 66 B8 F5 00 EB D7 66 B8 F6 00 EB D1 66 B8 F7 00 EB CB 66 B8 F8 00 EB C5 66 B8 F9 00 EB BF 66 B8 FA 00 EB B9 66 B8 FB 00 EB B3 66 B8 FC 00 EB AD 66 B8 FD 00 EB A7 66 B8 FE 00 EB A1 66 B8 FF 00 EB 9B 66 B8 00 01 EB 95 66 B8 01 01 EB 8F 66 B8 02 01 EB 89 66 B8 03 01 EB 83 E9 70 F9 FF FF 66 B8 04 01 EB F5 66 B8 05 01 EB EF 66 B8 06 01 EB E9 66 B8 07 01 EB E3 66 B8 08 01 EB DD 66 B8 09 01 EB D7 66 B8 0A 01 EB D1 66 B8 0B 01 EB CB 66 B8 0C 01 EB C5 66 B8 0D 01 EB BF 66 B8 0E 01 EB B9 66 B8 0F 01 EB B3 66 B8 10 01 EB AD 66 B8 11 01 EB A7 66 B8 12 01 EB A1 66 B8 13 01 EB 9B 66 B8 14 01 EB 95 66 B8 15 01 EB 8F 66 B8 16 01 EB 89 66 B8 17 01 EB 83 E9 F3 F8 FF FF 66 B8 18 01 EB F5 66 B8 19 01 EB EF 66 B8 1A 01 EB E9 66 B8 1B 01 EB E3 66 B8 1C 01 EB DD 66 B8 1D 01 EB D7 66 B8 1E 01 EB D1 66 B8 1F 01 EB CB 66 B8 20 01 EB C5 66 B8 21 01 EB BF 66 B8 22 01 EB B9 66 B8 23 01 EB B3 66 B8 24 01 EB AD 66 B8 25 01 EB A7 66 B8 26 01 EB A1 66 B8 27 01 EB 9B 66 B8 28 01 EB 95 66 B8 29 01 EB 8F 66 B8 2A 01 EB 89 66 B8 2B 01 EB 83 E9 76 F8 FF FF 66 B8 2C 01 EB F5 66 B8 2D 01 EB EF 66 B8 2E 01 EB E9 66 B8 2F 01 EB E3 66 B8 30 01 EB DD 66 B8 31 01 EB D7 66 B8 32 01 EB D1 66 B8 33 01 EB CB 66 B8 34 01 EB C5 66 B8 35 01 EB BF 66 B8 36 01 EB B9 66 B8 37 01 EB B3 66 B8 38 01 EB AD 66 B8 39 01 EB A7 66 B8 3A 01 EB A1 66 B8 3B 01 EB 9B 66 B8 3C 01 EB 95 66 B8 3D 01 EB 8F 66 B8 3E 01 EB 89 66 B8 3F 01 EB 83 E9 F9 F7 FF FF 66 B8 40 01 EB F5 66 B8 41 01 EB EF 66 B8 42 01 EB E9 66 B8 43 01 EB E3 66 B8 44 01 EB DD 66 B8 45 01 EB D7 66 B8 46 01 EB D1 66 B8 47 01 EB CB 66 B8 48 01 EB C5 66 B8 49 01 EB BF 66 B8 4A 01 EB B9 66 B8 4B 01 EB B3 66 B8 4C 01 EB AD 66 B8 4D 01 EB A7 66 B8 4E 01 EB A1 66 B8 4F 01 EB 9B 66 B8 50 01 EB 95 66 B8 51 01 EB 8F 66 B8 52 01 EB 89 66 B8 53 01 EB 83 E9 7C F7 FF FF 66 B8 54 01 EB F5 66 B8 55 01 EB EF 66 B8 56 01 EB E9 66 B8 57 01 EB E3 66 B8 58 01 EB DD 66 B8 59 01 EB D7 66 B8 5A 01 EB D1 66 B8 5B 01 EB CB 66 B8 5C 01 EB C5 66 B8 5D 01 EB BF 66 B8 5E 01 EB B9 66 B8 5F 01 EB B3 66 B8 60 01 EB AD 66 B8 61 01 EB A7 66 B8 62 01 EB A1 66 B8 63 01 EB 9B 66 B8 64 01 EB 95 66 B8 65 01 EB 8F 66 B8 66 01 EB 89 66 B8 67 01 EB 83 E9 FF F6 FF FF 66 B8 68 01 EB F5 66 B8 69 01 EB EF 66 B8 6A 01 EB E9 66 B8 6B 01 EB E3 66 B8 6C 01 EB DD 66 B8 6D 01 EB D7 66 B8 6E 01 EB D1 66 B8 6F 01 EB CB 66 B8 70 01 EB C5 66 B8 71 01 EB BF 66 B8 72 01 EB B9 66 B8 73 01 EB B3 66 B8 74 01 EB AD 66 B8 75 01 EB A7 66 B8 76 01 EB A1 66 B8 77 01 EB 9B 66 B8 78 01 EB 95 66 B8 79 01 EB 8F 66 B8 7A 01 EB 89 66 B8 7B 01 EB 83 E9 82 F6 FF FF 66 B8 7C 01 EB F5 66 B8 7D 01 EB EF 66 B8 7E 01 EB E9 66 B8 7F 01 EB E3 66 B8 80 01 EB DD 66 B8 81 01 EB D7 66 B8 82 01 EB D1 66 B8 83 01 EB CB 66 B8 84 01 EB C5 66 B8 85 01 EB BF 66 B8 86 01 EB B9 66 B8 87 01 EB B3 66 B8 88 01 EB AD 66 B8 89 01 EB A7 66 B8 8A 01 EB A1 66 B8 8B 01 EB 9B 66 B8 8C 01 EB 95 66 B8 8D 01 EB 8F 66 B8 8E 01 EB 89 66 B8 8F 01 EB 83 E9 05 F6 FF FF 66 B8 90 01 EB F5 66 B8 91 01 EB EF 66 B8 92 01 EB E9 66 B8 93 01 EB E3 66 B8 94 01 EB DD 66 B8 95 01 EB D7 66 B8 96 01 EB D1 66 B8 97 01 EB CB 66 B8 98 01 EB C5 66 B8 99 01 EB BF 66 B8 9A 01 EB B9 66 B8 9B 01 EB B3 66 B8 9C 01 EB AD 66 B8 9D 01 EB A7 66 B8 9E 01 EB A1 66 B8 9F 01 EB 9B 66 B8 A0 01 EB 95 66 B8 A1 01 EB 8F 66 B8 A2 01 EB 89 66 B8 A3 01 EB 83 E9 88 F5 FF FF 66 B8 A4 01 EB F5 66 B8 A5 01 EB EF 66 B8 A6 01 EB E9 66 B8 A7 01 EB E3 66 B8 A8 01 EB DD 66 B8 A9 01 EB D7 66 B8 AA 01 EB D1 66 B8 AB 01 EB CB 66 B8 AC 01 EB C5 66 B8 AD 01 EB BF 66 B8 AE 01 EB B9 66 B8 AF 01 EB B3 66 B8 B0 01 EB AD 66 B8 B1 01 EB A7 66 B8 B2 01 EB A1 66 B8 B3 01 EB 9B 66 B8 B4 01 EB 95 66 B8 B5 01 EB 8F 66 B8 B6 01 EB 89 66 B8 B7 01 EB 83 E9 0B F5 FF FF 66 B8 B8 01 EB F5 66 B8 B9 01 EB EF 66 B8 BA 01 EB E9 66 B8 BB 01 EB E3 66 B8 BC 01 EB DD 66 B8 BD 01 EB D7 66 B8 BE 01 EB D1 66 B8 BF 01 EB CB 66 B8 C0 01 EB C5 66 B8 C1 01 EB BF 66 B8 C2 01 EB B9 66 B8 C3 01 EB B3 66 B8 C4 01 EB AD 66 B8 C5 01 EB A7 66 B8 C6 01 EB A1 66 B8 C7 01 EB 9B 66 B8 C8 01 EB 95 66 B8 C9 01 EB 8F 66 B8 CA 01 EB 89 66 B8 CB 01 EB 83 E9 8E F4 FF FF 66 B8 CC 01 EB F5 66 B8 CD 01 EB EF 66 B8 CE 01 EB E9 66 B8 CF 01 EB E3 66 B8 D0 01 EB DD 66 B8 D1 01 EB D7 66 B8 D2 01 EB D1 66 B8 D3 01 EB CB 66 B8 D4 01 EB C5 66 B8 D5 01 EB BF 66 B8 D6 01 EB B9 66 B8 D7 01 EB B3 66 B8 D8 01 EB AD 66 B8 D9 01 EB A7 66 B8 DA 01 EB A1 66 B8 DB 01 EB 9B 66 B8 DC 01 EB 95 66 B8 DD 01 EB 8F 66 B8 DE 01 EB 89 66 B8 DF 01 EB 83 E9 11 F4 FF FF 66 B8 E0 01 EB F5 66 B8 E1 01 EB EF 66 B8 E2 01 EB E9 66 B8 E3 01 EB E3 66 B8 E4 01 EB DD 66 B8 E5 01 EB D7 66 B8 E6 01 EB D1 66 B8 E7 01 EB CB 66 B8 E8 01 EB C5 66 B8 E9 01 EB BF 66 B8 EA 01 EB B9 66 B8 EB 01 EB B3 66 B8 EC 01 EB AD 66 B8 ED 01 EB A7 66 B8 EE 01 EB A1 66 B8 EF 01 EB 9B 66 B8 F0 01 EB 95 66 B8 F1 01 EB 8F 66 B8 F2 01 EB 89 66 B8 F3 01 EB 83 E9 94 F3 FF FF 66 B8 F4 01 EB F5 66 B8 F5 01 EB EF 66 B8 F6 01 EB E9 66 B8 F7 01 EB E3 66 B8 F8 01 EB DD 66 B8 F9 01 EB D7 66 B8 FA 01 EB D1 66 B8 FB 01 EB CB 66 B8 FC 01 EB C5 66 B8 FD 01 EB BF 66 B8 FE 01 EB B9 66 B8 FF 01 EB B3 66 B8 00 02 EB AD 66 B8 01 02 EB A7 66 B8 02 02 EB A1 66 B8 03 02 EB 9B 66 B8 04 02 EB 95 66 B8 05 02 EB 8F 66 B8 06 02 EB 89 66 B8 07 02 EB 83 E9 17 F3 FF FF 66 B8 08 02 EB F5 66 B8 09 02 EB EF 66 B8 0A 02 EB E9 66 B8 0B 02 EB E3 66 B8 0C 02 EB DD 66 B8 0D 02 EB D7 66 B8 0E 02 EB D1 66 B8 0F 02 EB CB 66 B8 10 02 EB C5 66 B8 11 02 EB BF 66 B8 12 02 EB B9 66 B8 13 02 EB B3 66 B8 14 02 EB AD 66 B8 15 02 EB A7 66 B8 16 02 EB A1 66 B8 17 02 EB 9B 66 B8 18 02 EB 95 66 B8 19 02 EB 8F 66 B8 1A 02 EB 89 66 B8 1B 02 EB 83 E9 9A F2 FF FF 66 B8 1C 02 EB F5 66 B8 1D 02 EB EF 66 B8 1E 02 EB E9 66 B8 1F 02 EB E3 66 B8 20 02 EB DD 66 B8 21 02 EB D7 66 B8 22 02 EB D1 66 B8 23 02 EB CB 66 B8 24 02 EB C5 66 B8 25 02 EB BF 66 B8 26 02 EB B9 66 B8 27 02 EB B3 66 B8 28 02 EB AD 66 B8 29 02 EB A7 66 B8 2A 02 EB A1 66 B8 2B 02 EB 9B 66 B8 2C 02 EB 95 66 B8 2D 02 EB 8F 66 B8 2E 02 EB 89 66 B8 2F 02 EB 83 E9 1D F2 FF FF 66 B8 30 02 EB F5 66 B8 31 02 EB EF 66 B8 32 02 EB E9 66 B8 33 02 EB E3 66 B8 34 02 EB DD 66 B8 35 02 EB D7 66 B8 36 02 EB D1 66 B8 37 02 EB CB 66 B8 38 02 EB C5 66 B8 39 02 EB BF 66 B8 3A 02 EB B9 66 B8 3B 02 EB B3 66 B8 3C 02 EB AD 66 B8 3D 02 EB A7 66 B8 3E 02 EB A1 66 B8 3F 02 EB 9B 66 B8 40 02 EB 95 66 B8 41 02 EB 8F 66 B8 42 02 EB 89 66 B8 43 02 EB 83 E9 A0 F1 FF FF 66 B8 44 02 EB F5 66 B8 45 02 EB EF 66 B8 46 02 EB E9 66 B8 47 02 EB E3 66 B8 48 02 EB DD 66 B8 49 02 EB D7 66 B8 4A 02 EB D1 66 B8 4B 02 EB CB 66 B8 4C 02 EB C5 66 B8 4D 02 EB BF 66 B8 4E 02 EB B9 66 B8 4F 02 EB B3 66 B8 50 02 EB AD 66 B8 51 02 EB A7 66 B8 52 02 EB A1 66 B8 53 02 EB 9B 66 B8 54 02 EB 95 66 B8 55 02 EB 8F 66 B8 56 02 EB 89 66 B8 57 02 EB 83 E9 23 F1 FF FF 66 B8 58 02 EB F5 66 B8 59 02 EB EF 66 B8 5A 02 EB E9 66 B8 5B 02 EB E3 66 B8 5C 02 EB DD 66 B8 5D 02 EB D7 66 B8 5E 02 EB D1 66 B8 5F 02 EB CB 66 B8 60 02 EB C5 66 B8 61 02 EB BF 66 B8 62 02 EB B9 66 B8 63 02 EB B3 66 B8 64 02 EB AD 66 B8 65 02 EB A7 66 B8 66 02 EB A1 66 B8 67 02 EB 9B 66 B8 68 02 EB 95 66 B8 69 02 EB 8F 66 B8 6A 02 EB 89 66 B8 6B 02 EB 83 E9 A6 F0 FF FF 66 B8 6C 02 EB F5 66 B8 6D 02 EB EF 66 B8 6E 02 EB E9 66 B8 6F 02 EB E3 66 B8 70 02 EB DD 66 B8 71 02 EB D7 66 B8 72 02 EB D1 66 B8 73 02 EB CB 66 B8 74 02 EB C5 66 B8 75 02 EB BF 66 B8 76 02 EB B9 66 B8 77 02 EB B3 66 B8 78 02 EB AD 66 B8 79 02 EB A7 66 B8 7A 02 EB A1 66 B8 7B 02 EB 9B 66 B8 7C 02 EB 95 66 B8 7D 02 EB 8F 66 B8 7E 02 EB 89 66 B8 7F 02 EB 83 E9 29 F0 FF FF 66 B8 80 02 EB F5 66 B8 81 02 EB EF 66 B8 82 02 EB E9 66 B8 83 02 EB E3 66 B8 84 02 EB DD 66 B8 85 02 EB D7 66 B8 86 02 EB }
	condition:
		$1
}

rule function_1147_0 {
	meta:
		name = "_DF_"
		size = 1233
		refs = "00a7 IsDBCSLeadByte 00d0 GetCurrentDirectoryA 00e4 FatalAppExitA 014b GlobalAlloc 0151 GlobalLock 016d FindFirstFileA 0178 FindClose 01a0 _DV_ 01aa RegOpenKeyExA 01cd RegQueryValueExA 01dd RegCloseKey 01f9 InitializeCriticalSection 0222 DeleteCriticalSection 023b InterlockedIncrement 0249 CreateMutexA 0263 InterlockedDecrement 026d ReleaseMutex 027b CloseHandle 0285 EnterCriticalSection 02a3 LeaveCriticalSection 02c1 SetErrorMode 030c LoadLibraryA 0347 SearchPathA 036e GetLastError 039e __APIINFOTABLE 03a8 __APIINFOTABLEEND 0468 GetModuleHandleA"
	strings:
		$1 = { 55 8B EC 53 8B 55 08 8B 45 0C 80 38 00 74 0A 8A 08 40 8A 1A 42 3A CB 74 F1 80 38 00 75 0C 80 3A 00 75 07 B8 01 00 00 00 EB 02 33 C0 5B 5D C2 08 00 55 8B EC 53 56 57 8B 75 08 8B 55 0C 8B 4D 10 66 85 F6 74 2E 33 C0 EB 0F 0F B7 D8 8D 3C 19 0F B7 D8 8A 1C 1A 88 1F 40 0F B7 D8 80 3C 1A 00 74 0B 0F B7 D8 0F B7 FE 4F 3B DF 7C DD 0F B7 C0 C6 04 01 00 5F 5E 5B 5D C2 0C 00 55 8B EC 53 56 57 8B 7D 08 8B 75 0C 83 C8 FF 33 DB 3B FB 7E 2E 8A 14 1E 84 D2 75 05 83 C8 FF EB 22 48 75 07 B8 02 00 00 00 EB 13 52 E8 ?? ?? ?? ?? 85 C0 74 07 B8 01 00 00 00 EB 02 33 C0 43 3B FB 7F D2 5F 5E 5B 5D C2 08 00 55 8B EC 53 8B 5D 0C 53 FF 75 08 E8 ?? ?? ?? ?? 8B C3 5B 5D C2 08 00 55 8B EC FF 75 08 6A 00 E8 ?? ?? ?? ?? 5D C2 04 00 55 8B EC 53 56 8B 75 10 8B DE 8B 45 0C 33 D2 EB 08 8A 08 40 43 88 4B FF 42 80 38 00 75 F3 3B F3 74 1A 80 7B FF 5C 75 10 56 0F BF C2 48 50 E8 5B FF FF FF 83 F8 02 75 04 C6 03 5C 43 8B 45 08 EB 07 8A 10 40 43 88 53 FF 80 38 00 75 F4 C6 03 00 5E 5B 5D C2 0C 00 55 8B EC FF 75 08 6A 40 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5D C2 04 00 55 8B EC 81 C4 C0 FE FF FF 8D 85 C0 FE FF FF 50 FF 75 08 E8 ?? ?? ?? ?? 83 F8 FF 74 0D 50 E8 ?? ?? ?? ?? B8 01 00 00 00 EB 02 33 C0 8B E5 5D C2 04 00 55 8B EC 83 C4 F8 53 33 DB 8D 45 FC 50 68 19 00 02 00 6A 00 68 ?? ?? ?? ?? 68 02 00 00 80 E8 ?? ?? ?? ?? 85 C0 75 31 0F B7 55 08 89 55 F8 8D 4D F8 51 FF 75 0C 6A 00 6A 00 68 ?? ?? ?? ?? FF 75 FC E8 ?? ?? ?? ?? 85 C0 74 04 66 BB 04 2A FF 75 FC E8 ?? ?? ?? ?? EB 04 66 BB 04 2A 8B C3 5B 59 59 5D C2 08 00 55 8B EC 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 01 00 00 00 5D C3 55 8B EC 83 3D ?? ?? ?? ?? 00 74 11 33 C0 A3 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 55 8B EC 53 83 3D ?? ?? ?? ?? 00 75 4A 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 01 6A 00 E8 ?? ?? ?? ?? 8B D8 83 3D ?? ?? ?? ?? 00 75 05 E8 93 FF FF FF 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 08 53 E8 ?? ?? ?? ?? EB 0C 53 E8 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 01 00 00 00 5B 5D C3 55 8B EC 83 3D ?? ?? ?? ?? 00 74 0A 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 55 8B EC 81 C4 F0 FC FF FF 53 56 57 8B 5D 08 8B 75 0C 68 00 80 00 00 E8 ?? ?? ?? ?? 8B F8 85 DB 74 04 8B C3 EB 17 8D 95 F8 FE FF FF 52 68 04 01 00 00 E8 E4 FD FF FF 8D 85 F8 FE FF FF 8D 95 F0 FC FF FF 52 50 56 E8 F8 FD FF FF 8D 8D F0 FC FF FF 51 E8 59 FE FF FF 85 C0 74 12 8D 85 F0 FC FF FF 50 E8 ?? ?? ?? ?? 8B D8 85 DB 75 5C 8D 85 F4 FD FF FF 50 68 04 01 00 00 E8 64 FE FF FF 66 85 C0 75 35 8D 55 FC 52 8D 8D F0 FC FF FF 51 68 04 01 00 00 6A 00 56 8D 85 F4 FD FF FF 50 E8 ?? ?? ?? ?? 85 C0 74 12 8D 95 F0 FC FF FF 52 E8 ?? ?? ?? ?? 8B D8 85 DB 75 11 56 E8 ?? ?? ?? ?? 8B D8 85 DB 75 05 E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 8B E5 5D C2 08 00 55 8B EC 8B 45 08 5D C2 04 00 55 8B EC 5D C2 04 00 55 8B EC 53 56 57 8B 75 08 BF ?? ?? ?? ?? E8 81 FE FF FF B8 ?? ?? ?? ?? 2B C7 B9 30 00 00 00 33 D2 F7 F1 33 DB 3B C3 76 11 8B D3 03 D2 8D 14 52 3B 34 D7 74 05 43 3B C3 77 EF 3B C3 76 64 33 F6 EB 20 8B C3 C1 E0 04 8D 04 40 03 C7 50 56 8B D3 03 D2 8D 14 52 8B 4C D7 2A FF 34 B1 E8 C6 00 00 00 46 8B C3 03 C0 8D 04 40 0F B7 54 C7 04 3B F2 72 D0 8B CB C1 E1 04 8D 0C 49 03 CF 51 E8 6D FF FF FF 8B D3 03 D2 8D 14 52 33 C9 89 0C D0 8B D3 03 D2 8D 14 52 66 C7 44 D0 2E 00 00 50 E8 57 FF FF FF E8 CE FD FF FF 5F 5E 5B 5D C2 04 00 55 8B EC 51 53 56 57 8B 7D 08 33 C0 89 45 FC 57 E8 2C FF FF FF 8B D8 85 DB 75 06 66 B8 01 25 EB 50 8D 57 06 52 E8 ?? ?? ?? ?? 8B F0 85 F6 75 24 83 C7 06 57 6A 00 E8 2C FE FF FF 8B F0 85 F6 75 0C 53 E8 04 FF FF FF 66 B8 0A 21 EB 24 C7 45 FC 01 00 00 00 89 33 66 8B 55 FC 66 09 53 2E 53 E8 E7 FE FF FF 56 68 ?? ?? ?? ?? E8 15 02 00 00 33 C0 5F 5E 5B 59 5D C2 04 00 55 8B EC 8B 45 10 8B 50 26 8B 4D 0C 8B 45 08 89 04 8A 5D C2 0C 00 }
	condition:
		$1
}

rule function_1148_0 {
	meta:
		name = "__LOADFUNC"
		size = 661
		refs = "0040 GetProcAddress 007e __APIINFOTABLE 0090 __APIINFOTABLEEND 00ce FreeLibrary 01c3 _DV_ 0264 GetLastError"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 75 08 8B 1E 8B 7E 04 E8 44 FD FF FF 85 C0 75 07 B8 06 2A 00 00 EB 42 83 3B 00 75 12 53 E8 48 FF FF FF 66 85 C0 74 07 0F B7 D0 8B C2 EB 2B 66 8B 46 08 0F B7 D0 52 FF 33 E8 ?? ?? ?? ?? 8B F0 85 F6 75 07 B8 4F 27 00 00 EB 0F 53 57 56 E8 91 FF FF FF E8 62 FD FF FF 8B C6 5F 5E 5B 5D C2 04 00 55 8B EC E8 B0 FC FF FF B8 01 00 00 00 5D C3 55 8B EC 51 53 56 57 BF ?? ?? ?? ?? E8 D0 FC FF FF 85 C0 0F 84 B5 00 00 00 B8 ?? ?? ?? ?? 2B C7 B9 30 00 00 00 33 D2 F7 F1 89 45 FC 33 DB 3B 5D FC 73 63 8B C3 03 C0 8D 04 40 8B 34 C7 85 F6 74 1B 56 E8 6E 01 00 00 8B C3 03 C0 8D 04 40 66 83 7C C7 2E 00 74 06 56 E8 ?? ?? ?? ?? 33 F6 EB 20 8B C3 C1 E0 04 8D 04 40 03 C7 50 56 8B D3 03 D2 8D 14 52 8B 4C D7 2A FF 34 B1 E8 F5 FE FF FF 46 8B C3 03 C0 8D 04 40 0F B7 54 C7 04 3B F2 72 D0 43 3B 5D FC 72 9D 57 E8 A0 FD FF FF 33 DB 3B 5D FC 73 20 8B D3 03 D2 8D 14 52 33 C9 89 0C D0 8B D3 03 D2 8D 14 52 66 C7 44 D0 2E 00 00 43 3B 5D FC 72 E0 50 E8 7D FD FF FF E8 F4 FB FF FF 5F 5E 5B 59 5D C3 55 8B EC 53 56 57 8B 75 0C 56 FF 75 08 E8 D3 F9 FF FF 85 C0 74 0A B8 01 00 00 00 E9 84 00 00 00 B8 ?? ?? ?? ?? 2D ?? ?? ?? ?? B9 30 00 00 00 33 D2 F7 F1 8B F8 33 DB 3B FB 76 67 8B C3 C1 E0 04 8D 04 40 05 ?? ?? ?? ?? 50 56 E8 96 F9 FF FF 85 C0 75 4A 8B D3 03 D2 8D 14 52 83 3C D5 ?? ?? ?? ?? 00 74 04 33 C0 EB 3C 68 ?? ?? ?? ?? E8 F6 FC FF FF 8B D8 85 DB 75 0A 68 ?? ?? ?? ?? E8 3E FA FF FF 8D 43 06 50 FF 75 08 6A 20 E8 86 F9 FF FF 53 E8 DC FC FF FF B8 01 00 00 00 EB 07 43 3B FB 77 99 33 C0 5F 5E 5B 5D C2 08 00 55 8B EC 83 C4 F4 68 ?? ?? ?? ?? FF 75 0C E8 ?? ?? ?? ?? 66 C7 45 F4 01 00 C7 45 F6 ?? ?? ?? ?? 8B 55 08 89 55 FA 85 C0 74 06 8D 4D F4 51 FF D0 8B E5 5D C2 08 00 55 8B EC 53 8B 5D 08 68 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 85 C0 74 04 FF D0 EB 16 68 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 85 C0 74 07 68 ?? ?? ?? ?? FF D0 5B 5D C2 04 00 55 8B EC E8 ?? ?? ?? ?? 83 C0 FE 83 E8 02 72 11 83 E8 0A 74 12 83 E8 70 74 07 83 E8 23 74 02 EB 0C 66 B8 08 21 EB 0A 66 B8 01 25 EB 04 66 B8 09 21 5D C2 04 00 }
	condition:
		$1
}

rule function_1149_0 {
	meta:
		name = "DbiInitFn"
		size = 251
		refs = "0017 _DV_ 0075 GetProcAddress 00d8 FreeLibrary"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 33 C0 89 45 FC 33 D2 89 55 F8 33 FF 83 3D ?? ?? ?? ?? 00 75 40 68 ?? ?? ?? ?? 6A 00 E8 19 FB FF FF 8B D8 85 DB 75 0F 53 E8 95 FF FF FF 8B F0 33 DB E9 8D 00 00 00 C7 45 F8 01 00 00 00 E8 87 FD FF FF 85 C0 75 06 66 BE 01 25 EB 77 C7 45 FC 01 00 00 00 EB 06 8B 1D ?? ?? ?? ?? E8 59 FA FF FF BF 01 00 00 00 68 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 85 C0 75 06 66 BE 06 2A EB 49 FF 75 0C 66 8B 55 08 52 FF D0 8B F0 66 85 F6 75 38 66 83 3D ?? ?? ?? ?? 00 75 12 68 ?? ?? ?? ?? E8 75 FB FF FF 89 18 50 E8 77 FB FF FF 68 ?? ?? ?? ?? E8 63 FB FF FF 66 FF 00 50 E8 64 FB FF FF E8 63 FA FF FF 33 C0 EB 26 85 DB 74 0C 83 7D F8 00 74 06 53 E8 ?? ?? ?? ?? 83 7D FC 00 74 05 E8 FA FC FF FF 85 FF 74 05 E8 3B FA FF FF 8B C6 5F 5E 5B 59 59 5D C2 08 00 }
	condition:
		$1
}

rule function_1150_0 {
	meta:
		name = "DbiExit"
		size = 128
		refs = "0006 _DV_ 0011 GetProcAddress 0062 FreeLibrary"
	strings:
		$1 = { 55 8B EC 53 56 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 85 DB 75 06 66 B8 4F 27 EB 5B FF D3 66 85 C0 75 54 66 83 3D ?? ?? ?? ?? 00 76 48 68 ?? ?? ?? ?? E8 E6 FA FF FF 8B D8 85 DB 74 03 66 FF 0B 66 83 3D ?? ?? ?? ?? 00 75 25 68 ?? ?? ?? ?? E8 C9 FA FF FF 8B F0 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 F6 74 04 33 C0 89 06 56 E8 B8 FA FF FF 53 E8 B2 FA FF FF 33 C0 5E 5B 5D C3 }
	condition:
		$1
}

rule function_1151_0 {
	meta:
		name = "DbiDLLExit"
		size = 100
		refs = "0008 __APIINFOTABLEEND 000d __APIINFOTABLE 0033 INFO_IDAPI32 005e DbiGetSysVersion"
	strings:
		$1 = { 55 8B EC 53 56 33 F6 B8 ?? ?? ?? ?? 2D ?? ?? ?? ?? B9 30 00 00 00 33 D2 F7 F1 85 C0 74 07 E8 43 FC FF FF EB 2D E8 1D F9 FF FF 85 C0 75 04 8B C6 EB 22 BB ?? ?? ?? ?? 8B 03 85 C0 74 10 50 E8 D8 FD FF FF 33 D2 89 13 66 C7 43 2E 00 00 E8 D6 F8 FF FF 8B C6 5E 5B 5D C3 55 8B EC 6A 00 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule function_1156_0 {
	meta:
		name = "GetObjectContext"
		size = 136
		refs = "0015 GetObjectContext 0040 @HandleAnyException 0045 @DoneExcept 0056 @IntfCopy 0060 @IntfClear 007b @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 33 D2 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 0A E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 7D F8 00 74 0D 8B 45 FC 8B 55 F8 E8 ?? ?? ?? ?? EB 08 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1158_0 {
	meta:
		name = "BdeMts"
		size = 31
		refs = "0002 _DV_1 000a GetObjectContextProc 001a GetObjectContext"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 15 A1 ?? ?? ?? ?? 83 38 00 75 0B A1 ?? ?? ?? ?? C7 00 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1187_0 {
	meta:
		name = "BdeProv"
		size = 31
		refs = "0002 _DV_2 000a CreateProviderProc 001a CreateProvider"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 15 A1 ?? ?? ?? ?? 83 38 00 75 0B A1 ?? ?? ?? ?? C7 00 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1159_0 {
	meta:
		name = "CreateProvider"
		size = 45
		refs = "000c _DV_TProvider 0011 TProvider.Create 0025 TProvider.SetDataSet"
	strings:
		$1 = { 53 56 57 8B FA 8B F0 8B CE B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 8B D7 8B C3 8B 08 FF 51 38 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1160_0 {
	meta:
		name = "TCachedQuery.Create"
		size = 71
		refs = "000a @ClassCreate 0017 TQuery.Create 001e _Dn_TList 0023 TObject.Create 0034 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 86 40 02 00 00 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1161_0 {
	meta:
		name = "TCachedQuery.Destroy"
		size = 55
		refs = "0003 @BeforeDestruction 000e TCachedQuery.ClearStatements 0019 TObject.Free 0025 TQuery.Destroy 0030 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B 86 40 02 00 00 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1162_0 {
	meta:
		name = "TCachedQuery.GetStatementHandle"
		size = 65
		refs = "000c TCachedQuery.GetStmtInfo 001e TQuery.GetStatementHandle 0028 @LStrFromPChar"
	strings:
		$1 = { 53 56 57 8B FA 8B D8 8B D7 8B C3 E8 ?? ?? ?? ?? 8B F0 8B 46 04 85 C0 75 1E 8B D7 8B C3 E8 ?? ?? ?? ?? 8D 46 08 8B D7 E8 ?? ?? ?? ?? 8B 83 50 01 00 00 89 46 04 EB 06 89 83 50 01 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1164_0 {
	meta:
		name = "TCachedQuery.ClearStatements"
		size = 98
		refs = "001f TList.Get 002f TQuery.FreeStatement 0042 TStmtInfo 0047 @Dispose 005a @CallDynaInst"
	strings:
		$1 = { 53 56 57 8B D8 8B 83 40 02 00 00 8B 78 08 4F 85 FF 7C 3C 47 33 F6 8B D6 8B 83 40 02 00 00 E8 ?? ?? ?? ?? 8B 40 04 89 83 50 01 00 00 8B C3 E8 ?? ?? ?? ?? 8B D6 8B 83 40 02 00 00 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 46 4F 75 C7 8B 83 40 02 00 00 66 BB FF FF E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1165_0 {
	meta:
		name = "GetHashCode"
		size = 105
		refs = "0013 StrLen"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B F8 33 DB BE 01 00 00 00 8B C7 E8 ?? ?? ?? ?? 83 F8 10 7D 1B 48 83 F8 00 7C 3F 33 D2 8A 14 37 6B CB 25 03 D1 8B DA 46 48 83 F8 FF 75 ED EB 2A 8B D0 85 D2 79 03 83 C2 07 C1 FA 03 89 55 FC 48 85 C0 7C 16 33 D2 8A 14 37 6B CB 27 03 D1 8B DA 2B 45 FC 03 75 FC 85 C0 7D EA 8B C3 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1166_0 {
	meta:
		name = "TCachedQuery.GetStmtInfo"
		size = 180
		refs = "0016 GetHashCode 0038 TList.Get 004a @LStrToPChar 0052 AnsiStrIComp 006d TStmtInfo 0077 @New 008a TList.Add 009a @FillChar"
	strings:
		$1 = { 53 56 57 55 83 C4 F4 89 14 24 8B E8 33 C0 89 44 24 04 8B 04 24 E8 ?? ?? ?? ?? 89 44 24 08 8B 85 40 02 00 00 8B 70 08 4E 85 F6 7C 38 46 33 FF 8B 85 40 02 00 00 8B D7 E8 ?? ?? ?? ?? 8B D8 8B 03 3B 44 24 08 75 1A 8B 43 08 E8 ?? ?? ?? ?? 8B 14 24 E8 ?? ?? ?? ?? 85 C0 75 06 89 5C 24 04 EB 04 47 4E 75 CB 83 7C 24 04 00 75 3D 8B 15 ?? ?? ?? ?? B8 0C 00 00 00 E8 ?? ?? ?? ?? 89 44 24 04 8B 85 40 02 00 00 8B 54 24 04 E8 ?? ?? ?? ?? 8B 44 24 04 33 C9 BA 0C 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 04 8B 54 24 08 89 10 8B 44 24 04 83 C4 0C 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1167_0 {
	meta:
		name = "TProvider.Create"
		size = 105
		refs = "000e @ClassCreate 001c TDataSetProvider.Create 002c _DV_TCachedQuery 0031 TCachedQuery.Create 0054 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B D8 33 D2 8B C3 E8 ?? ?? ?? ?? C6 83 80 00 00 00 00 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 84 00 00 00 C6 86 3D 02 00 00 00 C6 83 8C 00 00 00 00 8B C3 80 7D FF 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1168_0 {
	meta:
		name = "TProvider.GetDataSet"
		size = 12
		refs = "0006 TDataSetProvider.GetDataSet"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_18486_0 {
	meta:
		name = "FormatClearStr"
		size = 12
		refs = "0006 @LStrClr"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1223_0 {
	meta:
		name = "TAttachments.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_5363_0 {
	meta:
		name = "TCheckConstraints.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_9914_0 {
	meta:
		name = "TCookieCollection.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_3277_0 {
	meta:
		name = "TCoolBands.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_13451_0 {
	meta:
		name = "TCubeDims.Add"
		size = 12
		refs = "0006 TDimensionItems.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_6649_0 {
	meta:
		name = "TDBGridColumns.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_6936_0 {
	meta:
		name = "TDataBindings.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_12788_0 {
	meta:
		name = "TDimensionItems.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_4921_0 {
	meta:
		name = "TFieldDefs.AddFieldDef"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_7524_0 {
	meta:
		name = "THTMLTableColumns.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2467_0 {
	meta:
		name = "THeaderSections.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_10593_0 {
	meta:
		name = "TIdCookieCollection.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_10310_0 {
	meta:
		name = "TIdDNSQuestionList.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_10317_0 {
	meta:
		name = "TIdDNSResourceList.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_10357_0 {
	meta:
		name = "TIdEMailAddressList.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_10479_0 {
	meta:
		name = "TIdGopherMenu.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_5304_0 {
	meta:
		name = "TIndexDefs.AddIndexDef"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2885_0 {
	meta:
		name = "TListColumns.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1226_0 {
	meta:
		name = "TMailAddresses.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1216_0 {
	meta:
		name = "TMailBox.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_13501_0 {
	meta:
		name = "TQueryDims.Add"
		size = 12
		refs = "0006 TDimensionItems.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2416_0 {
	meta:
		name = "TStatusPanels.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_9975_0 {
	meta:
		name = "TWebActionItems.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_12461_0 {
	meta:
		name = "mci_HMS_Second"
		size = 12
		refs = "0006 HiWord"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_12452_0 {
	meta:
		name = "mci_MSF_Frame"
		size = 12
		refs = "0006 HiWord"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_12456_0 {
	meta:
		name = "mci_TMSF_Second"
		size = 12
		refs = "0006 HiWord"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1170_0 {
	meta:
		name = "TProvider.ApplyUpdates"
		size = 354
		refs = "0014 TProvider.GetDataSet 0028 TDBDataSet.GetDBSession 002e TSession.OpenDatabase 0041 TProvider.ApplyUpdates 0058 TDBDataSet.SetSessionName 0072 TDBDataSet.SetDatabaseName 0080 TDatabase.GetInTransaction 00ac TDatabase.StartTransaction 00cf TDataSetProvider.ApplyUpdates 0100 TDatabase.Commit 0110 TDatabase.Rollback 0116 @HandleFinally 0133 TCachedQuery.ClearStatements 014e TSession.CloseDatabase"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 89 4D F8 8B DA 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 8B 80 10 02 00 00 50 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B F0 8B 45 FC 89 B0 88 00 00 00 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 56 4C 8B 45 FC 8B 80 84 00 00 00 E8 ?? ?? ?? ?? 8B 45 FC 8B 80 88 00 00 00 8B 50 50 8B 45 FC 8B 80 84 00 00 00 E8 ?? ?? ?? ?? 8B 45 FC 8B 80 88 00 00 00 E8 ?? ?? ?? ?? 34 01 88 45 F7 80 7D F7 00 74 21 8B 45 FC 8B 80 88 00 00 00 80 78 30 00 75 04 C6 40 28 00 8B 45 FC 8B 80 88 00 00 00 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 0C 50 8B 45 08 50 8B D3 8B 4D F8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 80 7D F7 00 74 2E 8B 45 0C 8B 00 3B 45 F8 7E 06 83 7D F8 FF 75 10 8B 45 FC 8B 80 88 00 00 00 E8 ?? ?? ?? ?? EB 0E 8B 45 FC 8B 80 88 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB C4 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 80 84 00 00 00 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B 92 88 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB CF 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_1171_0 {
	meta:
		name = "TProvider.GetUpdateException"
		size = 89
		refs = "0019 _Dn_EDBEngineError 001e @IsClass 002b EDBEngineError.GetError 003e _Dn_EUpdateError 0043 EUpdateError.Create 0050 TBaseProvider.GetUpdateException"
	strings:
		$1 = { 53 56 57 55 8B F1 8B DA 8B E8 85 F6 74 05 8B 7E 0C EB 02 33 FF 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 23 33 D2 8B C3 E8 ?? ?? ?? ?? 6A 00 0F B7 40 04 50 57 53 8B 4B 04 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 0B 8B CE 8B D3 8B C5 E8 ?? ?? ?? ?? 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1172_0 {
	meta:
		name = "TProvider.GetKeyFields"
		size = 347
		refs = "001c TProvider.GetKeyFields 0029 @LStrClr 0032 _Dn_TTable 0037 TTable.Create 0052 TTable.SetTableName 005c TDataSet.SetObjectView 006d TDBDataSet.SetSessionName 007e TDBDataSet.SetDatabaseName 008c TIndexDefs.Update 009a TCollection.GetCount 00b5 TIndexDefs.GetIndexDef 00d9 TIndexDef.GetFields 00ea ExtractFieldName 00f5 TDataSet.FindField 0105 @LStrLen 0129 TObject.Free 012f @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 89 4D FC 8B FA 8B D8 8B 75 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 33 C9 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D7 8B 45 F8 E8 ?? ?? ?? ?? B2 01 8B 45 F8 E8 ?? ?? ?? ?? 8B 83 88 00 00 00 8B 50 4C 8B 45 F8 E8 ?? ?? ?? ?? 8B 83 88 00 00 00 8B 50 50 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 F8 8B 80 1C 02 00 00 E8 ?? ?? ?? ?? 8B 45 F8 8B 80 1C 02 00 00 E8 ?? ?? ?? ?? 48 85 C0 7C 75 40 89 45 F0 33 FF 8B 45 F8 8B 80 1C 02 00 00 8B D7 E8 ?? ?? ?? ?? F6 40 20 02 74 53 C7 45 F4 01 00 00 00 8B 45 F8 8B 80 1C 02 00 00 8B D7 E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 33 DB EB 21 8D 4D EC 8D 55 F4 8B 06 E8 ?? ?? ?? ?? 8B 55 EC 8B 45 FC E8 ?? ?? ?? ?? 85 C0 0F 95 C3 84 DB 74 0C 8B 06 E8 ?? ?? ?? ?? 3B 45 F4 7D D3 84 DB 75 06 47 FF 4D F0 75 91 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_1173_0 {
	meta:
		name = "TProvider.ExecSQL"
		size = 183
		refs = "000d TProvider.ExecSQL 0045 TQuery.ExecSQL 0050 TQuery.GetRowsAffected 005b STooManyRecordsModified 0060 LoadResString 006a DatabaseError 0080 SRecordChanged 00a4 @LStrClr 00aa @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 86 84 00 00 00 8B 80 18 02 00 00 8B D1 8B 08 FF 51 08 8B 86 84 00 00 00 8B 80 20 02 00 00 8B 55 08 8B 08 FF 51 08 8B 86 84 00 00 00 E8 ?? ?? ?? ?? 8B 86 84 00 00 00 E8 ?? ?? ?? ?? 48 7E 17 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 33 D2 E8 ?? ?? ?? ?? 8B 86 84 00 00 00 E8 ?? ?? ?? ?? 48 7D 17 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 33 D2 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_1174_0 {
	meta:
		name = "TProvider.GetValues"
		size = 175
		refs = "0045 TDataSet.Open 004d TProvider.GetValues 0070 _Dn_TPacketDataSet 0075 @AsClass 0083 TPacketDataSet.AssignCurValues 009e TDataSet.Close 00a4 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 89 45 FC 8B 45 FC 8B 80 84 00 00 00 8B 80 18 02 00 00 8B D1 8B 08 FF 51 08 8B 45 FC 8B 80 84 00 00 00 8B 80 20 02 00 00 8B 55 0C 8B 08 FF 51 08 8B 45 FC 8B 80 84 00 00 00 C6 80 35 02 00 00 00 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 80 84 00 00 00 8B 10 FF 92 F4 00 00 00 48 75 1C 8B 45 08 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B 92 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 80 84 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EA 59 5D C2 08 00 }
	condition:
		$1
}

rule function_1175_0 {
	meta:
		name = "TProvider.SetResolveToDataSet"
		size = 36
		refs = "0017 TBaseProvider.FreeResolver"
	strings:
		$1 = { 53 56 8B DA 8B F0 3A 9E 80 00 00 00 74 0D 83 7E 38 00 74 07 8B C6 E8 ?? ?? ?? ?? 88 9E 80 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_1176_0 {
	meta:
		name = "TProvider.Reset"
		size = 58
		refs = "0006 TDataSetProvider.Reset 000d TProvider.GetDataSet 001d TDataSet.GetActive 0034 DbiForceReread"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 85 C0 74 23 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 13 8B C3 E8 ?? ?? ?? ?? 8B 80 4C 01 00 00 50 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1177_0 {
	meta:
		name = "TProvider.CreateResolver"
		size = 70
		refs = "0011 _Dn_TDataSetResolver 0016 TDataSetResolver.Create 0024 TProvider.ExecSQL 002f TProvider.GetValues 0039 _Dn_TSQLResolver 003e TSQLResolver.Create"
	strings:
		$1 = { 83 C4 F0 80 B8 80 00 00 00 00 74 10 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 26 89 44 24 0C C7 44 24 08 ?? ?? ?? ?? 89 44 24 04 C7 04 24 ?? ?? ?? ?? 54 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule function_1178_0 {
	meta:
		name = "TProvider.GetParamCount"
		size = 146
		refs = "0009 TProvider.GetDataSet 001a _Dn_TTable 001f @IsClass 002f TBDEDataSet.GetIndexFieldCount 0040 _Dn_TQuery 005b TCollection.GetCount 006c _Dn_TStoredProc"
	strings:
		$1 = { 53 56 8B D8 33 F6 8B C3 E8 ?? ?? ?? ?? 85 C0 74 7C 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 10 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 EB 56 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 16 8B C3 E8 ?? ?? ?? ?? 8B 80 20 02 00 00 E8 ?? ?? ?? ?? 8B F0 EB 2A 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 14 8B C3 E8 ?? ?? ?? ?? 8B 80 1C 02 00 00 E8 ?? ?? ?? ?? 8B F0 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1179_0 {
	meta:
		name = "TProvider.SetParamByName"
		size = 79
		refs = "000c TProvider.GetDataSet 0012 _Dn_TQuery 0017 @IsClass 0040 TParams.ParamByName 0047 TParam.SetAsVariant"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0F 8B C3 E8 ?? ?? ?? ?? 8B 98 20 02 00 00 EB 0D 8B C3 E8 ?? ?? ?? ?? 8B 98 1C 02 00 00 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1180_0 {
	meta:
		name = "TProvider.SetParamByIndex"
		size = 79
		refs = "000c TProvider.GetDataSet 0012 _Dn_TQuery 0017 @IsClass 0040 TParams.GetItem 0047 TParam.SetAsVariant"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0F 8B C3 E8 ?? ?? ?? ?? 8B 98 20 02 00 00 EB 0D 8B C3 E8 ?? ?? ?? ?? 8B 98 1C 02 00 00 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1181_0 {
	meta:
		name = "TProvider.FetchParams"
		size = 473
		refs = "001b TProvider.FetchParams 0028 TProvider.GetDataSet 002e _Dn_TQuery 0033 @IsClass 0053 _Dn_TStoredProc 0078 TCollection.GetCount 0085 Null 008a @OleVarFromVar 00b5 VarArrayCreate 00df TParams.GetItem 00ef @VarFromLStr 0107 TParam.GetDataType 0114 @VarFromInt 012c TParam.GetParamType 015d TParam.GetAsVariant 0181 VarArrayOf 018e @VarArrayPut 01b4 Variant 01be @FinalizeArray 01c6 @VarClr 01cc @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 14 00 00 00 6A 00 6A 00 49 75 F9 53 56 57 89 55 FC 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0F 8B C3 E8 ?? ?? ?? ?? 8B B8 20 02 00 00 EB 27 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0F 8B C3 E8 ?? ?? ?? ?? 8B B8 1C 02 00 00 EB 02 33 FF 85 FF 74 0B 8B C7 E8 ?? ?? ?? ?? 85 C0 75 13 8B 45 FC 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 0C 01 00 00 8D 45 E8 50 33 C0 89 45 E0 8B C7 E8 ?? ?? ?? ?? 48 89 45 E4 8D 45 E0 B9 0C 00 00 00 BA 01 00 00 00 E8 ?? ?? ?? ?? 8D 55 E8 8B 45 FC E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 48 85 C0 0F 8C CB 00 00 00 40 89 45 F8 33 F6 8B D6 8B C7 E8 ?? ?? ?? ?? 8B D8 56 6A 01 8D 45 90 8B 53 24 E8 ?? ?? ?? ?? 56 57 8D 75 90 8D 7D A0 B9 04 00 00 00 F3 A5 5F 5E 8B C3 E8 ?? ?? ?? ?? 8B D0 0F BE D2 8D 45 80 E8 ?? ?? ?? ?? 56 57 8D 75 80 8D 7D B0 B9 04 00 00 00 F3 A5 5F 5E 8B C3 E8 ?? ?? ?? ?? 8B D0 0F BE D2 8D 85 70 FF FF FF E8 ?? ?? ?? ?? 56 57 8D B5 70 FF FF FF 8D 7D C0 B9 04 00 00 00 F3 A5 5F 5E 8D 95 60 FF FF FF 8B C3 E8 ?? ?? ?? ?? 56 57 8D B5 60 FF FF FF 8D 7D D0 B9 04 00 00 00 F3 A5 5F 5E 8D 45 A0 8D 4D E8 BA 03 00 00 00 E8 ?? ?? ?? ?? 8D 45 E8 50 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 10 46 FF 4D F8 0F 85 3B FF FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 60 FF FF FF 8B 15 ?? ?? ?? ?? B9 04 00 00 00 E8 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DA 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1182_0 {
	meta:
		name = "TProvider.FetchData"
		size = 149
		refs = "0011 TProvider.GetDataSet 0025 TDBDataSet.GetDBSession 002b TSession.OpenDatabase 003c TProvider.FetchData 004e TDataSetProvider.FetchData 0069 TCachedQuery.ClearStatements 0084 TSession.CloseDatabase 008a @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 8B F1 8B DA 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 8B 80 10 02 00 00 50 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B 55 FC 89 82 88 00 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B CE 8B D3 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 80 84 00 00 00 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B 92 88 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB CF 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1183_0 {
	meta:
		name = "AssignFields"
		size = 345
		refs = "0019 AssignFields 002f VarArrayHighBound 0038 TBDEDataSet.GetIndexFieldCount 0066 @VarArrayGet 0071 VarIsArray 00aa @VarToLStr 00b4 TDataSet.FieldByName 00f6 TBDEDataSet.GetIndexField 0136 @VarClr 013e @LStrClr 014c @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 57 8B F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 83 C0 F0 BA 01 00 00 00 E8 ?? ?? ?? ?? 8B D8 8B C7 E8 ?? ?? ?? ?? 3B D8 7C 0A 8B C7 E8 ?? ?? ?? ?? 8B D8 4B 8B F3 85 F6 0F 8C D1 00 00 00 46 33 DB 53 6A 01 8B 45 08 83 C0 F0 50 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 10 8D 45 F0 E8 ?? ?? ?? ?? 84 C0 74 78 6A 00 6A 01 53 6A 01 8B 45 08 83 C0 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 10 8D 45 DC 50 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 F0 8D 45 EC E8 ?? ?? ?? ?? 8B 55 EC 8B C7 E8 ?? ?? ?? ?? 50 6A 01 6A 01 53 6A 01 8B 45 08 83 C0 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 10 8D 45 DC 50 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 F0 58 8B 08 FF 91 9C 00 00 00 EB 2C 8B D3 8B C7 E8 ?? ?? ?? ?? 50 53 6A 01 8B 45 08 83 C0 F0 50 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 F0 58 8B 08 FF 91 9C 00 00 00 43 4E 0F 85 32 FF FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1184_0 {
	meta:
		name = "TProvider.SetParams"
		size = 323
		refs = "0029 @VarAddRef 0031 TProvider.SetParams 003e TProvider.GetDataSet 0044 _Dn_TTable 0049 @IsClass 0059 VarIsNull 0065 VarIsArray 0083 VarArrayOf 008e @OleVarFromVar 00aa TTable.CancelRange 00ba TDataSet.Open 00c1 TTable.SetRangeStart 00ce AssignFields 00d6 TTable.SetRangeEnd 00eb TTable.ApplyRange 0107 TBaseProvider.SetParams 0113 TDataSet.Close 0128 @VarClr 0136 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 D0 53 56 57 33 C9 89 4D E0 89 4D E4 89 4D E8 89 4D EC 8B F2 8D 7D F0 B9 04 00 00 00 F3 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 AC 00 00 00 8D 45 F0 E8 ?? ?? ?? ?? 84 C0 75 31 8D 45 F0 E8 ?? ?? ?? ?? 84 C0 75 25 8D 75 F0 8D 7D D0 B9 04 00 00 00 F3 A5 8D 45 D0 8D 4D E0 33 D2 E8 ?? ?? ?? ?? 8D 55 E0 8D 45 F0 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B F0 8D 45 F0 E8 ?? ?? ?? ?? 84 C0 74 10 8B C6 E8 ?? ?? ?? ?? C6 83 8C 00 00 00 00 EB 3F 8B C6 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 55 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B C6 E8 ?? ?? ?? ?? 55 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B C6 E8 ?? ?? ?? ?? C6 83 8C 00 00 00 01 33 D2 8B C3 8B 08 FF 51 50 EB 16 8D 55 F0 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1214_0 {
	meta:
		name = "TOwnedCollection.Create"
		size = 65
		refs = "000d @ClassCreate 0020 TCollection.Create 002b @AfterConstruction"
	strings:
		$1 = { 55 8B EC 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 89 4E 18 8B 4D 08 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_1215_0 {
	meta:
		name = "TAggregates.GetOwner"
		size = 4
		altNames = "TCheckConstraints.GetOwner TCoolBands.GetOwner TDBGridColumns.GetOwner TDataBindings.GetOwner TDimensionItems.GetOwner THTMLTableColumns.GetOwner THeaderSections.GetOwner TIdHTTPSession.GetContent TListColumns.GetOwner TMIMEAttachment.GetStream TMIMEMail.GetAttachments TOwnedCollection.GetOwner TParams.GetOwner TPrinterSettings.GetCopies TStatusPanels.GetOwner TWebActionItems.GetOwner"
	strings:
		$1 = { 8B 40 18 C3 }
	condition:
		$1
}

rule function_1217_0 {
	meta:
		name = "THTMLTableColumns.GetAttrCount"
		size = 6
		altNames = "TMailAddresses.GetAttrCount TMailBox.GetAttrCount"
	strings:
		$1 = { B8 02 00 00 00 C3 }
	condition:
		$1
}

rule function_1218_0 {
	meta:
		name = "TMailBox.GetAttr"
		size = 68
		refs = "000a TMailBox.GetAttr 000f @LStrLAsg"
	strings:
		$1 = { 53 8B D9 85 D2 75 0E 8B C3 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 4A 75 0C 8B C3 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 00 00 FF FF FF FF 02 00 00 00 54 6F 00 00 FF FF FF FF 07 00 00 00 53 75 62 6A 65 63 74 00 }
	condition:
		$1
}

rule function_1219_0 {
	meta:
		name = "TMailBox.GetItemAttr"
		size = 85
		refs = "0013 TMailBox.GetMail 0025 TCollection.GetCount 0037 TMailAddresses.GetAddress"
	strings:
		$1 = { 55 8B EC 53 56 8B DA 85 DB 74 05 83 FB 01 75 3F 8B D1 E8 ?? ?? ?? ?? 8B F0 85 DB 75 28 8B C6 8B 10 FF 52 40 E8 ?? ?? ?? ?? 85 C0 7E 22 8B C6 8B 10 FF 52 40 33 D2 E8 ?? ?? ?? ?? 8B 55 08 8B 08 FF 51 1C EB 0A 8B 55 08 8B C6 8B 08 FF 51 3C 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_1220_0 {
	meta:
		name = "TAggregates.GetItem"
		size = 18
		refs = "000b TCollection.GetItem"
		altNames = "TAttachments.GetAttachment TCheckConstraints.GetItem TCookieCollection.GetCookie TCoolBands.GetItem TDBGridColumns.GetColumn TDataBindings.GetItem TDimensionItems.GetDimensionItem TDisplayDims.GetDisplayDim TFieldDefs.GetFieldDef THTMLTableColumns.GetColumn THeaderSections.GetItem TIdCoderCollection.GetCoder TIdDNSQuestionList.GetItem TIdDNSResourceList.GetItem TIdEMailAddressList.GetItem TIdGopherMenu.GetItem TIdMessageParts.GetItem TIdSocketHandles.GetItem TIndexDefs.GetIndexDef TListColumns.GetItem TMailAddresses.GetAddress TMailBox.GetMail TStatusPanels.GetItem TWebActionItems.GetActionItem"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_19275_0 {
	meta:
		name = "TChartSeriesList.GetSeries"
		size = 18
		refs = "000b TList.Get"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_19111_0 {
	meta:
		name = "TChartValueLists.GetValueList"
		size = 18
		refs = "000b TList.Get"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_13449_0 {
	meta:
		name = "TCubeDims.GetCubeDim"
		size = 18
		refs = "000b TDimensionItems.GetDimensionItem"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_17418_0 {
	meta:
		name = "TCustomLabel.GetLabelText"
		size = 18
		refs = "000b TControl.GetText"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_11887_0 {
	meta:
		name = "TCustomMaskEdit.GetEditText"
		size = 18
		refs = "000b TControl.GetText"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_6837_0 {
	meta:
		name = "TDBLookupCombo.GetDisplayValue"
		size = 18
		refs = "000b TControl.GetText"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_4993_0 {
	meta:
		name = "TField.GetAsString"
		size = 18
		refs = "000b TField.GetClassDesc"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_5001_0 {
	meta:
		name = "TField.GetDisplayLabel"
		size = 18
		refs = "000b TField.GetDisplayName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_5718_0 {
	meta:
		name = "TListOfDataSources.GetDataSource"
		size = 18
		refs = "000b TList.Get"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_14395_0 {
	meta:
		name = "TOleControl.GetByteProp"
		size = 18
		refs = "000b TOleControl.GetIntegerProp"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_14425_0 {
	meta:
		name = "TOleControl.GetShortIntProp"
		size = 18
		refs = "000b TOleControl.GetIntegerProp"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_14431_0 {
	meta:
		name = "TOleControl.GetWordProp"
		size = 18
		refs = "000b TOleControl.GetIntegerProp"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_17173_0 {
	meta:
		name = "TPieAngles.GetAngle"
		size = 18
		refs = "000b TList.Get"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_13499_0 {
	meta:
		name = "TQueryDims.GetQueryDim"
		size = 18
		refs = "000b TDimensionItems.GetDimensionItem"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_8060_0 {
	meta:
		name = "TStringProperty.GetValue"
		size = 18
		refs = "000b TPropertyEditor.GetStrValue"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_7956_0 {
	meta:
		name = "TTableList.GetItems"
		size = 18
		refs = "000b TList.Get"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1623_0 {
	meta:
		name = "TTeeSeriesTypes.GetSeriesType"
		size = 18
		refs = "000b TList.Get"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1221_0 {
	meta:
		name = "TMailBox.SetMail"
		size = 29
		refs = "000e TMailBox.GetMail"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1225_0 {
	meta:
		name = "TAttachments.SetAttachment"
		size = 29
		refs = "000e TAttachments.GetAttachment"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_9916_0 {
	meta:
		name = "TCookieCollection.SetCookie"
		size = 29
		refs = "000e TCookieCollection.GetCookie"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_13450_0 {
	meta:
		name = "TCubeDims.SetCubeDim"
		size = 29
		refs = "000e TCubeDims.GetCubeDim"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_6659_0 {
	meta:
		name = "TDBGridColumns.SetColumn"
		size = 29
		refs = "000e TDBGridColumns.GetColumn"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_12787_0 {
	meta:
		name = "TDimensionItems.SetDimensionItem"
		size = 29
		refs = "000e TDimensionItems.GetDimensionItem"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_13097_0 {
	meta:
		name = "TDisplayDims.SetDisplayDim"
		size = 29
		refs = "000e TDisplayDims.GetDisplayDim"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_7529_0 {
	meta:
		name = "THTMLTableColumns.SetColumn"
		size = 29
		refs = "000e THTMLTableColumns.GetColumn"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2934_0 {
	meta:
		name = "TListItems.SetItem"
		size = 29
		refs = "000e TListItems.GetItem"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1231_0 {
	meta:
		name = "TMailAddresses.SetAddress"
		size = 29
		refs = "000e TMailAddresses.GetAddress"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_13500_0 {
	meta:
		name = "TQueryDims.SetQueryDim"
		size = 29
		refs = "000e TQueryDims.GetQueryDim"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2543_0 {
	meta:
		name = "TTreeNode.SetItem"
		size = 29
		refs = "000e TTreeNode.GetItem"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2586_0 {
	meta:
		name = "TTreeNodes.SetItem"
		size = 29
		refs = "000e TTreeNodes.GetNodeFromIndex"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_9981_0 {
	meta:
		name = "TWebActionItems.SetActionItem"
		size = 29
		refs = "000e TWebActionItems.GetActionItem"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1222_0 {
	meta:
		name = "TAttachment.SetAttachmentType"
		size = 16
		refs = "000b TCollectionItem.Changed"
		altNames = "TCoolBand.SetBorderStyle"
	strings:
		$1 = { 3A 50 0C 74 0A 88 50 0C 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1228_0 {
	meta:
		name = "TMailAddresses.GetAttr"
		size = 80
		refs = "000a TMailAddresses.GetAttr 000f @LStrLAsg 0029 @LStrClr"
	strings:
		$1 = { 53 8B D9 85 D2 75 0E 8B C3 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 4A 75 0E 8B C3 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 07 8B C3 E8 ?? ?? ?? ?? 5B C3 00 FF FF FF FF 04 00 00 00 4E 61 6D 65 00 00 00 00 FF FF FF FF 07 00 00 00 41 64 64 72 65 73 73 00 }
	condition:
		$1
}

rule function_1229_0 {
	meta:
		name = "TMailAddresses.GetItemAttr"
		size = 73
		refs = "0018 TMailAddresses.GetAddress 003e @LStrClr"
	strings:
		$1 = { 55 8B EC 51 53 56 89 4D FC 8B D8 8B 75 08 85 D2 75 13 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 8B D6 8B 08 FF 51 28 EB 1D 4A 75 13 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 8B D6 8B 08 FF 51 1C EB 07 8B C6 E8 ?? ?? ?? ?? 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_1232_0 {
	meta:
		name = "TInternetAddress.AssignTo"
		size = 72
		refs = "000b _DV_TInternetAddress 0010 @IsClass 0021 @LStrAsg 0035 TCollectionItem.Changed 0040 TPersistent.AssignTo"
	strings:
		$1 = { 53 56 57 8B DA 8B F0 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 23 8B FB 8D 47 0C 8B 56 0C E8 ?? ?? ?? ?? 8D 47 10 8B 56 10 E8 ?? ?? ?? ?? 33 D2 8B C7 E8 ?? ?? ?? ?? EB 09 8B D3 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1233_0 {
	meta:
		name = "TInternetAddress.GetAddress"
		size = 19
		refs = "000c @LStrLAsg"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 53 10 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_8153_0 {
	meta:
		name = "TComponentEditor.GetDesigner"
		size = 19
		refs = "000c @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 53 10 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1234_0 {
	meta:
		name = "TInternetAddress.GetFormattedAddress"
		size = 132
		refs = "0032 TInternetAddress.GetFormattedAddress 0037 Format"
	strings:
		$1 = { 53 56 83 C4 E8 8B F2 8B D8 83 7B 0C 00 74 2E 56 8B 43 0C 89 44 24 04 C6 44 24 08 0B 8B 43 10 89 44 24 0C C6 44 24 10 0B 8D 54 24 04 B9 01 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 1D 56 8B 43 10 89 44 24 14 C6 44 24 18 0B 8D 54 24 14 33 C9 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 5E 5B C3 FF FF FF FF 09 00 00 00 22 25 73 22 20 3C 25 73 3E 00 00 00 FF FF FF FF 04 00 00 00 3C 25 73 3E 00 00 00 00 }
	condition:
		$1
}

rule function_1235_0 {
	meta:
		name = "TInternetAddress.SetAddress"
		size = 42
		refs = "000c CompareText 001a @LStrAsg 0023 TCollectionItem.Changed"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 10 E8 ?? ?? ?? ?? 85 C0 74 13 8D 43 10 8B D6 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1236_0 {
	meta:
		name = "TInternetAddress.GetName"
		size = 19
		refs = "000c @LStrLAsg"
		altNames = "TNamedItem.GetDisplayName TQREvEmbeddedFunction.Expression"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 53 0C E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1237_0 {
	meta:
		name = "TInternetAddress.SetName"
		size = 42
		refs = "000c CompareText 001a @LStrAsg 0023 TCollectionItem.Changed"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 0C E8 ?? ?? ?? ?? 85 C0 74 13 8D 43 0C 8B D6 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1238_0 {
	meta:
		name = "TInternetOutBox.Create"
		size = 72
		refs = "000e @ClassCreate 0023 TOwnedCollection.Create 0031 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 8B 45 08 50 8B CE 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 1C 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_1240_0 {
	meta:
		name = "TMIMEMail.Create"
		size = 198
		refs = "000a @ClassCreate 0017 TCollectionItem.Create 001e _Dn_TStringList 0023 TObject.Create 003a _DV_TMIMEAttachment 0044 _DV_TAttachments 0049 TOwnedCollection.Create 0051 _DV_TInternetAddress 005b _DV_TMailAddresses 00b3 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 0C B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 10 A1 ?? ?? ?? ?? 50 8B CE B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 18 A1 ?? ?? ?? ?? 50 8B CE B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 1C A1 ?? ?? ?? ?? 50 8B CE B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 20 A1 ?? ?? ?? ?? 50 8B CE B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 24 A1 ?? ?? ?? ?? 50 8B CE B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 28 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1241_0 {
	meta:
		name = "TMIMEMail.Destroy"
		size = 93
		refs = "0003 @BeforeDestruction 000f TObject.Free 004b TCollectionItem.Destroy 0056 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 0C E8 ?? ?? ?? ?? 8B 46 10 E8 ?? ?? ?? ?? 8B 46 18 E8 ?? ?? ?? ?? 8B 46 1C E8 ?? ?? ?? ?? 8B 46 20 E8 ?? ?? ?? ?? 8B 46 24 E8 ?? ?? ?? ?? 8B 46 28 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1242_0 {
	meta:
		name = "TMIMEMail.GetHeader"
		size = 25
		refs = "0011 TStrings.GetValue"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B 43 0C E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1243_0 {
	meta:
		name = "TMIMEMail.SetHeader"
		size = 22
		refs = "0007 TStrings.SetValue 0010 TCollectionItem.Changed"
	strings:
		$1 = { 53 8B D8 8B 43 0C E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1244_0 {
	meta:
		name = "TMIMEAttachment.GetBody"
		size = 4
		altNames = "TMIMEMail.GetBody TStringList.GetCount"
	strings:
		$1 = { 8B 40 10 C3 }
	condition:
		$1
}

rule function_1246_0 {
	meta:
		name = "TDisplayDims.GetOwner"
		size = 4
		altNames = "TMIMEMail.GetFromAddresses TMasterDataLink.GetDetailDataSet TQueryDataLink.GetDetailDataSet"
	strings:
		$1 = { 8B 40 1C C3 }
	condition:
		$1
}

rule function_1247_0 {
	meta:
		name = "TMIMEMail.GetBCCAddresses"
		size = 4
		altNames = "TPrinterSettings.GetMaxExtentX"
	strings:
		$1 = { 8B 40 20 C3 }
	condition:
		$1
}

rule function_1248_0 {
	meta:
		name = "TControl.GetParentComponent"
		size = 4
		altNames = "TListColumn.GetWidth TMIMEMail.GetCCAddresses TPrinterSettings.GetMaxExtentY TUpdateSQL.GetDataSet"
	strings:
		$1 = { 8B 40 24 C3 }
	condition:
		$1
}

rule function_1249_0 {
	meta:
		name = "TComServer.GetHelpFileName"
		size = 19
		refs = "000c @LStrLAsg"
		altNames = "TMIMEMail.GetSubject"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 53 14 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1250_0 {
	meta:
		name = "TMIMEMail.GetToAddresses"
		size = 4
		altNames = "TPrinterSettings.GetMinExtentX TQRPrinter.GetCanvas TTeeFunction.GetParentComponent"
	strings:
		$1 = { 8B 40 28 C3 }
	condition:
		$1
}

rule function_1251_0 {
	meta:
		name = "TMIMEAttachment.SetBody"
		size = 22
		refs = "0010 TCollectionItem.Changed"
		altNames = "TMIMEMail.SetBody"
	strings:
		$1 = { 56 8B F0 8B 46 10 8B 08 FF 51 08 33 D2 8B C6 E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule function_1252_0 {
	meta:
		name = "TMIMEMail.AssignTo"
		size = 127
		refs = "000b _DV_TMIMEMail 0010 @IsClass 006c TCollectionItem.Changed 0077 TPersistent.AssignTo"
	strings:
		$1 = { 53 56 57 8B DA 8B F0 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 5A 8B FB 8B 47 10 8B 56 10 8B 08 FF 51 08 8B 47 0C 8B 56 0C 8B 08 FF 51 08 8B 47 18 8B 56 18 8B 08 FF 51 08 8B 47 1C 8B 56 1C 8B 08 FF 51 08 8B 47 20 8B 56 20 8B 08 FF 51 08 8B 47 24 8B 56 24 8B 08 FF 51 08 8B 47 28 8B 56 28 8B 08 FF 51 08 B2 01 8B C7 E8 ?? ?? ?? ?? EB 09 8B D3 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1253_0 {
	meta:
		name = "TMIMEMail.SetAttachments"
		size = 22
		refs = "0010 TCollectionItem.Changed"
	strings:
		$1 = { 53 8B D8 8B 43 18 8B 08 FF 51 08 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1254_0 {
	meta:
		name = "TMIMEMail.SetFromAddresses"
		size = 22
		refs = "0010 TCollectionItem.Changed"
	strings:
		$1 = { 53 8B D8 8B 43 1C 8B 08 FF 51 08 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1255_0 {
	meta:
		name = "TMIMEMail.SetBCCAddresses"
		size = 22
		refs = "0010 TCollectionItem.Changed"
	strings:
		$1 = { 53 8B D8 8B 43 20 8B 08 FF 51 08 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1256_0 {
	meta:
		name = "TCustomChartAxis.SetAxis"
		size = 9
		altNames = "TCustomChartLegend.SetFrame THTMLTableColumn.SetTitle TMIMEMail.SetCCAddresses"
	strings:
		$1 = { 8B 40 24 8B 08 FF 51 08 C3 }
	condition:
		$1
}

rule function_1257_0 {
	meta:
		name = "TMIMEMail.SetSubject"
		size = 40
		refs = "000c @LStrCmp 0018 @LStrAsg 0021 TCollectionItem.Changed"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 53 14 E8 ?? ?? ?? ?? 74 13 8D 43 14 8B D6 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1258_0 {
	meta:
		name = "TIdHTTPResponseInfo.SetCookies"
		size = 9
		altNames = "TMIMEMail.SetToAddresses"
	strings:
		$1 = { 8B 40 28 8B 08 FF 51 08 C3 }
	condition:
		$1
}

rule function_1259_0 {
	meta:
		name = "TMIMEAttachment.Create"
		size = 98
		refs = "000a @ClassCreate 0017 TCollectionItem.Create 001e _Dn_TStringList 0023 TObject.Create 003c _Dn_TMemoryStream 004f @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 10 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 14 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 18 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1260_0 {
	meta:
		name = "TMIMEAttachment.Destroy"
		size = 61
		refs = "0003 @BeforeDestruction 000f TObject.Free 002b TCollectionItem.Destroy 0036 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 10 E8 ?? ?? ?? ?? 8B 46 14 E8 ?? ?? ?? ?? 8B 46 18 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1264_0 {
	meta:
		name = "TMIMEAttachment.GetValue"
		size = 25
		refs = "0011 TStrings.GetValue"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B 43 14 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1265_0 {
	meta:
		name = "TMIMEAttachment.SetValue"
		size = 22
		refs = "0007 TStrings.SetValue 0010 TCollectionItem.Changed"
	strings:
		$1 = { 53 8B D8 8B 43 14 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1266_0 {
	meta:
		name = "TMIMEAttachment.SetValues"
		size = 22
		refs = "0010 TCollectionItem.Changed"
	strings:
		$1 = { 56 8B F0 8B 46 14 8B 08 FF 51 08 33 D2 8B C6 E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule function_1267_0 {
	meta:
		name = "TMIMEAttachment.AssignTo"
		size = 72
		refs = "000b _DV_TMIMEAttachment 0010 @IsClass 0035 TCollectionItem.Changed 0040 TPersistent.AssignTo"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 23 8B FE 8B 47 10 8B 53 10 8B 08 FF 51 08 8B 47 14 8B 53 14 8B 08 FF 51 08 B2 01 8B C3 E8 ?? ?? ?? ?? EB 09 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1268_0 {
	meta:
		name = "TCustomSimpleMail.Create"
		size = 144
		refs = "000e @ClassCreate 001c TComponent.Create 0021 _DV_TMIMEMail 002b _DV_TInternetOutBox 0030 TInternetOutBox.Create 003d _Dn_TClientWinSocket 0042 TCustomWinSocket.Create 0050 TAbstractSocket.InitSocket 0055 TCustomSimpleMail.Create 005c TAbstractSocket.SetService 0069 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B D8 33 D2 8B C3 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 50 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 43 3C 83 C9 FF B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 73 38 8B D6 8B C3 E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B C3 80 7D FF 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5E 5B 59 5D C3 00 00 FF FF FF FF 04 00 00 00 73 6D 74 70 00 00 00 00 }
	condition:
		$1
}

rule function_1269_0 {
	meta:
		name = "TCustomSimpleMail.Destroy"
		size = 53
		refs = "0003 @BeforeDestruction 000f TObject.Free 0023 TComponent.Destroy 002e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 38 E8 ?? ?? ?? ?? 8B 46 3C E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_15488_0 {
	meta:
		name = "TSQLResolver.Destroy"
		size = 53
		refs = "0003 @BeforeDestruction 000f TObject.Free 0023 TCustomResolver.Destroy 002e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 38 E8 ?? ?? ?? ?? 8B 46 3C E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1270_0 {
	meta:
		name = "TCustomSimpleMail.CheckResponse"
		size = 200
		refs = "0011 TCustomSimpleMail.CheckResponse 0021 TCustomWinSocket.ReceiveText 0037 @LStrCopy 0042 StrToIntDef 00b4 @LStrArrayClr 00ba @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 8B DA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8D 45 F8 50 B9 03 00 00 00 BA 01 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 45 F8 83 CA FF E8 ?? ?? ?? ?? 8B D8 66 83 BE 86 00 00 00 00 74 14 8B 45 FC 50 8B CB 8B D6 8B 86 88 00 00 00 FF 96 84 00 00 00 81 FB D3 00 00 00 74 2C 81 FB DC 00 00 00 74 24 81 FB DD 00 00 00 74 1C 81 FB FA 00 00 00 74 14 81 FB FB 00 00 00 74 0C 81 FB 62 01 00 00 74 04 33 C0 EB 02 B0 01 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 8B C3 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1271_0 {
	meta:
		name = "TCustomSimpleMail.DoActivate"
		size = 67
		refs = "001b TCustomWinSocket.GetHandle 003c TCustomWinSocket.Open"
	strings:
		$1 = { 56 57 8B F0 8B 7E 38 8A 47 08 3A D0 74 32 F6 46 20 10 75 2C 84 C0 74 12 8B C7 E8 ?? ?? ?? ?? 8B D0 8B C7 8B 08 FF 51 08 EB 16 8B 46 34 50 66 8B 46 28 50 8B 4E 2C 8B 56 30 8B C7 E8 ?? ?? ?? ?? 5F 5E C3 }
	condition:
		$1
}

rule function_1272_0 {
	meta:
		name = "GetGMTOffset"
		size = 224
		refs = "000c GetTimeZoneInformation 007a GetGMTOffset 007f Format 0093 @LStrCat3 00a1 @LStrLAsg"
	strings:
		$1 = { 53 56 81 C4 44 FF FF FF 8B D8 54 E8 ?? ?? ?? ?? 83 F8 FF 0F 84 80 00 00 00 83 F8 01 75 09 8B 44 24 54 01 04 24 EB 0F 83 F8 02 75 0A 8B 84 24 A8 00 00 00 01 04 24 53 8B 74 24 04 8B C6 B9 3C 00 00 00 99 F7 F9 89 84 24 B0 00 00 00 C6 84 24 B4 00 00 00 00 8B C6 B9 3C 00 00 00 99 F7 F9 89 94 24 B8 00 00 00 C6 84 24 BC 00 00 00 00 8D 94 24 B0 00 00 00 B9 01 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 3C 24 00 7E 1C 8B 0B 8B C3 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 0C 8B C3 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 81 C4 BC 00 00 00 5E 5B C3 00 00 FF FF FF FF 08 00 00 00 25 2E 32 64 25 2E 32 64 00 00 00 00 FF FF FF FF 01 00 00 00 2D 00 00 00 FF FF FF FF 04 00 00 00 30 30 30 30 00 00 00 00 }
	condition:
		$1
}

rule function_1273_0 {
	meta:
		name = "WriteAddresses"
		size = 288
		refs = "001a WriteAddresses 0027 TCollection.GetCount 0050 TMailAddresses.GetAddress 0074 Format 0082 TStringStream.WriteString 00dd @LStrClr 00eb @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 DC 53 56 57 33 C9 89 4D F8 89 4D E4 89 55 FC 8B F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 8B F0 4E 85 F6 0F 8C 96 00 00 00 46 33 DB 85 DB 75 4B 8D 45 F8 50 8B 45 FC 89 45 E8 C6 45 EC 0B 8B D3 8B C7 E8 ?? ?? ?? ?? 8D 55 E4 8B 08 FF 51 24 8B 45 E4 89 45 F0 C6 45 F4 0B 8D 55 E8 B9 01 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? EB 3C 8D 45 F8 50 8B D3 8B C7 E8 ?? ?? ?? ?? 8D 55 E4 8B 08 FF 51 24 8B 45 E4 89 45 DC C6 45 E0 0B 8D 55 DC 33 C9 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 43 4E 0F 85 6D FF FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 FF FF FF FF 08 00 00 00 25 73 3A 20 25 73 0D 0A 00 00 00 00 FF FF FF FF 08 00 00 00 20 20 20 20 25 73 0D 0A 00 00 00 00 }
	condition:
		$1
}

rule function_1274_0 {
	meta:
		name = "WriteBody"
		size = 208
		refs = "0015 WriteBody 002b TStringStream.WriteString 0052 @LStrLen 006e @LStrCat3 00a5 @LStrClr 00ab @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 33 D2 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 8B 10 FF 52 14 8B D8 4B 85 DB 7C 56 43 33 F6 8D 4D F8 8B D6 8B 45 FC 8B 38 FF 57 0C 8B 45 F8 E8 ?? ?? ?? ?? 85 C0 7E 18 8B 45 F8 80 38 2E 75 10 8D 45 F8 8B 4D F8 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC 8B 55 F8 E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 46 4B 75 AD 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 59 5D C3 FF FF FF FF 02 00 00 00 0D 0A 00 00 FF FF FF FF 01 00 00 00 2E 00 00 00 }
	condition:
		$1
}

rule function_1275_0 {
	meta:
		name = "TCustomSimpleMail.Event"
		size = 1572
		refs = "001c TCustomSimpleMail.Event 0093 TAbstractSocket.SetActive 0132 TCustomWinSocket.GetLocalHost 014b Format 0166 TMailBox.GetMail 017e TMailAddresses.GetAddress 01c3 TCollection.GetCount 02b5 _Dn_TStringStream 02ba TStringStream.Create 02c6 Now 02da FormatDateTime 02ec GetGMTOffset 0313 TStringStream.WriteString 0326 WriteAddresses 03f2 WriteBody 040a TStream.SetPosition 0414 TCustomWinSocket.SendStream 0482 @LStrClr 0498 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 D8 53 56 57 33 DB 89 5D F8 89 5D EC 89 5D D8 8B FA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 8A C1 83 F8 07 0F 87 3E 04 00 00 FF 24 85 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 66 83 7E 56 00 0F 84 0C 04 00 00 8B CF 8B D6 8B 46 58 FF 56 54 E9 FD 03 00 00 66 83 7E 66 00 0F 84 F2 03 00 00 8B CF 8B D6 8B 46 68 FF 56 64 E9 E3 03 00 00 B2 01 8B C6 E8 ?? ?? ?? ?? C6 46 40 01 33 C0 89 46 44 33 C0 89 46 48 66 83 7E 5E 00 0F 84 C1 03 00 00 8B CF 8B D6 8B 46 60 FF 56 5C E9 B2 03 00 00 33 D2 8B C6 E8 ?? ?? ?? ?? C6 46 40 00 66 83 7E 6E 00 0F 84 9A 03 00 00 8B CF 8B D6 8B 46 70 FF 56 6C E9 8B 03 00 00 8B D7 8B C6 8B 08 FF 51 40 84 C0 0F 84 7A 03 00 00 33 C0 8A 46 40 83 F8 06 0F 87 6C 03 00 00 FF 24 85 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8D 45 F8 50 8D 55 EC 8B C7 E8 ?? ?? ?? ?? 8B 45 EC 89 45 F0 C6 45 F4 0B 8D 55 F0 33 C9 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D F8 8B D7 8B C6 8B 18 FF 53 3C C6 46 40 02 8B 56 44 8B 46 3C E8 ?? ?? ?? ?? 89 46 4C E9 FF 02 00 00 8B 46 4C 8B 10 FF 52 30 8B 56 48 E8 ?? ?? ?? ?? 8B D8 8D 45 F8 50 8D 55 EC 8B C3 8B 08 FF 51 1C 8B 45 EC 89 45 F0 C6 45 F4 0B 8D 55 F0 33 C9 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D F8 8B D7 8B C6 8B 18 FF 53 3C FF 46 48 8B 46 4C 8B 10 FF 52 30 E8 ?? ?? ?? ?? 3B 46 48 0F 8F A1 02 00 00 C6 46 40 03 33 C0 89 46 48 8B 46 4C 8B 10 FF 52 40 89 46 50 E9 88 02 00 00 8B 46 50 E8 ?? ?? ?? ?? 3B 46 48 7E 40 8B 56 48 8B 46 50 E8 ?? ?? ?? ?? 8B D8 8D 45 F8 50 8D 55 EC 8B C3 8B 08 FF 51 1C 8B 45 EC 89 45 F0 C6 45 F4 0B 8D 55 F0 33 C9 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D F8 8B D7 8B C6 8B 18 FF 53 3C FF 46 48 8B 46 50 E8 ?? ?? ?? ?? 3B 46 48 0F 8F 27 02 00 00 33 C0 89 46 48 8B 46 4C 8B 10 FF 52 40 3B 46 50 75 0D 8B 46 4C 8B 10 FF 52 38 89 46 50 EB D0 8B 46 4C 8B 10 FF 52 38 3B 46 50 75 0D 8B 46 4C 8B 10 FF 52 34 89 46 50 EB B6 8B 46 4C 8B 10 FF 52 34 3B 46 50 75 A9 C6 46 40 04 E9 D8 01 00 00 B9 ?? ?? ?? ?? 8B D7 8B C6 8B 18 FF 53 3C C6 46 40 05 E9 C1 01 00 00 33 C9 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 8D 45 F8 50 E8 ?? ?? ?? ?? 83 C4 F8 DD 1C 24 9B 8D 55 EC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 EC 89 45 DC C6 45 E0 0B 8D 45 D8 E8 ?? ?? ?? ?? 8B 45 D8 89 45 E4 C6 45 E8 0B 8D 55 DC B9 01 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 8B 45 FC E8 ?? ?? ?? ?? 55 8B 46 4C 8B 10 FF 52 30 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 83 BE 90 00 00 00 00 74 2B 8D 45 F8 50 8B 86 90 00 00 00 89 45 F0 C6 45 F4 0B 8D 55 F0 33 C9 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 8B 45 FC E8 ?? ?? ?? ?? 55 8B 46 4C 8B 10 FF 52 40 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 55 8B 46 4C 8B 10 FF 52 38 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 55 8B 46 4C 8B 10 FF 52 34 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8D 45 F8 50 8D 55 EC 8B 46 4C 8B 08 FF 51 3C 8B 45 EC 89 45 F0 C6 45 F4 0B 8D 55 F0 33 C9 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 8B 45 FC E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 55 8B 46 4C 8B 10 FF 52 24 E8 ?? ?? ?? ?? 59 BA ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 D2 8B 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B C7 E8 ?? ?? ?? ?? C6 46 40 06 EB 53 FF 46 44 33 C0 89 46 4C 33 C0 89 46 50 8B 46 3C E8 ?? ?? ?? ?? 3B 46 44 7F 14 B9 ?? ?? ?? ?? 8B D7 8B C6 8B 18 FF 53 3C C6 46 40 00 EB 25 8B 56 44 8B 46 3C E8 ?? ?? ?? ?? 89 46 4C 33 C0 89 46 48 C6 46 40 02 B9 ?? ?? ?? ?? 8B D7 8B C6 8B 18 FF 53 3C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 D8 E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5F 5E 5B 8B E5 5D C3 00 00 00 FF FF FF FF 09 00 00 00 48 45 4C 4F 20 25 73 0D 0A 00 00 00 FF FF FF FF 11 00 00 00 4D 41 49 4C 20 46 52 4F 4D 3A 20 3C 25 73 3E 0D 0A 00 00 00 FF FF FF FF 0F 00 00 00 52 43 50 54 20 54 4F 3A 20 3C 25 73 3E 0D 0A 00 FF FF FF FF 06 00 00 00 44 41 54 41 0D 0A 00 00 FF FF FF FF 19 00 00 00 64 64 64 2C 20 64 64 20 6D 6D 6D 20 79 79 79 79 20 68 68 3A 6D 6D 3A 73 73 00 00 00 FF FF FF FF 0D 00 00 00 44 61 74 65 3A 20 25 73 20 25 73 0D 0A 00 00 00 FF FF FF FF 04 00 00 00 46 72 6F 6D 00 00 00 00 FF FF FF FF 0E 00 00 00 52 65 70 6C 79 2D 54 6F 3A 20 25 73 0D 0A 00 00 FF FF FF FF 02 00 00 00 54 6F 00 00 FF FF FF FF 02 00 00 00 43 43 00 00 FF FF FF FF 03 00 00 00 42 43 43 00 FF FF FF FF 0D 00 00 00 53 75 62 6A 65 63 74 3A 20 25 73 0D 0A 00 00 00 FF FF FF FF 13 00 00 00 4D 49 4D 45 2D 56 65 72 73 69 6F 6E 3A 20 31 2E 30 0D 0A 00 FF FF FF FF 2C 00 00 00 43 6F 6E 74 65 6E 74 2D 54 79 70 65 3A 20 74 65 78 74 2F 70 6C 61 69 6E 3B 20 63 68 61 72 73 65 74 3D 75 73 2D 61 73 63 69 69 0D 0A 00 00 00 00 FF FF FF FF 05 00 00 00 0D 0A 2E 0D 0A 00 00 00 FF FF FF FF 06 00 00 00 51 55 49 54 0D 0A 00 00 FF FF FF FF 06 00 00 00 4E 4F 4F 50 0D 0A 00 00 }
	condition:
		$1
}

rule function_1276_0 {
	meta:
		name = "TCustomSimpleMail.Error"
		size = 33
	strings:
		$1 = { 55 8B EC 53 66 83 78 76 00 74 11 51 8B 4D 08 51 8B D8 8B CA 8B D0 8B 43 78 FF 53 74 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_1277_0 {
	meta:
		name = "TCustomSimpleMail.IsServiceStored"
		size = 40
		refs = "0004 TCustomSimpleMail.IsServiceStored 000c CompareText"
	strings:
		$1 = { 53 8B D8 BA ?? ?? ?? ?? 8B 43 34 E8 ?? ?? ?? ?? 85 C0 0F 95 C0 5B C3 00 FF FF FF FF 04 00 00 00 73 6D 74 70 00 00 00 00 }
	condition:
		$1
}

rule function_1278_0 {
	meta:
		name = "TCustomSimpleMail.SetOutBox"
		size = 9
		altNames = "TDSTableProducer.SetColumns"
	strings:
		$1 = { 8B 40 3C 8B 08 FF 51 08 C3 }
	condition:
		$1
}

rule function_1280_0 {
	meta:
		name = "TCustomSimpleMail.SendRequest"
		size = 42
		refs = "0022 TCustomWinSocket.SendText"
	strings:
		$1 = { 53 56 57 8B D9 8B F2 66 83 78 7E 00 74 0F 8B F8 8B CB 8B D0 8B 87 80 00 00 00 FF 57 7C 8B D3 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1283_0 {
	meta:
		name = "InternalEditFont"
		size = 116
		refs = "000e _Dn_TFontDialog 0013 TFontDialog.Create 001e InternalEditFont 0061 TObject.Free 0067 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 89 55 FC 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 8B 40 4C 8B 55 FC 8B 08 FF 51 08 8B 45 F8 8B 10 FF 52 3C 84 C0 74 0E 8B 45 F8 8B 50 4C 8B 45 FC 8B 08 FF 51 08 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 FC 59 59 5D C3 }
	condition:
		$1
}

rule function_1284_0 {
	meta:
		name = "EditChartBrush"
		size = 91
		refs = "000c _DV_TBrushDialog 0011 TCustomForm.Create 001c EditChartBrush 004b TObject.Free 0051 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B DA 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 89 98 E0 02 00 00 8B 45 FC 8B 10 FF 92 CC 00 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1285_0 {
	meta:
		name = "TBrushDialog.RedrawShape"
		size = 86
		refs = "000a TBrush.GetStyle 0025 TBrush.GetColor 0038 TBrush.SetColor 0050 TControl.SetVisible"
	strings:
		$1 = { 53 8B D8 8B 83 E0 02 00 00 E8 ?? ?? ?? ?? 84 C0 0F 95 C2 8B 83 D0 02 00 00 8B 08 FF 51 60 8B 83 E0 02 00 00 E8 ?? ?? ?? ?? 8B D0 8B 83 D4 02 00 00 8B 80 1C 01 00 00 E8 ?? ?? ?? ?? 8B 83 D0 02 00 00 8B 10 FF 52 50 8B D0 8B 83 D4 02 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1286_0 {
	meta:
		name = "TBrushDialog.FormShow"
		size = 118
		refs = "0005 Screen 000e TScreen.SetCursor 0015 _Dn_TChartBrush 001a TChartBrush.Create 003a TBrush.GetStyle 004b TCustomRadioGroup.SetItemIndex 006f TBrushDialog.RedrawShape"
	strings:
		$1 = { 53 56 8B D8 A1 ?? ?? ?? ?? 8B 00 33 D2 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 DC 02 00 00 8B 93 E0 02 00 00 8B C6 8B 08 FF 51 08 8B 83 E0 02 00 00 E8 ?? ?? ?? ?? 84 C0 75 0F 33 D2 8B 83 C4 02 00 00 E8 ?? ?? ?? ?? EB 1B 8B 83 E0 02 00 00 E8 ?? ?? ?? ?? 33 D2 8A D0 4A 8B 83 C4 02 00 00 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1287_0 {
	meta:
		name = "TBrushDialog.RGStyleClick"
		size = 60
		refs = "001b TBrush.SetStyle 0036 TBrushDialog.RedrawShape"
	strings:
		$1 = { 53 8B D8 8B 83 C4 02 00 00 83 B8 F8 01 00 00 00 75 0F 33 D2 8B 83 E0 02 00 00 E8 ?? ?? ?? ?? EB 12 8A 90 F8 01 00 00 42 8B 83 E0 02 00 00 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1288_0 {
	meta:
		name = "TBrushDialog.BColorClick"
		size = 45
		refs = "000d TBrush.GetColor 0016 EditColor 001f TBrush.SetColor 0026 TBrushDialog.RedrawShape"
	strings:
		$1 = { 53 56 8B D8 8B B3 E0 02 00 00 8B C6 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1290_0 {
	meta:
		name = "TBrushDialog.Button3Click"
		size = 32
	strings:
		$1 = { 53 8B D8 8B 93 DC 02 00 00 8B 83 E0 02 00 00 8B 08 FF 51 08 C7 83 2C 02 00 00 02 00 00 00 5B C3 }
	condition:
		$1
}

rule function_1291_0 {
	meta:
		name = "TBrushDialog.FormClose"
		size = 12
		refs = "0007 TObject.Free"
	strings:
		$1 = { 8B 80 DC 02 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1294_0 {
	meta:
		name = "TBubbleSeries.Create"
		size = 205
		refs = "000f @ClassCreate 001b TBubbleSeries.Create 002a TPointSeries.Create 0032 TeeMsg_ValuesBubbleRadius 0037 LoadResString 0044 _Dn_TChartValueList 0049 TChartValueList.Create 005c TSeriesPointer.SetInflateMargins 0069 TSeriesPointer.SetStyle 0076 TChartPen.SetVisible 0080 TSeriesMarks.SetBackTransparent 00a5 @LStrClr 00ab @HandleFinally 00b8 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B C6 E8 ?? ?? ?? ?? 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 50 8B CE B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 86 2C 01 00 00 33 D2 8B 86 F8 00 00 00 E8 ?? ?? ?? ?? B2 01 8B 86 F8 00 00 00 E8 ?? ?? ?? ?? 8B 46 50 8B 40 14 33 D2 E8 ?? ?? ?? ?? B2 01 8B 46 50 E8 ?? ?? ?? ?? C6 86 30 01 00 00 01 B2 01 8B C6 8B 08 FF 51 78 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1297_0 {
	meta:
		name = "TBubbleSeries.AddBubble"
		size = 77
	strings:
		$1 = { 55 8B EC 51 53 56 89 4D FC 8B F0 FF 75 1C FF 75 18 FF 75 14 FF 75 10 8B 4D FC 8B C6 8B 18 FF 93 8C 00 00 00 8B D8 8B 86 2C 01 00 00 8B 55 08 89 50 30 8B 55 0C 89 50 34 8B D3 8B C6 8B 08 FF 91 D8 00 00 00 8B C3 5E 5B 59 5D C2 18 00 }
	condition:
		$1
}

rule function_1298_0 {
	meta:
		name = "TBubbleSeries.FillSampleValues"
		size = 196
		refs = "0032 TChartSeries.CalcRandomBounds 0043 @ROUND 0048 @RandInt 0089 TBubbleSeries.FillSampleValues 00a0 TBubbleSeries.AddBubble 00b3 TChartSeries.RefreshSeries"
	strings:
		$1 = { 53 56 57 55 83 C4 C8 8B DA 8B F0 8B FC 8D 6C 24 20 8B C6 8B 10 FF 92 90 00 00 00 8D 44 24 10 50 8D 44 24 0C 50 8D 44 24 20 50 55 8B CF 8B D3 8B C6 E8 ?? ?? ?? ?? 85 DB 7E 76 FF 77 04 FF 37 DD 45 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 44 24 30 DB 44 24 30 83 C4 F8 DD 1C 24 9B B8 19 00 00 00 E8 ?? ?? ?? ?? 83 C0 0A 89 44 24 3C DB 44 24 3C DC 7D 00 E8 ?? ?? ?? ?? 89 44 24 40 89 54 24 44 DF 6C 24 40 DD 45 00 D8 35 ?? ?? ?? ?? DE C1 83 C4 F8 DD 1C 24 9B B9 00 00 00 80 33 D2 8B C6 E8 ?? ?? ?? ?? DD 07 DC 44 24 10 DD 1F 9B 4B 75 8A 8B C6 E8 ?? ?? ?? ?? 83 C4 38 5D 5F 5E 5B C3 00 00 00 C8 41 }
	condition:
		$1
}

rule function_1299_0 {
	meta:
		name = "TBubbleSeries.DrawValue"
		size = 181
		refs = "0010 TChartValueList.GetValue 001e TChartSeries.CalcYSizeValue 0036 TSeriesPointer.ChangeHorizSize 0053 TChartSeries.CalcXSizeValue 006d TSeriesPointer.ChangeVertSize 0085 TSeriesPointer.PrepareCanvas"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B D6 8B 83 2C 01 00 00 E8 ?? ?? ?? ?? 83 C4 F8 DD 1C 24 9B 8B C3 E8 ?? ?? ?? ?? 8B F8 80 BB 30 01 00 00 00 74 0F 8B D7 8B 83 F8 00 00 00 E8 ?? ?? ?? ?? EB 28 8B D6 8B 83 2C 01 00 00 E8 ?? ?? ?? ?? 83 C4 F8 DD 1C 24 9B 8B C3 E8 ?? ?? ?? ?? 8B D0 8B 83 F8 00 00 00 E8 ?? ?? ?? ?? 8B D7 8B 83 F8 00 00 00 E8 ?? ?? ?? ?? 8B D6 8B C3 8B 08 FF 51 60 8B F8 8B D7 8B 83 F8 00 00 00 E8 ?? ?? ?? ?? 57 56 8B D6 8B C3 8B 08 FF 91 D4 00 00 00 50 8B D6 8B C3 8B 08 FF 91 D0 00 00 00 8B D0 8B C3 59 8B 18 FF 93 38 01 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1300_0 {
	meta:
		name = "TBubbleSeries.MaxYValue"
		size = 105
		refs = "000b TChartSeries.MaxYValue 0016 TChartSeries.Count 0043 TChartValueList.GetValue 0053 MaxDouble"
	strings:
		$1 = { 53 56 57 83 C4 F0 8B F0 8B C6 E8 ?? ?? ?? ?? DD 1C 24 9B 8B C6 E8 ?? ?? ?? ?? 48 8B F8 85 FF 7C 3E 47 33 DB FF 74 24 04 FF 74 24 04 8B D3 8B C6 8B 08 FF 51 6C DD 5C 24 10 9B 8B D3 8B 86 2C 01 00 00 E8 ?? ?? ?? ?? DC 44 24 10 83 C4 F8 DD 1C 24 9B E8 ?? ?? ?? ?? DD 1C 24 9B 43 4F 75 C5 DD 04 24 83 C4 10 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1301_0 {
	meta:
		name = "TBubbleSeries.MinYValue"
		size = 105
		refs = "000b TChartSeries.MinYValue 0016 TChartSeries.Count 0043 TChartValueList.GetValue 0053 MinDouble"
	strings:
		$1 = { 53 56 57 83 C4 F0 8B F0 8B C6 E8 ?? ?? ?? ?? DD 1C 24 9B 8B C6 E8 ?? ?? ?? ?? 48 8B F8 85 FF 7C 3E 47 33 DB FF 74 24 04 FF 74 24 04 8B D3 8B C6 8B 08 FF 51 6C DD 5C 24 10 9B 8B D3 8B 86 2C 01 00 00 E8 ?? ?? ?? ?? DC 6C 24 10 83 C4 F8 DD 1C 24 9B E8 ?? ?? ?? ?? DD 1C 24 9B 43 4F 75 C5 DD 04 24 83 C4 10 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1302_0 {
	meta:
		name = "TBubbleSeries.Assign"
		size = 47
		refs = "000a _DV_TBubbleSeries 000f @IsClass 0028 TPointSeries.Assign"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0C 8A 86 30 01 00 00 88 83 30 01 00 00 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1303_0 {
	meta:
		name = "TBubbleSeries.GetEditorClass"
		size = 48
		refs = "0006 TBubbleSeries.GetEditorClass 000b @LStrLAsg"
	strings:
		$1 = { 53 8B DA 8B C3 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 00 00 00 FF FF FF FF 13 00 00 00 54 42 75 62 62 6C 65 53 65 72 69 65 73 45 64 69 74 6F 72 00 }
	condition:
		$1
}

rule function_1305_0 {
	meta:
		name = "TBubbleSeries.DrawLegendShape"
		size = 70
		refs = "0016 MinLong 0025 TSeriesPointer.ChangeHorizSize 0032 TSeriesPointer.ChangeVertSize 003d TCustomSeries.DrawLegendShape"
	strings:
		$1 = { 53 56 57 55 8B D9 8B EA 8B F0 8B 53 0C 2B 53 04 8B 43 08 2B 03 E8 ?? ?? ?? ?? 8B F8 8B D7 8B 86 F8 00 00 00 E8 ?? ?? ?? ?? 8B D7 8B 86 F8 00 00 00 E8 ?? ?? ?? ?? 8B CB 8B D5 8B C6 E8 ?? ?? ?? ?? 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1308_0 {
	meta:
		name = "TBubbleSeriesEditor.Enable3DPoint"
		size = 47
	strings:
		$1 = { 8B 90 E4 02 00 00 8B 92 F8 00 00 00 8A 4A 1C 84 C9 74 0E 80 F9 02 74 09 80 F9 03 74 04 33 D2 EB 02 B2 01 8B 80 C4 02 00 00 8B 08 FF 51 60 C3 }
	condition:
		$1
}

rule function_1309_0 {
	meta:
		name = "TBubbleSeriesEditor.FormShow"
		size = 160
		refs = "0005 Screen 000e TScreen.SetCursor 0046 TCustomRadioGroup.SetItemIndex 004d TBubbleSeriesEditor.Enable3DPoint 0072 TBrush.GetColor"
	strings:
		$1 = { 53 56 8B D8 A1 ?? ?? ?? ?? 8B 00 33 D2 E8 ?? ?? ?? ?? 8B 43 0C 89 83 E4 02 00 00 8B F0 8B 86 F8 00 00 00 8A 50 04 8B 83 C4 02 00 00 8B 08 FF 91 BC 00 00 00 8B 86 F8 00 00 00 33 D2 8A 50 1C 8B 83 D0 02 00 00 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B 86 F8 00 00 00 8A 50 10 8B 83 C8 02 00 00 8B 08 FF 91 BC 00 00 00 8B 86 F8 00 00 00 8B 40 08 E8 ?? ?? ?? ?? 3D 00 00 00 80 0F 94 C2 8B 83 D8 02 00 00 8B 08 FF 91 BC 00 00 00 8A 56 2C 8B 83 E0 02 00 00 8B 08 FF 91 BC 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_1310_0 {
	meta:
		name = "TBubbleSeriesEditor.CB3dPointClick"
		size = 38
		refs = "0020 TSeriesPointer.SetDraw3D"
	strings:
		$1 = { 53 8B D8 8B 83 C4 02 00 00 8B 10 FF 92 B8 00 00 00 8B D0 8B 83 E4 02 00 00 8B 80 F8 00 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1311_0 {
	meta:
		name = "TBubbleSeriesEditor.BPointFillColorClick"
		size = 63
		refs = "0016 TBrush.GetColor 001f EditColor 0028 TBrush.SetColor"
	strings:
		$1 = { 53 56 8B D8 8B 83 E4 02 00 00 8B 80 F8 00 00 00 8B 70 08 8B C6 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 33 D2 8B 83 D8 02 00 00 8B 08 FF 91 BC 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_1312_0 {
	meta:
		name = "TBubbleSeriesEditor.CBPointColorDefClick"
		size = 48
		refs = "002a TBrush.SetColor"
	strings:
		$1 = { 53 8B D8 8B 83 D8 02 00 00 8B 10 FF 92 B8 00 00 00 84 C0 74 19 8B 83 E4 02 00 00 8B 80 F8 00 00 00 8B 40 08 BA 00 00 00 80 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1313_0 {
	meta:
		name = "TBubbleSeriesEditor.BPoinPenColClick"
		size = 21
		refs = "0010 EditChartPen"
	strings:
		$1 = { 8B 90 E4 02 00 00 8B 92 F8 00 00 00 8B 52 18 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1314_0 {
	meta:
		name = "TBubbleSeriesEditor.FormCreate"
		size = 9
	strings:
		$1 = { 33 D2 89 90 E4 02 00 00 C3 }
	condition:
		$1
}

rule function_1315_0 {
	meta:
		name = "TBubbleSeriesEditor.CBInflateClick"
		size = 38
		refs = "0020 TSeriesPointer.SetInflateMargins"
	strings:
		$1 = { 53 8B D8 8B 83 C8 02 00 00 8B 10 FF 92 B8 00 00 00 8B D0 8B 83 E4 02 00 00 8B 80 F8 00 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1316_0 {
	meta:
		name = "TBubbleSeriesEditor.RGStyleClick"
		size = 41
		refs = "001c TSeriesPointer.SetStyle 0023 TBubbleSeriesEditor.Enable3DPoint"
	strings:
		$1 = { 53 8B D8 8B 83 D0 02 00 00 8A 90 F8 01 00 00 8B 83 E4 02 00 00 8B 80 F8 00 00 00 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1317_0 {
	meta:
		name = "TBubbleSeriesEditor.CBColorEachClick"
		size = 32
	strings:
		$1 = { 53 8B D8 8B 83 E0 02 00 00 8B 10 FF 92 B8 00 00 00 8B D0 8B 83 E4 02 00 00 8B 08 FF 51 78 5B C3 }
	condition:
		$1
}

rule function_1320_0 {
	meta:
		name = "_NF__19C"
		size = 88
	strings:
		$1 = { 42 42 4F 4B 00 00 00 00 42 42 43 41 4E 43 45 4C 00 00 00 00 42 42 48 45 4C 50 00 00 42 42 59 45 53 00 00 00 42 42 4E 4F 00 00 00 00 42 42 43 4C 4F 53 45 00 42 42 41 42 4F 52 54 00 42 42 52 45 54 52 59 00 42 42 49 47 4E 4F 52 45 00 00 00 00 42 42 41 4C 4C 00 00 00 }
	condition:
		$1
}

rule function_1321_0 {
	meta:
		name = "DrawButtonFace"
		size = 624
		refs = "0019 NewStyleControls 0049 TBrush.SetColor 0053 TBrush.SetStyle 005a TCanvas.GetHandle 0070 DrawEdge 00eb TPen.SetColor 0117 TCanvas.Rectangle 012f TCanvas.SetPixel 017c InflateRect 01c6 Frame3D 01e4 Point 0233 TCanvas.Polyline 0250 Rect 0263 OffsetRect"
	strings:
		$1 = { 55 8B EC 83 C4 BC 53 56 57 89 4D FC 8B F2 8B D8 8B 45 18 84 C0 75 0B 8B 15 ?? ?? ?? ?? 80 3A 00 75 08 3C 02 74 04 33 C0 EB 02 B0 01 56 8D 7D EC B9 04 00 00 00 F3 A5 5E 84 C0 0F 84 A2 00 00 00 BA 0F 00 00 80 8B 43 14 E8 ?? ?? ?? ?? 33 D2 8B 43 14 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B D8 80 7D 10 00 74 3E 6A 03 6A 08 8D 45 EC 50 53 E8 ?? ?? ?? ?? 6A 0C 6A 02 8D 45 EC 50 53 E8 ?? ?? ?? ?? FF 4D F8 FF 4D F4 FF 45 F0 FF 45 EC 68 03 08 00 00 6A 02 8D 45 EC 50 53 E8 ?? ?? ?? ?? E9 93 01 00 00 6A 0C 6A 01 8D 45 EC 50 53 E8 ?? ?? ?? ?? FF 4D F8 FF 4D F4 6A 03 6A 04 8D 45 EC 50 53 E8 ?? ?? ?? ?? FF 45 F0 FF 45 EC 68 0C 08 00 00 6A 04 8D 45 EC 50 53 E8 ?? ?? ?? ?? E9 55 01 00 00 BA 06 00 00 80 8B 43 10 E8 ?? ?? ?? ?? BA 0F 00 00 80 8B 43 14 E8 ?? ?? ?? ?? 33 D2 8B 43 14 E8 ?? ?? ?? ?? 8B 45 F4 50 8B 45 F8 50 8B 4D F0 8B 55 EC 8B C3 E8 ?? ?? ?? ?? 80 7D 14 00 74 4C 68 0F 00 00 80 8B 4D F0 8B 55 EC 8B C3 E8 ?? ?? ?? ?? 68 0F 00 00 80 8B 4D F8 49 8B 55 EC 8B C3 E8 ?? ?? ?? ?? 68 0F 00 00 80 8B 55 F4 4A 8B 4D F0 8B C3 E8 ?? ?? ?? ?? 68 0F 00 00 80 8B 4D F8 49 8B 55 F4 4A 8B C3 E8 ?? ?? ?? ?? 80 7D 0C 00 74 2C 6A FF 6A FF 8D 45 EC 50 E8 ?? ?? ?? ?? B2 01 8B 43 14 E8 ?? ?? ?? ?? 8B 45 F4 50 8B 45 F8 50 8B 4D F0 8B 55 EC 8B C3 E8 ?? ?? ?? ?? 6A FF 6A FF 8D 45 EC 50 E8 ?? ?? ?? ?? 80 7D 10 00 75 1A 68 10 00 00 80 8B 45 FC 50 8D 55 EC B9 14 00 00 80 8B C3 E8 ?? ?? ?? ?? EB 6B BA 10 00 00 80 8B 43 10 E8 ?? ?? ?? ?? 8D 4D CC 8B 55 F8 4A 8B 45 EC E8 ?? ?? ?? ?? 8B 45 CC 89 45 D4 8B 45 D0 89 45 D8 8D 4D C4 8B 55 F0 8B 45 EC E8 ?? ?? ?? ?? 8B 45 C4 89 45 DC 8B 45 C8 89 45 E0 8D 4D BC 8B 55 F0 8B 45 F4 E8 ?? ?? ?? ?? 8B 45 BC 89 45 E4 8B 45 C0 89 45 E8 8D 55 D4 B9 02 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B 46 0C 83 E8 02 50 8B 45 08 50 8B 4E 08 83 E9 02 8B 56 04 42 8B 06 40 E8 ?? ?? ?? ?? 80 7D 10 00 74 0D 6A 01 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2 14 00 }
	condition:
		$1
}

rule function_1322_0 {
	meta:
		name = "GetBitBtnGlyph"
		size = 142
		refs = "000d GetBitBtnGlyph 001f BitBtnGlyphs 0029 _Dn_TBitmap 002e TBitmap.Create 003f BitBtnResNames 0044 @LStrFromPChar 004d HInstance 005f TBitmap.LoadFromResourceName 007b @LStrClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B F3 83 E6 7F 83 3C B5 ?? ?? ?? ?? 00 75 3D B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 04 B5 ?? ?? ?? ?? 8D 45 FC 8B 14 B5 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC 8B 15 ?? ?? ?? ?? 8B 12 33 C0 8A C3 8B 04 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 1C B5 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1323_0 {
	meta:
		name = "TGlyphList.CreateSize"
		size = 78
		refs = "000d @ClassCreate 001e TCustomImageList.CreateSize 0025 _Dn_TBits 002a TObject.Create 0038 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 45 08 50 33 D2 8B C6 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 70 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_1324_0 {
	meta:
		name = "TGlyphList.Destroy"
		size = 45
		refs = "0003 @BeforeDestruction 000f TObject.Free 001b TCustomImageList.Destroy 0026 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 70 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1325_0 {
	meta:
		name = "TGlyphList.AllocateIndex"
		size = 63
		refs = "0008 TBits.OpenBit 001d TCustomImageList.Add 002a TBits.SetSize 0036 TBits.SetBit"
	strings:
		$1 = { 53 56 8B D8 8B 43 70 E8 ?? ?? ?? ?? 8B F0 8B 43 70 3B 70 04 7C 18 33 C9 33 D2 8B C3 E8 ?? ?? ?? ?? 8B F0 8D 56 01 8B 43 70 E8 ?? ?? ?? ?? B1 01 8B D6 8B 43 70 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1326_0 {
	meta:
		name = "TGlyphList.AddMasked"
		size = 41
		refs = "000d TGlyphList.AllocateIndex 001b TCustomImageList.ReplaceMasked"
	strings:
		$1 = { 53 56 57 55 8B E9 8B FA 8B D8 8B C3 E8 ?? ?? ?? ?? 8B F0 55 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? FF 43 74 8B C6 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1327_0 {
	meta:
		name = "TGlyphList.Delete"
		size = 38
		refs = "000c TBits.GetBit 001f TBits.SetBit"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 70 E8 ?? ?? ?? ?? 84 C0 74 0F FF 4B 74 33 C9 8B D6 8B 43 70 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1328_0 {
	meta:
		name = "TGlyphCache.Create"
		size = 68
		refs = "000a @ClassCreate 0017 TObject.Create 001e _Dn_TList 0031 @AfterConstruction"
		altNames = "TNameMap.Create TQRExportFilterLibrary.Create TValueList.Create"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 04 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_15906_0 {
	meta:
		name = "TQRLibrary.Create"
		size = 68
		refs = "000a @ClassCreate 0017 TObject.Create 001e _Dn_TStringList 0031 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 04 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1329_0 {
	meta:
		name = "TGlyphCache.Destroy"
		size = 45
		refs = "0003 @BeforeDestruction 000f TObject.Free 001b TObject.Destroy 0026 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 04 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_9379_0 {
	meta:
		name = "TPicture.Destroy"
		size = 45
		refs = "0003 @BeforeDestruction 000f TObject.Free 001b TPersistent.Destroy 0026 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 04 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1330_0 {
	meta:
		name = "TGlyphCache.GetList"
		size = 93
		refs = "001e TList.Get 0040 _DV_TGlyphList 0045 TGlyphList.CreateSize 0051 TList.Add"
	strings:
		$1 = { 53 56 57 55 51 89 0C 24 8B EA 8B F8 8B 47 04 8B 70 08 4E 83 FE 00 7C 1F 8B 47 04 8B D6 E8 ?? ?? ?? ?? 8B D8 3B 6B 28 75 08 8B 04 24 3B 43 24 74 24 4E 83 FE FF 75 E1 8B 04 24 50 8B CD B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 8B 47 04 8B D3 E8 ?? ?? ?? ?? 8B C3 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1331_0 {
	meta:
		name = "TGlyphCache.ReturnList"
		size = 32
		refs = "0013 TList.Remove 001a TObject.Free"
	strings:
		$1 = { 53 8B DA 85 DB 74 17 83 7B 74 00 75 11 8B D3 8B 40 04 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1332_0 {
	meta:
		name = "TGlyphCache.Empty"
		size = 11
	strings:
		$1 = { 8B 40 04 83 78 08 00 0F 94 C0 C3 }
	condition:
		$1
}

rule function_1333_0 {
	meta:
		name = "TButtonGlyph.Create"
		size = 145
		refs = "000e @ClassCreate 001c TObject.Create 0023 _Dn_TBitmap 0028 TBitmap.Create 0037 TButtonGlyph.GlyphChanged 005b GlyphCache 0065 _DV_TGlyphCache 006a TGlyphCache.Create 007c @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B D8 33 D2 8B C3 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 73 04 89 5E 08 C7 46 04 ?? ?? ?? ?? C7 43 1C 80 80 00 00 C6 43 20 01 33 C0 33 D2 8A D0 C7 44 93 0C FF FF FF FF 40 3C 04 75 EF 83 3D ?? ?? ?? ?? 00 75 11 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8B C3 80 7D FF 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1334_0 {
	meta:
		name = "TButtonGlyph.Destroy"
		size = 92
		refs = "0003 @BeforeDestruction 000f TObject.Free 0016 TButtonGlyph.Invalidate 001c GlyphCache 0029 TGlyphCache.Empty 004a TObject.Destroy 0055 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 04 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 1F A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 11 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1335_0 {
	meta:
		name = "TButtonGlyph.Invalidate"
		size = 71
		refs = "001f TGlyphList.Delete 0035 GlyphCache 003a TGlyphCache.ReturnList"
	strings:
		$1 = { 53 56 57 8B F0 33 DB 8B FB 83 E7 7F 8B 44 BE 0C 83 F8 FF 74 0E 33 D2 8A D3 8B D0 8B 46 08 E8 ?? ?? ?? ?? C7 44 BE 0C FF FF FF FF 43 80 FB 04 75 D6 8B 56 08 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 89 46 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1336_0 {
	meta:
		name = "TButtonGlyph.GlyphChanged"
		size = 46
		refs = "000e TBitmap.GetTransparentColor 0018 TButtonGlyph.Invalidate"
	strings:
		$1 = { 53 56 8B D8 8B 73 04 3B D6 75 20 8B C6 E8 ?? ?? ?? ?? 89 43 1C 8B C3 E8 ?? ?? ?? ?? 66 83 7B 26 00 74 08 8B D3 8B 43 28 FF 53 24 5E 5B C3 }
	condition:
		$1
}

rule function_1337_0 {
	meta:
		name = "TButtonGlyph.SetGlyph"
		size = 118
		refs = "0009 TButtonGlyph.Invalidate 0029 TBitmap.GetTransparentColor 006f TButtonGlyph.SetNumGlyphs"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B D3 8B 46 04 8B 08 FF 51 08 85 DB 74 58 8B C3 8B 10 FF 52 20 85 C0 7E 4D 8B C3 E8 ?? ?? ?? ?? 89 46 1C 8B C3 8B 10 FF 52 2C 50 8B C3 8B 10 FF 52 20 5A 92 8B CA 99 F7 F9 85 D2 75 29 8B C3 8B 10 FF 52 2C 50 8B C3 8B 10 FF 52 20 5A 92 8B CA 99 F7 F9 83 F8 04 7E 05 B8 01 00 00 00 8B D0 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1338_0 {
	meta:
		name = "TButtonGlyph.SetNumGlyphs"
		size = 38
		refs = "0012 TButtonGlyph.Invalidate 001f TButtonGlyph.GlyphChanged"
	strings:
		$1 = { 53 56 8B DA 8B F0 3A 5E 20 74 18 84 DB 76 14 8B C6 E8 ?? ?? ?? ?? 88 5E 20 8B 56 04 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1339_0 {
	meta:
		name = "TButtonGlyph.CreateButtonGlyph"
		size = 1494
		refs = "0088 GlyphCache 0092 _DV_TGlyphCache 0097 TGlyphCache.Create 00aa TGlyphCache.GetList 00b7 _Dn_TBitmap 00bc TBitmap.Create 00c7 TButtonGlyph.CreateButtonGlyph 00f1 Rect 00f9 TBitmap.GetCanvas 0106 TBrush.SetColor 0116 CopyPalette 017a TCanvas.CopyRect 019a TGlyphList.AddMasked 0258 TBitmap.SetMonochrome 02b7 TCanvas.GetHandle 02c1 SetTextColor 02cc SetBkColor 02ef BitBlt 037d ColorToRGB 043e TBitmap.GetMonochrome 0457 TFont.SetColor 04a1 TCanvas.FillRect 0566 TObject.Free 0574 @HandleFinally 05c9 TBitmap.Dormant"
	strings:
		$1 = { 55 8B EC 83 C4 C8 53 56 57 88 55 FB 89 45 FC 80 7D FB 02 75 0D 8B 45 FC 80 78 20 03 73 04 C6 45 FB 00 33 C0 8A 45 FB 8B 55 FC 8B 5C 82 0C 83 FB FF 0F 85 96 05 00 00 8B 45 FC 8B 40 04 8B 10 FF 52 2C 8B F0 8B 45 FC 8B 40 04 8B 10 FF 52 20 0B F0 0F 84 76 05 00 00 8B 45 FC 8B 40 04 8B 10 FF 52 2C 8B 55 FC 0F B6 52 20 8B CA 99 F7 F9 8B F8 8B 45 FC 8B 40 04 8B 10 FF 52 20 8B F0 8B 45 FC 83 78 08 00 75 2E 83 3D ?? ?? ?? ?? 00 75 11 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8B CE 8B D7 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 89 42 08 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D7 8B 45 F4 8B 08 FF 51 40 8B D6 8B 45 F4 8B 08 FF 51 34 56 8D 45 D8 50 8B CF 33 D2 33 C0 E8 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? 8B 40 14 BA 0F 00 00 80 E8 ?? ?? ?? ?? 8B 45 FC 8B 40 04 8B 10 FF 52 24 E8 ?? ?? ?? ?? 8B D0 8B 45 F4 8B 08 FF 51 38 8A 5D FB 8B 45 FC 3A 58 20 7C 02 33 DB 56 8D 45 C8 50 33 C9 8A CB 41 0F AF CF 33 C0 8A C3 F7 EF 33 D2 E8 ?? ?? ?? ?? 8A 45 FB 2C 01 72 0B 74 7F 48 2C 02 0F 83 3C 04 00 00 8D 45 C8 50 8B 45 FC 8B 40 04 E8 ?? ?? ?? ?? 50 8B 45 F4 E8 ?? ?? ?? ?? 8D 55 D8 59 E8 ?? ?? ?? ?? 8B 45 FC 8B 40 04 80 78 28 01 75 25 8B 45 FC 8B 48 1C 8B 45 FC 8B 40 08 8B 55 F4 E8 ?? ?? ?? ?? 33 D2 8A 55 FB 8B 4D FC 89 44 91 0C E9 EA 03 00 00 8B 45 FC 8B 40 08 B9 00 00 00 20 8B 55 F4 E8 ?? ?? ?? ?? 33 D2 8A 55 FB 8B 4D FC 89 44 91 0C E9 C6 03 00 00 33 C0 89 45 EC 33 C0 89 45 F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 EC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F0 8B 45 FC 8B 50 04 8B 45 F0 8B 08 FF 51 08 B2 01 8B 45 F0 8B 08 FF 51 68 8B 45 FC 80 78 20 01 0F 86 D8 01 00 00 8B 45 F4 E8 ?? ?? ?? ?? 89 45 E8 8D 45 C8 50 8B 45 F0 E8 ?? ?? ?? ?? 8B C8 8D 55 D8 8B 45 E8 E8 ?? ?? ?? ?? B2 01 8B 45 EC E8 ?? ?? ?? ?? 8B D7 8B 45 EC 8B 08 FF 51 40 8B D6 8B 45 EC 8B 08 FF 51 34 8B 45 F0 E8 ?? ?? ?? ?? 8B 40 14 BA FF FF FF 00 E8 ?? ?? ?? ?? 8D 45 C8 50 8B 45 F0 E8 ?? ?? ?? ?? 50 8B 45 EC E8 ?? ?? ?? ?? 8D 55 D8 59 E8 ?? ?? ?? ?? 8B 45 E8 8B 40 14 BA 14 00 00 80 E8 ?? ?? ?? ?? 8B 45 E8 E8 ?? ?? ?? ?? 8B D8 6A 00 53 E8 ?? ?? ?? ?? 68 FF FF FF 00 53 E8 ?? ?? ?? ?? 68 46 07 E2 00 6A 00 6A 00 8B 45 EC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 56 57 6A 00 6A 00 53 E8 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? 8B 40 14 BA 80 80 80 00 E8 ?? ?? ?? ?? 8D 45 C8 50 8B 45 F0 E8 ?? ?? ?? ?? 50 8B 45 EC E8 ?? ?? ?? ?? 8D 55 D8 59 E8 ?? ?? ?? ?? 8B 45 E8 8B 40 14 BA 10 00 00 80 E8 ?? ?? ?? ?? 8B 45 E8 E8 ?? ?? ?? ?? 8B D8 6A 00 53 E8 ?? ?? ?? ?? 68 FF FF FF 00 53 E8 ?? ?? ?? ?? 68 46 07 E2 00 6A 00 6A 00 8B 45 EC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 56 57 6A 00 6A 00 53 E8 ?? ?? ?? ?? 8B 45 FC 8B 40 1C E8 ?? ?? ?? ?? 50 8B 45 F0 E8 ?? ?? ?? ?? 8B 40 14 5A E8 ?? ?? ?? ?? 8D 45 C8 50 8B 45 F0 E8 ?? ?? ?? ?? 50 8B 45 EC E8 ?? ?? ?? ?? 8D 55 D8 59 E8 ?? ?? ?? ?? 8B 45 E8 8B 40 14 BA 0F 00 00 80 E8 ?? ?? ?? ?? 8B 45 E8 E8 ?? ?? ?? ?? 8B D8 6A 00 53 E8 ?? ?? ?? ?? 68 FF FF FF 00 53 E8 ?? ?? ?? ?? 68 46 07 E2 00 6A 00 6A 00 8B 45 EC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 56 57 6A 00 6A 00 53 E8 ?? ?? ?? ?? E9 4F 01 00 00 8B 45 FC 8B 50 04 8B 45 EC 8B 08 FF 51 08 B2 01 8B 45 EC 8B 08 FF 51 68 8B 45 EC E8 ?? ?? ?? ?? 8B 40 14 33 D2 E8 ?? ?? ?? ?? 8B D7 8B 45 EC 8B 08 FF 51 40 8B 45 EC E8 ?? ?? ?? ?? 84 C0 74 34 8B 45 EC E8 ?? ?? ?? ?? 8B 40 0C BA FF FF FF 00 E8 ?? ?? ?? ?? 33 D2 8B 45 EC E8 ?? ?? ?? ?? 8B 45 EC E8 ?? ?? ?? ?? 8B 40 14 BA FF FF FF 00 E8 ?? ?? ?? ?? B2 01 8B 45 EC E8 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? 8B D8 8B 43 14 BA 0F 00 00 80 E8 ?? ?? ?? ?? 8D 55 D8 8B C3 E8 ?? ?? ?? ?? 8B 43 14 BA 14 00 00 80 E8 ?? ?? ?? ?? 6A 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 68 FF FF FF 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 68 46 07 E2 00 6A 00 6A 00 8B 45 EC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 56 57 6A 01 6A 01 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 43 14 BA 10 00 00 80 E8 ?? ?? ?? ?? 6A 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 68 FF FF FF 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 68 46 07 E2 00 6A 00 6A 00 8B 45 EC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 56 57 6A 00 6A 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? 8B 45 EC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B 45 FC 8B 40 08 B9 00 00 00 20 8B 55 F4 E8 ?? ?? ?? ?? 33 D2 8A 55 FB 8B 4D FC 89 44 91 0C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 8A 45 FB 8B 55 FC 8B 5C 82 0C 8B 45 FC 8B 40 04 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1340_0 {
	meta:
		name = "TButtonGlyph.DrawButtonGlyph"
		size = 186
		refs = "003a TButtonGlyph.CreateButtonGlyph 0067 TCanvas.GetHandle 0071 TCustomImageList.GetHandle 0077 ImageList_DrawEx 008a ColorToRGB"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B F1 89 55 FC 8B D8 83 7B 04 00 0F 84 9A 00 00 00 8B 43 04 8B 10 FF 52 2C 85 C0 0F 84 8A 00 00 00 8B 43 04 8B 10 FF 52 20 85 C0 74 7E 8A 55 0C 8B C3 E8 ?? ?? ?? ?? 8B F8 80 7D 08 00 75 06 80 7D 0C 03 75 31 6A 01 68 FF FF FF 1F 68 FF FF FF 1F 6A 00 6A 00 8B 46 04 50 8B 06 50 8B 45 FC E8 ?? ?? ?? ?? 50 57 8B 43 08 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? EB 35 6A 00 68 FF FF FF 1F B8 0F 00 00 80 E8 ?? ?? ?? ?? 50 6A 00 6A 00 8B 46 04 50 8B 06 50 8B 45 FC E8 ?? ?? ?? ?? 50 57 8B 43 08 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5F 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_1341_0 {
	meta:
		name = "TButtonGlyph.DrawButtonText"
		size = 227
		refs = "0025 TBrush.SetStyle 003c OffsetRect 0049 TFont.SetColor 005a @LStrLen 0062 @LStrToPChar 006a TCanvas.GetHandle 0070 DrawText"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 8B 75 10 8D 7D F0 51 B9 04 00 00 00 F3 A5 59 8B F1 8B DA 8B 7D 08 B2 01 8B 43 14 E8 ?? ?? ?? ?? 80 7D 0C 01 0F 85 82 00 00 00 6A 01 6A 01 8D 45 F0 50 E8 ?? ?? ?? ?? BA 14 00 00 80 8B 43 0C E8 ?? ?? ?? ?? 8B C7 83 C8 05 50 8D 45 F0 50 8B C6 E8 ?? ?? ?? ?? 50 8B C6 E8 ?? ?? ?? ?? 50 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 6A FF 6A FF 8D 45 F0 50 E8 ?? ?? ?? ?? BA 10 00 00 80 8B 43 0C E8 ?? ?? ?? ?? 83 CF 05 57 8D 45 F0 50 8B C6 E8 ?? ?? ?? ?? 50 8B C6 E8 ?? ?? ?? ?? 50 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? EB 25 83 CF 05 57 8D 45 F0 50 8B C6 E8 ?? ?? ?? ?? 50 8B C6 E8 ?? ?? ?? ?? 50 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_1342_0 {
	meta:
		name = "TButtonGlyph.CalcButtonLayout"
		size = 781
		refs = "0047 Point 0092 @LStrLen 00aa Rect 00d3 @LStrToPChar 00dc TCanvas.GetHandle 00e2 DrawText 0300 OffsetRect"
	strings:
		$1 = { 55 8B EC 83 C4 C0 53 56 57 8B D9 89 55 F8 89 45 FC 8B 7D 0C 8B 75 10 8B 45 08 83 E0 02 83 F8 02 75 16 80 7D 1C 00 75 06 C6 45 1C 01 EB 0A 80 7D 1C 01 75 04 C6 45 1C 00 8B 53 0C 2B 53 04 8B 43 08 2B 03 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 FC 83 78 04 00 74 2E 8B 45 FC 8B 40 04 8B 10 FF 52 20 50 8B 45 FC 8B 40 04 8B 10 FF 52 2C 8B 55 FC 0F B6 52 20 8B CA 99 F7 F9 8D 4D E0 5A E8 ?? ?? ?? ?? EB 0C 8D 4D E0 33 D2 33 C0 E8 ?? ?? ?? ?? 8B 45 20 E8 ?? ?? ?? ?? 85 C0 7E 61 6A 00 8D 45 C0 50 8B 4B 08 2B 0B 33 D2 33 C0 E8 ?? ?? ?? ?? 56 57 8D 75 C0 B9 04 00 00 00 F3 A5 5F 5E 8B 45 08 0D 00 04 00 00 50 57 8B 45 20 E8 ?? ?? ?? ?? 50 8B 45 20 E8 ?? ?? ?? ?? 50 8B 45 F8 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 57 0C 2B 57 04 8B 47 08 2B 07 8D 4D D8 E8 ?? ?? ?? ?? EB 2B 6A 00 8D 45 C0 50 33 C9 33 D2 33 C0 E8 ?? ?? ?? ?? 56 57 8D 75 C0 B9 04 00 00 00 F3 A5 5F 5E 8D 4D D8 33 D2 33 C0 E8 ?? ?? ?? ?? 8A 45 1C 2C 02 73 23 8B 45 EC 8B D0 2B 55 E4 42 D1 FA 79 03 83 D2 00 89 56 04 2B 45 DC 40 D1 F8 79 03 83 D0 00 89 45 F4 EB 20 8B 45 E8 8B D0 2B 55 E0 42 D1 FA 79 03 83 D2 00 89 16 2B 45 D8 40 D1 F8 79 03 83 D0 00 89 45 F0 83 7D D8 00 74 06 83 7D E0 00 75 05 33 C0 89 45 14 83 7D 18 FF 0F 85 97 00 00 00 83 7D 14 FF 75 4A 8D 4D D0 8B 55 E4 03 55 DC 8B 45 E0 03 45 D8 E8 ?? ?? ?? ?? 8A 45 1C 2C 02 73 13 8B 45 E8 2B 45 D0 B9 03 00 00 00 99 F7 F9 89 45 18 EB 11 8B 45 EC 2B 45 D4 B9 03 00 00 00 99 F7 F9 89 45 18 8B 45 18 89 45 14 E9 96 00 00 00 8D 4D D0 8B 55 E4 03 55 14 03 55 DC 8B 45 E0 03 45 14 03 45 D8 E8 ?? ?? ?? ?? 8A 45 1C 2C 02 73 13 8B 45 E8 2B 45 D0 40 D1 F8 79 03 83 D0 00 89 45 18 EB 62 8B 45 EC 2B 45 D4 40 D1 F8 79 03 83 D0 00 89 45 18 EB 4F 83 7D 14 FF 75 49 8B 45 18 03 45 E4 8B 55 EC 2B D0 8B 45 18 03 45 E0 50 8B 45 E8 59 2B C1 8D 4D D0 E8 ?? ?? ?? ?? 8A 45 1C 2C 02 73 12 8B 45 D0 2B 45 D8 D1 F8 79 03 83 D0 00 89 45 14 EB 10 8B 45 D4 2B 45 DC D1 F8 79 03 83 D0 00 89 45 14 8A 45 1C 2C 01 72 0C 74 1A FE C8 74 2C FE C8 74 39 EB 4C 8B 45 18 89 06 03 45 E0 03 45 14 89 45 F0 EB 3C 8B 45 E8 2B 45 18 2B 45 E0 89 06 2B 45 14 2B 45 D8 89 45 F0 EB 26 8B 45 18 89 46 04 03 45 E4 03 45 14 89 45 F4 EB 15 8B 45 EC 2B 45 18 2B 45 E4 89 46 04 2B 45 14 2B 45 DC 89 45 F4 8B 03 8B 55 24 03 02 01 06 8B 43 04 8B 55 24 03 42 04 01 46 04 8B 53 04 03 55 F4 8B 45 24 8B 00 03 D0 52 8B 13 03 55 F0 8B 4D 24 03 D0 52 57 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2 20 00 }
	condition:
		$1
}

rule function_1343_0 {
	meta:
		name = "TButtonGlyph.Draw"
		size = 112
		refs = "0038 TButtonGlyph.CalcButtonLayout 004c TButtonGlyph.DrawButtonGlyph 0063 TButtonGlyph.DrawButtonText"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 89 4D FC 8B F2 8B D8 8B 7D 24 8B 45 28 50 57 8A 45 20 50 8B 45 1C 50 8B 45 18 50 8D 45 F4 50 8B 45 08 50 8B 45 0C 50 8B 4D FC 8B D6 8B C3 E8 ?? ?? ?? ?? 8A 45 14 50 8A 45 10 50 8D 4D F4 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 45 08 50 8A 45 14 50 8B 45 0C 50 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2 24 00 }
	condition:
		$1
}

rule function_1344_0 {
	meta:
		name = "TSpeedButton.Create"
		size = 192
		refs = "000e @ClassCreate 001c _DV_TButtonGlyph 0021 TButtonGlyph.Create 0037 TSpeedButton.GlyphChanged 0042 TGraphicControl.Create 0059 TSpeedButton.Create 0065 TControl.SetParentFont 0071 TControl.SetColor 0099 ButtonCount 00a6 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 88 55 FF 8B D8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 1C 01 00 00 8B 83 1C 01 00 00 89 58 28 C7 40 24 ?? ?? ?? ?? 8B CE 33 D2 8B C3 E8 ?? ?? ?? ?? 6A 17 6A 16 33 C9 33 D2 8B C3 8B 30 FF 96 80 00 00 00 A1 ?? ?? ?? ?? 89 43 40 B2 01 8B C3 E8 ?? ?? ?? ?? BA 0F 00 00 80 8B C3 E8 ?? ?? ?? ?? C7 83 24 01 00 00 04 00 00 00 C7 83 2C 01 00 00 FF FF FF FF C6 83 23 01 00 00 00 C6 83 28 01 00 00 01 FF 05 ?? ?? ?? ?? 8B C3 80 7D FF 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5E 5B 59 5D C3 00 82 00 00 00 }
	condition:
		$1
}

rule function_1345_0 {
	meta:
		name = "TSpeedButton.Destroy"
		size = 54
		refs = "0003 @BeforeDestruction 000d ButtonCount 0019 TGraphicControl.Destroy 0024 TObject.Free 002f @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 FF 0D ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 8B 86 1C 01 00 00 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1346_0 {
	meta:
		name = "TSpeedButton.Paint"
		size = 581
		refs = "0013 TSpeedButton.Paint 006d TCanvas.SetFont 0081 Rect 00b3 TCanvas.GetHandle 00b9 DrawFrameControl 00f1 FillStyles 010c DownStyles 0122 DrawEdge 013e TBrush.SetColor 014c TCanvas.FillRect 0159 InflateRect 018f AllocPatternBitmap 019f TBrush.SetBitmap 01d5 TControl.GetText 0205 TControl.DrawTextBiDiModeFlags 021e TButtonGlyph.Draw 0233 @LStrClr 0239 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 D4 53 56 33 D2 89 55 D4 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 10 FF 52 50 84 C0 75 10 C6 83 32 01 00 00 01 C6 83 21 01 00 00 00 EB 2B 80 BB 32 01 00 00 01 75 22 80 BB 20 01 00 00 00 74 12 83 BB 18 01 00 00 00 74 09 C6 83 32 01 00 00 03 EB 07 C6 83 32 01 00 00 00 8B 53 58 8B 83 14 01 00 00 E8 ?? ?? ?? ?? 8B 43 3C 50 8D 45 E8 50 8B 4B 38 33 D2 33 C0 E8 ?? ?? ?? ?? 80 BB 30 01 00 00 00 75 34 BE 10 20 00 00 8A 83 32 01 00 00 04 FE 2C 02 73 06 81 CE 00 02 00 00 56 6A 04 8D 45 E8 50 8B 83 14 01 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? E9 9B 00 00 00 8A 83 32 01 00 00 04 FE 2C 02 72 18 80 BB 31 01 00 00 00 74 09 80 BB 32 01 00 00 01 75 06 F6 43 20 10 74 42 33 C0 8A 83 28 01 00 00 8B 04 85 ?? ?? ?? ?? 83 C8 0F 50 8A 83 32 01 00 00 04 FE 2C 02 0F 92 C0 83 E0 7F 8B 04 85 ?? ?? ?? ?? 50 8D 45 E8 50 8B 83 14 01 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? EB 28 80 BB 28 01 00 00 00 75 1F 8B 83 14 01 00 00 8B 40 14 8B 53 64 E8 ?? ?? ?? ?? 8D 55 E8 8B 83 14 01 00 00 E8 ?? ?? ?? ?? 6A FF 6A FF 8D 45 E8 50 E8 ?? ?? ?? ?? 8A 83 32 01 00 00 04 FE 2C 02 73 58 80 BB 32 01 00 00 03 75 3F 80 BB 30 01 00 00 00 74 09 80 BB 31 01 00 00 00 75 2D BA 14 00 00 80 B8 0F 00 00 80 E8 ?? ?? ?? ?? 8B D0 8B 83 14 01 00 00 8B 40 14 E8 ?? ?? ?? ?? 8D 55 E8 8B 83 14 01 00 00 E8 ?? ?? ?? ?? C7 45 F8 01 00 00 00 C7 45 FC 01 00 00 00 EB 0A 33 C0 89 45 F8 33 C0 89 45 FC 8D 45 F8 50 8D 55 D4 8B C3 E8 ?? ?? ?? ?? 8B 45 D4 50 8A 83 23 01 00 00 50 8B 83 2C 01 00 00 50 8B 83 24 01 00 00 50 8A 83 32 01 00 00 50 8A 83 28 01 00 00 50 33 D2 8B C3 E8 ?? ?? ?? ?? 50 8D 45 D8 50 8D 4D E8 8B 93 14 01 00 00 8B 83 1C 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 D4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1347_0 {
	meta:
		name = "TSpeedButton.UpdateTracking"
		size = 99
		refs = "001d GetCursorPos 0026 FindDragTarget 0048 TControl.Perform"
	strings:
		$1 = { 53 56 83 C4 F8 8B F0 80 BE 30 01 00 00 00 74 4E 8B C6 8B 10 FF 52 50 84 C0 74 43 54 E8 ?? ?? ?? ?? 8B C4 B2 01 E8 ?? ?? ?? ?? 3B F0 0F 94 C3 80 F3 01 88 9E 31 01 00 00 84 DB 74 12 6A 00 33 C9 BA 14 B0 00 00 8B C6 E8 ?? ?? ?? ?? EB 10 6A 00 33 C9 BA 13 B0 00 00 8B C6 E8 ?? ?? ?? ?? 59 5A 5E 5B C3 }
	condition:
		$1
}

rule function_1348_0 {
	meta:
		name = "TSpeedButton.Loaded"
		size = 42
		refs = "0006 TControl.Loaded 0024 TButtonGlyph.CreateButtonGlyph"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 50 84 C0 74 04 33 C0 EB 02 B0 01 8B D0 8B 83 1C 01 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1349_0 {
	meta:
		name = "TSpeedButton.MouseDown"
		size = 85
		refs = "001d TControl.MouseDown"
	strings:
		$1 = { 55 8B EC 51 53 56 88 4D FF 8B DA 8B F0 8B 45 0C 50 8B 45 08 50 8A 4D FF 8B D3 8B C6 E8 ?? ?? ?? ?? 84 DB 75 29 8B C6 8B 10 FF 52 50 84 C0 74 1E 80 BE 20 01 00 00 00 75 0E C6 86 32 01 00 00 02 8B C6 8B 10 FF 52 78 C6 86 21 01 00 00 01 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_1350_0 {
	meta:
		name = "TSpeedButton.MouseMove"
		size = 160
		refs = "001a TControl.MouseMove 0041 TControl.GetClientWidth 0050 TControl.GetClientHeight 0094 TSpeedButton.UpdateTracking"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B F1 88 55 FF 8B D8 8B 7D 08 57 8B CE 8A 55 FF 8B C3 E8 ?? ?? ?? ?? 80 BB 21 01 00 00 00 74 61 80 BB 20 01 00 00 00 75 06 C6 45 FE 00 EB 04 C6 45 FE 03 85 F6 7C 2D 8B C3 E8 ?? ?? ?? ?? 3B F0 7D 22 85 FF 7C 1E 8B C3 E8 ?? ?? ?? ?? 3B F8 7F 13 80 BB 20 01 00 00 00 74 06 C6 45 FE 03 EB 04 C6 45 FE 02 8A 45 FE 3A 83 32 01 00 00 74 22 8A 45 FE 88 83 32 01 00 00 8B C3 8B 10 FF 52 78 EB 10 80 BB 31 01 00 00 00 75 07 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_1351_0 {
	meta:
		name = "TSpeedButton.MouseUp"
		size = 233
		refs = "0020 TControl.MouseUp 003f TControl.GetClientWidth 004e TControl.GetClientHeight 009e TSpeedButton.SetDown 00d6 @CallDynaInst 00dd TSpeedButton.UpdateTracking"
	strings:
		$1 = { 55 8B EC 51 53 56 57 88 4D FE 88 55 FF 8B F0 8B 7D 08 8B 5D 0C 53 57 8A 4D FE 8A 55 FF 8B C6 E8 ?? ?? ?? ?? 80 BE 21 01 00 00 00 0F 84 B0 00 00 00 C6 86 21 01 00 00 00 85 DB 7C 1A 8B C6 E8 ?? ?? ?? ?? 3B D8 7D 0F 85 FF 7C 0B 8B C6 E8 ?? ?? ?? ?? 3B F8 7E 04 33 C0 EB 02 B0 01 8B D8 83 BE 18 01 00 00 00 75 27 C6 86 32 01 00 00 00 C6 86 31 01 00 00 00 84 DB 74 52 8A 86 32 01 00 00 04 FE 2C 02 72 46 8B C6 8B 10 FF 52 78 EB 3D 84 DB 74 22 8A 96 20 01 00 00 80 F2 01 8B C6 E8 ?? ?? ?? ?? 80 BE 20 01 00 00 00 74 20 8B C6 8B 10 FF 52 7C EB 17 80 BE 20 01 00 00 00 74 07 C6 86 32 01 00 00 03 8B C6 8B 10 FF 52 7C 84 DB 74 0B 8B C6 66 BB EC FF E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_1353_0 {
	meta:
		name = "TSpeedButton.GetPalette"
		size = 17
		refs = "0006 TSpeedButton.GetGlyph"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 10 FF 52 24 5B C3 }
	condition:
		$1
}

rule function_1391_0 {
	meta:
		name = "TBitBtn.GetPalette"
		size = 17
		refs = "0006 TBitBtn.GetGlyph"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 10 FF 52 24 5B C3 }
	condition:
		$1
}

rule function_1354_0 {
	meta:
		name = "TSpeedButton.GetGlyph"
		size = 10
	strings:
		$1 = { 8B 80 1C 01 00 00 8B 40 04 C3 }
	condition:
		$1
}

rule function_1355_0 {
	meta:
		name = "TSpeedButton.SetGlyph"
		size = 23
		refs = "000a TButtonGlyph.SetGlyph"
	strings:
		$1 = { 53 8B D8 8B 83 1C 01 00 00 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 78 5B C3 }
	condition:
		$1
}

rule function_1356_0 {
	meta:
		name = "TSpeedButton.GetNumGlyphs"
		size = 10
	strings:
		$1 = { 8B 80 1C 01 00 00 8A 40 20 C3 }
	condition:
		$1
}

rule function_1357_0 {
	meta:
		name = "TSpeedButton.SetNumGlyphs"
		size = 43
		refs = "001e TButtonGlyph.SetNumGlyphs"
	strings:
		$1 = { 53 8B D8 84 D2 73 04 B2 01 EB 07 80 FA 04 76 02 B2 04 8B 83 1C 01 00 00 3A 50 20 74 0C E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 78 5B C3 }
	condition:
		$1
}

rule function_1358_0 {
	meta:
		name = "TBitBtn.GlyphChanged"
		size = 6
		altNames = "TBytesField.GetDataSize TControl.CMColorChanged TControl.CMEnabledChanged TControl.CMFontChanged TCustomDecisionGrid.FontChanged TCustomGrid.InvalidateGrid TCustomPanel.CMTextChanged TCustomTeePanel.CanvasChanged TQRShape.StyleChanged TShape.StyleChanged TSpeedButton.CMFontChanged TSpeedButton.CMTextChanged TSpeedButton.GlyphChanged TTabbedNotebook.CMTabFontChanged"
	strings:
		$1 = { 8B 10 FF 52 78 C3 }
	condition:
		$1
}

rule function_1359_0 {
	meta:
		name = "TSpeedButton.UpdateExclusive"
		size = 54
		refs = "002e TWinControl.Broadcast"
	strings:
		$1 = { 83 C4 F0 8B 90 18 01 00 00 85 D2 74 25 83 78 24 00 74 1F C7 04 24 18 B0 00 00 89 54 24 04 89 44 24 08 33 D2 89 54 24 0C 8B D4 8B 40 24 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule function_1360_0 {
	meta:
		name = "TSpeedButton.SetDown"
		size = 106
		refs = "0063 TSpeedButton.UpdateExclusive"
	strings:
		$1 = { 53 56 8B DA 8B F0 83 BE 18 01 00 00 00 75 02 33 DB 3A 9E 20 01 00 00 74 4E 80 BE 20 01 00 00 00 74 09 80 BE 22 01 00 00 00 74 3C 88 9E 20 01 00 00 84 DB 74 19 80 BE 32 01 00 00 00 75 07 8B C6 8B 10 FF 52 78 C6 86 32 01 00 00 03 EB 0E C6 86 32 01 00 00 00 8B C6 8B 10 FF 52 7C 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1361_0 {
	meta:
		name = "TSpeedButton.SetFlat"
		size = 20
	strings:
		$1 = { 3A 90 30 01 00 00 74 0B 88 90 30 01 00 00 8B 10 FF 52 78 C3 }
	condition:
		$1
}

rule function_1362_0 {
	meta:
		name = "TSpeedButton.SetGroupIndex"
		size = 20
		refs = "000f TSpeedButton.UpdateExclusive"
	strings:
		$1 = { 3B 90 18 01 00 00 74 0B 89 90 18 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1363_0 {
	meta:
		name = "TSpeedButton.SetLayout"
		size = 20
	strings:
		$1 = { 3A 90 23 01 00 00 74 0B 88 90 23 01 00 00 8B 10 FF 52 78 C3 }
	condition:
		$1
}

rule function_1364_0 {
	meta:
		name = "TSpeedButton.SetMargin"
		size = 25
	strings:
		$1 = { 3B 90 2C 01 00 00 74 10 83 FA FF 7C 0B 89 90 2C 01 00 00 8B 10 FF 52 78 C3 }
	condition:
		$1
}

rule function_1365_0 {
	meta:
		name = "TSpeedButton.SetSpacing"
		size = 20
	strings:
		$1 = { 3B 90 24 01 00 00 74 0B 89 90 24 01 00 00 8B 10 FF 52 78 C3 }
	condition:
		$1
}

rule function_1366_0 {
	meta:
		name = "TSpeedButton.SetTransparent"
		size = 60
		refs = "0016 TSpeedButton.SetTransparent"
	strings:
		$1 = { 53 8B D8 3A 93 28 01 00 00 74 2B 88 93 28 01 00 00 84 D2 74 0F A1 ?? ?? ?? ?? F7 D0 23 43 40 89 43 40 EB 0B A1 ?? ?? ?? ?? 0B 43 40 89 43 40 8B C3 8B 10 FF 52 78 5B C3 40 00 00 00 }
	condition:
		$1
}

rule function_1367_0 {
	meta:
		name = "TSpeedButton.SetAllowAllUp"
		size = 20
		refs = "000f TSpeedButton.UpdateExclusive"
	strings:
		$1 = { 3A 90 22 01 00 00 74 0B 88 90 22 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1368_0 {
	meta:
		name = "TSpeedButton.WMLButtonDblClk"
		size = 34
		refs = "0007 TControl.WMLButtonDblClk 001b @CallDynaInst"
	strings:
		$1 = { 53 56 8B F0 8B C6 E8 ?? ?? ?? ?? 80 BE 20 01 00 00 00 74 0B 8B C6 66 BB EB FF E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1369_0 {
	meta:
		name = "TSpeedButton.CMEnabledChanged"
		size = 46
		refs = "000f NewState 001a TButtonGlyph.CreateButtonGlyph 0021 TSpeedButton.UpdateTracking"
	strings:
		$1 = { 53 8B D8 8B C3 8B 10 FF 52 50 83 E0 7F 8A 90 ?? ?? ?? ?? 8B 83 1C 01 00 00 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 7C 5B C3 }
	condition:
		$1
}

rule function_1370_0 {
	meta:
		name = "TSpeedButton.CMButtonPressed"
		size = 76
	strings:
		$1 = { 53 56 8B D8 8B 42 04 3B 83 18 01 00 00 75 3A 8B 72 08 3B DE 74 33 80 BE 20 01 00 00 00 74 1E 80 BB 20 01 00 00 00 74 15 C6 83 20 01 00 00 00 C6 83 32 01 00 00 00 8B C3 8B 10 FF 52 78 8A 86 22 01 00 00 88 83 22 01 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_1371_0 {
	meta:
		name = "TSpeedButton.CMDialogChar"
		size = 127
		refs = "0010 TSpeedButton.CMDialogChar 0020 TControl.GetText 002c IsAccel 0046 @CallDynaInst 006d @LStrClr 0073 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B FA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C6 E8 ?? ?? ?? ?? 8B 55 FC 66 8B 47 04 E8 ?? ?? ?? ?? 84 C0 74 1F 8B C6 8B 10 FF 52 50 84 C0 74 14 8B C6 66 BB EC FF E8 ?? ?? ?? ?? C7 47 0C 01 00 00 00 EB 09 8B D7 8B C6 8B 08 FF 51 F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1374_0 {
	meta:
		name = "TSpeedButton.CMSysColorChange"
		size = 33
		refs = "000d TButtonGlyph.Invalidate 001a TButtonGlyph.CreateButtonGlyph"
	strings:
		$1 = { 53 56 8B D8 8B B3 1C 01 00 00 8B C6 E8 ?? ?? ?? ?? 8A 93 32 01 00 00 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1375_0 {
	meta:
		name = "TSpeedButton.CMMouseEnter"
		size = 70
		refs = "0006 TControl.CMMouseEnter 002e GetCapture"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 80 BB 30 01 00 00 00 74 31 80 BB 31 01 00 00 00 75 28 8B C3 8B 10 FF 52 50 84 C0 74 1D 80 7B 4D 01 74 17 E8 ?? ?? ?? ?? 85 C0 75 0E C6 83 31 01 00 00 01 8B C3 8B 10 FF 52 7C 5B C3 }
	condition:
		$1
}

rule function_1376_0 {
	meta:
		name = "TSpeedButton.CMMouseLeave"
		size = 64
		refs = "0006 TControl.CMMouseLeave"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 80 BB 30 01 00 00 00 74 2B 80 BB 31 01 00 00 00 74 22 8B C3 8B 10 FF 52 50 84 C0 74 17 80 BB 21 01 00 00 00 75 0E C6 83 31 01 00 00 00 8B C3 8B 10 FF 52 78 5B C3 }
	condition:
		$1
}

rule function_1377_0 {
	meta:
		name = "CopyImage"
		size = 143
		refs = "0014 TSpeedButton.GetGlyph 0031 TBitmap.GetCanvas 003e TBrush.SetColor 005c Rect 006d TCanvas.FillRect 0084 TCustomImageList.Draw"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 8B FA 8B F0 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B D8 8B 56 28 8B C3 8B 08 FF 51 40 8B 56 24 8B C3 8B 08 FF 51 34 8B C3 E8 ?? ?? ?? ?? 8B 40 14 BA FF 00 FF 00 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 20 50 8D 45 F0 50 8B C3 8B 10 FF 52 2C 8B C8 33 D2 33 C0 E8 ?? ?? ?? ?? 8D 45 F0 50 8B C3 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 6A 00 57 6A 01 8B C3 E8 ?? ?? ?? ?? 8B D0 33 C9 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1405_0 {
	meta:
		name = "CopyImage"
		size = 143
		refs = "0014 TBitBtn.GetGlyph 0031 TBitmap.GetCanvas 003e TBrush.SetColor 005c Rect 006d TCanvas.FillRect 0084 TCustomImageList.Draw"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 8B FA 8B F0 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B D8 8B 56 28 8B C3 8B 08 FF 51 40 8B 56 24 8B C3 8B 08 FF 51 34 8B C3 E8 ?? ?? ?? ?? 8B 40 14 BA FF 00 FF 00 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 20 50 8D 45 F0 50 8B C3 8B 10 FF 52 2C 8B C8 33 D2 33 C0 E8 ?? ?? ?? ?? 8D 45 F0 50 8B C3 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 6A 00 57 6A 01 8B C3 E8 ?? ?? ?? ?? 8B D0 33 C9 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1378_0 {
	meta:
		name = "TSpeedButton.ActionChange"
		size = 117
		refs = "0011 TControl.ActionChange 0019 _Dn_TCustomAction 001e @IsClass 002a TSpeedButton.GetGlyph 0055 TCustomImageList.GetCount 006b CopyImage"
	strings:
		$1 = { 55 8B EC 51 53 56 8B DA 89 45 FC 8B D3 8B 45 FC E8 ?? ?? ?? ?? 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 4A 8B 45 FC E8 ?? ?? ?? ?? 8B 10 FF 52 1C 84 C0 74 39 83 7B 44 00 74 33 8B 43 44 83 78 2C 00 74 2A 83 7B 5C 00 7C 24 8B F3 8B 46 44 8B 40 2C E8 ?? ?? ?? ?? 3B 46 5C 7E 12 55 8B C3 8B 50 5C 8B 40 44 8B 40 2C E8 ?? ?? ?? ?? 59 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1406_0 {
	meta:
		name = "TBitBtn.ActionChange"
		size = 117
		refs = "0011 TButtonControl.ActionChange 0019 _Dn_TCustomAction 001e @IsClass 002a TBitBtn.GetGlyph 0055 TCustomImageList.GetCount 006b CopyImage"
	strings:
		$1 = { 55 8B EC 51 53 56 8B DA 89 45 FC 8B D3 8B 45 FC E8 ?? ?? ?? ?? 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 4A 8B 45 FC E8 ?? ?? ?? ?? 8B 10 FF 52 1C 84 C0 74 39 83 7B 44 00 74 33 8B 43 44 83 78 2C 00 74 2A 83 7B 5C 00 7C 24 8B F3 8B 46 44 8B 40 2C E8 ?? ?? ?? ?? 3B 46 5C 7E 12 55 8B C3 8B 50 5C 8B 40 44 8B 40 2C E8 ?? ?? ?? ?? 59 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1379_0 {
	meta:
		name = "TBitBtn.Create"
		size = 168
		refs = "000b @ClassCreate 0018 _DV_TButtonGlyph 001d TButtonGlyph.Create 0033 TBitBtn.GlyphChanged 003e TButton.Create 0045 _Dn_TCanvas 004a TCanvas.Create 007e TBitBtn.Create 008f @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 87 FC 01 00 00 8B 87 FC 01 00 00 89 78 28 C7 40 24 ?? ?? ?? ?? 8B CE 33 D2 8B C7 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 87 F8 01 00 00 C6 87 00 02 00 00 00 C6 87 01 02 00 00 00 C6 87 02 02 00 00 00 C7 87 04 02 00 00 04 00 00 00 C7 87 08 02 00 00 FF FF FF FF A1 ?? ?? ?? ?? 0B 47 40 89 47 40 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 00 00 40 00 00 }
	condition:
		$1
}

rule function_1380_0 {
	meta:
		name = "TBitBtn.Destroy"
		size = 59
		refs = "0003 @BeforeDestruction 0013 TWinControl.Destroy 001e TObject.Free 0034 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 8B 86 FC 01 00 00 E8 ?? ?? ?? ?? 8B 86 F8 01 00 00 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1381_0 {
	meta:
		name = "TBitBtn.CreateHandle"
		size = 44
		refs = "0018 TWinControl.CreateHandle 0025 TButtonGlyph.CreateButtonGlyph"
	strings:
		$1 = { 53 56 8B F0 8B C6 8B 10 FF 52 50 84 C0 74 04 33 DB EB 02 B3 01 8B C6 E8 ?? ?? ?? ?? 8B D3 8B 86 FC 01 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1382_0 {
	meta:
		name = "TBitBtn.CreateParams"
		size = 16
		refs = "0006 TButton.CreateParams"
	strings:
		$1 = { 53 8B DA 8B D3 E8 ?? ?? ?? ?? 83 4B 04 0B 5B C3 }
	condition:
		$1
}

rule function_1383_0 {
	meta:
		name = "TBitBtn.SetButtonStyle"
		size = 20
		refs = "000f TControl.Refresh"
	strings:
		$1 = { 3A 90 0C 02 00 00 74 0B 88 90 0C 02 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1384_0 {
	meta:
		name = "TBitBtn.Click"
		size = 108
		refs = "0014 GetParentForm 001d TCustomForm.Close 0026 TButton.Click 0046 Application 0054 TApplication.HelpContext"
	strings:
		$1 = { 53 8B D8 8A 83 01 02 00 00 2C 03 74 1F 2C 03 75 52 8B C3 E8 ?? ?? ?? ?? 85 C0 74 07 E8 ?? ?? ?? ?? EB 47 8B C3 E8 ?? ?? ?? ?? 5B C3 8B C3 EB 03 8B 40 24 85 C0 74 09 83 B8 44 01 00 00 00 74 F0 85 C0 74 16 8B 15 ?? ?? ?? ?? 8B 12 8B 80 44 01 00 00 92 E8 ?? ?? ?? ?? EB 10 8B C3 E8 ?? ?? ?? ?? 5B C3 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1385_0 {
	meta:
		name = "TBitBtn.CNMeasureItem"
		size = 16
	strings:
		$1 = { 8B 52 08 8B 48 38 89 4A 0C 8B 40 3C 89 42 10 C3 }
	condition:
		$1
}

rule function_1386_0 {
	meta:
		name = "TBitBtn.CNDrawItem"
		size = 9
		refs = "0004 TBitBtn.DrawItem"
	strings:
		$1 = { 8B 52 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1387_0 {
	meta:
		name = "TBitBtn.DrawItem"
		size = 651
		refs = "0016 TBitBtn.DrawItem 002a TCanvas.SetHandle 009e TPen.SetColor 00b1 TPen.SetWidth 00c1 TBrush.SetStyle 00da TCanvas.Rectangle 00e7 InflateRect 0124 TBrush.SetColor 015f DrawFrameControl 018d TCanvas.SetFont 019e OffsetRect 01aa Point 01b8 TControl.GetText 01e0 TControl.DrawTextBiDiModeFlags 01f9 TButtonGlyph.Draw 0250 TCanvas.GetHandle 0256 DrawFocusRect 0278 @LStrClr 027e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 CC 53 56 57 33 C9 89 4D CC 8B F2 8B F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 56 18 8B 87 F8 01 00 00 E8 ?? ?? ?? ?? 8D 55 E8 8B C7 8B 08 FF 51 44 8B 46 10 A8 01 0F 95 C3 A8 10 0F 95 45 FF 8B C7 8B 10 FF 52 50 84 C0 75 06 C6 45 FE 01 EB 0E 84 DB 74 06 C6 45 FE 02 EB 04 C6 45 FE 00 C7 45 F8 10 20 00 00 84 DB 74 07 81 4D F8 00 02 00 00 F6 46 10 04 74 07 81 4D F8 00 01 00 00 8A 87 0C 02 00 00 0A 45 FF 74 5C 8B 87 F8 01 00 00 8B 40 10 BA 06 00 00 80 E8 ?? ?? ?? ?? 8B 87 F8 01 00 00 8B 40 10 BA 01 00 00 00 E8 ?? ?? ?? ?? 8B 87 F8 01 00 00 8B 40 14 B2 01 E8 ?? ?? ?? ?? 8B 45 F0 50 8B 45 F4 50 8B 4D EC 8B 55 E8 8B 87 F8 01 00 00 E8 ?? ?? ?? ?? 6A FF 6A FF 8D 45 E8 50 E8 ?? ?? ?? ?? 84 DB 74 61 8B 87 F8 01 00 00 8B 40 10 BA 10 00 00 80 E8 ?? ?? ?? ?? 8B 87 F8 01 00 00 8B 40 10 BA 01 00 00 00 E8 ?? ?? ?? ?? 8B 87 F8 01 00 00 8B 40 14 BA 0F 00 00 80 E8 ?? ?? ?? ?? 8B 45 F0 50 8B 45 F4 50 8B 4D EC 8B 55 E8 8B 87 F8 01 00 00 E8 ?? ?? ?? ?? 6A FF 6A FF 8D 45 E8 50 E8 ?? ?? ?? ?? EB 13 8B 45 F8 50 6A 04 8D 45 E8 50 8B 46 18 50 E8 ?? ?? ?? ?? 80 BF 0C 02 00 00 00 74 17 8D 55 E8 8B C7 8B 08 FF 51 44 6A FF 6A FF 8D 45 E8 50 E8 ?? ?? ?? ?? 8B 57 58 8B 87 F8 01 00 00 E8 ?? ?? ?? ?? 84 DB 74 0D 6A 01 6A 01 8D 45 E8 50 E8 ?? ?? ?? ?? 8D 4D D0 33 D2 33 C0 E8 ?? ?? ?? ?? 8D 45 D0 50 8D 55 CC 8B C7 E8 ?? ?? ?? ?? 8B 45 CC 50 8A 87 02 02 00 00 50 8B 87 08 02 00 00 50 8B 87 04 02 00 00 50 8A 45 FE 50 6A 00 33 D2 8B C7 E8 ?? ?? ?? ?? 50 8D 45 D8 50 8D 4D E8 8B 97 F8 01 00 00 8B 87 FC 01 00 00 E8 ?? ?? ?? ?? 8A 87 0C 02 00 00 22 45 FF 74 52 8D 55 E8 8B C7 8B 08 FF 51 44 6A FC 6A FC 8D 45 E8 50 E8 ?? ?? ?? ?? 8B 87 F8 01 00 00 8B 40 10 BA 06 00 00 80 E8 ?? ?? ?? ?? 8B 87 F8 01 00 00 8B 40 14 BA 0F 00 00 80 E8 ?? ?? ?? ?? 8D 45 E8 50 8B 87 F8 01 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 33 D2 8B 87 F8 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1388_0 {
	meta:
		name = "TBitBtn.CMFontChanged"
		size = 19
		refs = "0006 TWinControl.CMFontChanged"
	strings:
		$1 = { 56 8B F0 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 52 78 5E C3 }
	condition:
		$1
}

rule function_1389_0 {
	meta:
		name = "TBitBtn.CMEnabledChanged"
		size = 19
		refs = "0006 TWinControl.CMEnabledChanged"
	strings:
		$1 = { 56 8B F0 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 52 78 5E C3 }
	condition:
		$1
}

rule function_2267_0 {
	meta:
		name = "TColorGrid.CMCtl3DChanged"
		size = 19
		refs = "0006 TWinControl.CMCtl3DChanged"
	strings:
		$1 = { 56 8B F0 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 52 78 5E C3 }
	condition:
		$1
}

rule function_17593_0 {
	meta:
		name = "TCustomCheckBox.WMSize"
		size = 19
		refs = "0006 TWinControl.WMSize"
	strings:
		$1 = { 56 8B F0 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 52 78 5E C3 }
	condition:
		$1
}

rule function_17416_0 {
	meta:
		name = "TCustomGroupBox.WMSize"
		size = 19
		refs = "0006 TWinControl.WMSize"
	strings:
		$1 = { 56 8B F0 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 52 78 5E C3 }
	condition:
		$1
}

rule function_8399_0 {
	meta:
		name = "TCustomPanel.CMBorderChanged"
		size = 19
		refs = "0006 TWinControl.CMBorderChanged"
	strings:
		$1 = { 56 8B F0 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 52 78 5E C3 }
	condition:
		$1
}

rule function_5708_0 {
	meta:
		name = "TDBCtrlGrid.WMSize"
		size = 19
		refs = "0006 TWinControl.WMSize"
	strings:
		$1 = { 56 8B F0 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 52 78 5E C3 }
	condition:
		$1
}

rule function_6317_0 {
	meta:
		name = "TDBImage.WMSize"
		size = 19
		refs = "0006 TWinControl.WMSize"
	strings:
		$1 = { 56 8B F0 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 52 78 5E C3 }
	condition:
		$1
}

rule function_8474_0 {
	meta:
		name = "THeader.WMSize"
		size = 19
		refs = "0006 TWinControl.WMSize"
	strings:
		$1 = { 56 8B F0 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 52 78 5E C3 }
	condition:
		$1
}

rule function_2495_0 {
	meta:
		name = "THeaderControl.WMWindowPosChanged"
		size = 19
		refs = "0006 TWinControl.WMWindowPosChanged"
	strings:
		$1 = { 56 8B F0 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 52 78 5E C3 }
	condition:
		$1
}

rule function_1390_0 {
	meta:
		name = "TBitBtn.WMLButtonDblClk"
		size = 18
		refs = "000d TControl.Perform"
	strings:
		$1 = { 8B 4A 08 51 8B 4A 04 BA 01 02 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1392_0 {
	meta:
		name = "TBitBtn.SetGlyph"
		size = 30
		refs = "000a TButtonGlyph.SetGlyph"
	strings:
		$1 = { 53 8B D8 8B 83 FC 01 00 00 E8 ?? ?? ?? ?? C6 83 0D 02 00 00 01 8B C3 8B 10 FF 52 78 5B C3 }
	condition:
		$1
}

rule function_1393_0 {
	meta:
		name = "TBitBtn.GetGlyph"
		size = 10
	strings:
		$1 = { 8B 80 FC 01 00 00 8B 40 04 C3 }
	condition:
		$1
}

rule function_1395_0 {
	meta:
		name = "TBitBtn.IsCustom"
		size = 17
		refs = "0006 TBitBtn.GetKind"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 0F 94 C0 5B C3 }
	condition:
		$1
}

rule function_1396_0 {
	meta:
		name = "TBitBtn.SetStyle"
		size = 20
	strings:
		$1 = { 3A 90 00 02 00 00 74 0B 88 90 00 02 00 00 8B 10 FF 52 78 C3 }
	condition:
		$1
}

rule function_1397_0 {
	meta:
		name = "TBitBtn.SetKind"
		size = 270
		refs = "0012 TBitBtn.SetKind 0043 TButton.SetDefault 0069 TControl.GetText 0080 BitBtnCaptions 0092 LoadResString 009c TControl.SetText 00a7 BitBtnModalResults 00b4 GetBitBtnGlyph 00c1 TButtonGlyph.SetGlyph 00ca TBitBtn.SetNumGlyphs 00f3 @LStrClr 0101 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 57 8B DA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 3A 9E 01 02 00 00 0F 84 BA 00 00 00 84 DB 0F 84 A5 00 00 00 8B C3 2C 01 74 08 2C 03 74 04 33 D2 EB 02 B2 01 8B C6 E8 ?? ?? ?? ?? 8B C3 2C 02 74 08 2C 03 74 04 33 C0 EB 02 B0 01 88 86 F1 01 00 00 F6 46 20 01 74 10 8D 55 FC 8B C6 E8 ?? ?? ?? ?? 83 7D FC 00 74 06 F6 46 20 01 75 27 33 C0 8A C3 8B 3C 85 ?? ?? ?? ?? 85 FF 74 18 8D 55 F8 33 C0 8A C3 8B C7 E8 ?? ?? ?? ?? 8B 55 F8 8B C6 E8 ?? ?? ?? ?? 33 C0 8A C3 8B 04 85 ?? ?? ?? ?? 89 86 F4 01 00 00 8B C3 E8 ?? ?? ?? ?? 8B D0 8B 86 FC 01 00 00 E8 ?? ?? ?? ?? B2 02 8B C6 E8 ?? ?? ?? ?? C6 86 0D 02 00 00 00 88 9E 01 02 00 00 8B C6 8B 10 FF 52 78 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1398_0 {
	meta:
		name = "TBitBtn.IsCustomCaption"
		size = 121
		refs = "000e TBitBtn.IsCustomCaption 0026 BitBtnCaptions 002b LoadResString 0039 TControl.GetText 0042 AnsiCompareStr 005e @LStrClr 006c @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 33 C0 8A 83 01 02 00 00 8B 04 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 5A E8 ?? ?? ?? ?? 85 C0 0F 95 C0 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1399_0 {
	meta:
		name = "TBitBtn.GetKind"
		size = 108
		refs = "0049 BitBtnModalResults"
	strings:
		$1 = { 80 B8 01 02 00 00 00 74 5C 8A 90 01 02 00 00 8B CA 80 E9 01 74 09 80 E9 03 74 04 33 C9 EB 02 B1 01 32 88 F0 01 00 00 75 35 8B CA 80 E9 02 74 09 80 E9 03 74 04 33 C9 EB 02 B1 01 32 88 F1 01 00 00 75 1B 83 E2 7F 8B 14 95 ?? ?? ?? ?? 3B 90 F4 01 00 00 75 09 80 B8 0D 02 00 00 00 74 07 C6 80 01 02 00 00 00 8A 80 01 02 00 00 C3 }
	condition:
		$1
}

rule function_1400_0 {
	meta:
		name = "TBitBtn.SetLayout"
		size = 20
	strings:
		$1 = { 3A 90 02 02 00 00 74 0B 88 90 02 02 00 00 8B 10 FF 52 78 C3 }
	condition:
		$1
}

rule function_1401_0 {
	meta:
		name = "TBitBtn.GetNumGlyphs"
		size = 10
	strings:
		$1 = { 8B 80 FC 01 00 00 8A 40 20 C3 }
	condition:
		$1
}

rule function_1402_0 {
	meta:
		name = "TBitBtn.SetNumGlyphs"
		size = 43
		refs = "001e TButtonGlyph.SetNumGlyphs"
	strings:
		$1 = { 53 8B D8 84 D2 73 04 B2 01 EB 07 80 FA 04 76 02 B2 04 8B 83 FC 01 00 00 3A 50 20 74 0C E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 78 5B C3 }
	condition:
		$1
}

rule function_1403_0 {
	meta:
		name = "TBitBtn.SetSpacing"
		size = 20
	strings:
		$1 = { 3B 90 04 02 00 00 74 0B 89 90 04 02 00 00 8B 10 FF 52 78 C3 }
	condition:
		$1
}

rule function_1404_0 {
	meta:
		name = "TBitBtn.SetMargin"
		size = 25
	strings:
		$1 = { 3B 90 08 02 00 00 74 10 83 FA FF 7C 0B 89 90 08 02 00 00 8B 10 FF 52 78 C3 }
	condition:
		$1
}

rule function_1407_0 {
	meta:
		name = "DestroyLocals"
		size = 26
		refs = "0005 BitBtnGlyphs 000c TObject.Free"
	strings:
		$1 = { 53 56 B3 0B BE ?? ?? ?? ?? 8B 06 E8 ?? ?? ?? ?? 83 C6 04 FE CB 75 F2 5E 5B C3 }
	condition:
		$1
}

rule function_1409_0 {
	meta:
		name = "Finalization"
		size = 53
		refs = "0007 Finalization 0013 _DV_3 001a DestroyLocals 002d @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 05 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_1633_0 {
	meta:
		name = "Finalization"
		size = 53
		refs = "0007 Finalization 0013 _DV_21 001a TeeGalleryExitProc 002d @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 05 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_14353_0 {
	meta:
		name = "Finalization"
		size = 53
		refs = "0007 Finalization 0013 _DV_3 001a OleUninitialize 002d @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 05 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_1410_0 {
	meta:
		name = "Buttons"
		size = 37
		refs = "0002 _DV_3 000a _NF__309 000f @InitImports 0014 BitBtnGlyphs 0020 @FillChar"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 1B B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? 33 C9 BA 2C 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1411_0 {
	meta:
		name = "TCalendar.Create"
		size = 176
		refs = "000a @ClassCreate 0017 TCustomGrid.Create 0027 TCustomGrid.SetFixedCols 0033 TCustomGrid.SetFixedRows 003f TCustomGrid.SetColCount 004b TCustomGrid.SetRowCount 0054 TCustomGrid.SetScrollBars 005b TCalendar.Create 0072 TCustomGrid.SetOptions 0077 Date 0093 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? C6 86 8B 02 00 00 01 33 D2 8B C6 E8 ?? ?? ?? ?? BA 01 00 00 00 8B C6 E8 ?? ?? ?? ?? BA 07 00 00 00 8B C6 E8 ?? ?? ?? ?? BA 07 00 00 00 8B C6 E8 ?? ?? ?? ?? 33 D2 8B C6 E8 ?? ?? ?? ?? 66 8B 15 ?? ?? ?? ?? F7 D2 66 23 96 28 02 00 00 66 0B 15 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? DD 9E 74 02 00 00 9B 8B C6 8B 10 FF 92 E4 00 00 00 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 00 00 10 00 00 00 20 00 00 00 }
	condition:
		$1
}

rule function_1412_0 {
	meta:
		name = "TCalendar.Change"
		size = 29
	strings:
		$1 = { 53 66 83 B8 82 02 00 00 00 74 10 8B D8 8B D0 8B 83 84 02 00 00 FF 93 80 02 00 00 5B C3 }
	condition:
		$1
}

rule function_1413_0 {
	meta:
		name = "TCalendar.Click"
		size = 113
		refs = "000c TCalendar.Click 0019 TControl.Click 0030 TCalendar.GetCellText 003e StrToInt 004c TCalendar.SetDateElement 0061 @LStrClr 0067 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 8D 45 FC 50 8B 8B 0C 02 00 00 8B 93 08 02 00 00 8B C3 E8 ?? ?? ?? ?? 83 7D FC 00 74 16 8B 45 FC E8 ?? ?? ?? ?? 8B C8 BA 03 00 00 00 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1414_0 {
	meta:
		name = "TCalendar.IsLeapYear"
		size = 57
	strings:
		$1 = { 53 8B CA 8B C1 25 03 00 00 80 79 05 48 83 C8 FC 40 85 C0 75 1C 8B C1 BB 64 00 00 00 99 F7 FB 85 D2 75 12 8B C1 B9 90 01 00 00 99 F7 F9 85 D2 74 04 33 C0 5B C3 B0 01 5B C3 }
	condition:
		$1
}

rule function_1415_0 {
	meta:
		name = "TCalendar.DaysPerMonth"
		size = 46
		refs = "000d DaysInMonth"
	strings:
		$1 = { 53 56 57 55 8B F1 8B EA 8B D8 8B 3C B5 ?? ?? ?? ?? 83 FE 02 75 11 8B D5 8B C3 8B 08 FF 91 E0 00 00 00 84 C0 74 01 47 8B C7 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1416_0 {
	meta:
		name = "TCalendar.DaysThisMonth"
		size = 43
		refs = "000b TCalendar.GetDateElement"
	strings:
		$1 = { 53 8B D8 BA 02 00 00 00 8B C3 E8 ?? ?? ?? ?? 50 BA 01 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C3 59 8B 18 FF 93 D8 00 00 00 5B C3 }
	condition:
		$1
}

rule function_1417_0 {
	meta:
		name = "TCalendar.DrawCell"
		size = 181
		refs = "0027 TCalendar.DrawCell 003c TCalendar.GetCellText 004c TCanvas.TextHeight 006e TCanvas.TextWidth 008b TCanvas.TextRect 00a0 @LStrClr 00a6 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D FC 8B 75 0C 8D 7D EC 51 B9 04 00 00 00 F3 A5 59 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 9B EC 01 00 00 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 55 F8 8B 7D F0 2B D7 2B D0 D1 FA 79 03 83 D2 00 03 D7 52 8B 45 FC 50 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 4D F4 8B 75 EC 2B CE 2B C8 D1 F9 79 03 83 D1 00 03 CE 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_1418_0 {
	meta:
		name = "TCalendar.GetCellText"
		size = 112
		refs = "0024 ShortDayNames 002e @LStrLAsg 005a @LStrClr 0065 IntToStr"
	strings:
		$1 = { 55 8B EC 53 56 57 8B F2 8B D8 8B 7D 08 85 C9 75 23 33 C0 8A 83 89 02 00 00 03 C6 B9 07 00 00 00 99 F7 F9 A1 ?? ?? ?? ?? 8B 14 90 8B C7 E8 ?? ?? ?? ?? EB 35 03 B3 7C 02 00 00 49 8B C1 C1 E0 03 2B C1 03 F0 83 FE 01 7C 0E 8B C3 8B 10 FF 92 DC 00 00 00 3B F0 7E 09 8B C7 E8 ?? ?? ?? ?? EB 09 8B D7 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_1419_0 {
	meta:
		name = "TCalendar.SelectCell"
		size = 121
		refs = "0012 TCalendar.SelectCell 0039 TCalendar.GetCellText 004e TCustomGrid.SelectCell 0065 @LStrClr 006b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 80 BB 8A 02 00 00 00 75 09 80 BB 88 02 00 00 00 75 15 8D 45 FC 50 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 83 7D FC 00 75 04 33 DB EB 0D 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1420_0 {
	meta:
		name = "TCalendar.SetCalendarDate"
		size = 50
		refs = "0029 @CallDynaInst"
	strings:
		$1 = { 55 8B EC 53 8B D8 8B 45 08 89 83 74 02 00 00 8B 45 0C 89 83 78 02 00 00 8B C3 8B 10 FF 92 E4 00 00 00 8B C3 66 BB A3 FF E8 ?? ?? ?? ?? 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_1421_0 {
	meta:
		name = "TCalendar.StoreCalendarDate"
		size = 9
	strings:
		$1 = { 8A 80 8B 02 00 00 34 01 C3 }
	condition:
		$1
}

rule function_1422_0 {
	meta:
		name = "TCalendar.GetDateElement"
		size = 73
		refs = "001f DecodeDate"
	strings:
		$1 = { 53 83 C4 F8 8B DA FF B0 78 02 00 00 FF B0 74 02 00 00 8D 4C 24 0C 8D 54 24 0A 8D 44 24 08 E8 ?? ?? ?? ?? 4B 74 08 4B 74 0B 4B 74 0F EB 14 0F B7 04 24 EB 11 0F B7 44 24 02 EB 0A 0F B7 44 24 04 EB 03 83 C8 FF 59 5A 5B C3 }
	condition:
		$1
}

rule function_1423_0 {
	meta:
		name = "TCalendar.SetDateElement"
		size = 183
		refs = "002d DecodeDate 008a EncodeDate 00ad @CallDynaInst"
	strings:
		$1 = { 53 56 57 83 C4 F8 8B F1 8B FA 8B D8 85 F6 0F 8E 9D 00 00 00 FF B3 78 02 00 00 FF B3 74 02 00 00 8D 4C 24 0C 8D 54 24 0A 8D 44 24 08 E8 ?? ?? ?? ?? 4F 74 08 4F 74 13 4F 74 25 EB 75 0F B7 04 24 3B F0 74 6D 66 89 34 24 EB 31 83 FE 0C 7F 62 0F B7 44 24 02 3B F0 74 59 66 89 74 24 02 EB 1C 8B C3 8B 10 FF 92 DC 00 00 00 3B F0 7F 44 0F B7 44 24 04 3B F0 74 3B 66 89 74 24 04 66 8B 4C 24 04 66 8B 54 24 02 66 8B 04 24 E8 ?? ?? ?? ?? DD 9B 74 02 00 00 9B C6 83 8B 02 00 00 00 8B C3 8B 10 FF 92 E4 00 00 00 8B C3 66 BB A3 FF E8 ?? ?? ?? ?? 59 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1424_0 {
	meta:
		name = "TCalendar.SetStartOfWeek"
		size = 29
	strings:
		$1 = { 56 8B F0 3A 96 89 02 00 00 74 10 88 96 89 02 00 00 8B C6 8B 10 FF 92 E4 00 00 00 5E C3 }
	condition:
		$1
}

rule function_1425_0 {
	meta:
		name = "TCalendar.SetUseCurrentDate"
		size = 45
		refs = "0016 Date"
	strings:
		$1 = { 56 8B F0 3A 96 8B 02 00 00 74 20 88 96 8B 02 00 00 84 D2 74 16 E8 ?? ?? ?? ?? DD 9E 74 02 00 00 9B 8B C6 8B 10 FF 92 E4 00 00 00 5E C3 }
	condition:
		$1
}

rule function_1426_0 {
	meta:
		name = "TCalendar.ChangeMonth"
		size = 243
		refs = "0024 DecodeDate 0061 EncodeDate 00e7 TCalendar.SetCalendarDate"
	strings:
		$1 = { 53 56 57 55 83 C4 EC 8B FA 8B D8 FF B3 78 02 00 00 FF B3 74 02 00 00 8D 4C 24 0C 8D 54 24 0A 8D 44 24 08 E8 ?? ?? ?? ?? 0F B7 74 24 04 85 FF 7E 1A 0F B7 4C 24 02 0F B7 14 24 8B C3 8B 28 FF 95 D8 00 00 00 66 89 44 24 04 EB 07 66 C7 44 24 04 01 00 66 8B 4C 24 04 66 8B 54 24 02 66 8B 04 24 E8 ?? ?? ?? ?? DD 5C 24 08 9B 89 7C 24 10 DB 44 24 10 DC 44 24 08 DD 5C 24 08 9B FF 74 24 0C FF 74 24 0C 8D 4C 24 0C 8D 54 24 0A 8D 44 24 08 E8 ?? ?? ?? ?? 0F B7 4C 24 02 0F B7 14 24 8B C3 8B 38 FF 97 D8 00 00 00 3B F0 7D 07 66 89 74 24 04 EB 18 0F B7 4C 24 02 0F B7 14 24 8B C3 8B 30 FF 96 D8 00 00 00 66 89 44 24 04 66 8B 4C 24 04 66 8B 54 24 02 66 8B 04 24 E8 ?? ?? ?? ?? 83 C4 F8 DD 1C 24 9B 8B C3 E8 ?? ?? ?? ?? 83 C4 14 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1427_0 {
	meta:
		name = "TCalendar.PrevMonth"
		size = 9
		refs = "0004 TCalendar.ChangeMonth"
	strings:
		$1 = { 83 CA FF E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_11246_0 {
	meta:
		name = "TCustomImageList.Clear"
		size = 9
		refs = "0004 TCustomImageList.Delete"
	strings:
		$1 = { 83 CA FF E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5546_0 {
	meta:
		name = "TDataSet.Prior"
		size = 9
		refs = "0004 TDataSet.MoveBy"
	strings:
		$1 = { 83 CA FF E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1428_0 {
	meta:
		name = "TCalendar.NextMonth"
		size = 11
		refs = "0006 TCalendar.ChangeMonth"
	strings:
		$1 = { BA 01 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5545_0 {
	meta:
		name = "TDataSet.BlockReadNext"
		size = 11
		refs = "0006 TDataSet.MoveBy"
	strings:
		$1 = { BA 01 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_13570_0 {
	meta:
		name = "TNMFTP.Reinitialize"
		size = 28
		refs = "0001 TNMFTP.Reinitialize 0006 TNMFTP.DoCommand"
	strings:
		$1 = { BA ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 00 FF FF FF FF 04 00 00 00 52 45 49 4E 00 00 00 00 }
	condition:
		$1
}

rule function_1429_0 {
	meta:
		name = "TCalendar.NextYear"
		size = 111
		refs = "000b TCalendar.GetDateElement 004e TCalendar.SetDateElement"
	strings:
		$1 = { 53 8B D8 BA 01 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C3 8B 08 FF 91 E0 00 00 00 84 C0 74 33 BA 02 00 00 00 8B C3 E8 ?? ?? ?? ?? 83 F8 02 75 22 BA 03 00 00 00 8B C3 E8 ?? ?? ?? ?? 83 F8 1D 75 11 B9 1C 00 00 00 BA 03 00 00 00 8B C3 E8 ?? ?? ?? ?? BA 01 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B C8 41 BA 01 00 00 00 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1430_0 {
	meta:
		name = "TCalendar.PrevYear"
		size = 111
		refs = "000b TCalendar.GetDateElement 004e TCalendar.SetDateElement"
	strings:
		$1 = { 53 8B D8 BA 01 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C3 8B 08 FF 91 E0 00 00 00 84 C0 74 33 BA 02 00 00 00 8B C3 E8 ?? ?? ?? ?? 83 F8 02 75 22 BA 03 00 00 00 8B C3 E8 ?? ?? ?? ?? 83 F8 1D 75 11 B9 1C 00 00 00 BA 03 00 00 00 8B C3 E8 ?? ?? ?? ?? BA 01 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B C8 49 BA 01 00 00 00 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1431_0 {
	meta:
		name = "TCalendar.UpdateCalendar"
		size = 246
		refs = "0018 TCalendar.UpdateCalendar 003b DecodeDate 004c EncodeDate 005b DayOfWeek 00c6 TCustomGrid.MoveColRow 00eb @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 89 45 FC 8B 45 FC C6 80 8A 02 00 00 01 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC FF B0 78 02 00 00 FF B0 74 02 00 00 8D 4D F6 8D 55 F8 8D 45 FA E8 ?? ?? ?? ?? 66 B9 01 00 66 8B 55 F8 66 8B 45 FA E8 ?? ?? ?? ?? DD 5D EC 9B FF 75 F0 FF 75 EC E8 ?? ?? ?? ?? 8B 55 FC 0F B6 92 89 02 00 00 2B C2 83 C0 07 B9 07 00 00 00 99 F7 F9 BB 02 00 00 00 2B DA 8B 45 FC 89 98 7C 02 00 00 83 FB 02 75 0D 8B 45 FC C7 80 7C 02 00 00 FB FF FF FF 6A 00 6A 00 0F B7 4D F6 8B 45 FC 2B 88 7C 02 00 00 8B C1 BB 07 00 00 00 99 F7 FB 52 8B C1 B9 07 00 00 00 99 F7 F9 40 8B C8 8B 45 FC 5A E8 ?? ?? ?? ?? 8B 45 FC 8B 10 FF 52 78 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC C6 80 8A 02 00 00 00 C3 E9 ?? ?? ?? ?? EB EE 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1432_0 {
	meta:
		name = "TCalendar.WMSize"
		size = 68
		refs = "0025 TCustomGrid.SetDefaultColWidth 003c TCustomGrid.SetDefaultRowHeight"
	strings:
		$1 = { 53 56 57 8B FA 8B D8 8B B3 24 02 00 00 03 F6 8D 34 76 0F B7 47 08 2B C6 B9 07 00 00 00 99 F7 F9 8B D0 8B C3 E8 ?? ?? ?? ?? 0F B7 47 0A 2B C6 B9 07 00 00 00 99 F7 F9 8B D0 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1435_0 {
	meta:
		name = "_NF__9D"
		size = 660
	strings:
		$1 = { FF FF FF FF 0E 00 00 00 52 45 51 55 45 53 54 5F 4D 45 54 48 4F 44 00 00 FF FF FF FF 0F 00 00 00 53 45 52 56 45 52 5F 50 52 4F 54 4F 43 4F 4C 00 FF FF FF FF 03 00 00 00 55 52 4C 00 FF FF FF FF 0C 00 00 00 51 55 45 52 59 5F 53 54 52 49 4E 47 00 00 00 00 FF FF FF FF 09 00 00 00 50 41 54 48 5F 49 4E 46 4F 00 00 00 FF FF FF FF 0F 00 00 00 50 41 54 48 5F 54 52 41 4E 53 4C 41 54 45 44 00 FF FF FF FF 12 00 00 00 48 54 54 50 5F 43 41 43 48 45 5F 43 4F 4E 54 52 4F 4C 00 00 FF FF FF FF 09 00 00 00 48 54 54 50 5F 44 41 54 45 00 00 00 FF FF FF FF 0B 00 00 00 48 54 54 50 5F 41 43 43 45 50 54 00 FF FF FF FF 09 00 00 00 48 54 54 50 5F 46 52 4F 4D 00 00 00 FF FF FF FF 09 00 00 00 48 54 54 50 5F 48 4F 53 54 00 00 00 FF FF FF FF 16 00 00 00 48 54 54 50 5F 49 46 5F 4D 4F 44 49 46 49 45 44 5F 53 49 4E 43 45 00 00 FF FF FF FF 0C 00 00 00 48 54 54 50 5F 52 45 46 45 52 45 52 00 00 00 00 FF FF FF FF 0F 00 00 00 48 54 54 50 5F 55 53 45 52 5F 41 47 45 4E 54 00 FF FF FF FF 15 00 00 00 48 54 54 50 5F 43 4F 4E 54 45 4E 54 5F 45 4E 43 4F 44 49 4E 47 00 00 00 FF FF FF FF 11 00 00 00 48 54 54 50 5F 43 4F 4E 54 45 4E 54 5F 54 59 50 45 00 00 00 FF FF FF FF 13 00 00 00 48 54 54 50 5F 43 4F 4E 54 45 4E 54 5F 4C 45 4E 47 54 48 00 FF FF FF FF 14 00 00 00 48 54 54 50 5F 43 4F 4E 54 45 4E 54 5F 56 45 52 53 49 4F 4E 00 00 00 00 FF FF FF FF 11 00 00 00 48 54 54 50 5F 44 45 52 49 56 45 44 5F 46 52 4F 4D 00 00 00 FF FF FF FF 0C 00 00 00 48 54 54 50 5F 45 58 50 49 52 45 53 00 00 00 00 FF FF FF FF 0A 00 00 00 48 54 54 50 5F 54 49 54 4C 45 00 00 FF FF FF FF 0B 00 00 00 52 45 4D 4F 54 45 5F 41 44 44 52 00 FF FF FF FF 0B 00 00 00 52 45 4D 4F 54 45 5F 48 4F 53 54 00 FF FF FF FF 0B 00 00 00 53 43 52 49 50 54 5F 4E 41 4D 45 00 FF FF FF FF 0B 00 00 00 53 45 52 56 45 52 5F 50 4F 52 54 00 FF FF FF FF 0F 00 00 00 48 54 54 50 5F 43 4F 4E 4E 45 43 54 49 4F 4E 00 FF FF FF FF 0B 00 00 00 48 54 54 50 5F 43 4F 4F 4B 49 45 00 FF FF FF FF 12 00 00 00 48 54 54 50 5F 41 55 54 48 4F 52 49 5A 41 54 49 4F 4E 00 00 }
	condition:
		$1
}

rule function_1436_0 {
	meta:
		name = "TCGIRequest.Create"
		size = 140
		refs = "0010 @ClassCreate 001c TCGIRequest.Create 002b TWebRequest.Create 004e @LStrAsg 0063 @LStrClr 0069 @HandleFinally 0076 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B C6 E8 ?? ?? ?? ?? BA 10 00 00 00 8B C6 8B 08 FF 51 08 8B D0 8D 4D FC 8B C6 8B 38 FF 57 10 8B 55 FC 8D 46 14 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1437_0 {
	meta:
		name = "StripHTTP"
		size = 72
		refs = "0009 StripHTTP 000e @LStrPos 0023 @LStrCopy 002f @LStrLAsg"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D3 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 75 15 56 B9 FF FF FF 7F BA 06 00 00 00 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 8B C6 8B D3 E8 ?? ?? ?? ?? 5E 5B C3 00 00 FF FF FF FF 05 00 00 00 48 54 54 50 5F 00 00 00 }
	condition:
		$1
}

rule function_1438_0 {
	meta:
		name = "TCGIRequest.GetFieldByName"
		size = 181
		refs = "001f TCGIRequest.GetFieldByName 0038 @LStrToPChar 003e GetEnvironmentVariable 004d @LStrFromPCharLen 006b StripHTTP 00a3 @LStrClr 00a9 @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 04 F0 FF FF 50 83 C4 FC 53 56 33 DB 89 9D FC EF FF FF 8B D9 8B F2 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 68 00 10 00 00 8D 85 00 F0 FF FF 50 8B C6 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B C8 8D 95 00 F0 FF FF 8B C3 E8 ?? ?? ?? ?? 83 3B 00 75 39 68 00 10 00 00 8D 85 00 F0 FF FF 50 8D 95 FC EF FF FF 8B C6 E8 ?? ?? ?? ?? 8B 85 FC EF FF FF E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B C8 8D 95 00 F0 FF FF 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 FC EF FF FF E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1439_0 {
	meta:
		name = "TCGIRequest.GetStringVariable"
		size = 46
		refs = "0014 @LStrLAsg 001f CGIServerVariables"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 83 FE 19 75 0C 8B C7 8B 53 14 E8 ?? ?? ?? ?? EB 10 8B CF 8B 14 B5 ?? ?? ?? ?? 8B C3 8B 18 FF 53 20 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1440_0 {
	meta:
		name = "TCGIRequest.GetDateVariable"
		size = 112
		refs = "0015 TCGIRequest.GetDateVariable 0034 ParseDate 005b @LStrClr 0061 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 33 C9 89 4D F4 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 4D F4 8B D6 8B C3 8B 18 FF 13 83 7D F4 00 74 0E 8B 45 F4 E8 ?? ?? ?? ?? DD 5D F8 9B EB 0C 33 C0 89 45 F8 C7 45 FC 00 00 F0 BF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 DD 45 F8 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_11424_0 {
	meta:
		name = "TISAPIRequest.GetDateVariable"
		size = 112
		refs = "0015 TISAPIRequest.GetDateVariable 0034 ParseDate 005b @LStrClr 0061 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 33 C9 89 4D F4 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 4D F4 8B D6 8B C3 8B 18 FF 13 83 7D F4 00 74 0E 8B 45 F4 E8 ?? ?? ?? ?? DD 5D F8 9B EB 0C 33 C0 89 45 F8 C7 45 FC 00 00 F0 BF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 DD 45 F8 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1441_0 {
	meta:
		name = "TCGIRequest.GetIntegerVariable"
		size = 85
		refs = "000f TCGIRequest.GetIntegerVariable 002b StrToIntDef 0042 @LStrClr 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 4D FC 8B D6 8B C3 8B 18 FF 13 83 CA FF 8B 45 FC E8 ?? ?? ?? ?? 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1442_0 {
	meta:
		name = "TCGIRequest.ReadClient"
		size = 13
		refs = "0001 Input 0008 FileRead"
	strings:
		$1 = { A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1445_0 {
	meta:
		name = "TCGIRequest.WriteClient"
		size = 13
		refs = "0001 Output 0008 FileWrite"
	strings:
		$1 = { A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1443_0 {
	meta:
		name = "TCGIRequest.ReadString"
		size = 47
		refs = "000b @LStrSetLength 0016 Input 001f FileRead"
	strings:
		$1 = { 53 56 8B F1 8B DA 8B C6 8B D3 E8 ?? ?? ?? ?? 85 DB 7E 19 8B 16 A1 ?? ?? ?? ?? 8B 00 8B CB E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1446_0 {
	meta:
		name = "TCGIRequest.WriteString"
		size = 53
		refs = "000b @LStrLen 0014 Output 001b FileWrite"
	strings:
		$1 = { 53 56 8B DA 85 DB 74 28 8B C3 E8 ?? ?? ?? ?? 8B C8 8B D3 A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? 8B F0 8B C3 E8 ?? ?? ?? ?? 3B F0 0F 94 C0 5E 5B C3 33 C0 5E 5B C3 }
	condition:
		$1
}

rule function_1447_0 {
	meta:
		name = "TCGIResponse.Create"
		size = 264
		refs = "0015 @ClassCreate 0022 TCGIResponse.Create 0031 TWebResponse.Create 00bc @LStrClr 00c2 @HandleFinally 00d1 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 DB 89 5D F8 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B C3 E8 ?? ?? ?? ?? 8D 4D F8 BA 01 00 00 00 8B 43 10 8B 30 FF 16 83 7D F8 00 75 0E B9 ?? ?? ?? ?? 33 D2 8B C3 8B 30 FF 56 04 BA C8 00 00 00 8B C3 8B 08 FF 51 28 68 00 00 F0 BF 6A 00 BA 02 00 00 00 8B C3 8B 08 FF 51 0C 68 00 00 F0 BF 6A 00 BA 01 00 00 00 8B C3 8B 08 FF 51 0C 68 00 00 F0 BF 6A 00 33 D2 8B C3 8B 08 FF 51 0C B9 ?? ?? ?? ?? BA 08 00 00 00 8B C3 8B 30 FF 56 04 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 80 7D FF 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5E 5B 59 59 5D C3 00 FF FF FF FF 03 00 00 00 31 2E 30 00 FF FF FF FF 09 00 00 00 74 65 78 74 2F 68 74 6D 6C 00 00 00 }
	condition:
		$1
}

rule function_11431_0 {
	meta:
		name = "TISAPIResponse.Create"
		size = 264
		refs = "0015 @ClassCreate 0022 TISAPIResponse.Create 0031 TWebResponse.Create 00bc @LStrClr 00c2 @HandleFinally 00d1 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 DB 89 5D F8 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B C3 E8 ?? ?? ?? ?? 8D 4D F8 BA 01 00 00 00 8B 43 10 8B 30 FF 16 83 7D F8 00 75 0E B9 ?? ?? ?? ?? 33 D2 8B C3 8B 30 FF 56 04 BA C8 00 00 00 8B C3 8B 08 FF 51 28 68 00 00 F0 BF 6A 00 BA 02 00 00 00 8B C3 8B 08 FF 51 0C 68 00 00 F0 BF 6A 00 BA 01 00 00 00 8B C3 8B 08 FF 51 0C 68 00 00 F0 BF 6A 00 33 D2 8B C3 8B 08 FF 51 0C B9 ?? ?? ?? ?? BA 08 00 00 00 8B C3 8B 30 FF 56 04 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 80 7D FF 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5E 5B 59 59 5D C3 00 FF FF FF FF 03 00 00 00 31 2E 30 00 FF FF FF FF 09 00 00 00 74 65 78 74 2F 68 74 6D 6C 00 00 00 }
	condition:
		$1
}

rule function_1448_0 {
	meta:
		name = "TCGIResponse.GetContent"
		size = 19
		refs = "000c @LStrLAsg"
		altNames = "TISAPIResponse.GetContent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 53 64 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1449_0 {
	meta:
		name = "TCGIResponse.GetDateVariable"
		size = 48
	strings:
		$1 = { 83 C4 F8 85 D2 7C 16 83 FA 03 7D 11 8B 4C D0 4C 89 0C 24 8B 4C D0 50 89 4C 24 04 EB 0D 33 C0 89 04 24 C7 44 24 04 00 00 F0 BF DD 04 24 59 5A C3 }
	condition:
		$1
}

rule function_1450_0 {
	meta:
		name = "TCGIResponse.GetIntegerVariable"
		size = 18
	strings:
		$1 = { 85 D2 7C 0A 83 FA 02 7D 05 8B 44 90 48 C3 83 C8 FF C3 }
	condition:
		$1
}

rule function_1452_0 {
	meta:
		name = "TCGIResponse.GetStatusCode"
		size = 4
		altNames = "TISAPIResponse.GetStatusCode TStringList.GetCapacity"
	strings:
		$1 = { 8B 40 14 C3 }
	condition:
		$1
}

rule function_1453_0 {
	meta:
		name = "TCGIResponse.GetStringVariable"
		size = 33
		refs = "0019 @LStrLAsg"
	strings:
		$1 = { 53 56 57 8B F9 8B DA 8B F0 85 DB 7C 10 83 FB 0C 7D 0B 8B C7 8B 54 9E 18 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1454_0 {
	meta:
		name = "TCGIResponse.Sent"
		size = 4
		altNames = "TISAPIResponse.Sent"
	strings:
		$1 = { 8A 40 68 C3 }
	condition:
		$1
}

rule function_1455_0 {
	meta:
		name = "TCGIResponse.SetContent"
		size = 38
		refs = "000c @LStrAsg 0014 @LStrLen"
		altNames = "TISAPIResponse.SetContent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8D 43 64 8B D6 E8 ?? ?? ?? ?? 8B 43 64 E8 ?? ?? ?? ?? 8B C8 33 D2 8B C3 8B 18 FF 53 14 5E 5B C3 }
	condition:
		$1
}

rule function_1456_0 {
	meta:
		name = "TCGIResponse.SetDateVariable"
		size = 44
		altNames = "TISAPIResponse.SetDateVariable"
	strings:
		$1 = { 55 8B EC 8B C8 85 D2 7C 1F 83 FA 02 7F 1A DD 45 08 DC 5C D1 4C DF E0 9E 74 0E 8B 45 08 89 44 D1 4C 8B 45 0C 89 44 D1 50 5D C2 08 00 }
	condition:
		$1
}

rule function_1457_0 {
	meta:
		name = "TCGIResponse.SetIntegerVariable"
		size = 34
	strings:
		$1 = { 53 51 8B D8 85 D2 7C 17 85 D2 7F 13 89 0C 24 DB 04 24 DC 5C D3 4C DF E0 9E 74 04 89 4C 93 48 5A 5B C3 }
	condition:
		$1
}

rule function_1459_0 {
	meta:
		name = "TCGIResponse.SetStatusCode"
		size = 92
		refs = "000f TCGIResponse.SetStatusCode 0027 StatusString 004b @LStrClr 0051 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 3B 73 14 74 1C 89 73 14 8D 55 FC 8B C6 E8 ?? ?? ?? ?? 8B 4D FC BA 01 00 00 00 8B C3 8B 18 FF 53 04 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_11443_0 {
	meta:
		name = "TISAPIResponse.SetStatusCode"
		size = 92
		refs = "000f TISAPIResponse.SetStatusCode 0027 StatusString 004b @LStrClr 0051 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 3B 73 14 74 1C 89 73 14 8D 55 FC 8B C6 E8 ?? ?? ?? ?? 8B 4D FC BA 01 00 00 00 8B C3 8B 18 FF 53 04 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1460_0 {
	meta:
		name = "TCGIResponse.SetStringVariable"
		size = 33
		refs = "0019 @LStrAsg"
		altNames = "TISAPIResponse.SetStringVariable"
	strings:
		$1 = { 53 56 57 8B F9 8B DA 8B F0 85 DB 7C 10 83 FB 0B 7F 0B 8D 44 9E 18 8B D7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1461_0 {
	meta:
		name = "AddHeaderItem"
		size = 110
		refs = "0015 AddHeaderItem 0036 Format 0044 @LStrCat 005c @LStrClr 0062 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 33 C9 89 4D FC 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 DB 74 28 8D 45 FC 50 89 5D F4 C6 45 F8 0B 8D 55 F4 33 C9 8B C6 E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 83 C0 FC E8 ?? ?? ?? ?? 8B 45 08 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1462_0 {
	meta:
		name = "TCGIResponse.SendResponse"
		size = 1456
		refs = "0018 TCGIResponse.SendResponse 0092 Format 00a1 @LStrLAsg 00af AddHeaderItem 00f2 TCollection.GetCount 0107 TCookieCollection.GetCookie 010f TCookie.GetHeaderValue 0178 DayOfWeekStr 019d MonthStr 01cb FormatDateTime 02b8 TWebResponse.AddCustomHeaders 0337 IntToStr 0352 @LStrCat 03af @LStrArrayClr 03c2 @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 05 00 00 00 6A 00 6A 00 49 75 F9 53 56 57 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 4D F4 BA 01 00 00 00 8B 43 10 8B 30 FF 16 83 7D F4 00 0F 84 26 03 00 00 8D 4D F4 BA 01 00 00 00 8B C3 8B 30 FF 16 83 7D F4 00 74 49 8B C3 8B 10 FF 52 24 85 C0 7E 3E 8D 45 F8 50 8B C3 8B 10 FF 52 24 89 45 E4 C6 45 E8 00 8D 4D F4 BA 01 00 00 00 8B C3 8B 30 FF 16 8B 45 F4 89 45 EC C6 45 F0 0B 8D 55 E4 B9 01 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 0D 8D 45 F8 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 55 BA ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 59 55 8D 4D F4 BA 06 00 00 00 8B C3 8B 30 FF 16 8B 45 F4 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 55 8D 4D F4 BA 05 00 00 00 8B C3 8B 30 FF 16 8B 45 F4 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 43 0C E8 ?? ?? ?? ?? 8B F0 4E 85 F6 7C 28 46 33 FF 55 8B D7 8B 43 0C E8 ?? ?? ?? ?? 8D 55 F4 E8 ?? ?? ?? ?? 8B 45 F4 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 47 4E 75 DB 55 8D 4D F4 BA 0A 00 00 00 8B C3 8B 30 FF 16 8B 45 F4 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 BA 01 00 00 00 8B C3 8B 08 FF 51 08 D8 1D ?? ?? ?? ?? DF E0 9E 0F 86 80 00 00 00 8D 45 F4 50 BA 01 00 00 00 8B C3 8B 08 FF 51 08 83 C4 F8 DD 1C 24 9B 8D 45 E0 E8 ?? ?? ?? ?? 8B 45 E0 89 45 E4 C6 45 E8 0B BA 01 00 00 00 8B C3 8B 08 FF 51 08 83 C4 F8 DD 1C 24 9B 8D 45 DC E8 ?? ?? ?? ?? 8B 45 DC 89 45 EC C6 45 F0 0B 8D 45 E4 50 BA 01 00 00 00 8B C3 8B 08 FF 51 08 83 C4 F8 DD 1C 24 9B 8D 55 D8 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 D8 B9 01 00 00 00 5A E8 ?? ?? ?? ?? BA 02 00 00 00 8B C3 8B 08 FF 51 08 D8 1D ?? ?? ?? ?? DF E0 9E 0F 86 80 00 00 00 8D 45 F4 50 BA 02 00 00 00 8B C3 8B 08 FF 51 08 83 C4 F8 DD 1C 24 9B 8D 45 E0 E8 ?? ?? ?? ?? 8B 45 E0 89 45 E4 C6 45 E8 0B BA 02 00 00 00 8B C3 8B 08 FF 51 08 83 C4 F8 DD 1C 24 9B 8D 45 DC E8 ?? ?? ?? ?? 8B 45 DC 89 45 EC C6 45 F0 0B 8D 45 E4 50 BA 02 00 00 00 8B C3 8B 08 FF 51 08 83 C4 F8 DD 1C 24 9B 8D 55 D8 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 D8 B9 01 00 00 00 5A E8 ?? ?? ?? ?? 55 8D 4D F4 BA 0B 00 00 00 8B C3 8B 30 FF 16 8B 45 F4 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 55 8D 4D F4 BA 03 00 00 00 8B C3 8B 30 FF 16 8B 45 F4 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 55 8D 4D F4 BA 09 00 00 00 8B C3 8B 30 FF 16 8B 45 F4 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 55 8D 4D F4 BA 07 00 00 00 8B C3 8B 30 FF 16 8B 45 F4 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 55 8D 4D F4 BA 08 00 00 00 8B C3 8B 30 FF 16 8B 45 F4 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8D 55 F4 8B C3 8B 08 FF 51 18 83 7D F4 00 75 06 83 7B 04 00 74 20 55 33 D2 8B C3 8B 08 FF 51 10 8D 55 F4 E8 ?? ?? ?? ?? 8B 45 F4 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8D 45 FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B 43 10 8B 08 FF 51 1C 8B 43 04 85 C0 75 17 8D 55 F4 8B C3 8B 08 FF 51 18 8B 55 F4 8B 43 10 8B 08 FF 51 1C EB 16 85 C0 74 12 8B D0 8B C3 8B 08 FF 51 3C 33 D2 8B C3 8B 08 FF 51 20 C6 43 68 01 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 D8 BA 03 00 00 00 E8 ?? ?? ?? ?? 8D 45 F4 BA 03 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DE 5F 5E 5B 8B E5 5D C3 00 FF FF FF FF 05 00 00 00 25 64 20 25 73 00 00 00 FF FF FF FF 06 00 00 00 32 30 30 20 4F 4B 00 00 FF FF FF FF 0C 00 00 00 53 74 61 74 75 73 3A 20 25 73 0D 0A 00 00 00 00 FF FF FF FF 0E 00 00 00 4C 6F 63 61 74 69 6F 6E 3A 20 25 73 0D 0A 00 00 FF FF FF FF 0B 00 00 00 41 6C 6C 6F 77 3A 20 25 73 0D 0A 00 FF FF FF FF 10 00 00 00 53 65 74 2D 43 6F 6F 6B 69 65 3A 20 25 73 0D 0A 00 00 00 00 FF FF FF FF 12 00 00 00 44 65 72 69 76 65 64 2D 46 72 6F 6D 3A 20 25 73 0D 0A 00 00 00 00 00 00 FF FF FF FF 2E 00 00 00 22 45 78 70 69 72 65 73 3A 20 22 22 25 73 22 2C 20 64 64 20 22 25 73 22 20 79 79 79 79 20 68 68 3A 6D 6D 3A 73 73 20 22 47 4D 54 22 0D 0A 00 00 FF FF FF FF 34 00 00 00 22 4C 61 73 74 2D 4D 6F 64 69 66 69 65 64 3A 20 22 22 25 73 22 2C 20 64 64 20 22 25 73 22 20 79 79 79 79 20 68 68 3A 6D 6D 3A 73 73 20 22 47 4D 54 22 0D 0A 00 00 00 00 FF FF FF FF 0B 00 00 00 54 69 74 6C 65 3A 20 25 73 0D 0A 00 FF FF FF FF 16 00 00 00 57 57 57 2D 41 75 74 68 65 6E 74 69 63 61 74 65 3A 20 25 73 0D 0A 00 00 FF FF FF FF 15 00 00 00 43 6F 6E 74 65 6E 74 2D 56 65 72 73 69 6F 6E 3A 20 25 73 0D 0A 00 00 00 FF FF FF FF 16 00 00 00 43 6F 6E 74 65 6E 74 2D 45 6E 63 6F 64 69 6E 67 3A 20 25 73 0D 0A 00 00 FF FF FF FF 12 00 00 00 43 6F 6E 74 65 6E 74 2D 54 79 70 65 3A 20 25 73 0D 0A 00 00 FF FF FF FF 14 00 00 00 43 6F 6E 74 65 6E 74 2D 4C 65 6E 67 74 68 3A 20 25 73 0D 0A 00 00 00 00 FF FF FF FF 0C 00 00 00 43 6F 6E 74 65 6E 74 3A 0D 0A 0D 0A 00 00 00 00 }
	condition:
		$1
}

rule function_1463_0 {
	meta:
		name = "TCGIResponse.SendRedirect"
		size = 196
		refs = "0019 TCGIResponse.SendRedirect 0056 sDocumentMoved 005b LoadResString 0071 Format 009c @LStrArrayClr 00a2 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 33 C9 89 4D FC 89 4D F8 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B CE BA 06 00 00 00 8B C3 8B 38 FF 57 04 BA 2E 01 00 00 8B C3 8B 08 FF 51 28 B9 ?? ?? ?? ?? BA 08 00 00 00 8B C3 8B 38 FF 57 04 8D 45 FC 50 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F8 50 89 75 F0 C6 45 F4 0B 8D 55 F0 33 C9 58 E8 ?? ?? ?? ?? 8B 55 FC 8B C3 8B 08 FF 51 1C 8B C3 8B 10 FF 52 34 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 8B E5 5D C3 00 FF FF FF FF 09 00 00 00 74 65 78 74 2F 68 74 6D 6C 00 00 00 }
	condition:
		$1
}

rule function_1464_0 {
	meta:
		name = "TCGIResponse.SendStream"
		size = 90
		refs = "003f TStream.GetPosition 0048 TStream.GetSize"
		altNames = "TISAPIResponse.SendStream"
	strings:
		$1 = { 53 56 57 50 B8 02 00 00 00 81 C4 04 F0 FF FF 50 48 75 F6 8B 84 24 00 20 00 00 83 C4 04 8B DA 8B F0 EB 19 8B D4 B9 00 20 00 00 8B C3 8B 38 FF 57 04 8B D4 8B 4E 10 91 8B 38 FF 57 18 8B C3 E8 ?? ?? ?? ?? 8B F8 8B C3 E8 ?? ?? ?? ?? 3B F8 7C D3 81 C4 00 20 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1465_0 {
	meta:
		name = "_NF__110"
		size = 592
	strings:
		$1 = { FF FF FF FF 0E 00 00 00 52 65 71 75 65 73 74 20 4D 65 74 68 6F 64 00 00 FF FF FF FF 10 00 00 00 52 65 71 75 65 73 74 20 50 72 6F 74 6F 63 6F 6C 00 00 00 00 FF FF FF FF 03 00 00 00 55 72 6C 00 FF FF FF FF 0C 00 00 00 51 75 65 72 79 20 53 74 72 69 6E 67 00 00 00 00 FF FF FF FF 0C 00 00 00 4C 6F 67 69 63 61 6C 20 50 61 74 68 00 00 00 00 FF FF FF FF 0D 00 00 00 50 68 79 73 69 63 61 6C 20 50 61 74 68 00 00 00 FF FF FF FF 0D 00 00 00 43 61 63 68 65 20 43 6F 6E 74 72 6F 6C 00 00 00 FF FF FF FF 04 00 00 00 44 61 74 65 00 00 00 00 FF FF FF FF 06 00 00 00 41 63 63 65 70 74 00 00 FF FF FF FF 04 00 00 00 46 72 6F 6D 00 00 00 00 FF FF FF FF 04 00 00 00 48 6F 73 74 00 00 00 00 FF FF FF FF 11 00 00 00 49 66 2D 4D 6F 64 69 66 69 65 64 2D 53 69 6E 63 65 00 00 00 FF FF FF FF 07 00 00 00 52 65 66 65 72 65 72 00 FF FF FF FF 0A 00 00 00 55 73 65 72 2D 41 67 65 6E 74 00 00 FF FF FF FF 10 00 00 00 43 6F 6E 74 65 6E 74 2D 45 6E 63 6F 64 69 6E 67 00 00 00 00 FF FF FF FF 0C 00 00 00 43 6F 6E 74 65 6E 74 20 54 79 70 65 00 00 00 00 FF FF FF FF 0E 00 00 00 43 6F 6E 74 65 6E 74 20 4C 65 6E 67 74 68 00 00 FF FF FF FF 0F 00 00 00 43 6F 6E 74 65 6E 74 20 56 65 72 73 69 6F 6E 00 FF FF FF FF 0C 00 00 00 44 65 72 69 76 65 64 2D 46 72 6F 6D 00 00 00 00 FF FF FF FF 07 00 00 00 45 78 70 69 72 65 73 00 FF FF FF FF 05 00 00 00 54 69 74 6C 65 00 00 00 FF FF FF FF 0E 00 00 00 52 65 6D 6F 74 65 20 41 64 64 72 65 73 73 00 00 FF FF FF FF 0B 00 00 00 52 65 6D 6F 74 65 20 48 6F 73 74 00 FF FF FF FF 0F 00 00 00 45 78 65 63 75 74 61 62 6C 65 20 50 61 74 68 00 FF FF FF FF 0B 00 00 00 53 65 72 76 65 72 20 50 6F 72 74 00 FF FF FF FF 0A 00 00 00 43 6F 6E 6E 65 63 74 69 6F 6E 00 00 FF FF FF FF 06 00 00 00 43 6F 6F 6B 69 65 00 00 FF FF FF FF 0D 00 00 00 41 75 74 68 6F 72 69 7A 61 74 69 6F 6E 00 00 00 }
	condition:
		$1
}

rule function_1466_0 {
	meta:
		name = "TWinCGIRequest.Create"
		size = 376
		refs = "0010 @ClassCreate 0020 @LStrAddRef 0038 TWinCGIRequest.Create 0048 _Dn_TIniFile 004d TCustomIniFile.Create 0093 FileExists 00a3 _Dn_TFileStream 00a8 TFileStream.Create 00ed TCGIRequest.Create 0102 @LStrClr 010f @LStrArrayClr 0115 @HandleFinally 0124 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D F8 88 55 FF 8B D8 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 0C E8 ?? ?? ?? ?? 8B 45 08 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 4D F8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 73 18 83 7D 0C 00 75 16 6A 00 8D 45 0C 50 B9 ?? ?? ?? ?? BA ?? ?? ?? ?? 8B C6 8B 30 FF 16 83 7D 08 00 75 17 6A 00 8D 45 08 50 B9 ?? ?? ?? ?? BA ?? ?? ?? ?? 8B 43 18 8B 30 FF 16 8B 45 0C E8 ?? ?? ?? ?? 84 C0 74 14 6A 40 8B 4D 0C B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 43 1C 8B 45 08 E8 ?? ?? ?? ?? 84 C0 74 16 6A 41 8B 4D 08 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 43 20 EB 17 68 FF FF 00 00 8B 4D 08 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 43 20 33 D2 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 08 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E3 8B C3 80 7D FF 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5E 5B 59 59 5D C2 08 00 FF FF FF FF 0C 00 00 00 43 6F 6E 74 65 6E 74 20 46 69 6C 65 00 00 00 00 FF FF FF FF 06 00 00 00 53 79 73 74 65 6D 00 00 FF FF FF FF 0B 00 00 00 4F 75 74 70 75 74 20 46 69 6C 65 00 }
	condition:
		$1
}

rule function_1467_0 {
	meta:
		name = "TWinCGIRequest.Destroy"
		size = 65
		refs = "0003 @BeforeDestruction 000f TObject.Free 002f TWebRequest.Destroy 003a @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 18 E8 ?? ?? ?? ?? 8B 46 1C 85 C0 74 05 E8 ?? ?? ?? ?? 8B 46 20 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1468_0 {
	meta:
		name = "TWinCGIRequest.GetFieldByName"
		size = 56
		refs = "000f TWinCGIRequest.GetFieldByName"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 6A 00 57 8B CE BA ?? ?? ?? ?? 8B 43 18 8B 18 FF 13 5F 5E 5B C3 00 00 FF FF FF FF 0D 00 00 00 45 78 74 72 61 20 48 65 61 64 65 72 73 00 00 00 }
	condition:
		$1
}

rule function_1469_0 {
	meta:
		name = "AcceptSection"
		size = 268
		refs = "0014 AcceptSection 0021 _Dn_TStringList 0026 TObject.Create 0054 @LStrClr 008f @LStrCatN 00a1 @LStrLen 00ab @LStrSetLength 00c0 TObject.Free 00c6 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 33 D2 89 55 F4 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 FC 8B 40 18 8B 4D FC BA ?? ?? ?? ?? 8B 30 FF 56 38 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 8B 10 FF 52 14 8B F0 4E 85 F6 7C 32 46 C7 45 F8 00 00 00 00 FF 33 8D 4D F4 8B 55 F8 8B 45 FC 8B 38 FF 57 0C FF 75 F4 68 ?? ?? ?? ?? 8B C3 BA 03 00 00 00 E8 ?? ?? ?? ?? FF 45 F8 4E 75 D6 83 3B 00 74 11 8B 03 E8 ?? ?? ?? ?? 8B D0 4A 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 FF FF FF FF 06 00 00 00 41 63 63 65 70 74 00 00 FF FF FF FF 01 00 00 00 2C 00 00 00 }
	condition:
		$1
}

rule function_1470_0 {
	meta:
		name = "TWinCGIRequest.GetStringVariable"
		size = 304
		refs = "0018 TWinCGIRequest.GetStringVariable 0071 WinCGIServerVariables 008f @LStrLAsg 00b5 AcceptSection 00e5 @LStrClr 0100 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 DB 89 5D F8 8B F1 8B DA 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 83 F8 1C 0F 87 99 00 00 00 8A 80 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 01 01 00 01 01 01 00 00 04 00 00 00 00 00 00 01 01 00 00 00 00 01 01 01 01 02 01 03 01 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 6A 00 56 8B 0C 9D ?? ?? ?? ?? 8B 45 FC 8B 40 18 BA ?? ?? ?? ?? 8B 18 FF 13 EB 63 8B C6 8B 55 FC 8B 52 14 E8 ?? ?? ?? ?? EB 54 6A 00 56 8B 0C 9D ?? ?? ?? ?? 8B 45 FC 8B 40 18 BA ?? ?? ?? ?? 8B 18 FF 13 EB 39 55 8D 45 F8 E8 ?? ?? ?? ?? 59 8B 55 F8 8B C6 E8 ?? ?? ?? ?? EB 23 85 DB 7C 18 83 FB 1C 7F 13 8B CE 8B 14 9D ?? ?? ?? ?? 8B 45 FC 8B 18 FF 53 20 EB 07 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 59 5D C3 FF FF FF FF 03 00 00 00 43 47 49 00 FF FF FF FF 0D 00 00 00 45 78 74 72 61 20 48 65 61 64 65 72 73 00 00 00 }
	condition:
		$1
}

rule function_1471_0 {
	meta:
		name = "TWinCGIRequest.ReadClient"
		size = 24
	strings:
		$1 = { 53 56 8B 70 1C 85 F6 74 0A 8B C6 8B 18 FF 53 04 5E 5B C3 33 C0 5E 5B C3 }
	condition:
		$1
}

rule function_1472_0 {
	meta:
		name = "TWinCGIRequest.ReadString"
		size = 62
		refs = "0018 @LStrSetLength 0036 @LStrClr"
	strings:
		$1 = { 53 56 57 8B F1 8B FA 8B D8 85 FF 7E 26 83 7B 1C 00 74 20 8B C6 8B D7 E8 ?? ?? ?? ?? 8B 16 8B CF 8B 43 1C 8B 18 FF 53 04 8B D0 8B C6 E8 ?? ?? ?? ?? EB 07 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1474_0 {
	meta:
		name = "TWinCGIRequest.WriteClient"
		size = 11
	strings:
		$1 = { 53 8B 40 20 8B 18 FF 53 08 5B C3 }
	condition:
		$1
}

rule function_1475_0 {
	meta:
		name = "TWinCGIRequest.WriteString"
		size = 51
		refs = "000d @LStrLen"
	strings:
		$1 = { 53 56 8B DA 8B F0 85 DB 74 24 8B C3 E8 ?? ?? ?? ?? 8B C8 8B D3 8B 46 20 8B 30 FF 56 08 8B F0 8B C3 E8 ?? ?? ?? ?? 3B F0 0F 94 C0 5E 5B C3 33 C0 5E 5B C3 }
	condition:
		$1
}

rule function_1476_0 {
	meta:
		name = "HandleServerException"
		size = 508
		refs = "0021 HandleServerException 0038 TObject.ClassName 005e sInternalServerError 0063 LoadResString 0074 Format 008a @LStrLen 00a8 IsConsole 00bf Output 00c6 FileWrite 00eb FileExists 00fa _Dn_TFileStream 00ff TFileStream.Create 0167 TObject.Free 016d @HandleFinally 0187 @LStrClr 0194 @LStrArrayClr"
	strings:
		$1 = { 55 8B EC 81 C4 E0 FE FF FF 53 56 33 C9 89 8D E0 FE FF FF 89 4D FC 89 4D F8 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 95 E4 FE FF FF 8B 03 E8 ?? ?? ?? ?? 8D 85 E4 FE FF FF 89 45 E4 C6 45 E8 04 8B 43 04 89 45 EC C6 45 F0 0B 8D 45 E4 50 8D 95 E0 FE FF FF A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 E0 FE FF FF B9 01 00 00 00 5A E8 ?? ?? ?? ?? 8D 45 F8 50 8B 43 04 89 45 E4 C6 45 E8 0B 8B 45 FC E8 ?? ?? ?? ?? 89 45 EC C6 45 F0 00 8D 55 E4 B9 01 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 80 38 00 74 37 8B 45 F8 E8 ?? ?? ?? ?? 8B C8 8B 55 F8 A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B C8 8B 55 FC A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? E9 8B 00 00 00 8B C6 E8 ?? ?? ?? ?? 84 C0 74 15 6A 41 8B CE B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F4 EB 16 68 FF FF 00 00 8B CE B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 E8 ?? ?? ?? ?? 8B C8 8B 55 F8 8B 45 F4 8B 18 FF 53 08 8B 45 FC E8 ?? ?? ?? ?? 8B C8 8B 55 FC 8B 45 F4 8B 18 FF 53 08 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 E0 FE FF FF E8 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 00 FF FF FF FF 49 00 00 00 53 74 61 74 75 73 3A 20 35 30 30 20 25 73 0D 0A 43 6F 6E 74 65 6E 74 2D 54 79 70 65 3A 20 74 65 78 74 2F 68 74 6D 6C 0D 0A 43 6F 6E 74 65 6E 74 2D 4C 65 6E 67 74 68 3A 20 25 64 0D 0A 43 6F 6E 74 65 6E 74 3A 0D 0A 0D 0A 00 00 00 }
	condition:
		$1
}

rule function_1477_0 {
	meta:
		name = "TCGIApplication.NewRequest"
		size = 324
		refs = "0025 TCGIApplication.NewRequest 0030 IsConsole 003c _DV_TCGIRequest 0041 TCGIRequest.Create 0058 ParamStr 0093 _DV_TWinCGIRequest 0098 TWinCGIRequest.Create 00c8 @LStrToPChar 00e9 GetPrivateProfileString 00f9 @LStrFromPCharLen 0116 @LStrArrayClr 011c @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 EC FE FF FF 53 56 33 D2 89 95 F4 FE FF FF 89 95 F0 FE FF FF 89 95 EC FE FF FF 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? 80 38 00 74 13 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 E9 B1 00 00 00 8D 95 F4 FE FF FF B8 02 00 00 00 E8 ?? ?? ?? ?? 8B 85 F4 FE FF FF 50 8D 95 F0 FE FF FF B8 03 00 00 00 E8 ?? ?? ?? ?? 8B 85 F0 FE FF FF 50 8D 95 EC FE FF FF B8 01 00 00 00 E8 ?? ?? ?? ?? 8B 8D EC FE FF FF B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 8D 53 44 B8 03 00 00 00 E8 ?? ?? ?? ?? 83 7B 44 00 75 4C 8D 95 F4 FE FF FF B8 01 00 00 00 E8 ?? ?? ?? ?? 8B 85 F4 FE FF FF E8 ?? ?? ?? ?? 50 68 05 01 00 00 8D 85 FB FE FF FF 50 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 8D 95 FB FE FF FF 8D 43 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 EC FE FF FF BA 03 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C6 5E 5B 8B E5 5D C3 00 00 00 00 00 00 4F 75 74 70 75 74 20 46 69 6C 65 00 53 79 73 74 65 6D 00 00 }
	condition:
		$1
}

rule function_1478_0 {
	meta:
		name = "TCGIApplication.NewResponse"
		size = 40
		refs = "0001 IsConsole 000d _DV_TCGIResponse 0014 TCGIResponse.Create 001c _DV_TWinCGIResponse"
	strings:
		$1 = { A1 ?? ?? ?? ?? 80 38 00 74 0F 8B CA A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? C3 8B CA A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1479_0 {
	meta:
		name = "TCGIApplication.Run"
		size = 242
		refs = "0010 TWebApplication.Run 0015 IsConsole 001f Output 0024 @RewritText 0029 @_IOTest 002e Input 0033 @ResetText 0040 TCGIApplication.Run 004e TCGIApplication.NewRequest 006a TCGIApplication.NewResponse 0089 TWebApplication.HandleRequest 009e TObject.Free 00a4 @HandleFinally 00d2 @HandleAnyException 00d7 ExceptObject 00e2 HandleServerException 00e7 @DoneExcept"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 80 38 00 74 1E A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 F8 8B 45 FC E8 ?? ?? ?? ?? 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 4D F4 8B 55 F8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 EB 1A E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B 52 44 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1480_0 {
	meta:
		name = "InitApplication"
		size = 23
		refs = "0005 _DV_TCGIApplication 000a TWebApplication.Create 0010 Application"
	strings:
		$1 = { 33 C9 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 02 C3 }
	condition:
		$1
}

rule function_11458_0 {
	meta:
		name = "InitApplication"
		size = 23
		refs = "0005 _DV_TISAPIApplication 000a TWebApplication.Create 0010 Application"
	strings:
		$1 = { 33 C9 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 02 C3 }
	condition:
		$1
}

rule function_1481_0 {
	meta:
		name = "DoneApplication"
		size = 22
		refs = "0001 Application 0008 TObject.Free"
	strings:
		$1 = { A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 D2 89 10 C3 }
	condition:
		$1
}

rule function_1482_0 {
	meta:
		name = "Finalization"
		size = 95
		refs = "0007 Finalization 0013 _DV_7 001a DoneApplication 001f WinCGIServerVariables 002a String 002f @FinalizeArray 0034 CGIServerVariables 0057 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 2F E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? B9 1D 00 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? B9 1D 00 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_1483_0 {
	meta:
		name = "CGIApp"
		size = 15
		refs = "0002 _DV_7 000a InitApplication"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 05 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1670_0 {
	meta:
		name = "CheckLst"
		size = 15
		refs = "0002 _DV_2 000a GetCheckSize"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 05 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_8691_0 {
	meta:
		name = "FlatSB"
		size = 15
		refs = "0002 _DV_1 000a InitFlatSB"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 05 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_11461_0 {
	meta:
		name = "ISAPIApp"
		size = 15
		refs = "0002 _DV_5 000a InitApplication"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 05 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_12598_0 {
	meta:
		name = "MultiMon"
		size = 15
		refs = "0002 _DV_1 000a InitMultiMonStubs"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 05 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_17236_0 {
	meta:
		name = "Series"
		size = 15
		refs = "0002 _DV_81 000a RegisterStandardSeries"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 05 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_16136_0 {
	meta:
		name = "qrprnsu"
		size = 15
		refs = "0002 _DV_5 000a InitGlobals"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 05 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1484_0 {
	meta:
		name = "GetDefaultPattern"
		size = 20
		refs = "000f PatternPalette"
	strings:
		$1 = { 8B C8 8B C1 B9 06 00 00 00 99 F7 F9 42 8A 82 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1485_0 {
	meta:
		name = "TChartGradient.Create"
		size = 78
		refs = "000b @ClassCreate 001a TObject.Create 003a @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 0C C6 47 04 00 C7 47 10 FF FF FF 00 C7 47 08 FF FF 00 00 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1486_0 {
	meta:
		name = "TChartGradient.SetVisible"
		size = 14
		refs = "0009 TCustomTeePanel.SetBooleanProperty"
	strings:
		$1 = { 8D 48 14 8B 40 0C 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1487_0 {
	meta:
		name = "TChartGradient.SetDirection"
		size = 21
	strings:
		$1 = { 56 8B F0 3A 56 04 74 0B 88 56 04 8B 46 0C 8B 10 FF 52 78 5E C3 }
	condition:
		$1
}

rule function_1488_0 {
	meta:
		name = "TChartGradient.SetStartColor"
		size = 14
		refs = "0009 TCustomTeePanel.SetColorProperty"
	strings:
		$1 = { 8D 48 10 8B 40 0C 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1489_0 {
	meta:
		name = "TChartGradient.SetEndColor"
		size = 14
		refs = "0009 TCustomTeePanel.SetColorProperty"
	strings:
		$1 = { 8D 48 08 8B 40 0C 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1490_0 {
	meta:
		name = "TChartGradient.Assign"
		size = 64
		refs = "000a _DV_TChartGradient 000f @IsClass 0039 TPersistent.Assign"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 1D 8B C6 8A 50 14 88 53 14 8A 50 04 88 53 04 8B 50 10 89 53 10 8B 40 08 89 43 08 5E 5B C3 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1491_0 {
	meta:
		name = "TChartWall.Create"
		size = 142
		refs = "000b @ClassCreate 001a TObject.Create 0032 _Dn_TBrush 0037 TBrush.Create 0054 _Dn_TChartPen 0059 TChartPen.Create 007a @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 14 C7 47 04 00 00 00 80 C7 47 18 00 00 00 80 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 77 08 8B 47 14 89 46 08 8B 00 8B 80 C0 00 00 00 89 46 04 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 77 0C 8B 47 14 89 46 08 8B 00 8B 80 C0 00 00 00 89 46 04 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1492_0 {
	meta:
		name = "TChartWall.Destroy"
		size = 53
		refs = "0003 @BeforeDestruction 000f TObject.Free 0023 TPersistent.Destroy 002e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 0C E8 ?? ?? ?? ?? 8B 46 08 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1493_0 {
	meta:
		name = "TChartWall.IsColorStored"
		size = 10
	strings:
		$1 = { 8B 50 04 3B 50 18 0F 95 C0 C3 }
	condition:
		$1
}

rule function_1494_0 {
	meta:
		name = "TChartWall.Assign"
		size = 75
		refs = "000b _DV_TChartWall 0010 @IsClass 0043 TPersistent.Assign"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 26 8B FE 8B 47 04 89 43 04 8B 57 08 8B 43 08 8B 08 FF 51 08 8B 57 0C 8B 43 0C 8B 08 FF 51 08 8B 47 10 89 43 10 EB 09 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1495_0 {
	meta:
		name = "TChartWall.SetPen"
		size = 9
	strings:
		$1 = { 8B 40 0C 8B 08 FF 51 08 C3 }
	condition:
		$1
}

rule function_1496_0 {
	meta:
		name = "TChartWall.SetBrush"
		size = 9
		altNames = "TSeriesPointer.SetBrush"
	strings:
		$1 = { 8B 40 08 8B 08 FF 51 08 C3 }
	condition:
		$1
}

rule function_1497_0 {
	meta:
		name = "TChartWall.SetSize"
		size = 14
		refs = "0009 TCustomTeePanel.SetLongintProperty"
	strings:
		$1 = { 8D 48 10 8B 40 14 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1498_0 {
	meta:
		name = "TChartWall.SetColor"
		size = 14
		refs = "0009 TCustomTeePanel.SetColorProperty"
	strings:
		$1 = { 8D 48 04 8B 40 14 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1499_0 {
	meta:
		name = "TChartBrush.Create"
		size = 65
		refs = "000a @ClassCreate 0017 TBrush.Create 0023 TBrush.SetColor 002e @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? BA 00 00 00 80 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1500_0 {
	meta:
		name = "TChartTitle.Create"
		size = 192
		refs = "000e @ClassCreate 001c TChartFontObject.Create 0023 _Dn_TStringList 0028 TObject.Create 0040 TFont.SetColor 004c TChartTitle.Create 0056 _Dn_TChartHiddenPen 005b TChartHiddenPen.Create 007c _DV_TChartBrush 0081 TChartBrush.Create 00a4 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B D8 33 D2 8B C3 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 43 18 C6 43 2C 01 C6 43 0D 02 BA 00 00 FF 00 8B 43 08 E8 ?? ?? ?? ?? C7 43 30 00 00 FF 00 A0 ?? ?? ?? ?? 88 43 34 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 73 14 8B 43 04 89 46 08 8B 00 8B 80 C0 00 00 00 89 46 04 C6 43 0C 01 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 73 10 8B 43 04 89 46 08 8B 00 8B 80 C0 00 00 00 89 46 04 8B C3 80 7D FF 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5E 5B 59 5D C3 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_1501_0 {
	meta:
		name = "TChartTitle.Assign"
		size = 90
		refs = "000b _DV_TChartTitle 0010 @IsClass 0052 TChartFontObject.Assign"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 35 8B FE 8B 57 18 8B 43 18 8B 08 FF 51 08 8A 47 0D 88 43 0D 8A 47 2C 88 43 2C 8B 57 14 8B 43 14 8B 08 FF 51 08 8A 47 0C 88 43 0C 8B 57 10 8B 43 10 8B 08 FF 51 08 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1502_0 {
	meta:
		name = "TChartTitle.IsFontStored"
		size = 156
		refs = "0010 TChartTitle.IsFontStored 0023 TFont.GetName 002f GetDefaultFontName 0038 @LStrCmp 0041 TFont.GetSize 0048 GetDefaultFontSize 005b TFont.GetStyle 007f @LStrClr 008d @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 57 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 5E 08 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8D 45 F8 E8 ?? ?? ?? ?? 8B 55 F8 58 E8 ?? ?? ?? ?? 75 2C 8B C3 E8 ?? ?? ?? ?? 8B F8 E8 ?? ?? ?? ?? 3B F8 75 1A 8B 43 14 3B 46 30 75 12 8B C3 E8 ?? ?? ?? ?? 8A 56 34 3A D0 75 04 33 C0 EB 02 B0 01 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1503_0 {
	meta:
		name = "TChartTitle.Destroy"
		size = 61
		refs = "0003 @BeforeDestruction 000f TObject.Free 002b TChartFontObject.Destroy 0036 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 18 E8 ?? ?? ?? ?? 8B 46 14 E8 ?? ?? ?? ?? 8B 46 10 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1504_0 {
	meta:
		name = "TChartTitle.SetText"
		size = 20
		refs = "000e TChartFontObject.Repaint"
	strings:
		$1 = { 56 8B F0 8B 46 18 8B 08 FF 51 08 8B C6 E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule function_1505_0 {
	meta:
		name = "TChartTitle.SetVisible"
		size = 14
		refs = "0009 TCustomTeePanel.SetBooleanProperty"
	strings:
		$1 = { 8D 48 2C 8B 40 04 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1506_0 {
	meta:
		name = "TChartTitle.SetAdjustFrame"
		size = 14
		refs = "0009 TCustomTeePanel.SetBooleanProperty"
	strings:
		$1 = { 8D 48 0C 8B 40 04 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1507_0 {
	meta:
		name = "TChartTitle.SetAlignment"
		size = 14
		refs = "0009 TChartFontObject.Repaint"
	strings:
		$1 = { 3A 50 0D 74 08 88 50 0D E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1508_0 {
	meta:
		name = "TCanvas.SetPen"
		size = 9
		altNames = "TChartTitle.SetBrush"
	strings:
		$1 = { 8B 40 10 8B 08 FF 51 08 C3 }
	condition:
		$1
}

rule function_1509_0 {
	meta:
		name = "TCanvas.SetBrush"
		size = 9
		altNames = "TChartTitle.SetFrame TSeriesMarks.SetFrame"
	strings:
		$1 = { 8B 40 14 8B 08 FF 51 08 C3 }
	condition:
		$1
}

rule function_1510_0 {
	meta:
		name = "TChartTitle.Clicked"
		size = 62
		refs = "0019 Point 002a PtInRect"
	strings:
		$1 = { 53 56 57 83 C4 F8 8B F9 8B F2 8B D8 80 7B 2C 00 74 20 8B CC 8B D7 8B C6 E8 ?? ?? ?? ?? FF 74 24 04 FF 74 24 04 8D 43 1C 50 E8 ?? ?? ?? ?? 85 C0 75 04 33 C0 EB 02 B0 01 59 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1511_0 {
	meta:
		name = "TCustomChart.Create"
		size = 524
		refs = "0018 @ClassCreate 0025 TCustomChart.Create 0034 TCustomAxisPanel.Create 003d _DV_TChartTitle 0042 TChartTitle.Create 006f TObject.ClassName 007d @LStrFromString 00a3 TFont.SetColor 00a8 GetDefaultFontSize 00b1 TFont.SetSize 00be TFont.SetStyle 00dd _DV_TChartGradient 00e2 TChartGradient.Create 00f1 _DV_TChartWall 00f6 TChartWall.Create 0108 TBrush.SetStyle 012a TChartWall.SetColor 013f _DV_TChartLegend 0144 TCustomChartLegend.Create 0186 _Dn_TPicture 018b TPicture.Create 01dc @LStrClr 01e2 @HandleFinally 01f1 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 81 C4 F8 FE FF FF 53 56 33 DB 89 5D F8 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B C3 E8 ?? ?? ?? ?? 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 80 03 00 00 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 1C 03 00 00 F6 43 20 10 74 72 8D 95 F8 FE FF FF 8B 03 E8 ?? ?? ?? ?? 8D 95 F8 FE FF FF 8D 45 F8 E8 ?? ?? ?? ?? 8B 55 F8 8B 83 80 03 00 00 8B 40 18 8B 08 FF 51 34 8B 83 1C 03 00 00 8B 70 08 BA FF 00 00 00 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 8A 15 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B 83 1C 03 00 00 C7 40 30 FF 00 00 00 8A 15 ?? ?? ?? ?? 88 50 34 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 20 03 00 00 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 14 03 00 00 8B 46 08 B2 01 E8 ?? ?? ?? ?? 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 24 03 00 00 BA FF FF 80 00 8B C6 E8 ?? ?? ?? ?? 8B 83 24 03 00 00 8B 50 04 89 50 18 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 28 03 00 00 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 18 03 00 00 BA FF FF FF 00 8B C6 E8 ?? ?? ?? ?? 8B 83 18 03 00 00 8B 50 04 89 50 18 C6 83 0B 03 00 00 00 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 10 03 00 00 89 5E 0C 8B 03 8B 80 C0 00 00 00 89 46 08 C7 83 04 03 00 00 08 00 00 00 C6 83 09 03 00 00 01 C6 83 0A 03 00 00 03 C6 83 00 03 00 00 00 C6 83 2C 03 00 00 01 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 80 7D FF 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5E 5B 8B E5 5D C3 00 02 00 00 00 }
	condition:
		$1
}

rule function_1512_0 {
	meta:
		name = "TCustomChart.Destroy"
		size = 133
		refs = "0003 @BeforeDestruction 0012 TObject.Free 0073 TCustomAxisPanel.Destroy 007e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 86 80 03 00 00 E8 ?? ?? ?? ?? 8B 86 1C 03 00 00 E8 ?? ?? ?? ?? 8B 86 14 03 00 00 E8 ?? ?? ?? ?? 33 C0 89 86 14 03 00 00 8B 86 18 03 00 00 E8 ?? ?? ?? ?? 8B 86 24 03 00 00 E8 ?? ?? ?? ?? 8B 86 28 03 00 00 E8 ?? ?? ?? ?? 8B 86 20 03 00 00 E8 ?? ?? ?? ?? 8B 86 10 03 00 00 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1513_0 {
	meta:
		name = "TCustomChart.SetTitle"
		size = 12
	strings:
		$1 = { 8B 80 80 03 00 00 8B 08 FF 51 08 C3 }
	condition:
		$1
}

rule function_1514_0 {
	meta:
		name = "TCustomChart.SetBackImage"
		size = 16
	strings:
		$1 = { 56 8B F0 8B 86 10 03 00 00 8B 08 FF 51 08 5E C3 }
	condition:
		$1
}

rule function_1515_0 {
	meta:
		name = "TCustomChart.SetBackImageInside"
		size = 14
		refs = "0009 TCustomTeePanel.SetBooleanProperty"
	strings:
		$1 = { 8D 88 0C 03 00 00 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1516_0 {
	meta:
		name = "TCustomChart.SetFoot"
		size = 12
	strings:
		$1 = { 8B 80 1C 03 00 00 8B 08 FF 51 08 C3 }
	condition:
		$1
}

rule function_1517_0 {
	meta:
		name = "TCustomChart.SetBackImageMode"
		size = 26
	strings:
		$1 = { 56 8B F0 3A 96 0B 03 00 00 74 0D 88 96 0B 03 00 00 8B C6 8B 10 FF 52 78 5E C3 }
	condition:
		$1
}

rule function_1518_0 {
	meta:
		name = "TCustomChart.FormattedValueLegend"
		size = 55
		refs = "0022 TCustomChartLegend.FormattedValue 002b @LStrClr"
	strings:
		$1 = { 55 8B EC 51 53 56 57 89 4D FC 8B F2 8B D8 8B 7D 08 85 F6 74 13 57 8B 4D FC 8B D6 8B 83 28 03 00 00 E8 ?? ?? ?? ?? EB 07 8B C7 E8 ?? ?? ?? ?? 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_1519_0 {
	meta:
		name = "TCustomChart.FormattedLegend"
		size = 63
		refs = "0014 TCustomChartLegend.FormattedLegend"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B 83 28 03 00 00 E8 ?? ?? ?? ?? 66 83 BB C2 03 00 00 00 74 19 56 57 8B 83 28 03 00 00 8A 48 50 8B D3 8B 83 C4 03 00 00 FF 93 C0 03 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1520_0 {
	meta:
		name = "TCustomChart.SetLegend"
		size = 16
	strings:
		$1 = { 56 8B F0 8B 86 28 03 00 00 8B 08 FF 51 08 5E C3 }
	condition:
		$1
}

rule function_1521_0 {
	meta:
		name = "SaveAxisScales"
		size = 42
	strings:
		$1 = { 8A 48 04 88 0A 8A 48 06 88 4A 01 8A 48 05 88 4A 02 8B 48 18 89 4A 04 8B 48 1C 89 4A 08 8B 48 10 89 4A 0C 8B 48 14 89 4A 10 C3 }
	condition:
		$1
}

rule function_1522_0 {
	meta:
		name = "TCustomChart.SaveScales"
		size = 64
		refs = "000f SaveAxisScales"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 83 88 02 00 00 E8 ?? ?? ?? ?? 8D 56 3C 8B 83 8C 02 00 00 E8 ?? ?? ?? ?? 8D 56 14 8B 83 90 02 00 00 E8 ?? ?? ?? ?? 8D 56 28 8B 83 94 02 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1524_0 {
	meta:
		name = "TCustomChart.RestoreScales"
		size = 64
		refs = "000f RestoreAxisScales"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 83 88 02 00 00 E8 ?? ?? ?? ?? 8D 56 3C 8B 83 8C 02 00 00 E8 ?? ?? ?? ?? 8D 56 14 8B 83 90 02 00 00 E8 ?? ?? ?? ?? 8D 56 28 8B 83 94 02 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1523_0 {
	meta:
		name = "RestoreAxisScales"
		size = 63
		refs = "000b TCustomChartAxis.SetAutomatic 0015 TCustomChartAxis.SetAutomaticMinimum 001f TCustomChartAxis.SetAutomaticMaximum 0038 TCustomChartAxis.SetMinMax"
	strings:
		$1 = { 53 56 8B F2 8B D8 8A 16 8B C3 E8 ?? ?? ?? ?? 8A 56 01 8B C3 E8 ?? ?? ?? ?? 8A 56 02 8B C3 E8 ?? ?? ?? ?? 80 7B 04 00 75 13 FF 76 08 FF 76 04 FF 76 10 FF 76 0C 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1525_0 {
	meta:
		name = "TCustomChart.SetGradient"
		size = 12
	strings:
		$1 = { 8B 80 20 03 00 00 8B 08 FF 51 08 C3 }
	condition:
		$1
}

rule function_1526_0 {
	meta:
		name = "TCustomChart.SetBackWall"
		size = 12
	strings:
		$1 = { 8B 80 14 03 00 00 8B 08 FF 51 08 C3 }
	condition:
		$1
}

rule function_1527_0 {
	meta:
		name = "TCustomChart.GetFrame"
		size = 17
	strings:
		$1 = { 8B 90 14 03 00 00 85 D2 74 04 8B 42 0C C3 33 C0 C3 }
	condition:
		$1
}

rule function_1528_0 {
	meta:
		name = "TCustomChart.SetFrame"
		size = 15
	strings:
		$1 = { 8B 80 14 03 00 00 8B 40 0C 8B 08 FF 51 08 C3 }
	condition:
		$1
}

rule function_1529_0 {
	meta:
		name = "TCustomChart.GetBackColor"
		size = 10
	strings:
		$1 = { 8B 80 14 03 00 00 8B 40 04 C3 }
	condition:
		$1
}

rule function_1530_0 {
	meta:
		name = "TCustomChart.SetBackColor"
		size = 32
		refs = "000a TChartWall.SetColor 001a TBrush.SetStyle"
	strings:
		$1 = { 53 8B D8 8B 83 14 03 00 00 E8 ?? ?? ?? ?? 8B 83 14 03 00 00 8B 40 08 33 D2 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1531_0 {
	meta:
		name = "TCustomChart.IsFreeSeriesColor"
		size = 118
		refs = "0011 TCustomAxisPanel.SeriesCount 0024 TCustomAxisPanel.GetSeries 0043 TCustomChart.GetBackColor"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 88 0C 24 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B F8 4F 85 FF 7C 37 47 33 ED 8B D5 8B C3 E8 ?? ?? ?? ?? 8B 40 28 89 44 24 04 3B 74 24 04 74 16 80 3C 24 00 74 14 3B 73 64 74 0B 8B C3 E8 ?? ?? ?? ?? 3B F0 75 04 33 C0 EB 20 45 4F 75 CC 80 3C 24 00 74 14 3B 73 64 74 0B 8B C3 E8 ?? ?? ?? ?? 3B F0 75 04 33 C0 EB 02 B0 01 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1532_0 {
	meta:
		name = "TCustomChart.SetLeftWall"
		size = 12
	strings:
		$1 = { 8B 80 24 03 00 00 8B 08 FF 51 08 C3 }
	condition:
		$1
}

rule function_1533_0 {
	meta:
		name = "TCustomChart.SetBottomWall"
		size = 12
	strings:
		$1 = { 8B 80 18 03 00 00 8B 08 FF 51 08 C3 }
	condition:
		$1
}

rule function_1534_0 {
	meta:
		name = "DrawTitleFoot"
		size = 77
		refs = "0023 TCustomChart.DrawTitle"
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 40 FC 8B 80 80 03 00 00 80 78 2C 00 74 12 8B 55 08 8B D0 8B 45 08 8B 40 FC B1 01 E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC 8B 80 1C 03 00 00 80 78 2C 00 74 12 8B 55 08 8B D0 8B 45 08 8B 40 FC 33 C9 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule function_1535_0 {
	meta:
		name = "TCustomChart.DrawTitlesAndLegend"
		size = 148
		refs = "0031 TChartSeriesList.CountActive 0043 TCustomChartLegend.GetVertical 005b DrawTitleFoot"
	strings:
		$1 = { 55 8B EC 51 89 45 FC 8B 45 FC 8B 80 5C 02 00 00 8B 10 FF 92 DC 00 00 00 8B 45 FC 8B 80 28 03 00 00 80 78 2C 00 74 52 8B 45 FC 8B 80 80 02 00 00 E8 ?? ?? ?? ?? 85 C0 7E 40 8B 45 FC 8B 80 28 03 00 00 E8 ?? ?? ?? ?? 84 C0 74 17 8B 45 FC 8B 80 28 03 00 00 8B 10 FF 52 10 55 E8 ?? ?? ?? ?? 59 EB 1E 55 E8 ?? ?? ?? ?? 59 8B 45 FC 8B 80 28 03 00 00 8B 10 FF 52 10 EB 07 55 E8 ?? ?? ?? ?? 59 8B 45 FC 8B 80 5C 02 00 00 8B 10 FF 92 E0 00 00 00 59 5D C3 }
	condition:
		$1
}

rule function_1536_0 {
	meta:
		name = "TCustomChart.DrawBitmap"
		size = 423
		refs = "0044 RectSize 0052 TeeClipWhenPrinting 005c TeeClipWhenMetafiling 0092 TPicture.GetWidth 00a1 TPicture.GetHeight"
	strings:
		$1 = { 53 56 57 55 83 C4 EC 8B FA 8B F0 8B 86 10 03 00 00 8B 40 04 85 C0 0F 84 83 01 00 00 80 BE 0B 03 00 00 00 75 14 8B C8 8B D7 8B 86 5C 02 00 00 8B 18 FF 53 58 E9 66 01 00 00 8D 4C 24 0C 8D 54 24 10 8B C7 E8 ?? ?? ?? ?? 80 BE 44 02 00 00 00 74 0A A1 ?? ?? ?? ?? 80 38 00 75 0A A1 ?? ?? ?? ?? 80 38 00 74 19 8B 86 54 02 00 00 50 8B D7 33 C9 8B 86 5C 02 00 00 8B 18 FF 93 C0 00 00 00 80 BE 0B 03 00 00 01 0F 85 8A 00 00 00 8B 86 10 03 00 00 E8 ?? ?? ?? ?? 89 44 24 04 8B 86 10 03 00 00 E8 ?? ?? ?? ?? 89 44 24 08 83 7C 24 04 00 0F 8E C0 00 00 00 83 7C 24 08 00 0F 8E B5 00 00 00 33 C0 89 04 24 8B 04 24 3B 44 24 0C 0F 8D A3 00 00 00 33 DB 3B 5C 24 10 7D 2A 8B 86 10 03 00 00 8B 40 04 50 8B 4F 04 03 4C 24 04 8B 17 03 D3 8B 86 5C 02 00 00 8B 28 FF 55 34 03 5C 24 04 3B 5C 24 10 7C D6 8B 44 24 08 01 04 24 8B 04 24 3B 44 24 0C 7C BE EB 5F 8B D7 8B C6 8B 08 FF 91 08 01 00 00 8B 86 10 03 00 00 E8 ?? ?? ?? ?? 8B 5C 24 10 2B D8 D1 FB 79 03 83 D3 00 03 1F 8B 86 10 03 00 00 E8 ?? ?? ?? ?? 8B 54 24 0C 2B D0 D1 FA 79 03 83 D2 00 03 57 04 89 14 24 8B 86 10 03 00 00 8B 40 04 50 8B 4C 24 04 8B D3 8B 86 5C 02 00 00 8B 18 FF 53 34 80 BE 44 02 00 00 00 74 0A A1 ?? ?? ?? ?? 80 38 00 75 0A A1 ?? ?? ?? ?? 80 38 00 74 0E 8B 86 5C 02 00 00 8B 10 FF 92 90 00 00 00 83 C4 14 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1537_0 {
	meta:
		name = "TCustomChart.FillPanelRect"
		size = 145
		refs = "005c PrintTeePanel 0072 TBrush.SetColor 007c TBrush.SetStyle"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 89 14 24 8B F8 8B B7 20 03 00 00 80 7E 14 00 74 3A 8A 46 04 84 C0 74 04 3C 02 75 0C 8B 6E 10 8B 56 08 89 54 24 04 EB 0A 8B 56 10 89 54 24 04 8B 6E 08 8B 54 24 04 52 50 8B 54 24 08 8B CD 8B 87 5C 02 00 00 8B 18 FF 53 7C EB 38 80 BF 44 02 00 00 00 74 0A A1 ?? ?? ?? ?? 80 38 00 74 25 8B 9F 5C 02 00 00 8B 43 10 8B 57 64 E8 ?? ?? ?? ?? 8B 43 10 33 D2 E8 ?? ?? ?? ?? 8B 14 24 8B C3 8B 08 FF 51 78 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1538_0 {
	meta:
		name = "TCustomChart.PanelPaint"
		size = 154
		refs = "004a PrintTeePanel 0061 TPen.SetStyle 006d TPen.SetWidth 0076 TPen.SetMode 0086 TBrush.SetStyle 008f TCustomTeePanel.DrawPanelBevels"
	strings:
		$1 = { 53 56 57 83 C4 F0 8B D8 8B F2 8B FC B9 04 00 00 00 F3 A5 8B D4 8B C3 8B 08 FF 91 08 01 00 00 8B 83 10 03 00 00 83 78 04 00 74 15 80 BB 0C 03 00 00 00 75 0C 8B D4 8B C3 8B 08 FF 91 04 01 00 00 80 BB 44 02 00 00 00 74 0A A1 ?? ?? ?? ?? 80 38 00 74 40 8B 83 5C 02 00 00 8B 70 0C 33 D2 8B C6 E8 ?? ?? ?? ?? BA 01 00 00 00 8B C6 E8 ?? ?? ?? ?? B2 04 8B C6 E8 ?? ?? ?? ?? 8B 83 5C 02 00 00 8B 40 10 B2 01 E8 ?? ?? ?? ?? 8B D4 8B C3 E8 ?? ?? ?? ?? 83 C4 10 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1539_0 {
	meta:
		name = "TCustomChart.CalcWallSize"
		size = 59
	strings:
		$1 = { 33 C9 80 B8 4C 02 00 00 00 74 2D 80 B8 98 02 00 00 00 74 24 3B 90 90 02 00 00 75 0B 8B 80 24 03 00 00 8B 48 10 EB 11 3B 90 8C 02 00 00 75 09 8B 80 18 03 00 00 8B 48 10 8B C1 C3 }
	condition:
		$1
}

rule function_1540_0 {
	meta:
		name = "PrepareWallCanvas"
		size = 174
		refs = "0016 TTeeCanvas.AssignVisiblePen 001e TBrush.GetBitmap 0038 TBrush.SetBitmap 0049 TBrush.GetStyle 0055 TBrush.GetColor 006e TCustomTeePanel.SetBrushCanvas 0086 TBrush.SetStyle"
	strings:
		$1 = { 55 8B EC 53 8B D8 8B 45 08 8B 40 FC 8B 80 5C 02 00 00 8B 53 0C E8 ?? ?? ?? ?? 8B 43 08 E8 ?? ?? ?? ?? 85 C0 75 67 8B 45 08 8B 40 FC 8B 80 5C 02 00 00 8B 40 10 33 D2 E8 ?? ?? ?? ?? 81 7B 04 00 00 00 80 75 0C 8B 43 08 E8 ?? ?? ?? ?? 84 C0 74 23 8B 43 08 E8 ?? ?? ?? ?? 50 8B 43 08 E8 ?? ?? ?? ?? 8B C8 8B 45 08 8B 40 FC 8B 53 04 E8 ?? ?? ?? ?? EB 37 8B 45 08 8B 40 FC 8B 80 5C 02 00 00 8B 40 10 B2 01 E8 ?? ?? ?? ?? 5B 5D C3 8B 43 08 E8 ?? ?? ?? ?? 8B D0 8B 45 08 8B 40 FC 8B 80 5C 02 00 00 8B 40 10 E8 ?? ?? ?? ?? 5B 5D C3 }
	condition:
		$1
}

rule function_1541_0 {
	meta:
		name = "TCustomChart.DrawWalls"
		size = 743
		refs = "0017 PrepareWallCanvas 0086 TBrush.GetStyle 0092 TBrush.GetBitmap 00eb Rect"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 89 45 FC 55 8B 45 FC 8B 80 14 03 00 00 E8 ?? ?? ?? ?? 59 8B 45 FC 8B 98 14 03 00 00 8B 45 FC 80 B8 4C 02 00 00 00 0F 84 D9 00 00 00 8B 45 FC 80 B8 98 02 00 00 00 0F 84 8A 00 00 00 83 7B 10 00 0F 8E 80 00 00 00 8B 45 FC 8D B0 60 02 00 00 8B 46 04 50 8B 45 FC 8B 90 8C 02 00 00 8B 45 FC 8B 08 FF 91 D4 00 00 00 03 46 0C 50 8B 45 FC 8B B8 54 02 00 00 57 03 7B 10 57 8B 43 08 E8 ?? ?? ?? ?? 3C 01 74 0C 8B 43 08 E8 ?? ?? ?? ?? 85 C0 74 04 33 C0 EB 02 B0 01 50 8B 45 FC 8B 90 90 02 00 00 8B 45 FC 8B 08 FF 91 D4 00 00 00 8B 16 2B D0 8B 4E 08 8B 45 FC 8B 80 5C 02 00 00 8B 18 FF 93 C4 00 00 00 EB 64 8B 45 FC 8D 98 60 02 00 00 8B 43 0C 50 8D 45 EC 50 8B 4B 08 8B 53 04 4A 8B 03 40 E8 ?? ?? ?? ?? 8D 55 EC 8B 45 FC 8B 88 54 02 00 00 8B 45 FC 8B 80 5C 02 00 00 8B 18 FF 93 04 01 00 00 EB 25 8B 45 FC 05 60 02 00 00 8B 50 08 42 52 8B 50 0C 52 8B 55 FC 8B 92 5C 02 00 00 8B 48 04 8B 00 92 8B 18 FF 53 50 8B 45 FC 8B 80 10 03 00 00 83 78 04 00 74 20 8B 45 FC 80 B8 0C 03 00 00 00 74 14 8B 45 FC 8D 90 60 02 00 00 8B 45 FC 8B 08 FF 91 04 01 00 00 8B 45 FC 80 B8 4C 02 00 00 00 0F 84 6E 01 00 00 8B 45 FC 80 B8 98 02 00 00 00 0F 84 5E 01 00 00 55 8B 45 FC 8B 80 24 03 00 00 E8 ?? ?? ?? ?? 59 8B 45 FC 8B B0 24 03 00 00 8B 45 FC 8D 98 60 02 00 00 8B 7E 10 85 FF 7E 61 8B 43 04 50 8B 45 FC 8B 90 8C 02 00 00 8B 45 FC 8B 08 FF 91 D4 00 00 00 03 43 0C 50 6A 00 8B 45 FC 8B 80 54 02 00 00 40 50 8B 46 08 E8 ?? ?? ?? ?? 3C 01 74 0C 8B 46 08 E8 ?? ?? ?? ?? 85 C0 74 04 33 C0 EB 02 B0 01 50 8B 13 2B D7 8B 45 FC 8B 80 5C 02 00 00 8B 0B 8B 18 FF 93 C4 00 00 00 EB 3B 8B 45 FC 8B 90 8C 02 00 00 8B 45 FC 8B 08 FF 91 D4 00 00 00 03 43 0C 50 6A 00 8B 45 FC 8B 80 54 02 00 00 40 50 8B 45 FC 8B 80 5C 02 00 00 8B 4B 04 8B 13 8B 18 FF 93 0C 01 00 00 55 8B 45 FC 8B 80 18 03 00 00 E8 ?? ?? ?? ?? 59 8B 45 FC 8B B0 18 03 00 00 8B 45 FC 8D 98 60 02 00 00 83 7E 10 00 7E 4B 8B 7B 0C 57 03 7E 10 57 6A 00 8B 45 FC 8B 80 54 02 00 00 50 8B 46 08 E8 ?? ?? ?? ?? 3C 01 74 0C 8B 46 08 E8 ?? ?? ?? ?? 85 C0 74 04 33 C0 EB 02 B0 01 50 8B 4B 08 8B 13 8B 45 FC 8B 80 5C 02 00 00 8B 18 FF 93 C4 00 00 00 EB 26 8B 43 08 50 6A 00 8B 45 FC 8B 80 54 02 00 00 50 8B 4B 0C 8B 13 8B 45 FC 8B 80 5C 02 00 00 8B 18 FF 93 08 01 00 00 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1542_0 {
	meta:
		name = "DrawTitleLine"
		size = 121
	strings:
		$1 = { 55 8B EC 53 8B D8 8B 45 08 8B 40 FC 8B 80 5C 02 00 00 8B D3 8B 08 FF 51 60 8B 55 08 8B 52 F8 8A 52 0D 80 EA 01 72 04 74 0A EB 14 8B 45 08 8B 40 E8 EB 2A 8B 55 08 8B 52 F0 2B D0 8B C2 EB 1E 8B 55 08 8B 52 E8 8B 4D 08 03 51 F0 D1 FA 79 03 83 D2 00 D1 F8 79 03 83 D0 00 2B D0 8B C2 53 8B 55 08 8B 4A EC 8B 55 08 8B 52 FC 8B 92 5C 02 00 00 92 8B 18 FF 53 5C 5B 5D C3 }
	condition:
		$1
}

rule function_1543_0 {
	meta:
		name = "TCustomChart.DrawTitle"
		size = 847
		refs = "001b TCustomChart.DrawTitle 0046 TTeeCanvas.FontHeight 0065 TBrush.GetColor 0079 TBrush.SetStyle 008c TPen.GetColor 00ad TPen.GetWidth 0182 InflateRect 0294 DrawTitleLine 0327 TCustomTeePanel.ReCalcWidthHeight 033c @LStrClr 0342 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 CC 53 56 57 33 DB 89 5D CC 88 4D E7 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 80 5C 02 00 00 89 45 D0 8B 45 F8 8B 50 08 8B 45 FC 8B 08 FF 91 C8 00 00 00 8B 45 D0 E8 ?? ?? ?? ?? 89 45 E0 8B 45 F8 8B 50 10 8B 45 D0 8B 40 10 8B 08 FF 51 08 8B 45 D0 8B 40 10 E8 ?? ?? ?? ?? 3D 00 00 00 80 75 0D 8B 45 D0 8B 40 10 B2 01 E8 ?? ?? ?? ?? 8B 45 F8 8B 58 14 80 7B 18 00 74 0E 8B C3 E8 ?? ?? ?? ?? 3D 00 00 00 80 75 04 33 C0 EB 02 B0 01 88 45 DB 80 7D DB 00 74 0D 8B 45 F8 8B 40 14 E8 ?? ?? ?? ?? EB 02 33 C0 8B 55 FC 8B 92 60 02 00 00 03 D0 89 55 E8 80 7D E7 00 74 16 8B 55 FC 8B 92 64 02 00 00 03 D0 89 55 EC 83 EA 05 89 55 F4 EB 14 8B 55 FC 8B 92 6C 02 00 00 2B D0 89 55 F4 83 C2 05 89 55 EC 8B 55 FC 8B 92 68 02 00 00 2B D0 89 55 F0 8B 45 F8 8D 78 1C 8D 75 E8 B9 04 00 00 00 F3 A5 80 7D DB 00 74 20 8B 45 F8 8B 50 14 8B 45 D0 8B 40 0C 8B 08 FF 51 08 8B 45 D0 8B 40 0C E8 ?? ?? ?? ?? 8B F8 EB 02 33 FF 8B C7 03 C0 89 45 D4 80 7D E7 00 74 19 8B 45 F8 8B 40 18 8B 10 FF 52 14 F7 6D E0 03 45 EC 8B 55 F8 89 42 28 EB 19 8B 45 F8 8B 40 18 8B 10 FF 52 14 F7 6D E0 8B 55 F4 2B D0 8B 45 F8 89 50 20 57 57 8B 45 F8 83 C0 1C 50 E8 ?? ?? ?? ?? 80 7D DB 00 0F 84 A7 00 00 00 8B 45 F8 80 78 0C 00 0F 84 9A 00 00 00 33 C0 89 45 DC 8B 45 F8 8B 40 18 8B 10 FF 52 14 8B F0 4E 85 F6 7C 2C 46 33 DB 8D 4D CC 8B 45 F8 8B 40 18 8B D3 8B 38 FF 57 0C 8B 55 CC 8B 45 D0 8B 08 FF 51 60 8B F8 3B 7D DC 7E 03 89 7D DC 43 4E 75 D7 8B 45 D4 01 45 DC 8B 45 F8 83 C0 1C 8B 55 F8 8A 52 0D 80 EA 01 72 08 74 10 FE CA 74 16 EB 38 8B 10 03 55 DC 89 50 08 EB 2E 8B 50 08 2B 55 DC 89 10 EB 24 8B 10 03 50 08 D1 FA 79 03 83 D2 00 8B 4D DC D1 F9 79 03 83 D1 00 03 4D D4 8B DA 2B D9 89 18 03 CA 89 48 08 80 7D DB 00 74 0E 8B 45 F8 8D 50 1C 8B 45 D0 8B 08 FF 51 70 8B 45 FC 8B 80 5C 02 00 00 B2 01 8B 08 FF 51 1C 80 7D E7 00 74 44 8B 45 F8 8B 40 18 8B 10 FF 52 14 8B F0 4E 85 F6 7C 74 46 33 DB 8B 45 EC 03 45 E0 89 45 F4 55 8D 4D CC 8B 45 F8 8B 40 18 8B D3 8B 38 FF 57 0C 8B 45 CC E8 ?? ?? ?? ?? 59 8B 45 F4 89 45 EC 43 4E 75 D3 EB 42 8B 45 F8 8B 40 18 8B 10 FF 52 14 8B D8 4B 83 FB 00 7C 2F 8B 45 F4 2B 45 E0 89 45 EC 55 8D 4D CC 8B 45 F8 8B 40 18 8B D3 8B 30 FF 56 0C 8B 45 CC E8 ?? ?? ?? ?? 59 8B 45 EC 89 45 F4 4B 83 FB FF 75 D1 80 7D DB 00 74 14 80 7D E7 00 74 08 8B 45 D4 01 45 F4 EB 06 8B 45 D4 29 45 EC 8B 45 FC 05 60 02 00 00 80 7D E7 00 74 0B 8B 55 F4 83 C2 05 89 50 04 EB 09 8B 55 EC 83 EA 05 89 50 0C 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1544_0 {
	meta:
		name = "TCustomChart.SeriesUp"
		size = 43
		refs = "000a TList.IndexOf 001e TList.Exchange"
	strings:
		$1 = { 56 8B F0 8B 86 80 02 00 00 E8 ?? ?? ?? ?? 85 C0 7E 17 8B C8 49 8B D0 8B 86 80 02 00 00 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 52 78 5E C3 }
	condition:
		$1
}

rule function_1545_0 {
	meta:
		name = "TCustomChart.SeriesDown"
		size = 55
		refs = "000b TList.IndexOf 0014 TCustomAxisPanel.SeriesCount 0029 TList.Exchange"
	strings:
		$1 = { 53 56 8B F0 8B 86 80 02 00 00 E8 ?? ?? ?? ?? 8B D8 8B C6 E8 ?? ?? ?? ?? 48 3B D8 7D 17 8D 4B 01 8B D3 8B 86 80 02 00 00 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 52 78 5E 5B C3 }
	condition:
		$1
}

rule function_1546_0 {
	meta:
		name = "TCustomChart.PreviousPage"
		size = 34
	strings:
		$1 = { 83 B8 D8 02 00 00 00 7E 18 83 B8 D4 02 00 00 01 7E 0F 8B 90 D4 02 00 00 4A 8B 08 FF 91 D0 00 00 00 C3 }
	condition:
		$1
}

rule function_1547_0 {
	meta:
		name = "TCustomChart.NextPage"
		size = 52
		refs = "0014 @CallDynaInst"
	strings:
		$1 = { 53 56 8B F0 83 BE D8 02 00 00 00 7E 24 8B C6 66 BB B7 FF E8 ?? ?? ?? ?? 3B 86 D4 02 00 00 7E 11 8B 96 D4 02 00 00 42 8B C6 8B 08 FF 91 D0 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_1548_0 {
	meta:
		name = "ZoomAxis"
		size = 56
		refs = "000b AnimatedZoomFactor 0030 TCustomChartAxis.SetMinMax"
	strings:
		$1 = { 55 8B EC DD 45 10 DC 60 18 DC 35 ?? ?? ?? ?? DC 40 18 83 C4 F8 DD 1C 24 9B DD 40 10 DC 65 08 DC 35 ?? ?? ?? ?? DC 68 10 83 C4 F8 DD 1C 24 9B E8 ?? ?? ?? ?? 5D C2 10 00 }
	condition:
		$1
}

rule function_1549_0 {
	meta:
		name = "TCustomChart.DoZoom"
		size = 340
		refs = "001f TCustomChart.SaveScales 0067 ZoomAxis 00bc TControl.Refresh 00da TCustomChartAxis.SetMinMax"
	strings:
		$1 = { 55 8B EC 83 C4 AC 53 56 57 89 4D FC 8B FA 8B D8 80 BB 2C 03 00 00 00 74 23 8D 55 AC 8B C3 E8 ?? ?? ?? ?? 57 8D 75 AC 8D BB 30 03 00 00 B9 14 00 00 00 F3 A5 5F C6 83 2C 03 00 00 00 80 BB 08 03 00 00 00 74 7E 8B B3 04 03 00 00 4E 85 F6 7E 73 8B 45 14 FF 70 04 FF 30 8B 45 10 FF 70 04 FF 30 8B 83 90 02 00 00 E8 ?? ?? ?? ?? 8B 45 0C FF 70 04 FF 30 8B 45 08 FF 70 04 FF 30 8B 83 94 02 00 00 E8 ?? ?? ?? ?? FF 77 04 FF 37 8B 45 FC FF 70 04 FF 30 8B 83 88 02 00 00 E8 ?? ?? ?? ?? 8B 45 1C FF 70 04 FF 30 8B 45 18 FF 70 04 FF 30 8B 83 8C 02 00 00 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 4E 75 8D 8B 45 14 FF 70 04 FF 30 8B 45 10 FF 70 04 FF 30 8B 83 90 02 00 00 E8 ?? ?? ?? ?? 8B 45 0C FF 70 04 FF 30 8B 45 08 FF 70 04 FF 30 8B 83 94 02 00 00 E8 ?? ?? ?? ?? FF 77 04 FF 37 8B 45 FC FF 70 04 FF 30 8B 83 88 02 00 00 E8 ?? ?? ?? ?? 8B 45 1C FF 70 04 FF 30 8B 45 18 FF 70 04 FF 30 8B 83 8C 02 00 00 E8 ?? ?? ?? ?? C6 83 84 03 00 00 01 66 83 BB DA 03 00 00 00 74 0E 8B D3 8B 83 DC 03 00 00 FF 93 D8 03 00 00 5F 5E 5B 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule function_1550_0 {
	meta:
		name = "TCustomChart.SetAnimatedZoom"
		size = 14
		refs = "0009 TCustomTeePanel.SetBooleanProperty"
	strings:
		$1 = { 8D 88 08 03 00 00 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1551_0 {
	meta:
		name = "TCustomChart.SetAnimatedZoomSteps"
		size = 14
		refs = "0009 TCustomTeePanel.SetIntegerProperty"
	strings:
		$1 = { 8D 88 04 03 00 00 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1552_0 {
	meta:
		name = "TCustomChart.ZoomRect"
		size = 44
	strings:
		$1 = { 56 8B F0 8B 86 58 02 00 00 8B 0A 89 48 08 8B 4A 04 89 48 0C 8B 4A 08 89 48 10 8B 52 0C 89 50 14 8B C6 8B 10 FF 92 FC 00 00 00 5E C3 }
	condition:
		$1
}

rule function_1553_0 {
	meta:
		name = "CalcAxisScale"
		size = 108
		refs = "002b TCustomChartAxis.CalcMinMax 003d CalcAxisScale"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 56 8B F1 8B DA 8B 50 18 89 55 F0 8B 50 1C 89 55 F4 8B 50 10 89 55 E8 8B 50 14 89 55 EC 8D 4D E8 8D 55 F0 E8 ?? ?? ?? ?? DD 45 E8 DC 65 F0 8B 45 08 DD 40 08 D8 25 ?? ?? ?? ?? DE C9 D8 35 ?? ?? ?? ?? DD 5D F8 9B DD 45 F0 DC 45 F8 DD 1B 9B DD 45 E8 DC 65 F8 DD 1E 9B 5E 5B 8B E5 5D C3 00 00 00 00 00 C8 42 }
	condition:
		$1
}

rule function_1554_0 {
	meta:
		name = "TCustomChart.ZoomPercent"
		size = 141
		refs = "0018 CalcAxisScale"
	strings:
		$1 = { 55 8B EC 83 C4 C0 53 56 8B D8 55 8D 4D F0 8D 55 F8 8B 83 90 02 00 00 E8 ?? ?? ?? ?? 59 55 8D 4D E0 8D 55 E8 8B 83 94 02 00 00 E8 ?? ?? ?? ?? 59 55 8D 4D D0 8D 55 D8 8B 83 88 02 00 00 E8 ?? ?? ?? ?? 59 55 8D 4D C0 8D 55 C8 8B 83 8C 02 00 00 E8 ?? ?? ?? ?? 59 8D 45 C8 50 8D 45 C0 50 8D 45 F8 50 8D 45 F0 50 8D 45 E8 50 8D 45 E0 50 8D 4D D0 8D 55 D8 8B C3 8B 30 FF 96 00 01 00 00 8B C3 8B 10 FF 52 7C 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_1555_0 {
	meta:
		name = "ClickedAxis"
		size = 50
		refs = "0015 TCustomChartAxis.Clicked"
	strings:
		$1 = { 55 8B EC 53 8B D8 8B 45 08 8B 48 FC 8B 45 08 8B 50 F8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 12 8B 55 08 8B 52 F4 C6 02 02 8B 55 08 8B 52 F4 89 5A 0C 5B 5D C3 }
	condition:
		$1
}

rule function_1556_0 {
	meta:
		name = "TCustomChart.CalcClickedPart"
		size = 442
		refs = "004c PtInRect 0062 TCustomAxisPanel.SeriesCount 0073 TCustomAxisPanel.GetSeries 00f5 ClickedAxis 015b TChartTitle.Clicked 01a5 TChartSeriesList.CountActive"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 56 57 8B F2 8D 7D F8 A5 A5 89 4D F4 8B D8 8B 45 F4 C6 00 00 8B 45 F4 C7 40 04 FF FF FF FF 8B 45 F4 33 D2 89 50 08 8B 45 F4 33 D2 89 50 0C 8B B3 28 03 00 00 80 7E 2C 00 74 1E FF 75 FC FF 75 F8 8D 46 40 50 E8 ?? ?? ?? ?? 85 C0 74 0B 8B 45 F4 C6 00 01 E9 54 01 00 00 8B C3 E8 ?? ?? ?? ?? 8B F0 4E 83 FE 00 7C 7F 8B D6 8B C3 E8 ?? ?? ?? ?? 89 45 E8 8B 45 E8 80 78 24 00 74 64 8B 45 F8 89 45 EC 8B 45 FC 89 45 F0 8B 45 E8 8B 80 D4 00 00 00 50 8D 4D F0 8D 55 EC 8B 83 5C 02 00 00 8B 38 FF 97 A0 00 00 00 8B 4D F0 8B 55 EC 8B 45 E8 8B 38 FF 97 E0 00 00 00 8B 55 F4 89 42 04 8B 45 F4 83 78 04 FF 74 1A 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 55 F4 89 42 08 8B 45 F4 C6 00 03 E9 CC 00 00 00 4E 83 FE FF 75 81 55 8B 83 88 02 00 00 E8 ?? ?? ?? ?? 59 84 C0 0F 85 B1 00 00 00 55 8B 83 8C 02 00 00 E8 ?? ?? ?? ?? 59 84 C0 0F 85 9C 00 00 00 55 8B 83 90 02 00 00 E8 ?? ?? ?? ?? 59 84 C0 0F 85 87 00 00 00 55 8B 83 94 02 00 00 E8 ?? ?? ?? ?? 59 84 C0 75 76 55 8B 83 84 02 00 00 E8 ?? ?? ?? ?? 59 84 C0 75 65 8B 4D FC 8B 55 F8 8B 83 80 03 00 00 E8 ?? ?? ?? ?? 84 C0 74 08 8B 45 F4 C6 00 04 EB 48 8B 4D FC 8B 55 F8 8B 83 1C 03 00 00 E8 ?? ?? ?? ?? 84 C0 74 08 8B 45 F4 C6 00 05 EB 2B FF 75 FC FF 75 F8 8D 83 60 02 00 00 50 E8 ?? ?? ?? ?? 85 C0 74 15 8B 83 80 02 00 00 E8 ?? ?? ?? ?? 85 C0 7E 06 8B 45 F4 C6 00 06 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1557_0 {
	meta:
		name = "CheckZoomPanning"
		size = 204
		refs = "001a TeeZoomMouseButton 002a TeeZoomKeyShift 0039 TControl.SetCursor 0056 TZoomPanningRecord.Activate 0061 TCustomTeePanel.DrawZoomRectangle 0083 TeeScrollMouseButton 0093 TeeScrollKeyShift"
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 40 FC 80 B8 09 03 00 00 00 74 5A 8B 45 08 8A 40 FB 3A 05 ?? ?? ?? ?? 75 4C 8B 45 08 8A 40 FA F7 D0 22 05 ?? ?? ?? ?? 75 3C 8B 45 08 8B 40 FC 33 D2 E8 ?? ?? ?? ?? 8B 45 08 8B 48 08 8B 45 08 8B 50 0C 8B 45 08 8B 40 FC 8B 80 58 02 00 00 E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B 45 08 C6 40 F9 01 8B 45 08 8B 40 FC 80 B8 0A 03 00 00 00 74 4F 8B 45 08 8A 40 FB 3A 05 ?? ?? ?? ?? 75 41 8B 45 08 8A 40 FA F7 D0 22 05 ?? ?? ?? ?? 75 31 8B 45 08 8B 40 FC 33 D2 E8 ?? ?? ?? ?? 8B 45 08 8B 48 08 8B 45 08 8B 50 0C 8B 45 08 8B 40 FC 8B 80 40 02 00 00 E8 ?? ?? ?? ?? 8B 45 08 C6 40 F9 01 5D C3 }
	condition:
		$1
}

rule function_1558_0 {
	meta:
		name = "CheckBackground"
		size = 105
	strings:
		$1 = { 55 8B EC 53 8B 45 08 8B 40 FC 66 83 B8 9A 03 00 00 00 74 52 8B 45 08 8B 40 FC C6 80 00 03 00 00 01 8B 45 08 8A 40 FA 50 8B 45 08 8B 40 0C 50 8B 45 08 8B 40 08 50 8B 45 08 8B 58 FC 8B 45 08 8A 48 FB 8B 45 08 8B 50 FC 8B 83 9C 03 00 00 FF 93 98 03 00 00 8B 45 08 8B 40 FC 8A 80 00 03 00 00 8B 55 08 88 42 F9 5B 5D C3 }
	condition:
		$1
}

rule function_1559_0 {
	meta:
		name = "TCustomChart.MouseDown"
		size = 509
		refs = "0022 TControl.MouseDown 0071 Point 007f TCustomChart.CalcClickedPart 016d CheckZoomPanning 01cd CheckBackground"
	strings:
		$1 = { 55 8B EC 83 C4 E0 53 88 4D FA 88 55 FB 89 45 FC 8B 45 0C 50 8B 45 08 50 8A 4D FA 8A 55 FB 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 8B 80 58 02 00 00 80 78 04 00 0F 85 BD 01 00 00 8B 45 FC 8B 80 40 02 00 00 80 78 04 00 0F 85 AA 01 00 00 8B 45 FC 80 B8 00 03 00 00 00 74 0F 8B 45 FC C6 80 00 03 00 00 00 E9 8F 01 00 00 8D 4D E0 8B 55 08 8B 45 0C E8 ?? ?? ?? ?? 8D 55 E0 8D 4D E8 8B 45 FC E8 ?? ?? ?? ?? C6 45 F9 00 8A 45 E8 FE C8 74 19 FE C8 0F 84 DE 00 00 00 FE C8 74 5A 2C 03 0F 84 29 01 00 00 E9 38 01 00 00 8B 45 FC 66 83 B8 A2 03 00 00 00 0F 84 27 01 00 00 8B 45 FC C6 80 00 03 00 00 01 8A 45 FA 50 8B 45 0C 50 8B 45 08 50 8B 5D FC 8A 4D FB 8B 55 FC 8B 83 A4 03 00 00 FF 93 A0 03 00 00 8B 45 FC 8A 80 00 03 00 00 88 45 F9 E9 EB 00 00 00 8A 45 FB 50 8A 45 FA 50 8B 45 0C 50 8B 45 08 50 8B 4D EC 8B 5D F0 8B D3 8B C3 8B 18 FF 93 04 01 00 00 88 45 F9 8B 45 FC 66 83 B8 AA 03 00 00 00 74 3F 8B 45 FC C6 80 00 03 00 00 01 8B 45 EC 50 8A 45 FB 50 8A 45 FA 50 8B 45 0C 50 8B 45 08 50 8B 5D FC 8B 4D F0 8B 55 FC 8B 83 AC 03 00 00 FF 93 A8 03 00 00 8B 45 FC 8A 80 00 03 00 00 88 45 F9 80 7D F9 00 75 74 55 E8 ?? ?? ?? ?? 59 EB 6B 8B 45 FC 66 83 B8 92 03 00 00 00 74 3B 8B 45 FC C6 80 00 03 00 00 01 8A 45 FB 50 8A 45 FA 50 8B 45 0C 50 8B 45 08 50 8B 5D FC 8B 4D F4 8B 55 FC 8B 83 94 03 00 00 FF 93 90 03 00 00 8B 45 FC 8A 80 00 03 00 00 88 45 F9 80 7D F9 00 75 1D 55 E8 ?? ?? ?? ?? 59 EB 14 55 E8 ?? ?? ?? ?? 59 80 7D F9 00 75 07 55 E8 ?? ?? ?? ?? 59 80 7D F9 00 75 07 55 E8 ?? ?? ?? ?? 59 8B 45 FC C6 80 00 03 00 00 00 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_1560_0 {
	meta:
		name = "ProcessPanning"
		size = 147
		refs = "0014 TCustomChartAxis.CalcPosPoint 0088 TCustomChartAxis.SetMinMax"
	strings:
		$1 = { 55 8B EC 83 C4 DC 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? DD 5D DC 9B 8B D7 8B C3 E8 ?? ?? ?? ?? DC 6D DC DD 5D F8 9B DD 43 18 DC 45 F8 DD 5D F0 9B DD 43 10 DC 45 F8 DD 5D E8 9B C6 45 E7 01 8B 45 08 8B 40 FC 66 83 B8 8A 03 00 00 00 74 1F 8D 45 E8 50 8D 45 E7 50 8B 45 08 8B 70 FC 8D 4D F0 8B D3 8B 86 8C 03 00 00 FF 96 88 03 00 00 80 7D E7 00 74 13 FF 75 F4 FF 75 F0 FF 75 EC FF 75 E8 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1561_0 {
	meta:
		name = "CheckMouseSeries"
		size = 198
		refs = "0014 TCustomAxisPanel.SeriesCount 002b TCustomAxisPanel.GetSeries 006d TControl.SetCursor"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 C6 45 FF 00 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B D8 4B 85 DB 7C 5C 43 33 F6 8B 45 08 8B 40 FC 8B D6 E8 ?? ?? ?? ?? 89 45 F8 8B 45 F8 80 78 24 00 74 3C 8B 45 F8 66 83 78 38 00 74 32 8B 45 08 8B 48 08 8B 45 08 8B 50 F8 8B 45 F8 8B 38 FF 97 E0 00 00 00 40 74 18 8B 45 F8 66 8B 50 38 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? C6 45 FF 01 EB 04 46 4B 75 A7 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B D8 4B 85 DB 7C 2F 43 33 F6 8B 45 08 8B 40 08 50 8B 45 08 8B 40 FC 8B D6 E8 ?? ?? ?? ?? 8B 55 08 8B 4A F8 8B 55 08 8A 52 F7 8B 38 FF 97 00 01 00 00 46 4B 75 D4 8A 45 FF 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1562_0 {
	meta:
		name = "TCustomChart.MouseMove"
		size = 513
		refs = "0020 TControl.MouseMove 0058 TCustomTeePanel.DrawZoomRectangle 0092 Point 00a6 PtInRect 00cb TZoomPanningRecord.Check 00e2 TCustomChart.SaveScales 012f ProcessPanning 01dd CheckMouseSeries 01f4 TControl.SetCursor"
	strings:
		$1 = { 55 8B EC 83 C4 9C 53 56 57 89 4D F8 88 55 F7 89 45 FC 8B 45 08 50 8B 4D F8 8A 55 F7 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC F6 40 20 10 0F 85 C7 01 00 00 8B 45 FC 8B 98 58 02 00 00 80 7B 04 00 74 35 8B 45 F8 3B 43 10 75 0C 8B 45 08 3B 43 14 0F 84 A4 01 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 45 F8 89 43 10 8B 45 08 89 43 14 8B 45 FC E8 ?? ?? ?? ?? E9 83 01 00 00 8B 45 FC 8B B0 40 02 00 00 80 7E 04 00 0F 84 53 01 00 00 8D 4D EC 8B 55 08 8B 45 F8 E8 ?? ?? ?? ?? FF 75 F0 FF 75 EC 8B 45 FC 05 60 02 00 00 50 E8 ?? ?? ?? ?? 85 C0 0F 84 1A 01 00 00 8B 45 F8 3B 46 10 75 0C 8B 45 08 3B 46 14 0F 84 32 01 00 00 33 DB 8B C6 E8 ?? ?? ?? ?? 8B 45 FC 80 B8 2C 03 00 00 00 74 2A 8D 55 9C 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 56 8D 75 9C 8D B8 30 03 00 00 B9 14 00 00 00 F3 A5 5E 8B 45 FC C6 80 2C 03 00 00 00 8B 55 F8 3B 56 10 74 3F 8B 45 FC 8A 80 0A 03 00 00 3C 01 74 04 3C 03 75 2E 55 8B 45 FC 8B 80 8C 02 00 00 8B 4D F8 8B 56 10 E8 ?? ?? ?? ?? 59 55 8B 45 FC 8B 80 88 02 00 00 8B 4D F8 8B 56 10 E8 ?? ?? ?? ?? 59 B3 01 8B 55 08 3B 56 14 74 3F 8B 45 FC 8A 80 0A 03 00 00 3C 02 74 04 3C 03 75 2E 55 8B 45 FC 8B 80 90 02 00 00 8B 4D 08 8B 56 14 E8 ?? ?? ?? ?? 59 55 8B 45 FC 8B 80 94 02 00 00 8B 4D 08 8B 56 14 E8 ?? ?? ?? ?? 59 B3 01 8B 45 F8 89 46 10 8B 45 08 89 46 14 84 DB 74 55 8B 45 FC 66 83 B8 CA 03 00 00 00 74 12 8B 5D FC 8B 55 FC 8B 83 CC 03 00 00 FF 93 C8 03 00 00 8B 45 FC 8B 10 FF 52 78 EB 2C 8B 45 FC 8B 80 40 02 00 00 C6 40 04 00 EB 1D 55 E8 ?? ?? ?? ?? 59 84 C0 75 12 8B 45 FC 66 8B 90 3C 02 00 00 8B 45 FC E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_1563_0 {
	meta:
		name = "TCustomChart.UndoZoom"
		size = 72
		refs = "0015 TCustomChart.RestoreScales"
	strings:
		$1 = { 53 8B D8 80 BB 2C 03 00 00 00 75 0D 8D 93 30 03 00 00 8B C3 E8 ?? ?? ?? ?? C6 83 2C 03 00 00 01 66 83 BB D2 03 00 00 00 74 0E 8B D3 8B 83 D4 03 00 00 FF 93 D0 03 00 00 8B C3 8B 10 FF 52 78 C6 83 84 03 00 00 00 5B C3 }
	condition:
		$1
}

rule function_1564_0 {
	meta:
		name = "TCustomChart.CalcZoomPoints"
		size = 225
		refs = "0010 TZoomPanningRecord.Check 001e TCustomChartAxis.CalcPosPoint"
	strings:
		$1 = { 53 56 83 C4 C0 8B D8 8B B3 58 02 00 00 8B C6 E8 ?? ?? ?? ?? 8B 56 14 8B 83 90 02 00 00 E8 ?? ?? ?? ?? DD 1C 24 9B 8B 56 0C 8B 83 90 02 00 00 E8 ?? ?? ?? ?? DD 5C 24 08 9B 8B 56 14 8B 83 94 02 00 00 E8 ?? ?? ?? ?? DD 5C 24 10 9B 8B 56 0C 8B 83 94 02 00 00 E8 ?? ?? ?? ?? DD 5C 24 18 9B 8B 56 08 8B 83 88 02 00 00 E8 ?? ?? ?? ?? DD 5C 24 20 9B 8B 56 10 8B 83 88 02 00 00 E8 ?? ?? ?? ?? DD 5C 24 28 9B 8B 56 08 8B 83 8C 02 00 00 E8 ?? ?? ?? ?? DD 5C 24 30 9B 8B 56 10 8B 83 8C 02 00 00 E8 ?? ?? ?? ?? DD 5C 24 38 9B 8D 44 24 30 50 8D 44 24 3C 50 8D 44 24 08 50 8D 44 24 14 50 8D 44 24 20 50 8D 44 24 2C 50 8D 4C 24 40 8D 54 24 38 8B C3 8B 18 FF 93 00 01 00 00 83 C4 40 5E 5B C3 }
	condition:
		$1
}

rule function_1565_0 {
	meta:
		name = "TCustomChart.MouseUp"
		size = 262
		refs = "0022 TControl.MouseUp 0029 TCustomAxisPanel.SeriesCount 004a TCustomAxisPanel.GetSeries 0077 TeeZoomMouseButton 0086 TCustomTeePanel.DrawZoomRectangle 0096 TPen.SetMode"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 88 4D FE 88 55 FF 8B D8 8B 45 0C 50 8B 45 08 50 8A 4D FE 8A 55 FF 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B F0 4E 85 F6 7C 2E 46 C7 45 F8 00 00 00 00 8B 45 0C 50 8B 45 08 50 8B 55 F8 8B C3 E8 ?? ?? ?? ?? 8A 4D FE 8A 55 FF 8B 38 FF 97 08 01 00 00 FF 45 F8 4E 75 DA 8B 83 58 02 00 00 80 78 04 00 0F 84 81 00 00 00 8A 55 FF 3A 15 ?? ?? ?? ?? 75 76 8B F0 C6 46 04 00 8B C3 E8 ?? ?? ?? ?? 8B 83 5C 02 00 00 8B 40 0C B2 04 E8 ?? ?? ?? ?? 8B 45 0C 89 46 10 8B 45 08 89 46 14 8B 46 10 2B 46 08 99 33 C2 2B C2 83 F8 10 7E 3D 8B 46 14 2B 46 0C 99 33 C2 2B C2 83 F8 10 7E 2D 8B 46 10 3B 46 08 7E 14 8B 46 14 3B 46 0C 7E 0C 8B C3 8B 10 FF 92 FC 00 00 00 EB 0A 8B C3 8B 10 FF 92 14 01 00 00 8B C3 8B 10 FF 52 78 8B 83 40 02 00 00 C6 40 04 00 5F 5E 5B 59 59 5D C2 08 00 }
	condition:
		$1
}

rule function_1566_0 {
	meta:
		name = "TCustomChart.WMGetDlgCode"
		size = 16
	strings:
		$1 = { 56 8B F2 8B D6 8B 08 FF 51 F0 83 4E 0C 01 5E C3 }
	condition:
		$1
}

rule function_1567_0 {
	meta:
		name = "AxisRect"
		size = 101
		refs = "0014 TCustomAxisPanel.IsAxisVisible 0032 TCustomChartAxis.CalcRect 0046 IntersectRect"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 8B D8 8B 45 08 8B 40 FC 8B D3 E8 ?? ?? ?? ?? 84 C0 74 42 8B 45 08 8D 70 EC 8D 7D F0 B9 04 00 00 00 F3 A5 8D 55 F0 8B C3 E8 ?? ?? ?? ?? 8D 45 F0 50 8B 45 08 83 C0 EC 50 8D 45 F0 50 E8 ?? ?? ?? ?? 85 C0 74 10 8B 45 08 8D 78 EC 8D 75 F0 B9 04 00 00 00 F3 A5 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1568_0 {
	meta:
		name = "TCustomChart.CalcAxisRect"
		size = 302
		refs = "0018 TCustomChartAxis.AdjustMaxMin 0053 TCustomAxisPanel.CalcSize3DWalls 00ad TCustomTeePanel.ReCalcWidthHeight 00cd AxisRect"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 89 45 FC 8D 5D FC 8B 03 8B 80 90 02 00 00 E8 ?? ?? ?? ?? 8B 03 8B 80 94 02 00 00 E8 ?? ?? ?? ?? 8B 03 8B 80 88 02 00 00 E8 ?? ?? ?? ?? 8B 03 8B 80 8C 02 00 00 E8 ?? ?? ?? ?? 8B 03 8B 80 84 02 00 00 E8 ?? ?? ?? ?? 8B 03 E8 ?? ?? ?? ?? 8B 03 80 B8 4C 02 00 00 00 74 48 8B 03 8B 80 50 02 00 00 80 78 0C 00 74 3A 8B 03 80 B8 98 02 00 00 00 74 0D 8B 03 8B 80 14 03 00 00 8B 40 10 EB 02 33 C0 8B 13 81 C2 60 02 00 00 8B 0B 8B 89 54 02 00 00 03 C8 29 4A 08 8B 0B 03 81 28 02 00 00 01 42 04 8B 03 E8 ?? ?? ?? ?? 8B 03 8D B0 60 02 00 00 8D 7D EC B9 04 00 00 00 F3 A5 55 8B 03 8B 80 90 02 00 00 E8 ?? ?? ?? ?? 59 55 8B 03 8B 80 94 02 00 00 E8 ?? ?? ?? ?? 59 55 8B 03 8B 80 88 02 00 00 E8 ?? ?? ?? ?? 59 55 8B 03 8B 80 8C 02 00 00 E8 ?? ?? ?? ?? 59 55 8B 03 8B 80 84 02 00 00 E8 ?? ?? ?? ?? 59 8B 03 8D B8 60 02 00 00 8D 75 EC B9 04 00 00 00 F3 A5 8B 03 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1569_0 {
	meta:
		name = "CalcSeriesAxisRect"
		size = 249
		refs = "0018 Rect 0023 TCustomAxisPanel.SeriesCount 0044 TCustomAxisPanel.GetSeries 0063 TChartSeries.GetHorizAxis 0083 MaxLong 00a9 TChartSeries.GetVertAxis 00ef TCustomChartAxis.AdjustMaxMinRect"
	strings:
		$1 = { 55 8B EC 83 C4 E0 53 56 89 45 FC 6A 00 8D 45 E0 50 33 C9 33 D2 33 C0 E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B F0 4E 85 F6 0F 8C B6 00 00 00 46 C7 45 F0 00 00 00 00 8B 45 08 8B 40 FC 8B 55 F0 E8 ?? ?? ?? ?? 8B D8 80 7B 24 00 0F 84 8A 00 00 00 8B 45 FC 80 B8 86 00 00 00 00 74 3A 8B C3 E8 ?? ?? ?? ?? 3B 45 FC 75 2E 8D 4D F4 8D 55 F8 8B C3 8B 18 FF 93 1C 01 00 00 8B 55 F8 8B 45 E0 E8 ?? ?? ?? ?? 89 45 E0 8B 55 F4 8B 45 E8 E8 ?? ?? ?? ?? 89 45 E8 EB 44 8B 45 FC 80 B8 86 00 00 00 00 75 38 8B C3 E8 ?? ?? ?? ?? 3B 45 FC 75 2C 8D 4D F4 8D 55 F8 8B C3 8B 18 FF 93 20 01 00 00 8B 55 F8 8B 45 E4 E8 ?? ?? ?? ?? 89 45 E4 8B 55 F4 8B 45 EC E8 ?? ?? ?? ?? 89 45 EC FF 45 F0 4E 0F 85 52 FF FF FF 8D 55 E0 8B 45 FC E8 ?? ?? ?? ?? 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1570_0 {
	meta:
		name = "TCustomChart.CalcSeriesRect"
		size = 74
		refs = "0012 CalcSeriesAxisRect"
	strings:
		$1 = { 55 8B EC 51 89 45 FC 55 8B 45 FC 8B 80 88 02 00 00 E8 ?? ?? ?? ?? 59 55 8B 45 FC 8B 80 90 02 00 00 E8 ?? ?? ?? ?? 59 55 8B 45 FC 8B 80 94 02 00 00 E8 ?? ?? ?? ?? 59 55 8B 45 FC 8B 80 8C 02 00 00 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule function_1571_0 {
	meta:
		name = "TCustomChart.Assign"
		size = 212
		refs = "000b _DV_TCustomChart 0010 @IsClass 0094 TCustomChart.SetAnimatedZoom 00a1 TCustomChart.SetAnimatedZoomSteps 00cc TCustomAxisPanel.Assign"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 AB 00 00 00 8B FE 8B 97 14 03 00 00 8B 83 14 03 00 00 8B 08 FF 51 08 8B 97 18 03 00 00 8B 83 18 03 00 00 8B 08 FF 51 08 8B 97 20 03 00 00 8B 83 20 03 00 00 8B 08 FF 51 08 8B 97 24 03 00 00 8B 83 24 03 00 00 8B 08 FF 51 08 8B 97 28 03 00 00 8B 83 28 03 00 00 8B 08 FF 51 08 8A 87 0A 03 00 00 88 83 0A 03 00 00 8A 87 09 03 00 00 88 83 09 03 00 00 8A 97 08 03 00 00 8B C3 E8 ?? ?? ?? ?? 8B 97 04 03 00 00 8B C3 E8 ?? ?? ?? ?? 8B 97 1C 03 00 00 8B 83 1C 03 00 00 8B 08 FF 51 08 8B 97 80 03 00 00 8B 83 80 03 00 00 8B 08 FF 51 08 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1572_0 {
	meta:
		name = "TCustomChart.ExchangeSeries"
		size = 99
		refs = "0015 TList.Exchange 001e TCustomAxisPanel.GetSeries 0023 TComponent.GetComponentIndex 0043 TComponent.SetComponentIndex"
	strings:
		$1 = { 53 56 57 55 8B F9 8B F2 8B D8 8B CF 8B D6 8B 83 80 02 00 00 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B E8 8B D7 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8B D6 8B C3 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B D7 8B C3 E8 ?? ?? ?? ?? 8B D5 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 7C 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1573_0 {
	meta:
		name = "TCustomChart.GetPalette"
		size = 57
		refs = "001c _Dn_TBitmap 0021 @IsClass"
	strings:
		$1 = { 53 56 57 8B D8 33 FF 8B B3 10 03 00 00 85 F6 74 22 83 7E 04 00 74 1C 8B 46 04 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0A 8B 46 04 8B 10 FF 52 24 8B F8 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1575_0 {
	meta:
		name = "TCustomChart.FillValueSourceItems"
		size = 102
		refs = "000c TChartSeries.GetDataSource 001d _Dn_TChartSeries 0022 @IsClass 004e TChartValueLists.GetValueList"
	strings:
		$1 = { 55 8B EC 51 53 56 8B 5A 2C 8B C3 E8 ?? ?? ?? ?? 85 C0 74 4B 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 35 8B C3 E8 ?? ?? ?? ?? 89 45 FC 8B 45 FC 8B 40 6C 8B 58 08 4B 85 DB 7C 1D 43 33 F6 8B 45 FC 8B 40 6C 8B D6 E8 ?? ?? ?? ?? 8B 50 24 8B 45 0C FF 55 08 46 4B 75 E6 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_1576_0 {
	meta:
		name = "TCustomChartLegend.Create"
		size = 188
		refs = "000a @ClassCreate 0017 TChartFontObject.Create 0031 _Dn_TChartPen 0036 TChartPen.Create 0040 TCustomChartLegend.GetParentChart 007e _Dn_TChartHiddenPen 0083 TChartHiddenPen.Create 00a9 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? C6 46 2C 01 C6 46 2D 01 C6 46 50 00 C7 46 20 FF FF FF 00 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 24 8B C6 E8 ?? ?? ?? ?? 8B 56 24 89 42 08 8B 00 8B 80 C0 00 00 00 89 42 04 C6 46 0E 01 C6 46 0D 00 C7 46 10 0C 00 00 00 C7 46 1C 0A 00 00 00 C6 46 0C 01 33 C0 89 46 30 C7 46 34 03 00 00 00 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 38 8B C6 E8 ?? ?? ?? ?? 8B 56 38 89 42 08 8B 00 8B 80 C0 00 00 00 89 42 04 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1577_0 {
	meta:
		name = "TCustomChartLegend.Destroy"
		size = 53
		refs = "0003 @BeforeDestruction 000f TObject.Free 0023 TChartFontObject.Destroy 002e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 38 E8 ?? ?? ?? ?? 8B 46 24 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1578_0 {
	meta:
		name = "TCustomChartLegend.Assign"
		size = 120
		refs = "000a _DV_TCustomChartLegend 000f @IsClass 0071 TChartFontObject.Assign"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 55 8B C6 8A 50 2C 88 53 2C 8A 50 0D 88 53 0D 8B 50 28 89 53 28 8A 50 2D 88 53 2D 8A 50 0E 88 53 0E 8B 50 10 89 53 10 8B 50 14 89 53 14 8B 50 18 89 53 18 8A 50 0C 88 53 0C 8A 50 2E 88 53 2E 8B 50 1C 89 53 1C 8B 50 20 89 53 20 8B 50 24 8B 43 24 8B 08 FF 51 08 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1579_0 {
	meta:
		name = "TCustomChartLegend.SetVisible"
		size = 26
		refs = "0009 TCustomChartLegend.GetParentChart 0013 TCustomTeePanel.SetBooleanProperty"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8D 56 2C 8B CB E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1580_0 {
	meta:
		name = "TCustomChartLegend.SetInverted"
		size = 26
		refs = "0009 TCustomChartLegend.GetParentChart 0013 TCustomTeePanel.SetBooleanProperty"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8D 56 2E 8B CB E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1581_0 {
	meta:
		name = "TCustomChartLegend.SetAlignment"
		size = 14
		refs = "0009 TChartFontObject.Repaint"
	strings:
		$1 = { 3A 50 2D 74 08 88 50 2D E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1585_0 {
	meta:
		name = "TCustomChartLegend.SetTopLeftPos"
		size = 120
		refs = "000f TCustomChartLegend.SetTopLeftPos 0026 TeeMsg_LegendTopPos 002b LoadResString 0035 _DV_LegendException 003a Exception.Create 003f @RaiseExcept 0048 TCustomChartLegend.GetParentChart 0052 TCustomTeePanel.SetIntegerProperty 0067 @LStrClr 006d @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B DA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 DB 7C 05 83 FB 64 7E 23 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 11 8B C6 E8 ?? ?? ?? ?? 8D 56 1C 8B CB E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1586_0 {
	meta:
		name = "TCustomChartLegend.SetFirstValue"
		size = 115
		refs = "000f TCustomChartLegend.SetFirstValue 0021 TeeMsg_LegendFirstValue 0026 LoadResString 0030 _DV_LegendException 0035 Exception.Create 003a @RaiseExcept 0043 TCustomChartLegend.GetParentChart 004d TCustomTeePanel.SetLongintProperty 0062 @LStrClr 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 F6 7D 23 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 11 8B C3 E8 ?? ?? ?? ?? 8D 53 28 8B CE E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1587_0 {
	meta:
		name = "TCustomChartLegend.SetTextStyle"
		size = 14
		refs = "0009 TChartFontObject.Repaint"
	strings:
		$1 = { 3A 50 0E 74 08 88 50 0E E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1588_0 {
	meta:
		name = "TCustomChartLegend.SetLegendStyle"
		size = 27
		refs = "000e TCustomChartLegend.CalcLegendStyle 0015 TChartFontObject.Repaint"
	strings:
		$1 = { 53 8B D8 3A 53 0D 74 11 88 53 0D 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1589_0 {
	meta:
		name = "TCustomChartLegend.SetHorizMargin"
		size = 26
		refs = "0009 TCustomChartLegend.GetParentChart 0013 TCustomTeePanel.SetIntegerProperty"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8D 53 14 8B CE E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1590_0 {
	meta:
		name = "TCustomChartLegend.SetVertMargin"
		size = 26
		refs = "0009 TCustomChartLegend.GetParentChart 0013 TCustomTeePanel.SetIntegerProperty"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8D 53 18 8B CE E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1591_0 {
	meta:
		name = "TCollectionItem.GetOwner"
		size = 4
		altNames = "TComponent.GetOwner TCustomChartLegend.GetParentChart TQRMerger.GetOrgLines"
	strings:
		$1 = { 8B 40 04 C3 }
	condition:
		$1
}

rule function_1592_0 {
	meta:
		name = "TCustomChartLegend.SetResizeChart"
		size = 26
		refs = "0009 TCustomChartLegend.GetParentChart 0013 TCustomTeePanel.SetBooleanProperty"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8D 56 0C 8B CB E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1593_0 {
	meta:
		name = "TCustomChartLegend.SetColor"
		size = 26
		refs = "0009 TCustomChartLegend.GetParentChart 0013 TCustomTeePanel.SetColorProperty"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8D 53 20 8B CE E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1594_0 {
	meta:
		name = "TCustomChartLegend.SetColorWidth"
		size = 120
		refs = "000f TCustomChartLegend.SetColorWidth 0026 TeeMsg_LegendColorWidth 002b LoadResString 0035 _DV_LegendException 003a Exception.Create 003f @RaiseExcept 0048 TCustomChartLegend.GetParentChart 0052 TCustomTeePanel.SetIntegerProperty 0067 @LStrClr 006d @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B DA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 DB 7C 05 83 FB 64 7E 23 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 11 8B C6 E8 ?? ?? ?? ?? 8D 56 10 8B CB E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1595_0 {
	meta:
		name = "TCustomChartLegend.CalcLegendStyle"
		size = 48
		refs = "000d TCustomChartLegend.GetParentChart 0018 TChartSeriesList.CountActive"
	strings:
		$1 = { 53 8B D8 8A 43 0D 84 C0 75 21 8B C3 E8 ?? ?? ?? ?? 8B 80 80 02 00 00 E8 ?? ?? ?? ?? 48 7E 06 C6 43 50 01 EB 09 C6 43 50 02 5B C3 88 43 50 5B C3 }
	condition:
		$1
}

rule function_1596_0 {
	meta:
		name = "TCustomChartLegend.FormattedLegend"
		size = 125
		refs = "000e TCustomChartLegend.GetParentChart 002d TCustomAxisPanel.SeriesTitleLegend 003a TCustomAxisPanel.GetASeries 0057 TCustomAxisPanel.GetSeries 005c TChartSeries.Count"
	strings:
		$1 = { 53 56 57 51 89 0C 24 8B FA 8B D8 8B C3 E8 ?? ?? ?? ?? 8B F0 8A 43 50 FE C8 74 0A FE C8 74 14 FE C8 74 2B EB 53 8B 0C 24 8B D7 8B C6 E8 ?? ?? ?? ?? EB 45 8B 04 24 50 8B C6 E8 ?? ?? ?? ?? 8B D0 8B CF 8B C6 8B 18 FF 93 F8 00 00 00 EB 2A 8B 04 24 50 8B D7 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 50 8B D7 8B C6 E8 ?? ?? ?? ?? 8B D0 8B C6 59 8B 18 FF 93 F8 00 00 00 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1597_0 {
	meta:
		name = "TCustomChartLegend.SetShadowColor"
		size = 26
		refs = "0009 TCustomChartLegend.GetParentChart 0013 TCustomTeePanel.SetColorProperty"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8D 53 30 8B CE E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1598_0 {
	meta:
		name = "TCustomChartLegend.SetShadowSize"
		size = 26
		refs = "0009 TCustomChartLegend.GetParentChart 0013 TCustomTeePanel.SetIntegerProperty"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8D 53 34 8B CE E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1599_0 {
	meta:
		name = "TCustomChartAxis.SetGrid"
		size = 9
		altNames = "TCustomChartLegend.SetDividingLines"
	strings:
		$1 = { 8B 40 38 8B 08 FF 51 08 C3 }
	condition:
		$1
}

rule function_1600_0 {
	meta:
		name = "CalcMaxLegendValues"
		size = 114
		refs = "0013 TCustomChartLegend.GetParentChart 0032 TPen.GetWidth 0058 TCustomChartLegend.TotalLegendItems 0061 MinLong"
	strings:
		$1 = { 55 8B EC 53 56 57 8B F9 8B F2 8B D8 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B 45 08 3B 58 F8 7E 4A 8B 45 08 83 78 F4 00 7E 41 8B 45 08 8B 40 FC 8B 40 24 E8 ?? ?? ?? ?? 03 C0 50 8B C6 5A 2B C2 8B 55 08 2B 42 F8 03 C7 8B 55 08 8B 4A F4 99 F7 F9 8B D8 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 8B D8 EB 02 33 DB 8B C3 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule function_1601_0 {
	meta:
		name = "TCustomChartLegend.MaxLegendValues"
		size = 91
		refs = "0014 TCustomChartLegend.GetParentChart 001e TCustomChartLegend.GetVertical 003a CalcMaxLegendValues"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 89 4D F4 89 55 F8 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 8B D8 8B 45 FC E8 ?? ?? ?? ?? 84 C0 74 1B 55 8B 8B 64 02 00 00 8B 93 18 02 00 00 8B 83 6C 02 00 00 E8 ?? ?? ?? ?? 59 EB 15 55 33 C9 8B 93 14 02 00 00 8B 83 68 02 00 00 E8 ?? ?? ?? ?? 59 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1602_0 {
	meta:
		name = "TCustomChartLegend.TotalLegendItems"
		size = 134
		refs = "0016 TCustomChartLegend.GetParentChart 001b TCustomAxisPanel.SeriesCount 0033 TCustomAxisPanel.GetSeries 0055 TCustomAxisPanel.GetASeries 0079 MaxLong"
	strings:
		$1 = { 53 56 57 55 8B D8 33 FF 8A 43 50 3C 01 74 04 3C 03 75 3A 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 4E 85 F6 7C 22 46 33 ED 8B C3 E8 ?? ?? ?? ?? 8B D5 E8 ?? ?? ?? ?? 80 78 24 00 74 07 80 78 5C 00 74 01 47 45 4E 75 E1 2B 7B 28 EB 27 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 85 F6 74 15 80 7E 5C 00 74 0F 8B C6 8B 10 FF 92 94 00 00 00 8B F8 2B 7B 28 8B D7 33 C0 E8 ?? ?? ?? ?? 8B F8 8B C7 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1603_0 {
	meta:
		name = "TCustomChartLegend.MaxLegendWidth"
		size = 172
		refs = "0017 TCustomChartLegend.MaxLegendWidth 002c TCustomChartLegend.TotalLegendItems 0042 TCustomChartLegend.GetParentChart 0060 TCustomChart.FormattedLegend 007a MaxLong 0097 @LStrClr 009d @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 33 C9 89 4D F0 89 55 FC 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 F6 83 7D FC FF 75 0F 8B C3 E8 ?? ?? ?? ?? 8B F8 03 7B 28 4F EB 07 8B 7B 28 03 7D FC 4F 8B C3 E8 ?? ?? ?? ?? 89 45 F4 8B 43 28 8B DF 2B D8 7C 34 43 89 45 F8 8D 4D F0 8B 55 F8 8B 45 F4 E8 ?? ?? ?? ?? 8B 55 F0 8B 45 F4 8B 80 5C 02 00 00 8B 08 FF 51 60 8B D0 8B C6 E8 ?? ?? ?? ?? 8B F0 FF 45 F8 4B 75 D0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1604_0 {
	meta:
		name = "TCustomChartLegend.GetColorRect"
		size = 48
	strings:
		$1 = { 55 8B EC 51 53 89 4D FC 8B 5D 08 8B CA 2B 48 3C 89 0B 03 48 3C 89 4B 08 8B 45 FC 83 C0 02 89 43 04 8B 45 0C 83 E8 02 89 43 0C 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_1605_0 {
	meta:
		name = "TCustomChartLegend.GetVertical"
		size = 18
	strings:
		$1 = { 8A 50 2D 84 D2 74 08 80 FA 01 74 03 33 C0 C3 B0 01 C3 }
	condition:
		$1
}

rule function_1606_0 {
	meta:
		name = "DrawLegendItem"
		size = 628
		refs = "0018 DrawLegendItem 0029 TCustomChartLegend.TotalLegendItems 003d TCustomChartLegend.GetParentChart 004f TBrush.SetStyle 0060 TBrush.SetColor 0081 TCustomChartLegend.GetVertical 0106 TCustomChart.FormattedLegend 0143 TCustomChartLegend.GetColorRect 0161 TCustomAxisPanel.ActiveSeriesLegend 0261 @LStrClr 0267 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 DC 53 56 57 33 C9 89 4D EC 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 3B 45 F8 0F 8E 1A 02 00 00 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 8B D8 8B B3 5C 02 00 00 33 D2 8B 46 10 E8 ?? ?? ?? ?? 8B 45 08 8B 40 F8 8B 50 20 8B 46 10 E8 ?? ?? ?? ?? 8B 45 08 8B 40 F4 89 45 F4 8B 45 08 8B 40 F8 8B 40 44 40 89 45 F0 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 84 C0 74 0E 8B 45 08 8B 40 F0 F7 6D F8 01 45 F0 EB 27 8B 45 08 FF 70 E8 8B 45 F8 5A 8B CA 99 F7 F9 8B 45 08 8B 40 EC 8B 4D 08 8B 49 F8 03 41 3C 83 C0 04 0F AF D0 01 55 F4 66 83 BB B2 03 00 00 00 74 2B 8D 45 F4 50 8D 45 F0 50 8B 45 08 83 C0 FC 50 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 8B D0 8B 4D FC 8B 83 B4 03 00 00 FF 93 B0 03 00 00 B2 01 8B 46 10 E8 ?? ?? ?? ?? 8D 4D EC 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 83 7D EC 00 0F 84 B1 00 00 00 8B 45 EC 50 8B 4D F0 8B 55 F4 8B C6 8B 38 FF 57 5C 8B 45 08 8B 40 F0 03 45 F0 50 8D 45 DC 50 8B 55 F4 83 EA 04 8B 45 08 8B 40 F8 8B 4D F0 E8 ?? ?? ?? ?? 8B 45 08 8B 40 F8 8A 40 50 3C 01 74 07 8B 55 08 3C 03 75 1A 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 8D 4D DC 83 CA FF 8B 38 FF 97 10 01 00 00 EB 50 8B 45 08 83 78 E4 00 74 26 8B 45 08 8B 40 E4 8B 55 FC 8B 08 FF 91 A8 00 00 00 8B D0 8D 4D DC 8B 45 08 8B 40 E4 8B 38 FF 97 10 01 00 00 EB 21 BA FF FF FF 00 8B 46 10 E8 ?? ?? ?? ?? 33 D2 8B 46 10 E8 ?? ?? ?? ?? 8D 55 DC 8B C6 8B 08 FF 51 70 83 7D F8 00 0F 8E 81 00 00 00 8B 45 08 8B 40 F8 8B 40 38 80 78 18 00 74 72 8B 45 08 8B 40 F8 8B 50 38 8B 83 5C 02 00 00 8B 40 0C 8B 08 FF 51 08 B2 01 8B 83 5C 02 00 00 8B 08 FF 51 1C 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 84 C0 74 1F 8B 45 F0 50 8B 45 08 8B 40 F8 8B 48 48 8B 45 08 8B 40 F8 8B 50 40 8B C6 8B 18 FF 53 6C EB 20 8B 45 08 8B 40 F8 8B 40 4C 50 8B 45 08 8B 40 F8 8B 48 44 8B 55 DC 83 EA 04 8B C6 8B 18 FF 53 74 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1607_0 {
	meta:
		name = "DrawLegendBackground"
		size = 302
		refs = "0023 TCustomChartLegend.GetParentChart 0039 TTeeCanvas.AssignVisiblePen 0050 TPen.GetColor 0061 TPen.SetColor 0078 InflateRect 00ad TBrush.SetStyle 00ca TBrush.SetColor 00fe Rect"
	strings:
		$1 = { 55 8B EC 83 C4 E0 53 56 57 8B 45 08 8B 40 F8 8D 70 40 8D 7D F0 B9 04 00 00 00 F3 A5 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 8B B0 5C 02 00 00 8B 45 08 8B 40 F8 8B 50 24 8B C6 E8 ?? ?? ?? ?? 8B 45 08 8B 40 F8 8B 40 24 80 78 18 00 74 51 8B 46 0C E8 ?? ?? ?? ?? 3D 00 00 00 80 75 0A 33 D2 8B 46 0C E8 ?? ?? ?? ?? 8B 45 08 8B 40 E0 50 8B 45 08 8B 40 E0 50 8D 45 F0 50 E8 ?? ?? ?? ?? 8B 45 08 8B 40 F8 8B 78 34 8B 45 08 03 78 E0 8B 45 08 8B 40 E0 48 D1 F8 79 03 83 D0 00 03 F8 EB 0A 8B 45 08 8B 40 F8 8B 78 34 4F 33 D2 8B 46 10 E8 ?? ?? ?? ?? 8B 45 08 8B 40 F8 83 78 34 00 7E 4F 8B 45 08 8B 40 F8 8B 50 30 8B 46 10 E8 ?? ?? ?? ?? 8B 45 08 8B 40 F8 8D 58 40 8B 43 0C 03 C7 50 8D 45 E0 50 8B 4B 08 03 CF 8B 45 08 8B 40 F8 8B 50 34 03 53 04 8B 45 08 8B 40 F8 8B 40 34 03 03 E8 ?? ?? ?? ?? 8D 55 E0 8B C6 8B 08 FF 51 3C 8B 45 08 8B 40 F8 8B 50 20 8B 46 10 E8 ?? ?? ?? ?? 8D 55 F0 8B C6 8B 08 FF 51 70 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1608_0 {
	meta:
		name = "CalcHorizontalColsRows"
		size = 77
	strings:
		$1 = { 55 8B EC 53 8B 45 08 8B 48 EC 8B 45 08 8B 40 F8 03 48 3C 83 C1 08 8B 45 08 8B 40 F8 BA 08 00 00 00 8B 18 FF 53 0C 8B 55 08 89 42 E8 8B 45 08 83 78 E8 00 7E 0D 8B 45 08 C7 40 DC 01 00 00 00 5B 5D C3 8B 45 08 33 D2 89 50 DC 5B 5D C3 }
	condition:
		$1
}

rule function_1609_0 {
	meta:
		name = "CalcHorizMargin"
		size = 50
		refs = "0019 TCustomChartLegend.GetParentChart 0027 MulDiv"
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 40 F8 8B 40 14 85 C0 75 1D 6A 64 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 8B 80 14 02 00 00 50 6A 03 E8 ?? ?? ?? ?? 5D C3 8B 55 08 5D C3 }
	condition:
		$1
}

rule function_1610_0 {
	meta:
		name = "CalcVertMargin"
		size = 50
		refs = "0019 TCustomChartLegend.GetParentChart 0027 MulDiv"
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 40 F8 8B 40 18 85 C0 75 1D 6A 64 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 8B 80 18 02 00 00 50 6A 04 E8 ?? ?? ?? ?? 5D C3 8B 55 08 5D C3 }
	condition:
		$1
}

rule function_1611_0 {
	meta:
		name = "TCustomChartLegend.Draw"
		size = 1224
		refs = "0010 TCustomChartLegend.CalcLegendStyle 0018 TCustomChartLegend.GetParentChart 0041 TTeeCanvas.FontHeight 004f TCustomChartLegend.MaxLegendWidth 006a TCustomChartLegend.Draw 006f @ROUND 0080 TPen.GetWidth 00bf CalcHorizontalColsRows 02b9 MinLong 0379 DrawLegendBackground 0398 TPen.SetColor 03ac TPen.SetStyle 03b8 TPen.SetWidth 03bf TCustomAxisPanel.GetASeries 03ee DrawLegendItem 0484 CalcHorizMargin 049b CalcVertMargin 04b2 TCustomTeePanel.ReCalcWidthHeight"
	strings:
		$1 = { 55 8B EC 83 C4 C4 53 56 57 89 45 F8 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 8B D8 8B 45 F8 8B 40 20 89 83 FC 02 00 00 8B 45 F8 8B 50 08 8B C3 8B 08 FF 91 C8 00 00 00 8B 83 5C 02 00 00 E8 ?? ?? ?? ?? 89 45 F0 83 CA FF 8B 45 F8 E8 ?? ?? ?? ?? 83 C0 04 89 45 EC 8B 45 F8 8B 40 10 F7 6D EC 89 45 C4 DB 45 C4 D8 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 89 42 3C 8B 45 F8 8B 40 24 E8 ?? ?? ?? ?? 89 45 E0 8B 45 F8 8D 70 40 8B 45 F8 8A 40 2D 2C 02 74 44 FE C8 75 77 8B 45 F8 8B 93 6C 02 00 00 2B 50 34 89 56 0C 8B 45 F8 8B 40 24 80 78 18 00 74 07 8B 45 E0 40 29 46 0C 55 E8 ?? ?? ?? ?? 59 8B 46 0C 83 E8 02 8B 55 F0 0F AF 55 DC 2B C2 89 46 04 E9 93 00 00 00 8B 83 64 02 00 00 89 46 04 8B 45 F8 8B 40 24 80 78 18 00 74 07 8B 45 E0 40 01 46 04 55 E8 ?? ?? ?? ?? 59 8B 46 04 83 C0 02 8B 55 F0 0F AF 55 DC 03 C2 89 46 0C EB 5C 8B 45 F8 DB 40 1C D8 0D ?? ?? ?? ?? 8B 83 10 02 00 00 8B BB 08 02 00 00 2B C7 89 45 C4 DB 45 C4 DE C9 D8 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 03 C7 89 46 04 C7 45 E8 01 00 00 00 8B 56 04 8B 4D F0 8B 45 F8 8B 38 FF 57 0C 89 45 DC 8B 46 04 83 C0 02 8B 55 F0 0F AF 55 DC 03 C2 89 46 0C 33 F6 8B 45 F8 8D 78 40 8B 45 F8 8A 40 2D 2C 01 72 14 0F 84 88 00 00 00 48 2C 02 0F 82 06 01 00 00 E9 94 01 00 00 8B 55 DC 8B 45 F8 E8 ?? ?? ?? ?? 89 45 EC 8B 83 60 02 00 00 89 07 8B 45 F8 8B 40 24 80 78 18 00 74 06 8B 45 E0 40 01 07 8B 07 83 C0 04 89 45 FC 8B 45 FC 83 C0 04 03 45 EC 83 C0 02 2B 07 8B 55 F8 F7 6A 10 89 45 C4 DB 45 C4 D8 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 8B 45 F8 89 70 3C 03 75 FC 83 C6 04 89 75 F4 8B 45 F4 03 45 EC 83 C0 02 89 47 08 8B 75 DC E9 1A 01 00 00 8B 55 DC 8B 45 F8 E8 ?? ?? ?? ?? 89 45 EC 8B 83 68 02 00 00 89 47 08 8B 45 F8 8B 40 24 80 78 18 00 74 07 8B 45 E0 40 29 47 08 8B 45 F8 8B 40 34 29 47 08 8B 47 08 2B 45 EC 83 E8 02 89 45 F4 8B 47 08 8B 55 F4 83 EA 04 83 EA 04 2B C2 8B 55 F8 F7 6A 10 89 45 C4 DB 45 C4 D8 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 8B 45 F8 89 70 3C 8B 45 F4 2B C6 83 E8 04 89 45 FC 8B 45 FC 83 E8 04 89 07 8B 75 DC E9 93 00 00 00 8B 45 F8 8B 70 3C 03 75 EC 83 C6 04 0F AF 75 E8 83 C6 08 8B 45 F8 8B 50 34 03 D2 03 D6 8B 83 14 02 00 00 E8 ?? ?? ?? ?? 8B F0 8B 45 F8 DB 40 1C D8 0D ?? ?? ?? ?? 8B 83 0C 02 00 00 2B 83 04 02 00 00 2B C6 89 45 C4 DB 45 C4 DE C9 D8 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? D1 FE 79 03 83 D6 00 8B 93 1C 02 00 00 2B D6 03 D0 89 17 03 B3 1C 02 00 00 03 C6 89 47 08 8B 07 83 C0 04 89 45 FC 8B 45 F8 8B 40 3C 03 45 FC 83 C0 04 89 45 F4 8B 75 E8 0F AF 75 DC 66 83 BB BA 03 00 00 00 74 3D 8B 45 F8 56 8D 70 40 8D 7D C8 B9 04 00 00 00 F3 A5 5E 8B 45 F8 E8 ?? ?? ?? ?? 8B D0 8D 4D C8 8B 83 BC 03 00 00 FF 93 B8 03 00 00 8B 45 F8 56 8D 78 40 8D 75 C8 B9 04 00 00 00 F3 A5 5E 85 F6 0F 8E 3F 01 00 00 55 E8 ?? ?? ?? ?? 59 8B 83 5C 02 00 00 8B 78 0C 8B 45 F8 83 78 20 00 75 0E BA FF FF FF 00 8B C7 E8 ?? ?? ?? ?? EB 09 33 D2 8B C7 E8 ?? ?? ?? ?? 33 D2 8B C7 E8 ?? ?? ?? ?? BA 01 00 00 00 8B C7 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 89 45 E4 8B 45 F8 8B 40 28 03 F0 4E 89 75 D8 8B 55 F8 80 7A 2E 00 74 1E 8B 75 D8 8B F8 2B FE 7F 34 4F 55 8B 55 D8 2B D6 8B C6 E8 ?? ?? ?? ?? 59 4E 47 75 EE EB 1F 8B F0 8B 7D D8 2B FE 7C 16 47 55 8B 45 F8 8B D6 2B 50 28 8B C6 E8 ?? ?? ?? ?? 59 46 4F 75 EB 8D B3 60 02 00 00 8B 45 F8 80 78 0C 00 74 45 8B 45 F8 8A 40 2D 2C 01 72 0C 74 14 FE C8 74 1B FE C8 74 28 EB 2F 8B 45 F8 8B 40 48 89 06 EB 25 8B 45 F8 8B 40 40 89 46 08 EB 1A 8B 45 F8 8B 40 4C 8B 55 F8 03 42 34 89 46 04 EB 09 8B 45 F8 8B 40 44 89 46 0C 8B 45 F8 8A 40 2D 2C 01 72 0C 74 15 FE C8 74 1D FE C8 74 25 EB 2D 55 E8 ?? ?? ?? ?? 59 01 06 EB 22 55 E8 ?? ?? ?? ?? 59 29 46 08 EB 16 55 E8 ?? ?? ?? ?? 59 01 46 04 EB 0A 55 E8 ?? ?? ?? ?? 59 29 46 0C 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 00 00 00 00 00 C8 42 00 00 80 3F }
	condition:
		$1
}

rule function_1612_0 {
	meta:
		name = "TCustomChartLegend.FormattedValue"
		size = 552
		refs = "0023 TCustomChartLegend.FormattedValue 005a TeeLineSeparator 0061 @LStrFromChar 006b @LStrPos 0078 UniqueString 00f1 FormatFloat 014e @LStrCatN 01a3 TChartSeries.GetHorizAxis 01e5 TCustomChartAxis.LabelValue 01ff @LStrArrayClr 0205 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 D8 53 56 33 DB 89 5D D8 89 5D E0 89 5D DC 89 4D F4 89 55 F8 89 45 FC 8B 75 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 7D F4 FF 0F 84 B2 01 00 00 8B 55 F4 8B 45 F8 8B 08 FF 91 A8 00 00 00 89 45 F4 8B CE 8B 55 F4 8B 45 F8 8B 18 FF 53 64 8D 45 D8 8B 15 ?? ?? ?? ?? 8A 12 E8 ?? ?? ?? ?? 8B 45 D8 8B 16 E8 ?? ?? ?? ?? 8B D8 85 DB 7E 0C 8B C6 E8 ?? ?? ?? ?? C6 44 18 FF 20 85 DB 75 D0 8B 45 FC 80 78 0E 00 0F 84 57 01 00 00 8B 55 F4 8B 45 F8 8B 08 FF 91 E8 00 00 00 DD 5D EC 9B 8B 45 F8 8B 10 FF 92 F0 00 00 00 8B D0 DD 42 40 D8 1D ?? ?? ?? ?? DF E0 9E 75 0E 33 C0 89 45 E4 C7 45 E8 00 00 59 40 EB 10 D9 05 ?? ?? ?? ?? DC 4D EC DC 72 40 DD 5D E4 9B DD 45 EC 83 C4 F4 DB 3C 24 9B 8D 55 E0 8B 45 F8 8B 40 68 E8 ?? ?? ?? ?? DD 45 E4 83 C4 F4 DB 3C 24 9B 8D 55 DC 8B 45 F8 8B 40 58 E8 ?? ?? ?? ?? 8B 45 FC 0F B6 40 0E 83 F8 05 0F 87 CC 00 00 00 FF 24 85 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FF 75 E0 68 ?? ?? ?? ?? FF 36 8B C6 BA 03 00 00 00 E8 ?? ?? ?? ?? E9 92 00 00 00 FF 36 68 ?? ?? ?? ?? FF 75 E0 8B C6 BA 03 00 00 00 E8 ?? ?? ?? ?? EB 7A FF 75 DC 68 ?? ?? ?? ?? FF 36 8B C6 BA 03 00 00 00 E8 ?? ?? ?? ?? EB 62 FF 36 68 ?? ?? ?? ?? FF 75 DC 8B C6 BA 03 00 00 00 E8 ?? ?? ?? ?? EB 4A 8B 45 F8 E8 ?? ?? ?? ?? 8B D8 85 DB 75 21 8B 55 F4 8B 45 F8 8B 08 FF 51 68 83 C4 F4 DB 3C 24 9B 8B D6 8B 45 F8 8B 40 68 E8 ?? ?? ?? ?? EB 1B 8B 55 F4 8B 45 F8 8B 08 FF 51 68 83 C4 F8 DD 1C 24 9B 8B D6 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 D8 BA 03 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5E 5B 8B E5 5D C2 04 00 00 00 00 00 00 00 00 C8 42 FF FF FF FF 01 00 00 00 20 00 00 00 }
	condition:
		$1
}

rule function_1613_0 {
	meta:
		name = "TCustomChartLegend.Clicked"
		size = 157
		refs = "001e Point 002f PtInRect 003a TCustomChartLegend.GetParentChart 0045 TTeeCanvas.FontHeight"
	strings:
		$1 = { 53 56 83 C4 EC 89 0C 24 8B F2 8B D8 C7 44 24 04 FF FF FF FF 8D 4C 24 0C 8B 14 24 8B C6 E8 ?? ?? ?? ?? FF 74 24 10 FF 74 24 10 8D 43 40 50 E8 ?? ?? ?? ?? 85 C0 74 5C 8B C3 E8 ?? ?? ?? ?? 8B 80 5C 02 00 00 E8 ?? ?? ?? ?? 89 44 24 08 8B 4C 24 08 8B 53 44 8B C3 8B 30 FF 56 0C 8B F0 4E 85 F6 7C 31 46 33 D2 8B 43 44 40 8B CA 0F AF 4C 24 08 03 C1 3B 04 24 7F 18 8B 4C 24 08 D1 F9 79 03 83 D1 00 03 C1 3B 04 24 7C 06 89 54 24 04 EB 04 42 4E 75 D2 8B 44 24 04 83 C4 14 5E 5B C3 }
	condition:
		$1
}

rule function_1614_0 {
	meta:
		name = "TeeGetUniqueName"
		size = 264
		refs = "001b TeeGetUniqueName 0029 @LStrClr 0031 _Dn_TCustomForm 0036 @IsClass 0058 @IntfCast 007d IntToStr 008b @LStrCat3 00b0 TComponent.FindComponent 00bf @LStrLAsg 00dc @IntfClear 00ea @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 89 4D F8 89 55 FC 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 E8 ?? ?? ?? ?? 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 2C 8B DE 83 BB 30 02 00 00 00 74 21 8D 45 F0 8B 93 30 02 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F0 8B 4D F8 8B 55 FC 8B 18 FF 53 58 8B 45 F8 83 38 00 75 51 BB 01 00 00 00 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 4D EC 8D 45 F4 8B 55 FC E8 ?? ?? ?? ?? EB 19 43 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 4D EC 8D 45 F4 8B 55 FC E8 ?? ?? ?? ?? 8B 55 F4 8B C6 E8 ?? ?? ?? ?? 85 C0 75 D9 8B 45 F8 8B 55 F4 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 00 55 72 BE AB 95 54 D1 11 9F B5 00 20 AF 3D 82 DA }
	condition:
		$1
}

rule function_1615_0 {
	meta:
		name = "GetNewSeriesName"
		size = 40
		refs = "0009 GetNewSeriesName 0010 TeeGetUniqueName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B CE BA ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 00 FF FF FF FF 06 00 00 00 53 65 72 69 65 73 00 00 }
	condition:
		$1
}

rule function_1616_0 {
	meta:
		name = "GetNewFunctionName"
		size = 176
		refs = "0012 GetNewFunctionName 0027 IntToStr 0037 @LStrCat3 005e TComponent.FindComponent 006c @LStrLAsg 0086 @LStrArrayClr 008c @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 57 8B FA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 BB 01 00 00 00 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 4D F8 8D 45 FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 1B 43 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 4D F8 8D 45 FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 85 C0 75 D7 8B C7 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 59 59 5D C3 00 00 00 FF FF FF FF 0B 00 00 00 54 65 65 46 75 6E 63 74 69 6F 6E 00 }
	condition:
		$1
}

rule function_1617_0 {
	meta:
		name = "AssignSeries"
		size = 520
		refs = "0016 AssignSeries 0112 @LStrLAsg 011d TList.Get 012f TList.IndexOf 013b TList.Add 0150 TList.Remove 015a TChartSeries.AddLinkedSeries 0164 TChartSeries.RemoveLinkedSeries 019b TList.Exchange 01a2 TObject.Free 01b7 TChartSeries.GetDataSource 01e0 TChartSeries.RefreshSeries 01f5 @LStrClr 01fb @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 33 C9 89 4D FC 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 13 8B 06 8B 08 FF 51 08 8B 06 8B 13 8B 8A B0 00 00 00 89 88 B0 00 00 00 8B 8A B4 00 00 00 89 88 B4 00 00 00 8B 06 8B 13 8B 8A A8 00 00 00 89 88 A8 00 00 00 8B 8A AC 00 00 00 89 88 AC 00 00 00 8B 06 8B 13 8B 8A 90 00 00 00 89 88 90 00 00 00 8B 8A 94 00 00 00 89 88 94 00 00 00 8B 06 8B 13 8B 8A 88 00 00 00 89 88 88 00 00 00 8B 8A 8C 00 00 00 89 88 8C 00 00 00 8B 06 8B 13 8B 8A 98 00 00 00 89 88 98 00 00 00 8B 8A 9C 00 00 00 89 88 9C 00 00 00 8B 06 8B 13 8B 8A B8 00 00 00 89 88 B8 00 00 00 8B 8A BC 00 00 00 89 88 BC 00 00 00 8B 06 8B 13 8B 8A C0 00 00 00 89 88 C0 00 00 00 8B 8A C4 00 00 00 89 88 C4 00 00 00 8B 06 8B 13 8B 8A A0 00 00 00 89 88 A0 00 00 00 8B 8A A4 00 00 00 89 88 A4 00 00 00 8D 45 FC 8B 13 8B 52 08 E8 ?? ?? ?? ?? EB 50 8B C7 33 D2 E8 ?? ?? ?? ?? 89 45 F4 8B 45 F4 8B 78 3C 8B 16 8B C7 E8 ?? ?? ?? ?? 40 75 09 8B 16 8B C7 E8 ?? ?? ?? ?? 8B 13 8B C7 E8 ?? ?? ?? ?? 40 74 09 8B 13 8B C7 E8 ?? ?? ?? ?? 8B 06 8B 55 F4 E8 ?? ?? ?? ?? 8B 03 8B 55 F4 E8 ?? ?? ?? ?? 8B 03 8B 78 4C 83 7F 08 00 7F A5 8B 03 8B 40 54 8B B8 80 02 00 00 8B 13 8B C7 E8 ?? ?? ?? ?? 89 45 F8 8B 16 8B C7 E8 ?? ?? ?? ?? 8B C8 8B 55 F8 8B C7 E8 ?? ?? ?? ?? 8B 03 E8 ?? ?? ?? ?? 33 C0 89 03 8B 06 8B 55 FC 8B 08 FF 51 18 8B 06 E8 ?? ?? ?? ?? 85 C0 75 1E 8B 06 F6 40 20 10 74 16 8B 06 8B 10 FF 92 C4 00 00 00 8B D0 8B 06 8B 08 FF 91 9C 00 00 00 8B 06 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1618_0 {
	meta:
		name = "CreateNewTeeFunction"
		size = 101
		refs = "000d CreateNewTeeFunction 0028 TTeeFunction.SetParentSeries 0033 GetNewFunctionName 0052 @LStrClr 0058 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 4B 04 8B C2 B2 01 FF 50 2C 8B F0 8B D3 8B C6 E8 ?? ?? ?? ?? 8D 55 FC 8B 43 04 E8 ?? ?? ?? ?? 8B 55 FC 8B C6 8B 08 FF 51 18 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1619_0 {
	meta:
		name = "CreateNewSeries"
		size = 138
		refs = "0019 CreateNewSeries 0044 GetNewSeriesName 005e CreateNewTeeFunction 0073 @LStrClr 0079 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 33 DB 89 5D F8 89 4D FC 8B DA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 F6 75 02 8B F3 8B CE B2 01 8B 45 FC FF 50 2C 8B F8 8B D3 8B C7 8B 08 FF 51 7C 8D 55 F8 8B C6 E8 ?? ?? ?? ?? 8B 55 F8 8B C7 8B 08 FF 51 18 83 7D 08 00 74 0A 8B 55 08 8B C7 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C7 5F 5E 5B 59 59 5D C2 04 00 }
	condition:
		$1
}

rule function_1620_0 {
	meta:
		name = "CloneChartSeries"
		size = 84
		refs = "0015 TObject.ClassType 002c CreateNewSeries 003e TChartSeries.GetDataSource 004b TChartSeries.AssignValues"
	strings:
		$1 = { 53 56 8B D8 8B B3 80 00 00 00 85 F6 75 04 33 F6 EB 09 8B C6 E8 ?? ?? ?? ?? 8B F0 56 8B C3 E8 ?? ?? ?? ?? 8B C8 8B 53 54 8B 43 04 E8 ?? ?? ?? ?? 8B F0 8B D3 8B C6 8B 08 FF 51 08 8B C6 E8 ?? ?? ?? ?? 85 C0 75 09 8B D3 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1621_0 {
	meta:
		name = "ChangeSeriesType"
		size = 64
		refs = "000a TObject.ClassType 0021 CreateNewSeries 0033 AssignSeries"
	strings:
		$1 = { 53 56 51 8B F2 8B D8 8B 03 E8 ?? ?? ?? ?? 3B F0 74 2A 6A 00 8B 03 8B 50 54 8B 03 8B 40 04 8B CE E8 ?? ?? ?? ?? 89 04 24 83 3C 24 00 74 0E 8B D4 8B C3 E8 ?? ?? ?? ?? 8B 04 24 89 03 5A 5E 5B C3 }
	condition:
		$1
}

rule function_1622_0 {
	meta:
		name = "ChangeAllSeriesType"
		size = 57
		refs = "000c TCustomAxisPanel.SeriesCount 001f TCustomAxisPanel.GetSeries 002b ChangeSeriesType"
	strings:
		$1 = { 53 56 57 55 51 8B EA 8B F8 8B C7 E8 ?? ?? ?? ?? 8B D8 4B 85 DB 7C 1C 43 33 F6 8B D6 8B C7 E8 ?? ?? ?? ?? 89 04 24 8B C4 8B D5 E8 ?? ?? ?? ?? 46 4B 75 E7 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1624_0 {
	meta:
		name = "RegisterTeeSeriesFunction"
		size = 236
		refs = "001b RegisterClass 002f TeeSeriesTypes 0039 _DV_TTeeSeriesTypes 003e TObject.Create 005f TTeeSeriesTypes.GetSeriesType 0077 _DV_TTeeSeriesType 009a @LStrToString 00aa @PStrNCpy 00df TList.Add"
	strings:
		$1 = { 55 8B EC 81 C4 F8 FE FF FF 53 56 57 89 4D F8 89 55 FC 8B F8 85 FF 74 07 8B C7 E8 ?? ?? ?? ?? 83 7D FC 00 74 08 8B 45 FC E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 11 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 58 08 4B 85 DB 7C 20 43 33 F6 8B D6 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 3B 78 04 75 08 8B 40 08 3B 45 FC 74 73 46 4B 75 E3 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 89 7B 04 8B 45 FC 89 43 08 8D 85 F8 FE FF FF 8B 55 F8 B9 FF 00 00 00 E8 ?? ?? ?? ?? 8D 95 F8 FE FF FF 8D 43 0C B1 14 E8 ?? ?? ?? ?? 8D 85 F8 FE FF FF 8B 55 0C B9 FF 00 00 00 E8 ?? ?? ?? ?? 8D 95 F8 FE FF FF 8D 43 21 B1 14 E8 ?? ?? ?? ?? 8B 45 08 89 43 38 8B D3 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_1625_0 {
	meta:
		name = "RegisterTeeSeries"
		size = 21
		refs = "000d RegisterTeeSeriesFunction"
	strings:
		$1 = { 55 8B EC 51 8B 4D 08 51 33 C9 87 CA E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule function_1626_0 {
	meta:
		name = "RegisterTeeFunction"
		size = 22
		refs = "000e RegisterTeeSeriesFunction"
	strings:
		$1 = { 55 8B EC 51 8B 4D 08 51 33 C9 91 87 CA E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule function_1627_0 {
	meta:
		name = "RegisterTeeBasicFunction"
		size = 86
		refs = "000f RegisterTeeBasicFunction 001f TeeMsg_GalleryFunctions 0024 LoadResString 0030 RegisterTeeFunction 0045 @LStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 6A 02 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC 8B D6 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1628_0 {
	meta:
		name = "GetTeeFunctionDescription"
		size = 76
		refs = "000e @LStrClr 0013 TeeSeriesTypes 002a TTeeSeriesTypes.GetSeriesType 003c @LStrFromString"
	strings:
		$1 = { 53 56 57 55 51 89 14 24 8B E8 8B 04 24 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 70 08 4E 85 F6 7C 27 46 33 FF 8B D7 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 3B 6B 08 75 0D 8B 04 24 8D 53 0C E8 ?? ?? ?? ?? EB 04 47 4E 75 DC 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1629_0 {
	meta:
		name = "InternalUnRegister"
		size = 82
		refs = "0009 TeeSeriesTypes 001d TTeeSeriesTypes.GetSeriesType 0034 TObject.Free 003e TList.Delete"
	strings:
		$1 = { 53 56 57 55 8B FA 8B D8 BD ?? ?? ?? ?? 83 7D 00 00 74 3A 33 F6 EB 2E 8B D6 8B 45 00 E8 ?? ?? ?? ?? 84 DB 74 05 3B 78 04 74 09 84 DB 75 16 3B 78 08 75 11 E8 ?? ?? ?? ?? 8B D6 8B 45 00 E8 ?? ?? ?? ?? EB 01 46 8B 45 00 3B 70 08 7C CA 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1630_0 {
	meta:
		name = "UnRegisterTeeSeries"
		size = 29
		refs = "0010 InternalUnRegister"
	strings:
		$1 = { 53 56 8B F2 85 F6 7C 12 46 8B D8 8B 13 B0 01 E8 ?? ?? ?? ?? 83 C3 04 4E 75 F1 5E 5B C3 }
	condition:
		$1
}

rule function_1631_0 {
	meta:
		name = "UnRegisterTeeFunctions"
		size = 29
		refs = "0010 InternalUnRegister"
	strings:
		$1 = { 53 56 8B F2 85 F6 7C 12 46 8B D8 8B 13 33 C0 E8 ?? ?? ?? ?? 83 C3 04 4E 75 F1 5E 5B C3 }
	condition:
		$1
}

rule function_1632_0 {
	meta:
		name = "TeeGalleryExitProc"
		size = 54
		refs = "0004 TeeSeriesTypes 001a TTeeSeriesTypes.GetSeriesType 001f TObject.Free"
	strings:
		$1 = { 53 56 57 BF ?? ?? ?? ?? 8B 07 8B 58 08 4B 85 DB 7C 15 43 33 F6 8B D6 8B 07 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 46 4B 75 EE 8B 07 E8 ?? ?? ?? ?? 33 C0 89 07 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1634_0 {
	meta:
		name = "Chart"
		size = 364
		refs = "000f Chart 001b _DV_21 0029 TeeSeriesTypes 0031 AnimatedZoomFactor 0041 TeeZoomMouseButton 0048 TeeScrollMouseButton 0053 TeeZoomKeyShift 005d TeeScrollKeyShift 0062 _DV_TChartLegend 006a _DV_TChartGradient 0072 _DV_TChartWall 007a _DV_TChartTitle 008a RegisterClasses 0092 TeeMsg_FunctionAdd 0097 LoadResString 009f _Dn_TAddTeeFunction 00a4 RegisterTeeBasicFunction 00ac TeeMsg_FunctionSubtract 00b9 _Dn_TSubtractTeeFunction 00c6 TeeMsg_FunctionMultiply 00d3 _Dn_TMultiplyTeeFunction 00e0 TeeMsg_FunctionDivide 00ed _Dn_TDivideTeeFunction 00fa TeeMsg_FunctionHigh 0107 _Dn_THighTeeFunction 0114 TeeMsg_FunctionLow 0121 _Dn_TLowTeeFunction 012e TeeMsg_FunctionAverage 013b _Dn_TAverageTeeFunction 0155 @LStrClr 015b @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 33 C0 89 45 EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 2D ?? ?? ?? ?? 01 0F 83 1E 01 00 00 33 C0 A3 ?? ?? ?? ?? 33 C0 89 05 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 08 40 C6 05 ?? ?? ?? ?? 00 C6 05 ?? ?? ?? ?? 01 A0 ?? ?? ?? ?? A2 ?? ?? ?? ?? A0 ?? ?? ?? ?? A2 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 45 F0 A1 ?? ?? ?? ?? 89 45 F4 A1 ?? ?? ?? ?? 89 45 F8 A1 ?? ?? ?? ?? 89 45 FC 8D 45 F0 BA 03 00 00 00 E8 ?? ?? ?? ?? 8D 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B E5 5D C3 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_1635_0 {
	meta:
		name = "GetCheckSize"
		size = 131
		refs = "0007 _Dn_TBitmap 000c TBitmap.Create 0017 GetCheckSize 0029 LoadBitmap 0033 TBitmap.SetHandle 004a FCheckWidth 005f FCheckHeight 0074 TObject.Free 007a @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 68 F7 7F 00 00 6A 00 E8 ?? ?? ?? ?? 8B D0 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 8B 10 FF 52 2C 85 C0 79 03 83 C0 03 C1 F8 02 A3 ?? ?? ?? ?? 8B 45 FC 8B 10 FF 52 20 B9 03 00 00 00 99 F7 F9 A3 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_1636_0 {
	meta:
		name = "TCheckListBoxDataWrapper.SetChecked"
		size = 14
	strings:
		$1 = { 84 D2 74 05 C6 40 08 01 C3 C6 40 08 00 C3 }
	condition:
		$1
}

rule function_1637_0 {
	meta:
		name = "TCheckListBoxDataWrapper.GetChecked"
		size = 8
	strings:
		$1 = { 80 78 08 01 0F 94 C0 C3 }
	condition:
		$1
}

rule function_1639_0 {
	meta:
		name = "TCheckListBox.Create"
		size = 60
		refs = "000a @ClassCreate 0017 TCustomListBox.Create 0029 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? C6 86 2D 02 00 00 01 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1640_0 {
	meta:
		name = "TCheckListBox.Destroy"
		size = 48
		refs = "0003 @BeforeDestruction 0012 TObject.Free 001e TCustomListBox.Destroy 0029 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 86 3C 02 00 00 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1641_0 {
	meta:
		name = "TCheckListBox.CreateWnd"
		size = 42
		refs = "0006 TCustomListBox.CreateWnd 0015 TObject.Free 0024 TCheckListBox.ResetItemHeight"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 83 3C 02 00 00 85 C0 74 0D E8 ?? ?? ?? ?? 33 C0 89 83 3C 02 00 00 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1642_0 {
	meta:
		name = "TCheckListBox.DestroyWnd"
		size = 98
		refs = "0017 _Dn_TList 001c TObject.Create 0040 TCheckListBox.GetState 004f TList.Add 005a TCustomListBox.DestroyWnd"
	strings:
		$1 = { 53 56 57 8B D8 8B 83 EC 01 00 00 8B 10 FF 52 14 85 C0 7E 43 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 3C 02 00 00 8B 83 EC 01 00 00 8B 10 FF 52 14 8B F0 4E 85 F6 7C 1F 46 33 FF 8B D7 8B C3 E8 ?? ?? ?? ?? 33 D2 8A D0 8B 83 3C 02 00 00 E8 ?? ?? ?? ?? 47 4E 75 E4 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1643_0 {
	meta:
		name = "TCheckListBox.CreateParams"
		size = 22
		refs = "0006 TCustomListBox.CreateParams"
	strings:
		$1 = { 53 8B DA 8B D3 E8 ?? ?? ?? ?? F6 43 04 30 75 04 83 4B 04 10 5B C3 }
	condition:
		$1
}

rule function_1644_0 {
	meta:
		name = "TCheckListBox.GetCheckWidth"
		size = 9
		refs = "0001 FCheckWidth"
	strings:
		$1 = { A1 ?? ?? ?? ?? 83 C0 02 C3 }
	condition:
		$1
}

rule function_1645_0 {
	meta:
		name = "TCheckListBox.CMFontChanged"
		size = 19
		refs = "0006 TWinControl.CMFontChanged 000d TCheckListBox.ResetItemHeight"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_3347_0 {
	meta:
		name = "TCoolBar.CMSysFontChanged"
		size = 19
		refs = "0006 TWinControl.CMSysFontChanged 000d TWinControl.RecreateWnd"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_3300_0 {
	meta:
		name = "TCoolBar.Loaded"
		size = 19
		refs = "0006 TControl.Loaded 000d TCoolBar.UpdateBands"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_3341_0 {
	meta:
		name = "TCoolBar.WMSize"
		size = 19
		refs = "0006 TWinControl.WMSize 000d TWinControl.Realign"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_17585_0 {
	meta:
		name = "TCustomCheckBox.Click"
		size = 19
		refs = "0006 TControl.Changed 000d TControl.Click"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_6797_0 {
	meta:
		name = "TCustomDBGrid.TopLeftChanged"
		size = 19
		refs = "0006 TCustomDBGrid.InvalidateTitles 000d TCustomGrid.TopLeftChanged"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_6786_0 {
	meta:
		name = "TCustomDBGrid.WMIMEStartComp"
		size = 19
		refs = "0006 TWinControl.WMIMEStartComp 000d TCustomGrid.ShowEditor"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_13008_0 {
	meta:
		name = "TCustomDecisionGraph.Updated"
		size = 19
		refs = "0006 TComponent.Updated 000d TCustomDecisionGraph.NewGraphLayout"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_9765_0 {
	meta:
		name = "TCustomGrid.CMCtl3DChanged"
		size = 19
		refs = "0006 TWinControl.CMCtl3DChanged 000d TWinControl.RecreateWnd"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_9770_0 {
	meta:
		name = "TCustomGrid.ColWidthsChanged"
		size = 19
		refs = "0006 TCustomGrid.UpdateScrollRange 000d TCustomGrid.UpdateEdit"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_9771_0 {
	meta:
		name = "TCustomGrid.RowHeightsChanged"
		size = 19
		refs = "0006 TCustomGrid.UpdateScrollRange 000d TCustomGrid.UpdateEdit"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_9762_0 {
	meta:
		name = "TCustomGrid.WMCancelMode"
		size = 19
		refs = "0006 TControl.WMCancelMode 000d TCustomGrid.CancelMode"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_17659_0 {
	meta:
		name = "TCustomListBox.WMSize"
		size = 19
		refs = "0006 TWinControl.WMSize 000d TCustomListBox.SetColumnWidth"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_8493_0 {
	meta:
		name = "TCustomRadioGroup.CMFontChanged"
		size = 19
		refs = "0006 TWinControl.CMFontChanged 000d TCustomRadioGroup.ArrangeButtons"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_8494_0 {
	meta:
		name = "TCustomRadioGroup.WMSize"
		size = 19
		refs = "0006 TCustomGroupBox.WMSize 000d TCustomRadioGroup.ArrangeButtons"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_17686_0 {
	meta:
		name = "TCustomStaticText.CMFontChanged"
		size = 19
		refs = "0006 TWinControl.CMFontChanged 000d TCustomStaticText.AdjustBounds"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_17688_0 {
	meta:
		name = "TCustomStaticText.Loaded"
		size = 19
		refs = "0006 TControl.Loaded 000d TCustomStaticText.AdjustBounds"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2615_0 {
	meta:
		name = "TCustomTreeView.CMColorChanged"
		size = 19
		refs = "0006 TWinControl.CMColorChanged 000d TWinControl.RecreateWnd"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_6175_0 {
	meta:
		name = "TDBComboBox.CreateWnd"
		size = 19
		refs = "0006 TCustomComboBox.CreateWnd 000d TDBComboBox.SetEditReadOnly"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_6853_0 {
	meta:
		name = "TDBLookupCombo.CMFontChanged"
		size = 19
		refs = "0006 TCustomEdit.CMFontChanged 000d TDBLookupCombo.GetMinHeight"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_6404_0 {
	meta:
		name = "TDBLookupListBox.CreateWnd"
		size = 19
		refs = "0006 TWinControl.CreateWnd 000d TDBLookupListBox.UpdateScrollBar"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_13142_0 {
	meta:
		name = "TDecisionPivot.SetBorderStyle"
		size = 19
		refs = "0006 TCustomPanel.SetBorderStyle 000d TDecisionPivot.NewPanelSetup"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_13141_0 {
	meta:
		name = "TDecisionPivot.SetBorderWidth"
		size = 19
		refs = "0006 TCustomPanel.SetBorderWidth 000d TDecisionPivot.NewPanelSetup"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_8614_0 {
	meta:
		name = "TDirectoryListBox.CMFontChanged"
		size = 19
		refs = "0006 TWinControl.CMFontChanged 000d TDirectoryListBox.ResetItemHeight"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_8609_0 {
	meta:
		name = "TDirectoryListBox.DblClick"
		size = 19
		refs = "0006 TControl.DblClick 000d TDirectoryListBox.OpenCurrent"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_17227_0 {
	meta:
		name = "TFastLineSeries.DrawAllValues"
		size = 19
		refs = "0006 TFastLineSeries.PrepareCanvas 000d TChartSeries.DrawAllValues"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_8641_0 {
	meta:
		name = "TFileListBox.CMFontChanged"
		size = 19
		refs = "0006 TWinControl.CMFontChanged 000d TFileListBox.ResetItemHeight"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_8648_0 {
	meta:
		name = "TFilterComboBox.CreateWnd"
		size = 19
		refs = "0006 TCustomComboBox.CreateWnd 000d TFilterComboBox.BuildList"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2475_0 {
	meta:
		name = "THeaderControl.CreateWnd"
		size = 19
		refs = "0006 TWinControl.CreateWnd 000d THeaderControl.UpdateSections"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_10721_0 {
	meta:
		name = "TIdMessage.Clear"
		size = 19
		refs = "0006 TIdMessage.ClearHeader 000d TIdMessage.ClearBody"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_11007_0 {
	meta:
		name = "TIdTCPConnection.CancelWriteBuffer"
		size = 19
		refs = "0006 TIdTCPConnection.ClearWriteBuffer 000d TIdTCPConnection.CloseWriteBuffer"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_12500_0 {
	meta:
		name = "TMediaPlayer.Updated"
		size = 19
		refs = "0006 TComponent.Updated 000d TMediaPlayer.Adjust"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_15623_0 {
	meta:
		name = "TQRCompEd.Apply1Click"
		size = 19
		refs = "0006 TQRCompEd.SetValues 000d TQRCompEd.GetValues"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_15622_0 {
	meta:
		name = "TQRCompEd.OK1Click"
		size = 19
		refs = "0006 TQRCompEd.SetValues 000d TCustomForm.Close"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_16099_0 {
	meta:
		name = "TQRStandardPreview.Show"
		size = 19
		refs = "0006 TCustomForm.Show 000d TQRStandardPreview.UpdateInfo"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_7441_0 {
	meta:
		name = "TQuery.Disconnect"
		size = 19
		refs = "0006 TDataSet.Close 000d TQuery.UnPrepare"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_8780_0 {
	meta:
		name = "TScrollBox.WMSize"
		size = 19
		refs = "0006 TScrollingWinControl.WMSize 000d TScrollingWinControl.CalcAutoRange"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_17363_0 {
	meta:
		name = "TSpinEdit.CreateWnd"
		size = 19
		refs = "0006 TCustomEdit.CreateWnd 000d TSpinEdit.SetEditRect"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2445_0 {
	meta:
		name = "TStatusBar.CMColorChanged"
		size = 19
		refs = "0006 TWinControl.CMColorChanged 000d TWinControl.RecreateWnd"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_7415_0 {
	meta:
		name = "TStoredProc.Disconnect"
		size = 19
		refs = "0006 TDataSet.Close 000d TStoredProc.UnPrepare"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_19010_0 {
	meta:
		name = "TTeeGalleryPanel.Resize"
		size = 19
		refs = "0006 TControl.Resize 000d TTeeGalleryPanel.ResizeCharts"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_3222_0 {
	meta:
		name = "TToolBar.CMColorChanged"
		size = 19
		refs = "0006 TWinControl.CMColorChanged 000d TWinControl.RecreateWnd"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_3225_0 {
	meta:
		name = "TToolBar.CMSysFontChanged"
		size = 19
		refs = "0006 TWinControl.CMSysFontChanged 000d TWinControl.RecreateWnd"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1646_0 {
	meta:
		name = "TCheckListBox.ResetItemHeight"
		size = 92
		refs = "0007 TWinControl.HandleAllocated 0022 TCanvas.SetFont 0027 TCheckListBox.ResetItemHeight 0032 TCanvas.TextHeight 0049 TControl.Perform"
	strings:
		$1 = { 53 56 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 3E 80 BB 00 02 00 00 00 75 35 8B 53 58 8B 83 F4 01 00 00 E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 8B 83 F4 01 00 00 E8 ?? ?? ?? ?? 8B F0 89 B3 30 02 00 00 56 33 C9 BA A0 01 00 00 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 FF FF FF FF 02 00 00 00 57 67 00 00 }
	condition:
		$1
}

rule function_1647_0 {
	meta:
		name = "TCheckListBox.DrawItem"
		size = 296
		refs = "001e TCheckListBox.GetCheckWidth 004f @CallDynaInst 0075 TCheckListBox.GetState 0082 TCheckListBox.DrawCheck 00c9 TCheckListBox.DrawItem 00e0 TCustomListBox.DrawItem 0108 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 D4 53 56 57 8B F1 8D 7D E4 B9 04 00 00 00 F3 A5 8B F2 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 8B F8 8B 45 FC 8B 80 EC 01 00 00 8B 10 FF 52 14 3B F0 7D 50 56 57 8D 75 E4 8D 7D D4 B9 04 00 00 00 F3 A5 5F 5E 8B 45 FC 66 BB CF FF E8 ?? ?? ?? ?? 84 C0 75 0D 8B 45 E4 89 45 DC 2B C7 89 45 D4 EB 0B 8B 45 EC 89 45 D4 03 F8 89 7D DC 8B D6 8B 45 FC E8 ?? ?? ?? ?? 8B C8 8D 55 D4 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 80 B8 00 02 00 00 00 75 7C 8B 45 FC 66 83 B8 1A 02 00 00 00 74 6F 8B 45 FC 8B 90 18 02 00 00 89 55 F4 8B 90 1C 02 00 00 89 55 F8 8B 45 FC 33 D2 89 90 18 02 00 00 89 90 1C 02 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8A 45 08 50 8D 4D E4 8B D6 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 55 F4 89 90 18 02 00 00 8B 55 F8 89 90 1C 02 00 00 C3 E9 ?? ?? ?? ?? EB E3 8A 45 08 50 8D 4D E4 8B D6 8B 45 FC E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_1648_0 {
	meta:
		name = "TCheckListBox.CNDrawItem"
		size = 62
		refs = "0012 @CallDynaInst 001d TCheckListBox.GetCheckWidth 0035 TCustomListBox.CNDrawItem"
	strings:
		$1 = { 53 56 57 55 8B EA 8B F0 8B 7D 08 8B C6 66 BB CF FF E8 ?? ?? ?? ?? 84 C0 75 0C 8B C6 E8 ?? ?? ?? ?? 01 47 1C EB 0A 8B C6 E8 ?? ?? ?? ?? 29 47 24 8B D5 8B C6 E8 ?? ?? ?? ?? 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1649_0 {
	meta:
		name = "TCheckListBox.DrawCheck"
		size = 424
		refs = "0026 FCheckWidth 0068 FCheckHeight 009f CreateRectRgn 00a9 TCanvas.GetHandle 00af GetClipRgn 00ea SelectClipRgn 00f4 DeleteObject 0109 DrawFrameControl 0132 TBrush.GetStyle 013d TBrush.GetColor 0147 TPen.GetColor 0153 TBrush.SetStyle 0160 TPen.SetColor 017d TCanvas.Rectangle 0192 TBrush.SetColor"
	strings:
		$1 = { 53 56 57 55 83 C4 D8 8B F2 8D 7C 24 08 51 B9 04 00 00 00 F3 A5 59 8B F0 33 FF 8B 54 24 10 8B 44 24 08 2B D0 2B 15 ?? ?? ?? ?? D1 FA 79 03 83 D2 00 03 D0 89 54 24 18 8B 54 24 14 8B 44 24 0C 2B D0 2B 15 ?? ?? ?? ?? D1 FA 79 03 83 D2 00 03 D0 89 54 24 1C 8B 44 24 18 03 05 ?? ?? ?? ?? 89 44 24 20 8B 44 24 1C 03 05 ?? ?? ?? ?? 89 44 24 24 80 E9 01 72 09 75 0B BB 00 04 00 00 EB 09 33 DB EB 05 BB 08 04 00 00 8B AE F4 01 00 00 80 BE 2D 02 00 00 00 74 62 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 8B F8 57 8B C5 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 44 24 24 83 E8 02 50 8B 44 24 24 83 E8 02 50 8B 44 24 24 83 C0 02 50 8B 44 24 24 83 C0 02 50 E8 ?? ?? ?? ?? 89 44 24 04 8B 44 24 04 50 8B C5 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 44 24 04 50 E8 ?? ?? ?? ?? 53 6A 04 8D 44 24 20 50 8B C5 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 80 BE 2D 02 00 00 00 0F 84 86 00 00 00 57 8B C5 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 8B 45 14 E8 ?? ?? ?? ?? 88 04 24 8B 45 14 E8 ?? ?? ?? ?? 8B F0 8B 45 10 E8 ?? ?? ?? ?? 8B F8 B2 01 8B 45 14 E8 ?? ?? ?? ?? BA 10 00 00 80 8B 45 10 E8 ?? ?? ?? ?? 8B 44 24 20 48 50 8B 44 24 28 48 50 8B 4C 24 24 41 8B 54 24 20 42 8B C5 E8 ?? ?? ?? ?? 8A 14 24 8B 45 14 E8 ?? ?? ?? ?? 8B D6 8B 45 14 E8 ?? ?? ?? ?? 8B D7 8B 45 10 E8 ?? ?? ?? ?? 83 C4 28 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1650_0 {
	meta:
		name = "TCheckListBox.SetChecked"
		size = 51
		refs = "000e TCheckListBox.GetChecked 001b TCheckListBox.GetWrapper 0022 TCheckListBoxDataWrapper.SetChecked 002b TCheckListBox.InvalidateCheck"
	strings:
		$1 = { 53 56 57 8B D9 8B F2 8B F8 8B D6 8B C7 E8 ?? ?? ?? ?? 3A D8 74 19 8B D6 8B C7 E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B D6 8B C7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1651_0 {
	meta:
		name = "TCheckListBox.SetState"
		size = 47
		refs = "000e TCheckListBox.GetState 001b TCheckListBox.GetWrapper 0027 TCheckListBox.InvalidateCheck"
	strings:
		$1 = { 53 56 57 8B D9 8B F2 8B F8 8B D6 8B C7 E8 ?? ?? ?? ?? 3A D8 74 15 8B D6 8B C7 E8 ?? ?? ?? ?? 88 58 08 8B D6 8B C7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1652_0 {
	meta:
		name = "TCheckListBox.InvalidateCheck"
		size = 118
		refs = "0010 TCustomListBox.ItemRect 001b @CallDynaInst 0026 TCheckListBox.GetCheckWidth 0059 TWinControl.GetHandle 005f InvalidateRect 006c UpdateWindow"
	strings:
		$1 = { 53 56 83 C4 F0 8B DA 8B F0 8B CC 8B D3 8B C6 E8 ?? ?? ?? ?? 8B C6 66 BB CF FF E8 ?? ?? ?? ?? 84 C0 75 10 8B C6 E8 ?? ?? ?? ?? 03 04 24 89 44 24 08 EB 10 8B C6 E8 ?? ?? ?? ?? 8B 54 24 08 2B D0 89 14 24 F6 46 40 40 0F 95 C0 34 01 F6 D8 1B C0 50 8D 44 24 04 50 8B C6 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 10 5E 5B C3 }
	condition:
		$1
}

rule function_1653_0 {
	meta:
		name = "TCheckListBox.GetChecked"
		size = 41
		refs = "000b TCheckListBox.HaveWrapper 0018 TCheckListBox.GetWrapper 001d TCheckListBoxDataWrapper.GetChecked"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 84 C0 74 11 8B D6 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 33 C0 5E 5B C3 }
	condition:
		$1
}

rule function_1654_0 {
	meta:
		name = "TCheckListBox.GetState"
		size = 47
		refs = "000b TCheckListBox.HaveWrapper 0018 TCheckListBox.GetWrapper 0023 _DV_TCheckListBoxDataWrapper 0028 TCheckListBoxDataWrapper.GetDefaultState"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 84 C0 74 0F 8B D6 8B C3 E8 ?? ?? ?? ?? 8A 40 08 5E 5B C3 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1655_0 {
	meta:
		name = "TCheckListBox.KeyPress"
		size = 39
		refs = "000b TWinControl.KeyPress 0017 TCustomListBox.GetItemIndex 0020 TCheckListBox.ToggleClickCheck"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 80 3E 20 75 10 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1656_0 {
	meta:
		name = "TCheckListBox.MouseDown"
		size = 186
		refs = "0022 TControl.MouseDown 002e Point 003a TCustomListBox.ItemAtPos 004e @CallDynaInst 005f TCustomListBox.ItemRect 0069 TCheckListBox.GetCheckWidth 0077 TCheckListBox.ToggleClickCheck"
	strings:
		$1 = { 55 8B EC 83 C4 E0 53 56 57 88 4D FE 88 55 FF 8B F0 8B 5D 08 8B 7D 0C 57 53 8A 4D FE 8A 55 FF 8B C6 E8 ?? ?? ?? ?? 8D 4D F0 8B D3 8B C7 E8 ?? ?? ?? ?? 8D 55 F0 B1 01 8B C6 E8 ?? ?? ?? ?? 89 45 F8 83 7D F8 FF 74 6A 8B C6 66 BB CF FF E8 ?? ?? ?? ?? 84 C0 75 27 8D 4D E0 8B 55 F8 8B C6 E8 ?? ?? ?? ?? 2B 7D E0 8B C6 E8 ?? ?? ?? ?? 3B F8 7D 40 8B 55 F8 8B C6 E8 ?? ?? ?? ?? EB 34 8D 4D E0 8B 55 F8 8B C6 E8 ?? ?? ?? ?? 8B 5D E8 8B C6 E8 ?? ?? ?? ?? 2B D8 2B FB 85 FF 7E 15 8B C6 E8 ?? ?? ?? ?? 3B F8 7D 0A 8B 55 F8 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_1657_0 {
	meta:
		name = "TCheckListBox.ToggleClickCheck"
		size = 97
		refs = "001e TCheckListBox.GetState 004f TCheckListBox.SetState 005a @CallDynaInst"
	strings:
		$1 = { 53 56 8B F2 8B D8 85 F6 7C 54 8B 83 EC 01 00 00 8B 10 FF 52 14 3B F0 7D 45 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D0 80 EA 01 72 08 74 17 FE CA 74 17 EB 17 80 BB 2C 02 00 00 00 74 04 B0 02 EB 0A B0 01 EB 06 33 C0 EB 02 B0 01 8B C8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B C3 66 BB B4 FF E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1658_0 {
	meta:
		name = "TAnimate.DoStart"
		size = 29
		altNames = "TCheckListBox.ClickCheck TCustomComboBox.DropDown TCustomRichEdit.SelectionChange"
	strings:
		$1 = { 53 66 83 B8 36 02 00 00 00 74 10 8B D8 8B D0 8B 83 38 02 00 00 FF 93 34 02 00 00 5B C3 }
	condition:
		$1
}

rule function_1659_0 {
	meta:
		name = "TCheckListBox.GetItemData"
		size = 40
		refs = "000e TCheckListBox.HaveWrapper 001b TCheckListBox.GetWrapper"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 33 FF 8B D6 8B C3 E8 ?? ?? ?? ?? 84 C0 74 0C 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 78 04 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1660_0 {
	meta:
		name = "TCheckListBox.GetWrapper"
		size = 31
		refs = "000b TCheckListBox.ExtractWrapper 0018 TCheckListBox.CreateWrapper"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 85 C0 75 09 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1661_0 {
	meta:
		name = "TCheckListBox.ExtractWrapper"
		size = 153
		refs = "0015 TCheckListBox.ExtractWrapper 0024 TCustomListBox.GetItemData 0040 SListIndexError 0045 LoadResString 004f _Dn_EListError 0054 Exception.CreateFmt 0059 @RaiseExcept 0065 _DV_TCheckListBoxDataWrapper 006a @IsClass 0085 @LStrClr 008b @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 33 C9 89 4D F4 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D8 83 FB FF 75 2E 89 75 F8 C6 45 FC 00 8D 45 F8 50 6A 00 8D 55 F4 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D F4 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 DB 74 13 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 02 33 DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1662_0 {
	meta:
		name = "TCheckListBox.CreateWrapper"
		size = 38
		refs = "000a _DV_TCheckListBoxDataWrapper 000f TObject.Create 001c TCustomListBox.SetItemData"
	strings:
		$1 = { 53 56 57 8B FA 8B D8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 8B CE 8B D7 8B C3 E8 ?? ?? ?? ?? 8B C6 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1663_0 {
	meta:
		name = "TCheckListBox.HaveWrapper"
		size = 23
		refs = "000b TCheckListBox.ExtractWrapper"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 85 C0 0F 95 C0 5E 5B C3 }
	condition:
		$1
}

rule function_16700_0 {
	meta:
		name = "TRegistry.ReadBool"
		size = 23
		refs = "000b TRegistry.ReadInteger"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 85 C0 0F 95 C0 5E 5B C3 }
	condition:
		$1
}

rule function_1664_0 {
	meta:
		name = "TCheckListBox.SetItemData"
		size = 68
		refs = "000e TCheckListBox.GetWrapper 002c TList.Get 003c TList.Delete"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B F0 89 7E 04 8B BB 3C 02 00 00 85 FF 74 1F 83 7F 08 00 7E 19 33 D2 8B C7 E8 ?? ?? ?? ?? 88 46 08 33 D2 8B 83 3C 02 00 00 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1665_0 {
	meta:
		name = "TCheckListBox.ResetContent"
		size = 68
		refs = "001f TCheckListBox.HaveWrapper 002c TCheckListBox.GetWrapper 0031 TObject.Free 003c TCustomListBox.ResetContent"
	strings:
		$1 = { 53 56 57 8B F8 8B 87 EC 01 00 00 8B 10 FF 52 14 8B F0 4E 85 F6 7C 22 46 33 DB 8B D3 8B C7 E8 ?? ?? ?? ?? 84 C0 74 0E 8B D3 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 43 4E 75 E1 8B C7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1666_0 {
	meta:
		name = "TCheckListBox.DeleteString"
		size = 45
		refs = "000b TCheckListBox.HaveWrapper 0018 TCheckListBox.GetWrapper 001d TObject.Free 0026 TCustomListBox.DeleteString"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 84 C0 74 0E 8B D6 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1667_0 {
	meta:
		name = "TCheckListBox.SetFlat"
		size = 20
		altNames = "TQRDBImage.SetCenter"
	strings:
		$1 = { 3A 90 2D 02 00 00 74 0B 88 90 2D 02 00 00 8B 10 FF 52 78 C3 }
	condition:
		$1
}

rule function_1668_0 {
	meta:
		name = "TCheckListBox.WMDestroy"
		size = 61
		refs = "0022 TCheckListBox.ExtractWrapper 0027 TObject.Free 0034 TWinControl.WMDestroy"
	strings:
		$1 = { 53 56 57 55 8B EA 8B F8 8B 87 EC 01 00 00 8B 10 FF 52 14 8B D8 4B 85 DB 7C 15 43 33 F6 8B D6 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 46 4B 75 EE 8B D5 8B C7 E8 ?? ?? ?? ?? 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1671_0 {
	meta:
		name = "_NF__1D2"
		size = 279
		refs = "0005 TInterfaceList.Get 000d TInterfaceList.GetCapacity 0015 TInterfaceList.GetCount 001d TInterfaceList.Put 0025 TInterfaceList.SetCapacity 002d TInterfaceList.SetCount 0035 TInterfaceList.Clear 003d TInterfaceList.Delete 0045 TInterfaceList.Exchange 004d TInterfaceList.First 0055 TInterfaceList.IndexOf 005d TInterfaceList.Add 0065 TInterfaceList.Insert 006d TInterfaceList.Last 0075 TInterfaceList.Remove 007d TInterfaceList.Lock 0085 TInterfaceList.Unlock 008f TInterfacedObject.QueryInterface 0099 TInterfacedObject._AddRef 00a3 TInterfacedObject._Release 00a7 _NF__1D2"
	strings:
		$1 = { CC 83 C0 F0 E9 ?? ?? ?? ?? 83 C0 F0 E9 ?? ?? ?? ?? 83 C0 F0 E9 ?? ?? ?? ?? 83 C0 F0 E9 ?? ?? ?? ?? 83 C0 F0 E9 ?? ?? ?? ?? 83 C0 F0 E9 ?? ?? ?? ?? 83 C0 F0 E9 ?? ?? ?? ?? 83 C0 F0 E9 ?? ?? ?? ?? 83 C0 F0 E9 ?? ?? ?? ?? 83 C0 F0 E9 ?? ?? ?? ?? 83 C0 F0 E9 ?? ?? ?? ?? 83 C0 F0 E9 ?? ?? ?? ?? 83 C0 F0 E9 ?? ?? ?? ?? 83 C0 F0 E9 ?? ?? ?? ?? 83 C0 F0 E9 ?? ?? ?? ?? 83 C0 F0 E9 ?? ?? ?? ?? 83 C0 F0 E9 ?? ?? ?? ?? 83 44 24 04 F0 E9 ?? ?? ?? ?? 83 44 24 04 F0 E9 ?? ?? ?? ?? 83 44 24 04 F0 E9 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 00 00 00 8A EA 5D 28 65 B8 D1 11 AA A7 00 C0 4F B1 7A 72 ?? ?? ?? ?? 10 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_1680_0 {
	meta:
		name = "_NF__21A"
		size = 274
		refs = "00a0 TInterfacedObject.QueryInterface 00aa TInterfacedObject._AddRef 00b4 TInterfacedObject._Release 00ba _NF__21A"
	strings:
		$1 = { CC 83 44 24 04 EC 8B 44 24 04 8B 00 FF 20 83 44 24 04 EC 8B 44 24 04 8B 00 FF 60 04 83 44 24 04 EC 8B 44 24 04 8B 00 FF 60 08 83 44 24 04 EC 8B 44 24 04 8B 00 FF 60 0C 83 44 24 04 EC 8B 44 24 04 8B 00 FF 60 10 83 44 24 04 EC 8B 44 24 04 8B 00 FF 60 14 83 44 24 04 EC 8B 44 24 04 8B 00 FF 60 18 83 44 24 04 EC 8B 44 24 04 8B 00 FF 60 1C 83 44 24 04 EC 8B 44 24 04 8B 00 FF 60 20 83 44 24 04 EC 8B 44 24 04 8B 00 FF 60 24 83 44 24 04 EC 8B 44 24 04 8B 00 FF 60 28 83 44 24 04 EC E9 ?? ?? ?? ?? 83 44 24 04 EC E9 ?? ?? ?? ?? 83 44 24 04 EC E9 ?? ?? ?? ?? CC CC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 00 00 00 0C 00 00 00 00 00 00 00 C0 00 00 00 00 00 00 46 ?? ?? ?? ?? 14 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_1685_0 {
	meta:
		name = "Point"
		size = 6
	strings:
		$1 = { 89 01 89 51 04 C3 }
	condition:
		$1
}

rule function_1686_0 {
	meta:
		name = "SmallPoint"
		size = 15
	strings:
		$1 = { 51 66 89 04 24 66 89 54 24 02 8B 04 24 5A C3 }
	condition:
		$1
}

rule function_1687_0 {
	meta:
		name = "Rect"
		size = 26
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 89 03 89 53 04 89 4B 08 8B 45 0C 89 43 0C 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_1688_0 {
	meta:
		name = "Bounds"
		size = 28
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 89 03 89 53 04 03 C8 89 4B 08 03 55 0C 89 53 0C 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_1689_0 {
	meta:
		name = "GetFieldClassTable"
		size = 11
	strings:
		$1 = { 8B 40 C8 09 C0 74 03 8B 40 02 C3 }
	condition:
		$1
}

rule function_1690_0 {
	meta:
		name = "ClassNotFound"
		size = 129
		refs = "0015 ClassNotFound 0027 SClassNotFound 002c LoadResString 0042 Format 004c _DV_EClassNotFound 0051 Exception.Create 0056 @RaiseExcept 0070 @LStrArrayClr 0076 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 33 D2 89 55 FC 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F8 50 89 5D F0 C6 45 F4 0B 8D 55 F0 33 C9 58 E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1691_0 {
	meta:
		name = "GetClass"
		size = 174
		refs = "000d ClassList 0012 TThreadList.LockList 001c GetClass 0036 TList.Get 0044 TObject.ClassNameIs 004d @TryFinallyExit 005b ClassAliasList 0098 TThreadList.UnlockList 009e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 89 45 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 77 08 4E 85 F6 7C 29 46 33 DB 8B D3 8B C7 E8 ?? ?? ?? ?? 89 45 F8 8B 55 FC 8B 45 F8 E8 ?? ?? ?? ?? 84 C0 74 07 E8 ?? ?? ?? ?? EB 51 43 4E 75 DA 8B 55 FC A1 ?? ?? ?? ?? 8B 08 FF 51 50 8B D8 85 DB 7C 16 8B D3 A1 ?? ?? ?? ?? 8B 08 FF 51 18 89 45 F8 E8 ?? ?? ?? ?? EB 24 33 C0 89 45 F8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EE 8B 45 F8 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1692_0 {
	meta:
		name = "FindClass"
		size = 29
		refs = "0007 GetClass 0014 ClassNotFound"
	strings:
		$1 = { 53 56 8B F0 8B C6 E8 ?? ?? ?? ?? 8B D8 85 DB 75 07 8B C6 E8 ?? ?? ?? ?? 8B C3 5E 5B C3 }
	condition:
		$1
}

rule function_1693_0 {
	meta:
		name = "FindFieldClass"
		size = 201
		refs = "0018 FindFieldClass 0023 TObject.ClassType 0030 GetFieldClassTable 005c TObject.ClassName 006a @LStrFromString 0075 CompareText 0087 TObject.ClassParent 0093 _DV_TPersistent 009d FindClass 00b4 @LStrClr 00ba @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 F0 FE FF FF 53 56 57 33 C9 89 4D F0 89 55 FC 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 E8 ?? ?? ?? ?? 89 45 F4 EB 62 8B 45 F4 E8 ?? ?? ?? ?? 8B F0 85 F6 74 49 0F BF 1E 4B 85 DB 7C 41 43 C7 45 F8 00 00 00 00 8B 45 F8 8B 44 86 02 8B 38 8D 95 F0 FE FF FF 8B C7 E8 ?? ?? ?? ?? 8D 95 F0 FE FF FF 8D 45 F0 E8 ?? ?? ?? ?? 8B 45 F0 8B 55 FC E8 ?? ?? ?? ?? 85 C0 74 26 FF 45 F8 4B 75 C7 8B 45 F4 E8 ?? ?? ?? ?? 89 45 F4 8B 45 F4 3B 05 ?? ?? ?? ?? 75 93 8B 45 FC E8 ?? ?? ?? ?? 8B F8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C7 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1694_0 {
	meta:
		name = "RegisterClass"
		size = 291
		refs = "001c RegisterClass 0027 ClassList 002c TThreadList.LockList 004e TObject.ClassName 005c @LStrFromString 0064 GetClass 008c SDuplicateClass 0091 LoadResString 009e _DV_EFilerError 00a3 Exception.CreateFmt 00a8 @RaiseExcept 00b1 TList.Add 00b7 _DV_TPersistent 00c0 TObject.ClassParent 00cb TList.IndexOf 00e9 TThreadList.UnlockList 00ef @HandleFinally 0109 @LStrClr"
	strings:
		$1 = { 55 8B EC 81 C4 F0 FE FF FF 53 56 33 D2 89 95 F0 FE FF FF 89 55 FC 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 E9 81 00 00 00 8D 95 FC FE FF FF 8B C3 E8 ?? ?? ?? ?? 8D 95 FC FE FF FF 8D 45 FC E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 85 C0 74 40 8B 45 FC 89 85 F4 FE FF FF C6 85 F8 FE FF FF 0B 8D 85 F4 FE FF FF 50 6A 00 8D 95 F0 FE FF FF A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 8D F0 FE FF FF B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 3B 1D ?? ?? ?? ?? 74 19 8B C3 E8 ?? ?? ?? ?? 8B D8 8B D3 8B C6 E8 ?? ?? ?? ?? 40 0F 84 6F FF FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EE 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 F0 FE FF FF E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E5 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1695_0 {
	meta:
		name = "RegisterClasses"
		size = 52
		refs = "0020 RegisterClass"
	strings:
		$1 = { 55 8B EC 53 56 8B CA 85 C9 78 07 8B 1C 88 49 53 79 F9 8B C4 8B F2 85 F6 7C 10 46 8B D8 8B 03 E8 ?? ?? ?? ?? 83 C3 04 4E 75 F3 8B 75 F8 8B 5D FC 8B E5 5D C3 }
	condition:
		$1
}

rule function_1698_0 {
	meta:
		name = "UnRegisterClasses"
		size = 52
		refs = "0020 UnRegisterClass"
	strings:
		$1 = { 55 8B EC 53 56 8B CA 85 C9 78 07 8B 1C 88 49 53 79 F9 8B C4 8B F2 85 F6 7C 10 46 8B D8 8B 03 E8 ?? ?? ?? ?? 83 C3 04 4E 75 F3 8B 75 F8 8B 5D FC 8B E5 5D C3 }
	condition:
		$1
}

rule function_1696_0 {
	meta:
		name = "RegisterClassAlias"
		size = 89
		refs = "000a ClassList 000f TThreadList.LockList 0017 RegisterClassAlias 0024 RegisterClass 002d ClassAliasList 0049 TThreadList.UnlockList 004f @HandleFinally"
	strings:
		$1 = { 55 8B EC 53 56 8B F2 8B D8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 8B CB 8B D6 A1 ?? ?? ?? ?? 8B 18 FF 53 38 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EE 5E 5B 5D C3 }
	condition:
		$1
}

rule function_1697_0 {
	meta:
		name = "UnRegisterClass"
		size = 13
		refs = "0003 ClassList 0008 TThreadList.Remove"
	strings:
		$1 = { 8B D0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_6808_0 {
	meta:
		name = "InitProc"
		size = 13
		refs = "0003 InputReqClass 0008 TInputReqClass.RegisterCallback"
	strings:
		$1 = { 8B D0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1699_0 {
	meta:
		name = "UnRegisterModuleClasses"
		size = 198
		refs = "000c ClassList 0011 TThreadList.LockList 001b UnRegisterModuleClasses 0039 TList.Get 003f VirtualQuery 0051 TList.Delete 005c ClassAliasList 00b3 TThreadList.UnlockList 00b9 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 8B F0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 5F 08 4B 83 FB 00 7C 2D 6A 1C 8D 45 E4 50 8B D3 8B C7 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 F6 74 05 3B 75 E8 75 09 8B D3 8B C7 E8 ?? ?? ?? ?? 4B 83 FB FF 75 D3 A1 ?? ?? ?? ?? 8B 10 FF 52 14 8B D8 4B 83 FB 00 7C 33 6A 1C 8D 45 E4 50 8B D3 A1 ?? ?? ?? ?? 8B 08 FF 51 18 50 E8 ?? ?? ?? ?? 85 F6 74 05 3B 75 E8 75 0C 8B D3 A1 ?? ?? ?? ?? 8B 08 FF 51 44 4B 83 FB FF 75 CD 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EE 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1700_0 {
	meta:
		name = "RegisterComponents"
		size = 125
		refs = "001a RegisterComponents 0026 RegisterComponentsProc 0039 SRegisterError 003e LoadResString 0048 _DV_EComponentError 004d Exception.Create 0052 @RaiseExcept 0067 @LStrClr 006d @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B D9 85 DB 78 07 8B 34 9A 4B 56 79 F9 8B D4 33 DB 55 68 ?? ?? ?? ?? 64 FF 33 64 89 23 83 3D ?? ?? ?? ?? 00 74 08 FF 15 ?? ?? ?? ?? EB 21 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 75 F4 8B 5D F8 8B E5 5D C3 }
	condition:
		$1
}

rule function_1701_0 {
	meta:
		name = "RegisterNoIcon"
		size = 121
		refs = "0019 RegisterNoIcon 0025 RegisterNoIconProc 0038 SRegisterError 003d LoadResString 0047 _DV_EComponentError 004c Exception.Create 0051 @RaiseExcept 0066 @LStrClr 006c @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B CA 85 C9 78 07 8B 1C 88 49 53 79 F9 8B C4 33 C9 55 68 ?? ?? ?? ?? 64 FF 31 64 89 21 83 3D ?? ?? ?? ?? 00 74 08 FF 15 ?? ?? ?? ?? EB 21 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 5D F8 8B E5 5D C3 }
	condition:
		$1
}

rule function_1702_0 {
	meta:
		name = "RegisterNonActiveX"
		size = 123
		refs = "001a RegisterNonActiveX 0026 RegisterNonActiveXProc 0031 SRegisterError 0036 LoadResString 0040 _DV_EComponentError 0045 Exception.Create 004a @RaiseExcept 0065 @LStrClr 006b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B DA 85 DB 78 07 8B 34 98 4B 56 79 F9 8B C4 33 DB 55 68 ?? ?? ?? ?? 64 FF 33 64 89 23 83 3D ?? ?? ?? ?? 00 75 21 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 75 F4 8B 5D F8 8B E5 5D C3 }
	condition:
		$1
}

rule function_1703_0 {
	meta:
		name = "TIntConst.Create"
		size = 53
		refs = "000b @ClassCreate 0023 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 48 04 8B 4D 0C 89 48 08 8B 4D 08 89 48 0C 84 D2 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 5D C2 08 00 }
	condition:
		$1
}

rule function_1704_0 {
	meta:
		name = "RegisterIntegerConsts"
		size = 41
		refs = "0010 _DV_TIntConst 0015 TIntConst.Create 001c IntConstList 0021 TThreadList.Add"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 56 57 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1705_0 {
	meta:
		name = "IdentToInt"
		size = 64
		refs = "001c CompareText"
	strings:
		$1 = { 55 8B EC 51 53 56 57 89 55 FC 8B F8 8B 75 08 85 F6 7C 23 46 8D 59 04 8B D7 8B 03 E8 ?? ?? ?? ?? 85 C0 75 0C B0 01 8B 55 FC 8B 4B FC 89 0A EB 08 83 C3 08 4E 75 E1 33 C0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_1706_0 {
	meta:
		name = "IntToIdent"
		size = 67
		refs = "0027 @LStrAsg"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 89 4D FC 8B FA 8B 75 08 85 F6 7C 1E 46 8B 5D FC 3B 03 75 10 C6 45 FB 01 8B C7 8B 53 04 E8 ?? ?? ?? ?? EB 0A 83 C3 08 4E 75 E6 C6 45 FB 00 8A 45 FB 5F 5E 5B 59 59 5D C2 04 00 }
	condition:
		$1
}

rule function_1707_0 {
	meta:
		name = "InternalReadComponentRes"
		size = 133
		refs = "0013 HInstance 001e @LStrToPChar 0025 FindResource 003a _DV_TResourceStream 003f TResourceStream.Create 004a InternalReadComponentRes 005a TStream.ReadComponent 0071 TObject.Free 0077 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B F1 8B DA 8B F8 85 DB 75 08 8B 1D ?? ?? ?? ?? 8B 1B 6A 0A 8B C7 E8 ?? ?? ?? ?? 50 53 E8 ?? ?? ?? ?? 85 C0 0F 95 C0 84 C0 74 4D 57 6A 0A 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 16 8B 45 FC E8 ?? ?? ?? ?? 89 06 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 B0 01 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1708_0 {
	meta:
		name = "BeginGlobalLoading"
		size = 96
		refs = "0002 @GetTls 0008 GlobalLists 0012 _DV_TList 0017 TObject.Create 002f GlobalLoaded 0041 TList.Add"
	strings:
		$1 = { 53 E8 ?? ?? ?? ?? 83 B8 ?? ?? ?? ?? 00 75 19 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 89 98 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 89 98 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1709_0 {
	meta:
		name = "NotifyGlobalLoading"
		size = 54
		refs = "0003 @GetTls 0009 GlobalLoaded 0026 TList.Get"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 8B 58 08 4B 85 DB 7C 1E 43 33 F6 E8 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 8B 10 FF 52 0C 46 4B 75 E5 5E 5B C3 }
	condition:
		$1
}

rule function_1710_0 {
	meta:
		name = "EndGlobalLoading"
		size = 127
		refs = "0002 @GetTls 0008 GlobalLoaded 000d TObject.Free 0018 GlobalLists 001d TList.Last 004b TList.Delete"
	strings:
		$1 = { 53 E8 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 89 98 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 8B 40 08 48 50 E8 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 83 78 08 00 75 1D E8 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 D2 89 90 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1711_0 {
	meta:
		name = "InitComponent"
		size = 165
		refs = "0016 InitComponent 0024 _DV_TComponent 0039 TObject.ClassParent 004e TObject.ClassName 005c @LStrFromString 0067 FindClassHInstance 006c FindResourceHInstance 007a InternalReadComponentRes 0091 @LStrClr 0097 @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 FC FE FF FF 53 56 33 D2 89 55 FC 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 DB 3B 35 ?? ?? ?? ?? 74 56 8B 45 08 3B 70 F8 74 4E 8B 45 08 50 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B D8 8D 95 FC FE FF FF 8B C6 E8 ?? ?? ?? ?? 8D 95 FC FE FF FF 8D 45 FC E8 ?? ?? ?? ?? 8B 45 FC 50 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B 45 08 8D 48 FC 58 E8 ?? ?? ?? ?? 0A D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1712_0 {
	meta:
		name = "InitInheritedComponent"
		size = 142
		refs = "000d GlobalNameSpace 0012 TMultiReadExclusiveWriteSynchronizer.BeginWrite 001a InitInheritedComponent 0025 BeginGlobalLoading 003c TObject.ClassType 0041 InitComponent 004a NotifyGlobalLoading 005c EndGlobalLoading 0062 @HandleFinally 007b TMultiReadExclusiveWriteSynchronizer.EndWrite"
	strings:
		$1 = { 55 8B EC 83 C4 F4 89 55 F8 89 45 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 55 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 88 45 F7 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F3 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EE 8A 45 F7 8B E5 5D C3 }
	condition:
		$1
}

rule function_1713_0 {
	meta:
		name = "InitComponentRes"
		size = 39
		refs = "000b TObject.ClassType 0010 FindClassHInstance 0015 FindResourceHInstance 0020 InternalReadComponentRes"
	strings:
		$1 = { 53 51 89 14 24 8B D8 8B 04 24 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B CC 8B C3 E8 ?? ?? ?? ?? 5A 5B C3 }
	condition:
		$1
}

rule function_1714_0 {
	meta:
		name = "ReadComponentRes"
		size = 166
		refs = "0016 ReadComponentRes 002a TObject.ClassType 002f FindClassHInstance 0034 FindResourceHInstance 0046 InternalReadComponentRes 0064 SResNotFound 0069 LoadResString 0073 _DV_EResNotFound 0078 Exception.CreateFmt 007d @RaiseExcept 0092 @LStrClr 0098 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 33 C9 89 4D F0 89 55 FC 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 7D FC 00 74 16 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 EB 02 33 DB 8D 4D FC 8B D3 8B C6 E8 ?? ?? ?? ?? 84 C0 74 05 8B 5D FC EB 2E 89 75 F4 C6 45 F8 0B 8D 45 F4 50 6A 00 8D 55 F0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D F0 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1715_0 {
	meta:
		name = "ReadComponentResEx"
		size = 140
		refs = "0015 ReadComponentResEx 002c InternalReadComponentRes 004a SResNotFound 004f LoadResString 0059 _DV_EResNotFound 005e Exception.CreateFmt 0063 @RaiseExcept 0078 @LStrClr 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 33 C9 89 4D F0 8B DA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 89 45 FC 8D 4D FC 8B D6 8B C3 E8 ?? ?? ?? ?? 84 C0 74 05 8B 5D FC EB 2E 89 5D F4 C6 45 F8 0B 8D 45 F4 50 6A 00 8D 55 F0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D F0 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1716_0 {
	meta:
		name = "ReadComponentResFile"
		size = 92
		refs = "0010 _DV_TFileStream 0015 TFileStream.Create 0020 ReadComponentResFile 0030 TStream.ReadComponentRes 0048 TObject.Free 004e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 8B DA 6A 00 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D3 8B 45 F8 E8 ?? ?? ?? ?? 89 45 FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 FC 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1717_0 {
	meta:
		name = "WriteComponentResFile"
		size = 170
		refs = "0015 WriteComponentResFile 0029 _DV_TFileStream 002e TFileStream.Create 004c TObject.ClassName 005a @LStrFromString 0067 TStream.WriteComponentRes 007c TObject.Free 0082 @HandleFinally 0099 @LStrClr"
	strings:
		$1 = { 55 8B EC 81 C4 F8 FE FF FF 53 33 C9 89 4D F8 8B DA 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 68 FF FF 00 00 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 95 F8 FE FF FF 8B 03 E8 ?? ?? ?? ?? 8D 95 F8 FE FF FF 8D 45 F8 E8 ?? ?? ?? ?? 8B 55 F8 8B CB 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1718_0 {
	meta:
		name = "WriteCollection"
		size = 86
		refs = "0011 _DV_TWriter 0016 TFiler.Create 0021 WriteCollection 0031 TWriter.WriteCollection 0046 TObject.Free 004c @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B DA 68 00 04 00 00 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D3 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1719_0 {
	meta:
		name = "CollectionsEqual"
		size = 273
		refs = "0014 TObject.ClassType 002c TCollection.GetCount 0044 _DV_TMemoryStream 0049 TObject.Create 0054 CollectionsEqual 0064 WriteCollection 0093 TStream.GetSize 00bc CompareMem 00de TObject.Free 00e4 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 8B F2 8B D8 C6 45 FF 00 8B C3 E8 ?? ?? ?? ?? 8B F8 8B C6 E8 ?? ?? ?? ?? 3B F8 0F 85 DE 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B F8 8B C6 E8 ?? ?? ?? ?? 3B F8 0F 85 C6 00 00 00 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D3 8B 45 F8 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D6 8B 45 F4 E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 8B D8 8B 45 F4 E8 ?? ?? ?? ?? 3B D8 75 1F 8B 45 F8 E8 ?? ?? ?? ?? 8B C8 8B 45 F4 8B 50 04 8B 45 F8 8B 40 04 E8 ?? ?? ?? ?? 84 C0 75 04 33 C0 EB 02 B0 01 88 45 FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8A 45 FF 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1720_0 {
	meta:
		name = "LineStart"
		size = 30
	strings:
		$1 = { 57 89 D7 89 D1 29 C1 83 E9 01 76 10 89 C2 4F B0 0A FD F2 AE FC 89 D0 75 03 8D 47 02 5F C3 }
	condition:
		$1
}

rule function_1721_0 {
	meta:
		name = "ExtractStrings"
		size = 480
		refs = "0031 ExtractStrings 006d TStrings.BeginUpdate 009c @SetUnion 013d @LStrFromPCharLen 016b TStrings.EndUpdate 0171 @HandleFinally 0188 @LStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 90 53 56 57 33 DB 89 5D F0 8B F2 8D 7D B0 51 B9 08 00 00 00 F3 A5 59 8B F0 8D 7D D0 51 B9 08 00 00 00 F3 A5 59 89 4D FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 89 45 F8 83 7D FC 00 0F 84 2D 01 00 00 8B 45 FC 80 38 00 0F 84 21 01 00 00 83 7D 08 00 0F 84 17 01 00 00 8B 75 FC 33 DB C6 45 F6 00 8B 45 08 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 EB 01 46 56 8D 75 B0 8D 7D 90 B9 08 00 00 00 F3 A5 5E 8D 45 90 BA ?? ?? ?? ?? B1 20 E8 ?? ?? ?? ?? 8A 06 25 FF 00 00 00 0F A3 45 90 72 D4 8B FE EB 01 46 84 DB 74 0E 8A 06 84 C0 74 08 2C 22 74 04 2C 05 75 ED 56 57 8D 75 D0 8D 7D 90 B9 08 00 00 00 F3 A5 5F 5E 8D 45 90 BA ?? ?? ?? ?? B1 20 E8 ?? ?? ?? ?? 8A 06 25 FF 00 00 00 0F A3 45 90 73 C0 8A 06 2C 22 74 04 2C 05 75 22 80 7D F6 00 74 0D 8A 06 3A 45 F6 75 06 C6 45 F6 00 EB 05 8A 06 88 45 F6 80 7D F6 00 0F 95 C3 46 EB 95 80 3E 00 0F 94 45 F7 3B F7 74 27 80 3F 00 74 22 83 7D 08 00 74 19 8B CE 2B CF 8D 45 F0 8B D7 E8 ?? ?? ?? ?? 8B 55 F0 8B 45 08 8B 08 FF 51 34 FF 45 F8 46 80 7D F7 00 0F 84 28 FF FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 08 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 F8 5F 5E 5B 8B E5 5D C2 04 00 00 24 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 01 24 00 00 84 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_1722_0 {
	meta:
		name = "TList.Destroy"
		size = 41
		refs = "0004 @BeforeDestruction 0014 @CallDynaInst 0021 @ClassDestroy"
	strings:
		$1 = { 53 56 51 E8 ?? ?? ?? ?? 88 14 24 8B F0 8B C6 66 BB FF FF E8 ?? ?? ?? ?? 80 3C 24 00 7E 07 8B C6 E8 ?? ?? ?? ?? 5A 5E 5B C3 }
	condition:
		$1
}

rule function_1723_0 {
	meta:
		name = "TList.Add"
		size = 36
	strings:
		$1 = { 53 56 57 8B FA 8B D8 8B 73 08 3B 73 0C 75 06 8B C3 8B 10 FF 12 8B 43 04 89 3C B0 FF 43 08 8B C6 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1724_0 {
	meta:
		name = "TList.Clear"
		size = 23
		refs = "0008 TList.SetCount 0011 TList.SetCapacity"
	strings:
		$1 = { 53 8B D8 33 D2 8B C3 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1725_0 {
	meta:
		name = "TList.Delete"
		size = 126
		refs = "000f TList.Delete 0026 SListIndexError 002b LoadResString 0058 Move 006d @LStrClr 0073 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 F6 7C 05 3B 73 08 7C 17 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B CE 8B 03 FF 50 04 FF 4B 08 8B 43 08 3B F0 7D 19 2B C6 8B C8 C1 E1 02 8B 43 04 8D 14 B0 8B 43 04 8D 44 B0 04 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1726_0 {
	meta:
		name = "ReturnAddr"
		size = 4
	strings:
		$1 = { 8B 45 04 C3 }
	condition:
		$1
}

rule function_1727_0 {
	meta:
		name = "TList.Error"
		size = 55
		refs = "000a ReturnAddr 0024 _DV_EListError 0029 Exception.CreateFmt 002e @RaiseExcept"
	strings:
		$1 = { 53 56 83 C4 F8 8B F1 8B DA E8 ?? ?? ?? ?? 50 89 74 24 04 C6 44 24 08 00 8D 44 24 04 50 6A 00 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 59 5A 5E 5B C3 }
	condition:
		$1
}

rule function_1833_0 {
	meta:
		name = "TStrings.Error"
		size = 55
		refs = "000a ReturnAddr 0024 _DV_EStringListError 0029 Exception.CreateFmt 002e @RaiseExcept"
	strings:
		$1 = { 53 56 83 C4 F8 8B F1 8B DA E8 ?? ?? ?? ?? 50 89 74 24 04 C6 44 24 08 00 8D 44 24 04 50 6A 00 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 59 5A 5E 5B C3 }
	condition:
		$1
}

rule function_1728_0 {
	meta:
		name = "TList.Exchange"
		size = 158
		refs = "0018 TList.Exchange 002f SListIndexError 0034 LoadResString 008b @LStrClr 0091 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 33 DB 89 5D F8 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 F6 7C 05 3B 73 08 7C 17 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 8B CE 8B 03 FF 50 04 85 FF 7C 05 3B 7B 08 7C 17 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 8B CF 8B 03 FF 50 04 8B 43 04 8B 14 B0 89 55 FC 8B 53 04 8B 14 BA 89 14 B0 8B 55 FC 89 14 B8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1729_0 {
	meta:
		name = "TList.Expand"
		size = 21
	strings:
		$1 = { 53 8B D8 8B 43 08 3B 43 0C 75 06 8B C3 8B 10 FF 12 8B C3 5B C3 }
	condition:
		$1
}

rule function_1730_0 {
	meta:
		name = "TList.First"
		size = 8
		refs = "0003 TList.Get"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_3710_0 {
	meta:
		name = "Animate_Close"
		size = 8
		refs = "0003 Animate_Open"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_9045_0 {
	meta:
		name = "TApplication.NormalizeTopMosts"
		size = 8
		refs = "0003 TApplication.DoNormalizeTopMosts"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_19582_0 {
	meta:
		name = "TChartShape.DrawLegendShape"
		size = 8
		refs = "0003 TChartShape.DrawShape"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5884_0 {
	meta:
		name = "TClientDataSet.CancelUpdates"
		size = 8
		refs = "0003 TClientDataSet.SetSavePoint"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1793_0 {
	meta:
		name = "TCollectionItem.SetDisplayName"
		size = 8
		refs = "0003 TCollectionItem.Changed"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4150_0 {
	meta:
		name = "TControl.Hide"
		size = 8
		refs = "0003 TControl.SetVisible"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_8922_0 {
	meta:
		name = "TCustomForm.Hide"
		size = 8
		refs = "0003 TCustomForm.SetVisible"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_11903_0 {
	meta:
		name = "TCustomMaskEdit.Clear"
		size = 8
		refs = "0003 TCustomMaskEdit.SetText"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_16581_0 {
	meta:
		name = "TCustomQuickRep.PreviewModeless"
		size = 8
		refs = "0003 TCustomQuickRep.PreviewIt"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_19541_0 {
	meta:
		name = "TCustomTeePanel.PrintPortrait"
		size = 8
		refs = "0003 TCustomTeePanel.PrintOrientation"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4979_0 {
	meta:
		name = "TField.Clear"
		size = 8
		refs = "0003 TField.SetData"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_7520_0 {
	meta:
		name = "THTMLTableColumn.TitleChanged"
		size = 8
		refs = "0003 TCollectionItem.Changed"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_14954_0 {
	meta:
		name = "TOutlineNode.Collapse"
		size = 8
		refs = "0003 TOutlineNode.SetExpandedState"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_12763_0 {
	meta:
		name = "TPivotButton.DragCanceled"
		size = 8
		refs = "0003 TPivotButton.SetState"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_8019_0 {
	meta:
		name = "TPropertyEditor.GetOrdValue"
		size = 8
		refs = "0003 TPropertyEditor.GetOrdValueAt"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1985_0 {
	meta:
		name = "TReader.ReadListEnd"
		size = 8
		refs = "0003 TReader.CheckValue"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_9021_0 {
	meta:
		name = "TScreen.Realign"
		size = 8
		refs = "0003 TScreen.AlignForm"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_7021_0 {
	meta:
		name = "TSession.Close"
		size = 8
		refs = "0003 TSession.SetActive"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2521_0 {
	meta:
		name = "TTreeNode.GetCut"
		size = 8
		refs = "0003 TTreeNode.GetState"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4276_0 {
	meta:
		name = "TWinControl.Realign"
		size = 8
		refs = "0003 TWinControl.AlignControl"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2044_0 {
	meta:
		name = "TWriter.WriteListEnd"
		size = 8
		refs = "0003 TWriter.WriteValue"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1731_0 {
	meta:
		name = "TList.Get"
		size = 99
		refs = "000f TList.Get 0026 SListIndexError 002b LoadResString 0050 @LStrClr 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 F6 7C 05 3B 73 08 7C 17 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B CE 8B 03 FF 50 04 8B 43 04 8B 1C B0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1732_0 {
	meta:
		name = "TList.Grow"
		size = 49
		refs = "002c TList.SetCapacity"
	strings:
		$1 = { 8B 50 0C 83 FA 40 7E 0E 8B CA 85 C9 79 03 83 C1 03 C1 F9 02 EB 11 83 FA 08 7E 07 B9 10 00 00 00 EB 05 B9 04 00 00 00 03 CA 8B D1 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1733_0 {
	meta:
		name = "TList.IndexOf"
		size = 31
	strings:
		$1 = { 53 33 C9 EB 01 41 3B 48 08 7D 08 8B 58 04 3B 14 8B 75 F2 3B 48 08 75 03 83 C9 FF 8B C1 5B C3 }
	condition:
		$1
}

rule function_1734_0 {
	meta:
		name = "TList.Insert"
		size = 159
		refs = "0018 TList.Insert 002f SListIndexError 0034 LoadResString 006c Move 008d @LStrClr 0093 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 DB 89 5D F8 89 4D FC 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 F6 7C 05 3B 73 08 7E 17 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 8B CE 8B 03 FF 50 04 8B 43 08 3B 43 0C 75 06 8B C3 8B 10 FF 12 8B 43 08 3B F0 7D 19 2B C6 8B C8 C1 E1 02 8B 43 04 8D 54 B0 04 8B 43 04 8D 04 B0 E8 ?? ?? ?? ?? 8B 43 04 8B 55 FC 89 14 B0 FF 43 08 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1735_0 {
	meta:
		name = "TList.Last"
		size = 10
		refs = "0005 TList.Get"
	strings:
		$1 = { 8B 50 08 4A E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1736_0 {
	meta:
		name = "TList.Move"
		size = 139
		refs = "0018 TList.Move 0033 SListIndexError 0038 LoadResString 004b TList.Get 0057 TList.Delete 0063 TList.Insert 0078 @LStrClr 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 33 DB 89 5D F8 8B F1 8B FA 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 3B F7 74 41 85 F6 7C 05 3B 73 08 7C 17 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 8B CE 8B 03 FF 50 04 8B D7 8B C3 E8 ?? ?? ?? ?? 89 45 FC 8B D7 8B C3 E8 ?? ?? ?? ?? 8B 4D FC 8B D6 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1737_0 {
	meta:
		name = "TList.Put"
		size = 101
		refs = "0012 TList.Put 0029 SListIndexError 002e LoadResString 0053 @LStrClr 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 F6 7C 05 3B 73 08 7C 17 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B CE 8B 03 FF 50 04 8B 43 04 89 3C B0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1738_0 {
	meta:
		name = "TList.Remove"
		size = 32
		refs = "0007 TList.IndexOf 0017 TList.Delete"
	strings:
		$1 = { 53 56 8B D8 8B C3 E8 ?? ?? ?? ?? 8B F0 83 FE FF 74 09 8B D6 8B C3 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1739_0 {
	meta:
		name = "TList.Pack"
		size = 44
		refs = "0012 TList.Get 001f TList.Delete"
	strings:
		$1 = { 53 56 8B F0 8B 5E 08 4B 83 FB 00 7C 1C 8B D3 8B C6 E8 ?? ?? ?? ?? 85 C0 75 09 8B D3 8B C6 E8 ?? ?? ?? ?? 4B 83 FB FF 75 E4 5E 5B C3 }
	condition:
		$1
}

rule function_1740_0 {
	meta:
		name = "TList.SetCapacity"
		size = 116
		refs = "000f TList.SetCapacity 002a SListCapacityError 002f LoadResString 004b @ReallocMem 0063 @LStrClr 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 3B 73 08 7C 08 81 FE FF FF FF 07 7E 17 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B CE 8B 03 FF 50 04 3B 73 0C 74 10 8B D6 C1 E2 02 8D 43 04 E8 ?? ?? ?? ?? 89 73 0C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1741_0 {
	meta:
		name = "TList.SetCount"
		size = 141
		refs = "000f TList.SetCount 0029 SListCountError 002e LoadResString 0046 TList.SetCapacity 0064 @FillChar 007c @LStrClr 0082 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 F6 7C 08 81 FE FF FF FF 07 7E 17 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B CE 8B 03 FF 50 04 3B 73 0C 7E 09 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 43 08 3B F0 7E 17 8B 53 04 8D 14 82 8B CE 2B C8 8B C1 C1 E0 02 33 C9 92 E8 ?? ?? ?? ?? 89 73 08 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1742_0 {
	meta:
		name = "QuickSort"
		size = 129
		refs = "006c QuickSort"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 89 4D F8 89 55 FC 8B F8 8B 5D FC 8B 75 F8 8B 45 FC 03 45 F8 D1 E8 8B 04 87 89 45 F4 EB 01 43 8B 04 9F 8B 55 F4 FF 55 08 85 C0 7C F2 EB 01 4E 8B 04 B7 8B 55 F4 FF 55 08 85 C0 7F F2 3B F3 7C 0E 8B 04 9F 8B 14 B7 89 14 9F 89 04 B7 43 4E 3B F3 7D CD 3B 75 FC 7E 10 8B 45 08 50 8B CE 8B 55 FC 8B C7 E8 ?? ?? ?? ?? 89 5D FC 3B 5D F8 7C 99 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_1743_0 {
	meta:
		name = "TList.Sort"
		size = 30
		refs = "0019 QuickSort"
	strings:
		$1 = { 8B 48 04 85 C9 74 16 83 78 08 00 7E 10 52 8B 50 08 4A 8B C1 33 C9 87 D1 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1744_0 {
	meta:
		name = "TThreadList.Create"
		size = 77
		refs = "000a @ClassCreate 0017 TObject.Create 0020 InitializeCriticalSection 0027 _DV_TList 003a @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8D 46 08 50 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 04 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1745_0 {
	meta:
		name = "TThreadList.Destroy"
		size = 123
		refs = "0007 @BeforeDestruction 0015 TThreadList.LockList 001d TThreadList.Destroy 002e TObject.Free 003c TObject.Destroy 0051 TThreadList.UnlockList 005d DeleteCriticalSection 0063 @HandleFinally 0073 @ClassDestroy"
	strings:
		$1 = { 55 8B EC 83 C4 F8 E8 ?? ?? ?? ?? 88 55 FB 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 40 04 E8 ?? ?? ?? ?? 8A 55 FB 80 E2 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 83 C0 08 50 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E4 80 7D FB 00 7E 08 8B 45 FC E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule function_12744_0 {
	meta:
		name = "TThreadCustomArray.Destroy"
		size = 123
		refs = "0007 @BeforeDestruction 0015 TThreadCustomArray.LockArray 001d TThreadCustomArray.Destroy 002e TObject.Free 003c TObject.Destroy 0051 TThreadCustomArray.UnlockArray 005d DeleteCriticalSection 0063 @HandleFinally 0073 @ClassDestroy"
	strings:
		$1 = { 55 8B EC 83 C4 F8 E8 ?? ?? ?? ?? 88 55 FB 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 40 04 E8 ?? ?? ?? ?? 8A 55 FB 80 E2 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 83 C0 08 50 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E4 80 7D FB 00 7E 08 8B 45 FC E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule function_1746_0 {
	meta:
		name = "TThreadList.Add"
		size = 94
		refs = "000e TThreadList.LockList 0016 TThreadList.Add 0029 TList.IndexOf 0039 TList.Add 004e TThreadList.UnlockList 0054 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B DA 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 40 04 8B D3 E8 ?? ?? ?? ?? 40 75 0D 8B 45 FC 8B 40 04 8B D3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1747_0 {
	meta:
		name = "TThreadList.Clear"
		size = 78
		refs = "000c TThreadList.LockList 0014 TThreadList.Clear 0029 @CallDynaInst 003e TThreadList.UnlockList 0044 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 40 04 66 BB FF FF E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1748_0 {
	meta:
		name = "TThreadCustomArray.LockArray"
		size = 17
		refs = "0008 EnterCriticalSection"
		altNames = "TThreadList.LockList"
	strings:
		$1 = { 53 8B D8 8D 43 08 50 E8 ?? ?? ?? ?? 8B 43 04 5B C3 }
	condition:
		$1
}

rule function_1749_0 {
	meta:
		name = "TThreadList.Remove"
		size = 78
		refs = "000e TThreadList.LockList 0016 TThreadList.Remove 0029 TList.Remove 003e TThreadList.UnlockList 0044 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B DA 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 40 04 8B D3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1750_0 {
	meta:
		name = "TPatternManager.Unlock"
		size = 10
		refs = "0005 LeaveCriticalSection"
		altNames = "TResourceManager.Unlock TThreadCustomArray.UnlockArray TThreadList.UnlockList"
	strings:
		$1 = { 83 C0 08 50 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_9551_0 {
	meta:
		name = "TPatternManager.Lock"
		size = 10
		refs = "0005 EnterCriticalSection"
	strings:
		$1 = { 83 C0 08 50 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_9194_0 {
	meta:
		name = "TResourceManager.Lock"
		size = 10
		refs = "0005 EnterCriticalSection"
	strings:
		$1 = { 83 C0 08 50 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1751_0 {
	meta:
		name = "TInterfaceList.Create"
		size = 68
		refs = "000a @ClassCreate 0017 TObject.Create 001e _DV_TThreadList 0023 TThreadList.Create 0031 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 0C 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_7995_0 {
	meta:
		name = "TComponentList.Create"
		size = 68
		refs = "000a @ClassCreate 0017 TObject.Create 001e _Dn_TList 0031 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 0C 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1752_0 {
	meta:
		name = "TInterfaceList.Destroy"
		size = 52
		refs = "0003 @BeforeDestruction 000e TInterfaceList.Clear 0016 TObject.Free 0022 TObject.Destroy 002d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B 46 0C E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1753_0 {
	meta:
		name = "TInterfaceList.Clear"
		size = 116
		refs = "0015 TThreadList.LockList 001f TInterfaceList.Clear 003b @IntfClear 004a @CallDynaInst 0062 TThreadList.UnlockList 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 57 89 45 FC 8B 45 FC 8B 40 0C 85 C0 74 5A E8 ?? ?? ?? ?? 8B F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 5F 08 4B 85 DB 7C 12 43 33 F6 8B 47 04 8D 04 B0 E8 ?? ?? ?? ?? 46 4B 75 F1 8B C7 66 BB FF FF E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 40 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1754_0 {
	meta:
		name = "TInterfaceList.Delete"
		size = 96
		refs = "0012 TThreadList.LockList 001c TInterfaceList.Delete 002e TInterfaceList.Put 0037 TList.Delete 004f TThreadList.UnlockList 0055 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 8B DA 89 45 FC 8B 45 FC 8B 40 0C E8 ?? ?? ?? ?? 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C9 8B D3 8B 45 FC E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 40 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1755_0 {
	meta:
		name = "TInterfaceList.Expand"
		size = 84
		refs = "0010 TThreadList.LockList 0018 TInterfaceList.Expand 0023 TList.Expand 0041 TThreadList.UnlockList 0047 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 89 45 FC 8B 45 FC 8B 40 0C E8 ?? ?? ?? ?? 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 E8 ?? ?? ?? ?? 8B 45 FC 89 45 F8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 40 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 8B 45 F8 59 59 5D C3 }
	condition:
		$1
}

rule function_1756_0 {
	meta:
		name = "TInterfaceList.First"
		size = 20
		refs = "000d TInterfaceList.Get"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B CE 33 D2 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_4617_0 {
	meta:
		name = "TCopyParser.SkipToEOF"
		size = 20
		refs = "000d TCopyParser.CopySkipToEOF"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B CE 33 D2 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_4616_0 {
	meta:
		name = "TCopyParser.SkipToEOL"
		size = 20
		refs = "000d TCopyParser.CopySkipToEOL"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B CE 33 D2 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_8015_0 {
	meta:
		name = "TPropertyEditor.GetMethodValue"
		size = 20
		refs = "000d TPropertyEditor.GetMethodValueAt"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B CE 33 D2 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_8025_0 {
	meta:
		name = "TPropertyEditor.GetStrValue"
		size = 20
		refs = "000d TPropertyEditor.GetStrValueAt"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B CE 33 D2 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_8027_0 {
	meta:
		name = "TPropertyEditor.GetVarValue"
		size = 20
		refs = "000d TPropertyEditor.GetVarValueAt"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B CE 33 D2 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1757_0 {
	meta:
		name = "TInterfaceList.Get"
		size = 92
		refs = "0015 TThreadList.LockList 001f TInterfaceList.Get 0032 @IntfCopy 004a TThreadList.UnlockList 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B F9 8B F2 89 45 FC 8B 45 FC 8B 40 0C E8 ?? ?? ?? ?? 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 8B 53 04 8B 14 B2 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 40 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1758_0 {
	meta:
		name = "TInterfaceList.GetCapacity"
		size = 79
		refs = "0010 TThreadList.LockList 0018 TInterfaceList.GetCapacity 003c TThreadList.UnlockList 0042 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 89 45 FC 8B 45 FC 8B 40 0C E8 ?? ?? ?? ?? 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 40 0C 89 45 F8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 40 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 8B 45 F8 59 59 5D C3 }
	condition:
		$1
}

rule function_1759_0 {
	meta:
		name = "TInterfaceList.GetCount"
		size = 79
		refs = "0010 TThreadList.LockList 0018 TInterfaceList.GetCount 003c TThreadList.UnlockList 0042 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 89 45 FC 8B 45 FC 8B 40 0C E8 ?? ?? ?? ?? 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 40 08 89 45 F8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 40 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 8B 45 F8 59 59 5D C3 }
	condition:
		$1
}

rule function_1760_0 {
	meta:
		name = "TInterfaceList.IndexOf"
		size = 138
		refs = "0010 @IntfAddRef 0018 TInterfaceList.IndexOf 0029 TThreadList.LockList 003f TList.IndexOf 005a TThreadList.UnlockList 0060 @HandleFinally 0077 @IntfClear"
	strings:
		$1 = { 55 8B EC 83 C4 F4 89 55 F8 89 45 FC 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 40 0C E8 ?? ?? ?? ?? 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 55 F8 E8 ?? ?? ?? ?? 89 45 F4 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 40 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule function_1761_0 {
	meta:
		name = "TInterfaceList.Add"
		size = 160
		refs = "0011 @IntfAddRef 0019 TInterfaceList.Add 002a TThreadList.LockList 0043 TList.Add 0057 @IntfCopy 006f TThreadList.UnlockList 0075 @HandleFinally 008c @IntfClear"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 89 55 F8 89 45 FC 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 40 0C E8 ?? ?? ?? ?? 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B C3 E8 ?? ?? ?? ?? 89 45 F4 8B 43 04 8B 55 F4 8D 04 90 8B 55 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 40 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 F4 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1762_0 {
	meta:
		name = "TInterfaceList.Insert"
		size = 157
		refs = "0014 @IntfAddRef 001c TInterfaceList.Insert 002d TThreadList.LockList 0048 TList.Insert 0056 @IntfCopy 006e TThreadList.UnlockList 0074 @HandleFinally 008b @IntfClear"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 89 4D F8 8B F2 89 45 FC 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 40 0C E8 ?? ?? ?? ?? 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C9 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 43 04 8D 04 B0 8B 55 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 40 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1763_0 {
	meta:
		name = "TInterfaceList.Last"
		size = 89
		refs = "0012 TThreadList.LockList 001c TInterfaceList.Last 0030 TInterfaceList.Get 0048 TThreadList.UnlockList 004e @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 8B F2 89 45 FC 8B 45 FC 8B 40 0C E8 ?? ?? ?? ?? 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B CE 8B 53 08 4A 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 40 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1764_0 {
	meta:
		name = "TInterfaceList.Put"
		size = 191
		refs = "0019 @IntfAddRef 0021 TInterfaceList.Put 0032 TThreadList.LockList 0053 SListIndexError 0058 LoadResString 0070 @IntfCopy 0088 TThreadList.UnlockList 008e @HandleFinally 00a5 @LStrClr 00ad @IntfClear"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 33 DB 89 5D F4 89 4D F8 8B DA 89 45 FC 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 40 0C E8 ?? ?? ?? ?? 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 DB 7C 05 3B 5E 08 7C 17 8D 55 F4 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F4 8B 06 8B CB FF 50 04 8B 46 04 8D 04 98 8B 55 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 40 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1765_0 {
	meta:
		name = "TInterfaceList.Remove"
		size = 174
		refs = "0011 @IntfAddRef 0019 TInterfaceList.Remove 002a TThreadList.LockList 0044 TList.IndexOf 005b @IntfClear 0065 TList.Delete 007d TThreadList.UnlockList 0083 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 89 55 F8 89 45 FC 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 40 0C E8 ?? ?? ?? ?? 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 F8 8B C3 E8 ?? ?? ?? ?? 89 45 F4 83 7D F4 FF 7E 18 8B 43 04 8B 55 F4 8D 04 90 E8 ?? ?? ?? ?? 8B 55 F4 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 40 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 F4 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1766_0 {
	meta:
		name = "TInterfaceList.SetCapacity"
		size = 78
		refs = "0011 TThreadList.LockList 0019 TInterfaceList.SetCapacity 0026 TList.SetCapacity 003e TThreadList.UnlockList 0044 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B DA 89 45 FC 8B 45 FC 8B 40 0C E8 ?? ?? ?? ?? 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B D3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 40 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 5B 59 5D C3 }
	condition:
		$1
}

rule function_1767_0 {
	meta:
		name = "TInterfaceList.SetCount"
		size = 78
		refs = "0011 TThreadList.LockList 0019 TInterfaceList.SetCount 0026 TList.SetCount 003e TThreadList.UnlockList 0044 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B DA 89 45 FC 8B 45 FC 8B 40 0C E8 ?? ?? ?? ?? 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B D3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 40 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 5B 59 5D C3 }
	condition:
		$1
}

rule function_1768_0 {
	meta:
		name = "TInterfaceList.Exchange"
		size = 84
		refs = "0014 TThreadList.LockList 001c TInterfaceList.Exchange 002b TList.Exchange 0043 TThreadList.UnlockList 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 8B F1 8B DA 89 45 FC 8B 45 FC 8B 40 0C E8 ?? ?? ?? ?? 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B CE 8B D3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 40 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1769_0 {
	meta:
		name = "TInterfaceList.Lock"
		size = 9
		refs = "0004 TThreadList.LockList"
	strings:
		$1 = { 8B 40 0C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_7999_0 {
	meta:
		name = "TComponentList.Add"
		size = 9
		refs = "0004 TList.Add"
	strings:
		$1 = { 8B 40 0C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1770_0 {
	meta:
		name = "TInterfaceList.Unlock"
		size = 9
		refs = "0004 TThreadList.UnlockList"
	strings:
		$1 = { 8B 40 0C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_14973_0 {
	meta:
		name = "TOutlineStrings.Clear"
		size = 9
		refs = "0004 TCustomOutline.Clear"
	strings:
		$1 = { 8B 40 0C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_14972_0 {
	meta:
		name = "TOutlineStrings.GetCount"
		size = 9
		refs = "0004 TCustomOutline.GetItemCount"
	strings:
		$1 = { 8B 40 0C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_9850_0 {
	meta:
		name = "TStringGridStrings.SetUpdateState"
		size = 9
		refs = "0004 TStringGrid.SetUpdateState"
	strings:
		$1 = { 8B 40 0C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_9833_0 {
	meta:
		name = "TStringSparseList.Exchange"
		size = 9
		refs = "0004 TSparseList.Exchange"
	strings:
		$1 = { 8B 40 0C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2602_0 {
	meta:
		name = "TTreeStrings.Clear"
		size = 9
		refs = "0004 TTreeNodes.Clear"
	strings:
		$1 = { 8B 40 0C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2601_0 {
	meta:
		name = "TTreeStrings.GetCount"
		size = 9
		refs = "0004 TTreeNodes.GetCount"
	strings:
		$1 = { 8B 40 0C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1771_0 {
	meta:
		name = "TBits.Destroy"
		size = 46
		refs = "0003 @BeforeDestruction 0010 TBits.SetSize 001c TObject.Destroy 0027 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1786_0 {
	meta:
		name = "TCollectionItem.Destroy"
		size = 46
		refs = "0003 @BeforeDestruction 0010 TCollectionItem.SetCollection 001c TPersistent.Destroy 0027 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_12941_0 {
	meta:
		name = "TDecisionDataLink.Destroy"
		size = 46
		refs = "0003 @BeforeDestruction 0010 TDecisionDataLink.SetDecisionSource 001c TPersistent.Destroy 0027 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_11072_0 {
	meta:
		name = "TIdUDPBase.Destroy"
		size = 46
		refs = "0003 @BeforeDestruction 0010 TIdUDPBase.SetActive 001c TIdComponent.Destroy 0027 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_4570_0 {
	meta:
		name = "TMouse.Destroy"
		size = 46
		refs = "0003 @BeforeDestruction 0010 TMouse.SetCapture 001c TObject.Destroy 0027 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1821_0 {
	meta:
		name = "TStrings.Destroy"
		size = 46
		refs = "0003 @BeforeDestruction 0010 TStrings.SetStringsAdapter 001c TPersistent.Destroy 0027 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1772_0 {
	meta:
		name = "TBits.Error"
		size = 84
		refs = "0009 TBits.Error 0017 SBitsIndexError 001c LoadResString 0026 _DV_EBitsError 002b Exception.Create 0030 @RaiseExcept 0045 @LStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_18626_0 {
	meta:
		name = "ALV"
		size = 84
		refs = "0009 ALV 0017 SNL 001c LoadResString 0026 _DV_Exception 002b Exception.Create 0030 @RaiseExcept 0045 @LStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_12611_0 {
	meta:
		name = "ArrayDuplicateError"
		size = 84
		refs = "0009 ArrayDuplicateError 0017 sDupeItem 001c LoadResString 0026 _DV_EArrayError 002b Exception.Create 0030 @RaiseExcept 0045 @LStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_10337_0 {
	meta:
		name = "DoMailBRdata"
		size = 84
		refs = "0009 DoMailBRdata 0017 RSDNSMailBNotImplemented 001c LoadResString 0026 _Dn_EIdDnsResolverError 002b Exception.Create 0030 @RaiseExcept 0045 @LStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_9309_0 {
	meta:
		name = "Error"
		size = 84
		refs = "0009 Error 0017 SNoCanvasHandle 001c LoadResString 0026 _Dn_EInvalidOperation 002b Exception.Create 0030 @RaiseExcept 0045 @LStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_12603_0 {
	meta:
		name = "LowCapacityError"
		size = 84
		refs = "0009 LowCapacityError 0017 sLowCapacityError 001c LoadResString 0026 _DV_ELowCapacityError 002b Exception.Create 0030 @RaiseExcept 0045 @LStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_9324_0 {
	meta:
		name = "OutOfResources"
		size = 84
		refs = "0009 OutOfResources 0017 SOutOfResources 001c LoadResString 0026 _Dn_EOutOfResources 002b Exception.Create 0030 @RaiseExcept 0045 @LStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_3924_0 {
	meta:
		name = "RaiseException"
		size = 84
		refs = "0009 RaiseException 0017 SVarNotObject 001c LoadResString 0026 _DV_EOleError 002b Exception.Create 0030 @RaiseExcept 0045 @LStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_12009_0 {
	meta:
		name = "RaiseOverflowError"
		size = 84
		refs = "0009 RaiseOverflowError 0017 SIntOverflow 001c LoadResString 0026 _Dn_EIntOverflow 002b Exception.Create 0030 @RaiseExcept 0045 @LStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_9810_0 {
	meta:
		name = "TSparseList.Error"
		size = 84
		refs = "0009 TSparseList.Error 0017 SListIndexError 001c LoadResString 0026 _Dn_EListError 002b Exception.Create 0030 @RaiseExcept 0045 @LStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_9831_0 {
	meta:
		name = "TStringSparseList.Error"
		size = 84
		refs = "0009 TStringSparseList.Error 0017 SPutObjectError 001c LoadResString 0026 _DV_EStringSparseListError 002b Exception.Create 0030 @RaiseExcept 0045 @LStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_1773_0 {
	meta:
		name = "Min"
		size = 11
	strings:
		$1 = { 8B C8 3B D0 7D 02 8B CA 8B C1 C3 }
	condition:
		$1
}

rule function_1774_0 {
	meta:
		name = "TBits.SetSize"
		size = 162
		refs = "0019 TBits.Error 0056 @GetMem 0065 @FillChar 0078 Min 0085 Move 008f @FreeMem"
	strings:
		$1 = { 53 56 57 55 51 8B F2 8B D8 3B 73 04 0F 84 8A 00 00 00 85 F6 7D 07 8B C3 E8 ?? ?? ?? ?? 8D 46 20 48 85 C0 79 03 83 C0 1F C1 F8 05 8B F8 C1 E7 02 8B 43 04 83 C0 20 48 85 C0 79 03 83 C0 1F C1 F8 05 8B E8 C1 E5 02 3B EF 74 4F 33 C0 89 04 24 85 FF 74 16 8B C7 E8 ?? ?? ?? ?? 89 04 24 8B 04 24 33 C9 8B D7 E8 ?? ?? ?? ?? 85 ED 74 26 83 3C 24 00 74 16 8B D7 8B C5 E8 ?? ?? ?? ?? 8B C8 8B 14 24 8B 43 08 E8 ?? ?? ?? ?? 8B D5 8B 43 08 E8 ?? ?? ?? ?? 8B 04 24 89 43 08 89 73 04 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1775_0 {
	meta:
		name = "TBits.SetBit"
		size = 44
		refs = "0019 TBits.Error 0022 TBits.SetSize"
	strings:
		$1 = { 3B 50 04 73 0F 8B 40 08 08 C9 74 04 0F AB 10 C3 0F B3 10 C3 83 FA 00 0F 8C ?? ?? ?? ?? 50 52 51 42 E8 ?? ?? ?? ?? 59 5A 58 EB DA C3 }
	condition:
		$1
}

rule function_1776_0 {
	meta:
		name = "TBits.GetBit"
		size = 21
		refs = "0005 TBits.Error"
	strings:
		$1 = { 3B 50 04 0F 83 ?? ?? ?? ?? 8B 40 08 0F A3 10 19 C0 83 E0 01 C3 }
	condition:
		$1
}

rule function_1777_0 {
	meta:
		name = "TBits.OpenBit"
		size = 120
		refs = "0027 TBits.OpenBit"
	strings:
		$1 = { 53 56 57 51 8B D8 8B 43 04 83 C0 20 48 85 C0 79 03 83 C0 1F C1 F8 05 48 85 C0 7C 4D 40 89 04 24 33 F6 8B 43 08 8B 15 ?? ?? ?? ?? 3B 14 B0 74 33 8B 43 08 8B 3C B0 33 C0 8B D0 80 FA 1F 77 06 83 E2 7F 0F A3 D7 72 17 8B D6 C1 E2 05 83 E0 7F 03 D0 8B C2 8B 53 04 3B C2 7C 12 8B C2 EB 0E 40 3C 20 75 D5 46 FF 0C 24 75 B9 8B 43 04 5A 5F 5E 5B C3 00 00 00 FF FF FF FF }
	condition:
		$1
}

rule function_1778_0 {
	meta:
		name = "TPersistent.Destroy"
		size = 44
		refs = "0003 @BeforeDestruction 000e RemoveFixups 001a TObject.Destroy 0025 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_9452_0 {
	meta:
		name = "TBitmapCanvas.Destroy"
		size = 44
		refs = "0003 @BeforeDestruction 000e TBitmapCanvas.FreeContext 001a TCanvas.Destroy 0025 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_4048_0 {
	meta:
		name = "TControlCanvas.Destroy"
		size = 44
		refs = "0003 @BeforeDestruction 000e TControlCanvas.FreeHandle 001a TCanvas.Destroy 0025 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_13347_0 {
	meta:
		name = "TDataCache.Destroy"
		size = 44
		refs = "0003 @BeforeDestruction 000e TDataCache.FreeCache 001a TObject.Destroy 0025 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_7665_0 {
	meta:
		name = "TDdeCliItem.Destroy"
		size = 44
		refs = "0003 @BeforeDestruction 000e TDdeCliItem.StopAdvise 001a TPersistent.Destroy 0025 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_6554_0 {
	meta:
		name = "TGridDataLink.Destroy"
		size = 44
		refs = "0003 @BeforeDestruction 000e TGridDataLink.ClearMapping 001a TDataLink.Destroy 0025 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_7537_0 {
	meta:
		name = "THTTPDataLink.Destroy"
		size = 44
		refs = "0003 @BeforeDestruction 000e THTTPDataLink.ClearMapping 001a TDataLink.Destroy 0025 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2926_0 {
	meta:
		name = "TListItems.Destroy"
		size = 44
		refs = "0003 @BeforeDestruction 000e TListItems.Clear 001a TPersistent.Destroy 0025 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1912_0 {
	meta:
		name = "TMemoryStream.Destroy"
		size = 44
		refs = "0003 @BeforeDestruction 000e TMemoryStream.Clear 001a TObject.Destroy 0025 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_14257_0 {
	meta:
		name = "TOleContainer.Destroy"
		size = 44
		refs = "0003 @BeforeDestruction 000e TOleContainer.DestroyObject 001a TCustomControl.Destroy 0025 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_16677_0 {
	meta:
		name = "TRegistry.Destroy"
		size = 44
		refs = "0003 @BeforeDestruction 000e TRegistry.CloseKey 001a TObject.Destroy 0025 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2563_0 {
	meta:
		name = "TTreeNodes.Destroy"
		size = 44
		refs = "0003 @BeforeDestruction 000e TTreeNodes.Clear 001a TPersistent.Destroy 0025 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2020_0 {
	meta:
		name = "TWriter.Destroy"
		size = 44
		refs = "0003 @BeforeDestruction 000e TWriter.WriteBuffer 001a TFiler.Destroy 0025 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1779_0 {
	meta:
		name = "TPersistent.Assign"
		size = 18
		refs = "000d TPersistent.AssignError"
	strings:
		$1 = { 85 D2 74 06 92 8B 08 FF 11 C3 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1780_0 {
	meta:
		name = "TPersistent.AssignError"
		size = 240
		refs = "001e TPersistent.AssignError 0035 TObject.ClassName 0043 @LStrFromString 0052 @LStrLAsg 0096 SAssignError 009b LoadResString 00a8 _Dn_EConvertError 00ad Exception.CreateFmt 00b2 @RaiseExcept 00ca @LStrClr 00d8 @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 E8 FE FF FF 53 56 33 C9 89 8D E8 FE FF FF 89 4D FC 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 F6 74 1D 8D 95 FC FE FF FF 8B 06 E8 ?? ?? ?? ?? 8D 95 FC FE FF FF 8D 45 FC E8 ?? ?? ?? ?? EB 0D 8D 45 FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 89 85 EC FE FF FF C6 85 F0 FE FF FF 0B 8D 95 FC FE FF FF 8B 03 E8 ?? ?? ?? ?? 8D 85 FC FE FF FF 89 85 F4 FE FF FF C6 85 F8 FE FF FF 04 8D 85 EC FE FF FF 50 6A 01 8D 95 E8 FE FF FF A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 8D E8 FE FF FF B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 E8 FE FF FF E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E5 5E 5B 8B E5 5D C3 FF FF FF FF 03 00 00 00 6E 69 6C 00 }
	condition:
		$1
}

rule function_1783_0 {
	meta:
		name = "TPersistent.GetNamePath"
		size = 176
		refs = "0019 TPersistent.GetNamePath 002c TObject.ClassName 0039 @LStrFromString 0044 @CallDynaInst 007b @LStrCatN 0090 @LStrClr 0096 @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 FC FE FF FF 53 56 57 33 C9 89 4D FC 8B FA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 95 FC FE FF FF 8B 06 E8 ?? ?? ?? ?? 8D 95 FC FE FF FF 8B C7 E8 ?? ?? ?? ?? 8B C6 66 BB FF FF E8 ?? ?? ?? ?? 85 C0 74 33 8B C6 66 BB FF FF E8 ?? ?? ?? ?? 8D 55 FC 66 BB FE FF E8 ?? ?? ?? ?? 83 7D FC 00 74 16 FF 75 FC 68 ?? ?? ?? ?? FF 37 8B C7 BA 03 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 00 FF FF FF FF 01 00 00 00 2E 00 00 00 }
	condition:
		$1
}

rule function_1785_0 {
	meta:
		name = "TCollectionItem.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TCollectionItem.SetCollection 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D1 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_9806_0 {
	meta:
		name = "TSparseList.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TSparseList.NewList 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D1 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1787_0 {
	meta:
		name = "TCollectionItem.Changed"
		size = 33
	strings:
		$1 = { 56 8B 70 04 85 F6 74 17 83 7E 0C 00 75 11 84 D2 74 04 33 D2 EB 02 8B D0 8B C6 8B 08 FF 51 10 5E C3 }
	condition:
		$1
}

rule function_1788_0 {
	meta:
		name = "TCollectionItem.GetIndex"
		size = 21
		refs = "000c TList.IndexOf"
	strings:
		$1 = { 8B 50 04 85 D2 74 0A 8B 52 08 92 E8 ?? ?? ?? ?? C3 83 C8 FF C3 }
	condition:
		$1
}

rule function_1789_0 {
	meta:
		name = "TCollectionItem.GetDisplayName"
		size = 39
		refs = "0011 TObject.ClassName 001a @LStrFromString"
		altNames = "TDragObject.GetName"
	strings:
		$1 = { 53 56 81 C4 00 FF FF FF 8B F2 8B D8 8B D4 8B 03 E8 ?? ?? ?? ?? 8B D4 8B C6 E8 ?? ?? ?? ?? 81 C4 00 01 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_1790_0 {
	meta:
		name = "TCollectionItem.GetNamePath"
		size = 180
		refs = "0019 TCollectionItem.GetNamePath 0035 @CallDynaInst 0046 TCollectionItem.GetIndex 005f Format 006e TObject.ClassName 007b @LStrFromString 0090 @LStrClr 0096 @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 EC FE FF FF 53 56 57 33 C9 89 4D EC 8B FA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 7E 04 00 74 3C 57 8D 55 EC 8B 46 04 66 BB FE FF E8 ?? ?? ?? ?? 8B 45 EC 89 45 F0 C6 45 F4 0B 8B C6 E8 ?? ?? ?? ?? 89 45 F8 C6 45 FC 00 8D 55 F0 B9 01 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 1A 8D 95 EC FE FF FF 8B 06 E8 ?? ?? ?? ?? 8D 95 EC FE FF FF 8B C7 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 00 FF FF FF FF 06 00 00 00 25 73 5B 25 64 5D 00 00 }
	condition:
		$1
}

rule function_1792_0 {
	meta:
		name = "TCollectionItem.SetCollection"
		size = 40
		refs = "0014 TCollection.RemoveItem 0021 TCollection.InsertItem"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 43 04 3B F0 74 18 85 C0 74 07 8B D3 E8 ?? ?? ?? ?? 85 F6 74 09 8B D3 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1794_0 {
	meta:
		name = "TCollectionItem.SetIndex"
		size = 47
		refs = "0009 TCollectionItem.GetIndex 001f TList.Move 0028 TCollectionItem.Changed"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 85 C0 7C 1B 3B F0 74 17 8B 53 04 8B 52 08 8B CE 92 E8 ?? ?? ?? ?? B2 01 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1796_0 {
	meta:
		name = "TCollection.Destroy"
		size = 65
		refs = "0003 @BeforeDestruction 001b TCollection.Clear 0023 TObject.Free 002f TPersistent.Destroy 003a @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 C7 46 0C 01 00 00 00 83 7E 08 00 74 07 8B C6 E8 ?? ?? ?? ?? 8B 46 08 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1797_0 {
	meta:
		name = "TCollection.Add"
		size = 11
	strings:
		$1 = { 8B C8 B2 01 8B 40 04 FF 50 18 C3 }
	condition:
		$1
}

rule function_1798_0 {
	meta:
		name = "TCollection.Assign"
		size = 149
		refs = "0010 _DV_TCollection 0015 @IsClass 0029 TCollection.Assign 0037 TCollection.Clear 003e TCollection.GetCount 0051 TCollection.GetItem 005a TCollection.Add 007f @HandleFinally 008b TPersistent.Assign"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B F2 89 45 FC 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 68 8B 45 FC 8B 10 FF 52 14 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B D8 4B 85 DB 7C 1F 43 33 FF 8B D7 8B C6 E8 ?? ?? ?? ?? 50 8B 45 FC E8 ?? ?? ?? ?? 5A 8B 08 FF 51 08 47 4B 75 E4 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 10 FF 52 18 C3 E9 ?? ?? ?? ?? EB F0 8B D6 8B 45 FC E8 ?? ?? ?? ?? 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1799_0 {
	meta:
		name = "TCollection.BeginUpdate"
		size = 4
	strings:
		$1 = { FF 40 0C C3 }
	condition:
		$1
}

rule function_1800_0 {
	meta:
		name = "TCollection.Changed"
		size = 14
	strings:
		$1 = { 83 78 0C 00 75 07 33 D2 8B 08 FF 51 10 C3 }
	condition:
		$1
}

rule function_1801_0 {
	meta:
		name = "TCollection.Clear"
		size = 101
		refs = "0020 TCollection.Clear 002f TList.Last 0034 TObject.Free 005b @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 45 FC 8B 45 FC 8B 40 08 83 78 08 00 7E 4D 8B 45 FC 8B 10 FF 52 14 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 EB 0C 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 8B 58 08 83 7B 08 00 7F E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 10 FF 52 18 C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1802_0 {
	meta:
		name = "TCollection.EndUpdate"
		size = 9
		refs = "0004 TCollection.Changed"
	strings:
		$1 = { FF 48 0C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1803_0 {
	meta:
		name = "TCollection.FindItemID"
		size = 48
		refs = "001c TList.Get"
	strings:
		$1 = { 53 56 57 55 8B EA 8B F8 8B 47 08 8B 58 08 4B 85 DB 7C 16 43 33 F6 8B 47 08 8B D6 E8 ?? ?? ?? ?? 3B 68 08 74 06 46 4B 75 ED 33 C0 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1805_0 {
	meta:
		name = "TCollection.GetAttr"
		size = 12
		refs = "0006 @LStrClr"
		altNames = "TCustomModule.GetVerb"
	strings:
		$1 = { 53 8B D9 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_5758_0 {
	meta:
		name = "TCustomRemoteServer.GetProvider"
		size = 12
		refs = "0006 @IntfClear"
	strings:
		$1 = { 53 8B D9 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1806_0 {
	meta:
		name = "TCollection.GetItemAttr"
		size = 32
		refs = "000e TCollection.GetItem"
	strings:
		$1 = { 55 8B EC 53 56 8B F1 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 55 08 8B 08 FF 51 0C 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_1807_0 {
	meta:
		name = "TChartValueList.Count"
		size = 7
		altNames = "TCollection.GetCount"
	strings:
		$1 = { 8B 40 08 8B 40 08 C3 }
	condition:
		$1
}

rule function_1808_0 {
	meta:
		name = "TCollection.GetItem"
		size = 19
		refs = "000c TList.Get"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 08 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_16214_0 {
	meta:
		name = "TPrinterSettings.GetDriver"
		size = 19
		refs = "000c StrPas"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 08 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1809_0 {
	meta:
		name = "TCollection.GetNamePath"
		size = 200
		refs = "001c TCollection.GetNamePath 002f TObject.ClassName 003c @LStrFromString 0047 @CallDynaInst 0072 TCollection.GetPropName 008f @LStrCatN 00a9 @LStrArrayClr 00af @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 F8 FE FF FF 53 56 57 33 C9 89 4D FC 89 4D F8 8B FA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 95 F8 FE FF FF 8B 06 E8 ?? ?? ?? ?? 8D 95 F8 FE FF FF 8B C7 E8 ?? ?? ?? ?? 8B C6 66 BB FF FF E8 ?? ?? ?? ?? 85 C0 74 44 8B C6 66 BB FF FF E8 ?? ?? ?? ?? 8D 55 FC 66 BB FE FF E8 ?? ?? ?? ?? 83 7D FC 00 74 27 8D 55 F8 8B C6 E8 ?? ?? ?? ?? 83 7D F8 00 74 17 FF 75 FC 68 ?? ?? ?? ?? FF 75 F8 8B C7 BA 03 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 8B E5 5D C3 FF FF FF FF 01 00 00 00 2E 00 00 00 }
	condition:
		$1
}

rule function_1810_0 {
	meta:
		name = "TCollection.GetPropName"
		size = 281
		refs = "0019 @LStrLAsg 0025 @CallDynaInst 0048 TObject.ClassInfo 005f GetTypeData 0080 @GetMem 008b TCollection.GetPropName 00a3 GetPropInfos 00cc GetOrdProp 00df @LStrFromString 00f8 @FreeMem 00fe @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 89 55 F8 89 45 FC 8B 45 F8 8B 55 FC 8B 52 14 E8 ?? ?? ?? ?? 8B 45 FC 66 BB FF FF E8 ?? ?? ?? ?? 89 45 F0 8B 45 F8 83 38 00 0F 85 DA 00 00 00 83 7D F0 00 0F 84 D0 00 00 00 8B 45 F0 8B 00 E8 ?? ?? ?? ?? 85 C0 0F 84 BE 00 00 00 8B 45 F0 8B 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 85 DB 0F 84 A5 00 00 00 66 83 7B 08 00 0F 84 9A 00 00 00 0F BF 43 08 C1 E0 02 E8 ?? ?? ?? ?? 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F0 8B 00 E8 ?? ?? ?? ?? 8B 55 F4 E8 ?? ?? ?? ?? 0F BF 7B 08 4F 85 FF 7C 37 47 33 DB 8B 45 F4 8B 34 98 8B 06 8B 00 80 38 07 75 21 8B 45 F4 8B 14 98 8B 45 F0 E8 ?? ?? ?? ?? 3B 45 FC 75 0E 8B 45 FC 83 C0 14 8D 56 1A E8 ?? ?? ?? ?? 43 4F 75 CC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 F8 8B 55 FC 8B 52 14 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1811_0 {
	meta:
		name = "TCollection.Insert"
		size = 25
		refs = "0005 TCollection.Add"
	strings:
		$1 = { 53 56 8B F2 E8 ?? ?? ?? ?? 8B D8 8B D6 8B C3 8B 08 FF 51 10 8B C3 5E 5B C3 }
	condition:
		$1
}

rule function_1812_0 {
	meta:
		name = "GetDesigner"
		size = 152
		refs = "0015 @IntfClear 0024 @CallDynaInst 0032 _DV_TComponent 0037 @IsClass 004e GetDesigner"
	strings:
		$1 = { 55 8B EC 53 56 57 8B FA 8B F0 85 FF 74 04 33 C0 89 07 8B C7 E8 ?? ?? ?? ?? 85 F6 74 64 8B C6 66 BB FF FF E8 ?? ?? ?? ?? 8B D8 85 DB 75 2C 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 42 F6 46 20 10 74 3C 8B C7 E8 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 56 8B 06 FF 50 28 EB 27 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 06 F6 46 20 10 74 10 8B C7 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B 5D C3 00 00 07 E8 71 B9 A6 E3 D1 11 AA B1 00 C0 4F B1 6F BC }
	condition:
		$1
}

rule function_1813_0 {
	meta:
		name = "NotifyDesigner"
		size = 98
		refs = "0012 NotifyDesigner 0020 @IntfClear 0029 GetDesigner 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B D9 8B F2 8B F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B D0 8B C7 E8 ?? ?? ?? ?? 83 7D FC 00 74 0C 8B CB 8B D6 8B 45 FC 8B 18 FF 53 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1814_0 {
	meta:
		name = "TCollection.InsertItem"
		size = 150
		refs = "000f TCollection.InsertItem 001f @IsClass 002b SInvalidProperty 0030 LoadResString 003a _DV_TList 003f TList.Error 0049 TList.Add 0065 TCollection.Changed 0070 NotifyDesigner 0085 @LStrClr 008b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 8B 53 04 E8 ?? ?? ?? ?? 84 C0 75 1C 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 33 C9 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D6 8B 43 08 E8 ?? ?? ?? ?? 89 5E 04 8B 43 10 89 46 08 FF 43 10 8B D6 8B C3 8B 08 FF 51 0C 8B C3 E8 ?? ?? ?? ?? 33 C9 8B D6 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1815_0 {
	meta:
		name = "TCollection.RemoveItem"
		size = 42
		refs = "000d NotifyDesigner 0017 TList.Remove 0023 TCollection.Changed"
	strings:
		$1 = { 53 56 8B F2 8B D8 B1 01 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D6 8B 43 08 E8 ?? ?? ?? ?? 33 C0 89 46 04 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1816_0 {
	meta:
		name = "TCollection.SetItem"
		size = 30
		refs = "000f TList.Get"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B 43 08 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1822_0 {
	meta:
		name = "TStrings.Add"
		size = 33
	strings:
		$1 = { 53 56 57 8B FA 8B D8 8B C3 8B 10 FF 52 14 8B F0 8B CF 8B D6 8B C3 8B 18 FF 53 54 8B C6 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1823_0 {
	meta:
		name = "TStrings.AddObject"
		size = 33
	strings:
		$1 = { 53 56 57 8B F9 8B D8 8B C3 8B 08 FF 51 34 8B F0 8B CF 8B D6 8B C3 8B 18 FF 53 24 8B C6 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1824_0 {
	meta:
		name = "TStrings.Append"
		size = 6
	strings:
		$1 = { 8B 08 FF 51 34 C3 }
	condition:
		$1
}

rule function_1825_0 {
	meta:
		name = "TStrings.AddStrings"
		size = 181
		refs = "0018 TStrings.AddStrings 0026 TStrings.BeginUpdate 0085 TStrings.EndUpdate 008b @HandleFinally 00a2 @LStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 33 C9 89 4D F4 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 8B 10 FF 52 14 8B F0 4E 85 F6 7C 2D 46 33 DB 8D 4D F4 8B D3 8B 45 F8 8B 38 FF 57 0C 8B 45 F4 50 8B D3 8B 45 F8 8B 08 FF 51 18 8B C8 8B 45 FC 5A 8B 38 FF 57 38 43 4E 75 D6 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1826_0 {
	meta:
		name = "TStrings.Assign"
		size = 110
		refs = "000e _DV_TStrings 0013 @IsClass 001f TStrings.BeginUpdate 0027 TStrings.Assign 0054 TStrings.EndUpdate 005a @HandleFinally 0066 TPersistent.Assign"
	strings:
		$1 = { 55 8B EC 51 53 8B DA 89 45 FC 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 45 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 10 FF 52 40 8B D3 8B 45 FC 8B 08 FF 51 3C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B D3 8B 45 FC E8 ?? ?? ?? ?? 5B 59 5D C3 }
	condition:
		$1
}

rule function_1827_0 {
	meta:
		name = "TStrings.BeginUpdate"
		size = 23
	strings:
		$1 = { 53 8B D8 83 7B 04 00 75 09 B2 01 8B C3 8B 08 FF 51 30 FF 43 04 5B C3 }
	condition:
		$1
}

rule function_1828_0 {
	meta:
		name = "DoWrite"
		size = 85
		refs = "001b _DV_TStrings 0020 @IsClass 0034 TStrings.Equals"
	strings:
		$1 = { 55 8B EC 53 56 8B 45 08 8B 40 FC 8B 70 1C 85 F6 74 2D B3 01 8B 45 08 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 27 8B 45 08 8B D6 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 8B D8 80 F3 01 EB 10 8B 45 08 8B 40 F8 8B 10 FF 52 14 85 C0 0F 9F C3 8B C3 5E 5B 5D C3 }
	condition:
		$1
}

rule function_1829_0 {
	meta:
		name = "TStrings.DefineProperties"
		size = 76
		refs = "0012 TStrings.ReadData 001b TStrings.WriteData 0021 DoWrite 0029 TStrings.DefineProperties"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 89 55 FC 89 45 F8 8B 45 F8 50 68 ?? ?? ?? ?? 8B 45 F8 50 68 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 8B C8 BA ?? ?? ?? ?? 8B 45 FC 8B 18 FF 13 5B 59 59 5D C3 00 00 00 FF FF FF FF 07 00 00 00 53 74 72 69 6E 67 73 00 }
	condition:
		$1
}

rule function_1830_0 {
	meta:
		name = "TStrings.EndUpdate"
		size = 17
	strings:
		$1 = { FF 48 04 83 78 04 00 75 07 33 D2 8B 08 FF 51 30 C3 }
	condition:
		$1
}

rule function_1831_0 {
	meta:
		name = "TStrings.Equals"
		size = 166
		refs = "001b TStrings.Equals 006c @LStrCmp 0090 @LStrArrayClr 0096 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D F0 89 4D EC 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C6 45 F7 00 8B 45 FC 8B 10 FF 52 14 8B D8 8B 45 F8 8B 10 FF 52 14 3B D8 75 3B 8B F3 4E 85 F6 7C 30 46 33 DB 8D 4D F0 8B D3 8B 45 FC 8B 38 FF 57 0C 8B 45 F0 50 8D 4D EC 8B D3 8B 45 F8 8B 38 FF 57 0C 8B 55 EC 58 E8 ?? ?? ?? ?? 75 08 43 4E 75 D3 C6 45 F7 01 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 8A 45 F7 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1834_0 {
	meta:
		name = "TStrings.Exchange"
		size = 230
		refs = "001c TStrings.Exchange 002a TStrings.BeginUpdate 00b1 TStrings.EndUpdate 00b7 @HandleFinally 00d3 @LStrArrayClr"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 33 DB 89 5D F0 89 5D F4 8B F1 8B DA 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 4D F4 8B D3 8B 45 FC 8B 38 FF 57 0C 8B D3 8B 45 FC 8B 08 FF 51 18 89 45 F8 8D 4D F0 8B D6 8B 45 FC 8B 38 FF 57 0C 8B 4D F0 8B D3 8B 45 FC 8B 38 FF 57 20 8B D6 8B 45 FC 8B 08 FF 51 18 8B C8 8B D3 8B 45 FC 8B 18 FF 53 24 8B 4D F4 8B D6 8B 45 FC 8B 18 FF 53 20 8B 4D F8 8B D6 8B 45 FC 8B 18 FF 53 24 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1835_0 {
	meta:
		name = "TStrings.GetCapacity"
		size = 6
	strings:
		$1 = { 8B 10 FF 52 14 C3 }
	condition:
		$1
}

rule function_1836_0 {
	meta:
		name = "TStrings.GetCommaText"
		size = 308
		refs = "001a TStrings.GetCommaText 004e @LStrLAsg 005a @LStrClr 0080 @LStrToPChar 0088 CharNext 00ab AnsiQuotedStr 00cc @LStrCatN 00db @LStrLen 00e9 @LStrDelete 010c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 89 4D F8 8B DA 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 10 FF 52 14 8B F0 83 FE 01 75 24 8D 4D EC 33 D2 8B 45 FC 8B 38 FF 57 0C 83 7D EC 00 75 11 8B C3 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 96 00 00 00 8B C3 E8 ?? ?? ?? ?? 4E 85 F6 7C 75 46 89 75 F0 C7 45 F4 00 00 00 00 8D 4D F8 8B 55 F4 8B 45 FC 8B 30 FF 56 0C 8B 45 F8 E8 ?? ?? ?? ?? EB 06 50 E8 ?? ?? ?? ?? 8A 10 80 EA 21 72 0A 80 EA 01 74 05 80 EA 0A 75 E9 80 38 00 74 18 8D 4D EC B2 22 8B 45 F8 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F8 E8 ?? ?? ?? ?? FF 33 FF 75 F8 68 ?? ?? ?? ?? 8B C3 BA 03 00 00 00 E8 ?? ?? ?? ?? FF 45 F4 FF 4D F0 75 96 8B 03 E8 ?? ?? ?? ?? 8B D0 8B C3 B9 01 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 00 00 00 FF FF FF FF 02 00 00 00 22 22 00 00 FF FF FF FF 01 00 00 00 2C 00 00 00 }
	condition:
		$1
}

rule function_1837_0 {
	meta:
		name = "TStrings.GetName"
		size = 76
		refs = "0017 TStrings.GetName 001c AnsiPos 002a @LStrSetLength"
	strings:
		$1 = { 53 56 57 8B D9 8B FA 8B F0 8B CB 8B D7 8B C6 8B 30 FF 56 0C 8B 13 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0C 8B D0 4A 8B C3 E8 ?? ?? ?? ?? EB 09 8B C3 33 D2 E8 ?? ?? ?? ?? 5F 5E 5B C3 00 00 00 FF FF FF FF 01 00 00 00 3D 00 00 00 }
	condition:
		$1
}

rule function_1839_0 {
	meta:
		name = "TStrings.GetText"
		size = 82
		refs = "000c TStrings.GetText 0024 @LStrToPChar 0029 StrNew 0040 @LStrClr 0046 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 8B 08 FF 51 1C 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 }
	condition:
		$1
}

rule function_1840_0 {
	meta:
		name = "TStrings.GetTextStr"
		size = 229
		refs = "001b TStrings.GetTextStr 0054 @LStrLen 006b @LStrFromPCharLen 00a8 Move 00d2 @LStrArrayClr 00d8 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 56 57 33 C9 89 4D E8 89 4D EC 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 10 FF 52 14 89 45 F0 33 DB 8B 75 F0 4E 85 F6 7C 29 46 C7 45 F4 00 00 00 00 8D 4D E8 8B 55 F4 8B 45 FC 8B 38 FF 57 0C 8B 45 E8 E8 ?? ?? ?? ?? 83 C0 02 03 D8 FF 45 F4 4E 75 DF 8B 45 F8 8B CB 33 D2 E8 ?? ?? ?? ?? 8B 5D F8 8B 1B 8B 75 F0 4E 85 F6 7C 40 46 C7 45 F4 00 00 00 00 8D 4D EC 8B 55 F4 8B 45 FC 8B 38 FF 57 0C 8B 45 EC E8 ?? ?? ?? ?? 8B F8 85 FF 74 0E 8B D3 8B 45 EC 8B CF E8 ?? ?? ?? ?? 03 DF C6 03 0D 43 C6 03 0A 43 FF 45 F4 4E 75 C8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1841_0 {
	meta:
		name = "TStrings.GetValue"
		size = 140
		refs = "0019 TStrings.GetValue 0029 TStrings.IndexOfName 004b @LStrLen 005b @LStrCopy 0065 @LStrClr 0080 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 33 DB 89 5D F4 89 4D F8 89 55 FC 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 8B F0 85 F6 7C 2E 8B 45 F8 50 8D 4D F4 8B D6 8B C3 8B 18 FF 53 0C 8B 45 F4 50 8B 45 FC E8 ?? ?? ?? ?? 8B D0 83 C2 02 B9 FF FF FF 7F 58 E8 ?? ?? ?? ?? EB 08 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_13519_0 {
	meta:
		name = "TExStringList.GetValue"
		size = 140
		refs = "0019 TExStringList.GetValue 0029 TExStringList.IndexOfName 004b @LStrLen 005b @LStrCopy 0065 @LStrClr 0080 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 33 DB 89 5D F4 89 4D F8 89 55 FC 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 8B F0 85 F6 7C 2E 8B 45 F8 50 8D 4D F4 8B D6 8B C3 8B 18 FF 53 0C 8B 45 F4 50 8B 45 FC E8 ?? ?? ?? ?? 8B D0 83 C2 02 B9 FF FF FF 7F 58 E8 ?? ?? ?? ?? EB 08 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1842_0 {
	meta:
		name = "TStrings.IndexOf"
		size = 125
		refs = "0018 TStrings.IndexOf 0048 AnsiCompareText 0068 @LStrClr 006e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 33 C9 89 4D F4 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 10 FF 52 14 8B D8 4B 85 DB 7C 23 43 33 F6 8D 4D F4 8B D6 8B 45 FC 8B 38 FF 57 0C 8B 45 F4 8B 55 F8 E8 ?? ?? ?? ?? 85 C0 74 07 46 4B 75 E0 83 CE FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1843_0 {
	meta:
		name = "TStrings.IndexOfName"
		size = 196
		refs = "001a TStrings.IndexOfName 0052 AnsiPos 006c @LStrCopy 0077 AnsiCompareText 00a2 @LStrArrayClr 00a8 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 33 C9 89 4D EC 89 4D F0 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 10 FF 52 14 8B F0 4E 85 F6 7C 52 46 C7 45 F4 00 00 00 00 8D 4D F0 8B 55 F4 8B 45 FC 8B 18 FF 53 0C 8B 55 F0 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 85 DB 74 23 8D 45 EC 50 8B CB 49 BA 01 00 00 00 8B 45 F0 E8 ?? ?? ?? ?? 8B 45 EC 8B 55 F8 E8 ?? ?? ?? ?? 85 C0 74 0D FF 45 F4 4E 75 B6 C7 45 F4 FF FF FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 8B 45 F4 5E 5B 8B E5 5D C3 00 FF FF FF FF 01 00 00 00 3D 00 00 00 }
	condition:
		$1
}

rule function_1844_0 {
	meta:
		name = "TStrings.IndexOfObject"
		size = 52
	strings:
		$1 = { 53 56 57 55 8B EA 8B F8 8B C7 8B 10 FF 52 14 8B D8 4B 85 DB 7C 14 43 33 F6 8B D6 8B C7 8B 08 FF 51 18 3B E8 74 07 46 4B 75 EF 83 CE FF 8B C6 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1845_0 {
	meta:
		name = "TStrings.InsertObject"
		size = 46
	strings:
		$1 = { 55 8B EC 51 53 56 57 89 4D FC 8B DA 8B F0 8B 4D FC 8B D3 8B C6 8B 38 FF 57 54 8B 4D 08 8B D3 8B C6 8B 18 FF 53 24 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_1846_0 {
	meta:
		name = "TStrings.LoadFromFile"
		size = 83
		refs = "000c _DV_TFileStream 0013 TFileStream.Create 001e TStrings.LoadFromFile 0043 TObject.Free 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 56 8B F0 6A 20 8B CA A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B C6 8B 08 FF 51 5C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 59 5D C3 }
	condition:
		$1
}

rule function_1847_0 {
	meta:
		name = "TStrings.LoadFromStream"
		size = 171
		refs = "0016 TStrings.LoadFromStream 0024 TStrings.BeginUpdate 0039 TStream.GetSize 0042 TStream.GetPosition 0050 @LStrFromPCharLen 007c TStrings.EndUpdate 0082 @HandleFinally 0099 @LStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 C9 89 4D F8 8B DA 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 8B F0 8B C3 E8 ?? ?? ?? ?? 2B F0 8D 45 F8 8B CE 33 D2 E8 ?? ?? ?? ?? 8B 55 F8 8B CE 8B C3 8B 18 FF 53 04 8B 55 F8 8B 45 FC 8B 08 FF 51 2C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1848_0 {
	meta:
		name = "TStrings.Move"
		size = 175
		refs = "0019 TStrings.Move 002b TStrings.BeginUpdate 006a TStrings.InsertObject 007f TStrings.EndUpdate 0085 @HandleFinally 009c @LStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 33 DB 89 5D F8 8B F1 8B DA 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 3B F3 74 64 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 4D F8 8B D3 8B 45 FC 8B 38 FF 57 0C 8B D3 8B 45 FC 8B 08 FF 51 18 8B F8 8B D3 8B 45 FC 8B 08 FF 51 44 57 8B 4D F8 8B D6 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1849_0 {
	meta:
		name = "TStrings.Put"
		size = 47
		refs = "0026 TStrings.InsertObject"
	strings:
		$1 = { 53 56 57 55 8B E9 8B F2 8B D8 8B D6 8B C3 8B 08 FF 51 18 8B F8 8B D6 8B C3 8B 08 FF 51 44 57 8B CD 8B D6 8B C3 E8 ?? ?? ?? ?? 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1851_0 {
	meta:
		name = "TStrings.ReadData"
		size = 175
		refs = "0015 TStrings.ReadData 0023 TReader.ReadListBegin 002b TStrings.BeginUpdate 004e TReader.ReadString 0061 TReader.EndOfList 007a TStrings.EndUpdate 0080 @HandleFinally 008a TReader.ReadListEnd 009f @LStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 F4 33 C9 89 4D F4 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 10 FF 52 40 EB 16 8D 55 F4 8B 45 F8 E8 ?? ?? ?? ?? 8B 55 F4 8B 45 FC 8B 08 FF 51 34 8B 45 F8 E8 ?? ?? ?? ?? 84 C0 74 DE 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B E5 5D C3 }
	condition:
		$1
}

rule function_1852_0 {
	meta:
		name = "TStrings.SaveToFile"
		size = 86
		refs = "000f _DV_TFileStream 0016 TFileStream.Create 0021 TStrings.SaveToFile 0046 TObject.Free 004c @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 56 8B F0 68 FF FF 00 00 8B CA A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B C6 8B 08 FF 51 68 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 59 5D C3 }
	condition:
		$1
}

rule function_1853_0 {
	meta:
		name = "TStrings.SaveToStream"
		size = 89
		refs = "000f TStrings.SaveToStream 0027 @LStrLen 0033 TStream.WriteBuffer 0048 @LStrClr 004e @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 8B 08 FF 51 1C 8B 45 FC E8 ?? ?? ?? ?? 8B C8 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1855_0 {
	meta:
		name = "TStrings.SetCommaText"
		size = 285
		refs = "0019 TStrings.SetCommaText 0027 TStrings.BeginUpdate 0044 @LStrToPChar 0050 CharNext 006d AnsiExtractQuotedStr 0097 @LStrFromPCharLen 00ee TStrings.EndUpdate 00f4 @HandleFinally 010b @LStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 33 C9 89 4D F4 8B F2 89 45 FC 8D 5D F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 FC 8B 10 FF 52 40 8B C6 E8 ?? ?? ?? ?? 89 03 EB 0A 8B 03 50 E8 ?? ?? ?? ?? 89 03 8B 03 8A 00 48 2C 20 72 ED EB 74 3C 22 75 0E 8D 4D F4 8B C3 B2 22 E8 ?? ?? ?? ?? EB 28 8B 33 EB 0A 8B 03 50 E8 ?? ?? ?? ?? 89 03 8B 03 8A 00 3C 20 76 04 3C 2C 75 EA 8B 0B 2B CE 8D 45 F4 8B D6 E8 ?? ?? ?? ?? 8B 55 F4 8B 45 FC 8B 08 FF 51 34 EB 0A 8B 03 50 E8 ?? ?? ?? ?? 89 03 8B 03 8A 00 48 2C 20 72 ED 8B 03 80 38 2C 75 13 8B 03 50 E8 ?? ?? ?? ?? 89 03 8B 03 8A 00 48 2C 20 72 ED 8B 03 8A 00 84 C0 75 84 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1856_0 {
	meta:
		name = "TStrings.SetStringsAdapter"
		size = 49
		refs = "001a @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 83 7B 08 00 74 08 8B 43 08 8B 10 FF 52 10 8D 43 08 8B D6 E8 ?? ?? ?? ?? 83 7B 08 00 74 0A 8B D3 8B 43 08 8B 08 FF 51 0C 5E 5B C3 }
	condition:
		$1
}

rule function_1857_0 {
	meta:
		name = "TStrings.SetText"
		size = 79
		refs = "000f TStrings.SetText 001f @LStrFromPChar 003e @LStrClr 0044 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 8B D6 E8 ?? ?? ?? ?? 8B 55 FC 8B C3 8B 08 FF 51 2C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1858_0 {
	meta:
		name = "TStrings.SetTextStr"
		size = 192
		refs = "0015 TStrings.SetTextStr 0023 TStrings.BeginUpdate 0061 @LStrFromPCharLen 0092 TStrings.EndUpdate 0098 @HandleFinally 00af @LStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 C9 89 4D F8 8B DA 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 FC 8B 10 FF 52 40 85 DB 74 40 EB 39 8B C3 EB 01 43 8A 13 84 D2 74 0A 80 EA 0A 74 05 80 EA 03 75 EF 8B CB 2B C8 8D 55 F8 92 E8 ?? ?? ?? ?? 8B 55 F8 8B 45 FC 8B 08 FF 51 34 80 3B 0D 75 01 43 80 3B 0A 75 01 43 80 3B 00 75 C2 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1860_0 {
	meta:
		name = "TStrings.SetValue"
		size = 164
		refs = "0019 TStrings.SetValue 0028 TStrings.IndexOfName 0055 @LStrCatN 0085 @LStrClr 008b @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 33 DB 89 5D F8 89 4D FC 8B FA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D7 8B C6 E8 ?? ?? ?? ?? 8B D8 83 7D FC 00 74 33 85 DB 7D 0B 33 D2 8B C6 8B 08 FF 51 34 8B D8 57 68 ?? ?? ?? ?? FF 75 FC 8D 45 F8 BA 03 00 00 00 E8 ?? ?? ?? ?? 8B 4D F8 8B D3 8B C6 8B 18 FF 53 20 EB 0D 85 DB 7C 09 8B D3 8B C6 8B 08 FF 51 44 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 59 5D C3 FF FF FF FF 01 00 00 00 3D 00 00 00 }
	condition:
		$1
}

rule function_1861_0 {
	meta:
		name = "TStrings.WriteData"
		size = 132
		refs = "0018 TStrings.WriteData 0026 TWriter.WriteListBegin 0050 TWriter.WriteString 005c TWriter.WriteListEnd 0071 @LStrClr 0077 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 33 C9 89 4D F4 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 FC 8B 10 FF 52 14 8B D8 4B 85 DB 7C 1F 43 33 F6 8D 4D F4 8B D6 8B 45 FC 8B 38 FF 57 0C 8B 55 F4 8B 45 F8 E8 ?? ?? ?? ?? 46 4B 75 E4 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1862_0 {
	meta:
		name = "TStringList.Destroy"
		size = 90
		refs = "0003 @BeforeDestruction 0023 TStrings.Destroy 0034 TStringItem 003a @FinalizeArray 0053 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 33 C0 89 46 1C 89 46 20 33 C0 89 46 24 89 46 28 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 8B 46 10 85 C0 74 10 8B 56 0C 8B C8 A1 ?? ?? ?? ?? 92 E8 ?? ?? ?? ?? 33 C0 89 46 10 33 D2 8B C6 8B 08 FF 51 28 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1863_0 {
	meta:
		name = "TStringList.Add"
		size = 151
		refs = "0016 TStringList.Add 004f SDuplicateString 0054 LoadResString 0060 TStrings.Error 006c TStringList.InsertItem 0081 @LStrClr 0087 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 33 C9 89 4D F8 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 80 7B 18 00 75 08 8B 43 10 89 45 FC EB 36 8D 4D FC 8B D6 8B C3 8B 38 FF 57 78 84 C0 74 26 8A 43 19 2C 01 72 2B FE C8 74 02 EB 19 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 33 C9 8B C3 E8 ?? ?? ?? ?? 8B CE 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 FC 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1864_0 {
	meta:
		name = "TStringList.Changed"
		size = 26
	strings:
		$1 = { 53 83 78 04 00 75 11 66 83 78 1E 00 74 0A 8B D8 8B D0 8B 43 20 FF 53 1C 5B C3 }
	condition:
		$1
}

rule function_1865_0 {
	meta:
		name = "TStringList.Changing"
		size = 26
	strings:
		$1 = { 53 83 78 04 00 75 11 66 83 78 26 00 74 0A 8B D8 8B D0 8B 43 28 FF 53 24 5B C3 }
	condition:
		$1
}

rule function_1866_0 {
	meta:
		name = "TStringList.Clear"
		size = 56
		refs = "0018 TStringItem 001d @FinalizeArray"
	strings:
		$1 = { 53 8B D8 83 7B 10 00 74 2D 8B C3 8B 10 FF 52 74 8B 43 0C 8B 4B 10 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 89 43 10 33 D2 8B C3 8B 08 FF 51 28 8B C3 8B 10 FF 52 70 5B C3 }
	condition:
		$1
}

rule function_1867_0 {
	meta:
		name = "TStringList.Delete"
		size = 159
		refs = "000f TStringList.Delete 0026 SListIndexError 002b LoadResString 0037 TStrings.Error 004a TStringItem 004f @Finalize 0072 Move 008e @LStrClr 0094 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 F6 7C 05 3B 73 10 7C 19 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B CE 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 74 8B 43 0C 8D 04 F0 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 4B 10 8B 43 10 3B F0 7D 19 2B C6 8B C8 C1 E1 03 8B 43 0C 8D 14 F0 8B 43 0C 8D 44 F0 08 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 70 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1868_0 {
	meta:
		name = "TStringList.Exchange"
		size = 156
		refs = "0012 TStringList.Exchange 0029 SListIndexError 002e LoadResString 003a TStrings.Error 006e TStringList.ExchangeItems 008a @LStrClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 F6 7C 05 3B 73 10 7C 19 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B CE 8B C3 E8 ?? ?? ?? ?? 85 FF 7C 05 3B 7B 10 7C 19 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B CF 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 74 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 70 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1869_0 {
	meta:
		name = "TStringList.ExchangeItems"
		size = 35
	strings:
		$1 = { 53 8B 58 0C 8D 14 D3 8B 40 0C 8D 04 C8 8B 0A 8B 18 89 1A 89 08 8B 4A 04 8B 58 04 89 5A 04 89 48 04 5B C3 }
	condition:
		$1
}

rule function_1870_0 {
	meta:
		name = "TStringList.Find"
		size = 101
		refs = "002e AnsiCompareText"
	strings:
		$1 = { 53 56 57 55 83 C4 F4 89 4C 24 04 89 14 24 8B E8 C6 44 24 08 00 33 F6 8B 7D 10 4F 3B FE 7C 34 8D 1C 37 D1 EB 8B 45 0C 8B 04 D8 8B 14 24 E8 ?? ?? ?? ?? 85 C0 7D 05 8D 73 01 EB 14 8B FB 4F 85 C0 75 0D C6 44 24 08 01 80 7D 19 01 74 02 8B F3 3B FE 7D CC 8B 44 24 04 89 30 8A 44 24 08 83 C4 0C 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1871_0 {
	meta:
		name = "TStringList.Get"
		size = 110
		refs = "0012 TStringList.Get 0029 SListIndexError 002e LoadResString 003a TStrings.Error 0047 @LStrLAsg 005c @LStrClr 0062 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 F6 7C 05 3B 73 10 7C 19 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B CE 8B C3 E8 ?? ?? ?? ?? 8B C7 8B 53 0C 8B 14 F2 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1874_0 {
	meta:
		name = "TStringList.GetObject"
		size = 102
		refs = "000f TStringList.GetObject 0026 SListIndexError 002b LoadResString 0037 TStrings.Error 0053 @LStrClr 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 F6 7C 05 3B 73 10 7C 19 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B CE 8B C3 E8 ?? ?? ?? ?? 8B 43 0C 8B 5C F0 04 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1875_0 {
	meta:
		name = "TStringList.Grow"
		size = 51
	strings:
		$1 = { 56 8B 50 14 83 FA 40 7E 0E 8B F2 85 F6 79 03 83 C6 03 C1 FE 02 EB 11 83 FA 08 7E 07 BE 10 00 00 00 EB 05 BE 04 00 00 00 03 F2 8B D6 8B 08 FF 51 28 5E C3 }
	condition:
		$1
}

rule function_1876_0 {
	meta:
		name = "TStringList.IndexOf"
		size = 56
		refs = "0012 TStrings.IndexOf"
	strings:
		$1 = { 53 56 51 8B F2 8B D8 80 7B 18 00 75 0E 8B D6 8B C3 E8 ?? ?? ?? ?? 89 04 24 EB 16 8B CC 8B D6 8B C3 8B 18 FF 53 78 84 C0 75 07 C7 04 24 FF FF FF FF 8B 04 24 5A 5E 5B C3 }
	condition:
		$1
}

rule function_1877_0 {
	meta:
		name = "TStringList.Insert"
		size = 139
		refs = "0012 TStringList.Insert 0026 SSortedListError 002b LoadResString 0037 TStrings.Error 0048 SListIndexError 0064 TStringList.InsertItem 0079 @LStrClr 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 80 7B 18 00 74 19 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 33 C9 8B C3 E8 ?? ?? ?? ?? 85 F6 7C 05 3B 73 10 7E 19 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B CE 8B C3 E8 ?? ?? ?? ?? 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1878_0 {
	meta:
		name = "TStringList.InsertItem"
		size = 102
		refs = "001b TStringList.Grow 003a Move 0054 @LStrAsg"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B C3 8B 10 FF 52 74 8B 43 10 3B 43 14 75 07 8B C3 E8 ?? ?? ?? ?? 8B 43 10 3B F0 7D 18 8B 53 0C 8D 54 F2 08 8B 4B 0C 8D 0C F1 2B C6 C1 E0 03 91 E8 ?? ?? ?? ?? 8B 43 0C 8D 04 F0 8B F0 33 C0 89 06 33 C0 89 46 04 8B C6 8B D7 E8 ?? ?? ?? ?? FF 43 10 8B C3 8B 10 FF 52 70 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1879_0 {
	meta:
		name = "TStringList.Put"
		size = 155
		refs = "0012 TStringList.Put 0026 SSortedListError 002b LoadResString 0037 TStrings.Error 0048 SListIndexError 006d @LStrAsg 0089 @LStrClr 008f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 80 7B 18 00 74 19 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 33 C9 8B C3 E8 ?? ?? ?? ?? 85 F6 7C 05 3B 73 10 7C 19 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B CE 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 74 8B 43 0C 8D 04 F0 8B D7 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 70 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1880_0 {
	meta:
		name = "TStringList.PutObject"
		size = 118
		refs = "0012 TStringList.PutObject 0029 SListIndexError 002e LoadResString 003a TStrings.Error 0064 @LStrClr 006a @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 F6 7C 05 3B 73 10 7C 19 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B CE 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 74 8B 43 0C 89 7C F0 04 8B C3 8B 10 FF 52 70 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1881_0 {
	meta:
		name = "TStringList.QuickSort"
		size = 188
		refs = "001a TStringList.QuickSort 003c @LStrLAsg 004d AnsiCompareText 0075 TStringList.ExchangeItems 00a9 @LStrClr 00af @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 33 DB 89 5D F4 89 4D F8 89 55 FC 8B F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 5D FC 8B 75 F8 8D 45 F4 8B 55 FC 03 55 F8 D1 EA 8B 4F 0C 8B 14 D1 E8 ?? ?? ?? ?? EB 01 43 8B 47 0C 8B 04 D8 8B 55 F4 E8 ?? ?? ?? ?? 85 C0 7C ED EB 01 4E 8B 47 0C 8B 04 F0 8B 55 F4 E8 ?? ?? ?? ?? 85 C0 7F ED 3B F3 7C 0D 8B CE 8B D3 8B C7 E8 ?? ?? ?? ?? 43 4E 3B F3 7D C4 3B 75 FC 7E 0C 8B CE 8B 55 FC 8B C7 E8 ?? ?? ?? ?? 89 5D FC 3B 5D F8 7C 8C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1882_0 {
	meta:
		name = "TStringList.SetCapacity"
		size = 25
		refs = "000f @ReallocMem"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 C1 E2 03 8D 43 0C E8 ?? ?? ?? ?? 89 73 14 5E 5B C3 }
	condition:
		$1
}

rule function_1883_0 {
	meta:
		name = "TStringList.SetSorted"
		size = 28
	strings:
		$1 = { 53 56 8B DA 8B F0 3A 5E 18 74 0E 84 DB 74 07 8B C6 8B 10 FF 52 7C 88 5E 18 5E 5B C3 }
	condition:
		$1
}

rule function_1884_0 {
	meta:
		name = "TStringList.SetUpdateState"
		size = 16
	strings:
		$1 = { 84 D2 74 06 8B 10 FF 52 74 C3 8B 10 FF 52 70 C3 }
	condition:
		$1
}

rule function_1885_0 {
	meta:
		name = "TStringList.Sort"
		size = 44
		refs = "001f TStringList.QuickSort"
	strings:
		$1 = { 53 8B D8 80 7B 18 00 75 21 83 7B 10 01 7E 1B 8B C3 8B 10 FF 52 74 8B 4B 10 49 33 D2 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 70 5B C3 }
	condition:
		$1
}

rule function_1886_0 {
	meta:
		name = "TStream.GetPosition"
		size = 14
	strings:
		$1 = { 53 66 B9 01 00 33 D2 8B 18 FF 53 0C 5B C3 }
	condition:
		$1
}

rule function_1887_0 {
	meta:
		name = "TStream.SetPosition"
		size = 10
	strings:
		$1 = { 53 33 C9 8B 18 FF 53 0C 5B C3 }
	condition:
		$1
}

rule function_1888_0 {
	meta:
		name = "TStream.GetSize"
		size = 52
	strings:
		$1 = { 53 56 57 8B D8 66 B9 01 00 33 D2 8B C3 8B 30 FF 56 0C 8B F0 66 B9 02 00 33 D2 8B C3 8B 38 FF 57 0C 8B F8 33 C9 8B D6 8B C3 8B 18 FF 53 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1890_0 {
	meta:
		name = "TStream.ReadBuffer"
		size = 122
		refs = "0018 TStream.ReadBuffer 003a SReadError 003f LoadResString 0049 _DV_EReadError 004e Exception.Create 0053 @RaiseExcept 0068 @LStrClr 006e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 DB 89 5D F8 8B D9 89 55 FC 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 DB 74 31 8B 55 FC 8B CB 8B C6 8B 30 FF 56 04 3B D8 74 21 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D F8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1891_0 {
	meta:
		name = "TStream.WriteBuffer"
		size = 122
		refs = "0018 TStream.WriteBuffer 003a SWriteError 003f LoadResString 0049 _DV_EWriteError 004e Exception.Create 0053 @RaiseExcept 0068 @LStrClr 006e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 DB 89 5D F8 8B D9 89 55 FC 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 DB 74 31 8B 55 FC 8B CB 8B C6 8B 30 FF 56 08 3B D8 74 21 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D F8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1892_0 {
	meta:
		name = "TStream.CopyFrom"
		size = 180
		refs = "001b TStream.SetPosition 0023 TStream.GetSize 0044 @GetMem 004f TStream.CopyFrom 0074 TStream.ReadBuffer 0080 TStream.WriteBuffer 009e @FreeMem 00a4 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 8B D9 89 55 F8 89 45 FC 85 DB 75 14 33 D2 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 8B D8 89 5D F4 81 FB 00 F0 00 00 7E 09 C7 45 F0 00 F0 00 00 EB 03 89 5D F0 8B 45 F0 E8 ?? ?? ?? ?? 89 45 EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 DB 74 2D 3B 5D F0 7E 05 8B 75 F0 EB 02 8B F3 8B 7D EC 8B D7 8B CE 8B 45 F8 E8 ?? ?? ?? ?? 8B D7 8B CE 8B 45 FC E8 ?? ?? ?? ?? 2B DE 85 DB 75 D3 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 55 F0 8B 45 EC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 8B 45 F4 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1893_0 {
	meta:
		name = "TStream.ReadComponent"
		size = 95
		refs = "0013 _DV_TReader 0018 TFiler.Create 0023 TStream.ReadComponent 0033 TReader.ReadRootComponent 004b TObject.Free 0051 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 8B DA 68 00 10 00 00 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D3 8B 45 F8 E8 ?? ?? ?? ?? 89 45 FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 FC 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1894_0 {
	meta:
		name = "TStream.WriteComponent"
		size = 8
		refs = "0003 TStream.WriteDescendent"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_18225_0 {
	meta:
		name = "@Write0Variant"
		size = 8
		refs = "0003 @WriteVariant"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_8228_0 {
	meta:
		name = "EditChart"
		size = 8
		refs = "0003 EditChartPage"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_9518_0 {
	meta:
		name = "TBitmap.SaveToStream"
		size = 8
		refs = "0003 TBitmap.WriteStream"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5825_0 {
	meta:
		name = "TClientDataSet.SaveToStream"
		size = 8
		refs = "0003 TClientDataSet.WriteDataPacket"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5902_0 {
	meta:
		name = "TClientDataSet.SetIndexName"
		size = 8
		refs = "0003 TClientDataSet.SetIndex"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4619_0 {
	meta:
		name = "TCopyParser.SkipToken"
		size = 8
		refs = "0003 TCopyParser.SkipToNextToken"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_7126_0 {
	meta:
		name = "TDatabase.SetDriverName"
		size = 8
		refs = "0003 TDatabase.SetDatabaseType"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_9600_0 {
	meta:
		name = "TInplaceEdit.UpdateLoc"
		size = 8
		refs = "0003 TInplaceEdit.InternalMove"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_15496_0 {
	meta:
		name = "TSQLResolver.DoUpdate"
		size = 8
		refs = "0003 TSQLResolver.InternalDoUpdate"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_7063_0 {
	meta:
		name = "TSession.OpenDatabase"
		size = 8
		refs = "0003 TSession.DoOpenDatabase"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_9870_0 {
	meta:
		name = "TStringGrid.GetRows"
		size = 8
		refs = "0003 TStringGrid.EnsureColRow"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_7340_0 {
	meta:
		name = "TTable.SetIndexName"
		size = 8
		refs = "0003 TTable.SetIndex"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_7386_0 {
	meta:
		name = "TTable.UnlockTable"
		size = 8
		refs = "0003 TTable.SetTableLock"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2067_0 {
	meta:
		name = "TWriter.WriteRootComponent"
		size = 8
		refs = "0003 TWriter.WriteDescendent"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_22006_0 {
	meta:
		name = "ZeroMemory"
		size = 8
		refs = "0003 @FillChar"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1895_0 {
	meta:
		name = "TStream.WriteDescendent"
		size = 92
		refs = "0014 _DV_TWriter 0019 TFiler.Create 0024 TStream.WriteDescendent 0036 TWriter.WriteDescendent 004b TObject.Free 0051 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 8B F1 8B DA 68 00 10 00 00 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B CE 8B D3 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1896_0 {
	meta:
		name = "TStream.ReadComponentRes"
		size = 25
		refs = "0009 TStream.ReadResHeader 0012 TStream.ReadComponent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2110_0 {
	meta:
		name = "ObjectResourceToText"
		size = 25
		refs = "0009 TStream.ReadResHeader 0012 ObjectBinaryToText"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_6545_0 {
	meta:
		name = "TDBGridInplaceEdit.WMCancelMode"
		size = 25
		refs = "0009 TDBGridInplaceEdit.StopTracking 0012 TControl.WMCancelMode"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_6313_0 {
	meta:
		name = "TDBImage.WMLButtonDblClk"
		size = 25
		refs = "0009 TDBImage.LoadPicture 0012 TControl.WMLButtonDblClk"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_6457_0 {
	meta:
		name = "TDBLookupComboBox.WMCancelMode"
		size = 25
		refs = "0009 TDBLookupComboBox.StopTracking 0012 TControl.WMCancelMode"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_6427_0 {
	meta:
		name = "TDBLookupListBox.WMCancelMode"
		size = 25
		refs = "0009 TDBLookupListBox.StopTracking 0012 TControl.WMCancelMode"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_19727_0 {
	meta:
		name = "TToolWindow.CMBorderChanged"
		size = 25
		refs = "0009 TWinControl.RecreateWnd 0012 TWinControl.CMBorderChanged"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1897_0 {
	meta:
		name = "TStream.WriteComponentRes"
		size = 8
		refs = "0003 TStream.WriteDescendentRes"
	strings:
		$1 = { 6A 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_18584_0 {
	meta:
		name = "Beep"
		size = 8
		refs = "0003 MessageBeep"
	strings:
		$1 = { 6A 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_9343_0 {
	meta:
		name = "GetDIBSizes"
		size = 8
		refs = "0003 InternalGetDIBSizes"
	strings:
		$1 = { 6A 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_15005_0 {
	meta:
		name = "TCustomOutline.Add"
		size = 8
		refs = "0003 TCustomOutline.AddObject"
	strings:
		$1 = { 6A 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_15007_0 {
	meta:
		name = "TCustomOutline.AddChild"
		size = 8
		refs = "0003 TCustomOutline.AddChildObject"
	strings:
		$1 = { 6A 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_15003_0 {
	meta:
		name = "TCustomOutline.Insert"
		size = 8
		refs = "0003 TCustomOutline.InsertObject"
	strings:
		$1 = { 6A 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5560_0 {
	meta:
		name = "TDataSet.InsertRecord"
		size = 8
		refs = "0003 TDataSet.AddRecord"
	strings:
		$1 = { 6A 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2574_0 {
	meta:
		name = "TTreeNodes.Add"
		size = 8
		refs = "0003 TTreeNodes.AddObject"
	strings:
		$1 = { 6A 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2570_0 {
	meta:
		name = "TTreeNodes.AddChild"
		size = 8
		refs = "0003 TTreeNodes.AddChildObject"
	strings:
		$1 = { 6A 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2568_0 {
	meta:
		name = "TTreeNodes.AddChildFirst"
		size = 8
		refs = "0003 TTreeNodes.AddChildObjectFirst"
	strings:
		$1 = { 6A 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2572_0 {
	meta:
		name = "TTreeNodes.AddFirst"
		size = 8
		refs = "0003 TTreeNodes.AddObjectFirst"
	strings:
		$1 = { 6A 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2577_0 {
	meta:
		name = "TTreeNodes.Insert"
		size = 8
		refs = "0003 TTreeNodes.InsertObject"
	strings:
		$1 = { 6A 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1898_0 {
	meta:
		name = "TStream.WriteDescendentRes"
		size = 167
		refs = "0028 StrPLCopy 002d StrUpper 0032 StrLen 0052 TStream.WriteBuffer 0059 TStream.GetPosition 0068 TStream.WriteDescendent 0080 TStream.SetPosition"
	strings:
		$1 = { 55 8B EC 83 C4 A8 53 56 89 4D FC 8B F2 8B D8 8D 45 A8 C6 00 FF 8D 45 A9 66 C7 00 0A 00 8D 45 AB B9 3F 00 00 00 8B D6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C0 0A 8D 54 05 A2 66 C7 02 30 10 8D 54 05 A4 33 C9 89 0A 8D 55 A8 8B C8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B F0 8B 4D 08 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 2B C6 89 45 F8 8B D6 83 EA 04 8B C3 E8 ?? ?? ?? ?? 8D 55 F8 B9 04 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B 55 F8 03 D6 8B C3 E8 ?? ?? ?? ?? 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_1899_0 {
	meta:
		name = "TStream.ReadResHeader"
		size = 177
		refs = "0013 TStream.ReadResHeader 0028 @FillChar 0055 StrLen 0071 SInvalidImage 0076 LoadResString 0080 _DV_EInvalidImage 0085 Exception.Create 008a @RaiseExcept 009f @LStrClr 00a5 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 AC 53 56 33 D2 89 55 AC 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 B0 33 C9 BA 50 00 00 00 E8 ?? ?? ?? ?? 8D 55 B0 B9 4F 00 00 00 8B C3 8B 30 FF 56 04 8B F0 8D 45 B0 80 38 FF 75 28 8D 45 B1 66 83 38 0A 75 1F 8D 45 B0 83 C0 03 E8 ?? ?? ?? ?? 8B D0 83 C2 0A 2B D6 66 B9 01 00 8B C3 8B 18 FF 53 0C EB 21 8D 55 AC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D AC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 AC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1900_0 {
	meta:
		name = "TEventDispatch.Create"
		size = 35
		refs = "0008 @ClassCreate 0014 @AfterConstruction"
		altNames = "THandleStream.Create"
	strings:
		$1 = { 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 48 04 84 D2 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C C3 }
	condition:
		$1
}

rule function_1901_0 {
	meta:
		name = "THandleStream.Read"
		size = 16
		refs = "0004 FileRead"
	strings:
		$1 = { 8B 40 04 E8 ?? ?? ?? ?? 83 F8 FF 75 02 33 C0 C3 }
	condition:
		$1
}

rule function_1902_0 {
	meta:
		name = "THandleStream.Write"
		size = 16
		refs = "0004 FileWrite"
	strings:
		$1 = { 8B 40 04 E8 ?? ?? ?? ?? 83 F8 FF 75 02 33 C0 C3 }
	condition:
		$1
}

rule function_1903_0 {
	meta:
		name = "THandleStream.Seek"
		size = 12
		refs = "0007 FileSeek"
	strings:
		$1 = { 0F B7 C9 8B 40 04 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1904_0 {
	meta:
		name = "THandleStream.SetSize"
		size = 30
		refs = "0012 SetEndOfFile 0017 Win32Check"
	strings:
		$1 = { 53 56 8B D8 33 C9 8B C3 8B 30 FF 56 0C 8B 43 04 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1905_0 {
	meta:
		name = "TFileStream.Create"
		size = 249
		refs = "0016 @ClassCreate 0028 TFileStream.Create 003c FileCreate 005a SFCreateError 005f LoadResString 0069 _DV_EFCreateError 006e Exception.CreateFmt 0073 @RaiseExcept 007f FileOpen 009d SFOpenError 00ac _DV_EFOpenError 00cb @LStrClr 00d1 @HandleFinally 00e0 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 33 DB 89 5D F0 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 88 55 FF 8B D8 8B 7D 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 66 81 FF FF FF 75 40 8B C6 E8 ?? ?? ?? ?? 8B F8 89 7B 04 85 FF 7D 71 89 75 F4 C6 45 F8 0B 8D 45 F4 50 6A 00 8D 55 F0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D F0 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 41 0F B7 D7 8B C6 E8 ?? ?? ?? ?? 89 43 04 83 7B 04 00 7D 2E 89 75 F4 C6 45 F8 0B 8D 45 F4 50 6A 00 8D 55 F0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D F0 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 80 7D FF 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_1906_0 {
	meta:
		name = "TFileStream.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 FileClose 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 04 85 C0 7C 05 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1907_0 {
	meta:
		name = "TCustomMemoryStream.SetPointer"
		size = 7
	strings:
		$1 = { 89 50 04 89 48 08 C3 }
	condition:
		$1
}

rule function_1908_0 {
	meta:
		name = "TCustomMemoryStream.Read"
		size = 56
		refs = "0027 Move"
	strings:
		$1 = { 53 56 57 8B D8 8B 7B 0C 85 FF 7C 24 85 C9 7C 20 8B 73 08 2B F7 85 F6 7E 17 3B CE 7D 02 8B F1 8B 43 04 03 C7 8B CE E8 ?? ?? ?? ?? 01 73 0C EB 02 33 F6 8B C6 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1909_0 {
	meta:
		name = "TCustomMemoryStream.Seek"
		size = 35
	strings:
		$1 = { 66 83 E9 01 72 09 74 0C 66 FF C9 74 0C EB 10 89 50 0C EB 0B 01 50 0C EB 06 03 50 08 89 50 0C 8B 40 0C C3 }
	condition:
		$1
}

rule function_1910_0 {
	meta:
		name = "TCustomMemoryStream.SaveToStream"
		size = 22
		refs = "0010 TStream.WriteBuffer"
	strings:
		$1 = { 53 8B 48 08 85 C9 74 0C 8B 58 04 87 DA 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1911_0 {
	meta:
		name = "TCustomMemoryStream.SaveToFile"
		size = 86
		refs = "000f _DV_TFileStream 0016 TFileStream.Create 0021 TCustomMemoryStream.SaveToFile 0031 TCustomMemoryStream.SaveToStream 0046 TObject.Free 004c @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B D8 68 FF FF 00 00 8B CA A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_5229_0 {
	meta:
		name = "TBlobField.SaveToFile"
		size = 86
		refs = "000f _Dn_TFileStream 0016 TFileStream.Create 0021 TBlobField.SaveToFile 0031 TBlobField.SaveToStream 0046 TObject.Free 004c @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B D8 68 FF FF 00 00 8B CA A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_5827_0 {
	meta:
		name = "TClientDataSet.SaveToFile"
		size = 86
		refs = "000f _Dn_TFileStream 0016 TFileStream.Create 0021 TClientDataSet.SaveToFile 0031 TClientDataSet.SaveToStream 0046 TObject.Free 004c @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B D8 68 FF FF 00 00 8B CA A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_15067_0 {
	meta:
		name = "TCustomOutline.SaveToFile"
		size = 86
		refs = "000f _Dn_TFileStream 0016 TFileStream.Create 0021 TCustomOutline.SaveToFile 0031 TCustomOutline.SaveToStream 0046 TObject.Free 004c @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B D8 68 FF FF 00 00 8B CA A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_2678_0 {
	meta:
		name = "TCustomTreeView.SaveToFile"
		size = 86
		refs = "000f _Dn_TFileStream 0016 TFileStream.Create 0021 TCustomTreeView.SaveToFile 0031 TCustomTreeView.SaveToStream 0046 TObject.Free 004c @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B D8 68 FF FF 00 00 8B CA A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_6657_0 {
	meta:
		name = "TDBGridColumns.SaveToFile"
		size = 86
		refs = "000f _Dn_TFileStream 0016 TFileStream.Create 0021 TDBGridColumns.SaveToFile 0031 TDBGridColumns.SaveToStream 0046 TObject.Free 004c @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B D8 68 FF FF 00 00 8B CA A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_14310_0 {
	meta:
		name = "TOleContainer.SaveToFile"
		size = 86
		refs = "000f _Dn_TFileStream 0016 TFileStream.Create 0021 TOleContainer.SaveToFile 0031 TOleContainer.SaveToStream 0046 TObject.Free 004c @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B D8 68 FF FF 00 00 8B CA A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1913_0 {
	meta:
		name = "TMemoryStream.Clear"
		size = 24
		refs = "0008 TMemoryStream.SetCapacity"
	strings:
		$1 = { 53 8B D8 33 D2 8B C3 E8 ?? ?? ?? ?? 33 C0 89 43 08 33 C0 89 43 0C 5B C3 }
	condition:
		$1
}

rule function_1914_0 {
	meta:
		name = "TMemoryStream.LoadFromStream"
		size = 53
		refs = "000c TStream.SetPosition 0013 TStream.GetSize 002d TStream.ReadBuffer"
	strings:
		$1 = { 53 56 57 8B FA 8B F0 33 D2 8B C7 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 8B D8 8B D3 8B C6 8B 08 FF 11 85 DB 74 0C 8B 56 04 8B CB 8B C7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1915_0 {
	meta:
		name = "TMemoryStream.LoadFromFile"
		size = 83
		refs = "000c _DV_TFileStream 0013 TFileStream.Create 001e TMemoryStream.LoadFromFile 002e TMemoryStream.LoadFromStream 0043 TObject.Free 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B D8 6A 00 8B CA A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_5225_0 {
	meta:
		name = "TBlobField.LoadFromFile"
		size = 83
		refs = "000c _Dn_TFileStream 0013 TFileStream.Create 001e TBlobField.LoadFromFile 002e TBlobField.LoadFromStream 0043 TObject.Free 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B D8 6A 00 8B CA A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_5826_0 {
	meta:
		name = "TClientDataSet.LoadFromFile"
		size = 83
		refs = "000c _Dn_TFileStream 0013 TFileStream.Create 001e TClientDataSet.LoadFromFile 002e TClientDataSet.LoadFromStream 0043 TObject.Free 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B D8 6A 00 8B CA A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_15059_0 {
	meta:
		name = "TCustomOutline.LoadFromFile"
		size = 83
		refs = "000c _Dn_TFileStream 0013 TFileStream.Create 001e TCustomOutline.LoadFromFile 002e TCustomOutline.LoadFromStream 0043 TObject.Free 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B D8 6A 00 8B CA A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_2676_0 {
	meta:
		name = "TCustomTreeView.LoadFromFile"
		size = 83
		refs = "000c _Dn_TFileStream 0013 TFileStream.Create 001e TCustomTreeView.LoadFromFile 002e TCustomTreeView.LoadFromStream 0043 TObject.Free 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B D8 6A 00 8B CA A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_6652_0 {
	meta:
		name = "TDBGridColumns.LoadFromFile"
		size = 83
		refs = "000c _Dn_TFileStream 0013 TFileStream.Create 001e TDBGridColumns.LoadFromFile 002e TDBGridColumns.LoadFromStream 0043 TObject.Free 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B D8 6A 00 8B CA A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_14295_0 {
	meta:
		name = "TOleContainer.LoadFromFile"
		size = 83
		refs = "000c _Dn_TFileStream 0013 TFileStream.Create 001e TOleContainer.LoadFromFile 002e TOleContainer.LoadFromStream 0043 TObject.Free 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B D8 6A 00 8B CA A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1916_0 {
	meta:
		name = "TMemoryStream.SetCapacity"
		size = 37
		refs = "0018 TCustomMemoryStream.SetPointer"
	strings:
		$1 = { 53 51 89 14 24 8B D8 8B D4 8B C3 8B 08 FF 51 10 8B D0 8B 4B 08 8B C3 E8 ?? ?? ?? ?? 8B 04 24 89 43 10 5A 5B C3 }
	condition:
		$1
}

rule function_1917_0 {
	meta:
		name = "TMemoryStream.SetSize"
		size = 43
		refs = "000f TMemoryStream.SetCapacity"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B 7B 0C 8B D6 8B C3 E8 ?? ?? ?? ?? 89 73 08 3B F7 7D 0D 66 B9 02 00 33 D2 8B C3 8B 18 FF 53 0C 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1918_0 {
	meta:
		name = "TMemoryStream.Realloc"
		size = 190
		refs = "000c TMemoryStream.Realloc 0041 GlobalFreePtr 004e HeapAllocFlags 0058 GlobalAllocPtr 006e GlobalReAllocPtr 007c SMemoryStreamError 0081 LoadResString 008b _DV_EStreamError 0090 Exception.Create 0095 @RaiseExcept 00aa @LStrClr 00b0 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 33 C9 55 68 ?? ?? ?? ?? 64 FF 31 64 89 21 83 3A 00 7E 10 8B 0A 81 C1 FF 1F 00 00 81 E1 00 E0 FF FF 89 0A 8B 70 04 8B DE 8B 3A 8B 48 10 3B F9 74 60 83 3A 00 75 0B 8B C6 E8 ?? ?? ?? ?? 33 DB EB 50 85 C9 75 13 A1 ?? ?? ?? ?? 0F B7 00 8B 12 E8 ?? ?? ?? ?? 8B D8 EB 14 8B 0D ?? ?? ?? ?? 0F B7 09 8B 12 8B C6 E8 ?? ?? ?? ?? 8B D8 85 DB 75 21 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1919_0 {
	meta:
		name = "TMemoryStream.Write"
		size = 80
		refs = "002c TMemoryStream.SetCapacity 003e Move"
	strings:
		$1 = { 53 56 57 55 8B F1 8B EA 8B D8 8B 43 0C 85 C0 7C 38 85 F6 7C 34 8B F8 03 FE 85 FF 7E 2C 3B 7B 08 7E 11 3B 7B 10 7E 09 8B D7 8B C3 E8 ?? ?? ?? ?? 89 7B 08 8B 53 04 03 53 0C 8B C5 8B CE E8 ?? ?? ?? ?? 89 7B 0C 8B C6 EB 02 33 C0 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1920_0 {
	meta:
		name = "TStringStream.Create"
		size = 67
		refs = "000b @ClassCreate 001a TObject.Create 0024 @LStrAsg 002f @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 8D 47 04 8B D6 E8 ?? ?? ?? ?? 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1921_0 {
	meta:
		name = "TStringStream.Read"
		size = 61
		refs = "000e @LStrLen 0021 UniqueString 002f Move"
	strings:
		$1 = { 53 56 57 55 8B F9 8B EA 8B D8 8B 43 04 E8 ?? ?? ?? ?? 8B F0 2B 73 08 3B FE 7D 02 8B F7 8D 43 04 E8 ?? ?? ?? ?? 8B 53 08 03 C2 8B D5 8B CE E8 ?? ?? ?? ?? 01 73 08 8B C6 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1922_0 {
	meta:
		name = "TStringStream.Write"
		size = 54
		refs = "0012 @LStrSetLength 001a UniqueString 0029 Move"
	strings:
		$1 = { 53 56 57 8B FA 8B D8 8B F1 8B 53 08 03 D6 8D 43 04 E8 ?? ?? ?? ?? 8D 43 04 E8 ?? ?? ?? ?? 8B 53 08 8D 14 10 8B C7 8B CE E8 ?? ?? ?? ?? 01 73 08 8B C6 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1923_0 {
	meta:
		name = "TStringStream.Seek"
		size = 87
		refs = "0023 @LStrLen"
	strings:
		$1 = { 53 56 8B F2 8B D8 66 83 E9 01 72 09 74 0C 66 FF C9 74 0C EB 17 89 73 08 EB 12 01 73 08 EB 0D 8B 43 04 E8 ?? ?? ?? ?? 2B C6 89 43 08 8B 43 04 E8 ?? ?? ?? ?? 3B 43 08 7D 0D 8B 43 04 E8 ?? ?? ?? ?? 89 43 08 EB 0B 83 7B 08 00 7D 05 33 C0 89 43 08 8B 43 08 5E 5B C3 }
	condition:
		$1
}

rule function_1924_0 {
	meta:
		name = "TStringStream.ReadString"
		size = 60
		refs = "000e @LStrLen 0021 UniqueString 0030 @LStrFromPCharLen"
	strings:
		$1 = { 53 56 57 55 8B E9 8B FA 8B D8 8B 43 04 E8 ?? ?? ?? ?? 8B F0 2B 73 08 3B FE 7D 02 8B F7 8D 43 04 E8 ?? ?? ?? ?? 8B 53 08 8D 14 10 8B C5 8B CE E8 ?? ?? ?? ?? 01 73 08 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1925_0 {
	meta:
		name = "TStringStream.WriteString"
		size = 34
		refs = "0009 @LStrLen 0011 @LStrToPChar"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 E8 ?? ?? ?? ?? 50 8B C6 E8 ?? ?? ?? ?? 8B D0 8B C3 59 8B 18 FF 53 08 5E 5B C3 }
	condition:
		$1
}

rule function_1926_0 {
	meta:
		name = "TStringStream.SetSize"
		size = 27
		refs = "000c @LStrSetLength"
	strings:
		$1 = { 53 56 8B F2 8B D8 8D 43 04 8B D6 E8 ?? ?? ?? ?? 3B 73 08 7D 03 89 73 08 5E 5B C3 }
	condition:
		$1
}

rule function_1927_0 {
	meta:
		name = "TResourceStream.Create"
		size = 86
		refs = "000e @ClassCreate 001d TObject.Create 0029 @LStrToPChar 0034 TResourceStream.Initialize 003f @AfterConstruction"
	strings:
		$1 = { 55 8B EC 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 8B 45 08 50 8B 45 0C E8 ?? ?? ?? ?? 8B C8 8B D6 8B C7 E8 ?? ?? ?? ?? 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_1928_0 {
	meta:
		name = "TResourceStream.CreateFromID"
		size = 79
		refs = "000e @ClassCreate 001d TObject.Create 002d TResourceStream.Initialize 0038 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 8B 45 08 50 8B 4D 0C 8B D6 8B C7 E8 ?? ?? ?? ?? 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_1929_0 {
	meta:
		name = "Error"
		size = 129
		refs = "0012 Error 0024 SResNotFound 0029 LoadResString 0043 Format 004d _DV_EResNotFound 0052 Exception.Create 0057 @RaiseExcept 0071 @LStrArrayClr 0077 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 33 C0 89 45 FC 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F8 8B 55 08 8B 52 FC 89 55 F0 C6 45 F4 06 8D 55 F0 33 C9 E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 8B E5 5D C3 }
	condition:
		$1
}

rule function_1930_0 {
	meta:
		name = "TResourceStream.Initialize"
		size = 108
		refs = "0018 FindResource 0027 Error 0032 LoadResource 004c SizeofResource 0056 LockResource 0060 TCustomMemoryStream.SetPointer"
	strings:
		$1 = { 55 8B EC 51 53 56 57 89 4D FC 8B F2 8B D8 8B 45 08 50 8B 45 FC 50 56 E8 ?? ?? ?? ?? 8B F8 89 7B 10 85 FF 75 07 55 E8 ?? ?? ?? ?? 59 8B 43 10 50 56 E8 ?? ?? ?? ?? 8B F8 89 7B 14 85 FF 75 07 55 E8 ?? ?? ?? ?? 59 8B 43 10 50 56 E8 ?? ?? ?? ?? 50 8B 43 14 50 E8 ?? ?? ?? ?? 8B D0 8B C3 59 E8 ?? ?? ?? ?? 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_1931_0 {
	meta:
		name = "TResourceStream.Destroy"
		size = 54
		refs = "0003 @BeforeDestruction 000f UnlockResource 0018 FreeResource 0024 TObject.Destroy 002f @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 14 E8 ?? ?? ?? ?? 8B 46 14 50 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1932_0 {
	meta:
		name = "TResourceStream.Write"
		size = 88
		refs = "000a TResourceStream.Write 0018 SCantWriteResourceStreamError 001d LoadResString 0027 _DV_EStreamError 002c Exception.Create 0031 @RaiseExcept 0046 @LStrClr 004c @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 }
	condition:
		$1
}

rule function_1933_0 {
	meta:
		name = "TFiler.Create"
		size = 71
		refs = "000e @ClassCreate 001f @GetMem 0030 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F8 8B 75 08 89 4F 04 8B C6 E8 ?? ?? ?? ?? 89 47 08 89 77 0C 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_1934_0 {
	meta:
		name = "TFiler.Destroy"
		size = 40
		refs = "0003 @BeforeDestruction 0016 @FreeMem 0021 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 08 85 C0 74 08 8B 56 0C E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1935_0 {
	meta:
		name = "TPropFixup.Create"
		size = 87
		refs = "000d @ClassCreate 002b @LStrAsg 0041 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 89 4E 04 8B 45 14 89 46 08 8B 45 10 89 46 0C 8D 46 10 8B 55 0C E8 ?? ?? ?? ?? 8D 46 14 8B 55 08 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 5D C2 10 00 }
	condition:
		$1
}

rule function_1936_0 {
	meta:
		name = "AddFinished"
		size = 56
		refs = "000f TList.IndexOf 0031 TList.Add"
	strings:
		$1 = { 55 8B EC 53 8B D8 8B 45 08 8B 40 FC 8B D3 E8 ?? ?? ?? ?? 85 C0 7D 1E 8B 45 08 8B 40 F8 8B D3 E8 ?? ?? ?? ?? 85 C0 7C 0D 8B 45 08 8B 40 FC 8B D3 E8 ?? ?? ?? ?? 5B 5D C3 }
	condition:
		$1
}

rule function_1937_0 {
	meta:
		name = "AddNotFinished"
		size = 69
		refs = "000f TList.IndexOf 0020 TList.Delete 003e TList.Add"
	strings:
		$1 = { 55 8B EC 53 8B D8 8B 45 08 8B 40 FC 8B D3 E8 ?? ?? ?? ?? 83 F8 FF 74 0C 8B 55 08 8B 52 FC 92 E8 ?? ?? ?? ?? 8B 45 08 8B 40 F8 8B D3 E8 ?? ?? ?? ?? 85 C0 7D 0D 8B 45 08 8B 40 F8 8B D3 E8 ?? ?? ?? ?? 5B 5D C3 }
	condition:
		$1
}

rule function_1938_0 {
	meta:
		name = "GlobalFixupReferences"
		size = 496
		refs = "000b FindGlobalComponent 0017 GlobalNameSpace 001c TMultiReadExclusiveWriteSynchronizer.BeginWrite 0024 GlobalFixupReferences 002f GlobalFixupList 0034 TThreadList.LockList 0055 _DV_TList 005a TObject.Create 0098 TList.Get 00b7 GetOrdProp 00cc TComponent.FindComponent 00e2 CompareText 00fa SetOrdProp 0103 AddFinished 010d TList.Delete 0114 TObject.Free 011f AddNotFinished 0145 @HandleFinally 0169 _DV_TComponent 016e @IsClass 01ae TThreadList.UnlockList 01cd TMultiReadExclusiveWriteSynchronizer.EndWrite"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 83 3D ?? ?? ?? ?? 00 0F 84 C3 01 00 00 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 7F 08 00 0F 8E 49 01 00 00 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 F6 E9 92 00 00 00 8B D6 8B C7 E8 ?? ?? ?? ?? 8B D8 8B 43 10 FF 15 ?? ?? ?? ?? 89 45 F4 83 7D F4 00 75 0F 8B 53 0C 8B 43 04 E8 ?? ?? ?? ?? 85 C0 74 5B 83 7D F4 00 74 39 8B 53 14 8B 45 F4 E8 ?? ?? ?? ?? 89 45 F0 83 7D F0 00 75 17 8B 43 14 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 06 8B 45 F4 89 45 F0 8B 53 0C 8B 43 04 8B 4D F0 E8 ?? ?? ?? ?? 55 8B 43 04 E8 ?? ?? ?? ?? 59 8B D6 8B C7 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? EB 0B 55 8B 43 04 E8 ?? ?? ?? ?? 59 46 3B 77 08 0F 8C 65 FF FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 FC 8B 58 08 4B 85 DB 7C 28 43 33 F6 8B D6 8B 45 FC E8 ?? ?? ?? ?? 8B F8 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 04 80 67 20 7F 46 4B 75 DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EE 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EE 5F 5E 5B 8B E5 5D C3 FF FF FF FF 05 00 00 00 4F 57 4E 45 52 00 00 00 }
	condition:
		$1
}

rule function_1939_0 {
	meta:
		name = "NameInStrings"
		size = 131
		refs = "0018 NameInStrings 004c CompareText 006d @LStrClr 0073 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 33 C9 89 4D F0 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C6 45 F7 01 8B 45 FC 8B 10 FF 52 14 8B D8 4B 85 DB 7C 23 43 33 F6 8D 4D F0 8B D6 8B 45 FC 8B 38 FF 57 0C 8B 55 F0 8B 45 F8 E8 ?? ?? ?? ?? 85 C0 74 08 46 4B 75 E0 C6 45 F7 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8A 45 F7 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1940_0 {
	meta:
		name = "GetFixupReferenceNames"
		size = 152
		refs = "000f GlobalFixupList 0014 TThreadList.LockList 001f GetFixupReferenceNames 0043 TList.Get 0059 NameInStrings 0085 TThreadList.UnlockList 008b @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 89 55 FC 8B F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F4 8B 70 08 4E 85 F6 7C 3E 46 C7 45 F8 00 00 00 00 8B 55 F8 8B 45 F4 E8 ?? ?? ?? ?? 8B D8 85 FF 74 05 3B 7B 08 75 1A 8B 53 10 8B 45 FC E8 ?? ?? ?? ?? 84 C0 75 0B 8B 53 10 8B 45 FC 8B 08 FF 51 34 FF 45 F8 4E 75 CA 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EE 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1941_0 {
	meta:
		name = "RedirectFixupReferences"
		size = 160
		refs = "0012 GlobalFixupList 0017 TThreadList.LockList 0022 RedirectFixupReferences 0046 TList.Get 005c CompareText 006b @LStrAsg 0076 GlobalFixupReferences 008d TThreadList.UnlockList 0093 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 89 4D F8 89 55 FC 8B F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F0 8B 70 08 4E 85 F6 7C 3E 46 C7 45 F4 00 00 00 00 8B 55 F4 8B 45 F0 E8 ?? ?? ?? ?? 8B D8 85 FF 74 05 3B 7B 08 75 1A 8B 53 10 8B 45 FC E8 ?? ?? ?? ?? 85 C0 75 0B 8D 43 10 8B 55 F8 E8 ?? ?? ?? ?? FF 45 F4 4E 75 CA E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EE 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1942_0 {
	meta:
		name = "RemoveFixupReferences"
		size = 169
		refs = "0011 GlobalFixupList 0022 TThreadList.LockList 002c RemoveFixupReferences 0044 TList.Get 0065 CompareText 0072 TList.Delete 0079 TObject.Free 0096 TThreadList.UnlockList 009c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 89 55 F8 89 45 FC 83 3D ?? ?? ?? ?? 00 0F 84 86 00 00 00 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 5F 08 4B 83 FB 00 7C 44 8B D3 8B C7 E8 ?? ?? ?? ?? 8B F0 83 7D FC 00 74 08 8B 46 08 3B 45 FC 75 25 83 7D F8 00 74 0F 8B 56 10 8B 45 F8 E8 ?? ?? ?? ?? 85 C0 75 10 8B D3 8B C7 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 4B 83 FB FF 75 BC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EE 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1943_0 {
	meta:
		name = "RemoveFixups"
		size = 132
		refs = "000c GlobalFixupList 0019 TThreadList.LockList 0023 RemoveFixups 003b TList.Get 004e TList.Delete 0055 TObject.Free 0072 TThreadList.UnlockList 0078 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 57 89 45 FC 83 3D ?? ?? ?? ?? 00 74 6B A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 5F 08 4B 83 FB 00 7C 29 8B D3 8B C7 E8 ?? ?? ?? ?? 8B F0 8B 46 04 3B 45 FC 75 10 8B D3 8B C7 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 4B 83 FB FF 75 D7 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EE 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1944_0 {
	meta:
		name = "GetFixupInstanceNames"
		size = 162
		refs = "0013 GlobalFixupList 0018 TThreadList.LockList 0023 GetFixupInstanceNames 0041 TList.Get 0056 CompareText 0065 NameInStrings 008f TThreadList.UnlockList 0095 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 89 4D F4 89 55 F8 89 45 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F0 8B 70 08 4E 85 F6 7C 44 46 33 FF 8B D7 8B 45 F0 E8 ?? ?? ?? ?? 8B D8 8B 43 08 3B 45 FC 75 29 8B 53 10 8B 45 F8 E8 ?? ?? ?? ?? 85 C0 75 1A 8B 53 14 8B 45 F4 E8 ?? ?? ?? ?? 84 C0 75 0B 8B 53 14 8B 45 F4 8B 08 FF 51 34 47 4E 75 BF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EE 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1948_0 {
	meta:
		name = "EnumValue"
		size = 22
		refs = "0002 GetEnumValue 000e PropValueError"
	strings:
		$1 = { 53 E8 ?? ?? ?? ?? 8B D8 83 FB FF 75 05 E8 ?? ?? ?? ?? 8B C3 5B C3 }
	condition:
		$1
}

rule function_1949_0 {
	meta:
		name = "TReader.Destroy"
		size = 57
		refs = "0004 @BeforeDestruction 0026 TFiler.Destroy 0031 @ClassDestroy"
	strings:
		$1 = { 53 56 57 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 56 10 2B 56 14 66 B9 01 00 8B 46 04 8B 38 FF 57 0C 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1950_0 {
	meta:
		name = "TReader.BeginReferences"
		size = 102
		refs = "000d _DV_TList 0012 TObject.Create 0020 TReader.BeginReferences 0047 @HandleAnyException 0052 TObject.Free 0057 @RaiseAgain 005c @DoneExcept"
	strings:
		$1 = { 55 8B EC 51 53 56 57 89 45 FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 89 42 30 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 89 42 2C 33 C0 5A 59 59 64 89 10 EB 1A E9 ?? ?? ?? ?? 8B 45 FC 8B 40 30 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1951_0 {
	meta:
		name = "TReader.CheckValue"
		size = 35
		refs = "0009 TReader.ReadValue 0017 TReader.SkipValue 001c PropValueError"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 3A D8 74 0F FF 4E 10 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1952_0 {
	meta:
		name = "TReader.DefineProperty"
		size = 52
		refs = "000f CompareText 002a @LStrClr"
	strings:
		$1 = { 55 8B EC 53 56 8B F2 8B D8 8B 53 60 8B C6 E8 ?? ?? ?? ?? 85 C0 75 17 66 83 7D 12 00 74 10 8B D3 8B 45 14 FF 55 10 8D 43 60 E8 ?? ?? ?? ?? 5E 5B 5D C2 10 00 }
	condition:
		$1
}

rule function_1953_0 {
	meta:
		name = "TReader.DefineBinaryProperty"
		size = 217
		refs = "0015 CompareText 0030 TReader.ReadValue 0042 TReader.SkipValue 004e PropValueError 0055 _DV_TMemoryStream 005a TObject.Create 0065 TReader.DefineBinaryProperty 007b TReader.Read 00bb TObject.Free 00c1 @HandleFinally 00ce @LStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 8B DA 89 45 FC 8B 45 FC 8B 50 60 8B C3 E8 ?? ?? ?? ?? 85 C0 0F 85 B1 00 00 00 66 83 7D 12 00 0F 84 A6 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 3C 0A 74 1A 8B 45 FC FF 48 10 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC C6 40 5C 01 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 F4 B9 04 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 55 F4 8B 45 F8 8B 08 FF 11 8B 45 F8 8B 50 04 8B 4D F4 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC C6 40 5C 01 8B 55 F8 8B 45 14 FF 55 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 FC 83 C0 60 E8 ?? ?? ?? ?? 5B 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule function_1954_0 {
	meta:
		name = "TReader.EndOfList"
		size = 20
		refs = "0006 TReader.ReadValue"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 0F 94 C0 FF 4B 10 5B C3 }
	condition:
		$1
}

rule function_1955_0 {
	meta:
		name = "TReader.EndReferences"
		size = 25
		refs = "0006 TReader.FreeFixups 000e TObject.Free"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 43 30 E8 ?? ?? ?? ?? 33 C0 89 43 30 5B C3 }
	condition:
		$1
}

rule function_1956_0 {
	meta:
		name = "TReader.Error"
		size = 32
	strings:
		$1 = { 53 51 C6 04 24 00 66 83 78 56 00 74 0D 54 8B D8 8B CA 8B D0 8B 43 58 FF 53 54 8A 04 24 5A 5B C3 }
	condition:
		$1
}

rule function_1957_0 {
	meta:
		name = "TReader.FindMethod"
		size = 102
		refs = "001b @LStrToString 0026 TObject.MethodAddress 0055 PropValueError"
	strings:
		$1 = { 53 56 57 81 C4 F8 FE FF FF 8B F1 8B FA 8B D8 8D 44 24 08 8B D6 B9 FF 00 00 00 E8 ?? ?? ?? ?? 8D 54 24 08 8B 07 E8 ?? ?? ?? ?? 89 04 24 83 3C 24 00 0F 94 44 24 04 66 83 7B 36 00 74 10 54 8D 44 24 08 50 8B CE 8B D3 8B 43 38 FF 53 34 80 7C 24 04 00 74 05 E8 ?? ?? ?? ?? 8B 04 24 81 C4 08 01 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1958_0 {
	meta:
		name = "TReader.DoFixupReferences"
		size = 256
		refs = "0015 TReader.DoFixupReferences 0055 TList.Get 0062 @LStrLAsg 007b TComponent.FindComponent 008e CompareText 00a5 SetOrdProp 00c0 TReader.FreeFixups 00c6 @HandleFinally 00dd @LStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 33 D2 89 55 F4 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 40 2C 85 C0 0F 84 9F 00 00 00 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 78 08 4F 85 FF 7C 6C 47 C7 45 F8 00 00 00 00 8B 45 FC 8B 40 2C 8B 55 F8 E8 ?? ?? ?? ?? 8B D8 8D 45 F4 8B 53 14 E8 ?? ?? ?? ?? 8D 55 F4 8B 45 FC 8B 08 FF 51 18 8B 45 FC 8B 40 18 8B 55 F4 E8 ?? ?? ?? ?? 8B F0 85 F6 75 17 BA ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? 85 C0 75 06 8B 45 FC 8B 70 18 8B 53 0C 8B 43 04 8B CE E8 ?? ?? ?? ?? FF 45 F8 4F 75 9C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 FF FF FF FF 05 00 00 00 4F 57 4E 45 52 00 00 00 }
	condition:
		$1
}

rule function_1959_0 {
	meta:
		name = "TReader.FixupReferences"
		size = 54
		refs = "0008 TReader.DoFixupReferences 000d GlobalFixupReferences 0025 TList.Get"
	strings:
		$1 = { 53 56 57 8B F8 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 47 30 8B 58 08 4B 85 DB 7C 16 43 33 F6 8B 47 30 8B D6 E8 ?? ?? ?? ?? 8B 10 FF 52 0C 46 4B 75 ED 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1960_0 {
	meta:
		name = "TReader.FlushBuffer"
		size = 32
		refs = "0006 TReader.GetPosition 0010 TStream.SetPosition"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D0 8B 43 04 E8 ?? ?? ?? ?? 33 C0 89 43 10 33 C0 89 43 14 5B C3 }
	condition:
		$1
}

rule function_1961_0 {
	meta:
		name = "TReader.FreeFixups"
		size = 59
		refs = "001d TList.Get 0022 TObject.Free"
	strings:
		$1 = { 53 56 57 8B D8 8B 43 2C 85 C0 74 2B 8B 70 08 4E 85 F6 7C 16 46 33 FF 8B D7 8B 43 2C E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 47 4E 75 ED 8B 43 2C E8 ?? ?? ?? ?? 33 C0 89 43 2C 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1962_0 {
	meta:
		name = "TReader.GetPosition"
		size = 21
		refs = "0007 TStream.GetPosition"
	strings:
		$1 = { 53 8B D8 8B 43 04 E8 ?? ?? ?? ?? 8B 53 14 2B 53 10 2B C2 5B C3 }
	condition:
		$1
}

rule function_1963_0 {
	meta:
		name = "TReader.NextValue"
		size = 15
		refs = "0006 TReader.ReadValue"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? FF 4B 10 5B C3 }
	condition:
		$1
}

rule function_1965_0 {
	meta:
		name = "TReader.Read"
		size = 73
		refs = "0016 TReader.ReadBuffer"
	strings:
		$1 = { 56 57 53 89 D7 89 CB 89 C6 EB 36 8B 4E 14 2B 4E 10 77 0A 89 F0 E8 ?? ?? ?? ?? 8B 4E 14 39 D9 72 02 89 D9 56 29 CB 8B 46 08 03 46 10 01 4E 10 89 C6 89 CA C1 E9 02 FC F3 A5 89 D1 83 E1 03 F3 A4 5E 09 DB 75 C6 5B 5F 5E C3 }
	condition:
		$1
}

rule function_1966_0 {
	meta:
		name = "TReader.ReadBuffer"
		size = 118
		refs = "000d TReader.ReadBuffer 0032 SReadError 0037 LoadResString 0041 _DV_EReadError 0046 Exception.Create 004b @RaiseExcept 0065 @LStrClr 006b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 53 08 8B 4B 0C 8B 43 04 8B 30 FF 56 04 8B F0 89 73 14 85 F6 75 21 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 89 43 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1967_0 {
	meta:
		name = "TReader.ReadBoolean"
		size = 17
		refs = "0006 TReader.ReadValue"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 3C 09 0F 94 C0 5B C3 }
	condition:
		$1
}

rule function_1968_0 {
	meta:
		name = "TReader.ReadChar"
		size = 129
		refs = "0012 TReader.ReadChar 0021 TReader.CheckValue 0030 TReader.Read 0044 TReader.ReadStr 0049 PropValueError 006d @LStrClr 0073 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B2 06 8B C3 E8 ?? ?? ?? ?? 8D 55 FF B9 01 00 00 00 8B C3 E8 ?? ?? ?? ?? 8A 45 FF 3C 01 74 12 FF 4B 10 8D 55 F8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 55 FF B9 01 00 00 00 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8A 45 FF 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1969_0 {
	meta:
		name = "TReader.ReadCollection"
		size = 172
		refs = "0017 TReader.ReadCollection 0024 TReader.EndOfList 0030 TCollection.Clear 0039 TReader.NextValue 0046 TReader.ReadInteger 004e TCollection.Add 0057 TReader.ReadListBegin 0062 TReader.ReadProperty 0074 TReader.ReadListEnd 00a1 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 89 55 FC 8B D8 8B 45 FC 8B 10 FF 52 14 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 84 C0 75 4C 8B 45 FC E8 ?? ?? ?? ?? EB 42 8B C3 E8 ?? ?? ?? ?? 04 FE 2C 03 73 07 8B C3 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B F0 8B C3 E8 ?? ?? ?? ?? EB 09 8B D6 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 84 C0 74 EC 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 84 C0 74 B3 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 10 FF 52 18 C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1970_0 {
	meta:
		name = "ComponentCreated"
		size = 29
	strings:
		$1 = { 55 8B EC 8B 45 08 F6 40 FF 01 75 09 8B 45 08 83 78 F8 00 74 04 33 C0 5D C3 B0 01 5D C3 }
	condition:
		$1
}

rule function_1971_0 {
	meta:
		name = "Recover"
		size = 94
		refs = "000a ExceptObject 0010 _Dn_Exception 0015 @IsClass 0022 ComponentCreated 002e TObject.Free 003f TReader.SkipComponent"
	strings:
		$1 = { 55 8B EC 53 56 8B F0 33 DB E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 3B 8B 45 08 50 E8 ?? ?? ?? ?? 59 84 C0 74 07 8B 06 E8 ?? ?? ?? ?? 33 C0 89 06 8B 45 08 8B 40 F4 33 D2 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 04 8B 45 08 8B 40 F4 8B 08 FF 51 0C 8B D8 8B C3 5E 5B 5D C3 }
	condition:
		$1
}

rule function_1972_0 {
	meta:
		name = "CreateComponent"
		size = 120
		refs = "000a CreateComponent 0024 FindFieldClass 0051 @HandleAnyException 0060 Recover 006a @RaiseAgain 006f @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 50 EC 8B 45 08 8B 40 F4 8B 40 18 E8 ?? ?? ?? ?? 8B 55 08 8B 52 F4 8B 4A 24 B2 01 FF 50 2C 8B 55 08 89 42 F0 8B 45 08 8B 40 F0 80 48 20 01 33 C0 5A 59 59 64 89 10 EB 23 E9 ?? ?? ?? ?? 8B 45 08 50 8B 45 08 83 C0 F0 E8 ?? ?? ?? ?? 59 84 C0 75 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule function_1973_0 {
	meta:
		name = "SetCompName"
		size = 117
		refs = "000a SetCompName 0028 @CallDynaInst 004e @HandleAnyException 005d Recover 0067 @RaiseAgain 006c @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 F4 8B 50 28 8B 45 08 8B 40 F0 66 BB F9 FF E8 ?? ?? ?? ?? 8B 45 08 8D 48 E8 8B 45 08 8B 50 F0 8B 45 08 8B 40 F4 8B 18 FF 53 14 33 C0 5A 59 59 64 89 10 EB 23 E9 ?? ?? ?? ?? 8B 45 08 50 8B 45 08 83 C0 F0 E8 ?? ?? ?? ?? 59 84 C0 75 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule function_1974_0 {
	meta:
		name = "FindExistingComponent"
		size = 139
		refs = "000a FindExistingComponent 0024 FindFieldClass 004c @CallDynaInst 0064 @HandleAnyException 0073 Recover 007d @RaiseAgain 0082 @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 50 EC 8B 45 08 8B 40 F4 8B 40 18 E8 ?? ?? ?? ?? 8B C8 8B 45 08 8B 50 E8 8B 45 08 8B 40 F4 8B 18 FF 53 1C 8B 55 08 89 42 F0 8B 45 08 8B 40 F0 66 BB F3 FF E8 ?? ?? ?? ?? 8B 55 08 8B 52 F4 89 42 28 33 C0 5A 59 59 64 89 10 EB 23 E9 ?? ?? ?? ?? 8B 45 08 50 8B 45 08 83 C0 F0 E8 ?? ?? ?? ?? 59 84 C0 75 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule function_1975_0 {
	meta:
		name = "TReader.ReadComponent"
		size = 382
		refs = "001b TReader.ReadComponent 003a TReader.ReadStr 0074 FindExistingComponent 007d CreateComponent 00a9 SetCompName 00bd @TryFinallyExit 00f6 @CallDynaInst 0104 TList.Add 0113 @HandleAnyException 0119 ComponentCreated 0126 TObject.Free 012b @RaiseAgain 0130 @DoneExcept 014c @HandleFinally 0168 @LStrArrayClr"
	strings:
		$1 = { 55 8B EC 83 C4 E0 53 56 57 33 C9 89 4D EC 89 4D E8 89 55 F8 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 4D E4 8D 55 FF 8B 45 F4 8B 18 FF 53 20 8D 55 EC 8B 45 F4 E8 ?? ?? ?? ?? 8D 55 E8 8B 45 F4 E8 ?? ?? ?? ?? 8B 45 F4 8B 40 28 89 45 E0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 89 45 F0 83 7D F0 00 75 16 F6 45 FF 01 74 09 55 E8 ?? ?? ?? ?? 59 EB 07 55 E8 ?? ?? ?? ?? 59 83 7D F0 00 0F 84 A8 00 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F0 80 48 20 01 F6 45 FF 01 75 07 55 E8 ?? ?? ?? ?? 59 83 7D F0 00 75 12 33 C0 5A 59 59 64 89 10 E8 ?? ?? ?? ?? E9 8C 00 00 00 8B 45 F0 80 48 20 02 8B 55 F4 8B 45 F0 8B 08 FF 51 14 8B 45 F0 80 60 20 FD F6 45 FF 02 74 15 8B 45 F4 8B 40 28 8B 4D E4 8B 55 F0 66 BB FA FF E8 ?? ?? ?? ?? 8B 45 F4 8B 40 30 8B 55 F0 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 22 E9 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 84 C0 74 08 8B 45 F0 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F4 8B 55 E0 89 50 28 C3 E9 ?? ?? ?? ?? EB EF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 8B 45 F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1976_0 {
	meta:
		name = "TReader.ReadData"
		size = 112
		refs = "0016 _DV_TList 001b TObject.Create 0029 TReader.ReadData 0039 TReader.ReadDataInner 0041 TReader.DoFixupReferences 0056 TReader.FreeFixups 005c @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B DA 89 45 FC 8B 45 FC 83 78 2C 00 75 4F B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 89 42 2C 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D3 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B D3 8B 45 FC E8 ?? ?? ?? ?? 5B 59 5D C3 }
	condition:
		$1
}

rule function_1977_0 {
	meta:
		name = "TReader.ReadDataInner"
		size = 208
		refs = "0016 TReader.ReadProperty 001e TReader.EndOfList 002a TReader.ReadListEnd 0047 @CallDynaInst 0055 TReader.ReadDataInner 008a TReader.ReadComponent 00c3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 8B F2 89 45 FC EB 0A 8B D6 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 84 C0 74 EA 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 8B 40 28 89 45 F8 8B 45 FC 8B 40 24 89 45 F4 8B C6 66 BB FB FF E8 ?? ?? ?? ?? 8B 55 FC 89 42 28 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 66 BB FC FF E8 ?? ?? ?? ?? 8B F8 8B 45 FC 89 78 24 85 FF 75 18 8B 45 FC 8B 40 18 8B 55 FC 89 42 24 EB 0A 33 D2 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 84 C0 74 EA 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 55 F8 89 50 28 8B 45 FC 8B 55 F4 89 50 24 C3 E9 ?? ?? ?? ?? EB E6 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1978_0 {
	meta:
		name = "TReader.ReadFloat"
		size = 63
		refs = "0009 TReader.ReadValue 001b TReader.Read 0027 TReader.ReadInteger"
	strings:
		$1 = { 53 83 C4 F0 8B D8 8B C3 E8 ?? ?? ?? ?? 3C 05 75 10 8B D4 B9 0A 00 00 00 8B C3 E8 ?? ?? ?? ?? EB 16 FF 4B 10 8B C3 E8 ?? ?? ?? ?? 89 44 24 0C DB 44 24 0C DB 3C 24 9B DB 2C 24 83 C4 10 5B C3 }
	condition:
		$1
}

rule function_1979_0 {
	meta:
		name = "TReader.ReadSingle"
		size = 62
		refs = "0009 TReader.ReadValue 001b TReader.Read 0027 TReader.ReadInteger"
	strings:
		$1 = { 53 83 C4 F8 8B D8 8B C3 E8 ?? ?? ?? ?? 3C 0F 75 10 8B D4 B9 04 00 00 00 8B C3 E8 ?? ?? ?? ?? EB 16 FF 4B 10 8B C3 E8 ?? ?? ?? ?? 89 44 24 04 DB 44 24 04 D9 1C 24 9B D9 04 24 59 5A 5B C3 }
	condition:
		$1
}

rule function_1980_0 {
	meta:
		name = "TReader.ReadCurrency"
		size = 76
		refs = "0009 TReader.ReadValue 001b TReader.Read 0027 TReader.ReadInteger 0035 TReader.ReadCurrency"
	strings:
		$1 = { 53 83 C4 F4 8B D8 8B C3 E8 ?? ?? ?? ?? 3C 10 75 10 8B D4 B9 08 00 00 00 8B C3 E8 ?? ?? ?? ?? EB 1C FF 4B 10 8B C3 E8 ?? ?? ?? ?? 89 44 24 08 DB 44 24 08 D8 0D ?? ?? ?? ?? DF 3C 24 9B DF 2C 24 83 C4 0C 5B C3 00 00 00 00 40 1C 46 }
	condition:
		$1
}

rule function_1981_0 {
	meta:
		name = "TReader.ReadDate"
		size = 63
		refs = "0009 TReader.ReadValue 001b TReader.Read 0027 TReader.ReadInteger"
	strings:
		$1 = { 53 83 C4 F4 8B D8 8B C3 E8 ?? ?? ?? ?? 3C 11 75 10 8B D4 B9 08 00 00 00 8B C3 E8 ?? ?? ?? ?? EB 16 FF 4B 10 8B C3 E8 ?? ?? ?? ?? 89 44 24 08 DB 44 24 08 DD 1C 24 9B DD 04 24 83 C4 0C 5B C3 }
	condition:
		$1
}

rule function_1982_0 {
	meta:
		name = "TReader.ReadIdent"
		size = 180
		refs = "000a TReader.ReadValue 002a TReader.Read 0038 @LStrFromPCharLen 003f UniqueString 0056 TReader.ReadIdent 005b @LStrLAsg 007e PropValueError"
	strings:
		$1 = { 53 56 51 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 2C 07 74 0E FE C8 74 3D FE C8 74 47 2C 04 74 51 EB 5D 8B D4 B9 01 00 00 00 8B C3 E8 ?? ?? ?? ?? 33 C9 8A 0C 24 8B C6 33 D2 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B D0 33 C9 8A 0C 24 8B C3 E8 ?? ?? ?? ?? EB 2F 8B C6 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 21 8B C6 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 13 8B C6 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 5A 5E 5B C3 00 00 FF FF FF FF 05 00 00 00 46 61 6C 73 65 00 00 00 FF FF FF FF 04 00 00 00 54 72 75 65 00 00 00 00 FF FF FF FF 03 00 00 00 6E 69 6C 00 }
	condition:
		$1
}

rule function_1983_0 {
	meta:
		name = "TReader.ReadInteger"
		size = 107
		refs = "0009 TReader.ReadValue 0027 TReader.Read 0060 PropValueError"
	strings:
		$1 = { 53 83 C4 F8 8B D8 8B C3 E8 ?? ?? ?? ?? 2C 02 74 0A FE C8 74 20 FE C8 74 36 EB 44 8D 54 24 04 B9 01 00 00 00 8B C3 E8 ?? ?? ?? ?? 0F BE 44 24 04 89 04 24 EB 2F 8D 54 24 06 B9 02 00 00 00 8B C3 E8 ?? ?? ?? ?? 0F BF 44 24 06 89 04 24 EB 15 8B D4 B9 04 00 00 00 8B C3 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 8B 04 24 59 5A 5B C3 }
	condition:
		$1
}

rule function_1984_0 {
	meta:
		name = "TReader.ReadListBegin"
		size = 8
		refs = "0003 TReader.CheckValue"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_9046_0 {
	meta:
		name = "TApplication.NormalizeAllTopMosts"
		size = 8
		refs = "0003 TApplication.DoNormalizeTopMosts"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_12638_0 {
	meta:
		name = "TBaseArray.GetAutoSize"
		size = 8
		refs = "0003 TBaseArray.HasFlag"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_16582_0 {
	meta:
		name = "TCustomQuickRep.Preview"
		size = 8
		refs = "0003 TCustomQuickRep.PreviewIt"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_16583_0 {
	meta:
		name = "TCustomQuickRep.PreviewModal"
		size = 8
		refs = "0003 TCustomQuickRep.PreviewIt"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_19542_0 {
	meta:
		name = "TCustomTeePanel.PrintLandscape"
		size = 8
		refs = "0003 TCustomTeePanel.PrintOrientation"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_14953_0 {
	meta:
		name = "TOutlineNode.Expand"
		size = 8
		refs = "0003 TOutlineNode.SetExpandedState"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_7462_0 {
	meta:
		name = "TQuery.CreateHandle"
		size = 8
		refs = "0003 TQuery.CreateCursor"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_7061_0 {
	meta:
		name = "TSession.Open"
		size = 8
		refs = "0003 TSession.SetActive"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_7417_0 {
	meta:
		name = "TStoredProc.CreateHandle"
		size = 8
		refs = "0003 TStoredProc.CreateCursor"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2523_0 {
	meta:
		name = "TTreeNode.GetDropTarget"
		size = 8
		refs = "0003 TTreeNode.GetState"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2043_0 {
	meta:
		name = "TWriter.WriteListBegin"
		size = 8
		refs = "0003 TWriter.WriteValue"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1986_0 {
	meta:
		name = "TReader.ReadPrefix"
		size = 64
		refs = "000a TReader.ReadPrefix 0013 TReader.NextValue 0020 TReader.ReadValue 0030 TReader.ReadInteger"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 A0 ?? ?? ?? ?? 88 06 8B C3 E8 ?? ?? ?? ?? 24 F0 3C F0 75 19 8B C3 E8 ?? ?? ?? ?? 24 0F 88 06 F6 06 02 74 09 8B C3 E8 ?? ?? ?? ?? 89 07 5F 5E 5B C3 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_1987_0 {
	meta:
		name = "HandleException"
		size = 286
		refs = "001b HandleException 0029 @LStrClr 0035 _DV_TComponent 003a @IsClass 004f @LStrLAsg 0068 TObject.ClassName 0076 @LStrFromString 008b DotSep 00d1 SPropertyException 00d6 LoadResString 00e3 _DV_EReadError 00e8 Exception.CreateFmt 00ed @RaiseExcept 0113 @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 D8 FE FF FF 53 33 D2 89 95 D8 FE FF FF 89 55 FC 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 11 8D 45 FC 8B 55 08 8B 52 FC 8B 52 08 E8 ?? ?? ?? ?? 83 7D FC 00 75 21 8D 95 FC FE FF FF 8B 45 08 8B 40 FC 8B 00 E8 ?? ?? ?? ?? 8D 95 FC FE FF FF 8D 45 FC E8 ?? ?? ?? ?? 8B 45 FC 89 85 DC FE FF FF C6 85 E0 FE FF FF 0B A1 ?? ?? ?? ?? 8B 00 89 85 E4 FE FF FF C6 85 E8 FE FF FF 0B 8B 45 08 8B 40 F8 89 85 EC FE FF FF C6 85 F0 FE FF FF 0B 8B 43 04 89 85 F4 FE FF FF C6 85 F8 FE FF FF 0B 8D 85 DC FE FF FF 50 6A 03 8D 95 D8 FE FF FF A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 8D D8 FE FF FF B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 D8 FE FF FF E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E5 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1988_0 {
	meta:
		name = "PropPathError"
		size = 83
		refs = "0009 PropPathError 001a TReader.SkipValue 0022 SInvalidPropertyPath 0027 LoadResString 002f ReadError 0044 @LStrClr 004a @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 F4 E8 ?? ?? ?? ?? 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_1989_0 {
	meta:
		name = "TReader.ReadProperty"
		size = 466
		refs = "0018 TReader.ReadProperty 0037 TReader.ReadStr 0052 @LStrLen 0089 @LStrCopy 0097 TObject.ClassInfo 00a2 GetPropInfo 00b0 TReader.PropertyError 00c8 GetOrdProp 00d4 _DV_TPersistent 00d9 @IsClass 00e3 PropPathError 0118 TReader.ReadPropValue 0153 @HandleOnException 015b _Dn_Exception 0165 HandleException 016b @DoneExcept 01a5 @RaiseAgain 01bf @LStrClr 01c5 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D F8 89 55 FC 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8D 55 F8 8B 45 F4 E8 ?? ?? ?? ?? 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 BB 01 00 00 00 8B 45 F8 E8 ?? ?? ?? ?? 8B F0 8B 45 FC 89 45 F0 8B 45 F4 C6 40 5C 01 8B FB EB 01 43 3B F3 7C 0A 8B 45 F8 80 7C 18 FF 2E 75 F1 8B 45 F4 83 C0 60 50 8B CB 2B CF 8B D7 8B 45 F8 E8 ?? ?? ?? ?? 3B F3 7C 63 8B 45 F0 8B 00 E8 ?? ?? ?? ?? 8B 55 F4 8B 52 60 E8 ?? ?? ?? ?? 8B F8 85 FF 75 08 8B 45 F4 E8 ?? ?? ?? ?? 33 C0 89 45 EC 8B 07 8B 00 80 38 07 75 0D 8B D7 8B 45 F0 E8 ?? ?? ?? ?? 89 45 EC 8B 45 EC 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 07 55 E8 ?? ?? ?? ?? 59 8B 45 EC 89 45 F0 43 E9 71 FF FF FF 8B 45 F0 8B 00 E8 ?? ?? ?? ?? 8B 55 F4 8B 52 60 E8 ?? ?? ?? ?? 8B F8 85 FF 74 0F 8B CF 8B 55 F0 8B 45 F4 E8 ?? ?? ?? ?? EB 2A 8B 45 F4 C6 40 5C 00 8B 55 F4 8B 45 F0 8B 08 FF 51 04 8B 45 F4 C6 40 5C 01 8B 45 F4 83 78 60 00 74 08 8B 45 F4 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 1D E9 ?? ?? ?? ?? 01 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 35 E9 ?? ?? ?? ?? 01 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 89 C3 8B 45 F4 80 78 5C 00 74 0F 8B 53 04 8B 45 F4 8B 08 FF 51 0C 84 C0 75 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1990_0 {
	meta:
		name = "SetIntIdent"
		size = 180
		refs = "001c IntConstList 0021 TThreadList.LockList 002c SetIntIdent 004a TList.Get 0086 TThreadList.UnlockList 008c @HandleFinally 00a2 SetOrdProp 00a9 PropValueError"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 56 57 89 4D F4 89 55 F8 89 45 FC C6 45 EF 00 33 C0 89 45 F0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 E8 8B 70 08 4E 85 F6 7C 32 46 33 FF 8B D7 8B 45 E8 E8 ?? ?? ?? ?? 8B D8 8B 45 F8 8B 00 8B 00 3B 43 04 75 13 8D 55 F0 8B 45 F4 FF 53 08 84 C0 74 06 C6 45 EF 01 EB 04 47 4E 75 D1 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EE 80 7D EF 00 74 10 8B 4D F0 8B 55 F8 8B 45 FC E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1991_0 {
	meta:
		name = "SetObjectIdent"
		size = 236
		refs = "0017 SetObjectIdent 0025 @LStrClr 002f @LStrLAsg 003b @LStrPos 0054 @LStrCopy 0086 _DV_TPropFixup 008b TPropFixup.Create 00a3 TList.Add 00ac GlobalFixupList 00b1 TThreadList.Add 00cb @LStrArrayClr 00d1 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 53 56 57 8B D9 89 55 FC 8B F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 F4 8B D3 E8 ?? ?? ?? ?? 8B D3 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 85 F6 74 26 8D 45 F8 50 8B CE 49 BA 01 00 00 00 8B C3 E8 ?? ?? ?? ?? 8D 45 F4 50 8D 56 01 B9 FF FF FF 7F 8B C3 E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC 8B 40 18 50 8B 45 FC 50 8B 45 F8 50 8B 45 F4 50 8B CF B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 83 7D F8 00 75 12 8B 45 08 8B 40 FC 8B 40 2C 8B D3 E8 ?? ?? ?? ?? EB 0C 8B D3 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 8B E5 5D C3 00 00 FF FF FF FF 01 00 00 00 2E 00 00 00 }
	condition:
		$1
}

rule function_1992_0 {
	meta:
		name = "ReadVariantProp"
		size = 516
		refs = "0010 ReadVariantProp 0021 TReader.NextValue 008e TReader.ReadValue 009a @VarClear 00a8 Null 00ad @VarCopy 00bd TReader.ReadInteger 00f7 TReader.ReadFloat 010b TReader.ReadSingle 011f TReader.ReadCurrency 0133 TReader.ReadDate 0147 TReader.ReadString 0152 @VarFromLStr 0162 TReader.ReadWideString 016d @VarFromWStr 0191 SReadError 0196 LoadResString 01a0 _DV_EReadError 01a5 Exception.Create 01aa @RaiseExcept 01b6 ValTtoVarT 01ce SetVariantProp 01e3 @WStrClr 01eb @LStrClr 01f3 @VarClr 01f9 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 51 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B D8 33 C0 8A C3 83 F8 12 0F 87 59 01 00 00 FF 24 85 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 3C 0D 75 0D 8D 45 F0 E8 ?? ?? ?? ?? E9 0B 01 00 00 8D 45 F0 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 F8 00 00 00 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 88 45 F8 E9 E5 00 00 00 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 66 89 45 F8 E9 D1 00 00 00 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 89 45 F8 E9 BE 00 00 00 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? DD 5D F8 9B E9 AA 00 00 00 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? D9 5D F8 9B E9 96 00 00 00 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? DF 7D F8 9B E9 82 00 00 00 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? DD 5D F8 9B EB 71 8D 55 EC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? EB 56 8D 55 E8 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B 55 E8 8D 45 F0 E8 ?? ?? ?? ?? EB 3B 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 3C 09 0F 94 C0 F6 D8 1B C0 66 89 45 F8 EB 21 8D 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D EC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 8A C3 66 8B 04 85 ?? ?? ?? ?? 66 89 45 F0 8D 4D F0 8B 45 08 8B 50 F4 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1993_0 {
	meta:
		name = "TReader.ReadPropValue"
		size = 616
		refs = "0019 TReader.ReadPropValue 0030 SReadOnlyProperty 0035 LoadResString 003d ReadError 0094 TReader.NextValue 00a3 TReader.ReadIdent 00b1 SetIntIdent 00be TReader.ReadInteger 00cb SetOrdProp 00d8 TReader.ReadChar 0101 EnumValue 011b TReader.ReadFloat 012d SetFloatProp 013d TReader.ReadString 014b SetStrProp 015a TReader.ReadSet 0186 TReader.ReadValue 01ab GetOrdProp 01b5 TReader.ReadCollection 01d4 SetObjectIdent 01f0 NilMethod 01fb SetMethodProp 0241 ReadVariantProp 0257 @LStrClr 025d @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 33 DB 89 5D E8 89 4D F4 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F4 83 78 08 00 75 15 8D 55 E8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 E8 E8 ?? ?? ?? ?? 8B 45 F4 8B 00 8B 18 33 C0 8A 03 83 F8 0C 0F 87 F1 01 00 00 FF 24 85 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 3C 07 75 1E 8D 55 E8 8B 45 FC E8 ?? ?? ?? ?? 8B 4D E8 8B 55 F4 8B 45 F8 E8 ?? ?? ?? ?? E9 8C 01 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B C8 8B 55 F4 8B 45 F8 E8 ?? ?? ?? ?? E9 72 01 00 00 8B 45 FC E8 ?? ?? ?? ?? 33 C9 8A C8 8B 55 F4 8B 45 F8 E8 ?? ?? ?? ?? E9 56 01 00 00 8D 55 E8 8B 45 FC E8 ?? ?? ?? ?? 8B 55 E8 8B C3 E8 ?? ?? ?? ?? 8B C8 8B 55 F4 8B 45 F8 E8 ?? ?? ?? ?? E9 2F 01 00 00 8B 45 FC E8 ?? ?? ?? ?? 83 C4 F4 DB 3C 24 9B 8B 55 F4 8B 45 F8 E8 ?? ?? ?? ?? E9 10 01 00 00 8D 55 E8 8B 45 FC E8 ?? ?? ?? ?? 8B 4D E8 8B 55 F4 8B 45 F8 E8 ?? ?? ?? ?? E9 F2 00 00 00 8B D3 8B 45 FC E8 ?? ?? ?? ?? 8B C8 8B 55 F4 8B 45 F8 E8 ?? ?? ?? ?? E9 D6 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 2C 0D 74 06 FE C8 74 1C EB 3C 8B 45 FC E8 ?? ?? ?? ?? 33 C9 8B 55 F4 8B 45 F8 E8 ?? ?? ?? ?? E9 AA 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 55 F4 8B 45 F8 E8 ?? ?? ?? ?? 8B D0 8B 45 FC E8 ?? ?? ?? ?? E9 88 00 00 00 55 8D 55 E8 8B 45 FC E8 ?? ?? ?? ?? 8B 4D E8 8B 55 F4 8B 45 F8 E8 ?? ?? ?? ?? 59 EB 6B 8B 45 FC E8 ?? ?? ?? ?? 3C 0D 75 1A 8B 45 FC E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? 8B 55 F4 8B 45 F8 E8 ?? ?? ?? ?? EB 45 8D 55 E8 8B 45 FC E8 ?? ?? ?? ?? 8B 4D E8 8B 45 FC 8B 50 18 8B 45 FC 8B 18 FF 53 10 89 45 EC 8B 45 FC 8B 40 18 89 45 F0 83 7D EC 00 74 17 8D 4D EC 8B 55 F4 8B 45 F8 E8 ?? ?? ?? ?? EB 07 55 E8 ?? ?? ?? ?? 59 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1994_0 {
	meta:
		name = "FindUniqueName"
		size = 112
		refs = "0012 @LStrClr 0018 FindGlobalComponent 0024 @LStrLAsg 0043 FindUniqueName 0048 Format"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 8B DA 8B F8 33 F6 8B C3 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 39 8B C3 8B D7 E8 ?? ?? ?? ?? EB 22 46 53 89 7D F0 C6 45 F4 0B 89 75 F8 C6 45 FC 00 8D 55 F0 B9 01 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 03 FF 15 ?? ?? ?? ?? 85 C0 75 D2 5F 5E 5B 8B E5 5D C3 00 FF FF FF FF 05 00 00 00 25 73 5F 25 64 00 00 00 }
	condition:
		$1
}

rule function_1995_0 {
	meta:
		name = "TReader.ReadRootComponent"
		size = 624
		refs = "001b TReader.ReadRootComponent 0029 TReader.ReadSignature 0033 GlobalNameSpace 0038 TMultiReadExclusiveWriteSynchronizer.BeginWrite 0073 TReader.ReadStr 007b FindClass 00da FindUniqueName 00f3 @GetTls 00f9 GlobalLoaded 0116 _DV_TList 011b TObject.Create 0140 TList.Add 01aa TList.Get 01db TObject.Free 01e9 @HandleFinally 01f0 GlobalFixupReferences 01ff @HandleAnyException 0209 RemoveFixupReferences 021c @RaiseAgain 0221 @DoneExcept 0238 TMultiReadExclusiveWriteSynchronizer.EndWrite 025a @LStrArrayClr"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 C9 89 4D E8 89 4D E4 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 33 C0 89 45 F4 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 4D F0 8D 55 EF 8B 45 FC 8B 18 FF 53 20 83 7D F8 00 75 35 8D 55 E8 8B 45 FC E8 ?? ?? ?? ?? 8B 45 E8 E8 ?? ?? ?? ?? 33 C9 B2 01 FF 50 2C 89 45 F4 8D 55 E8 8B 45 FC E8 ?? ?? ?? ?? 8B 55 E8 8B 45 F4 8B 08 FF 51 18 EB 48 8B 45 F8 89 45 F4 8D 55 E8 8B 45 FC E8 ?? ?? ?? ?? 8B 45 F4 F6 40 20 10 74 0D 8D 55 E8 8B 45 FC E8 ?? ?? ?? ?? EB 21 8D 55 E4 8B 45 FC E8 ?? ?? ?? ?? 8B 45 E4 8D 55 E8 E8 ?? ?? ?? ?? 8B 55 E8 8B 45 F4 8B 08 FF 51 18 8B 45 FC 8B 55 F4 89 50 18 E8 ?? ?? ?? ?? 83 B8 ?? ?? ?? ?? 00 74 13 E8 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 8B 55 FC 89 42 30 EB 12 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 89 42 30 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 50 18 8B 45 FC 8B 40 30 E8 ?? ?? ?? ?? 8B 45 FC 8B 40 18 8B 55 FC 89 42 24 8B 45 FC 8B 40 18 80 48 20 01 8B 45 FC 8B 40 18 80 48 20 02 8B 45 FC 8B 40 18 8B 55 FC 8B 08 FF 51 14 8B 45 FC 8B 40 18 80 60 20 FD E8 ?? ?? ?? ?? 83 B8 ?? ?? ?? ?? 00 75 2F 8B 45 FC 8B 40 30 8B 58 08 4B 85 DB 7C 21 43 C7 45 F0 00 00 00 00 8B 45 FC 8B 40 30 8B 55 F0 E8 ?? ?? ?? ?? 8B 10 FF 52 0C FF 45 F0 4B 75 E7 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 B8 ?? ?? ?? ?? 00 75 0B 8B 45 FC 8B 40 30 E8 ?? ?? ?? ?? 8B 45 FC 33 D2 89 50 30 C3 E9 ?? ?? ?? ?? EB D7 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 27 E9 ?? ?? ?? ?? 33 D2 8B 45 F8 E8 ?? ?? ?? ?? 83 7D F8 00 75 08 8B 45 F4 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EE 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 8B 45 F4 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1996_0 {
	meta:
		name = "TReader.ReadComponents"
		size = 144
		refs = "001d TReader.BeginReferences 0025 TReader.ReadComponents 0035 TReader.ReadSignature 003f TReader.ReadComponent 0056 TReader.EndOfList 0062 TReader.ReadListEnd 006a TReader.FixupReferences 007f TReader.EndReferences 0085 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 89 45 FC 8B 45 FC 89 50 18 8B 45 FC 89 50 24 8B 45 FC 89 48 28 8B 45 FC E8 ?? ?? ?? ?? 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 EB 21 8B 45 FC E8 ?? ?? ?? ?? 33 D2 8B 45 FC E8 ?? ?? ?? ?? 66 83 7D 0A 00 74 08 8B D0 8B 45 0C FF 55 08 8B 45 FC E8 ?? ?? ?? ?? 84 C0 74 D3 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C2 08 00 }
	condition:
		$1
}

rule function_1997_0 {
	meta:
		name = "TReader.ReadSet"
		size = 186
		refs = "0017 TReader.ReadSet 0033 TReader.ReadValue 003c PropValueError 0043 GetTypeData 0055 TReader.ReadStr 0065 EnumValue 007e @HandleAnyException 0086 TReader.SkipSetBody 008b @RaiseAgain 0090 @DoneExcept 00a5 @LStrClr 00ab @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 33 C9 89 4D F8 8B DA 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 3C 0B 74 05 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B 40 01 8B 30 33 DB 8D 55 F8 8B 45 FC E8 ?? ?? ?? ?? 83 7D F8 00 74 14 8B 55 F8 8B C6 E8 ?? ?? ?? ?? 83 F8 1F 77 E0 0F AB C3 EB DB 33 C0 5A 59 59 64 89 10 EB 17 E9 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1998_0 {
	meta:
		name = "TReader.ReadSignature"
		size = 103
		refs = "000f TReader.ReadSignature 0022 TReader.Read 002b FilerSignature 0035 SInvalidImage 003a LoadResString 0042 ReadError 0057 @LStrClr 005d @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 33 D2 89 55 F8 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8D 55 FC B9 04 00 00 00 E8 ?? ?? ?? ?? 8B 45 FC 3B 05 ?? ?? ?? ?? 74 15 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 59 5D C3 }
	condition:
		$1
}

rule function_1999_0 {
	meta:
		name = "TReader.ReadStr"
		size = 60
		refs = "0011 TReader.Read 001f @LStrFromPCharLen 0026 UniqueString"
	strings:
		$1 = { 53 56 51 8B F2 8B D8 8B D4 B9 01 00 00 00 8B C3 E8 ?? ?? ?? ?? 33 C9 8A 0C 24 8B C6 33 D2 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B D0 33 C9 8A 0C 24 8B C3 E8 ?? ?? ?? ?? 5A 5E 5B C3 }
	condition:
		$1
}

rule function_2000_0 {
	meta:
		name = "TReader.ReadString"
		size = 94
		refs = "000f TReader.ReadValue 0027 TReader.Read 003e PropValueError 004a @LStrFromPCharLen"
	strings:
		$1 = { 53 56 51 8B F2 8B D8 33 C0 89 04 24 8B C3 E8 ?? ?? ?? ?? 2C 06 74 06 2C 06 74 12 EB 20 8B D4 B9 01 00 00 00 8B C3 E8 ?? ?? ?? ?? EB 15 8B D4 B9 04 00 00 00 8B C3 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 8B C6 8B 0C 24 33 D2 E8 ?? ?? ?? ?? 8B 16 8B 0C 24 8B C3 E8 ?? ?? ?? ?? 5A 5E 5B C3 }
	condition:
		$1
}

rule function_2001_0 {
	meta:
		name = "TReader.ReadWideString"
		size = 70
		refs = "000f TReader.ReadValue 0018 PropValueError 0026 TReader.Read 0030 @WStrSetLength"
	strings:
		$1 = { 53 56 51 8B F2 8B D8 33 C0 89 04 24 8B C3 E8 ?? ?? ?? ?? 3C 12 74 05 E8 ?? ?? ?? ?? 8B D4 B9 04 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 14 24 E8 ?? ?? ?? ?? 8B 0C 24 03 C9 8B 16 8B C3 E8 ?? ?? ?? ?? 5A 5E 5B C3 }
	condition:
		$1
}

rule function_2002_0 {
	meta:
		name = "TReader.ReadValue"
		size = 18
		refs = "0009 TReader.Read"
	strings:
		$1 = { 51 8B D4 B9 01 00 00 00 E8 ?? ?? ?? ?? 8A 04 24 5A C3 }
	condition:
		$1
}

rule function_2003_0 {
	meta:
		name = "TReader.SetPosition"
		size = 23
		refs = "0007 TStream.SetPosition"
	strings:
		$1 = { 53 8B D8 8B 43 04 E8 ?? ?? ?? ?? 33 C0 89 43 10 33 C0 89 43 14 5B C3 }
	condition:
		$1
}

rule function_2004_0 {
	meta:
		name = "TReader.SkipSetBody"
		size = 71
		refs = "000c TReader.SkipSetBody 001c TReader.ReadStr 0037 @LStrClr 003d @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 83 7D FC 00 75 F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_2005_0 {
	meta:
		name = "SkipList"
		size = 40
		refs = "000f TReader.SkipValue 0016 TReader.EndOfList 0021 TReader.ReadListEnd"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 83 C3 FC EB 07 8B 03 E8 ?? ?? ?? ?? 8B 03 E8 ?? ?? ?? ?? 84 C0 74 EE 8B 03 E8 ?? ?? ?? ?? 5B 5D C3 }
	condition:
		$1
}

rule function_2006_0 {
	meta:
		name = "SkipBytes"
		size = 84
		refs = "002a TReader.Read"
	strings:
		$1 = { 55 8B EC 81 C4 00 FF FF FF 53 8B D8 85 DB 7E 3F 81 FB 00 01 00 00 7E 1E 8D 95 00 FF FF FF 8B 45 08 8B 40 FC B9 00 01 00 00 E8 ?? ?? ?? ?? 81 EB 00 01 00 00 EB 15 8D 95 00 FF FF FF 8B 45 08 8B 40 FC 8B CB E8 ?? ?? ?? ?? 33 DB 85 DB 7F C1 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2007_0 {
	meta:
		name = "SkipBinary"
		size = 39
		refs = "0013 TReader.Read 001f SkipBytes"
	strings:
		$1 = { 55 8B EC 51 8D 55 FC 8B 45 08 8B 40 FC B9 04 00 00 00 E8 ?? ?? ?? ?? 8B 45 08 50 8B 45 FC E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule function_2008_0 {
	meta:
		name = "SkipCollection"
		size = 95
		refs = "000f TReader.NextValue 001c TReader.SkipValue 002a SkipBytes 0034 TReader.SkipProperty 003b TReader.EndOfList 0046 TReader.ReadListEnd"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 83 C3 FC EB 3E 8B 03 E8 ?? ?? ?? ?? 04 FE 2C 03 73 07 8B 03 E8 ?? ?? ?? ?? 8B 45 08 50 B8 01 00 00 00 E8 ?? ?? ?? ?? 59 EB 07 8B 03 E8 ?? ?? ?? ?? 8B 03 E8 ?? ?? ?? ?? 84 C0 74 EE 8B 03 E8 ?? ?? ?? ?? 8B 03 E8 ?? ?? ?? ?? 84 C0 74 B7 8B 03 E8 ?? ?? ?? ?? 5B 5D C3 }
	condition:
		$1
}

rule function_2009_0 {
	meta:
		name = "TReader.SkipValue"
		size = 254
		refs = "0012 TReader.SkipValue 0020 TReader.ReadValue 0077 SkipList 0085 SkipBytes 00bd TReader.ReadStr 00c5 SkipBinary 00d0 TReader.SkipSetBody 00d8 SkipCollection 00ee @LStrClr 00f4 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 33 D2 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 83 E0 7F 83 F8 0E 0F 87 AD 00 00 00 FF 24 85 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? EB 68 55 E8 ?? ?? ?? ?? 59 EB 5F 55 B8 01 00 00 00 E8 ?? ?? ?? ?? 59 EB 51 55 B8 02 00 00 00 E8 ?? ?? ?? ?? 59 EB 43 55 B8 04 00 00 00 E8 ?? ?? ?? ?? 59 EB 35 55 B8 0A 00 00 00 E8 ?? ?? ?? ?? 59 EB 27 8D 55 F8 8B 45 FC E8 ?? ?? ?? ?? EB 1A 55 E8 ?? ?? ?? ?? 59 EB 11 8B 45 FC E8 ?? ?? ?? ?? EB 07 55 E8 ?? ?? ?? ?? 59 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 59 5D C3 }
	condition:
		$1
}

rule function_2010_0 {
	meta:
		name = "CopySetBody"
		size = 109
		refs = "0009 CopySetBody 001a TReader.ReadValue 0027 TWriter.WriteValue 0035 TReader.ReadStr 0043 TWriter.WriteStr 005e @LStrClr 0064 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 8B D0 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 55 FC 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC 8B 55 FC E8 ?? ?? ?? ?? 83 7D FC 00 75 DE 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_2011_0 {
	meta:
		name = "CopyList"
		size = 73
		refs = "0014 TReader.ReadValue 001d TWriter.WriteValue 0028 TReader.CopyValue 002f TReader.EndOfList 003a TReader.ReadListEnd 0041 TWriter.WriteListEnd"
	strings:
		$1 = { 55 8B EC 53 56 8B 5D 08 83 C3 F8 8B 75 08 83 C6 FC 8B 03 E8 ?? ?? ?? ?? 8B D0 8B 06 E8 ?? ?? ?? ?? EB 09 8B 16 8B 03 E8 ?? ?? ?? ?? 8B 03 E8 ?? ?? ?? ?? 84 C0 74 EC 8B 03 E8 ?? ?? ?? ?? 8B 06 E8 ?? ?? ?? ?? 5E 5B 5D C3 }
	condition:
		$1
}

rule function_2012_0 {
	meta:
		name = "CopyBytes"
		size = 141
		refs = "0036 TReader.Read 004c TWriter.Write"
	strings:
		$1 = { 55 8B EC 50 B8 02 00 00 00 81 C4 04 F0 FF FF 50 48 75 F6 8B 45 FC 83 C4 04 53 8B D8 81 FB 00 20 00 00 7E 3A 8D 95 00 E0 FF FF 8B 45 08 8B 40 F8 B9 00 20 00 00 E8 ?? ?? ?? ?? 8D 95 00 E0 FF FF 8B 45 08 8B 40 FC B9 00 20 00 00 E8 ?? ?? ?? ?? 81 EB 00 20 00 00 81 FB 00 20 00 00 7F C6 85 DB 7E 26 8D 95 00 E0 FF FF 8B 45 08 8B 40 F8 8B CB E8 ?? ?? ?? ?? 8D 95 00 E0 FF FF 8B 45 08 8B 40 FC 8B CB E8 ?? ?? ?? ?? 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2013_0 {
	meta:
		name = "CopyBinary"
		size = 82
		refs = "000b TReader.ReadValue 0018 TWriter.WriteValue 002b TReader.Read 003e TWriter.Write 004a CopyBytes"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 8B D0 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 55 FC 8B 45 08 8B 40 F8 B9 04 00 00 00 E8 ?? ?? ?? ?? 8D 55 FC 8B 45 08 8B 40 FC B9 04 00 00 00 E8 ?? ?? ?? ?? 8B 45 08 50 8B 45 FC E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule function_2014_0 {
	meta:
		name = "TReader.CopyValue"
		size = 289
		refs = "0015 TReader.CopyValue 0023 TReader.NextValue 007a TReader.ReadValue 0084 TWriter.WriteValue 008c CopyList 0097 TReader.ReadInteger 00a1 TWriter.WriteInteger 00ab TReader.ReadFloat 00ba TWriter.WriteFloat 00c7 TReader.ReadStr 00d2 TWriter.WriteStr 00df TReader.ReadIdent 00ea TWriter.WriteIdent 00f2 CopyBinary 00fb CopySetBody 0111 @LStrClr 0117 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 33 C9 89 4D F4 89 55 FC 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 E8 ?? ?? ?? ?? 83 E0 7F 83 F8 0E 0F 87 CD 00 00 00 FF 24 85 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 8B D0 8B 45 FC E8 ?? ?? ?? ?? EB 76 55 E8 ?? ?? ?? ?? 59 EB 6D 8B 45 F8 E8 ?? ?? ?? ?? 8B D0 8B 45 FC E8 ?? ?? ?? ?? EB 59 8B 45 F8 E8 ?? ?? ?? ?? 83 C4 F4 DB 3C 24 9B 8B 45 FC E8 ?? ?? ?? ?? EB 40 8D 55 F4 8B 45 F8 E8 ?? ?? ?? ?? 8B 55 F4 8B 45 FC E8 ?? ?? ?? ?? EB 28 8D 55 F4 8B 45 F8 E8 ?? ?? ?? ?? 8B 55 F4 8B 45 FC E8 ?? ?? ?? ?? EB 10 55 E8 ?? ?? ?? ?? 59 EB 07 55 E8 ?? ?? ?? ?? 59 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B E5 5D C3 }
	condition:
		$1
}

rule function_2015_0 {
	meta:
		name = "TReader.SkipProperty"
		size = 72
		refs = "000c TReader.SkipProperty 001c TReader.ReadStr 0023 TReader.SkipValue 0038 @LStrClr 003e @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_2016_0 {
	meta:
		name = "TReader.SkipComponent"
		size = 157
		refs = "0013 TReader.SkipComponent 0034 TReader.ReadStr 0047 TReader.SkipProperty 004e TReader.EndOfList 0059 TReader.ReadListEnd 008b @LStrClr 0091 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 33 C9 89 4D F4 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 84 D2 74 2A 8D 4D F8 8D 55 FF 8B C6 8B 18 FF 53 20 8D 55 F4 8B C6 E8 ?? ?? ?? ?? 8D 55 F4 8B C6 E8 ?? ?? ?? ?? EB 07 8B C6 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 84 C0 74 EE 8B C6 E8 ?? ?? ?? ?? EB 09 B2 01 8B C6 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 84 C0 74 EC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2017_0 {
	meta:
		name = "TReader.FindAncestorComponent"
		size = 192
		refs = "001b TReader.FindAncestorComponent 002b @LStrLAsg 0036 TComponent.FindComponent 0074 SAncestorNotFound 0079 LoadResString 0083 _DV_EReadError 0088 Exception.CreateFmt 008d @RaiseExcept 00a2 @LStrClr 00b0 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 89 5D F8 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F8 8B D6 E8 ?? ?? ?? ?? 8B 55 F8 8B 43 18 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 4E 66 83 7B 4E 00 74 10 57 8D 45 FC 50 8B 4D F8 8B D3 8B 43 50 FF 53 4C 83 7D FC 00 75 31 8B 45 F8 89 45 F0 C6 45 F4 0B 8D 45 F0 50 6A 00 8D 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D EC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B 45 FC 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2018_0 {
	meta:
		name = "TReader.ReferenceName"
		size = 22
	strings:
		$1 = { 53 66 83 78 46 00 74 0C 8B CA 8B D8 8B D0 8B 43 48 FF 53 44 5B C3 }
	condition:
		$1
}

rule function_2019_0 {
	meta:
		name = "TReader.SetName"
		size = 40
	strings:
		$1 = { 53 56 57 8B F1 8B DA 66 83 78 3E 00 74 0D 56 8B F8 8B CB 8B D0 8B 47 40 FF 57 3C 8B 16 8B C3 8B 08 FF 51 18 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2021_0 {
	meta:
		name = "TQRCustomController.AddAfter"
		size = 9
		refs = "0004 TList.Add"
		altNames = "TWriter.AddAncestor"
	strings:
		$1 = { 8B 40 2C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2022_0 {
	meta:
		name = "TWriter.DefineProperty"
		size = 37
		refs = "0014 TWriter.WritePropName"
	strings:
		$1 = { 55 8B EC 53 8B D8 84 C9 74 16 66 83 7D 0A 00 74 0F 8B C3 E8 ?? ?? ?? ?? 8B D3 8B 45 0C FF 55 08 5B 5D C2 10 00 }
	condition:
		$1
}

rule function_2023_0 {
	meta:
		name = "TWriter.DefineBinaryProperty"
		size = 42
		refs = "0014 TWriter.WritePropName 0021 TWriter.WriteBinary"
	strings:
		$1 = { 55 8B EC 53 8B D8 84 C9 74 1B 66 83 7D 0A 00 74 14 8B C3 E8 ?? ?? ?? ?? FF 75 0C FF 75 08 8B C3 E8 ?? ?? ?? ?? 5B 5D C2 10 00 }
	condition:
		$1
}

rule function_2024_0 {
	meta:
		name = "TWriter.GetPosition"
		size = 16
		refs = "0007 TStream.GetPosition"
	strings:
		$1 = { 53 8B D8 8B 43 04 E8 ?? ?? ?? ?? 03 43 10 5B C3 }
	condition:
		$1
}

rule function_2026_0 {
	meta:
		name = "TWriter.SetPosition"
		size = 55
		refs = "000a TStream.GetPosition 001e TWriter.WriteBuffer 0028 TStream.SetPosition"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 43 04 E8 ?? ?? ?? ?? 3B C6 7F 09 8B 53 10 03 D0 3B F2 7E 14 8B C3 E8 ?? ?? ?? ?? 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5E 5B C3 2B F0 89 73 10 5E 5B C3 }
	condition:
		$1
}

rule function_2027_0 {
	meta:
		name = "TWriter.Write"
		size = 73
		refs = "0016 TWriter.WriteBuffer"
	strings:
		$1 = { 56 57 53 89 D6 89 CB 89 C7 EB 36 8B 4F 0C 2B 4F 10 77 0A 89 F8 E8 ?? ?? ?? ?? 8B 4F 0C 39 D9 72 02 89 D9 29 CB 57 8B 47 08 03 47 10 01 4F 10 89 C7 89 CA C1 E9 02 FC F3 A5 89 D1 83 E1 03 F3 A4 5F 09 DB 75 C6 5B 5F 5E C3 }
	condition:
		$1
}

rule function_2028_0 {
	meta:
		name = "TWriter.WriteBinary"
		size = 134
		refs = "000c _DV_TMemoryStream 0011 TObject.Create 001c TWriter.WriteBinary 0034 TWriter.WriteValue 003c TStream.GetSize 004e TWriter.Write 0073 TObject.Free 0079 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 8B D8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B 45 0C FF 55 08 B2 0A 8B C3 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 89 45 F8 8D 55 F8 B9 04 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 8B 50 04 8B 4D F8 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 59 5D C2 08 00 }
	condition:
		$1
}

rule function_2029_0 {
	meta:
		name = "TWriter.WriteBuffer"
		size = 24
		refs = "000d TStream.WriteBuffer"
	strings:
		$1 = { 53 8B D8 8B 53 08 8B 4B 10 8B 43 04 E8 ?? ?? ?? ?? 33 C0 89 43 10 5B C3 }
	condition:
		$1
}

rule function_2030_0 {
	meta:
		name = "TWriter.WriteBoolean"
		size = 20
		refs = "0007 TWriter.WriteValue"
	strings:
		$1 = { 84 D2 74 08 B2 09 E8 ?? ?? ?? ?? C3 B2 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2031_0 {
	meta:
		name = "TWriter.WriteChar"
		size = 79
		refs = "000f TWriter.WriteChar 001f @LStrFromChar 0029 TWriter.WriteString 003e @LStrClr 0044 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B DA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 8B D3 E8 ?? ?? ?? ?? 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2032_0 {
	meta:
		name = "TWriter.WriteCollection"
		size = 82
		refs = "000d TWriter.WriteValue 0014 TCollection.GetCount 0025 TWriter.WriteListBegin 002e TCollection.GetItem 0037 TWriter.WriteProperties 003e TWriter.WriteListEnd"
	strings:
		$1 = { 53 56 57 55 8B EA 8B D8 B2 0E 8B C3 E8 ?? ?? ?? ?? 8B C5 E8 ?? ?? ?? ?? 8B F0 4E 85 F6 7C 27 46 33 FF 8B C3 E8 ?? ?? ?? ?? 8B D7 8B C5 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 47 4E 75 DC 8B C3 E8 ?? ?? ?? ?? 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2033_0 {
	meta:
		name = "FindAncestor"
		size = 77
		refs = "002a TList.Get 0037 CompareText"
	strings:
		$1 = { 55 8B EC 51 53 56 57 89 45 FC 8B 45 08 8B 40 FC 8B 40 2C 8B 58 08 4B 85 DB 7C 28 43 33 FF 8B 45 08 8B 40 FC 8B 40 2C 8B D7 E8 ?? ?? ?? ?? 8B F0 8B 55 FC 8B 46 08 E8 ?? ?? ?? ?? 85 C0 74 06 47 4B 75 DB 33 F6 8B C6 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2034_0 {
	meta:
		name = "TWriter.WriteComponent"
		size = 57
		refs = "001c FindAncestor"
	strings:
		$1 = { 55 8B EC 51 53 8B DA 89 45 FC 80 4B 20 04 8B 45 FC 83 78 2C 00 74 10 55 8B 43 08 E8 ?? ?? ?? ?? 59 8B 55 FC 89 42 1C 8B 55 FC 8B C3 8B 08 FF 51 24 80 63 20 FB 5B 59 5D C3 }
	condition:
		$1
}

rule function_2035_0 {
	meta:
		name = "TWriter.WriteData"
		size = 724
		refs = "001c TWriter.WriteData 0032 TObject.ClassName 0045 @LStrLen 0066 TWriter.WriteBuffer 006e TWriter.GetPosition 00b5 TList.Get 00d2 TWriter.WritePrefix 00f3 @LStrFromString 0101 TWriter.WriteStr 014f TWriter.WriteProperties 0157 TWriter.WriteListEnd 01c5 _DV_TComponent 01ca @IsClass 01d5 _DV_TList 01da TObject.Create 01e9 TWriter.AddAncestor 01fe @CallDynaInst 0207 TWriter.WriteComponent 0231 TObject.Free 0237 @HandleFinally 02a3 TWriter.SetPosition 02bb @LStrClr"
	strings:
		$1 = { 55 8B EC 81 C4 DC FE FF FF 53 33 C9 89 8D DC FE FF FF 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 95 E0 FE FF FF 8B 45 F8 8B 00 E8 ?? ?? ?? ?? 33 DB 8A 9D E0 FE FF FF 8B 45 F8 8B 40 08 E8 ?? ?? ?? ?? 03 D8 43 83 C3 05 83 C3 03 8B 45 FC 8B 40 0C 8B 55 FC 2B 42 10 3B D8 7E 08 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 89 45 F4 A0 ?? ?? ?? ?? 88 45 E3 8B 45 FC 83 78 1C 00 74 04 80 4D E3 01 8B 45 FC 8B 58 2C 85 DB 74 31 8B 45 FC 8B 40 30 3B 43 08 7D 26 8B 45 FC 83 78 1C 00 74 19 8B 45 FC 8B 50 30 8B 45 FC 8B 40 2C E8 ?? ?? ?? ?? 8B 55 FC 3B 42 1C 74 04 80 4D E3 02 8B 45 FC 8B 48 34 8A 55 E3 8B 45 FC E8 ?? ?? ?? ?? 8D 95 E0 FE FF FF 8B 45 F8 8B 00 E8 ?? ?? ?? ?? 8D 95 E0 FE FF FF 8D 85 DC FE FF FF E8 ?? ?? ?? ?? 8B 95 DC FE FF FF 8B 45 FC E8 ?? ?? ?? ?? 8B 45 F8 8B 50 08 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 89 45 F0 8B 45 FC 8B 40 2C 85 C0 74 20 8B 55 FC 8B 52 30 3B 50 08 7D 15 8B 45 FC 83 78 1C 00 74 06 8B 45 FC FF 40 30 8B 45 FC FF 40 34 8B 55 F8 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 8B 40 2C 89 45 EC 8B 45 FC 8B 40 30 89 45 E8 8B 45 FC 8B 40 34 89 45 E4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 33 D2 89 50 2C 8B 45 FC 33 D2 89 50 30 8B 45 FC 33 D2 89 50 34 8B 45 FC 80 78 20 00 0F 85 94 00 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 58 1C 85 DB 74 41 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 30 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 89 42 2C 8B 45 FC 50 68 ?? ?? ?? ?? 8B 45 FC 8B 50 24 8B 45 FC 8B 40 1C 66 BB FD FF E8 ?? ?? ?? ?? 8B 45 FC 50 68 ?? ?? ?? ?? 8B 45 FC 8B 50 18 8B 45 F8 66 BB FD FF E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 40 2C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 55 EC 89 50 2C 8B 45 FC 8B 55 E8 89 50 30 8B 45 FC 8B 55 E4 89 50 34 C3 E9 ?? ?? ?? ?? EB DD 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 8B 40 18 3B 45 F8 74 27 A0 ?? ?? ?? ?? 3A 45 E3 75 1D 8B 45 FC E8 ?? ?? ?? ?? 8B 55 F0 83 C2 02 3B C2 75 0B 8B 55 F4 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 DC FE FF FF E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 5B 8B E5 5D C3 00 00 00 00 01 00 00 00 }
	condition:
		$1
}

rule function_2036_0 {
	meta:
		name = "TWriter.WriteDescendent"
		size = 34
		refs = "0012 TWriter.WriteSignature 001b TWriter.WriteComponent"
	strings:
		$1 = { 53 56 8B F2 8B D8 89 4B 24 89 4B 1C 89 73 18 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2037_0 {
	meta:
		name = "TWriter.WriteFloat"
		size = 35
		refs = "000b TWriter.WriteValue 001a TWriter.Write"
	strings:
		$1 = { 55 8B EC 53 8B D8 B2 05 8B C3 E8 ?? ?? ?? ?? 8D 55 08 B9 0A 00 00 00 8B C3 E8 ?? ?? ?? ?? 5B 5D C2 0C 00 }
	condition:
		$1
}

rule function_2038_0 {
	meta:
		name = "TWriter.WriteSingle"
		size = 35
		refs = "000b TWriter.WriteValue 001a TWriter.Write"
	strings:
		$1 = { 55 8B EC 53 8B D8 B2 0F 8B C3 E8 ?? ?? ?? ?? 8D 55 08 B9 04 00 00 00 8B C3 E8 ?? ?? ?? ?? 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_2039_0 {
	meta:
		name = "TWriter.WriteCurrency"
		size = 35
		refs = "000b TWriter.WriteValue 001a TWriter.Write"
	strings:
		$1 = { 55 8B EC 53 8B D8 B2 10 8B C3 E8 ?? ?? ?? ?? 8D 55 08 B9 08 00 00 00 8B C3 E8 ?? ?? ?? ?? 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_2040_0 {
	meta:
		name = "TWriter.WriteDate"
		size = 35
		refs = "000b TWriter.WriteValue 001a TWriter.Write"
	strings:
		$1 = { 55 8B EC 53 8B D8 B2 11 8B C3 E8 ?? ?? ?? ?? 8D 55 08 B9 08 00 00 00 8B C3 E8 ?? ?? ?? ?? 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_2041_0 {
	meta:
		name = "TWriter.WriteIdent"
		size = 156
		refs = "0007 TWriter.WriteIdent 000e CompareText 001b TWriter.WriteValue 0066 TWriter.WriteStr"
	strings:
		$1 = { 53 56 8B F2 8B D8 BA ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 85 C0 75 0C B2 08 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 BA ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 85 C0 75 0B B2 09 8B C3 E8 ?? ?? ?? ?? EB 2D BA ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 85 C0 75 0B B2 0D 8B C3 E8 ?? ?? ?? ?? EB 12 B2 07 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 00 00 00 FF FF FF FF 05 00 00 00 46 61 6C 73 65 00 00 00 FF FF FF FF 04 00 00 00 54 72 75 65 00 00 00 00 FF FF FF FF 03 00 00 00 6E 69 6C 00 }
	condition:
		$1
}

rule function_2042_0 {
	meta:
		name = "TWriter.WriteInteger"
		size = 114
		refs = "0018 TWriter.WriteValue 0026 TWriter.Write"
	strings:
		$1 = { 53 51 89 14 24 8B D8 83 3C 24 80 7C 20 83 3C 24 7F 7F 1A B2 02 8B C3 E8 ?? ?? ?? ?? 8B D4 B9 01 00 00 00 8B C3 E8 ?? ?? ?? ?? 5A 5B C3 81 3C 24 00 80 FF FF 7C 22 81 3C 24 FF 7F 00 00 7F 19 B2 03 8B C3 E8 ?? ?? ?? ?? 8B D4 B9 02 00 00 00 8B C3 E8 ?? ?? ?? ?? EB 17 B2 04 8B C3 E8 ?? ?? ?? ?? 8B D4 B9 04 00 00 00 8B C3 E8 ?? ?? ?? ?? 5A 5B C3 }
	condition:
		$1
}

rule function_2045_0 {
	meta:
		name = "TWriter.WritePrefix"
		size = 68
		refs = "000b TWriter.WritePrefix 0029 TWriter.Write 0038 TWriter.WriteInteger"
	strings:
		$1 = { 53 56 51 8B F1 88 14 24 8B D8 A0 ?? ?? ?? ?? 3A 04 24 74 28 8A 04 24 0C F0 88 44 24 01 8D 54 24 01 B9 01 00 00 00 8B C3 E8 ?? ?? ?? ?? F6 04 24 02 74 09 8B D6 8B C3 E8 ?? ?? ?? ?? 5A 5E 5B C3 00 00 00 00 }
	condition:
		$1
}

rule function_2046_0 {
	meta:
		name = "TWriter.WriteProperties"
		size = 198
		refs = "0015 TObject.ClassInfo 001a GetTypeData 0036 @GetMem 0041 TWriter.WriteProperties 0059 GetPropInfos 0078 IsStoredProp 0089 TWriter.WriteProperty 00a8 @FreeMem 00ae @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 89 55 F8 89 45 FC 8B 45 F8 8B 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F BF 40 08 89 45 F4 83 7D F4 00 0F 8E 85 00 00 00 8B 45 F4 C1 E0 02 E8 ?? ?? ?? ?? 89 45 F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 8B 00 E8 ?? ?? ?? ?? 8B 55 F0 E8 ?? ?? ?? ?? 8B 75 F4 4E 85 F6 7C 2C 46 33 FF 8B 45 F0 8B 1C B8 85 DB 74 1F 8B D3 8B 45 F8 E8 ?? ?? ?? ?? 84 C0 74 0D 8B CB 8B 55 F8 8B 45 FC E8 ?? ?? ?? ?? 47 4E 75 D7 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 55 F4 C1 E2 02 8B 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EA 8B 55 FC 8B 45 F8 8B 08 FF 51 04 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2047_0 {
	meta:
		name = "AncestorValid"
		size = 74
		refs = "0017 TObject.ClassType"
	strings:
		$1 = { 55 8B EC 53 8B 45 08 8B 40 FC 83 78 1C 00 74 30 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 8B D8 8B 45 08 8B 40 FC 8B 40 1C E8 ?? ?? ?? ?? 3B D8 74 16 8B 45 08 8B 40 F8 8B 55 08 8B 52 FC 3B 42 18 74 05 33 C0 5B 5D C3 B0 01 5B 5D C3 }
	condition:
		$1
}

rule function_2048_0 {
	meta:
		name = "WritePropPath"
		size = 82
		refs = "0009 WritePropPath 0020 @LStrFromString 002e TWriter.WritePropName 0043 @LStrClr 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 8B 55 08 8B 52 F4 83 C2 1A E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_2049_0 {
	meta:
		name = "WriteSet"
		size = 147
		refs = "000e WriteSet 001f GetTypeData 0031 TWriter.WriteValue 004b GetEnumName 0059 TWriter.WriteStr 0081 @LStrClr 0087 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 F0 E8 ?? ?? ?? ?? 8B 40 01 8B 38 8B 45 08 8B 40 FC B2 0B E8 ?? ?? ?? ?? 33 DB 8B C3 83 F8 1F 77 03 0F A3 C6 73 1A 8D 4D FC 8B D3 8B C7 E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 43 83 FB 20 75 D4 8B 45 08 8B 40 FC 33 D2 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2050_0 {
	meta:
		name = "WriteIntProp"
		size = 214
		refs = "0018 WriteIntProp 0023 IntConstList 0028 TThreadList.LockList 0051 TList.Get 0076 TWriter.WriteIdent 007b @TryFinallyExit 0098 TThreadList.UnlockList 009e @HandleFinally 00ae TWriter.WriteInteger 00c3 @LStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 33 C9 89 4D F4 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F0 8B 70 08 4E 85 F6 7C 3D 46 33 FF 8B D7 8B 45 F0 E8 ?? ?? ?? ?? 8B D8 8B 43 04 3B 45 FC 75 22 8D 55 F4 8B 45 F8 FF 53 0C 84 C0 74 19 8B 45 08 8B 40 FC 8B 55 F4 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 31 47 4E 75 C6 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EE 8B 45 08 8B 40 FC 8B 55 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2051_0 {
	meta:
		name = "WriteCollectionProp"
		size = 161
		refs = "000c WriteCollectionProp 001b WritePropPath 002d @LStrLAsg 0049 @LStrClr 0056 TWriter.WriteCollection 0074 @LStrAsg 007a @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 50 E8 ?? ?? ?? ?? 59 8D 45 FC 8B 55 08 8B 52 FC 8B 52 28 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 FC 83 C0 28 E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC 8B D3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 08 8B 40 FC 83 C0 28 8B 55 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E7 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_2052_0 {
	meta:
		name = "IsDefaultValue"
		size = 80
		refs = "000b AncestorValid 002a GetOrdProp"
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 40 08 50 E8 ?? ?? ?? ?? 59 84 C0 74 25 8B 45 08 8B 40 08 8B 50 F4 8B 45 08 8B 40 08 8B 40 FC 8B 40 1C E8 ?? ?? ?? ?? 8B 55 08 3B 42 FC 0F 94 C0 5D C3 8B 45 08 8B 40 FC 8B 55 08 8B 52 08 8B 52 F4 3B 42 14 0F 94 C0 5D C3 }
	condition:
		$1
}

rule function_2053_0 {
	meta:
		name = "WriteOrdProp"
		size = 212
		refs = "000f WriteOrdProp 0026 GetOrdProp 002f IsDefaultValue 003d WritePropPath 006e WriteIntProp 007f TWriter.WriteChar 008d WriteSet 00a1 GetEnumName 00af TWriter.WriteIdent 00c4 @LStrClr 00ca @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 33 C0 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 50 F4 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 89 45 FC 55 E8 ?? ?? ?? ?? 59 84 C0 75 7B 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B 45 08 8B 40 F0 8A 00 FE C8 74 0E FE C8 74 23 FE C8 74 3E 2C 03 74 2B EB 57 8B 45 08 50 8B 45 08 8B 40 F4 8B 00 8B 00 8B 55 FC E8 ?? ?? ?? ?? 59 EB 3E 8B 55 FC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? EB 2E 8B 45 08 50 8B 45 FC E8 ?? ?? ?? ?? 59 EB 1F 8D 4D F8 8B 45 08 8B 40 F0 8B 55 FC E8 ?? ?? ?? ?? 8B 55 F8 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 59 5D C3 }
	condition:
		$1
}

rule function_2054_0 {
	meta:
		name = "IsDefaultValue"
		size = 88
		refs = "000b AncestorValid 002a GetFloatProp 0046 IsDefaultValue"
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 40 08 50 E8 ?? ?? ?? ?? 59 84 C0 74 2A 8B 45 08 8B 40 08 8B 50 F4 8B 45 08 8B 40 08 8B 40 FC 8B 40 1C E8 ?? ?? ?? ?? 8B 45 08 DB 68 F6 DE D9 DF E0 9E 0F 94 C0 5D C3 8B 45 08 DB 68 F6 D8 1D ?? ?? ?? ?? DF E0 9E 0F 94 C0 5D C3 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_2055_0 {
	meta:
		name = "WriteFloatProp"
		size = 74
		refs = "0013 GetFloatProp 001d IsDefaultValue 002b WritePropPath 0042 TWriter.WriteFloat"
	strings:
		$1 = { 55 8B EC 83 C4 F4 8B 45 08 8B 50 F4 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? DB 7D F6 9B 55 E8 ?? ?? ?? ?? 59 84 C0 75 20 8B 45 08 50 E8 ?? ?? ?? ?? 59 66 8B 45 FE 50 FF 75 FA FF 75 F6 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule function_2056_0 {
	meta:
		name = "IsDefault"
		size = 130
		refs = "000a IsDefault 001c AncestorValid 003e GetStrProp 004c @LStrCmp 0070 @LStrClr 0076 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 08 50 E8 ?? ?? ?? ?? 59 84 C0 74 30 8D 4D FC 8B 45 08 8B 40 08 8B 50 F4 8B 45 08 8B 40 08 8B 40 FC 8B 40 1C E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 0F 94 C3 EB 0A 8B 45 08 83 78 FC 00 0F 94 C3 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 }
	condition:
		$1
}

rule function_2057_0 {
	meta:
		name = "WriteStrProp"
		size = 106
		refs = "0009 WriteStrProp 0023 GetStrProp 0029 IsDefault 0037 WritePropPath 0046 TWriter.WriteString 005b @LStrClr 0061 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 4D FC 8B 45 08 8B 50 F4 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 84 C0 75 18 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B 45 08 8B 40 FC 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_2058_0 {
	meta:
		name = "IsDefault"
		size = 143
		refs = "000e AncestorValid 002d GetOrdProp 0075 CompareText"
	strings:
		$1 = { 55 8B EC 53 33 DB 8B 45 08 8B 40 08 50 E8 ?? ?? ?? ?? 59 84 C0 74 6C 8B 45 08 8B 40 08 8B 50 F4 8B 45 08 8B 40 08 8B 40 FC 8B 40 1C E8 ?? ?? ?? ?? 8B D8 85 DB 74 4C 8B 43 04 8B 55 08 8B 52 08 8B 52 FC 3B 42 24 75 3B 8B 45 08 83 78 FC 00 74 32 8B 45 08 8B 40 FC 8B 40 04 8B 55 08 8B 52 08 8B 52 FC 3B 42 18 75 1B 8B 45 08 8B 40 FC 8B 50 08 8B 43 08 E8 ?? ?? ?? ?? 85 C0 75 06 8B 45 08 8B 58 FC 8B 45 08 3B 58 FC 0F 94 C0 5B 5D C3 }
	condition:
		$1
}

rule function_2059_0 {
	meta:
		name = "GetComponentValue"
		size = 160
		refs = "0023 @LStrLAsg 0036 GetComponentValue 0058 @LStrCatN 0069 @LStrCat3"
	strings:
		$1 = { 55 8B EC 53 56 57 8B F2 8B D8 8B 45 08 8B 40 08 8B 40 FC 8B 40 18 8B 7B 04 3B C7 75 0C 8B C6 8B 53 08 E8 ?? ?? ?? ?? EB 44 8B 55 08 8B 52 08 3B C3 75 0E 8B C6 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 2C 85 FF 74 19 FF 77 08 68 ?? ?? ?? ?? FF 73 08 8B C6 BA 03 00 00 00 E8 ?? ?? ?? ?? EB 0F 8B C6 B9 ?? ?? ?? ?? 8B 53 08 E8 ?? ?? ?? ?? 5F 5E 5B 5D C3 00 00 FF FF FF FF 05 00 00 00 4F 77 6E 65 72 00 00 00 FF FF FF FF 01 00 00 00 2E 00 00 00 FF FF FF FF 06 00 00 00 2E 4F 77 6E 65 72 00 00 }
	condition:
		$1
}

rule function_2060_0 {
	meta:
		name = "WriteObjectProp"
		size = 548
		refs = "000e WriteObjectProp 0025 GetOrdProp 0034 IsDefault 0042 WritePropPath 0050 TWriter.WriteValue 005e _DV_TPersistent 0063 @IsClass 0074 _DV_TComponent 0098 GetComponentValue 00a4 @LStrLAsg 00c6 TWriter.WriteIdent 00d4 _DV_TCollection 00e6 AncestorValid 0109 CollectionsEqual 011d WriteCollectionProp 0168 @LStrFromString 0183 @LStrCatN 01bc TWriter.WriteProperties 01e6 @LStrAsg 01ec @HandleFinally 0208 @LStrArrayClr"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 50 F4 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 27 55 E8 ?? ?? ?? ?? 59 84 C0 75 1C 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B 45 08 8B 40 FC B2 0D E8 ?? ?? ?? ?? E9 99 01 00 00 8B 45 FC 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 83 01 00 00 8B 45 FC 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 4E 55 E8 ?? ?? ?? ?? 59 84 C0 0F 85 62 01 00 00 55 8D 55 EC 8B 45 FC E8 ?? ?? ?? ?? 59 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 83 7D F0 00 0F 84 40 01 00 00 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B 45 08 8B 40 FC 8B 55 F0 E8 ?? ?? ?? ?? E9 23 01 00 00 8B 45 FC 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 46 8B 45 08 50 E8 ?? ?? ?? ?? 59 84 C0 74 26 8B 45 08 8B 50 F4 8B 45 08 8B 40 FC 8B 40 1C E8 ?? ?? ?? ?? 8B D0 8B 45 FC E8 ?? ?? ?? ?? 84 C0 0F 85 DD 00 00 00 8B 45 08 50 8B 45 FC E8 ?? ?? ?? ?? 59 E9 CB 00 00 00 8B 45 08 8B 40 FC 8B 40 1C 89 45 F8 8D 45 F4 8B 55 08 8B 52 FC 8B 52 28 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 FC FF 70 28 8D 45 EC 8B 55 08 8B 52 F4 83 C2 1A E8 ?? ?? ?? ?? FF 75 EC 68 ?? ?? ?? ?? 8B 45 08 8B 40 FC 83 C0 28 BA 03 00 00 00 E8 ?? ?? ?? ?? 8B 45 08 50 E8 ?? ?? ?? ?? 59 84 C0 74 1D 8B 45 08 8B 50 F4 8B 45 08 8B 40 FC 8B 40 1C E8 ?? ?? ?? ?? 8B 55 08 8B 52 FC 89 42 1C 8B 45 08 8B 40 FC 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 08 8B 40 FC 8B 55 F8 89 50 1C 8B 45 08 8B 40 FC 83 C0 28 8B 55 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC BA 03 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 8B E5 5D C3 FF FF FF FF 01 00 00 00 2E 00 00 00 }
	condition:
		$1
}

rule function_2061_0 {
	meta:
		name = "IsDefaultValue"
		size = 131
		refs = "0015 AncestorValid 0037 GetMethodProp 006a TObject.MethodName"
	strings:
		$1 = { 55 8B EC 81 C4 F8 FE FF FF 53 56 33 DB 8B 45 08 8B 40 08 50 E8 ?? ?? ?? ?? 59 84 C0 74 20 8D 4D F8 8B 45 08 8B 40 08 8B 50 F4 8B 45 08 8B 40 08 8B 40 FC 8B 40 1C E8 ?? ?? ?? ?? 8B 5D F8 8B 45 08 3B 58 F8 74 35 8B 45 08 8B 70 F8 85 F6 74 27 8D 8D F8 FE FF FF 8B 45 08 8B D6 8B 45 08 8B 40 08 8B 40 FC 8B 40 18 8B 00 E8 ?? ?? ?? ?? 80 BD F8 FE FF FF 00 74 04 33 C0 EB 02 B0 01 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2062_0 {
	meta:
		name = "WriteMethodProp"
		size = 178
		refs = "0013 WriteMethodProp 002d GetMethodProp 0033 IsDefaultValue 0041 WritePropPath 0056 TWriter.WriteValue 0070 TObject.MethodName 007e @LStrFromString 008c TWriter.WriteIdent 00a1 @LStrClr 00a7 @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 F4 FE FF FF 53 33 C0 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 4D F8 8B 45 08 8B 50 F4 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 84 C0 75 54 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B 5D F8 85 DB 75 0F 8B 45 08 8B 40 FC B2 0D E8 ?? ?? ?? ?? EB 34 8D 8D F4 FE FF FF 8B 45 08 8B 40 FC 8B 40 18 8B 00 8B D3 E8 ?? ?? ?? ?? 8D 95 F4 FE FF FF 8D 45 F4 E8 ?? ?? ?? ?? 8B 55 F4 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2063_0 {
	meta:
		name = "IsDefaultValue"
		size = 138
		refs = "000e IsDefaultValue 0020 AncestorValid 0042 GetVariantProp 0050 @VarCmp 0060 VarIsEmpty 0077 @VarClr 007d @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 08 50 E8 ?? ?? ?? ?? 59 84 C0 74 30 8D 4D F0 8B 45 08 8B 40 08 8B 50 F4 8B 45 08 8B 40 08 8B 40 FC 8B 40 1C E8 ?? ?? ?? ?? 8D 55 F0 8B 45 08 83 C0 F0 E8 ?? ?? ?? ?? 0F 94 C3 EB 0D 8B 45 08 83 C0 F0 E8 ?? ?? ?? ?? 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2064_0 {
	meta:
		name = "WriteVariantProp"
		size = 659
		refs = "0012 WriteVariantProp 002c GetVariantProp 0032 IsDefaultValue 0043 VarIsArray 004f SWriteError 0054 LoadResString 005e _DV_EWriteError 0063 Exception.Create 0068 @RaiseExcept 0071 WritePropPath 007a VarType 00ec TWriter.WriteValue 010e @VarToWStr 011c TWriter.WriteWideString 012c @VarToLStr 013a TWriter.WriteString 0147 @VarToInt 0154 TWriter.WriteInteger 0161 @VarToReal 0173 TWriter.WriteSingle 0192 TWriter.WriteFloat 019f @VarToCurr 01b1 TWriter.WriteCurrency 01d0 TWriter.WriteDate 01dd @VarToBool 0235 @HandleAnyException 025b @DoneExcept 0270 @WStrClr 0278 @LStrClr 0280 @VarClr 0286 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 51 53 56 57 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 4D F0 8B 45 08 8B 50 F4 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 84 C0 0F 85 20 02 00 00 8D 45 F0 E8 ?? ?? ?? ?? 84 C0 74 21 8D 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D EC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 08 50 E8 ?? ?? ?? ?? 59 8D 45 F0 E8 ?? ?? ?? ?? 25 FF 0F 00 00 83 F8 06 7F 2E 0F 84 0D 01 00 00 83 F8 05 0F 87 6C 01 00 00 FF 24 85 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 83 F8 0B 7F 17 0F 84 18 01 00 00 83 E8 07 0F 84 F0 00 00 00 48 74 3A E9 31 01 00 00 83 E8 11 74 6C 2D EF 00 00 00 74 47 E9 20 01 00 00 8B 45 08 8B 40 FC B2 0D E8 ?? ?? ?? ?? E9 6A 01 00 00 8B 45 08 8B 40 FC 33 D2 E8 ?? ?? ?? ?? E9 58 01 00 00 8D 45 E8 8D 55 F0 E8 ?? ?? ?? ?? 8B 55 E8 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? E9 3A 01 00 00 8D 45 EC 8D 55 F0 E8 ?? ?? ?? ?? 8B 55 EC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? E9 1C 01 00 00 8D 45 F0 E8 ?? ?? ?? ?? 8B D0 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? E9 02 01 00 00 8D 45 F0 E8 ?? ?? ?? ?? 83 C4 FC D9 1C 24 9B 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? E9 E3 00 00 00 8D 45 F0 E8 ?? ?? ?? ?? 83 C4 F4 DB 3C 24 9B 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? E9 C4 00 00 00 8D 45 F0 E8 ?? ?? ?? ?? 83 C4 F8 DF 3C 24 9B 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? E9 A5 00 00 00 8D 45 F0 E8 ?? ?? ?? ?? 83 C4 F8 DD 1C 24 9B 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? E9 86 00 00 00 8D 45 F0 E8 ?? ?? ?? ?? 84 C0 74 0F 8B 45 08 8B 40 FC B2 09 E8 ?? ?? ?? ?? EB 6B 8B 45 08 8B 40 FC B2 08 E8 ?? ?? ?? ?? EB 5C 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 EC 8D 55 F0 E8 ?? ?? ?? ?? 8B 55 EC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 2B E9 ?? ?? ?? ?? 8D 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D EC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2065_0 {
	meta:
		name = "TWriter.WriteProperty"
		size = 161
		refs = "0031 TWriter.WriteProperty 006b WriteOrdProp 0074 WriteFloatProp 007d WriteStrProp 0086 WriteObjectProp 008f WriteMethodProp 0098 WriteVariantProp"
	strings:
		$1 = { 55 8B EC 83 C4 F0 89 4D F4 89 55 F8 89 45 FC 8B 45 F4 83 78 08 00 0F 84 81 00 00 00 8B 00 8B 00 89 45 F0 8B 45 F0 0F B6 00 83 F8 0C 77 6F FF 24 85 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 EB 2B 55 E8 ?? ?? ?? ?? 59 EB 22 55 E8 ?? ?? ?? ?? 59 EB 19 55 E8 ?? ?? ?? ?? 59 EB 10 55 E8 ?? ?? ?? ?? 59 EB 07 55 E8 ?? ?? ?? ?? 59 8B E5 5D C3 }
	condition:
		$1
}

rule function_2066_0 {
	meta:
		name = "TWriter.WritePropName"
		size = 82
		refs = "000f TWriter.WritePropName 0022 @LStrCat3 002c TWriter.WriteStr 0041 @LStrClr 0047 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 8B CE 8B 53 28 E8 ?? ?? ?? ?? 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2068_0 {
	meta:
		name = "TWriter.WriteSignature"
		size = 16
		refs = "0001 FilerSignature 000b TWriter.Write"
	strings:
		$1 = { BA ?? ?? ?? ?? B9 04 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2069_0 {
	meta:
		name = "TWriter.WriteStr"
		size = 70
		refs = "000a @LStrLen 002b TWriter.Write 0032 @LStrToPChar"
	strings:
		$1 = { 53 56 51 8B F2 8B D8 8B C6 E8 ?? ?? ?? ?? 89 04 24 81 3C 24 FF 00 00 00 7E 07 C7 04 24 FF 00 00 00 8B D4 B9 01 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B D0 8B 0C 24 8B C3 E8 ?? ?? ?? ?? 5A 5E 5B C3 }
	condition:
		$1
}

rule function_2070_0 {
	meta:
		name = "TWriter.WriteString"
		size = 90
		refs = "000a @LStrLen 001f TWriter.WriteValue 002d TWriter.Write"
	strings:
		$1 = { 53 56 51 8B F2 8B D8 8B C6 E8 ?? ?? ?? ?? 89 04 24 81 3C 24 FF 00 00 00 7F 19 B2 06 8B C3 E8 ?? ?? ?? ?? 8B D4 B9 01 00 00 00 8B C3 E8 ?? ?? ?? ?? EB 17 B2 0C 8B C3 E8 ?? ?? ?? ?? 8B D4 B9 04 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B D6 8B 0C 24 8B C3 E8 ?? ?? ?? ?? 5A 5E 5B C3 }
	condition:
		$1
}

rule function_2071_0 {
	meta:
		name = "TWriter.WriteWideString"
		size = 58
		refs = "000c TWriter.WriteValue 0013 @WStrLen 0024 TWriter.Write"
	strings:
		$1 = { 53 56 51 8B F2 8B D8 B2 12 8B C3 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 89 04 24 8B D4 B9 04 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B 0C 24 03 C9 8B D6 8B C3 E8 ?? ?? ?? ?? 5A 5E 5B C3 }
	condition:
		$1
}

rule function_2072_0 {
	meta:
		name = "TWriter.WriteValue"
		size = 18
		refs = "000c TWriter.Write"
	strings:
		$1 = { 51 88 14 24 8B D4 B9 01 00 00 00 E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule function_2073_0 {
	meta:
		name = "BinToHex"
		size = 60
		refs = "0025 BinToHex"
	strings:
		$1 = { 56 57 89 C6 89 D7 BA 00 00 00 00 EB 10 30 31 32 33 34 35 36 37 38 39 41 42 43 44 45 46 AC 88 C2 80 E2 0F 8A A2 ?? ?? ?? ?? 88 C2 C0 EA 04 8A 82 ?? ?? ?? ?? 66 AB 49 75 E4 5F 5E C3 }
	condition:
		$1
}

rule function_2074_0 {
	meta:
		name = "HexToBin"
		size = 136
		refs = "0057 HexToBin"
	strings:
		$1 = { 56 57 53 89 C6 89 D7 89 D3 BA 00 00 00 00 EB 37 00 01 02 03 04 05 06 07 08 09 FF FF FF FF FF FF FF 0A 0B 0C 0D 0E 0F FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF 0A 0B 0C 0D 0E 0F 66 AD 80 F8 30 72 32 80 F8 66 77 2D 88 C2 8A 82 ?? ?? ?? ?? 80 F8 FF 74 20 C0 E0 04 80 FC 30 72 18 80 FC 66 77 13 88 E2 8A A2 ?? ?? ?? ?? 80 FC FF 74 06 08 E0 AA 49 75 C7 89 F8 29 D8 5B 5F 5E C3 }
	condition:
		$1
}

rule function_2075_0 {
	meta:
		name = "TParser.Create"
		size = 113
		refs = "000b @ClassCreate 001c @GetMem 0052 TParser.NextToken 005d @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F8 89 4F 04 B8 00 10 00 00 E8 ?? ?? ?? ?? 8B F0 89 77 0C C6 06 00 89 77 10 8B 47 0C 05 00 10 00 00 89 47 14 8B 47 0C 89 47 18 8B 47 0C 89 47 1C 8B 47 0C 89 47 20 C7 47 28 01 00 00 00 8B C7 E8 ?? ?? ?? ?? 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2076_0 {
	meta:
		name = "TParser.Destroy"
		size = 59
		refs = "0004 @BeforeDestruction 0028 @FreeMem 0033 @ClassDestroy"
	strings:
		$1 = { 53 56 57 E8 ?? ?? ?? ?? 8B DA 8B F0 83 7E 0C 00 74 1A 8B 56 20 2B 56 10 66 B9 01 00 8B 46 04 8B 38 FF 57 0C 8B 46 0C E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2077_0 {
	meta:
		name = "TParser.CheckToken"
		size = 204
		refs = "0015 TParser.CheckToken 003f SIdentifierExpected 0044 LoadResString 004e TParser.Error 0058 SStringExpected 0071 SNumberExpected 008c SCharExpected 00a5 TParser.ErrorFmt 00ba @LStrClr 00c0 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 33 C9 89 4D FC 8B DA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 3A 5E 2D 0F 84 81 00 00 00 8B C3 FE C8 74 0D FE C8 74 22 48 2C 02 72 36 74 1B EB 4B 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C6 E8 ?? ?? ?? ?? EB 55 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C6 E8 ?? ?? ?? ?? EB 3C 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C6 E8 ?? ?? ?? ?? EB 23 6A 00 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 88 5D F4 C6 45 F8 02 8D 4D F4 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2078_0 {
	meta:
		name = "TParser.CheckTokenSymbol"
		size = 116
		refs = "0015 TParser.CheckTokenSymbol 0024 TParser.TokenSymbolIs 0032 SSymbolExpected 0037 LoadResString 004d TParser.ErrorFmt 0062 @LStrClr 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 33 C9 89 4D FC 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D6 8B C3 E8 ?? ?? ?? ?? 84 C0 75 25 6A 00 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 50 89 75 F4 C6 45 F8 0B 8D 4D F4 8B C3 5A E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_4600_0 {
	meta:
		name = "TCopyParser.CheckTokenSymbol"
		size = 116
		refs = "0015 TCopyParser.CheckTokenSymbol 0024 TCopyParser.TokenSymbolIs 0032 SSymbolExpected 0037 LoadResString 004d TCopyParser.ErrorFmt 0062 @LStrClr 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 33 C9 89 4D FC 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D6 8B C3 E8 ?? ?? ?? ?? 84 C0 75 25 6A 00 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 50 89 75 F4 C6 45 F8 0B 8D 4D F4 8B C3 5A E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2080_0 {
	meta:
		name = "TParser.ErrorFmt"
		size = 91
		refs = "0012 TParser.ErrorFmt 0028 Format 0032 TParser.ErrorStr 0047 @LStrClr 004d @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8B D7 8B 4D 08 8B C6 E8 ?? ?? ?? ?? 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_4611_0 {
	meta:
		name = "TCopyParser.ErrorFmt"
		size = 91
		refs = "0012 TCopyParser.ErrorFmt 0028 Format 0032 TCopyParser.ErrorStr 0047 @LStrClr 004d @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8B D7 8B 4D 08 8B C6 E8 ?? ?? ?? ?? 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_2081_0 {
	meta:
		name = "TParser.ErrorStr"
		size = 122
		refs = "0015 TParser.ErrorStr 003a SParseError 003f LoadResString 0049 _DV_EParserError 004e Exception.CreateFmt 0053 @RaiseExcept 0068 @LStrClr 006e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 33 C9 89 4D EC 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 89 75 F0 C6 45 F4 0B 8B 43 28 89 45 F8 C6 45 FC 00 8D 45 F0 50 6A 01 8D 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D EC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2082_0 {
	meta:
		name = "TParser.HexToBinary"
		size = 183
		refs = "001d TParser.HexToBinary 002a TParser.SkipBlanks 003c HexToBin 004d SInvalidBinary 0052 LoadResString 005f TParser.Error 008c TParser.NextToken 00a4 @LStrClr 00aa @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 F8 FE FF FF 53 56 57 33 C9 89 8D F8 FE FF FF 89 55 FC 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? EB 51 8D 95 FC FE FF FF B9 00 01 00 00 E8 ?? ?? ?? ?? 8B F0 85 F6 75 1D 8D 95 F8 FE FF FF A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 95 F8 FE FF FF 8B C3 E8 ?? ?? ?? ?? 8D 95 FC FE FF FF 8B CE 8B 45 FC 8B 38 FF 57 08 8B C6 03 C0 01 43 18 8B C3 E8 ?? ?? ?? ?? 8B 43 18 80 38 7D 75 A7 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 F8 FE FF FF E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2083_0 {
	meta:
		name = "TParser.NextToken"
		size = 674
		refs = "0014 TParser.NextToken 0021 TParser.SkipBlanks 00f7 SInvalidString 00fc LoadResString 0106 TParser.Error 0125 @WStrSetLength 028c @LStrClr 0292 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 33 D2 89 55 F4 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 8B 5E 18 89 5E 20 33 C0 8A 03 83 F8 30 7D 1F 83 E8 23 74 64 48 0F 84 AA 01 00 00 83 E8 03 74 58 83 E8 06 0F 84 BA 01 00 00 E9 13 02 00 00 83 C0 D0 83 E8 0A 0F 82 A9 01 00 00 83 C0 F9 83 E8 1A 72 11 83 E8 04 74 0C 83 C0 FE 83 E8 1A 0F 83 EE 01 00 00 43 EB 01 43 8A 03 04 D0 2C 0A 72 F7 04 F9 2C 1A 72 F1 2C 04 74 ED 04 FE 2C 1A 72 E7 C6 45 FF 01 E9 D5 01 00 00 C6 45 FE 00 33 FF 89 5D F8 8A 03 2C 23 74 06 2C 04 74 2E EB 64 43 33 C0 EB 0F 03 C0 8D 04 80 33 D2 8A 13 83 EA 30 03 C2 43 8A 13 80 C2 D0 80 EA 0A 72 E7 3D FF 00 00 00 7E 04 C6 45 FE 01 47 EB C8 43 8A 03 2C 01 72 0E 2C 09 74 0A 2C 03 74 06 2C 1A 74 1B EB 1F 8D 55 F4 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F4 8B C6 E8 ?? ?? ?? ?? EB 06 43 80 3B 27 75 94 47 43 EB C9 8B 5D F8 80 7D FE 00 74 0A 8D 46 30 8B D7 E8 ?? ?? ?? ?? BF 01 00 00 00 8A 03 2C 23 74 09 2C 04 74 3E E9 8F 00 00 00 43 33 C0 EB 0F 03 C0 8D 04 80 33 D2 8A 13 83 EA 30 03 C2 43 8A 13 80 C2 D0 80 EA 0A 72 E7 80 7D FE 00 74 0B 8B 56 30 66 89 44 7A FE 47 EB C2 8B 55 F8 88 02 FF 45 F8 EB B8 43 8A 03 2C 01 72 0E 2C 09 74 0A 2C 03 74 06 2C 1A 74 1B EB 1F 8D 55 F4 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F4 8B C6 E8 ?? ?? ?? ?? EB 06 43 80 3B 27 75 84 80 7D FE 00 74 0F 8B 46 30 33 D2 8A 13 66 89 54 78 FE 47 EB 0A 8B 45 F8 8A 13 88 10 FF 45 F8 43 EB AB 8B 45 F8 89 46 24 80 7D FE 00 74 09 C6 45 FF 05 E9 91 00 00 00 C6 45 FF 02 E9 88 00 00 00 43 EB 01 43 8A 03 04 D0 2C 0A 72 F7 04 F9 2C 06 72 F1 04 E6 2C 06 72 EB C6 45 FF 03 EB 6A 43 EB 01 43 8A 03 04 D0 2C 0A 72 F7 C6 45 FF 03 EB 05 43 C6 45 FF 04 8A 03 2C 2B 74 F5 04 FE 2C 02 72 EF 48 2C 0A 72 EA 2C 0B 74 E6 2C 20 74 E2 8A 03 8B D0 80 C2 BD 80 EA 02 72 12 80 EA 0E 74 0D 80 C2 F0 80 EA 02 72 05 80 EA 0E 75 0A C6 45 FF 04 88 46 2E 43 EB 12 C6 46 2E 00 EB 0C 8A 03 88 45 FF 80 7D FF 00 74 01 43 89 5E 18 8A 45 FF 88 46 2D 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8A 45 FF 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2084_0 {
	meta:
		name = "TParser.ReadBuffer"
		size = 199
		refs = "000e TParser.ReadBuffer 003b Move 0071 LineStart 0083 SLineTooLong 0088 LoadResString 0092 TParser.Error 00b5 @LStrClr 00bb @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 43 18 2B 43 0C 01 43 08 8B 43 1C 8A 53 2C 88 10 8B 73 10 8B 43 18 2B F0 85 F6 74 0A 8B 53 0C 8B CE E8 ?? ?? ?? ?? 03 73 0C 89 73 10 8B 4B 14 2B 4B 10 8B 53 10 8B 43 04 8B 30 FF 56 04 01 43 10 8B 43 0C 89 43 18 8B 73 10 89 73 1C 3B 73 14 75 2C 8B D6 4A 8B 43 0C E8 ?? ?? ?? ?? 8B F8 89 7B 1C 3B 7B 0C 75 17 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 43 1C 8A 00 88 43 2C 8B 43 1C C6 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2085_0 {
	meta:
		name = "TParser.SkipBlanks"
		size = 51
		refs = "001b TParser.ReadBuffer"
	strings:
		$1 = { 53 8B D8 8B 43 18 8A 00 2C 01 72 0C 2C 09 74 19 04 E9 2C DF 72 1B EB 14 8B C3 E8 ?? ?? ?? ?? 8B 43 18 80 38 00 74 0A EB DA FF 43 28 FF 43 18 EB D2 5B C3 }
	condition:
		$1
}

rule function_2086_0 {
	meta:
		name = "TParser.SourcePos"
		size = 12
	strings:
		$1 = { 8B 50 20 2B 50 0C 03 50 08 8B C2 C3 }
	condition:
		$1
}

rule function_2087_0 {
	meta:
		name = "TParser.TokenFloat"
		size = 105
		refs = "0012 TParser.TokenFloat 002b TParser.TokenString 0033 StrToFloat 0055 @LStrClr 005b @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 33 D2 89 55 F0 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 80 7B 2E 00 74 03 FF 4B 18 8D 55 F0 8B C3 E8 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? DB 7D F6 9B 80 7B 2E 00 74 03 FF 43 18 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 DB 6D F6 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2088_0 {
	meta:
		name = "TParser.TokenInt"
		size = 77
		refs = "000c TParser.TokenInt 001c TParser.TokenString 0024 StrToInt 003b @LStrClr 0041 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 }
	condition:
		$1
}

rule function_4625_0 {
	meta:
		name = "TCopyParser.TokenInt"
		size = 77
		refs = "000c TCopyParser.TokenInt 001c TCopyParser.TokenString 0024 StrToInt 003b @LStrClr 0041 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 }
	condition:
		$1
}

rule function_11888_0 {
	meta:
		name = "TCustomMaskEdit.GetTextLen"
		size = 77
		refs = "000c TCustomMaskEdit.GetTextLen 001c TCustomMaskEdit.GetText 0024 @LStrLen 003b @LStrClr 0041 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 }
	condition:
		$1
}

rule function_2089_0 {
	meta:
		name = "TParser.TokenString"
		size = 30
		refs = "0019 @LStrFromPCharLen"
	strings:
		$1 = { 80 78 2D 02 75 08 8B 48 24 2B 48 20 EB 06 8B 48 18 2B 48 20 8B 40 20 92 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2090_0 {
	meta:
		name = "TParser.TokenWideString"
		size = 19
		refs = "000c @WStrAsg"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 53 30 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2091_0 {
	meta:
		name = "TParser.TokenSymbolIs"
		size = 99
		refs = "000f TParser.TokenSymbolIs 0025 TParser.TokenString 002f CompareText 0050 @LStrClr 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 80 7B 2D 01 75 18 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 85 C0 74 04 33 C0 EB 02 B0 01 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2092_0 {
	meta:
		name = "TParser.TokenComponentIdent"
		size = 159
		refs = "0010 TParser.TokenComponentIdent 001f TParser.CheckToken 003f SIdentifierExpected 0044 LoadResString 004e TParser.Error 0078 TParser.TokenString 008d @LStrClr 0093 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B FA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B2 01 8B C6 E8 ?? ?? ?? ?? 8B 5E 18 EB 43 43 8A 03 04 BF 2C 1A 72 21 2C 04 74 1D 04 FE 2C 1A 72 17 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 43 8A 03 04 D0 2C 0A 72 F7 04 F9 2C 1A 72 F1 2C 04 74 ED 04 FE 2C 1A 72 E7 80 3B 2E 74 B8 89 5E 18 8B D7 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2093_0 {
	meta:
		name = "WriteIndent"
		size = 41
		refs = "000f Blanks 001f TWriter.Write"
	strings:
		$1 = { 55 8B EC 53 8B 45 08 8B 58 FC 85 DB 7E 18 BA ?? ?? ?? ?? 8B 45 08 8B 40 F8 B9 02 00 00 00 E8 ?? ?? ?? ?? 4B 75 E8 5B 5D C3 }
	condition:
		$1
}

rule function_2094_0 {
	meta:
		name = "WriteStr"
		size = 38
		refs = "0009 @LStrLen 0011 @LStrToPChar 001f TWriter.Write"
	strings:
		$1 = { 55 8B EC 53 8B D8 8B C3 E8 ?? ?? ?? ?? 50 8B C3 E8 ?? ?? ?? ?? 8B D0 8B 45 08 8B 40 F8 59 E8 ?? ?? ?? ?? 5B 5D C3 }
	condition:
		$1
}

rule function_2095_0 {
	meta:
		name = "NewLine"
		size = 44
		refs = "0008 NewLine 000d WriteStr 0017 WriteIndent"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 45 08 50 E8 ?? ?? ?? ?? 59 5D C3 00 00 FF FF FF FF 02 00 00 00 0D 0A 00 00 }
	condition:
		$1
}

rule function_2096_0 {
	meta:
		name = "ConvertHeader"
		size = 372
		refs = "000f ConvertHeader 0034 TReader.ReadStr 004b WriteIndent 0060 WriteStr 00c5 IntToStr 0101 @LStrClr 010e @LStrArrayClr 0114 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 4D F0 8D 55 F7 8B 45 08 8B 40 F4 8B 18 FF 53 20 8D 55 FC 8B 45 08 8B 40 F4 E8 ?? ?? ?? ?? 8D 55 F8 8B 45 08 8B 40 F4 E8 ?? ?? ?? ?? 8B 45 08 50 E8 ?? ?? ?? ?? 59 F6 45 F7 01 74 11 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 EB 0F 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 83 7D F8 00 74 1C 8B 45 08 50 8B 45 F8 E8 ?? ?? ?? ?? 59 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 45 08 50 8B 45 FC E8 ?? ?? ?? ?? 59 F6 45 F7 02 74 36 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 45 08 50 8D 55 EC 8B 45 F0 E8 ?? ?? ?? ?? 8B 45 EC E8 ?? ?? ?? ?? 59 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E3 5B 8B E5 5D C3 00 FF FF FF FF 0A 00 00 00 69 6E 68 65 72 69 74 65 64 20 00 00 FF FF FF FF 07 00 00 00 6F 62 6A 65 63 74 20 00 FF FF FF FF 02 00 00 00 3A 20 00 00 FF FF FF FF 02 00 00 00 20 5B 00 00 FF FF FF FF 01 00 00 00 5D 00 00 00 FF FF FF FF 02 00 00 00 0D 0A 00 00 }
	condition:
		$1
}

rule function_2097_0 {
	meta:
		name = "ConvertBinary"
		size = 208
		refs = "0013 TReader.ReadValue 001c ConvertBinary 0021 WriteStr 003a TReader.Read 0052 NewLine 007e BinToHex 0090 TWriter.Write"
	strings:
		$1 = { 55 8B EC 83 C4 9C 53 56 57 8D 7D FC 8B 45 08 8B 40 F4 E8 ?? ?? ?? ?? 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 45 08 FF 40 FC 8B D7 8B 45 08 8B 40 F4 B9 04 00 00 00 E8 ?? ?? ?? ?? 83 3F 20 0F 9D C3 83 3F 00 7E 52 84 DB 74 0A 8B 45 08 50 E8 ?? ?? ?? ?? 59 83 3F 20 7C 07 BE 20 00 00 00 EB 02 8B 37 8D 55 DC 8B 45 08 8B 40 F4 8B CE E8 ?? ?? ?? ?? 8D 55 9C 8D 45 DC 8B CE E8 ?? ?? ?? ?? 8B CE 03 C9 8D 55 9C 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 29 37 83 3F 00 7F AE 8B 45 08 FF 48 FC 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 5F 5E 5B 8B E5 5D C3 00 FF FF FF FF 01 00 00 00 7B 00 00 00 FF FF FF FF 01 00 00 00 7D 00 00 00 }
	condition:
		$1
}

rule function_2098_0 {
	meta:
		name = "ConvertValue"
		size = 2012
		refs = "0011 ConvertValue 0022 TReader.NextValue 008c TReader.ReadValue 009a WriteStr 00ac NewLine 00c2 TReader.EndOfList 00d1 TReader.ReadListEnd 00fa TReader.ReadInteger 0102 IntToStr 011f TReader.ReadFloat 012e FloatToStr 014b TReader.ReadSingle 0167 @LStrCat 0184 TReader.ReadCurrency 01c9 TReader.ReadDate 0201 TReader.ReadWideString 0209 @WStrLen 02cc @LStrFromWStr 02d6 ByteType 0301 @LStrFromChar 03a2 @HandleFinally 03b2 TReader.ReadString 03ba @LStrLen 0472 UniqueString 0485 TWriter.Write 052c TReader.ReadIdent 0543 ConvertBinary 0573 TReader.ReadStr 0643 TReader.CheckValue 0654 ConvertProperty 067e WriteIndent 06d6 @LStrClr 06de @WStrClr"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 56 57 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 F4 E8 ?? ?? ?? ?? 83 E0 7F 83 F8 12 0F 87 93 06 00 00 FF 24 85 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8B 45 08 8B 40 F4 E8 ?? ?? ?? ?? 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 45 08 FF 40 FC EB 14 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B 45 08 8B 40 F4 E8 ?? ?? ?? ?? 84 C0 74 DD 8B 45 08 8B 40 F4 E8 ?? ?? ?? ?? 8B 45 08 FF 48 FC 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 E9 D6 05 00 00 8B 45 08 50 8B 45 08 8B 40 F4 E8 ?? ?? ?? ?? 8D 55 EC E8 ?? ?? ?? ?? 8B 45 EC E8 ?? ?? ?? ?? 59 E9 B1 05 00 00 8B 45 08 50 8B 45 08 8B 40 F4 E8 ?? ?? ?? ?? 83 C4 F4 DB 3C 24 9B 8D 45 EC E8 ?? ?? ?? ?? 8B 45 EC E8 ?? ?? ?? ?? 59 E9 85 05 00 00 8B 45 08 50 8B 45 08 8B 40 F4 E8 ?? ?? ?? ?? 83 C4 F4 DB 3C 24 9B 8D 45 EC E8 ?? ?? ?? ?? 8D 45 EC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 EC E8 ?? ?? ?? ?? 59 E9 4C 05 00 00 8B 45 08 50 8B 45 08 8B 40 F4 E8 ?? ?? ?? ?? D8 0D ?? ?? ?? ?? D8 35 ?? ?? ?? ?? 83 C4 F4 DB 3C 24 9B 8D 45 EC E8 ?? ?? ?? ?? 8D 45 EC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 EC E8 ?? ?? ?? ?? 59 E9 07 05 00 00 8B 45 08 50 8B 45 08 8B 40 F4 E8 ?? ?? ?? ?? 83 C4 F4 DB 3C 24 9B 8D 45 EC E8 ?? ?? ?? ?? 8D 45 EC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 EC E8 ?? ?? ?? ?? 59 E9 CE 04 00 00 8D 55 F4 8B 45 08 8B 40 F4 E8 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? 8B F0 85 F6 75 14 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 E9 9E 04 00 00 BB 01 00 00 00 8B 45 08 FF 40 FC 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 83 FE 40 7E 0A 8B 45 08 50 E8 ?? ?? ?? ?? 59 89 5D FC C6 45 F3 00 8B 45 F4 66 8B 44 58 FE 66 83 F8 20 0F 82 BC 00 00 00 8B 55 F4 66 83 F8 27 0F 84 AF 00 00 00 8B 55 F4 66 3D FF 00 0F 87 A2 00 00 00 8B FB 43 3B F3 7C 2E 8B 45 F4 66 83 7C 58 FE 20 72 23 8B 45 F4 66 83 7C 58 FE 27 74 18 8B C3 2B 45 FC 83 F8 40 7D 0E 8B 45 F4 66 8B 44 58 FE 66 3D FF 00 76 CD 8B C3 2B 45 FC 83 F8 40 7C 1E C6 45 F3 01 8D 45 EC 8B 55 F4 E8 ?? ?? ?? ?? 8B 45 EC 8B D3 E8 ?? ?? ?? ?? 3C 02 75 01 4B 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 3B DF 7E 21 8B 45 08 50 8D 45 EC 8B 55 F4 8A 54 7A FE E8 ?? ?? ?? ?? 8B 45 EC E8 ?? ?? ?? ?? 59 47 3B DF 7F DF 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 EB 3B 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 45 08 50 8B 45 F4 0F B7 44 58 FE 8D 55 EC E8 ?? ?? ?? ?? 8B 45 EC E8 ?? ?? ?? ?? 59 43 8B C3 2B 45 FC 83 F8 40 7C 04 C6 45 F3 01 80 7D F3 00 74 20 3B F3 7C 1C 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 45 08 50 E8 ?? ?? ?? ?? 59 89 5D FC 3B F3 0F 8D C5 FE FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 08 FF 48 FC C3 E9 ?? ?? ?? ?? EB F2 8D 55 F8 8B 45 08 8B 40 F4 E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 8B F0 85 F6 75 14 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 E9 ED 02 00 00 BB 01 00 00 00 8B 45 08 FF 40 FC 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 83 FE 40 7E 0A 8B 45 08 50 E8 ?? ?? ?? ?? 59 89 5D FC C6 45 F3 00 8B 45 F8 8A 44 18 FF 3C 20 0F 82 84 00 00 00 8B 55 F8 3C 27 74 7D 8B FB 43 3B F3 7C 1E 8B 45 F8 80 7C 18 FF 20 72 14 8B 45 F8 80 7C 18 FF 27 74 0A 8B C3 2B 45 FC 83 F8 40 7C DD 8B C3 2B 45 FC 83 F8 40 7C 13 C6 45 F3 01 8B D3 8B 45 F8 E8 ?? ?? ?? ?? 3C 02 75 01 4B 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8D 45 F8 E8 ?? ?? ?? ?? 8D 54 38 FF 8B CB 2B CF 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 EB 3B 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 45 08 50 8B 45 F8 0F B6 44 18 FF 8D 55 EC E8 ?? ?? ?? ?? 8B 45 EC E8 ?? ?? ?? ?? 59 43 8B C3 2B 45 FC 83 F8 40 7C 04 C6 45 F3 01 80 7D F3 00 74 20 3B F3 7C 1C 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 45 08 50 E8 ?? ?? ?? ?? 59 89 5D FC 3B F3 0F 8D 00 FF FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 08 FF 48 FC C3 E9 ?? ?? ?? ?? EB F2 8B 45 08 50 8D 55 EC 8B 45 08 8B 40 F4 E8 ?? ?? ?? ?? 8B 45 EC E8 ?? ?? ?? ?? 59 E9 87 01 00 00 8B 45 08 50 E8 ?? ?? ?? ?? 59 E9 78 01 00 00 8B 45 08 8B 40 F4 E8 ?? ?? ?? ?? 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 33 DB 8D 55 F8 8B 45 08 8B 40 F4 E8 ?? ?? ?? ?? 83 7D F8 00 74 23 85 DB 7E 0F 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 45 08 50 8B 45 F8 E8 ?? ?? ?? ?? 59 43 EB C9 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 E9 11 01 00 00 8B 45 08 8B 40 F4 E8 ?? ?? ?? ?? 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 45 08 FF 40 FC E9 B9 00 00 00 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 45 08 8B 40 F4 E8 ?? ?? ?? ?? 04 FE 2C 03 73 28 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 45 08 8B 40 F4 B2 01 E8 ?? ?? ?? ?? 8B 45 08 FF 40 FC EB 0A 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B 45 08 8B 40 F4 E8 ?? ?? ?? ?? 84 C0 74 E7 8B 45 08 8B 40 F4 E8 ?? ?? ?? ?? 8B 45 08 FF 48 FC 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 45 08 8B 40 F4 E8 ?? ?? ?? ?? 84 C0 0F 84 34 FF FF FF 8B 45 08 8B 40 F4 E8 ?? ?? ?? ?? 8B 45 08 FF 48 FC 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5F 5E 5B 8B E5 5D C3 00 00 00 FF FF FF FF 01 00 00 00 28 00 00 00 FF FF FF FF 01 00 00 00 29 00 00 00 FF FF FF FF 01 00 00 00 73 00 00 00 00 40 1C 46 FF FF FF FF 01 00 00 00 63 00 00 00 FF FF FF FF 01 00 00 00 64 00 00 00 FF FF FF FF 02 00 00 00 27 27 00 00 FF FF FF FF 01 00 00 00 27 00 00 00 FF FF FF FF 01 00 00 00 23 00 00 00 FF FF FF FF 02 00 00 00 20 2B 00 00 FF FF FF FF 01 00 00 00 5B 00 00 00 FF FF FF FF 02 00 00 00 2C 20 00 00 FF FF FF FF 01 00 00 00 5D 00 00 00 FF FF FF FF 01 00 00 00 3C 00 00 00 FF FF FF FF 04 00 00 00 69 74 65 6D 00 00 00 00 FF FF FF FF 02 00 00 00 20 5B 00 00 FF FF FF FF 02 00 00 00 0D 0A 00 00 FF FF FF FF 03 00 00 00 65 6E 64 00 FF FF FF FF 01 00 00 00 3E 00 00 00 }
	condition:
		$1
}

rule function_2099_0 {
	meta:
		name = "ConvertProperty"
		size = 152
		refs = "0009 ConvertProperty 0018 WriteIndent 002b TReader.ReadStr 0033 WriteStr 004c ConvertValue 0071 @LStrClr 0077 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B 45 08 50 8D 55 FC 8B 45 08 8B 40 F4 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 59 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 FF FF FF FF 03 00 00 00 20 3D 20 00 FF FF FF FF 02 00 00 00 0D 0A 00 00 }
	condition:
		$1
}

rule function_2100_0 {
	meta:
		name = "ConvertObject"
		size = 136
		refs = "000f ConvertHeader 0021 ConvertProperty 0029 TReader.EndOfList 0034 TReader.ReadListEnd 003f ConvertObject 0061 WriteIndent 0070 WriteStr"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 83 C3 F4 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B 45 08 FF 40 FC EB 0A 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B 03 E8 ?? ?? ?? ?? 84 C0 74 EB 8B 03 E8 ?? ?? ?? ?? EB 0A 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B 03 E8 ?? ?? ?? ?? 84 C0 74 EB 8B 03 E8 ?? ?? ?? ?? 8B 45 08 FF 48 FC 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 5B 5D C3 FF FF FF FF 05 00 00 00 65 6E 64 0D 0A 00 00 00 }
	condition:
		$1
}

rule function_2101_0 {
	meta:
		name = "ObjectBinaryToText"
		size = 196
		refs = "001b _DV_TReader 0020 TFiler.Create 0028 DecimalSeparator 003d ObjectBinaryToText 0051 _DV_TWriter 006f TReader.ReadSignature 0075 ConvertObject 008b TObject.Free 0091 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 8B F2 8B D8 33 C0 89 45 FC 68 00 10 00 00 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F4 A1 ?? ?? ?? ?? 8A 00 88 45 F3 A1 ?? ?? ?? ?? C6 00 2E 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 68 00 10 00 00 8B CE B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F4 E8 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8A 55 F3 88 10 8B 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E6 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2102_0 {
	meta:
		name = "ConvertOrderModifier"
		size = 96
		refs = "001a TParser.NextToken 0027 TParser.CheckToken 0032 TParser.TokenInt"
	strings:
		$1 = { 55 8B EC 53 83 CB FF 8B 45 08 8B 40 FC 80 78 2D 5B 75 48 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC B2 03 E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B D8 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC B2 5D E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B C3 5B 5D C3 }
	condition:
		$1
}

rule function_2103_0 {
	meta:
		name = "ConvertHeader"
		size = 260
		refs = "0012 ConvertHeader 0025 TParser.CheckToken 0033 TParser.TokenString 003b @LStrClr 0046 TParser.NextToken 006d @LStrLAsg 0095 ConvertOrderModifier 00b7 TWriter.WritePrefix 00c5 TWriter.WriteStr 00ed @LStrArrayClr 00f3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 53 56 88 45 FF 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 FC B2 01 E8 ?? ?? ?? ?? 8D 55 F8 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 3C 3A 75 3C 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC B2 01 E8 ?? ?? ?? ?? 8D 45 F4 8B 55 F8 E8 ?? ?? ?? ?? 8D 55 F8 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8A 1D ?? ?? ?? ?? 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B F0 80 7D FF 00 74 03 80 CB 01 85 F6 7C 03 80 CB 02 8B 45 08 8B 40 F8 8B CE 8B D3 E8 ?? ?? ?? ?? 8B 45 08 8B 40 F8 8B 55 F8 E8 ?? ?? ?? ?? 8B 45 08 8B 40 F8 8B 55 F4 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5E 5B 8B E5 5D C3 00 00 00 00 00 }
	condition:
		$1
}

rule function_2104_0 {
	meta:
		name = "CombineString"
		size = 124
		refs = "0016 CombineString 0025 TParser.TokenString 002e TParser.NextToken 0037 TParser.CheckToken 004b @LStrCat 006b @LStrClr 0071 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B D8 8B 75 08 8B 76 08 83 C6 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D3 8B 06 E8 ?? ?? ?? ?? EB 24 8B 06 E8 ?? ?? ?? ?? 8B 06 B2 02 E8 ?? ?? ?? ?? 8D 55 FC 8B 06 E8 ?? ?? ?? ?? 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 06 E8 ?? ?? ?? ?? 3C 2B 74 D1 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2105_0 {
	meta:
		name = "CombineWideString"
		size = 124
		refs = "0016 CombineWideString 0025 TParser.TokenWideString 002e TParser.NextToken 0037 TParser.CheckToken 004b @WStrCat 006b @WStrClr 0071 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B D8 8B 75 08 8B 76 08 83 C6 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D3 8B 06 E8 ?? ?? ?? ?? EB 24 8B 06 E8 ?? ?? ?? ?? 8B 06 B2 05 E8 ?? ?? ?? ?? 8D 55 FC 8B 06 E8 ?? ?? ?? ?? 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 06 E8 ?? ?? ?? ?? 3C 2B 74 D1 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2106_0 {
	meta:
		name = "ConvertValue"
		size = 932
		refs = "000b ConvertValue 0027 CombineString 0036 TWriter.WriteString 004b CombineWideString 005a TWriter.WriteWideString 00b0 TParser.TokenComponentIdent 00be TWriter.WriteIdent 00ce TParser.TokenInt 00db TWriter.WriteInteger 0115 TParser.TokenFloat 0127 TWriter.WriteSingle 0155 TWriter.WriteCurrency 0177 TWriter.WriteDate 0199 TWriter.WriteFloat 01a9 TParser.NextToken 01b6 TWriter.WriteValue 01cf TParser.CheckToken 01dd TParser.TokenString 01eb TWriter.WriteStr 023c TWriter.WriteListBegin 025f TWriter.WriteListEnd 0270 TParser.HexToBinary 027b TWriter.WriteBinary 02aa TParser.CheckTokenSymbol 02be ConvertOrderModifier 02e6 ConvertProperty 02f7 TParser.TokenSymbolIs 0336 SInvalidProperty 033b LoadResString 0349 TParser.Error 0369 @WStrClr 0371 @LStrClr 0377 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 FC 8A 40 2D 3C 02 75 1D 55 8D 45 FC E8 ?? ?? ?? ?? 59 8B 55 FC 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? E9 19 03 00 00 8B 55 08 3C 05 75 1D 55 8D 45 F8 E8 ?? ?? ?? ?? 59 8B 55 F8 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? E9 F5 02 00 00 8B 55 08 25 FF 00 00 00 83 F8 28 7F 16 0F 84 B4 01 00 00 48 74 2D 83 E8 02 74 49 48 74 63 E9 AC 02 00 00 83 E8 3C 0F 84 F5 01 00 00 83 E8 1F 0F 84 0A 01 00 00 83 E8 20 0F 84 C7 01 00 00 E9 8C 02 00 00 8D 55 FC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? E9 86 02 00 00 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B D0 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? E9 69 02 00 00 8B 45 08 8B 40 FC 0F B6 40 2E 83 F8 63 7F 11 74 3B 83 E8 43 74 36 48 74 61 83 E8 0F 74 0C EB 7C 83 E8 64 74 55 83 E8 0F 75 72 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 83 C4 FC D9 1C 24 9B 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? E9 1D 02 00 00 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? D8 35 ?? ?? ?? ?? D8 0D ?? ?? ?? ?? 83 C4 F8 DF 3C 24 9B 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? E9 EF 01 00 00 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 83 C4 F8 DD 1C 24 9B 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? E9 CD 01 00 00 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 83 C4 F4 DB 3C 24 9B 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? E9 AB 01 00 00 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B 45 08 8B 40 F8 B2 0B E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC 80 78 2D 5D 74 52 8B 45 08 8B 40 FC B2 01 E8 ?? ?? ?? ?? 8D 55 FC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 3C 5D 74 1A 8B 45 08 8B 40 FC B2 2C E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? EB AE 8B 45 08 8B 40 F8 33 D2 E8 ?? ?? ?? ?? E9 23 01 00 00 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? EB 0A 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B 45 08 8B 40 FC 80 78 2D 29 75 EA 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? E9 E5 00 00 00 8B 45 08 8B 40 FC 50 68 ?? ?? ?? ?? 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? E9 C9 00 00 00 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B 45 08 8B 40 F8 B2 0E E8 ?? ?? ?? ?? EB 77 8B 45 08 8B 40 FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B 45 08 50 E8 ?? ?? ?? ?? 59 83 F8 FF 74 0C 8B 55 08 8B 52 F8 92 E8 ?? ?? ?? ?? 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? EB 0A 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B 45 08 8B 40 FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 E2 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC 80 78 2D 3E 0F 85 79 FF FF FF 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? EB 1B 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 59 59 5D C3 00 00 00 00 40 1C 46 FF FF FF FF 04 00 00 00 69 74 65 6D 00 00 00 00 FF FF FF FF 03 00 00 00 65 6E 64 00 }
	condition:
		$1
}

rule function_2107_0 {
	meta:
		name = "ConvertProperty"
		size = 212
		refs = "0012 ConvertProperty 0021 TParser.CheckToken 002b TParser.TokenString 0032 TParser.NextToken 0066 @LStrCatN 0083 TWriter.WriteStr 009c ConvertValue 00b7 @LStrArrayClr 00bd @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 8B 5D 08 83 C3 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 03 B2 01 E8 ?? ?? ?? ?? 8D 55 FC 8B 03 E8 ?? ?? ?? ?? 8B 03 E8 ?? ?? ?? ?? EB 39 8B 03 E8 ?? ?? ?? ?? 8B 03 B2 01 E8 ?? ?? ?? ?? FF 75 FC 68 ?? ?? ?? ?? 8D 55 F8 8B 03 E8 ?? ?? ?? ?? FF 75 F8 8D 45 FC BA 03 00 00 00 E8 ?? ?? ?? ?? 8B 03 E8 ?? ?? ?? ?? 8B 03 80 78 2D 2E 74 BF 8B 45 08 8B 40 F8 8B 55 FC E8 ?? ?? ?? ?? 8B 03 B2 3D E8 ?? ?? ?? ?? 8B 03 E8 ?? ?? ?? ?? 8B 45 08 50 E8 ?? ?? ?? ?? 59 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5B 59 59 5D C3 FF FF FF FF 01 00 00 00 2E 00 00 00 }
	condition:
		$1
}

rule function_2108_0 {
	meta:
		name = "ConvertObject"
		size = 236
		refs = "0010 ConvertObject 0015 TParser.TokenSymbolIs 0029 TParser.CheckTokenSymbol 0030 TParser.NextToken 003b ConvertHeader 0047 ConvertProperty 0083 TWriter.WriteListEnd"
	strings:
		$1 = { 55 8B EC 53 56 8B 75 08 83 C6 FC 33 DB 8B 06 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 04 B3 01 EB 0C 8B 06 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 06 E8 ?? ?? ?? ?? 8B 45 08 50 8B C3 E8 ?? ?? ?? ?? 59 EB 0A 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B 06 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 20 8B 06 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 10 8B 06 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 C6 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? EB 0A 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B 06 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 E6 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 8B 06 E8 ?? ?? ?? ?? 5E 5B 5D C3 00 00 00 FF FF FF FF 09 00 00 00 49 4E 48 45 52 49 54 45 44 00 00 00 FF FF FF FF 06 00 00 00 4F 42 4A 45 43 54 00 00 FF FF FF FF 03 00 00 00 45 4E 44 00 }
	condition:
		$1
}

rule function_2109_0 {
	meta:
		name = "ObjectTextToBinary"
		size = 186
		refs = "0011 _DV_TParser 0016 TParser.Create 001e DecimalSeparator 0033 ObjectTextToBinary 0047 _DV_TWriter 004c TFiler.Create 0065 TWriter.WriteSignature 006b ConvertObject 0081 TObject.Free 0087 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 8B F2 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC A1 ?? ?? ?? ?? 8A 00 88 45 F7 A1 ?? ?? ?? ?? C6 00 2E 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 68 00 10 00 00 8B CE B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 E8 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8A 55 F7 88 10 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E6 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2111_0 {
	meta:
		name = "ObjectTextToResource"
		size = 332
		refs = "0010 _DV_TMemoryStream 0015 TObject.Create 0020 ObjectTextToResource 0030 ObjectTextToBinary 0038 TStream.GetSize 0049 @FillChar 0056 TStream.SetPosition 00dc StrUpper 0139 TObject.Free 013f @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 A4 53 56 57 8B F2 8B D8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F4 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 55 F4 8B C3 E8 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? 8B D8 8D 45 A4 33 C9 BA 50 00 00 00 E8 ?? ?? ?? ?? BA 04 00 00 00 8B 45 F4 E8 ?? ?? ?? ?? 8D 55 FF B9 01 00 00 00 8B 45 F4 8B 38 FF 57 04 8A 45 FF 24 F0 3C F0 75 55 A8 02 74 41 8D 55 FF B9 01 00 00 00 8B 45 F4 8B 38 FF 57 04 8A 45 FF 2C 02 74 0A FE C8 74 0C FE C8 74 0E EB 10 C6 45 FF 01 EB 0A C6 45 FF 02 EB 04 C6 45 FF 04 33 C9 8A 4D FF 8D 55 F8 8B 45 F4 8B 38 FF 57 04 8D 55 FF B9 01 00 00 00 8B 45 F4 8B 38 FF 57 04 33 C9 8A 4D FF 8D 55 A7 8B 45 F4 8B 38 FF 57 04 8D 45 A7 E8 ?? ?? ?? ?? 8D 45 A4 C6 00 FF 8D 45 A5 66 C7 00 0A 00 33 C0 8A 45 FF 8D 44 05 A8 66 C7 00 30 10 33 C0 8A 45 FF 8D 44 05 AA 89 18 33 C9 8A 4D FF 83 C1 0A 8D 55 A4 8B C6 8B 38 FF 57 08 8B 45 F4 8B 50 04 8B CB 8B C6 8B 18 FF 53 08 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2112_0 {
	meta:
		name = "FreeThreadWindow"
		size = 28
		refs = "0002 ThreadWindow 0010 DestroyWindow"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 12 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2113_0 {
	meta:
		name = "ThreadWndProc"
		size = 157
		refs = "0020 ThreadWndProc 0045 @HandleAnyException 004a RaiseList 006b @DoneExcept 0072 FreeThreadWindow 008b DefWindowProc"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B 45 0C 8B D0 81 EA FE 8F 00 00 74 5D 4A 75 66 33 C0 89 45 FC 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 14 33 D2 89 50 24 8B D8 8B 43 20 FF 53 1C 33 C0 5A 59 59 64 89 10 EB 4E E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 18 E8 ?? ?? ?? ?? 8B 40 08 8B 55 14 89 42 24 E8 ?? ?? ?? ?? 33 D2 89 50 08 E8 ?? ?? ?? ?? EB 21 E8 ?? ?? ?? ?? 33 C0 89 45 FC EB 15 8B 55 14 52 8B 55 10 52 50 8B 45 08 50 E8 ?? ?? ?? ?? 89 45 FC 8B 45 FC 5F 5E 5B 59 5D C2 10 00 }
	condition:
		$1
}

rule function_2114_0 {
	meta:
		name = "_NF__925"
		size = 16
	strings:
		$1 = { 54 54 68 72 65 61 64 57 69 6E 64 6F 77 00 00 00 }
	condition:
		$1
}

rule function_2115_0 {
	meta:
		name = "AllocateWindow"
		size = 144
		refs = "0007 HInstance 000e ThreadWindowClass 0025 GetClassInfo 0034 ThreadWndProc 0050 UnregisterClass 005a RegisterClass 0075 AllocateWindow 0081 CreateWindow"
	strings:
		$1 = { 55 8B EC 83 C4 D8 A1 ?? ?? ?? ?? 8B 00 A3 ?? ?? ?? ?? 8D 45 D8 50 A1 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? 8B 00 50 E8 ?? ?? ?? ?? F7 D8 1B C0 F7 D8 84 C0 74 0A BA ?? ?? ?? ?? 3B 55 DC 74 21 84 C0 74 13 A1 ?? ?? ?? ?? 8B 00 50 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 A1 ?? ?? ?? ?? 8B 00 50 6A 00 BA ?? ?? ?? ?? 33 C9 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B E5 5D C3 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_2116_0 {
	meta:
		name = "AddThread"
		size = 26
		refs = "0002 ThreadCount 000a AllocateWindow 000f ThreadWindow"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 0A E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? FF 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2117_0 {
	meta:
		name = "RemoveThread"
		size = 36
		refs = "0002 ThreadCount 0019 ThreadWindow 001f PostMessage"
	strings:
		$1 = { FF 0D ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 14 6A 00 6A 00 68 FE 8F 00 00 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2118_0 {
	meta:
		name = "ThreadProc"
		size = 52
		refs = "0023 TObject.Free 002a EndThread"
	strings:
		$1 = { 53 56 57 8B F8 8B C7 8B 10 FF 52 04 8A 5F 0E 8B 77 10 C6 47 0F 01 8B C7 8B 10 FF 12 84 DB 74 07 8B C7 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B C6 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2119_0 {
	meta:
		name = "TThread.Create"
		size = 108
		refs = "000f @ClassCreate 001f TObject.Create 0024 AddThread 003d ThreadProc 0046 BeginThread 0056 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B D9 88 55 FF 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 88 5F 0D 33 F6 84 DB 74 05 BE 04 00 00 00 57 56 8D 47 08 50 B9 ?? ?? ?? ?? 33 D2 33 C0 E8 ?? ?? ?? ?? 89 47 04 8B C7 80 7D FF 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2120_0 {
	meta:
		name = "TThread.Destroy"
		size = 81
		refs = "0003 @BeforeDestruction 001a TThread.Terminate 0021 TThread.WaitFor 002e CloseHandle 003a TObject.Destroy 003f RemoveThread 004a @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 80 7E 0F 00 75 14 80 7E 0D 00 75 0E 8B C6 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B 46 04 85 C0 74 06 50 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2121_0 {
	meta:
		name = "TThread.CallOnTerminate"
		size = 13
	strings:
		$1 = { 53 8B D8 8B D0 8B 43 18 FF 53 14 5B C3 }
	condition:
		$1
}

rule function_2122_0 {
	meta:
		name = "TThread.DoTerminate"
		size = 19
		refs = "0009 TThread.CallOnTerminate 000e TThread.Synchronize"
	strings:
		$1 = { 66 83 78 16 00 74 0B 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2123_0 {
	meta:
		name = "TThread.GetPriority"
		size = 38
		refs = "0006 GetThreadPriority 0011 Priorities"
	strings:
		$1 = { 56 8B 40 04 50 E8 ?? ?? ?? ?? 8B F0 B0 03 33 D2 B9 ?? ?? ?? ?? 3B 31 75 02 8B C2 42 83 C1 04 80 FA 07 75 F1 5E C3 }
	condition:
		$1
}

rule function_2124_0 {
	meta:
		name = "TThread.SetPriority"
		size = 21
		refs = "0006 Priorities 0010 SetThreadPriority"
	strings:
		$1 = { 83 E2 7F 8B 14 95 ?? ?? ?? ?? 52 8B 40 04 50 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2125_0 {
	meta:
		name = "TThread.Synchronize"
		size = 59
		refs = "0020 ThreadWindow 0026 SendMessage 0032 @RaiseExcept"
	strings:
		$1 = { 55 8B EC 53 8B D8 33 C0 89 43 24 8B 45 08 89 43 1C 8B 45 0C 89 43 20 53 6A 00 68 FF 8F 00 00 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 43 24 85 C0 74 05 E8 ?? ?? ?? ?? 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_2126_0 {
	meta:
		name = "TThread.SetSuspended"
		size = 22
		refs = "000a TThread.Suspend 0011 TThread.Resume"
	strings:
		$1 = { 3A 50 0D 74 10 84 D2 74 07 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2127_0 {
	meta:
		name = "TThread.Suspend"
		size = 14
		refs = "0009 SuspendThread"
	strings:
		$1 = { C6 40 0D 01 8B 40 04 50 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2128_0 {
	meta:
		name = "TThread.Resume"
		size = 23
		refs = "0008 ResumeThread"
	strings:
		$1 = { 53 8B D8 8B 43 04 50 E8 ?? ?? ?? ?? 83 F8 01 75 04 C6 43 0D 00 5B C3 }
	condition:
		$1
}

rule function_2129_0 {
	meta:
		name = "TThread.Terminate"
		size = 5
	strings:
		$1 = { C6 40 0C 01 C3 }
	condition:
		$1
}

rule function_2130_0 {
	meta:
		name = "TThread.WaitFor"
		size = 94
		refs = "0007 GetCurrentThreadId 000d MainThreadID 0025 PeekMessage 0036 MsgWaitForMultipleObjects 0048 WaitForSingleObject 0052 GetExitCodeThread"
	strings:
		$1 = { 53 83 C4 E0 8B D8 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 3B 02 75 2C EB 12 6A 00 6A 00 6A 00 6A 00 8D 44 24 14 50 E8 ?? ?? ?? ?? 6A 40 6A FF 6A 00 8D 43 04 50 6A 01 E8 ?? ?? ?? ?? 83 F8 01 74 D8 EB 0B 6A FF 8B 43 04 50 E8 ?? ?? ?? ?? 54 8B 43 04 50 E8 ?? ?? ?? ?? 8B 04 24 83 C4 20 5B C3 }
	condition:
		$1
}

rule function_2131_0 {
	meta:
		name = "TComponent.Create"
		size = 76
		refs = "000b @ClassCreate 0016 TComponent.Create 0026 TComponent.InsertComponent 0031 @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 A0 ?? ?? ?? ?? 88 47 21 85 F6 74 09 8B D7 8B C6 E8 ?? ?? ?? ?? 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 00 00 00 01 00 00 00 }
	condition:
		$1
}

rule function_2132_0 {
	meta:
		name = "TComponent.Destroy"
		size = 129
		refs = "0006 @BeforeDestruction 0027 TList.Get 003c TObject.Free 0048 TComponent.Destroying 004f TComponent.DestroyComponents 005d TComponent.RemoveComponent 006a TPersistent.Destroy 0077 @ClassDestroy"
	strings:
		$1 = { 53 56 57 55 51 E8 ?? ?? ?? ?? 88 14 24 8B D8 8B 43 14 85 C0 74 2F 8B 70 08 4E 85 F6 7C 1A 46 33 FF 8B D7 8B 43 14 E8 ?? ?? ?? ?? B1 01 8B D3 8B 28 FF 55 10 47 4E 75 E9 8B 43 14 E8 ?? ?? ?? ?? 33 C0 89 43 14 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B 43 04 85 C0 74 07 8B D3 E8 ?? ?? ?? ?? 8A 14 24 80 E2 FC 8B C3 E8 ?? ?? ?? ?? 80 3C 24 00 7E 07 8B C3 E8 ?? ?? ?? ?? 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2133_0 {
	meta:
		name = "TComponent.FreeNotification"
		size = 75
		refs = "001b _DV_TList 0020 TObject.Create 002d TList.IndexOf 003b TList.Add 0044 TComponent.FreeNotification"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 43 04 85 C0 74 05 3B 46 04 74 36 83 7B 14 00 75 0F B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 43 14 8B D6 8B 43 14 E8 ?? ?? ?? ?? 85 C0 7D 13 8B D6 8B 43 14 E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2134_0 {
	meta:
		name = "TComponent.ReadLeft"
		size = 20
		refs = "0009 TReader.ReadInteger"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 E8 ?? ?? ?? ?? 66 89 43 18 5E 5B C3 }
	condition:
		$1
}

rule function_2135_0 {
	meta:
		name = "TComponent.ReadTop"
		size = 20
		refs = "0009 TReader.ReadInteger"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 E8 ?? ?? ?? ?? 66 89 43 1A 5E 5B C3 }
	condition:
		$1
}

rule function_2136_0 {
	meta:
		name = "TComponent.WriteLeft"
		size = 11
		refs = "0006 TWriter.WriteInteger"
	strings:
		$1 = { 0F B7 40 18 92 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2137_0 {
	meta:
		name = "TComponent.WriteTop"
		size = 11
		refs = "0006 TWriter.WriteInteger"
	strings:
		$1 = { 0F B7 40 1A 92 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2138_0 {
	meta:
		name = "TComponent.Insert"
		size = 43
		refs = "000f _DV_TList 0014 TObject.Create 0021 TList.Add"
	strings:
		$1 = { 53 56 8B F2 8B D8 83 7B 10 00 75 0F B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 43 10 8B D6 8B 43 10 E8 ?? ?? ?? ?? 89 5E 04 5E 5B C3 }
	condition:
		$1
}

rule function_2139_0 {
	meta:
		name = "TComponent.Remove"
		size = 37
		refs = "000c TList.Remove 001a TObject.Free"
	strings:
		$1 = { 53 8B D8 33 C0 89 42 04 8B 43 10 E8 ?? ?? ?? ?? 8B 43 10 83 78 08 00 75 0A E8 ?? ?? ?? ?? 33 C0 89 43 10 5B C3 }
	condition:
		$1
}

rule function_2140_0 {
	meta:
		name = "TComponent.InsertComponent"
		size = 83
		refs = "0010 @CallDynaInst 0028 TComponent.Insert 0031 TComponent.SetReference 0040 TComponent.SetDesigning"
	strings:
		$1 = { 53 56 57 8B F2 8B F8 8B D7 8B C6 66 BB F6 FF E8 ?? ?? ?? ?? 8B 46 08 50 33 C9 8B D6 8B C7 8B 18 FF 53 20 8B D6 8B C7 E8 ?? ?? ?? ?? B2 01 8B C6 E8 ?? ?? ?? ?? F6 47 20 10 74 09 B2 01 8B C6 E8 ?? ?? ?? ?? 33 C9 8B D6 8B C7 8B 18 FF 53 10 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2141_0 {
	meta:
		name = "TComponent.RemoveComponent"
		size = 63
		refs = "0017 TComponent.SetReference 0020 TComponent.Remove 0029 TComponent.SetDesigning"
	strings:
		$1 = { 53 56 57 8B DA 8B F0 B1 01 8B D3 8B C6 8B 38 FF 57 10 33 D2 8B C3 E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 6A 00 8B 4B 08 8B D3 8B C6 8B 18 FF 53 20 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2142_0 {
	meta:
		name = "TComponent.DestroyComponents"
		size = 43
		refs = "0009 TList.Last 0014 TComponent.Remove"
	strings:
		$1 = { 53 56 8B D8 EB 1B 8B C6 E8 ?? ?? ?? ?? 8B F0 8B D6 8B C3 E8 ?? ?? ?? ?? B2 01 8B C6 8B 08 FF 51 FC 8B 73 10 85 F6 75 DE 5E 5B C3 }
	condition:
		$1
}

rule function_2143_0 {
	meta:
		name = "TComponent.Destroying"
		size = 56
		refs = "0027 TList.Get 002c TComponent.Destroying"
	strings:
		$1 = { 53 56 57 8B D8 F6 43 20 08 75 29 80 4B 20 08 8B 43 10 85 C0 74 1E 8B 70 08 4E 85 F6 7C 16 46 33 FF 8B D7 8B 43 10 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 47 4E 75 ED 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2144_0 {
	meta:
		name = "TComponent.Notification"
		size = 108
		refs = "0022 TList.Remove 0030 TObject.Free 0051 TList.Get"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 88 4C 24 04 89 14 24 8B D8 8B 43 14 85 C0 74 22 80 7C 24 04 01 75 1B 8B 14 24 E8 ?? ?? ?? ?? 8B 43 14 83 78 08 00 75 0A E8 ?? ?? ?? ?? 33 C0 89 43 14 8B 43 10 85 C0 74 25 8B 70 08 4E 85 F6 7C 1D 46 33 FF 8B D7 8B 43 10 E8 ?? ?? ?? ?? 8A 4C 24 04 8B 14 24 8B 28 FF 55 10 47 4E 75 E6 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2145_0 {
	meta:
		name = "TComponent.DefineProperties"
		size = 132
		refs = "001f TComponent.ReadLeft 0025 TComponent.WriteLeft 0035 TComponent.DefineProperties 0041 TComponent.ReadTop 0047 TComponent.WriteTop"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B F2 8B D8 33 C0 89 45 FC 8B 46 1C 85 C0 74 06 8B 40 18 89 45 FC 53 68 ?? ?? ?? ?? 53 68 ?? ?? ?? ?? 66 8B 43 18 66 3B 45 FC 0F 95 C1 BA ?? ?? ?? ?? 8B C6 8B 38 FF 17 53 68 ?? ?? ?? ?? 53 68 ?? ?? ?? ?? 66 8B 45 FE 66 3B 43 1A 0F 95 C1 BA ?? ?? ?? ?? 8B C6 8B 18 FF 13 5F 5E 5B 59 5D C3 00 FF FF FF FF 04 00 00 00 4C 65 66 74 00 00 00 00 FF FF FF FF 03 00 00 00 54 6F 70 00 }
	condition:
		$1
}

rule function_2150_0 {
	meta:
		name = "TComponent.GetNamePath"
		size = 19
		refs = "000c @LStrLAsg"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 53 08 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2155_0 {
	meta:
		name = "TComponent.Updating"
		size = 9
	strings:
		$1 = { 53 8B D8 80 4B 20 40 5B C3 }
	condition:
		$1
}

rule function_2156_0 {
	meta:
		name = "TComponent.Updated"
		size = 9
	strings:
		$1 = { 53 8B D8 80 63 20 BF 5B C3 }
	condition:
		$1
}

rule function_2157_0 {
	meta:
		name = "TComponent.Loaded"
		size = 9
	strings:
		$1 = { 53 8B D8 80 63 20 FE 5B C3 }
	condition:
		$1
}

rule function_2159_0 {
	meta:
		name = "TComponent.WriteState"
		size = 7
	strings:
		$1 = { 92 8B 08 FF 51 0C C3 }
	condition:
		$1
}

rule function_2160_0 {
	meta:
		name = "TComponent.ValidateRename"
		size = 179
		refs = "001c TComponent.ValidateRename 0030 CompareText 003d TComponent.FindComponent 0056 SDuplicateName 005b LoadResString 0065 _DV_EComponentError 006a Exception.CreateFmt 006f @RaiseExcept 009e @LStrClr 00a4 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 33 DB 89 5D F0 89 4D FC 8B FA 8B D8 8B 75 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 FF 74 49 8B D6 8B 45 FC E8 ?? ?? ?? ?? 85 C0 74 3B 8B D6 8B C3 E8 ?? ?? ?? ?? 85 C0 74 2E 89 75 F4 C6 45 F8 0B 8D 45 F4 50 6A 00 8D 55 F0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D F0 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 43 20 10 74 14 83 7B 04 00 74 0E 56 8B 4D FC 8B D7 8B 43 04 8B 18 FF 53 20 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_2161_0 {
	meta:
		name = "TComponent.ValidateContainer"
		size = 20
		refs = "000d @CallDynaInst"
	strings:
		$1 = { 53 56 8B F0 8B C2 8B D6 66 BB F5 FF E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2163_0 {
	meta:
		name = "TComponent.FindComponent"
		size = 77
		refs = "002a TList.Get 0037 CompareText"
	strings:
		$1 = { 53 56 57 55 51 89 14 24 8B F8 83 3C 24 00 74 33 83 7F 10 00 74 2D 8B 47 10 8B 58 08 4B 85 DB 7C 22 43 33 ED 8B 47 10 8B D5 E8 ?? ?? ?? ?? 8B F0 8B 14 24 8B 46 08 E8 ?? ?? ?? ?? 85 C0 74 06 45 4B 75 E1 33 F6 8B C6 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2164_0 {
	meta:
		name = "TComponent.SetName"
		size = 201
		refs = "0016 TComponent.SetName 0026 @LStrCmp 0033 IsValidIdent 004c SInvalidName 0051 LoadResString 005b _DV_EComponentError 0060 Exception.CreateFmt 0065 @RaiseExcept 008f TComponent.SetReference 0098 TComponent.ChangeName 00b6 @LStrClr 00bc @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 33 C9 89 4D F4 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 43 08 8B D6 E8 ?? ?? ?? ?? 74 79 85 F6 74 39 8B C6 E8 ?? ?? ?? ?? 84 C0 75 2E 89 75 F8 C6 45 FC 0B 8D 45 F8 50 6A 00 8D 55 F4 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D F4 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 43 04 85 C0 74 0D 56 8B 4B 08 8B D3 8B 38 FF 57 20 EB 0D 56 8B 4B 08 33 D2 8B C3 8B 38 FF 57 20 33 D2 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? B2 01 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2165_0 {
	meta:
		name = "TComponent.ChangeName"
		size = 19
		refs = "000c @LStrAsg"
	strings:
		$1 = { 53 56 8B F2 8B D8 8D 43 08 8B D6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2166_0 {
	meta:
		name = "TComponent.GetComponentIndex"
		size = 27
		refs = "0012 TList.IndexOf"
	strings:
		$1 = { 8B 50 04 85 D2 74 10 83 7A 10 00 74 0A 8B 52 10 92 E8 ?? ?? ?? ?? C3 83 C8 FF C3 }
	condition:
		$1
}

rule function_2167_0 {
	meta:
		name = "TComponent.GetComponent"
		size = 107
		refs = "000f TComponent.GetComponent 0023 SListIndexError 0028 LoadResString 0032 _DV_TList 0037 TList.Error 0041 TList.Get 0058 @LStrClr 005e @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 7B 10 00 75 1C 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B CE A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D6 8B 43 10 E8 ?? ?? ?? ?? 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2168_0 {
	meta:
		name = "TComponent.GetComponentCount"
		size = 14
	strings:
		$1 = { 8B 50 10 85 D2 74 04 8B 42 08 C3 33 C0 C3 }
	condition:
		$1
}

rule function_2169_0 {
	meta:
		name = "TComponent.SetComponentIndex"
		size = 81
		refs = "0014 TList.IndexOf 003a TList.Delete 0049 TList.Insert"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B 43 04 85 C0 74 3F 8B 40 10 8B D3 E8 ?? ?? ?? ?? 85 C0 7C 31 8B 53 04 8B 7A 10 8B 57 08 85 F6 7D 02 33 F6 3B D6 7F 03 8B F2 4E 3B C6 74 17 8B D7 92 E8 ?? ?? ?? ?? 8B 43 04 8B 40 10 8B CB 8B D6 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2170_0 {
	meta:
		name = "TComponent.SetAncestor"
		size = 64
		refs = "0019 TComponent.GetComponentCount 002c TComponent.GetComponent 0033 TComponent.SetAncestor"
	strings:
		$1 = { 53 56 57 55 8B DA 8B F8 84 DB 74 06 80 4F 20 20 EB 04 80 67 20 DF 8B C7 E8 ?? ?? ?? ?? 8B E8 4D 85 ED 7C 17 45 33 F6 8B D6 8B C7 E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 46 4D 75 EC 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2171_0 {
	meta:
		name = "TComponent.SetDesigning"
		size = 64
		refs = "0019 TComponent.GetComponentCount 002c TComponent.GetComponent 0033 TComponent.SetDesigning"
	strings:
		$1 = { 53 56 57 55 8B DA 8B F8 84 DB 74 06 80 4F 20 10 EB 04 80 67 20 EF 8B C7 E8 ?? ?? ?? ?? 8B E8 4D 85 ED 7C 17 45 33 F6 8B D6 8B C7 E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 46 4D 75 EC 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2172_0 {
	meta:
		name = "TComponent.SetReference"
		size = 70
		refs = "001f @LStrToString 0028 TObject.FieldAddress"
	strings:
		$1 = { 53 56 57 81 C4 00 FF FF FF 8B DA 8B F8 8B 77 04 85 F6 74 28 8B C4 8B 57 08 B9 FF 00 00 00 E8 ?? ?? ?? ?? 8B D4 8B C6 E8 ?? ?? ?? ?? 85 C0 74 0C 84 DB 74 04 89 38 EB 04 33 D2 89 10 81 C4 00 01 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2173_0 {
	meta:
		name = "TComponent.ExecuteAction"
		size = 38
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D3 8B C6 8B 08 FF 51 38 84 C0 74 0E 8B D3 8B C6 8B 08 FF 51 40 B0 01 5E 5B C3 33 C0 5E 5B C3 }
	condition:
		$1
}

rule function_2174_0 {
	meta:
		name = "TComponent.UpdateAction"
		size = 38
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D3 8B C6 8B 08 FF 51 38 84 C0 74 0E 8B D3 8B C6 8B 08 FF 51 3C B0 01 5E 5B C3 33 C0 5E 5B C3 }
	condition:
		$1
}

rule function_2175_0 {
	meta:
		name = "TComponent.GetComObject"
		size = 212
		refs = "001b TComponent.GetComObject 002d CreateVCLComObjectProc 004b TObject.ClassName 0069 SNoComSupport 006e LoadResString 007b _DV_EComponentError 0080 Exception.CreateFmt 0085 @RaiseExcept 008c @IntfClear 00b2 @LStrClr 00b8 @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 F4 FE FF FF 53 56 33 C9 89 8D F4 FE FF FF 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 7B 1C 00 75 5E 83 3D ?? ?? ?? ?? 00 74 08 8B C3 FF 15 ?? ?? ?? ?? 83 7B 1C 00 75 47 8D 95 F8 FE FF FF 8B 03 E8 ?? ?? ?? ?? 8D 85 F8 FE FF FF 89 45 F8 C6 45 FC 04 8D 45 F8 50 6A 00 8D 95 F4 FE FF FF A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 8D F4 FE FF FF B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 8B 43 1C 50 8B 00 FF 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 F4 FE FF FF E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 5E 5B 8B E5 5D C3 00 00 00 00 00 00 00 00 C0 00 00 00 00 00 00 46 }
	condition:
		$1
}

rule function_2176_0 {
	meta:
		name = "TComponent.SafeCallException"
		size = 24
		refs = "0012 TObject.SafeCallException"
	strings:
		$1 = { 53 83 78 1C 00 74 0A 8B 40 1C 8B 18 FF 53 1C 5B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2177_0 {
	meta:
		name = "TComponent.FreeOnRelease"
		size = 15
	strings:
		$1 = { 83 78 1C 00 74 08 8B 40 1C 8B 10 FF 52 20 C3 }
	condition:
		$1
}

rule function_2179_0 {
	meta:
		name = "TComponent.QueryInterface"
		size = 64
		refs = "001c TObject.GetInterface"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 7D 10 8B 75 0C 8B 5D 08 83 7B 1C 00 75 1A 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 84 C0 74 04 33 C0 EB 11 B8 02 40 00 80 EB 0A 57 56 8B 43 1C 50 8B 00 FF 10 5F 5E 5B 5D C2 0C 00 }
	condition:
		$1
}

rule function_2180_0 {
	meta:
		name = "TComponent._AddRef"
		size = 30
	strings:
		$1 = { 55 8B EC 8B 45 08 83 78 1C 00 75 05 83 C8 FF EB 09 8B 40 1C 50 8B 00 FF 50 04 5D C2 04 00 }
	condition:
		$1
}

rule function_2181_0 {
	meta:
		name = "TComponent._Release"
		size = 30
	strings:
		$1 = { 55 8B EC 8B 45 08 83 78 1C 00 75 05 83 C8 FF EB 09 8B 40 1C 50 8B 00 FF 50 08 5D C2 04 00 }
	condition:
		$1
}

rule function_2182_0 {
	meta:
		name = "TComponent.GetTypeInfoCount"
		size = 36
	strings:
		$1 = { 55 8B EC 8B 45 08 83 78 1C 00 75 07 B8 01 40 00 80 EB 0D 8B 55 0C 52 8B 40 1C 50 8B 00 FF 50 0C 5D C2 08 00 }
	condition:
		$1
}

rule function_2183_0 {
	meta:
		name = "TComponent.GetTypeInfo"
		size = 44
	strings:
		$1 = { 55 8B EC 8B 45 08 83 78 1C 00 75 07 B8 01 40 00 80 EB 15 8B 55 14 52 8B 55 10 52 8B 55 0C 52 8B 40 1C 50 8B 00 FF 50 10 5D C2 10 00 }
	condition:
		$1
}

rule function_2184_0 {
	meta:
		name = "TComponent.GetIDsOfNames"
		size = 52
	strings:
		$1 = { 55 8B EC 8B 45 08 83 78 1C 00 75 07 B8 01 40 00 80 EB 1D 8B 55 1C 52 8B 55 18 52 8B 55 14 52 8B 55 10 52 8B 55 0C 52 8B 40 1C 50 8B 00 FF 50 14 5D C2 18 00 }
	condition:
		$1
}

rule function_2185_0 {
	meta:
		name = "TComponent.Invoke"
		size = 65
	strings:
		$1 = { 55 8B EC 8B 45 08 83 78 1C 00 75 07 B8 01 40 00 80 EB 2A 8B 55 28 52 8B 55 24 52 8B 55 20 52 8B 55 1C 52 66 8B 55 18 52 8B 55 14 52 8B 55 10 52 8B 55 0C 52 8B 40 1C 50 8B 00 FF 50 18 5D C2 24 00 }
	condition:
		$1
}

rule function_2186_0 {
	meta:
		name = "TBasicActionLink.Create"
		size = 65
		refs = "000b @ClassCreate 001a TObject.Create 002d @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 8B D6 8B C7 8B 08 FF 11 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2188_0 {
	meta:
		name = "TBasicActionLink.Destroy"
		size = 51
		refs = "0003 @BeforeDestruction 0015 TBasicAction.UnRegisterChanges 0021 TObject.Destroy 002c @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 0C 85 C0 74 07 8B D6 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2189_0 {
	meta:
		name = "TBasicActionLink.Change"
		size = 21
	strings:
		$1 = { 53 66 83 78 06 00 74 0B 8B D8 8B 50 0C 8B 43 08 FF 53 04 5B C3 }
	condition:
		$1
}

rule function_2190_0 {
	meta:
		name = "TBasicActionLink.Execute"
		size = 15
		refs = "0009 @CallDynaInst"
	strings:
		$1 = { 53 8B 40 0C 66 BB F0 FF E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2191_0 {
	meta:
		name = "TBasicActionLink.SetAction"
		size = 43
		refs = "0014 TBasicAction.UnRegisterChanges 0024 TBasicAction.RegisterChanges"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 43 0C 3B F0 74 1B 85 C0 74 07 8B D3 E8 ?? ?? ?? ?? 89 73 0C 85 F6 74 09 8B D3 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2194_0 {
	meta:
		name = "TBasicActionLink.Update"
		size = 9
	strings:
		$1 = { 8B 40 0C 8B 10 FF 52 44 C3 }
	condition:
		$1
}

rule function_2195_0 {
	meta:
		name = "TBasicAction.Create"
		size = 68
		refs = "000a @ClassCreate 0017 TComponent.Create 001e _DV_TList 0023 TObject.Create 0031 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 3C 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_2196_0 {
	meta:
		name = "TBasicAction.Destroy"
		size = 74
		refs = "0004 @BeforeDestruction 0014 TComponent.Destroy 001d TList.Last 0026 TBasicAction.UnRegisterChanges 0037 TObject.Free 0042 @ClassDestroy"
	strings:
		$1 = { 53 56 57 E8 ?? ?? ?? ?? 8B DA 8B F8 8B D3 80 E2 FC 8B C7 E8 ?? ?? ?? ?? EB 10 8B C6 E8 ?? ?? ?? ?? 8B D0 8B C7 E8 ?? ?? ?? ?? 8B 77 3C 83 7E 08 00 7F E7 8B 47 3C E8 ?? ?? ?? ?? 84 DB 7E 07 8B C7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2200_0 {
	meta:
		name = "TBasicAction.Execute"
		size = 26
	strings:
		$1 = { 53 66 83 78 2E 00 74 0E 8B D8 8B D0 8B 43 30 FF 53 2C B0 01 5B C3 33 C0 5B C3 }
	condition:
		$1
}

rule function_2201_0 {
	meta:
		name = "TBasicAction.Update"
		size = 26
	strings:
		$1 = { 53 66 83 78 36 00 74 0E 8B D8 8B D0 8B 43 38 FF 53 34 B0 01 5B C3 33 C0 5B C3 }
	condition:
		$1
}

rule function_2202_0 {
	meta:
		name = "TBasicAction.SetOnExecute"
		size = 81
		refs = "002a TList.Get"
	strings:
		$1 = { 55 8B EC 53 56 57 8B D8 8B 45 08 3B 43 2C 74 3A 8B 43 3C 8B 70 08 4E 85 F6 7C 1C 46 33 FF FF 75 0C FF 75 08 8B D7 8B 43 3C E8 ?? ?? ?? ?? 8B 10 FF 52 10 47 4E 75 E7 8B 45 08 89 43 2C 8B 45 0C 89 43 30 8B C3 8B 10 FF 52 30 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_2203_0 {
	meta:
		name = "TBasicAction.Change"
		size = 20
		altNames = "TCanvas.Changed TDdeServerConv.Connect"
	strings:
		$1 = { 53 66 83 78 26 00 74 0A 8B D8 8B D0 8B 43 28 FF 53 24 5B C3 }
	condition:
		$1
}

rule function_2204_0 {
	meta:
		name = "TBasicAction.RegisterChanges"
		size = 12
		refs = "0007 TList.Add"
	strings:
		$1 = { 89 42 0C 8B 40 3C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2205_0 {
	meta:
		name = "TBasicAction.UnRegisterChanges"
		size = 62
		refs = "001c TList.Get 002f TList.Delete"
	strings:
		$1 = { 53 56 57 55 8B EA 8B F8 8B 47 3C 8B 70 08 4E 85 F6 7C 26 46 33 DB 8B 47 3C 8B D3 E8 ?? ?? ?? ?? 3B E8 75 11 33 C0 89 45 0C 8B 47 3C 8B D3 E8 ?? ?? ?? ?? EB 04 43 4E 75 DD 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2206_0 {
	meta:
		name = "TStreamAdapter.Create"
		size = 72
		refs = "000e @ClassCreate 001d TObject.Create 0031 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 0C 8A 45 08 88 47 10 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_2207_0 {
	meta:
		name = "TStreamAdapter.Destroy"
		size = 56
		refs = "0003 @BeforeDestruction 0015 TObject.Free 0026 TObject.Destroy 0031 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 80 7E 10 01 75 0D 8B 46 0C E8 ?? ?? ?? ?? 33 C0 89 46 0C 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2208_0 {
	meta:
		name = "TStreamAdapter.Read"
		size = 103
		refs = "0010 TStreamAdapter.Read 0050 @HandleAnyException 005a @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 55 0C 8B 45 08 33 C9 55 68 ?? ?? ?? ?? 64 FF 31 64 89 21 85 D2 75 0F BB 09 00 03 80 33 C0 5A 59 59 64 89 10 EB 31 8B 40 0C 8B 4D 10 8B 18 FF 53 04 83 7D 14 00 74 05 8B 55 14 89 02 33 DB 33 C0 5A 59 59 64 89 10 EB 0F E9 ?? ?? ?? ?? BB 01 00 00 00 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 10 00 }
	condition:
		$1
}

rule function_2209_0 {
	meta:
		name = "TStreamAdapter.Write"
		size = 103
		refs = "0010 TStreamAdapter.Write 0050 @HandleAnyException 005a @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 55 0C 8B 45 08 33 C9 55 68 ?? ?? ?? ?? 64 FF 31 64 89 21 85 D2 75 0F BB 09 00 03 80 33 C0 5A 59 59 64 89 10 EB 31 8B 40 0C 8B 4D 10 8B 18 FF 53 08 83 7D 14 00 74 05 8B 55 14 89 02 33 DB 33 C0 5A 59 59 64 89 10 EB 0F E9 ?? ?? ?? ?? BB 03 01 03 80 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 10 00 }
	condition:
		$1
}

rule function_2210_0 {
	meta:
		name = "TStreamAdapter.Seek"
		size = 119
		refs = "0010 TStreamAdapter.Seek 0060 @HandleAnyException 006a @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 4D 14 8B 5D 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 C9 7C 05 83 F9 02 7E 0F BB 01 00 03 80 33 C0 5A 59 59 64 89 10 EB 3C 8B 45 0C 8B D0 8B 43 0C 8B 18 FF 53 0C 8B C8 8B 45 18 85 C0 74 0B 8B C1 99 8B 4D 18 89 01 89 51 04 33 DB 33 C0 5A 59 59 64 89 10 EB 0F E9 ?? ?? ?? ?? BB 09 00 03 80 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 14 00 }
	condition:
		$1
}

rule function_2211_0 {
	meta:
		name = "TStreamAdapter.SetSize"
		size = 97
		refs = "000d TStreamAdapter.SetSize 0027 TStream.GetSize 004a @HandleAnyException 0054 @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 5D 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 0C 8B D0 8B 43 0C 8B 08 FF 11 8B 43 0C E8 ?? ?? ?? ?? 99 3B 55 10 75 03 3B 45 0C 74 07 BB 05 40 00 80 EB 02 33 DB 33 C0 5A 59 59 64 89 10 EB 0F E9 ?? ?? ?? ?? BB FF FF 00 80 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 0C 00 }
	condition:
		$1
}

rule function_2212_0 {
	meta:
		name = "TStreamAdapter.CopyTo"
		size = 259
		refs = "0013 @IntfAddRef 001b TStreamAdapter.CopyTo 003d @GetMem 009a @FreeMem 00a0 @HandleFinally 00ca @HandleAnyException 00d6 @DoneExcept 00eb @IntfClear"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 8B 5D 18 8B 75 08 8B 45 0C E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 10 89 45 F4 8B 45 F4 E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 F8 8B 46 0C 8B 4D F4 8B 30 FF 56 04 8B C8 85 DB 74 08 8B C1 99 89 03 89 53 04 8D 45 F0 50 8B 45 F4 50 8B 45 F8 50 8B 45 0C 50 8B 00 FF 50 10 89 45 FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 55 F4 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 83 7D FC 00 75 13 8B 45 1C 85 C0 74 0C 8B 45 F0 99 8B 4D 1C 89 01 89 51 04 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? C7 45 FC FF FF 00 80 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 FC 5F 5E 5B 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule function_2214_0 {
	meta:
		name = "TStreamAdapter.Revert"
		size = 12
	strings:
		$1 = { 55 8B EC B8 02 01 03 80 5D C2 04 00 }
	condition:
		$1
}

rule function_2215_0 {
	meta:
		name = "TStreamAdapter.LockRegion"
		size = 12
		altNames = "TStreamAdapter.UnlockRegion"
	strings:
		$1 = { 55 8B EC B8 01 00 03 80 5D C2 18 00 }
	condition:
		$1
}

rule function_2217_0 {
	meta:
		name = "TStreamAdapter.Stat"
		size = 125
		refs = "0012 TStreamAdapter.Stat 002b TStream.GetSize 0066 @HandleAnyException 0070 @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 5D 0C 8B 7D 08 33 F6 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 DB 74 3B C7 43 04 02 00 00 00 8B 47 0C E8 ?? ?? ?? ?? 99 89 43 08 89 53 0C 33 C0 89 43 10 33 C0 89 43 14 33 C0 89 43 18 33 C0 89 43 1C 33 C0 89 43 20 33 C0 89 43 24 C7 43 2C 01 00 00 00 33 C0 5A 59 59 64 89 10 EB 0F E9 ?? ?? ?? ?? BE FF FF 00 80 E8 ?? ?? ?? ?? 8B C6 5F 5E 5B 5D C2 0C 00 }
	condition:
		$1
}

rule function_2219_0 {
	meta:
		name = "FreeIntConstList"
		size = 107
		refs = "0007 IntConstList 000c TThreadList.LockList 0016 FreeIntConstList 0030 TList.Get 0035 TObject.Free 0050 TThreadList.UnlockList 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 53 56 57 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 5F 08 4B 85 DB 7C 15 43 33 F6 8B D6 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 46 4B 75 EE 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EE A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule function_2221_0 {
	meta:
		name = "Finalization"
		size = 169
		refs = "0007 Finalization 0013 _DV_84 001a HInstance 0021 UnRegisterModuleClasses 0026 GlobalNameSpace 002b TMultiReadExclusiveWriteSynchronizer.BeginWrite 0030 FreeIntConstList 0035 ClassList 003a TObject.Free 003f ClassAliasList 004d RemoveFixupReferences 0052 GlobalFixupList 0063 @GetTls 0069 GlobalLists 0073 FreeThreadWindow 0089 ModuleUnload 008e RemoveModuleUnloadProc 00a1 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 79 A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 D2 33 C0 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_2222_0 {
	meta:
		name = "Classes"
		size = 105
		refs = "0002 _DV_84 000a ModuleUnload 000f AddModuleUnloadProc 0016 _Dn_TMultiReadExclusiveWriteSynchronizer 001b TMultiReadExclusiveWriteSynchronizer.Create 0020 GlobalNameSpace 0027 _DV_TThreadList 002c TThreadList.Create 0031 ClassList 0038 _DV_TStringList 003d TObject.Create 0042 ClassAliasList 0053 IntConstList 0064 GlobalFixupList"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 5F B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2223_0 {
	meta:
		name = "TClipboard.Clear"
		size = 66
		refs = "000b TClipboard.Open 0013 TClipboard.Clear 001e EmptyClipboard 0033 TClipboard.Close 0039 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_2224_0 {
	meta:
		name = "TClipboard.Adding"
		size = 28
		refs = "0012 TClipboard.Clear"
	strings:
		$1 = { 53 8B D8 83 7B 04 00 74 11 80 7B 0D 00 75 0B 8B C3 E8 ?? ?? ?? ?? C6 43 0D 01 5B C3 }
	condition:
		$1
}

rule function_2225_0 {
	meta:
		name = "TClipboard.Close"
		size = 44
		refs = "0013 CloseClipboard 0021 DeallocateHWnd"
	strings:
		$1 = { 53 8B D8 83 7B 04 00 74 21 FF 4B 04 83 7B 04 00 75 18 E8 ?? ?? ?? ?? 80 7B 0C 00 74 08 8B 43 08 E8 ?? ?? ?? ?? 33 C0 89 43 08 5B C3 }
	condition:
		$1
}

rule function_2226_0 {
	meta:
		name = "TClipboard.Open"
		size = 149
		refs = "000c TClipboard.Open 001d Application 002f TClipboard.WndProc 0034 AllocateHWnd 0044 OpenClipboard 0050 SCannotOpenClipboard 0055 LoadResString 005f _Dn_Exception 0064 Exception.Create 0069 @RaiseExcept 0085 @LStrClr 008b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 7B 04 00 75 55 A1 ?? ?? ?? ?? 8B 00 8B 40 24 89 43 08 85 C0 75 12 53 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 43 08 C6 43 0C 01 8B 43 08 50 E8 ?? ?? ?? ?? 85 C0 75 21 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 43 0D 00 FF 43 04 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_2227_0 {
	meta:
		name = "TClipboard.WndProc"
		size = 32
		refs = "0016 DefWindowProc"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B 43 08 50 8B 43 04 50 8B 03 50 8B 46 08 50 E8 ?? ?? ?? ?? 89 43 0C 5E 5B C3 }
	condition:
		$1
}

rule function_2228_0 {
	meta:
		name = "TClipboard.GetComponent"
		size = 414
		refs = "0019 TClipboard.Open 0021 TClipboard.GetComponent 002e CF_COMPONENT 0034 GetClipboardData 0042 @TryFinallyExit 0050 GlobalLock 0075 _Dn_TMemoryStream 007a TObject.Create 0094 GlobalSize 00a0 TStream.WriteBuffer 00aa TStream.SetPosition 00b9 _Dn_TReader 00be TFiler.Create 00df TReader.ReadRootComponent 00fa TComponent.InsertComponent 0109 @HandleAnyException 0111 TObject.Free 0116 @RaiseAgain 011b @DoneExcept 0136 @HandleFinally 016b GlobalUnlock 0188 TClipboard.Close"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 8B F1 8B DA 89 45 FC 33 C0 89 45 F8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 0F B7 05 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 89 45 F4 83 7D F4 00 75 0A E8 ?? ?? ?? ?? E9 49 01 00 00 8B 45 F4 50 E8 ?? ?? ?? ?? 8B F8 85 FF 75 0A E8 ?? ?? ?? ?? E9 30 01 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F4 50 E8 ?? ?? ?? ?? 8B C8 8B D7 8B 45 F0 E8 ?? ?? ?? ?? 33 D2 8B 45 F0 E8 ?? ?? ?? ?? 68 00 01 00 00 8B 4D F0 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 EC 89 70 28 33 D2 8B 45 EC E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 F8 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 17 E9 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 EC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F4 50 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 F8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2229_0 {
	meta:
		name = "TClipboard.SetBuffer"
		size = 226
		refs = "0017 TClipboard.Open 001f TClipboard.SetBuffer 0030 GlobalAlloc 004a GlobalLock 0063 Move 006b TClipboard.Adding 0078 SetClipboardData 008e GlobalUnlock 0094 @HandleFinally 00a5 @HandleAnyException 00ae GlobalFree 00b3 @RaiseAgain 00b8 @DoneExcept 00cd TClipboard.Close"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 8B F9 8B F2 89 45 FC 8B 5D 08 8B 45 FC E8 ?? ?? ?? ?? 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 53 68 02 20 00 00 E8 ?? ?? ?? ?? 89 45 F8 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 F8 50 E8 ?? ?? ?? ?? 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B D0 8B C7 8B CB E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B 45 F8 50 0F B7 C6 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 50 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EF 33 C0 5A 59 59 64 89 10 EB 18 E9 ?? ?? ?? ?? 8B 45 F8 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 59 5D C2 04 00 }
	condition:
		$1
}

rule function_2230_0 {
	meta:
		name = "TClipboard.SetComponent"
		size = 112
		refs = "000d _Dn_TMemoryStream 0012 TObject.Create 001d TClipboard.SetComponent 002d TStream.WriteComponent 0035 TStream.GetSize 0043 CF_COMPONENT 004a TClipboard.SetBuffer 005f TObject.Free 0065 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 8B F2 8B D8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D6 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 50 8B 45 FC 8B 48 04 66 8B 15 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2231_0 {
	meta:
		name = "TClipboard.GetTextBuf"
		size = 79
		refs = "000d TClipboard.Open 0014 GetClipboardData 0024 GlobalLock 0030 StrLCopy 0035 StrLen 003d GlobalUnlock 0044 TClipboard.Close"
	strings:
		$1 = { 53 56 57 55 8B E9 8B FA 8B F0 8B C6 E8 ?? ?? ?? ?? 6A 01 E8 ?? ?? ?? ?? 8B D8 85 DB 75 04 33 FF EB 1F 53 E8 ?? ?? ?? ?? 8B D0 8B CD 49 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 53 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B C7 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2232_0 {
	meta:
		name = "TClipboard.SetTextBuf"
		size = 31
		refs = "0009 StrLen 0018 TClipboard.SetBuffer"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 E8 ?? ?? ?? ?? 40 50 8B CE 66 BA 01 00 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2233_0 {
	meta:
		name = "TClipboard.GetAsText"
		size = 126
		refs = "0010 TClipboard.Open 0017 GetClipboardData 0022 TClipboard.GetAsText 0037 GlobalLock 0040 @LStrFromPChar 0049 @LStrClr 0065 GlobalUnlock 006d TClipboard.Close 0073 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 8B DA 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 6A 01 E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 7D F8 00 74 14 8B 45 F8 50 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? EB 07 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 83 7D F8 00 74 09 8B 45 F8 50 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E1 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_2234_0 {
	meta:
		name = "TClipboard.SetAsText"
		size = 38
		refs = "0009 @LStrLen 0012 @LStrToPChar 001f TClipboard.SetBuffer"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 E8 ?? ?? ?? ?? 40 50 8B C6 E8 ?? ?? ?? ?? 8B C8 66 BA 01 00 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2235_0 {
	meta:
		name = "TClipboard.AssignToPicture"
		size = 236
		refs = "0017 TClipboard.AssignToPicture 0025 TClipboard.Open 003a EnumClipboardFormats 0048 _Dn_TPicture 004d TPicture.SupportsClipboardFormat 005a GetClipboardData 006f TPicture.LoadFromClipboardFormat 0074 @TryFinallyExit 008e SInvalidClipFmt 0093 LoadResString 009d _Dn_Exception 00a2 Exception.Create 00a7 @RaiseExcept 00bc TClipboard.Close 00c2 @HandleFinally 00d9 @LStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 33 C9 89 4D F8 8B FA 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 6A 00 E8 ?? ?? ?? ?? 8B D8 66 85 DB 74 45 8B D3 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 25 0F B7 C3 50 E8 ?? ?? ?? ?? 8B F0 6A 09 E8 ?? ?? ?? ?? 50 8B CE 8B D3 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 4E 0F B7 C3 50 E8 ?? ?? ?? ?? 8B D8 66 85 DB 75 BB 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D F8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_2236_0 {
	meta:
		name = "TClipboard.AssignToBitmap"
		size = 101
		refs = "0010 TClipboard.Open 0018 TClipboard.AssignToBitmap 0025 GetClipboardData 0053 TClipboard.Close 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B FA 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 6A 02 E8 ?? ?? ?? ?? 8B D8 6A 09 E8 ?? ?? ?? ?? 8B F0 56 8B CB 66 BA 02 00 8B C7 8B 18 FF 53 58 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2237_0 {
	meta:
		name = "TClipboard.AssignToMetafile"
		size = 97
		refs = "000f TClipboard.Open 0017 TClipboard.AssignToMetafile 0024 GetClipboardData 0050 TClipboard.Close 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 8B F2 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 6A 03 E8 ?? ?? ?? ?? 8B D8 6A 09 E8 ?? ?? ?? ?? 50 8B CB 66 BA 03 00 8B C6 8B 18 FF 53 58 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2238_0 {
	meta:
		name = "TClipboard.AssignTo"
		size = 103
		refs = "000a _Dn_TPicture 000f @IsClass 001c TClipboard.AssignToPicture 0027 _Dn_TBitmap 0039 TClipboard.AssignToBitmap 0043 _Dn_TMetafile 0055 TClipboard.AssignToMetafile 0060 TPersistent.AssignTo"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0C 8B D3 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0B 8B D3 8B C6 E8 ?? ?? ?? ?? EB 25 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0B 8B D3 8B C6 E8 ?? ?? ?? ?? EB 09 8B D3 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2239_0 {
	meta:
		name = "TClipboard.AssignPicture"
		size = 129
		refs = "0010 TClipboard.Open 0018 TClipboard.AssignPicture 0026 TClipboard.Adding 003c TPicture.SaveToClipboardFormat 004a SetClipboardData 0070 TClipboard.Close 0076 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 8B DA 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 33 C0 89 45 F0 8D 45 F0 50 8D 4D F8 8D 55 F6 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 0F B7 45 F6 50 E8 ?? ?? ?? ?? 83 7D F0 00 74 0B 8B 45 F0 50 6A 09 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2240_0 {
	meta:
		name = "TClipboard.AssignGraphic"
		size = 129
		refs = "0010 TClipboard.Open 0018 TClipboard.AssignGraphic 0026 TClipboard.Adding 004a SetClipboardData 0070 TClipboard.Close 0076 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 8B DA 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 33 C0 89 45 F0 8D 45 F0 50 8D 4D F8 8D 55 F6 8B C3 8B 18 FF 53 5C 8B 45 F8 50 0F B7 45 F6 50 E8 ?? ?? ?? ?? 83 7D F0 00 74 0B 8B 45 F0 50 6A 09 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2241_0 {
	meta:
		name = "TClipboard.Assign"
		size = 75
		refs = "000a _Dn_TPicture 000f @IsClass 001c TClipboard.AssignPicture 0027 _Dn_TGraphic 0039 TClipboard.AssignGraphic 0044 TPersistent.Assign"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0C 8B D3 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0B 8B D3 8B C6 E8 ?? ?? ?? ?? EB 09 8B D3 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2242_0 {
	meta:
		name = "TClipboard.GetAsHandle"
		size = 83
		refs = "0010 TClipboard.Open 0018 TClipboard.GetAsHandle 0027 GetClipboardData 003f TClipboard.Close 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 8B DA 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 0F B7 C3 50 E8 ?? ?? ?? ?? 89 45 F8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 F8 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_2243_0 {
	meta:
		name = "TClipboard.SetAsHandle"
		size = 87
		refs = "0011 TClipboard.Open 0019 TClipboard.SetAsHandle 0027 TClipboard.Adding 0031 SetClipboardData 0046 TClipboard.Close 004c @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 8B F1 8B DA 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 56 0F B7 C3 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2245_0 {
	meta:
		name = "TClipboard.GetFormats"
		size = 106
		refs = "0010 TClipboard.Open 0018 TClipboard.GetFormats 0025 EnumClipboardFormats 0055 TClipboard.Close 005b @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 8B DA 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 6A 00 E8 ?? ?? ?? ?? 66 89 45 FA 85 DB 7E 13 4B 0F B7 45 FA 50 E8 ?? ?? ?? ?? 66 89 45 FA 85 DB 7F ED 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 66 8B 45 FA 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_2246_0 {
	meta:
		name = "HasAPicture"
		size = 125
		refs = "000c TClipboard.Open 0014 HasAPicture 0025 EnumClipboardFormats 0033 _Dn_TPicture 0038 TPicture.SupportsClipboardFormat 006a TClipboard.Close 0070 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C6 45 FF 00 6A 00 E8 ?? ?? ?? ?? 8B D8 66 85 DB 74 26 8B D3 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 06 C6 45 FF 01 EB 10 0F B7 C3 50 E8 ?? ?? ?? ?? 8B D8 66 85 DB 75 DA 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 8A 45 FF 5B 59 5D C3 }
	condition:
		$1
}

rule function_2247_0 {
	meta:
		name = "TClipboard.HasFormat"
		size = 53
		refs = "000f IsClipboardFormatAvailable 001a CF_PICTURE 0022 HasAPicture"
	strings:
		$1 = { 55 8B EC 51 53 8B DA 89 45 FC 0F B7 C3 50 E8 ?? ?? ?? ?? 85 C0 75 18 66 3B 1D ?? ?? ?? ?? 75 0B 55 E8 ?? ?? ?? ?? 59 84 C0 75 04 33 C0 EB 02 B0 01 5B 59 5D C3 }
	condition:
		$1
}

rule function_2248_0 {
	meta:
		name = "Clipboard"
		size = 32
		refs = "0002 FClipboard 000c _DV_TClipboard 0011 TObject.Create"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 11 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_3931_0 {
	meta:
		name = "ComClassManager"
		size = 32
		refs = "0002 ComClassManagerVar 000c _DV_TComClassManager 0011 TComClassManager.Create"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 11 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_9377_0 {
	meta:
		name = "GetClipboardFormats"
		size = 32
		refs = "0002 ClipboardFormats 000c _DV_TClipboardFormats 0011 TClipboardFormats.Create"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 11 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_9376_0 {
	meta:
		name = "GetFileFormats"
		size = 32
		refs = "0002 FileFormats 000c _DV_TFileFormatsList 0011 TFileFormatsList.Create"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 11 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_15320_0 {
	meta:
		name = "Printer"
		size = 32
		refs = "0002 FPrinter 000c _DV_TPrinter 0011 TPrinter.Create"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 11 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_16313_0 {
	meta:
		name = "QRPrinter"
		size = 32
		refs = "0002 FQRPrinter 000c _DV_TQRPrinter 0011 TQRPrinter.Create"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 11 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2249_0 {
	meta:
		name = "SetClipboard"
		size = 14
		refs = "0002 FClipboard"
	strings:
		$1 = { 8B 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8B C2 C3 }
	condition:
		$1
}

rule function_15321_0 {
	meta:
		name = "SetPrinter"
		size = 14
		refs = "0002 FPrinter"
	strings:
		$1 = { 8B 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8B C2 C3 }
	condition:
		$1
}

rule function_2250_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_2 001a FClipboard 001f TObject.Free 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_6809_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_2 001a InputReqClass 001f TObject.Free 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10098_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_4 001a CoderCollective 001f TObject.Free 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_15322_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a FPrinter 001f TObject.Free 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_15532_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_1 001a MethodNumbers 001f TObject.Free 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_16038_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_51 001a QRFunctionLibrary 001f TObject.Free 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_2251_0 {
	meta:
		name = "Clipbrd"
		size = 88
		refs = "0002 _DV_2 000a Clipbrd 000f RegisterClipboardFormat 0015 CF_PICTURE 0025 CF_COMPONENT 002c FClipboard"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 27 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 66 A3 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 66 A3 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? C3 00 00 00 44 65 6C 70 68 69 20 50 69 63 74 75 72 65 00 00 44 65 6C 70 68 69 20 43 6F 6D 70 6F 6E 65 6E 74 00 00 00 00 }
	condition:
		$1
}

rule function_2252_0 {
	meta:
		name = "TColorGrid.Create"
		size = 204
		refs = "000e @ClassCreate 001c TCustomControl.Create 0021 TColorGrid.Create 005c TControl.SetColor 006c TBrush.SetStyle 007c TPen.SetColor 00a0 GetStockObject 00a6 GetPaletteEntries 00b3 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B D8 33 D2 8B C3 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 0B 43 40 89 43 40 C6 83 64 02 00 00 02 C7 83 5C 02 00 00 04 00 00 00 C7 83 60 02 00 00 04 00 00 00 C6 83 4C 02 00 00 01 C6 83 4D 02 00 00 01 BA 0F 00 00 80 8B C3 E8 ?? ?? ?? ?? 8B 83 EC 01 00 00 8B 40 14 33 D2 E8 ?? ?? ?? ?? 8B 83 EC 01 00 00 8B 40 10 33 D2 E8 ?? ?? ?? ?? 6A 64 6A 64 33 C9 33 D2 8B C3 8B 30 FF 96 80 00 00 00 8D 83 F0 01 00 00 50 6A 14 6A 00 6A 0F E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B C3 80 7D FF 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5E 5B 59 5D C3 40 00 00 00 }
	condition:
		$1
}

rule function_2253_0 {
	meta:
		name = "TColorGrid.ColorToIndex"
		size = 83
		refs = "0014 ColorToRGB 002c RGB"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 89 14 24 8B E8 33 FF 33 DB 8B 04 24 E8 ?? ?? ?? ?? 89 44 24 04 8D B4 9D F0 01 00 00 8A 4E 02 8A 56 01 8A 06 E8 ?? ?? ?? ?? 3B 44 24 04 74 14 83 FB 07 74 03 43 EB 03 83 C3 05 47 83 FB 14 7C D5 83 CF FF 8B C7 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2254_0 {
	meta:
		name = "TColorGrid.CreateWnd"
		size = 48
		refs = "0006 TWinControl.CreateWnd 000f TWinControl.GetHandle 0015 GetWindowLong 002a SetWindowLong"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 6A F0 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 0D 00 00 00 04 50 6A F0 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2255_0 {
	meta:
		name = "TColorGrid.DrawSquare"
		size = 518
		refs = "0064 Bounds 0080 TPen.SetColor 009d TCanvas.Rectangle 00ab InflateRect 00c6 Frame3D 00ee RGB 00fe TBrush.SetColor 0190 TCanvas.GetHandle 0196 DrawFocusRect 01b2 TPen.SetMode"
	strings:
		$1 = { 53 56 57 55 83 C4 EC 88 0C 24 8B CA 8B D8 85 C9 0F 8C E8 01 00 00 83 F9 0F 0F 8F DF 01 00 00 83 F9 08 7D 04 8B F1 EB 03 8D 71 04 8B C1 8B AB 5C 02 00 00 99 F7 FD 8B F8 0F AF BB 58 02 00 00 8B C1 99 F7 FD 0F AF 93 54 02 00 00 8B EA 8B 83 58 02 00 00 50 8D 44 24 08 50 8B 8B 54 02 00 00 8B D7 8B C5 E8 ?? ?? ?? ?? 80 BB 2C 01 00 00 00 74 5B 8B 83 EC 01 00 00 8B 40 10 BA 0F 00 00 80 E8 ?? ?? ?? ?? 8B 44 24 0C 50 8B 44 24 14 50 8B 4C 24 10 8B 54 24 0C 8B 83 EC 01 00 00 E8 ?? ?? ?? ?? 6A FF 6A FF 8D 44 24 0C 50 E8 ?? ?? ?? ?? 68 14 00 00 80 6A 02 8D 54 24 0C B9 10 00 00 80 8B 83 EC 01 00 00 E8 ?? ?? ?? ?? EB 10 8B 83 EC 01 00 00 8B 40 10 33 D2 E8 ?? ?? ?? ?? 8D 84 B3 F0 01 00 00 8B F0 8A 4E 02 8A 56 01 8A 06 E8 ?? ?? ?? ?? 8B D0 8B 83 EC 01 00 00 8B 40 14 E8 ?? ?? ?? ?? 80 BB 2C 01 00 00 00 74 1D 8A 4E 02 8A 56 01 8A 06 E8 ?? ?? ?? ?? 8B D0 8B 83 EC 01 00 00 8B 40 10 E8 ?? ?? ?? ?? 80 3C 24 00 75 22 8B 44 24 0C 50 8B 44 24 14 50 8B 4C 24 10 8B 54 24 0C 8B 83 EC 01 00 00 E8 ?? ?? ?? ?? E9 AE 00 00 00 80 BB 2C 01 00 00 00 74 43 8B 44 24 0C 50 8B 44 24 14 50 8B 4C 24 10 8B 54 24 0C 8B 83 EC 01 00 00 E8 ?? ?? ?? ?? 6A FF 6A FF 8D 44 24 0C 50 E8 ?? ?? ?? ?? 8D 44 24 04 50 8B 83 EC 01 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? EB 62 8B 9B EC 01 00 00 8B 43 10 33 D2 E8 ?? ?? ?? ?? 8B 43 10 B2 03 E8 ?? ?? ?? ?? 8B 44 24 0C 50 8B 44 24 14 50 8B 4C 24 10 8B 54 24 0C 8B C3 E8 ?? ?? ?? ?? 8B 43 10 B2 04 E8 ?? ?? ?? ?? 8B 44 24 0C 83 E8 02 50 8B 44 24 14 83 E8 02 50 8B 4C 24 10 83 C1 02 8B 54 24 0C 83 C2 02 8B C3 E8 ?? ?? ?? ?? 83 C4 14 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2256_0 {
	meta:
		name = "TernaryOp"
		size = 10
	strings:
		$1 = { 84 C0 74 03 8B C2 C3 8B C1 C3 }
	condition:
		$1
}

rule function_2257_0 {
	meta:
		name = "TColorGrid.DrawFgBg"
		size = 675
		refs = "0014 TColorGrid.DrawFgBg 0027 TCanvas.GetHandle 002d SetBkMode 005b SFB 0060 LoadResString 006a SFG 009a TernaryOp 00d7 RGB 00e7 TFont.SetColor 013a @LStrToPChar 014c DrawText 0187 SBG 0290 @LStrClr 0296 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 56 57 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 6A 01 8B 83 EC 01 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B F0 80 BB 4C 02 00 00 00 0F 84 10 01 00 00 8B 83 44 02 00 00 3B 83 48 02 00 00 75 18 80 BB 4D 02 00 00 00 74 0F 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 0D 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 83 44 02 00 00 83 F8 08 7C 03 83 C0 04 8B 84 83 F0 01 00 00 89 45 FC 80 7D FC 80 0F 93 C0 B9 FF 00 00 00 33 D2 E8 ?? ?? ?? ?? 88 45 FC 80 7D FD 80 0F 93 C0 B9 FF 00 00 00 33 D2 E8 ?? ?? ?? ?? 88 45 FD 80 7D FE 80 0F 93 C0 B9 FF 00 00 00 33 D2 E8 ?? ?? ?? ?? 88 45 FE 8A 4D FE 8A 55 FD 8A 45 FC E8 ?? ?? ?? ?? 8B D0 8B 83 EC 01 00 00 8B 40 0C E8 ?? ?? ?? ?? 8B 83 44 02 00 00 99 F7 BB 5C 02 00 00 8B CA 8B BB 54 02 00 00 0F AF CF 89 4D E8 03 CF 89 4D F0 8B 83 44 02 00 00 99 F7 BB 5C 02 00 00 8B C8 8B BB 58 02 00 00 0F AF CF 89 4D EC 03 CF 89 4D F4 68 25 01 00 00 8D 45 E8 50 6A FF 8B 45 F8 E8 ?? ?? ?? ?? 50 8B 83 EC 01 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 80 BB 4D 02 00 00 00 0F 84 10 01 00 00 8B 83 44 02 00 00 3B 83 48 02 00 00 75 18 80 BB 4C 02 00 00 00 74 0F 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 0D 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 83 48 02 00 00 83 F8 08 7C 03 83 C0 04 8B 84 83 F0 01 00 00 89 45 FC 80 7D FC 80 0F 93 C0 B9 FF 00 00 00 33 D2 E8 ?? ?? ?? ?? 88 45 FC 80 7D FD 80 0F 93 C0 B9 FF 00 00 00 33 D2 E8 ?? ?? ?? ?? 88 45 FD 80 7D FE 80 0F 93 C0 B9 FF 00 00 00 33 D2 E8 ?? ?? ?? ?? 88 45 FE 8A 4D FE 8A 55 FD 8A 45 FC E8 ?? ?? ?? ?? 8B D0 8B 83 EC 01 00 00 8B 40 0C E8 ?? ?? ?? ?? 8B 83 48 02 00 00 99 F7 BB 5C 02 00 00 8B CA 8B BB 54 02 00 00 0F AF CF 89 4D E8 03 CF 89 4D F0 8B 83 48 02 00 00 99 F7 BB 5C 02 00 00 8B C8 8B BB 58 02 00 00 0F AF CF 89 4D EC 03 CF 89 4D F4 68 25 01 00 00 8D 45 E8 50 6A FF 8B 45 F8 E8 ?? ?? ?? ?? 50 8B 83 EC 01 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 56 8B 83 EC 01 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2258_0 {
	meta:
		name = "TColorGrid.EnableForeground"
		size = 68
		refs = "0037 TColorGrid.DrawSquare 003e TColorGrid.DrawFgBg"
	strings:
		$1 = { 53 8B D8 3A 93 4C 02 00 00 74 37 88 93 4C 02 00 00 8B 83 44 02 00 00 3B 83 50 02 00 00 75 09 80 BB 65 02 00 00 00 75 04 33 C9 EB 02 B1 01 8B 93 44 02 00 00 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2259_0 {
	meta:
		name = "TColorGrid.EnableBackground"
		size = 68
		refs = "0037 TColorGrid.DrawSquare 003e TColorGrid.DrawFgBg"
	strings:
		$1 = { 53 8B D8 3A 93 4D 02 00 00 74 37 88 93 4D 02 00 00 8B 83 48 02 00 00 3B 83 50 02 00 00 75 09 80 BB 65 02 00 00 00 75 04 33 C9 EB 02 B1 01 8B 93 48 02 00 00 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2260_0 {
	meta:
		name = "TColorGrid.GetForegroundColor"
		size = 37
		refs = "001f RGB"
	strings:
		$1 = { 53 8B 90 44 02 00 00 83 FA 08 7C 03 83 C2 04 8D 9C 90 F0 01 00 00 8A 4B 02 8A 53 01 8A 03 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2261_0 {
	meta:
		name = "TColorGrid.GetBackgroundColor"
		size = 37
		refs = "001f RGB"
	strings:
		$1 = { 53 8B 90 48 02 00 00 83 FA 08 7C 03 83 C2 04 8D 9C 90 F0 01 00 00 8A 4B 02 8A 53 01 8A 03 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2262_0 {
	meta:
		name = "TColorGrid.WMSetFocus"
		size = 47
		refs = "0018 TColorGrid.DrawSquare 001f TColorGrid.DrawFgBg 0028 TWinControl.WMSetFocus"
	strings:
		$1 = { 53 56 8B F2 8B D8 C6 83 65 02 00 00 01 B1 01 8B 93 50 02 00 00 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2263_0 {
	meta:
		name = "TColorGrid.WMKillFocus"
		size = 47
		refs = "0018 TColorGrid.DrawSquare 001f TColorGrid.DrawFgBg 0028 TWinControl.WMKillFocus"
	strings:
		$1 = { 53 56 8B F2 8B D8 C6 83 65 02 00 00 00 33 C9 8B 93 50 02 00 00 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2264_0 {
	meta:
		name = "TColorGrid.KeyDown"
		size = 520
		refs = "0014 TWinControl.KeyDown 004c TColorGrid.KeyDown 00d7 TColorGrid.DrawSquare 00ea TColorGrid.SetForegroundIndex 00f3 TColorGrid.SetSelection 00fe @CallDynaInst 0159 TColorGrid.SetBackgroundIndex"
	strings:
		$1 = { 53 56 57 55 51 88 0C 24 8B EA 8B F0 8B D5 8A 0C 24 8B C6 E8 ?? ?? ?? ?? 8B 8E 50 02 00 00 8B F9 8B 9E 5C 02 00 00 8B C3 F7 AE 60 02 00 00 0F B7 55 00 83 FA 27 7F 35 0F 84 8D 01 00 00 83 C2 E0 83 FA 06 0F 87 94 01 00 00 FF 24 95 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 83 FA 46 7F 19 74 25 83 EA 28 0F 84 25 01 00 00 83 EA 1A 0F 84 82 00 00 00 E9 53 01 00 00 83 EA 62 74 78 83 EA 04 0F 85 45 01 00 00 80 BE 4C 02 00 00 00 75 44 80 BE 40 02 00 00 00 74 3B C6 86 4C 02 00 00 01 8B 86 44 02 00 00 3B 86 50 02 00 00 75 09 80 BE 65 02 00 00 00 75 04 33 C9 EB 02 B1 01 8B 96 44 02 00 00 8B C6 E8 ?? ?? ?? ?? C7 86 44 02 00 00 FF FF FF FF 8B D7 8B C6 E8 ?? ?? ?? ?? 8B D7 8B C6 E8 ?? ?? ?? ?? 8B C6 66 BB EC FF E8 ?? ?? ?? ?? E9 E4 00 00 00 80 BE 4D 02 00 00 00 75 44 80 BE 40 02 00 00 00 74 3B C6 86 4D 02 00 00 01 8B 86 48 02 00 00 3B 86 50 02 00 00 75 09 80 BE 65 02 00 00 00 75 04 33 C9 EB 02 B1 01 8B 96 48 02 00 00 8B C6 E8 ?? ?? ?? ?? C7 86 48 02 00 00 FF FF FF FF 8B D7 8B C6 E8 ?? ?? ?? ?? 8B D7 8B C6 E8 ?? ?? ?? ?? 8B C6 66 BB EC FF E8 ?? ?? ?? ?? EB 78 33 FF EB 74 3B D9 7F 06 8B F9 2B FB EB 6A 85 C9 74 09 8B F8 2B FB 03 F9 4F EB 5D 8B F8 4F EB 58 85 C9 74 05 8B F9 4F EB 4F 8B F8 4F EB 4A 8B D1 03 D3 3B C2 7E 0E 8B BE 50 02 00 00 03 BE 5C 02 00 00 EB 34 48 3B C8 74 0A 8B C1 99 F7 FB 8B FA 47 EB 25 33 FF EB 21 48 3B C8 74 05 8B F9 47 EB 17 33 FF EB 13 8B F8 4F EB 0E 8B D5 8A 0C 24 8B C6 E8 ?? ?? ?? ?? EB 17 66 C7 45 00 00 00 3B BE 50 02 00 00 74 09 8B D7 8B C6 E8 ?? ?? ?? ?? 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2265_0 {
	meta:
		name = "TColorGrid.WMGetDlgCode"
		size = 8
		altNames = "TDBCtrlGrid.WMGetDlgCode TDBLookupControl.WMGetDlgCode"
	strings:
		$1 = { C7 42 0C 81 00 00 00 C3 }
	condition:
		$1
}

rule function_2266_0 {
	meta:
		name = "TColorGrid.WMSize"
		size = 21
		refs = "0006 TWinControl.WMSize 000f TColorGrid.UpdateCellSizes"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_17494_0 {
	meta:
		name = "TCustomMemo.Loaded"
		size = 21
		refs = "0006 TControl.Loaded 000f TCustomEdit.SetModified"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2793_0 {
	meta:
		name = "TCustomRichEdit.Clear"
		size = 21
		refs = "0006 TCustomEdit.Clear 000f TCustomEdit.SetModified"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_6455_0 {
	meta:
		name = "TDBLookupComboBox.CMFontChanged"
		size = 21
		refs = "0006 TWinControl.CMFontChanged 000f TControl.SetHeight"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_7099_0 {
	meta:
		name = "TDatabase.Commit"
		size = 21
		refs = "0006 TDatabase.CheckActive 000f TDatabase.EndTransaction"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_14326_0 {
	meta:
		name = "TOleContainer.WMKillFocus"
		size = 21
		refs = "0006 TWinControl.WMKillFocus 000f TOleContainer.SetFocused"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2268_0 {
	meta:
		name = "TColorGrid.MouseDown"
		size = 284
		refs = "001e TControl.MouseDown 0037 TColorGrid.SquareFromPos 0080 TColorGrid.DrawSquare 0093 TColorGrid.SetForegroundIndex 009e TControl.SetMouseCapture 00f4 TColorGrid.SetBackgroundIndex 00fd TColorGrid.SetSelection"
	strings:
		$1 = { 55 8B EC 51 53 56 57 88 4D FF 8B DA 8B F8 8B 75 0C 56 8B 45 08 50 8A 4D FF 8B D3 8B C7 E8 ?? ?? ?? ?? 88 9F 70 02 00 00 C6 87 71 02 00 00 01 8B 4D 08 8B D6 8B C7 E8 ?? ?? ?? ?? 8B F0 84 DB 75 58 80 BF 4C 02 00 00 00 75 44 80 BF 40 02 00 00 00 74 3B C6 87 4C 02 00 00 01 8B 87 44 02 00 00 3B 87 50 02 00 00 75 09 80 BF 65 02 00 00 00 75 04 33 C9 EB 02 B1 01 8B 97 44 02 00 00 8B C7 E8 ?? ?? ?? ?? C7 87 44 02 00 00 FF FF FF FF 8B D6 8B C7 E8 ?? ?? ?? ?? EB 5F B2 01 8B C7 E8 ?? ?? ?? ?? 80 BF 4D 02 00 00 00 75 44 80 BF 40 02 00 00 00 74 3B C6 87 4D 02 00 00 01 8B 87 48 02 00 00 3B 87 50 02 00 00 75 09 80 BF 65 02 00 00 00 75 04 33 C9 EB 02 B1 01 8B 97 48 02 00 00 8B C7 E8 ?? ?? ?? ?? C7 87 48 02 00 00 FF FF FF FF 8B D6 8B C7 E8 ?? ?? ?? ?? 8B D6 8B C7 E8 ?? ?? ?? ?? 80 BF 78 01 00 00 00 74 0A 8B C7 8B 10 FF 92 B4 00 00 00 5F 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_2269_0 {
	meta:
		name = "TColorGrid.MouseMove"
		size = 98
		refs = "001a TControl.MouseMove 002e TColorGrid.SquareFromPos 0042 TColorGrid.SetForegroundIndex 004d TColorGrid.SetBackgroundIndex 0056 TColorGrid.SetSelection"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B F1 88 55 FF 8B D8 8B 7D 08 57 8B CE 8A 55 FF 8B C3 E8 ?? ?? ?? ?? 80 BB 71 02 00 00 00 74 33 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 8B F0 80 BB 70 02 00 00 00 75 0B 8B D6 8B C3 E8 ?? ?? ?? ?? EB 09 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_2270_0 {
	meta:
		name = "TColorGrid.MouseUp"
		size = 72
		refs = "0019 TControl.MouseUp 0032 TControl.SetMouseCapture 003d @CallDynaInst"
	strings:
		$1 = { 55 8B EC 51 53 56 88 4D FF 8B F0 8B 45 0C 50 8B 45 08 50 8A 4D FF 8B C6 E8 ?? ?? ?? ?? C6 86 71 02 00 00 00 80 BE 70 02 00 00 01 75 14 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 66 BB EC FF E8 ?? ?? ?? ?? 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_2271_0 {
	meta:
		name = "TColorGrid.Paint"
		size = 113
		refs = "0011 TCanvas.SetFont 0043 TColorGrid.DrawSquare 0067 TColorGrid.DrawFgBg"
	strings:
		$1 = { 53 56 57 55 51 8B D8 8B 53 58 8B 83 EC 01 00 00 E8 ?? ?? ?? ?? 8B 83 60 02 00 00 85 C0 7C 32 40 89 04 24 33 ED 8B B3 5C 02 00 00 85 F6 7C 1C 46 33 FF 8B C5 F7 AB 5C 02 00 00 03 C7 33 C9 8B D0 8B C3 E8 ?? ?? ?? ?? 47 4E 75 E7 45 FF 0C 24 75 D4 8A 8B 65 02 00 00 8B 93 50 02 00 00 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2272_0 {
	meta:
		name = "TColorGrid.SetBackgroundIndex"
		size = 138
		refs = "003b TColorGrid.DrawSquare 0078 TColorGrid.DrawFgBg 0083 @CallDynaInst"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 83 48 02 00 00 3B F0 74 77 80 BB 4D 02 00 00 00 74 6E 8B 93 48 02 00 00 3B 93 50 02 00 00 75 09 80 BB 65 02 00 00 00 75 04 33 C9 EB 02 B1 01 8B D0 8B C3 E8 ?? ?? ?? ?? 8B C6 89 83 48 02 00 00 3B 83 44 02 00 00 75 26 8B 93 48 02 00 00 3B 93 50 02 00 00 75 09 80 BB 65 02 00 00 00 75 04 33 C9 EB 02 B1 01 8B D0 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B C3 66 BB B8 FF E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2273_0 {
	meta:
		name = "TColorGrid.SetForegroundIndex"
		size = 138
		refs = "003b TColorGrid.DrawSquare 0078 TColorGrid.DrawFgBg 0083 @CallDynaInst"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 83 44 02 00 00 3B F0 74 77 80 BB 4C 02 00 00 00 74 6E 8B 93 44 02 00 00 3B 93 50 02 00 00 75 09 80 BB 65 02 00 00 00 75 04 33 C9 EB 02 B1 01 8B D0 8B C3 E8 ?? ?? ?? ?? 8B C6 89 83 44 02 00 00 3B 83 48 02 00 00 75 26 8B 93 44 02 00 00 3B 93 50 02 00 00 75 09 80 BB 65 02 00 00 00 75 04 33 C9 EB 02 B1 01 8B D0 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B C3 66 BB B8 FF E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2274_0 {
	meta:
		name = "TColorGrid.SetGridOrdering"
		size = 60
		refs = "0036 TColorGrid.UpdateCellSizes"
	strings:
		$1 = { 53 3A 90 64 02 00 00 74 31 8B DA 88 98 64 02 00 00 8B CB BA 10 00 00 00 D3 EA 89 90 5C 02 00 00 8A 88 64 02 00 00 BA 01 00 00 00 D3 E2 89 90 60 02 00 00 B2 01 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2275_0 {
	meta:
		name = "TColorGrid.SetSelection"
		size = 60
		refs = "0017 TColorGrid.DrawSquare 0035 TColorGrid.DrawFgBg"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 83 50 02 00 00 3B F0 74 29 33 C9 8B D0 8B C3 E8 ?? ?? ?? ?? 8B C6 89 83 50 02 00 00 8A 8B 65 02 00 00 8B D0 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2276_0 {
	meta:
		name = "TColorGrid.SquareFromPos"
		size = 76
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 43 38 48 3B F0 7E 04 8B F0 EB 06 85 F6 7D 02 33 F6 8B 43 3C 48 3B C8 7E 04 8B C8 EB 06 85 C9 7D 02 33 C9 8B C1 99 F7 BB 58 02 00 00 8B C8 0F AF 8B 5C 02 00 00 8B C6 99 F7 BB 54 02 00 00 03 C8 8B C1 5E 5B C3 }
	condition:
		$1
}

rule function_2277_0 {
	meta:
		name = "TColorGrid.UpdateCellSizes"
		size = 124
		refs = "003c Bounds 0045 TControl.SetBoundsRect"
	strings:
		$1 = { 53 56 57 55 83 C4 F0 8B DA 8B E8 8B 45 38 8B 8D 5C 02 00 00 99 F7 F9 8B F0 0F AF F1 8B 45 3C 8B 8D 60 02 00 00 99 F7 F9 8B F8 0F AF F9 57 8D 44 24 04 50 8B CE 8B 55 34 8B 45 30 E8 ?? ?? ?? ?? 8B D4 8B C5 E8 ?? ?? ?? ?? 8B 45 38 99 F7 BD 5C 02 00 00 89 85 54 02 00 00 8B 45 3C 99 F7 BD 60 02 00 00 89 85 58 02 00 00 84 DB 74 07 8B C5 8B 10 FF 52 78 83 C4 10 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2278_0 {
	meta:
		name = "TColorGrid.Change"
		size = 36
		refs = "0006 TControl.Changed"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 66 83 BB 6A 02 00 00 00 74 0E 8B D3 8B 83 6C 02 00 00 FF 93 68 02 00 00 5B C3 }
	condition:
		$1
}

rule function_2283_0 {
	meta:
		name = "TCorbaComObjectFactory.Create"
		size = 85
		refs = "000d @ClassCreate 002e TCorbaFactory.Create 003f @AfterConstruction"
		altNames = "TCorbaObjectFactory.Create"
	strings:
		$1 = { 55 8B EC 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 45 1C 50 8B 45 18 50 8B 45 14 50 8A 45 0C 50 8A 45 08 50 33 D2 8B C6 E8 ?? ?? ?? ?? 8B 45 10 89 46 3C 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 5D C2 18 00 }
	condition:
		$1
}

rule function_2284_0 {
	meta:
		name = "TCorbaComObjectFactory.CreateInterface"
		size = 35
		refs = "000c TComObject.Create 001c @IntfCopy"
	strings:
		$1 = { 53 56 8B F1 8B D8 B2 01 8B 43 3C E8 ?? ?? ?? ?? 8B D0 85 D2 74 03 83 EA E4 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2291_0 {
	meta:
		name = "_NF__8FE"
		size = 12
	strings:
		$1 = { FF FF FF FF 03 00 00 00 72 74 66 00 }
	condition:
		$1
}

rule function_2292_0 {
	meta:
		name = "_NF__900"
		size = 12
	strings:
		$1 = { FF FF FF FF 03 00 00 00 74 78 74 00 }
	condition:
		$1
}

rule function_2293_0 {
	meta:
		name = "InitCommonControl"
		size = 43
		refs = "0012 InitCommonControlsEx 0021 InitCommonControls"
	strings:
		$1 = { 53 83 C4 F8 C7 04 24 08 00 00 00 89 44 24 04 8B C4 E8 ?? ?? ?? ?? F7 D8 1B DB F7 DB 84 DB 75 05 E8 ?? ?? ?? ?? 8B C3 59 5A 5B C3 }
	condition:
		$1
}

rule function_2294_0 {
	meta:
		name = "CheckCommonControl"
		size = 99
		refs = "000c CheckCommonControl 0019 InitCommonControl 0025 sInvalidComCtl32 002a LoadResString 0034 _Dn_EComponentError 0039 Exception.Create 003e @RaiseExcept 0053 @LStrClr 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 84 C0 75 21 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_2295_0 {
	meta:
		name = "GetShellModule"
		size = 112
		refs = "0003 ShellModule 0010 SetErrorMode 0017 GetShellModule 001c GetModuleHandle 0034 LoadLibrary"
	strings:
		$1 = { 53 83 3D ?? ?? ?? ?? 00 75 52 68 00 80 00 00 E8 ?? ?? ?? ?? 8B D8 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 20 73 0F 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 76 10 83 3D ?? ?? ?? ?? 20 73 07 33 C0 A3 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 5B C3 00 73 68 65 6C 6C 33 32 2E 64 6C 6C 00 }
	condition:
		$1
}

rule function_2296_0 {
	meta:
		name = "GetComCtlVersion"
		size = 260
		refs = "0011 GetComCtlVersion 001d ComCtlVersion 0031 @LStrLAsg 003d @LStrToPChar 0045 GetFileVersionInfoSize 0052 @GetMem 0072 GetFileVersionInfo 008c VerQueryValue 00b0 @FreeMem 00b6 @HandleFinally 00d3 @LStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 33 C0 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 3D ?? ?? ?? ?? 00 0F 85 94 00 00 00 8D 45 FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 F8 50 8B 45 FC E8 ?? ?? ?? ?? 8B F0 56 E8 ?? ?? ?? ?? 8B D8 85 DB 74 6D 8B C3 E8 ?? ?? ?? ?? 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F4 50 53 8B 45 F8 50 56 E8 ?? ?? ?? ?? 85 C0 74 25 8D 45 EC 50 8D 45 F0 50 68 ?? ?? ?? ?? 8B 45 F4 50 E8 ?? ?? ?? ?? 85 C0 74 0B 8B 45 F0 8B 40 08 A3 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 1D ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 8B E5 5D C3 00 FF FF FF FF 0C 00 00 00 63 6F 6D 63 74 6C 33 32 2E 64 6C 6C 00 00 00 00 5C 00 00 00 }
	condition:
		$1
}

rule function_2297_0 {
	meta:
		name = "CheckToolMenuDropdown"
		size = 16
		refs = "000a @CallDynaInst"
	strings:
		$1 = { 53 85 C0 74 09 66 BB CE FF E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2298_0 {
	meta:
		name = "SetComCtlStyle"
		size = 71
		refs = "000d TWinControl.HandleAllocated 001a TWinControl.GetHandle 0020 GetWindowLong 003e SetWindowLong"
	strings:
		$1 = { 53 56 57 55 8B D9 8B FA 8B E8 8B C5 E8 ?? ?? ?? ?? 84 C0 74 2D 6A F0 8B C5 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B F0 84 DB 75 06 F7 D7 23 F7 EB 02 0B F7 56 6A F0 8B C5 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2300_0 {
	meta:
		name = "TTabStrings.Clear"
		size = 111
		refs = "000c TTabStrings.Clear 0023 TWinControl.GetHandle 0029 SendMessage 0035 sTabFailClear 003a LoadResString 0042 TabControlError 004a TCustomTabControl.TabsChanged 005f @LStrClr 0065 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 6A 00 6A 00 68 09 13 00 00 8B 43 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 75 15 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_2301_0 {
	meta:
		name = "TTabStrings.Delete"
		size = 153
		refs = "0018 TTabStrings.Delete 002e TWinControl.GetHandle 0034 SendMessage 0044 sTabFailDelete 0049 LoadResString 005d Format 0065 TabControlError 006d TCustomTabControl.TabsChanged 0087 @LStrArrayClr 008d @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 33 C9 89 4D FC 89 4D F8 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 6A 00 56 68 08 13 00 00 8B 43 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 75 2D 8D 45 FC 50 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F8 89 75 F0 C6 45 F4 00 8D 55 F0 33 C9 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2302_0 {
	meta:
		name = "TTabStrings.Get"
		size = 246
		refs = "0028 TTabStrings.Get 0036 TControl.UseRightToLeftReading 0040 RTL 0068 TWinControl.GetHandle 006e SendMessage 0084 sTabFailRetrieve 0089 LoadResString 00a9 Format 00b4 TabControlError 00c6 @LStrFromArray 00e3 @LStrArrayClr 00e9 @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 04 F0 FF FF 50 83 C4 D4 53 56 57 33 DB 89 9D E0 EF FF FF 89 9D DC EF FF FF 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 43 0C E8 ?? ?? ?? ?? 83 E0 7F 8B 04 85 ?? ?? ?? ?? 83 C8 01 89 45 E4 8D 85 E4 EF FF FF 89 45 F0 C7 45 F4 00 10 00 00 8D 45 E4 50 56 68 05 13 00 00 8B 43 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 75 42 8D 85 E0 EF FF FF 50 8D 95 DC EF FF FF A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 DC EF FF FF 89 B5 D4 EF FF FF C6 85 D8 EF FF FF 00 8D 95 D4 EF FF FF 33 C9 E8 ?? ?? ?? ?? 8B 85 E0 EF FF FF E8 ?? ?? ?? ?? 8B C7 8D 95 E4 EF FF FF B9 00 10 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 DC EF FF FF BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2303_0 {
	meta:
		name = "TTabStrings.GetCount"
		size = 28
		refs = "0010 TWinControl.GetHandle 0016 SendMessage"
	strings:
		$1 = { 53 8B D8 6A 00 6A 00 68 04 13 00 00 8B 43 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2304_0 {
	meta:
		name = "TTabStrings.GetObject"
		size = 159
		refs = "0018 TTabStrings.GetObject 0037 TWinControl.GetHandle 003d SendMessage 004d sTabFailGetObject 0052 LoadResString 0066 Format 006e TabControlError 008b @LStrArrayClr 0091 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 D4 53 56 33 C9 89 4D E0 89 4D DC 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C7 45 E4 08 00 00 00 8D 45 E4 50 56 68 05 13 00 00 8B 43 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 75 2D 8D 45 E0 50 8D 55 DC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 DC 89 75 D4 C6 45 D8 00 8D 55 D4 33 C9 E8 ?? ?? ?? ?? 8B 45 E0 E8 ?? ?? ?? ?? 8B 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 8B C3 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2305_0 {
	meta:
		name = "TTabStrings.Put"
		size = 224
		refs = "001b TTabStrings.Put 0029 TControl.UseRightToLeftReading 0033 RTL 0043 @LStrToPChar 0068 TWinControl.GetHandle 006e SendMessage 007e sTabFailSet 0083 LoadResString 00a3 Format 00ab TabControlError 00b3 TCustomTabControl.TabsChanged 00cd @LStrArrayClr 00d3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 CC 53 56 57 33 DB 89 5D E0 89 5D DC 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 43 0C E8 ?? ?? ?? ?? 83 E0 7F 8B 04 85 ?? ?? ?? ?? 83 C8 01 83 C8 02 89 45 E4 8B C7 E8 ?? ?? ?? ?? 89 45 F0 8B D6 8B 43 0C 8B 08 FF 91 C0 00 00 00 89 45 F8 8D 45 E4 50 56 68 06 13 00 00 8B 43 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 75 39 8D 45 E0 50 8D 55 DC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 DC 50 89 7D CC C6 45 D0 0B 89 75 D4 C6 45 D8 00 8D 55 CC B9 01 00 00 00 58 E8 ?? ?? ?? ?? 8B 45 E0 E8 ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2306_0 {
	meta:
		name = "TTabStrings.PutObject"
		size = 157
		refs = "0018 TTabStrings.PutObject 003a TWinControl.GetHandle 0040 SendMessage 0050 sTabFailSetObject 0055 LoadResString 0069 Format 0071 TabControlError 008b @LStrArrayClr 0091 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 D4 53 56 33 DB 89 5D E0 89 5D DC 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C7 45 E4 08 00 00 00 89 4D FC 8D 45 E4 50 56 68 06 13 00 00 8B 43 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 75 2D 8D 45 E0 50 8D 55 DC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 DC 89 75 D4 C6 45 D8 00 8D 55 D4 33 C9 E8 ?? ?? ?? ?? 8B 45 E0 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2307_0 {
	meta:
		name = "TTabStrings.Insert"
		size = 224
		refs = "001b TTabStrings.Insert 0029 TControl.UseRightToLeftReading 0033 RTL 0043 @LStrToPChar 0068 TWinControl.GetHandle 006e SendMessage 007e sTabFailSet 0083 LoadResString 00a3 Format 00ab TabControlError 00b3 TCustomTabControl.TabsChanged 00cd @LStrArrayClr 00d3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 CC 53 56 57 33 DB 89 5D E0 89 5D DC 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 43 0C E8 ?? ?? ?? ?? 83 E0 7F 8B 04 85 ?? ?? ?? ?? 83 C8 01 83 C8 02 89 45 E4 8B C7 E8 ?? ?? ?? ?? 89 45 F0 8B D6 8B 43 0C 8B 08 FF 91 C0 00 00 00 89 45 F8 8D 45 E4 50 56 68 07 13 00 00 8B 43 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 7D 39 8D 45 E0 50 8D 55 DC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 DC 50 89 7D CC C6 45 D0 0B 89 75 D4 C6 45 D8 00 8D 55 CC B9 01 00 00 00 58 E8 ?? ?? ?? ?? 8B 45 E0 E8 ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2308_0 {
	meta:
		name = "TTabStrings.SetUpdateState"
		size = 68
		refs = "001f TWinControl.GetHandle 0025 SendMessage 003c TCustomTabControl.TabsChanged"
	strings:
		$1 = { 53 56 57 8B DA 8B F0 8B 7E 0C 88 9F 14 02 00 00 6A 00 8B C3 34 01 83 E0 7F 50 6A 0B 8B C7 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 80 F3 01 84 DB 74 10 8B 46 0C 8B 10 FF 52 78 8B 46 0C E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2309_0 {
	meta:
		name = "TCustomTabControl.Create"
		size = 192
		refs = "000e @ClassCreate 001c TWinControl.Create 0028 TControl.SetWidth 0034 TControl.SetHeight 003d TWinControl.SetTabStop 0042 TCustomTabControl.Create 004c _DV_TTabStrings 0051 TObject.Create 0063 _Dn_TControlCanvas 0068 TCanvas.Create 0079 TControlCanvas.SetControl 0080 _Dn_TChangeLink 0097 TCustomTabControl.ImageListChange 00a4 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B D8 33 D2 8B C3 E8 ?? ?? ?? ?? BA 21 01 00 00 8B C3 E8 ?? ?? ?? ?? BA C1 00 00 00 8B C3 E8 ?? ?? ?? ?? B2 01 8B C3 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 43 40 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 0C 02 00 00 89 5E 0C B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 EC 01 00 00 8B D3 8B C6 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 F4 01 00 00 89 5E 0C C7 46 08 ?? ?? ?? ?? 8B C3 80 7D FF 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5E 5B 59 5D C3 00 00 00 81 00 00 00 }
	condition:
		$1
}

rule function_2310_0 {
	meta:
		name = "TCustomTabControl.Destroy"
		size = 81
		refs = "0003 @BeforeDestruction 0012 TObject.Free 003f TWinControl.Destroy 004a @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 86 EC 01 00 00 E8 ?? ?? ?? ?? 8B 86 0C 02 00 00 E8 ?? ?? ?? ?? 8B 86 04 02 00 00 E8 ?? ?? ?? ?? 8B 86 F4 01 00 00 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2311_0 {
	meta:
		name = "TCustomTabControl.CanChange"
		size = 40
	strings:
		$1 = { 53 51 C6 04 24 01 66 83 B8 22 02 00 00 00 74 12 8B CC 8B D8 8B D0 8B 83 24 02 00 00 FF 93 20 02 00 00 8A 04 24 5A 5B C3 }
	condition:
		$1
}

rule function_2313_0 {
	meta:
		name = "TCustomQuickRep.PrintFinished"
		size = 29
		altNames = "TCustomTabControl.Change"
	strings:
		$1 = { 53 66 83 B8 1A 02 00 00 00 74 10 8B D8 8B D0 8B 83 1C 02 00 00 FF 93 18 02 00 00 5B C3 }
	condition:
		$1
}

rule function_2314_0 {
	meta:
		name = "TCustomTabControl.CreateParams"
		size = 260
		refs = "000d InitCommonControl 0016 TWinControl.CreateParams 001b TCustomTabControl.CreateParams 0024 TWinControl.CreateSubClass 002f @CallDynaInst 003b AlignStyles 0060 TabStyles 006f RRStyles"
	strings:
		$1 = { 53 56 57 8B FA 8B F0 B8 08 00 00 00 E8 ?? ?? ?? ?? 8B D7 8B C6 E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? 8B D7 8B C6 E8 ?? ?? ?? ?? 8B C6 66 BB CF FF E8 ?? ?? ?? ?? 83 E0 7F 03 C0 8D 04 C5 ?? ?? ?? ?? 33 D2 8A 96 0A 02 00 00 8B 04 90 8B 57 04 81 CA 00 00 00 02 0B C2 33 D2 8A 96 09 02 00 00 0B 04 95 ?? ?? ?? ?? 33 D2 8A 96 FF 01 00 00 0B 04 95 ?? ?? ?? ?? 89 47 04 80 BE 78 01 00 00 00 75 07 81 4F 04 00 80 00 00 80 BE FC 01 00 00 00 74 07 81 4F 04 00 02 00 00 80 BE FD 01 00 00 00 74 04 83 4F 04 04 80 BE FE 01 00 00 00 74 07 81 4F 04 00 20 00 00 66 83 BE 10 02 00 00 00 74 07 81 4F 04 00 04 00 00 80 BE F0 01 00 00 00 74 0A F6 46 20 10 75 04 83 4F 04 40 80 BE 08 02 00 00 00 74 04 83 4F 04 01 8B 47 24 83 E0 FC 83 C8 08 89 47 24 5F 5E 5B C3 53 79 73 54 61 62 43 6F 6E 74 72 6F 6C 33 32 00 }
	condition:
		$1
}

rule function_2315_0 {
	meta:
		name = "TCustomTabControl.CreateWnd"
		size = 132
		refs = "0007 TWinControl.CreateWnd 0018 TCustomImageList.HandleAllocated 0027 TCustomImageList.GetHandle 0036 TControl.Perform 0046 TCustomTabControl.UpdateTabSize 006a TCustomTabControl.SetTabIndex 0075 TObject.Free"
	strings:
		$1 = { 53 56 8B D8 8B C3 E8 ?? ?? ?? ?? 8B B3 F8 01 00 00 85 F6 74 25 8B C6 E8 ?? ?? ?? ?? 84 C0 74 1A 8B 83 F8 01 00 00 E8 ?? ?? ?? ?? 50 33 C9 BA 03 13 00 00 8B C3 E8 ?? ?? ?? ?? 83 BB 10 02 00 00 00 74 07 8B C3 E8 ?? ?? ?? ?? 8B B3 04 02 00 00 85 F6 74 2D 8B D6 8B 83 0C 02 00 00 8B 08 FF 51 08 8B 93 00 02 00 00 8B C3 E8 ?? ?? ?? ?? 8B 83 04 02 00 00 E8 ?? ?? ?? ?? 33 C0 89 83 04 02 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_2316_0 {
	meta:
		name = "TCustomTabControl.DestroyWnd"
		size = 75
		refs = "0016 _Dn_TStringList 001b TObject.Create 0037 TCustomTabControl.GetTabIndex 0044 TWinControl.DestroyWnd"
	strings:
		$1 = { 53 56 8B D8 8B 83 0C 02 00 00 8B 10 FF 52 14 85 C0 7E 2E B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 04 02 00 00 8B 93 0C 02 00 00 8B C6 8B 08 FF 51 08 8B C3 E8 ?? ?? ?? ?? 89 83 00 02 00 00 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2317_0 {
	meta:
		name = "TCustomTabControl.DrawTab"
		size = 57
		refs = "0030 TCanvas.FillRect"
	strings:
		$1 = { 55 8B EC 53 66 83 B8 2A 02 00 00 00 74 19 51 8A 4D 08 51 8B D8 8B CA 8B D0 8B 83 2C 02 00 00 FF 93 28 02 00 00 EB 0D 8B D1 8B 80 EC 01 00 00 E8 ?? ?? ?? ?? 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_2318_0 {
	meta:
		name = "TCustomTabControl.GetDisplayRect"
		size = 43
		refs = "001a TWinControl.GetHandle 0020 SendMessage"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 8B 08 FF 51 44 56 6A 00 68 28 13 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 46 04 02 5E 5B C3 }
	condition:
		$1
}

rule function_2319_0 {
	meta:
		name = "TCustomTabControl.GetImageIndex"
		size = 40
	strings:
		$1 = { 53 51 89 14 24 66 83 B8 32 02 00 00 00 74 13 54 8B D8 8B CA 8B D0 8B 83 34 02 00 00 FF 93 30 02 00 00 8B 04 24 5A 5B C3 }
	condition:
		$1
}

rule function_2320_0 {
	meta:
		name = "TCustomTabControl.GetTabIndex"
		size = 27
		refs = "000f TWinControl.GetHandle 0015 SendMessage"
	strings:
		$1 = { 53 8B D8 6A 00 6A 00 68 0B 13 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2321_0 {
	meta:
		name = "TCustomTabControl.Loaded"
		size = 28
		refs = "0006 TControl.Loaded 0016 TCustomTabControl.UpdateTabImages"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 83 BB F8 01 00 00 00 74 07 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2322_0 {
	meta:
		name = "TCustomCheckBox.SetAlignment"
		size = 20
		refs = "000f TWinControl.RecreateWnd"
		altNames = "TCustomListBox.SetBorderStyle TCustomListView.SetBorderStyle TCustomTabControl.SetHotTrack TRadioButton.SetAlignment"
	strings:
		$1 = { 3A 90 F0 01 00 00 74 0B 88 90 F0 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2323_0 {
	meta:
		name = "TCustomTabControl.Notification"
		size = 46
		refs = "0010 TControl.Notification 0026 TCustomTabControl.SetImages"
	strings:
		$1 = { 53 56 57 8B D9 8B F2 8B F8 8B CB 8B D6 8B C7 E8 ?? ?? ?? ?? 80 FB 01 75 11 3B B7 F8 01 00 00 75 09 33 D2 8B C7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2324_0 {
	meta:
		name = "TCustomTabControl.SetImages"
		size = 111
		refs = "0017 TCustomImageList.UnRegisterChanges 002e TCustomImageList.RegisterChanges 003b TComponent.FreeNotification 0046 TCustomImageList.GetHandle 0055 TControl.Perform"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 83 F8 01 00 00 85 C0 74 0B 8B 93 F4 01 00 00 E8 ?? ?? ?? ?? 8B C6 89 83 F8 01 00 00 85 C0 74 35 8B 93 F4 01 00 00 E8 ?? ?? ?? ?? 8B D3 8B 83 F8 01 00 00 E8 ?? ?? ?? ?? 8B 83 F8 01 00 00 E8 ?? ?? ?? ?? 50 33 C9 BA 03 13 00 00 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 6A 00 33 C9 BA 03 13 00 00 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2325_0 {
	meta:
		name = "TCustomTabControl.ImageListChange"
		size = 31
		refs = "0009 TCustomImageList.GetHandle 0018 TControl.Perform"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 E8 ?? ?? ?? ?? 50 33 C9 BA 03 13 00 00 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2326_0 {
	meta:
		name = "TCustomTabControl.InternalSetMultiLine"
		size = 141
		refs = "0015 TCustomTabControl.InternalSetMultiLine 0045 sTabMustBeMultiLine 004a LoadResString 0052 TabControlError 0078 @LStrClr 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 C9 89 4D F8 8B DA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 3A 9E FC 01 00 00 0F 95 45 FF 80 7D FF 00 74 38 84 DB 75 23 8A 86 0A 02 00 00 3C 02 74 04 3C 03 75 15 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 88 9E FC 01 00 00 84 DB 75 07 C6 86 08 02 00 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8A 45 FF 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_2327_0 {
	meta:
		name = "TCustomTabControl.SetMultiLine"
		size = 29
		refs = "000b TCustomTabControl.InternalSetMultiLine 0016 TWinControl.RecreateWnd"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B D3 8B C6 E8 ?? ?? ?? ?? 84 C0 74 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2328_0 {
	meta:
		name = "TCustomTabControl.SetMultiSelect"
		size = 20
		refs = "000f TWinControl.RecreateWnd"
	strings:
		$1 = { 3A 90 FD 01 00 00 74 0B 88 90 FD 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2329_0 {
	meta:
		name = "TCustomTabControl.SetOwnerDraw"
		size = 20
		refs = "000f TWinControl.RecreateWnd"
		altNames = "THeader.SetBorderStyle"
	strings:
		$1 = { 3A 90 FE 01 00 00 74 0B 88 90 FE 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2330_0 {
	meta:
		name = "TCustomTabControl.SetRaggedRight"
		size = 27
		refs = "0016 SetComCtlStyle"
	strings:
		$1 = { 3A 90 FF 01 00 00 74 12 88 90 FF 01 00 00 8B CA BA 00 08 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2331_0 {
	meta:
		name = "TCustomTabControl.SetScrollOpposite"
		size = 30
		refs = "0019 TWinControl.RecreateWnd"
	strings:
		$1 = { 3A 90 08 02 00 00 74 15 88 90 08 02 00 00 84 D2 74 06 88 90 FC 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2332_0 {
	meta:
		name = "TCustomTabControl.SetStyle"
		size = 116
		refs = "0009 TCustomTabControl.SetStyle 002c SInvalidTabStyle 0031 LoadResString 003b _Dn_EInvalidOperation 0040 Exception.Create 0045 @RaiseExcept 0050 TWinControl.RecreateWnd 0065 @LStrClr 006b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C9 55 68 ?? ?? ?? ?? 64 FF 31 64 89 21 3A 90 09 02 00 00 74 39 84 D2 74 2A 80 B8 0A 02 00 00 00 74 21 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 88 90 09 02 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_2333_0 {
	meta:
		name = "TCustomTabControl.SetTabHeight"
		size = 170
		refs = "0018 TCustomTabControl.SetTabHeight 0039 TObject.ClassName 0057 SPropertyOutOfRange 005c LoadResString 0069 _Dn_EInvalidOperation 006e Exception.CreateFmt 0073 @RaiseExcept 0081 TCustomTabControl.UpdateTabSize 0099 @LStrClr 009f @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 F4 FE FF FF 53 33 C9 89 8D F4 FE FF FF 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 66 3B 93 12 02 00 00 74 5A 66 85 D2 7D 47 8D 95 F8 FE FF FF 8B 03 E8 ?? ?? ?? ?? 8D 85 F8 FE FF FF 89 45 F8 C6 45 FC 04 8D 45 F8 50 6A 00 8D 95 F4 FE FF FF A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 8D F4 FE FF FF B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 66 89 93 12 02 00 00 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 F4 FE FF FF E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2334_0 {
	meta:
		name = "TCustomTabControl.SetTabIndex"
		size = 30
		refs = "0011 TWinControl.GetHandle 0017 SendMessage"
	strings:
		$1 = { 53 56 8B F2 8B D8 6A 00 56 68 0C 13 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2335_0 {
	meta:
		name = "TCustomTabControl.SetTabPosition"
		size = 150
		refs = "000c TCustomTabControl.SetTabPosition 002f SInvalidTabPosition 0034 LoadResString 003e _Dn_EInvalidOperation 0043 Exception.Create 0048 @RaiseExcept 006a TCustomTabControl.InternalSetMultiLine 0071 TWinControl.RecreateWnd 0086 @LStrClr 008c @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 3A 93 0A 02 00 00 74 57 84 D2 74 2A 80 BB 09 02 00 00 00 74 21 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 88 93 0A 02 00 00 80 BB FC 01 00 00 00 75 13 80 FA 02 74 05 80 FA 03 75 09 B2 01 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_2336_0 {
	meta:
		name = "TCustomControlBar.SetPicture"
		size = 16
		altNames = "TCustomTabControl.SetTabs"
	strings:
		$1 = { 56 8B F0 8B 86 0C 02 00 00 8B 08 FF 51 08 5E C3 }
	condition:
		$1
}

rule function_2337_0 {
	meta:
		name = "TCustomTabControl.SetTabWidth"
		size = 196
		refs = "0018 TCustomTabControl.SetTabWidth 0039 TObject.ClassName 0057 SPropertyOutOfRange 005c LoadResString 0069 _Dn_EInvalidOperation 006e Exception.CreateFmt 0073 @RaiseExcept 0092 TWinControl.RecreateWnd 009b TCustomTabControl.UpdateTabSize 00b3 @LStrClr 00b9 @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 F4 FE FF FF 53 33 C9 89 8D F4 FE FF FF 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 66 3B 93 10 02 00 00 74 74 66 85 D2 7D 47 8D 95 F8 FE FF FF 8B 03 E8 ?? ?? ?? ?? 8D 85 F8 FE FF FF 89 45 F8 C6 45 FC 04 8D 45 F8 50 6A 00 8D 95 F4 FE FF FF A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 8D F4 FE FF FF B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 66 8B 83 10 02 00 00 66 89 93 10 02 00 00 66 85 C0 74 05 66 85 D2 75 09 8B C3 E8 ?? ?? ?? ?? EB 07 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 F4 FE FF FF E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2338_0 {
	meta:
		name = "TCustomTabControl.TabsChanged"
		size = 63
		refs = "000f TWinControl.HandleAllocated 002c TWinControl.GetHandle 0032 SendMessage 0039 TWinControl.Realign"
	strings:
		$1 = { 53 8B D8 80 BB 14 02 00 00 00 75 31 8B C3 E8 ?? ?? ?? ?? 84 C0 74 1F 0F B7 43 38 0F B7 53 3C C1 E2 10 0B C2 50 6A 00 6A 05 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2339_0 {
	meta:
		name = "TCustomTabControl.UpdateTabSize"
		size = 39
		refs = "0014 TWinControl.GetHandle 001a SendMessage 0021 TCustomTabControl.TabsChanged"
	strings:
		$1 = { 53 8B D8 8B 83 10 02 00 00 50 6A 00 68 29 13 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2340_0 {
	meta:
		name = "TCustomTabControl.UpdateTabImages"
		size = 249
		refs = "001a TCustomTabControl.UpdateTabImages 0061 TWinControl.GetHandle 0067 SendMessage 009c sTabFailSet 00a1 LoadResString 00af Format 00b7 TabControlError 00c4 TCustomTabControl.TabsChanged 00de @LStrArrayClr 00e6 @LStrClr 00ec @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 C4 53 56 57 33 D2 89 55 DC 89 55 C8 89 55 C4 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C7 45 E0 02 00 00 00 8B 86 0C 02 00 00 8B 10 FF 52 14 48 85 C0 0F 8C 82 00 00 00 40 89 45 FC 33 DB 8B D3 8B C6 8B 08 FF 91 C0 00 00 00 89 45 F4 8D 45 E0 50 53 68 06 13 00 00 8B C6 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 75 4C 8D 45 DC 50 8D 4D C8 8B D3 8B 86 0C 02 00 00 8B 38 FF 57 0C 8B 45 C8 89 45 CC C6 45 D0 0B 89 5D D4 C6 45 D8 00 8D 45 CC 50 8D 55 C4 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 C4 B9 01 00 00 00 5A E8 ?? ?? ?? ?? 8B 45 DC E8 ?? ?? ?? ?? 43 FF 4D FC 75 84 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 C4 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2341_0 {
	meta:
		name = "TCustomTabControl.CNDrawItem"
		size = 132
		refs = "0011 SaveDC 0022 TCanvas.SetHandle 0030 TCanvas.SetFont 0041 TCanvas.SetBrush 0073 RestoreDC"
	strings:
		$1 = { 53 56 57 55 51 8B FA 8B D8 8B 77 08 8B 46 18 50 E8 ?? ?? ?? ?? 89 04 24 8B 56 18 8B 83 EC 01 00 00 E8 ?? ?? ?? ?? 8B 53 58 8B 83 EC 01 00 00 E8 ?? ?? ?? ?? 8B 93 24 01 00 00 8B 83 EC 01 00 00 E8 ?? ?? ?? ?? F6 46 10 01 0F 95 C0 50 8D 4E 1C 8B 56 08 8B C3 8B 28 FF 95 BC 00 00 00 33 D2 8B 83 EC 01 00 00 E8 ?? ?? ?? ?? 8B 04 24 50 8B 46 18 50 E8 ?? ?? ?? ?? C7 47 0C 01 00 00 00 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2342_0 {
	meta:
		name = "TCustomTabControl.WMDestroy"
		size = 67
		refs = "0008 GetFocus 0015 TWinControl.GetHandle 0027 IsChild 0032 SetFocus 003b TWinControl.WMDestroy"
	strings:
		$1 = { 53 56 57 8B FA 8B D8 E8 ?? ?? ?? ?? 8B F0 85 F6 74 24 8B C3 E8 ?? ?? ?? ?? 3B F0 74 12 56 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 74 07 6A 00 E8 ?? ?? ?? ?? 8B D7 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2343_0 {
	meta:
		name = "TCoolBar.WMNotifyFormat"
		size = 36
		refs = "0014 TWinControl.GetHandle 001a DefWindowProc"
		altNames = "TCustomTabControl.WMNotifyFormat TToolBar.WMNotifyFormat"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B 43 08 50 8B 43 04 50 8B 03 50 8B C6 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 89 43 0C 5E 5B C3 }
	condition:
		$1
}

rule function_2344_0 {
	meta:
		name = "TCustomTabControl.WMSize"
		size = 31
		refs = "0006 TWinControl.WMSize 0013 TWinControl.GetHandle 0019 RedrawWindow"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 6A 05 6A 00 6A 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2345_0 {
	meta:
		name = "TCustomTabControl.CMFontChanged"
		size = 39
		refs = "0006 TWinControl.CMFontChanged 000d TWinControl.HandleAllocated 0021 TControl.Perform"
		altNames = "TMonthCalendar.CMFontChanged"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 84 C0 74 10 6A 00 33 C9 BA 05 00 00 00 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2346_0 {
	meta:
		name = "TCoolBar.CMSysColorChange"
		size = 39
		refs = "000b TWinControl.CMSysColorChange"
		altNames = "TCustomTabControl.CMSysColorChange TCustomTreeView.CMSysColorChange"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? F6 43 20 01 75 0F C7 06 15 00 00 00 8B D6 8B C3 8B 08 FF 51 F0 5E 5B C3 }
	condition:
		$1
}

rule function_2347_0 {
	meta:
		name = "TCustomTabControl.CMTabStopChanged"
		size = 12
		refs = "0007 TWinControl.RecreateWnd"
	strings:
		$1 = { F6 40 20 10 75 05 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2348_0 {
	meta:
		name = "TCustomTabControl.CNNotify"
		size = 67
		refs = "001e @CallDynaInst"
	strings:
		$1 = { 53 56 57 8B FA 8B F0 8B 47 08 8B 40 08 2D D8 FD FF FF 74 10 48 75 28 8B C6 66 BB B7 FF E8 ?? ?? ?? ?? EB 1B C7 47 0C 01 00 00 00 8B C6 66 BB B8 FF E8 ?? ?? ?? ?? 84 C0 74 05 33 C0 89 47 0C 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2349_0 {
	meta:
		name = "TCustomTabControl.CMDialogChar"
		size = 201
		refs = "0017 TCustomTabControl.CMDialogChar 0052 IsAccel 006d TWinControl.CanFocus 007a TCustomTabControl.SetTabIndex 008f @CallDynaInst 00a1 TWinControl.CMDialogChar 00b6 @LStrClr 00bc @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 33 C9 89 4D F4 89 55 FC 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 86 0C 02 00 00 8B 10 FF 52 14 48 85 C0 7C 6A 40 89 45 F8 33 DB 8D 4D F4 8B D3 8B 86 0C 02 00 00 8B 38 FF 57 0C 8B 55 F4 8B 45 FC 66 8B 40 04 E8 ?? ?? ?? ?? 84 C0 74 3B 8B D3 8B C6 8B 08 FF 91 B8 00 00 00 84 C0 74 2B 8B C6 E8 ?? ?? ?? ?? 84 C0 74 20 8B D3 8B C6 E8 ?? ?? ?? ?? 8B 45 FC C7 40 0C 01 00 00 00 8B C6 66 BB B7 FF E8 ?? ?? ?? ?? EB 10 43 FF 4D F8 75 9C 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2350_0 {
	meta:
		name = "TCustomTabControl.AdjustClientRect"
		size = 50
		refs = "000f TCustomTabControl.GetDisplayRect 0027 TWinControl.AdjustClientRect"
	strings:
		$1 = { 53 56 57 83 C4 F0 8B F2 8B D8 8B D4 8B C3 E8 ?? ?? ?? ?? 56 8B FE 8D 74 24 04 B9 04 00 00 00 F3 A5 5E 8B D6 8B C3 E8 ?? ?? ?? ?? 83 C4 10 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2351_0 {
	meta:
		name = "TTabSheet.Create"
		size = 96
		refs = "000a @ClassCreate 0017 TWinControl.Create 0020 TControl.SetAlign 0025 TTabSheet.Create 0034 TControl.SetVisible 0046 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? B2 05 8B C6 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 0B 46 40 89 46 40 33 D2 8B C6 E8 ?? ?? ?? ?? C6 86 F4 01 00 00 01 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 00 00 00 01 04 00 00 }
	condition:
		$1
}

rule function_2352_0 {
	meta:
		name = "TTabSheet.Destroy"
		size = 76
		refs = "0003 @BeforeDestruction 002e TPageControl.RemovePage 003a TWinControl.Destroy 0045 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 86 F0 01 00 00 85 C0 74 1D 3B B0 44 02 00 00 75 08 33 D2 89 90 44 02 00 00 8B D6 8B 86 F0 01 00 00 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2353_0 {
	meta:
		name = "TTabSheet.DoHide"
		size = 29
	strings:
		$1 = { 53 66 83 B8 FA 01 00 00 00 74 10 8B D8 8B D0 8B 83 FC 01 00 00 FF 93 F8 01 00 00 5B C3 }
	condition:
		$1
}

rule function_2354_0 {
	meta:
		name = "TTabSheet.DoShow"
		size = 29
	strings:
		$1 = { 53 66 83 B8 02 02 00 00 00 74 10 8B D8 8B D0 8B 83 04 02 00 00 FF 93 00 02 00 00 5B C3 }
	condition:
		$1
}

rule function_2355_0 {
	meta:
		name = "TTabSheet.GetPageIndex"
		size = 27
		refs = "0012 TList.IndexOf"
	strings:
		$1 = { 8B 90 F0 01 00 00 85 D2 74 0D 8B 92 38 02 00 00 92 E8 ?? ?? ?? ?? C3 83 C8 FF C3 }
	condition:
		$1
}

rule function_2356_0 {
	meta:
		name = "TTabSheet.GetTabIndex"
		size = 77
		refs = "0017 TTabSheet.GetPageIndex 0034 TList.Get"
	strings:
		$1 = { 53 56 57 55 8B F0 33 ED 80 BE F5 01 00 00 00 75 03 4D EB 32 8B C6 E8 ?? ?? ?? ?? 8B D8 4B 85 DB 7C 24 43 33 FF 8B 86 F0 01 00 00 8B 80 38 02 00 00 8B D7 E8 ?? ?? ?? ?? 80 B8 F5 01 00 00 00 74 01 45 47 4B 75 DF 8B C5 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2357_0 {
	meta:
		name = "TCustomControlBar.CreateParams"
		size = 16
		refs = "0006 TWinControl.CreateParams"
		altNames = "TCustomGroupBox.CreateParams TDBCtrlPanel.CreateParams TScrollingWinControl.CreateParams TTabSet.CreateParams TTabSheet.CreateParams"
	strings:
		$1 = { 53 8B DA 8B D3 E8 ?? ?? ?? ?? 83 63 24 FC 5B C3 }
	condition:
		$1
}

rule function_2359_0 {
	meta:
		name = "TTabSheet.SetImageIndex"
		size = 37
		refs = "0020 TPageControl.UpdateTab"
	strings:
		$1 = { 3B 90 EC 01 00 00 74 1C 89 90 EC 01 00 00 80 B8 F5 01 00 00 00 74 0D 8B D0 8B 80 F0 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2360_0 {
	meta:
		name = "TTabSheet.SetPageControl"
		size = 52
		refs = "0017 TPageControl.RemovePage 002d TPageControl.InsertPage"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 83 F0 01 00 00 3B F0 74 21 85 C0 74 07 8B D3 E8 ?? ?? ?? ?? 8B D6 8B C3 8B 08 FF 51 64 85 F6 74 09 8B D3 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2361_0 {
	meta:
		name = "TTabSheet.SetPageIndex"
		size = 212
		refs = "0016 TTabSheet.SetPageIndex 0054 sPageIndexError 0059 LoadResString 0063 _Dn_EListError 0068 Exception.CreateFmt 006d @RaiseExcept 0074 TTabSheet.GetTabIndex 007d TTabSheet.GetPageIndex 0092 TList.Move 00ac TPageControl.MoveTab 00c1 @LStrClr 00c7 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 83 F0 01 00 00 85 C0 0F 84 82 00 00 00 8B 80 38 02 00 00 8B 78 08 4F 3B FE 7D 35 89 75 F0 C6 45 F4 00 89 7D F8 C6 45 FC 00 8D 45 F0 50 6A 01 8D 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D EC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B F8 8B C3 E8 ?? ?? ?? ?? 8B D0 8B 83 F0 01 00 00 8B 80 38 02 00 00 8B CE E8 ?? ?? ?? ?? 85 FF 7C 16 8B C3 E8 ?? ?? ?? ?? 8B C8 8B D7 8B 83 F0 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2362_0 {
	meta:
		name = "TTabSheet.SetTabShowing"
		size = 68
		refs = "001f TPageControl.InsertTab 0028 TTabSheet.GetTabIndex 003e TPageControl.DeleteTab"
	strings:
		$1 = { 53 8B D8 3A 93 F5 01 00 00 74 37 84 D2 74 16 C6 83 F5 01 00 00 01 8B D3 8B 83 F0 01 00 00 E8 ?? ?? ?? ?? EB 1D 8B C3 E8 ?? ?? ?? ?? C6 83 F5 01 00 00 00 8B C8 8B D3 8B 83 F0 01 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2363_0 {
	meta:
		name = "TTabSheet.SetTabVisible"
		size = 20
		refs = "000f TTabSheet.UpdateTabShowing"
	strings:
		$1 = { 3A 90 F4 01 00 00 74 0B 88 90 F4 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_3088_0 {
	meta:
		name = "TAnimate.SetCenter"
		size = 20
		refs = "000f TWinControl.RecreateWnd"
	strings:
		$1 = { 3A 90 F4 01 00 00 74 0B 88 90 F4 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_3311_0 {
	meta:
		name = "TCoolBar.SetBandBorderStyle"
		size = 20
		refs = "000f TWinControl.RecreateWnd"
	strings:
		$1 = { 3A 90 F4 01 00 00 74 0B 88 90 F4 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_17547_0 {
	meta:
		name = "TCustomComboBox.SetCharCase"
		size = 20
		refs = "000f TWinControl.RecreateWnd"
	strings:
		$1 = { 3A 90 F4 01 00 00 74 0B 88 90 F4 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_17695_0 {
	meta:
		name = "TCustomStaticText.SetShowAccelChar"
		size = 20
		refs = "000f TWinControl.RecreateWnd"
	strings:
		$1 = { 3A 90 F4 01 00 00 74 0B 88 90 F4 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2482_0 {
	meta:
		name = "THeaderControl.SetFullDrag"
		size = 20
		refs = "000f TWinControl.RecreateWnd"
	strings:
		$1 = { 3A 90 F4 01 00 00 74 0B 88 90 F4 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2364_0 {
	meta:
		name = "TTabSheet.UpdateTabShowing"
		size = 36
		refs = "001f TTabSheet.SetTabShowing"
	strings:
		$1 = { 83 B8 F0 01 00 00 00 74 0F 80 B8 F4 01 00 00 00 75 0A F6 40 20 10 75 04 33 D2 EB 02 B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2365_0 {
	meta:
		name = "TTabSheet.CMTextChanged"
		size = 23
		refs = "0012 TPageControl.UpdateTab"
	strings:
		$1 = { 80 B8 F5 01 00 00 00 74 0D 8B D0 8B 80 F0 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2366_0 {
	meta:
		name = "TTabSheet.CMShowingChanged"
		size = 165
		refs = "000e TWinControl.CMShowingChanged 0023 TTabSheet.CMShowingChanged 0035 @CallDynaInst 0044 @HandleAnyException 0049 Application 0053 TApplication.HandleException 0058 @DoneExcept"
	strings:
		$1 = { 55 8B EC 51 53 56 57 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 8A 80 6C 01 00 00 84 C0 74 3F 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 66 BB B7 FF E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 5C E9 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 00 8B 55 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 41 84 C0 75 3D 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 66 BB B8 FF E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 19 E9 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 00 8B 55 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2367_0 {
	meta:
		name = "TPageControl.Create"
		size = 84
		refs = "000a @ClassCreate 0017 TCustomTabControl.Create 001c TPageControl.Create 0026 _Dn_TList 002b TObject.Create 003c @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 46 40 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 86 38 02 00 00 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 00 C0 00 00 00 }
	condition:
		$1
}

rule function_2368_0 {
	meta:
		name = "TPageControl.Destroy"
		size = 94
		refs = "0005 @BeforeDestruction 0027 TList.Get 003e TObject.Free 004a TCustomTabControl.Destroy 0055 @ClassDestroy"
	strings:
		$1 = { 53 56 57 55 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 86 38 02 00 00 8B 68 08 4D 85 ED 7C 1C 45 33 FF 8B D7 8B 86 38 02 00 00 E8 ?? ?? ?? ?? 33 D2 89 90 F0 01 00 00 47 4D 75 E7 8B 86 38 02 00 00 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2369_0 {
	meta:
		name = "TPageControl.CanShowTab"
		size = 27
		refs = "000f TList.Get"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 83 38 02 00 00 E8 ?? ?? ?? ?? 8B 10 FF 52 50 5E 5B C3 }
	condition:
		$1
}

rule function_2370_0 {
	meta:
		name = "TPageControl.Change"
		size = 56
		refs = "0006 TPageControl.UpdateActivePage 0013 GetParentForm 0032 TCustomTabControl.Change"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? F6 43 20 10 74 1F 8B C3 E8 ?? ?? ?? ?? 85 C0 74 14 83 B8 30 02 00 00 00 74 0B 8B 80 30 02 00 00 8B 10 FF 52 0C 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2371_0 {
	meta:
		name = "TPageControl.ChangeActivePage"
		size = 255
		refs = "0017 GetParentForm 0037 TWinControl.ContainsControl 0048 TCustomForm.SetActiveControl 005d TTabSheet.GetTabIndex 0066 TCustomTabControl.SetTabIndex 0076 TControl.BringToFront 007f TControl.SetVisible 00a1 TWinControl.CanFocus 00f6 TWinControl.SelectFirst"
	strings:
		$1 = { 53 56 57 55 8B FA 8B D8 3B BB 3C 02 00 00 0F 84 E6 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B F0 85 F6 74 4E 83 BB 3C 02 00 00 00 74 45 8B 96 00 02 00 00 8B 83 3C 02 00 00 E8 ?? ?? ?? ?? 84 C0 74 30 8B 93 3C 02 00 00 8B C6 E8 ?? ?? ?? ?? 8B AB 3C 02 00 00 3B AE 00 02 00 00 74 15 8B C5 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? E9 8B 00 00 00 85 FF 74 4A 8B C7 E8 ?? ?? ?? ?? B2 01 8B C7 E8 ?? ?? ?? ?? 85 F6 74 36 83 BB 3C 02 00 00 00 74 2D 8B 86 00 02 00 00 3B 83 3C 02 00 00 75 1F 8B C7 E8 ?? ?? ?? ?? 84 C0 74 0B 8B D7 8B C6 E8 ?? ?? ?? ?? EB 09 8B D3 8B C6 E8 ?? ?? ?? ?? 8B 83 3C 02 00 00 85 C0 74 07 33 D2 E8 ?? ?? ?? ?? 89 BB 3C 02 00 00 85 F6 74 22 83 BB 3C 02 00 00 00 74 19 8B 86 00 02 00 00 3B 83 3C 02 00 00 75 0B 8B 83 3C 02 00 00 E8 ?? ?? ?? ?? 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2372_0 {
	meta:
		name = "TPageControl.DeleteTab"
		size = 82
		refs = "0043 TCustomTabControl.SetTabIndex 004a TPageControl.UpdateActivePage"
	strings:
		$1 = { 53 56 57 8B F1 8B F8 3B 97 3C 02 00 00 0F 94 C3 8B D6 8B 87 0C 02 00 00 8B 08 FF 51 44 84 DB 74 26 8B 87 0C 02 00 00 8B 10 FF 52 14 3B F0 7C 0E 8B 87 0C 02 00 00 8B 10 FF 52 14 8B F0 4E 8B D6 8B C7 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2373_0 {
	meta:
		name = "TPageControl.DoAddDockClient"
		size = 19
	strings:
		$1 = { 8B 88 40 02 00 00 85 C9 74 08 8B C1 92 8B 08 FF 51 64 C3 }
	condition:
		$1
}

rule function_2374_0 {
	meta:
		name = "TPageControl.DockOver"
		size = 85
		refs = "0016 TWinControl.GetHandle 001c GetWindowRect 0048 @CallDynaInst"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 8B F9 8B F2 8B D8 8D 45 F0 50 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 56 57 8D 7E 38 8D 75 F0 B9 04 00 00 00 F3 A5 5F 5E 8B 45 10 50 8A 45 0C 50 8B 45 08 50 8B CF 8B D6 8B C3 66 BB CB FF E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_2375_0 {
	meta:
		name = "TPageControl.DoRemoveDockClient"
		size = 48
		refs = "0017 TPageControl.SelectNextPage 0022 TObject.Free"
	strings:
		$1 = { 53 8B D8 83 BB 44 02 00 00 00 74 22 F6 43 20 08 75 1C B2 01 8B C3 E8 ?? ?? ?? ?? 8B 83 44 02 00 00 E8 ?? ?? ?? ?? 33 C0 89 83 44 02 00 00 5B C3 }
	condition:
		$1
}

rule function_2376_0 {
	meta:
		name = "TPageControl.FindNextPage"
		size = 136
		refs = "0019 TList.IndexOf 0067 TList.Get"
	strings:
		$1 = { 55 8B EC 51 53 56 57 88 4D FF 8B F0 8B 86 38 02 00 00 83 78 08 00 74 66 E8 ?? ?? ?? ?? 8B F8 83 FF FF 75 14 80 7D FF 00 74 0C 8B 86 38 02 00 00 8B 78 08 4F EB 02 33 FF 8B DF 80 7D FF 00 74 10 43 8B 86 38 02 00 00 3B 58 08 75 12 33 DB EB 0E 85 DB 75 09 8B 86 38 02 00 00 8B 58 08 4B 8B D3 8B 86 38 02 00 00 E8 ?? ?? ?? ?? 80 7D 08 00 74 0F 80 B8 F4 01 00 00 00 75 06 3B FB 75 BC 33 C0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_2377_0 {
	meta:
		name = "TPageControl.GetChildren"
		size = 64
		refs = "0029 TList.Get"
		altNames = "TTabbedNotebook.GetChildren"
	strings:
		$1 = { 55 8B EC 51 53 56 89 45 FC 8B 45 FC 8B 80 38 02 00 00 8B 58 08 4B 85 DB 7C 1F 43 33 F6 8B 45 FC 8B 80 38 02 00 00 8B D6 E8 ?? ?? ?? ?? 8B D0 8B 45 0C FF 55 08 46 4B 75 E4 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_2378_0 {
	meta:
		name = "TPageControl.GetImageIndex"
		size = 46
		refs = "0015 TCustomTabControl.GetImageIndex 0021 TPageControl.GetPage"
	strings:
		$1 = { 53 56 8B F2 8B D8 66 83 BB 32 02 00 00 00 74 0C 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 80 EC 01 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_2379_0 {
	meta:
		name = "TPageControl.GetPageFromDockClient"
		size = 80
		refs = "0011 TPageControl.GetPageCount 0024 TPageControl.GetPage"
	strings:
		$1 = { 53 56 57 55 51 8B EA 8B D8 33 C0 89 04 24 8B C3 E8 ?? ?? ?? ?? 8B F8 4F 85 FF 7C 2B 47 33 F6 8B D6 8B C3 E8 ?? ?? ?? ?? 3B 45 24 75 16 3B 9D 8C 00 00 00 75 0E 8B D6 8B C3 E8 ?? ?? ?? ?? 89 04 24 EB 04 46 4F 75 D8 8B 04 24 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2380_0 {
	meta:
		name = "TPageControl.GetPage"
		size = 22
		refs = "000f TList.Get"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 83 38 02 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2381_0 {
	meta:
		name = "TPageControl.GetPageCount"
		size = 10
	strings:
		$1 = { 8B 80 38 02 00 00 8B 40 08 C3 }
	condition:
		$1
}

rule function_2382_0 {
	meta:
		name = "TPageControl.GetSiteInfo"
		size = 67
		refs = "0020 TPageControl.GetPageFromDockClient 0036 TWinControl.GetSiteInfo"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 8B 75 0C 8D 7D F4 A5 A5 89 4D FC 8B F2 8B D8 8B 7D 08 8B D6 8B C3 E8 ?? ?? ?? ?? 85 C0 0F 94 07 8D 45 F4 50 57 8B 4D FC 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_2383_0 {
	meta:
		name = "TPageControl.InsertPage"
		size = 35
		refs = "000f TList.Add 001c TTabSheet.UpdateTabShowing"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 83 38 02 00 00 E8 ?? ?? ?? ?? 89 9E F0 01 00 00 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2384_0 {
	meta:
		name = "TPageControl.InsertTab"
		size = 102
		refs = "000f TPageControl.InsertTab 0020 TControl.GetText 002b TTabSheet.GetTabIndex 0039 TStrings.InsertObject 0040 TPageControl.UpdateActivePage 0055 @LStrClr 005b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C6 E8 ?? ?? ?? ?? 8B 45 FC 50 8B C6 E8 ?? ?? ?? ?? 8B D0 8B 83 0C 02 00 00 59 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2385_0 {
	meta:
		name = "TPageControl.MoveTab"
		size = 24
	strings:
		$1 = { 53 56 57 8B FA 8B F0 8B D7 8B 86 0C 02 00 00 8B 18 FF 53 60 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2386_0 {
	meta:
		name = "TPageControl.RemovePage"
		size = 39
		refs = "000b TTabSheet.SetTabShowing 0020 TList.Remove"
	strings:
		$1 = { 53 56 8B DA 8B F0 33 D2 8B C3 E8 ?? ?? ?? ?? 33 C0 89 83 F0 01 00 00 8B D3 8B 86 38 02 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2387_0 {
	meta:
		name = "TPageControl.SelectNextPage"
		size = 82
		refs = "0012 TPageControl.FindNextPage 002b @CallDynaInst 0036 TTabSheet.GetTabIndex 003f TCustomTabControl.SetTabIndex"
	strings:
		$1 = { 53 56 57 8B F0 6A 01 8B CA 8B C6 8B 96 3C 02 00 00 E8 ?? ?? ?? ?? 8B F8 85 FF 74 32 3B BE 3C 02 00 00 74 2A 8B C6 66 BB B8 FF E8 ?? ?? ?? ?? 84 C0 74 1B 8B C7 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 8B C6 66 BB B7 FF E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2388_0 {
	meta:
		name = "TPageControl.SetActivePage"
		size = 70
		refs = "0017 TPageControl.ChangeActivePage 0025 TCustomTabControl.SetTabIndex 0036 TTabSheet.GetTabIndex"
	strings:
		$1 = { 53 56 8B DA 8B F0 85 DB 74 08 3B B3 F0 01 00 00 75 31 8B D3 8B C6 E8 ?? ?? ?? ?? 85 DB 75 0C 83 CA FF 8B C6 E8 ?? ?? ?? ?? EB 18 3B 9E 3C 02 00 00 75 10 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2389_0 {
	meta:
		name = "TPageControl.SetChildOrder"
		size = 10
		refs = "0005 TTabSheet.SetPageIndex"
	strings:
		$1 = { 8B C2 8B D1 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_7182_0 {
	meta:
		name = "TBDEDataSet.BCDToCurr"
		size = 10
		refs = "0005 FMTBCDToCurr"
	strings:
		$1 = { 8B C2 8B D1 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5857_0 {
	meta:
		name = "TClientDataSet.BCDToCurr"
		size = 10
		refs = "0005 FMTBCDToCurr"
	strings:
		$1 = { 8B C2 8B D1 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2827_0 {
	meta:
		name = "TCustomRichEdit.RegisterConversionFormat"
		size = 10
		refs = "0005 AppendConversionFormat"
	strings:
		$1 = { 8B C2 8B D1 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2390_0 {
	meta:
		name = "TPageControl.ShowControl"
		size = 52
		refs = "000a _DV_TTabSheet 000f @IsClass 0024 TPageControl.SetActivePage 002d TWinControl.ShowControl"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 11 3B 9E F0 01 00 00 75 09 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2391_0 {
	meta:
		name = "TPageControl.UpdateTab"
		size = 94
		refs = "000f TPageControl.UpdateTab 001f TControl.GetText 002a TTabSheet.GetTabIndex 004d @LStrClr 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C6 E8 ?? ?? ?? ?? 8B 45 FC 50 8B C6 E8 ?? ?? ?? ?? 8B D0 8B 83 0C 02 00 00 59 8B 18 FF 53 20 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2392_0 {
	meta:
		name = "TPageControl.UpdateActivePage"
		size = 45
		refs = "0006 TCustomTabControl.GetTabIndex 0027 TPageControl.SetActivePage"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 85 C0 7C 1D 8B C3 E8 ?? ?? ?? ?? 8B D0 8B 83 0C 02 00 00 8B 08 FF 51 18 8B D0 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2393_0 {
	meta:
		name = "TPageControl.CMDesignHitTest"
		size = 91
		refs = "0012 SmallPointToPoint 0032 TWinControl.GetHandle 0038 SendMessage 0045 TCustomTabControl.GetTabIndex"
	strings:
		$1 = { 53 56 57 83 C4 EC 8B FA 8B D8 8D 54 24 0C 8B 47 08 E8 ?? ?? ?? ?? 8B 44 24 0C 89 04 24 8B 44 24 10 89 44 24 04 8B C4 50 6A 00 68 0D 13 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B F0 85 F6 7C 12 8B C3 E8 ?? ?? ?? ?? 3B F0 74 07 C7 47 0C 01 00 00 00 83 C4 14 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2394_0 {
	meta:
		name = "TPageControl.CMDialogKey"
		size = 67
		refs = "0010 GetKeyState 0029 TPageControl.SelectNextPage 003c TWinControl.CMDialogKey"
	strings:
		$1 = { 53 56 8B F2 8B D8 66 83 7E 04 09 75 2A 6A 11 E8 ?? ?? ?? ?? 66 85 C0 7D 1E 6A 10 E8 ?? ?? ?? ?? 66 85 C0 0F 9D C2 8B C3 E8 ?? ?? ?? ?? C7 46 0C 01 00 00 00 5E 5B C3 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2395_0 {
	meta:
		name = "TPageControl.CMDockClient"
		size = 328
		refs = "0017 TPageControl.CMDockClient 002c _DV_TTabSheet 0031 TTabSheet.Create 0066 _Dn_TCustomForm 006b @IsClass 0079 TControl.GetText 0083 TControl.SetText 0094 TTabSheet.SetPageControl 00a8 @CallDynaInst 00b7 @HandleAnyException 00c5 TObject.Free 00ca @RaiseAgain 00cf @DoneExcept 00e2 TTabSheet.SetTabVisible 00f7 TPageControl.SetActivePage 0100 TControl.SetAlign 011e @HandleFinally 0135 @LStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 33 C9 89 4D F8 8B FA 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 89 47 0C 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 8B 45 FC 89 98 40 02 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 47 04 8B 70 30 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 14 8D 55 F8 8B C6 E8 ?? ?? ?? ?? 8B 55 F8 8B C3 E8 ?? ??