#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This file will test some simplifications for ruby-gtk4.
# =========================================================================== #
# $GTK_PARADISE/test/misc/testing_gtk4_simplifications.rb
# =========================================================================== #
if __FILE__ == $PROGRAM_NAME
  case ARGV.first
  when 'gtk3'
    require 'gtk_paradise/require_gtk3'
  when 'gtk4','',nil
    require 'gtk_paradise/require_gtk4'
  end
end

class TestingGtk4Applications < ::Gtk::BaseModuleBox # === TestingGtk4Applications

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = '80% or 800px minimum'

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      run_already = true
    )
    super(:vertical)
    reset
    run if run_already
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    set_width(WIDTH)
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    set_font_globally('Mono 35')
    append(hbox_text(' 1'))
    append(hbox_text(' 2'))
    append(hbox_text(' 3'))
    append(hbox_text(' 4'))
    append(hbox_text(' 5'))
    append(hbox_text(' 6'))
    append(hbox_text(' 7'))
    append(hbox_text(' 8'))
    append(hbox_text(' 9'))
    append(hbox_text('10'))
# pp @internal_hash
# pp width?
  end

  # ========================================================================= #
  # === title?
  # ========================================================================= #
  def title?
    'Showcasing Ten vboxes'
  end; alias title title? # === title

  # ========================================================================= #
  # === TestingGtk4Applications.run_gtk4
  # ========================================================================= #
  def self.run_gtk4
    ::Gtk.default_application {{
      widget_to_use: new
    }}
  end; self.instance_eval { alias run run_gtk4 } # === TestGtk4Applications.run

  # ========================================================================= #
  # === TestingGtk4Applications.run_gtk3
  # ========================================================================= #
  def self.run_gtk3(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = TestingGtk4Applications.new(i)
    r = ::Gtk.run
    r << _
    r.automatic_size_then_automatic_title
    r.enable_quick_exit
    r.top_left_then_run
  end

end

if __FILE__ == $PROGRAM_NAME
  case ARGV.first
  when 'gtk3'
    TestingGtk4Applications.run_gtk3
  when 'gtk4','',nil
    TestingGtk4Applications.run_gtk4
  end
end # rb testing_gtk4_simplifications.rb gtk4