#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_paradise/requires/require_gtk3.rb'
# =========================================================================== #
require 'gir_ffi-gtk3'

Gtk.init

require 'gtk_paradise/toplevel_methods/determine_which_gtk_version_is_in_use.rb'

Gtk.we_use_this_gtk_version = :gir_ffi_gtk3 # This must come before we require other files.


# require 'gtk_paradise/base_module/base_module.rb'
# ^^^ this does not work right now, too many small errors

require 'gtk_paradise/core_classes/button.rb'

win = Gtk::Window.new(:toplevel)
win.title = 'Hello Buttons!'

win.signal_connect("delete-event") {
  Gtk.main_quit
  false
}

win.border_width = 12

box = Gtk::HBox.new(false, 0)
win.add(box)

button1 = Gtk::Button.new_with_label("Button 1")
button1.signal_connect('clicked', 'button 1') {
  puts 'Button 1'
}
button1.no_border
button1.show
box.pack_start(button1, true, true, 0)

button2 = Gtk::Button.new_with_label('Button 2')
button2.signal_connect('clicked', 'button 2') {
  puts 'Button 2'
}
button2.show
box.pack_start(button2, true, true, 0)

box.show
win.show

Gtk.main

# require 'gtk_paradise/run'

