#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::ScrolledWindowWithViewportModule
#
# The primary purpose of this class - and the reason why it exists - is 
# to simply demonstrate how a scrolled-window can be used.
# =========================================================================== #
# require 'gtk_paradise/wdigets/shared_code/scrolled_window_with_viewport_module/scrolled_window_with_viewport_module.rb'
# include ::Gtk::ScrolledWindowWithViewportModule
# =========================================================================== #
module Gtk

module ScrolledWindowWithViewportModule

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  # ========================================================================= #
  # === NAMESPACE
  # ========================================================================= #
  NAMESPACE = inspect

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'ScrolledWindowWithViewport'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = 1200

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = 500

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      optional_file = nil,
      run_already   = true
    )
    super()
    reset
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, NAMESPACE]
    # ======================================================================= #
    # === @title
    # ======================================================================= #
    @title  = TITLE
    # ======================================================================= #
    # === @width
    # ======================================================================= #
    set_width(WIDTH)
    # ======================================================================= #
    # === @height
    # ======================================================================= #
    set_height(HEIGHT)
    # ======================================================================= #
    # === @scrolled_window
    # ======================================================================= #
    @scrolled_window = gtk_scrolled_window
    # ======================================================================= #
    # === @renderer
    # ======================================================================= #
    @renderer = gtk_cell_renderer_text
    # ======================================================================= #
    # === @list_store
    # ======================================================================= #
    @list_store = gtk_list_store(String)
    # ======================================================================= #
    # === @tree_view
    # ======================================================================= #
    @tree_view = gtk_tree_view(@list_store)
    set_use_this_font(:dejavu_condensed_22)
    use_gtk_paradise_project_css_file
    infer_the_size_automatically
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    2
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    2
  end

  # ========================================================================= #
  # === create_skeleton                                          (create tag)
  # ========================================================================= #
  def create_skeleton
    @tree_view.enable_single_selection
    @tree_view.enable_dragging
    %w(
      one two three four five
    ).each { |v|
      iter = @list_store.append
      iter.set_value(0, v)
    }
    @tree_view.signal_connect(:event) { |widget, event|
      _ = event.event_type.name
      case _
      when 'GDK_BUTTON_RELEASE'
        puts @tree_view.selection.selected[0]
      end
    }
    @column = gtk_tree_view_column(
      'Data', gtk_cell_renderer_text, {text: 0}
    )
    @tree_view.append_column(@column)
    @scrolled_window.window_bottom_left
    @scrolled_window.add(@tree_view) { :always } # add the TreeView here.
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
    add(@scrolled_window)
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    create_skeleton_then_connect_skeleton
  end

  # ========================================================================= #
  # === Gtk::ScrolledWindowWithViewportModule.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = ::Gtk::ScrolledWindowWithViewport.new(i)
    r = ::Gtk.run
    r << _
    r.set_size_request(_.width?, _.height?)
    r.modify_background :normal, :beige
    r.top_left_then_run
  end

end; end # $RUBY_GTK/scrolled_window_with_viewport.rb