#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_paradise/widgets/shared_code/emoji_toggle_widget/emoji_toggle_widget_module.rb'
# include Gtk::EmojiToggleWidgetModule
# =========================================================================== #
module Gtk

module EmojiToggleWidgetModule

  require 'gtk_paradise/emojis/emojis.rb'

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  # ========================================================================= #
  # === NAMESPACE
  # ========================================================================= #
  NAMESPACE = inspect

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = 250

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = 80

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Emoji Widget'

  # ========================================================================= #
  # === INITIAL_STATE
  # ========================================================================= #
  INITIAL_STATE = :sceptical_emoji # :thinking_emoji

  # ========================================================================= #
  # === TOGGLE_TO_THAT_STATE
  # ========================================================================= #
  TOGGLE_TO_THAT_STATE = :smiley_emoji

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      i           = ARGV,
      run_already = true
    )
    super()
    reset
    set_use_this_font(:hack_25)
    case i
    # ======================================================================= #
    # === :use_two_smileys
    # ======================================================================= #
    when :use_two_smileys
      i = [ :thinking_smiley, :happy_smiley ]
    end
    set_commandline_arguments(i)
    on_delete_event_quit_the_application
    menu
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, infer_the_namespace]
    title_height_width(TITLE, HEIGHT, WIDTH)
    # ======================================================================= #
    # === @initial_state
    # ======================================================================= #
    @initial_state = INITIAL_STATE
    # ======================================================================= #
    # === @toggle_to_that_state
    # ======================================================================= #
    @toggle_to_that_state = TOGGLE_TO_THAT_STATE
    set_font(:hack_24)
    assign_to_this_emoji
    use_gtk_paradise_project_css_file
  end

  # ========================================================================= #
  # === Gtk::EmojiToggleWidgetModule.width?
  # ========================================================================= #
  def self.width?
    WIDTH
  end

  # ========================================================================= #
  # === Gtk::EmojiToggleWidgetModule.height?
  # ========================================================================= #
  def self.height?
    HEIGHT
  end

  # ========================================================================= #
  # === menu
  # ========================================================================= #
  def menu(
      i = commandline_arguments?
    )
    all_entries = i.join(' ').strip
    unless all_entries.empty?
      splitted = all_entries.split(' ')
      if splitted and splitted[0] and splitted[1]
        @initial_state = splitted[0].to_sym
        @toggle_to_that_state = splitted[1].to_sym
      end
    end
  end

  # ========================================================================= #
  # === assign_to_this_emoji
  # ========================================================================= #
  def assign_to_this_emoji(
      i = @initial_state
    )
    i = ::Gtk::Emojis.map_emoji(i)
    if i.is_a? Symbol
      # ===================================================================== #
      # If it is still a symbol, notify the user about this.
      # ===================================================================== #
      e "Still a symbol; no emoji found for: #{i}"
    end
    set_text(i)
  end

  # ========================================================================= #
  # === flip_state
  #
  # This method can be used to simply flip the state.
  # ========================================================================= #
  def flip_state
    _ = text.to_s.dup
    if _.start_with? ::Gtk::Emojis.map_emoji(@initial_state)
      assign_to_this_emoji(@toggle_to_that_state)
    else
      revert_to_the_initial_state # Restore the default state.
    end
  end; alias do_flip_the_state flip_state # === do_flip_the_state
       alias toggle            flip_state # === toggle

  # ========================================================================= #
  # === revert_to_the_initial_state
  # ========================================================================= #  
  def revert_to_the_initial_state
    assign_to_this_emoji(@initial_state)
  end

  # ========================================================================= #
  # === create_skeleton
  # ========================================================================= #
  def create_skeleton
  end

  # ======================================================================== #
  # === padding?
  # ======================================================================== #
  def padding?
    10
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    show_all
  end

  # ======================================================================== #
  # === run                                                        (run tag)
  # ======================================================================== #
  def run
    create_skeleton
    connect_skeleton
  end

  # ======================================================================== #
  # === Gtk::EmojiToggleWidgetModule.run
  #
  # This is the variant that can be "run" directly.
  # ======================================================================== #
  def self.run
    require 'gtk_paradise/run.rb'
    error_widget = ::Gtk::EmojiToggleWidget.new(ARGV)
    error_widget.set_size_request(250, 150)
    r = ::Gtk.run
    r << error_widget
    error_widget << 'HI THERE - this is just a text message test'
    error_widget.flip_state
    Thread.new {
      sleep 3
      error_widget.flip_state
    }
    r.set_background :white
    r.enable_quick_exit_then_top_left_then_run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::EmojiToggleWidget.run
end