#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::BurningWidgetModule
#
# Adapted from:
#
#   http://zetcode.com/gui/rubygtk/customwidget/
#
# =========================================================================== #
# require 'gtk_paradise/widgets/shared_code/burning_widget/burning_widget_module.rb'
# include ::Gtk::BurningWidgetModule
# =========================================================================== #
module Gtk

module BurningWidgetModule

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = '40% or minimum 400px'

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = 250

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Burning Widget'

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      run_already = true
    )
    super(:vertical)
    reset
    @vbox = create_vbox
    create_scale
    fixed = gtk_fixed
    fixed.put(@scale, 50, 50)
    @vbox.maximal(fixed)
    # ======================================================================= #
    # Next instantiate the widget that handles the GUI.
    # ======================================================================= #
    @drawing_widget = DrawingWidget.new(self)
    @vbox.minimal(@drawing_widget)
    destroy_on_exit
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, infer_the_namespace]
    title_width_height(TITLE, WIDTH, HEIGHT)
    # ======================================================================= #
    # === @cur_value
    # ======================================================================= #
    @cur_value = 0 # Keep track of the current value here.
    set_use_this_font(:dejavu_condensed_22)
    use_gtk_paradise_project_css_file
    infer_the_size_automatically
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    2
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    2
  end

  # ========================================================================= #
  # === create_skeleton
  # ========================================================================= #
  def create_skeleton
  end

  # ========================================================================= #
  # === drawing_widget?
  # ========================================================================= #
  def drawing_widget?
    @drawing_widget
  end

  # ========================================================================= #
  # === on_changed
  # ========================================================================= #
  def on_changed(widget)
    @cur_value = widget.value
    drawing_widget?.queue_draw
  end
  
  # ========================================================================= #
  # === get_cur_value
  # ========================================================================= #
  def get_cur_value
    @cur_value
  end

  # ========================================================================= #
  # === create_scale
  # ========================================================================= #
  def create_scale
    # ======================================================================= #
    # Add a Gtk::Scale next, horizontal alignment.
    # ======================================================================= #
    @scale = ::Gtk::Scale.new(:horizontal)
    @scale.set_range(0, 750)
    @scale.set_digits(0)
    @scale.set_size_request(160, 35)
    @scale.set_value(@cur_value)
    @scale.on_value_changed { |widget|
      on_changed widget
    }
  end

  # ========================================================================= #
  # === connect_skeleton
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
    add(@vbox)
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    connect_skeleton
    show_all
  end

  # ========================================================================= #
  # === Gtk::BurningWidgetModule.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = ::Gtk::BurningWidget.new(i)
    r = ::Gtk.run
    r.set_window_position(:center)
    r << _
    r.set_size_request(_.width?, _.height?)
    r.top_left_then_run
  end

end; end