# =========================================================================== #
# require 'gtk_paradise/widgets/shared_code/admin_panel/admin_panel_module.rb'
# include ::Gtk::AdminPanelModule
# =========================================================================== #
module Gtk

module AdminPanelModule

  # ========================================================================= #
  # === CALLBACK_QUIT
  # ========================================================================= #
  CALLBACK_QUIT = Proc.new {
    puts 'Quit is called.'
    ::Gtk.main_quit
  }

  # ========================================================================= #
  # === CALLBACK_CREATE_A_NEW_FILE
  # ========================================================================= #
  CALLBACK_CREATE_A_NEW_FILE = Proc.new {|actiongroup, action|
    puts "`#{action.name}' is clicked."
  }

  # ========================================================================= #
  # === CALLBACK_DEBUG
  # ========================================================================= #
  CALLBACK_DEBUG = Proc.new {|actiongroup, action|
    puts 'DEBUGGING - not yet implemented'
  }

  # ========================================================================= #
  # === MENU_UI_DESIGN_XML
  #
  # Describe the main menu-interface to use, via XML.
  #
  # Adding a debug-action could be done via:
  #
  #   <menu action='Action'>
  #       <separator />
  #       <menuitem action='ActionDebug' />
  #       <separator />
  #   </menu>
  #
  # ========================================================================= #
  MENU_UI_DESIGN_XML = %Q[
<ui>
<menubar name='MenuBar'>

  <menu action='ActionFileMenu'>
      <separator />
      <menuitem action='New' />
      <separator />
      <menuitem action='Quit' />
      <separator />
  </menu>

</menubar>
</ui>
  ]

  # ========================================================================= #
  # === MENU_ACTIONS
  #
  # This describes the topmenu for this application.
  # ========================================================================= #
  MENU_ACTIONS = [
    ['ActionFileMenu', nil, '_File'],
    ['Quit', ::Gtk::Stock::QUIT, '_Quit', '<control>Q', 'Quit', CALLBACK_QUIT],
    ['New',  ::Gtk::Stock::NEW,  '_New',  '<control>N',  'Create a new file', CALLBACK_CREATE_A_NEW_FILE],
    ['ActionDebug', ::Gtk::Stock::NEW,  '_New',  '<control>A',  'Debug', CALLBACK_DEBUG]
  ]

  # ========================================================================= #
  # === ACTION_GROUP
  # ========================================================================= #
  ACTION_GROUP = ::Gtk::ActionGroup.new('Actions')
  ACTION_GROUP.add_actions(MENU_ACTIONS)

  # ========================================================================= #
  # === UI_MANAGER
  # ========================================================================= #
  UI_MANAGER = ::Gtk::UIManager.new
  UI_MANAGER.insert_action_group(ACTION_GROUP, 0)
  UI_MANAGER.add_ui(MENU_UI_DESIGN_XML)

  # ========================================================================= #
  # === ui_manager?
  # ========================================================================= #
  def ui_manager?
    @ui_manager
  end

  def add_all_subwidgets
    # ======================================================================= #
    # === (09) World Capitals
    # ======================================================================= #
    begin
      require 'roebe/gui/gtk/world_capitals/frame_for_world_capitals.rb'
      add_it ::Roebe::FrameForWorldCapitals.new, 'World Capitals'
    rescue LoadError; end
    # ======================================================================= #
    # === (12) Textarea or SourceView widget
    #
    # Next we will either add a simple textarea (TextView), or a
    # Gtk::SourceView. This depends on a certain constant being
    # available or not.
    #
    # The first is a simple textarea, so that the user can type stuff
    # into it.
    # ======================================================================= #
    if ::Gtk.const_defined? :SourceLanguageManager
      require 'gtk_paradise/widgets/gtksourceview2_example.rb'
      add_it ::Gtk::Gtksourceview2Example.new, 'textarea'
    else
      add_it ::Gtk.textview {{ indent: 8 }}, 'textarea'
    end
    # ======================================================================= #
    # === (15) ImageParadise GUI
    #
    # This widget allows the user to do image-related manipulations.
    # ======================================================================= #
    begin
      require 'image_paradise/requires/require_gtk_components.rb'
      add_it ImageParadise.gtk_widget, 'ImageParadise'
    rescue LoadError => error
      if is_on_roebe?
        pp error
      end
    # ======================================================================= #
    # === (20) Information about the local harddisc.
    #
    # This must be rescued, for windows specifically.
    # ======================================================================= #
    begin
      require 'gtk_paradise/widgets/gtk2/information_about_the_harddisc.rb'
      add_it InformationAboutTheHarddisc.new, 'Local HDDs'
    rescue Exception => error
      pp error
    end
    # ======================================================================= #
    # Next add only roebe-specific widgets:
    # ======================================================================= #
    if is_on_roebe?
      # ===================================================================== #
      # === (22) Compile a program
      # ===================================================================== #
      require 'rbt/requires/require_the_gtk_components.rb'
      add_it RBT.return_gtk_widget(:compile_program).new, 'Compile a program'
      add_it Wetter.gtk_widget, 'Wetter in Wien'
      # ===================================================================== #
      # === (24) Embed a prototype for an audio-player next
      # ===================================================================== #
      require 'multimedia_paradise/gui/gtk2/simple_play_widget/simple_play_widget.rb'
      add_it MultimediaParadise.simple_play_widget, 'Simple Audio Player'
    end
    # ======================================================================= #
    # === (25) Embed a prototype for an audio-player next
    # ======================================================================= #
    require 'gtk_paradise/widgets/gtk2/clipboard_demo.rb'
    add_it ::Gtk::ClipboardDemo.return_widget.new, 'Clipboard'
    # ======================================================================= #
    # === (27) Bioroebe
    # ======================================================================= #
    # require 'bioroebe/with_gui'
    # if Object.const_defined? :Bioroebe
    #   add_it Bioroebe::GUI::Controller.new, :bioroebe
    # end
    # ^^^ and this also does not work
    # begin
    #   require 'ascii_paradise/gui/gtk/notebook.rb'
    #   add_it AsciiParadise::GUI::Gtk.return_widget, 'animated ascii'
    # rescue LoadError; end
    # ======================================================================= #
    # === (29) CompileProgram
    # ======================================================================= #
    # add_it Gtk::CompileProgram.new, 'compile_program'
    # SysMessage.new)
    # add_it _, 'sysmessage and calendar'
    # ======================================================================= #
    # === (30) PartyViewer
    # ======================================================================= #
    # add_it PartyViewer.new, 'party viewer'
    # add_it FtpParadise.gtk_widget.new, 'FTP'
    # ^^^ Something is wrong with the width/height of the FTP addon.
    # add_it MultimediaParadise::GUI::Gtk::GtkNotebook.new, 'videos'
    # require 'x/GUI/gtk/rpg/party_viewer/party_viewer.rb'
    # require 'multimedia_paradise/gui/gtk/gtk_notebook.rb'
    require 'gtk_paradise/games/mastermind/mastermind.rb'
    add_it Mastermind::Mastermind.new, 'mastermind'
    require 'gtk_paradise/games/minesweeper/minesweeper_game.rb'
    add_it Minesweeper::Game.new, 'minesweeper'
  end

  # ========================================================================= #
  # === Gtk::AdminPanel.run_with_topmenu
  #
  # This will just pack the main AdminPanel widget into a Gtk::Runner
  # widget. If you need a variant with a topmenu, use the file
  # called topmenu.rb instead.
  # ========================================================================= #
  def self.run_with_topmenu
    require 'gtk_paradise/widgets/gtk2/mini_clock/mini_clock.rb'
    require 'gtk_paradise/run.rb'
    r = ::Gtk::Runner.new
    @v_box = ::Gtk::VBox.new
    top_pane = ::Gtk::HBox.new
    top_pane.maximal(UI_MANAGER['/MenuBar'],2)
    top_pane.minimal(::Gtk.clock { :bold }, 2)
    @v_box.minimal(top_pane)
    admin_panel = ::Gtk::AdminPanel.new(ARGV)
    # Next, the admin-panel is added.
    @v_box.minimal(admin_panel)
    r << @v_box
    # r.set_child_widget(admin_panel) # Must designate another child widget.
    # r.add_accel_group( UI_MANAGER.accel_group )
    #r.add_accel_group(admin_panel.accel_group?)
    r.move_top_left_then_run
  end

  # ========================================================================= #
  # === Gtk::AdminPanel.run
  #
  # This will just pack the main AdminPanel widget into a Gtk::Runner
  # widget. If you need a variant with a topmenu, use the file called
  # topmenu.rb instead.
  # ========================================================================= #
  def self.run
    require 'gtk_paradise/run.rb' 
    _ = Gtk::AdminPanel.new(ARGV)
    r = Gtk.run
    r << _
    r.modify_background(:normal, :beige)
  end

end; end