#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === FoobarParadise::GUI::Gtk::TypeTrainer
# =========================================================================== #
# require 'foobar/gui/gtk3/gtk3_standalone/gtk3_standalone.rb'
# FoobarParadise::GUI::Gtk::TypeTrainer.run
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class TypeTrainer < ::Gtk::BaseModuleBox # === FoobarParadise::GUI::Gtk::TypeTrainer 

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Type Trainer'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = '85% or minimum 800px'

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = '45% or minimum 400px'

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :dejavu_condensed_20

  # ========================================================================= #
  # === HASH_DIFFICULTY  
  # ========================================================================= #
  HASH_DIFFICULTY = {
    easy:       2,
    normal:     8,
    difficult: 12
  }

  # ========================================================================= #
  # === RUBY_WORDS
  # ========================================================================= #
  RUBY_WORDS = <<-EOF

In ruby you will see several commands def puts def () and there
are many special tokens:

class String
  class def >>
  def puts << print << puts def class String.
end

Simply try to type them def def define okay?

EOF

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = ARGV,
      run_already           = true
    )
    super(:vertical)
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    infer_the_namespace
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, namespace?]
    # ======================================================================= #
    # === Set the title, width, height and the font in use.
    # ======================================================================= #
    title_width_height_font(TITLE, WIDTH, HEIGHT, USE_THIS_FONT)
    use_gtk_paradise_project_css_file  
    infer_the_size_automatically
    # ======================================================================= #
    # === @alphabet
    # ======================================================================= #
    @alphabet = ('a'..'z').to_a
    @hash_difficulty = HASH_DIFFICULTY
    @difficulty_modifier = choose_random_difficulty
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    4
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    2
  end

  # ========================================================================= #
  # === create_skeleton                            (create tag, skeleton tag)
  # ========================================================================= #
  def create_skeleton
    create_the_text_view
    @scrolled_window = scrolled_window(text_view)
    @scrolled_window.pad4px
    @scrolled_window.bblack1
  end

  # ========================================================================= #
  # === create_the_text_view
  # ========================================================================= #
  def create_the_text_view
    @text_view = create_text_view
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
    maximal(@scrolled_window)
  end

  # ========================================================================= #
  # === choose_random_difficulty
  # ========================================================================= #
  def choose_random_difficulty
    case rand(3)
    when 0
      @hash_difficulty[:easy]
    when 1
      @hash_difficulty[:normal]
    when 2
      @hash_difficulty[:difficult]
    end
  end

  # ========================================================================= #
  # === return_random_word
  # ========================================================================= #
  def return_random_word
    my_word = ''.dup
    n_chars = 2 + rand(58)
    0.upto(n_chars) { |counter| my_word << @alphabet.sample }
    return my_word
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    super()
  end

  # ========================================================================= #
  # === Gtk::TypeTrainer.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = ::Gtk::TypeTrainer.new(i)
    r = ::Gtk.run
    r << _
    r.automatic_size_then_automatic_title
    r.enable_quick_exit
    r.top_left_then_run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::TypeTrainer.run
end