#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::ShowWhichKeyWasPressed
# =========================================================================== #
# require 'gtk_paradise/widgets/gtk3/show_which_key_was_pressed/show_which_key_was_pressed.rb'
# Gtk::ShowWhichKeyWasPressed.run
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class ShowWhichKeyWasPressed < ::Gtk::Box # === Gtk::ShowWhichKeyWasPressed 

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Show which key was pressed.'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = '55% or minimum 500px'

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = '25% or minimum 200px'

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :dejavu_condensed_18

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = ARGV,
      run_already           = true
    )
    super(:vertical)
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    infer_the_namespace
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, namespace?]
    # ======================================================================= #
    # === Set the title, width, height and the font in use.
    # ======================================================================= #
    title_width_height_font(TITLE, WIDTH, HEIGHT, USE_THIS_FONT)
    use_gtk_paradise_project_css_file 
    infer_the_size_automatically
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    4
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    2
  end

  # ========================================================================= #
  # === create_skeleton                            (create tag, skeleton tag)
  # ========================================================================= #
  def create_skeleton
    create_the_entries
  end

  # ========================================================================= #
  # === create_the_entries
  # ========================================================================= #
  def create_the_entries
    # ======================================================================= #
    # === @entry_for_the_keyvalue
    # ======================================================================= #
    @entry_for_the_keyvalue = gtk_entry
    @entry_for_the_keyvalue.is_read_only
    @entry_for_the_keyvalue.bblack1
    @entry_for_the_keyvalue.very_light_yellow_background
    # ======================================================================= #
    # === @entry_for_the_gdk_keyvalue
    # ======================================================================= #
    @entry_for_the_gdk_keyvalue = gtk_entry
    @entry_for_the_gdk_keyvalue.is_read_only
    @entry_for_the_gdk_keyvalue.bblack1
    @entry_for_the_gdk_keyvalue.very_light_yellow_background
    @entry_for_the_gdk_keyvalue.width_height(500, 20)
    # ======================================================================= #
    # === @entry
    # ======================================================================= #
    @entry = gtk_entry {{ max_length: 250 }}
    @entry.bblack1
    @entry.pad8px
    @entry.shadow_hint = 'Press any key here ...'
    @entry.very_light_yellow_background
    @entry.signal_connect(:key_press_event) { |w, event|
      get_key_value(event)
    }
  end

  # ========================================================================= #
  # === get_key_value
  # ========================================================================= #
  def get_key_value(event)
    string = '%-18s' % "Keyvalue: #{event.keyval}"
    # ======================================================================= #
    # Sync it back to the proper entry:
    # ======================================================================= #
    @entry_for_the_keyvalue.set_text(event.keyval.to_s)
    efancy string
    longer_string = "   Gdk::Keyval::KEY_#{Gdk::Keyval.to_name(event.keyval)}"
    efancy longer_string
    @entry_for_the_gdk_keyvalue.set_text(
      "Gdk::Keyval::KEY_#{Gdk::Keyval.to_name(event.keyval)}"
    )
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
    minimal(
      gtk_left_aligned_label('This widget will display the key-values of '\
        'the given input key.'), 12
    )
    minimal_spacer
    minimal(@entry, 25)
    minimal_spacer
    hbox1 = hbox
    hbox1.minimal(text('The keyvalue of the pressed key is: '))
    hbox1.minimal(@entry_for_the_keyvalue)
    minimal(hbox1, 5)
    hbox2 = hbox
    hbox2.minimal(text('The gdk-keyvalue of the pressed key is: '))
    hbox2.minimal(@entry_for_the_gdk_keyvalue)
    minimal(hbox2, 5)
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    super()
  end

  # ========================================================================= #
  # === Gtk::ShowWhichKeyWasPressed.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = Gtk::ShowWhichKeyWasPressed.new(i)
    r = ::Gtk.run
    r << _
    r.automatic_size_then_automatic_title
    r.enable_quick_exit
    r.top_left_then_run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::ShowWhichKeyWasPressed.run
end