#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::NoteWindow
#
# Clicking on this event-box will make another widget pop-up.
#
# This widget, a child-widget of Gtk::EventBox, is ideally suited to
# implement small note-like widgets.
# =========================================================================== #
# require 'gtk_paradise/widgets/gtk3/note_window/note_window.rb'
# Gtk::NoteWindow.run
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class NoteWindow < ::Gtk::EventBox # === Gtk::NoteWindow 

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Note Window'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = '25% or minimum 200px'

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = '15% or minimum 100px'

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :dejavu_condensed_20

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      set_new_title = 'Lacking_Title',
      run_already   = true
    )
    super()
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    infer_the_namespace
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, namespace?]
    # ======================================================================= #
    # === Set the title, width, height and the font in use.
    # ======================================================================= #
    title_width_height_font(TITLE, WIDTH, HEIGHT, USE_THIS_FONT)
    use_gtk_paradise_project_css_file 
    infer_the_size_automatically
    # ===================================================================== #
    # === @vbox
    # ===================================================================== #
    @vbox = gtk_vbox
    # ===================================================================== #
    # === @frame
    # ===================================================================== #
    @frame = gtk_frame
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    4
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    2
  end

  # ========================================================================= #
  # === create_skeleton                            (create tag, skeleton tag)
  # ========================================================================= #
  def create_skeleton
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
    minimal(gtk_left_aligned_label('Hello world! This is a simple test.'))
  end

  # ======================================================================= #
  # === on_clicked
  #
  # Proc-event upon a click-action.
  # ======================================================================= #
  def on_clicked(&block)
    @clicked_block = block
  end

  # ======================================================================= #
  # === grab_focus
  # ======================================================================= #
  def grab_focus
    @text_view.grab_focus
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    create_skeleton_then_connect_skeleton
    add(@vbox)
    @event_box = gtk_eventbox(@frame)
    @vbox.maximal(@event_box, 0)

    # ===================================================================== #
    # Create the top label:
    # ===================================================================== #
    @label = modify_bold_label("Note #{set_new_title}", 'rand')

    # ===================================================================== #
    # And add it
    # ===================================================================== #
    @frame.add(@label)
    @text_view = gtk_text_view
    scrolled_window = gtk_scrolled_window(@text_view) { :automatic }
    @vbox.maximal(scrolled_window, 0)
    set_size_request(220, 80)

    @frame.enable_all_events

    # ===================================================================== #
    # add button press event
    # ===================================================================== #
    on_button_press_event { |owner, event|
      if @clicked_block != nil
        @clicked_block.call(owner, event)
      end
      true
    }

    # ===================================================================== #
    # also add it to our @event_box
    # ===================================================================== #
    @event_box.on_button_press_event { |owner, event|
      @clicked_block.call(owner, event) if @clicked_block != nil
      true
    }
    # ===================================================================== #
    # Last but not least, the text view widget gets it as well.
    # ===================================================================== #
    @text_view.on_button_press_event { |owner, event|
      @clicked_block.call(owner, event) unless @clicked_block.nil?
      true
    }
    show_all
  end

  # ========================================================================= #
  # === Gtk::NoteWindow.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = ::Gtk::NoteWindow.new(i)
    r = ::Gtk.run
    r << _
    r.automatic_size_then_automatic_title
    r.top_left_then_run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::NoteWindow.run
end