#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::MyCalendar
# =========================================================================== #
# require 'gtk_paradise/widgets/gtk3/my_calendar/my_calendar.rb'
# Gtk::MyCalendar.run
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class MyCalendar < ::Gtk::Box # === Gtk::MyCalendar 

  include ::Gtk::BaseModule

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'My Calendar'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = '65% or minimum 1200px'

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = '45% or minimum 500px'

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :dejavu_condensed_20

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = ARGV,
      run_already           = true
    )
    super(:vertical)
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    infer_the_namespace
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, namespace?]
    # ======================================================================= #
    # === Set the title, width, height and the font in use.
    # ======================================================================= #
    title_width_height_font(TITLE, WIDTH, HEIGHT, USE_THIS_FONT)
    use_gtk_paradise_project_css_file
    infer_the_size_automatically
    # ======================================================================= #
    # === @day
    # ======================================================================= #
    @day   = nil
    # ======================================================================= #
    # === @month
    # ======================================================================= #
    @month = nil
    # ======================================================================= #
    # === @year
    # ======================================================================= #
    @year  = nil
    # ======================================================================= #
    # === @verbose_on_the_commandline
    #
    # If this variable is true then we will be verbose on the commandline.
    # ======================================================================= #
    @verbose_on_the_commandline = true
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    2
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    2
  end

  # ========================================================================= #
  # === day?
  # ========================================================================= #
  def day?
    @day
  end

  # ========================================================================= #
  # === create_skeleton                            (create tag, skeleton tag)
  # ========================================================================= #
  def create_skeleton
  end

  # ========================================================================= #
  # === month?
  # ========================================================================= #
  def month?
    @month
  end

  # ========================================================================= #
  # === year?
  # ========================================================================= #
  def year?
    @year
  end

  # ========================================================================= #
  # === update_time
  # ========================================================================= #
  def update_time
    @date = Time.new
    @year = @date.year
  end

  # ========================================================================= #
  # === mark_special_day
  #
  # Disabled.
  # ========================================================================= #
  def mark_special_days
    # puts "Now marking..."
    # self.mark_day(24)
  end

  # ========================================================================= #
  # === set_day
  # ========================================================================= #
  def set_day(i)
    @day = i
  end

  # ========================================================================= #
  # === set_month
  # ========================================================================= #
  def set_month(i)
    @month = i
  end

  # ========================================================================= #
  # === set_year
  # ========================================================================= #
  def set_year(i)
    @year = i
  end

  # ========================================================================= #
  # === connect_base
  # ========================================================================= #
  def connect_base
    @calendar = ::Gtk::Calendar.new
    @calendar.select_month(@date.month, @date.year)
    @calendar.select_day(@date.day)
    @calendar.mark_day(@date.day)
    # self.clear_marks
    if use_gtk2?
      @calendar.set_display_options(
        ::Gtk::Calendar::SHOW_HEADING      |
        ::Gtk::Calendar::SHOW_DAY_NAMES    |
        ::Gtk::Calendar::SHOW_WEEK_NUMBERS |
        ::Gtk::Calendar::WEEK_START_MONDAY
      )
    else
      @calendar.set_display_options(
        ::Gtk::CalendarDisplayOptions::SHOW_HEADING      |
        ::Gtk::CalendarDisplayOptions::SHOW_DAY_NAMES    |
        ::Gtk::CalendarDisplayOptions::SHOW_WEEK_NUMBERS
      )
    end
    report_dd_mm_yyyy
  end

  # ========================================================================= #
  # === report_dd_mm_yyyy
  # ========================================================================= #
  def report_dd_mm_yyyy(
      dd_mm_yyyy_string = return_dd_mm_yyy_string
    )
    e "#{::Colours.rev}The date is #{teal(dd_mm_yyyy_string)}"
  end

  # ========================================================================= #
  # === return_dd_mm_yyy_string
  # ========================================================================= #
  def return_dd_mm_yyy_string(date = @date)
    update_time
    year, month, day = date.year, date.month, date.day
    result = "#{day.to_s.rjust(2, '0')}.#{month.to_s.rjust(2,'0')}.#{year}"
    return result
  end

  # ========================================================================= #
  # === connect_signals
  #
  # The calendar responds to:
  #
  #   :day_selected
  #   :month_changed
  #   :day_selected_double_click
  #   :prev_month
  #   :next_month
  #   :prev_year
  #   :next_year
  #
  # ========================================================================= #
  def connect_signals(&block)
    @calendar.on_day_selected {
      date = @calendar.date # returns: [2022, 1, 20]
      set_date(date)
      # ===================================================================== #
      # This clause is entered when the user selects the current time/date,
      # on a mouse-click event.
      # ===================================================================== #
      _ = return_dd_mm_yyy_string
      if @verbose_on_the_commandline
        year, month, day = @date
        cliner
        set_day(day)
        set_month(month)
        set_year(year)
        e "Selected day:    #{teal(day)}"
        e "Selected month:  #{teal(month)}"
        report_dd_mm_yyyy(_)
        cliner
      end
      update_the_bottom_entry_with_this_text(_)
    }
    @calendar.signal_connect(:month_changed) {
      month = @date.month
      e "changed month: #{month}"
    }
    @calendar.signal_connect(:day_selected_double_click) {
      day = @date.day
      e "double-clicked day: #{day}"
    }
    @calendar.signal_connect(:prev_month) {
      month = @date.month
      e "prev month: #{month}"
    }
    @calendar.signal_connect(:next_month) {
      month = @date.month
      e "next_month: #{month}"
    }
    @calendar.signal_connect(:prev_year) {
      year = @date.year
      e "prev_year: #{year}"
    }
    @calendar.signal_connect(:next_year) {
      year = @date.year
      e "next year: #{year}"
    }
  end

  # ========================================================================= #
  # === set_date
  # ========================================================================= #
  def set_date(i = Time.new)
    if i.is_a? Array # [2022, 1, 20]
      i = Time.parse(i.last.to_s+'.'+i[1].to_s+'.'+i.first.to_s) # i is here of class Time.
    end
    @date = i
  end

  # ========================================================================= #
  # === teal
  # ========================================================================= #
  def teal(i = '')
    ::Colours.teal(i.to_s)
  end

  # ========================================================================= #
  # === Gtk::MyCalendar.width?
  # ========================================================================= #
  def self.width?
    450
  end

  # ========================================================================= #
  # === Gtk::MyCalendar.height?
  # ========================================================================= #
  def self.height?
    350
  end

  # ========================================================================= #
  # === connect_skeleton
  # ========================================================================= #
  def connect_skeleton
    connect_base
    connect_signals
  end

  # ========================================================================= #
  # === update_the_bottom_entry_with_this_text
  # ========================================================================= #
  def update_the_bottom_entry_with_this_text(i)
    @entry_current_selection.set_text(i.to_s)
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    update_time
    connect_skeleton
    mark_special_days
    maximal(@calendar)
    @entry_current_selection = create_entry
    @entry_current_selection.to_center
    add(@entry_current_selection)
  end

  # ========================================================================= #
  # === Gtk::MyCalendar.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = ::Gtk::MyCalendar.new(i)
    r = ::Gtk.run
    r << _
    r.automatic_size_then_automatic_title
    r.top_left_then_run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::MyCalendar.run
end