#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::MiniClock
# =========================================================================== #
# require 'gtk_paradise/widgets/gtk3/mini_clock/mini_clock.rb'
# Gtk.mini_clock
# Gtk::MiniClock.run
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class MiniClock < ::Gtk::Box

  require 'gtk_paradise/widgets/shared_code/mini_clock/mini_clock_module.rb'
  include ::Gtk::MiniClockModule

  # ========================================================================= #
  # === Gtk::MiniClock.run
  # ========================================================================= #
  def self.run
    ::Gtk::MiniClockModule.run
  end

  # ========================================================================= #
  # === Gtk::MiniClock.widget
  # ========================================================================= #
  def self.widget(&block)
    ::Gtk::MiniClockModule.widget(&block)
  end

end

# =========================================================================== #
# === Gtk.mini_clock
# =========================================================================== #
def self.mini_clock
  ::Gtk::MiniClock.new
end

end

if __FILE__ == $PROGRAM_NAME
  Gtk::MiniClock.run
end