#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::LinuxUsers
#
# This widget is simple: it will list which linux-users are available on
# the given computer-system.
# =========================================================================== #
# require 'gtk_paradise/widgets/gtk3/linux_users/linux_users.rb'
# include ::Gtk::LinuxUsers
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class LinuxUsers < ::Gtk::BaseModuleBox

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Users on the linux system'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = '12% or minimum 140px'

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = '40% or minimum 300px'

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :dejavu_condensed_18

  # ========================================================================= #
  # === FILE_PASSWD
  # ========================================================================= #
  FILE_PASSWD = '/etc/passwd'

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = ARGV,
      run_already           = true
    )
    super(:vertical)
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    infer_the_namespace
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, namespace?]
    title_width_height_font(TITLE, WIDTH, HEIGHT, USE_THIS_FONT)
    determine_the_main_dataset
    use_gtk_paradise_project_css_file
    infer_the_size_automatically
  end

  # ========================================================================= #
  # === determine_the_main_dataset
  # ========================================================================= #
  def determine_the_main_dataset(
      from_this_file = FILE_PASSWD
    )
    i = File.read(from_this_file)
    @dataset = []
    i.split(N).each_with_index {|line, index| index += 1
      if line.include? ':'
        @dataset << [index, line.split(':').first]
      end
    }
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    8
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    4
  end

  # ========================================================================= #
  # === create_skeleton                                          (create tag)
  # ========================================================================= #
  def create_skeleton
    create_the_main_list_store
    create_the_scrolled_window
  end

  # ========================================================================= #
  # === create_the_main_list_store
  # ========================================================================= #
  def create_the_main_list_store
    @list_store = gtk_list_store(String, String)
  end

  # ========================================================================= #
  # === create_the_scrolled_window
  # ========================================================================= #
  def create_the_scrolled_window
    tree_view = create_tree_view(@list_store)
    tree_view.use_these_headers = %w( Users Shell )
    tree_view.the_headers_can_be_resized
    tree_view.the_columns_can_be_rearranged
    tree_view.on_button_press_event {|widget, event|
      if double_click?(event)
        # =================================================================== #
        # Output the selection in this case.
        # =================================================================== #
        selected = tree_view.second_selection
        e ::Colours.steelblue(selected) # This is the selection output upon a double-click event.
      end
    }
    @scrolled_window = gtk_scrolled_window(tree_view) { :only_up_and_down }
    @scrolled_window.width_height(480, 420)
    @scrolled_window.bblack1
    @scrolled_window.pad5px
    @scrolled_window.set_border_width(2)
  end

  # ========================================================================= #
  # === add_the_first_row
  # ========================================================================= #
  def add_the_first_row
    minimal(
      left_aligned_label('<b>Users</b> on the linux-system:'), 0
    )
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
    add_the_first_row
    populate_this_list_store_with_that_array(
      @list_store, @dataset
    )
    minimal(@scrolled_window, 8)
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    super()
  end

  # ========================================================================= #
  # === Gtk::LinuxUsers.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = ::Gtk::LinuxUsers.new(i)
    r = ::Gtk.run
    r << _
    r.automatic
    r.top_left_then_run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::LinuxUsers.run
end