#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::ImageViewer
# =========================================================================== #
# require 'gtk_paradise/widgets/gtk3/image_viewer/image_viewer.rb'
# Gtk::ImageViewer.run
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class ImageViewer < ::Gtk::Box # === Gtk::ImageViewer 

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Image Viewer'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = '35% or minimum 250px'

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = '15% or minimum 100px'

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :dejavu_condensed_20

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = ARGV,
      run_already           = true
    )
    super(:vertical)
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    infer_the_namespace
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, namespace?]
    title_width_height_font(TITLE, WIDTH, HEIGHT, USE_THIS_FONT)
    use_gtk_paradise_project_css_file 
    infer_the_size_automatically
    set_work_on_this_directory(:default)
    more_CSS_then_apply_it '
#scrollbar1 slider {
  /* Size of the slider */
  min-width:     18px;
  min-height:    55px;
  border-radius: 30px;

  /* Padding around the slider */
  border: 8px solid steelblue;
}'
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    4
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    2
  end

  # ========================================================================= #
  # === create_skeleton                                          (create tag)
  # ========================================================================= #
  def create_skeleton
    # ======================================================================= #
    # === @outer_vbox
    # ======================================================================= #
    @outer_vbox = gtk_vbox
    @outer_vbox.pad5px
  end

  # ========================================================================= #
  # === set_work_on_this_directory
  # ========================================================================= #
  def set_work_on_this_directory(
      i = return_pwd
    )
    case i
    when :default
      i = return_pwd
    end
    i = i.first if i.is_a? Array
    i = i.dup if i.frozen?
    i << '/' unless i.end_with? '/'
    @work_on_this_directory = i
  end

  # ========================================================================= #
  # === do_populate_with_all_discovered_images
  # ========================================================================= #
  def do_populate_with_all_discovered_images(
      i = @work_on_this_directory
    )
    all_files = Dir[i+'*']
    all_files.select {|entry|
      entry.end_with?('.png','.jpg','.gif')
    }
    all_files.each {|this_image_file|
      use_this_image = gtk_image(this_image_file)
      @outer_vbox.minimal(
        use_this_image, 5
      )
    }
  end

  # ========================================================================= #
  # === n_images?
  #
  # This method must return a number (an integer).
  # ========================================================================= #
  def n_images?
    all_files = Dir[@work_on_this_directory+'*']
    return all_files.select {|entry|
      entry.end_with?('.png','.jpg','.gif')
    }.size
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    create_skeleton_then_connect_skeleton
    menu
  end

  # ========================================================================= #
  # === menu                                                       (menu tag)
  # ========================================================================= #
  def menu(
      i = commandline_arguments?
    )
    if i.is_a? Array
      i.each {|entry| menu(entry) }
    else
      if i and File.directory?(i)
        set_work_on_this_directory(i)
        do_populate_with_all_discovered_images
      end
    end
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
    @scrolled_window = gtk_scrolled_window(@outer_vbox) { :always_up_and_down }
    @scrolled_window.set_name('scrollbar1')
    @scrolled_window.width_height(500, 600)
    add_the_scrolled_window
  end

  # ========================================================================= #
  # === add_the_scrolled_window
  # ========================================================================= #
  def add_the_scrolled_window
    maximal(@scrolled_window)
  end

  # ========================================================================= #
  # === Gtk::ImageViewer.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = ::Gtk::ImageViewer.new(i)
    r = ::Gtk.run
    r << _
    r.automatic_size_then_automatic_title
    r.top_left_then_run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::ImageViewer.run('/home/x/data/images/games/magic_the_gathering/the_dark/')
end