#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_paradise/widgets/gtk3/editor/create.rb'
# =========================================================================== #
module Gtk

class Editor < ::Gtk::BaseModuleBox # === Gtk::Editor

  # ========================================================================= #
  # === create_the_buttons                          (buttons tag, button tag)
  # ========================================================================= #
  def create_the_buttons
    # ======================================================================= #
    # === @button_delete_selection
    # ======================================================================= #
    @button_delete_selection = button('_Delete selection')
    @button_delete_selection.on_clicked {
      delete_the_selected_text_in_the_buffer
    }
    # ======================================================================= #
    # === @button_colourize_the_text
    # ======================================================================= #
    @button_colourize_the_text = button('Colourize the text')
    @button_colourize_the_text.on_hover(:lightgreen)
    @button_colourize_the_text.bblack1
    @button_colourize_the_text.set_font(smaller_font?)
    @button_colourize_the_text.set_name('button_clear_the_textbuffer')
    @button_colourize_the_text.on_clicked {
      do_colourize_the_text_for_ruby_code
    }
    # ======================================================================= #
    # === @button_clear_the_textbuffer
    #
    # Add the "clear textbuffer" button next:
    # ======================================================================= #
    @button_clear_the_textbuffer = button('_Clear textbuffer')
    @button_clear_the_textbuffer.bblack1
    @button_clear_the_textbuffer.on_hover(:lightblue)
    @button_clear_the_textbuffer.hint =
      'Click on this button in order to clear the content of the '\
      'main textbuffer to the left.'
    @button_clear_the_textbuffer.set_font(smaller_font?)
    @button_clear_the_textbuffer.set_name('button_clear_the_textbuffer')
    @button_clear_the_textbuffer.on_clicked {
      do_clear_the_textbuffer_based_on_object_id
    }
    # ======================================================================= #
    # Create the insert-button next.
    # ======================================================================= #
    @button_insert = gtk_button('↑ Insert this Text')
    @button_insert.hint = 'Use this button to insert the text assigned '\
                          'above into the editor.'
    @button_insert.bblack1
    @button_insert.on_hover(:lightblue)
    @button_insert.use_this_font = smallest_font?
    # ======================================================================= #
    # Next, the insert-button.
    # ======================================================================= #
    @button_insert.on_clicked {
      insert_text(@entry_insert_this_text, textview?)
    }
    # ======================================================================= #
    # === @button_save_the_content_of_the_buffer
    # ======================================================================= #
    @button_save_the_content_of_the_buffer = button(
      '← Save into this local file'
    )
    @button_save_the_content_of_the_buffer.font(return_smaller_font)
    @button_save_the_content_of_the_buffer.bblack1
    @button_save_the_content_of_the_buffer.on_hover(:lightblue)
    @button_save_the_content_of_the_buffer.on_clicked {
      do_save_the_buffer
    }
    # ======================================================================= #
    # Create the retrieve-button ("get text") next.
    # ======================================================================= #
    @retrieve_button = button('_Get Text')
    @retrieve_button.hint =
      'Obtain the current selection, and put it into the buffer.'
    @retrieve_button.bblack1
    @retrieve_button.width_height(50, 20)
    @retrieve_button.on_hover(:lightblue)
    @retrieve_button.on_clicked {
      obtain_the_selection
      @entry_for_comments.set_text(
        retrieve_text(textview?).to_s
      )
    }
  end

  # ========================================================================= #
  # === obtain_the_selection
  # ========================================================================= #
  def obtain_the_selection
    retrieve_text(textview?)
  end

  # ========================================================================= #
  # === create_the_labels                             (labels tag, label tag)
  # ========================================================================= #
  def create_the_labels
    # ======================================================================= #
    # === @label_indicate_the_cursor_position
    # ======================================================================= #
    @label_indicate_the_cursor_position = left_aligned_text
    @label_indicate_the_cursor_position.css_class('border_1px_black_dotted')
    @label_indicate_the_cursor_position.pad5px
    @label_indicate_the_cursor_position.make_selectable
    @label_indicate_the_cursor_position.hint =
      'This entry will indicate the current cursor position.'
    @label_indicate_the_cursor_position.use_this_font = smaller_font?
    # ======================================================================= #
    # === @label_n_lines_in_the_file
    # ======================================================================= #
    @label_n_lines_in_the_file = left_aligned_text
    @label_n_lines_in_the_file.css_class('border_1px_black_dotted')
    @label_n_lines_in_the_file.pad5px
    @label_n_lines_in_the_file.hint =
      'This area will indicate how many lines are in the given '\
      'main buffer.'
  end

  # ========================================================================= #
  # === create_the_entries                           (entries tag, entry tag)
  # ========================================================================= #
  def create_the_entries
    # ======================================================================= #
    # === @entry_for_comments
    # ======================================================================= #
    @entry_for_comments = entry
    @entry_for_comments.hint = 'This can be used to add a comment '\
                               'to the current buffer. It will be '\
                               'activated by pressing the "enter" '\
                               'key.'
    @entry_for_comments.very_light_yellowish_background
    @entry_for_comments.on_enter {
      _ = @entry_for_comments.text?
      insert_this_text_at_the_cursor(
        "# ========================================================================= #\n"+
        '# === '+_.to_s+"\n"+
        "# ========================================================================= #\n"
      )
      do_colourize_the_buffer
      grab_focus
    }
    # ======================================================================= #
    # === @entry_save_into_this_local_file
    # ======================================================================= #
    @entry_save_into_this_local_file = entry(
      '/Depot/j/foobar.md'
    )
    @entry_save_into_this_local_file.width_height(520, 28)
    @entry_save_into_this_local_file.yellow_background
    @entry_save_into_this_local_file.bblack1
    @entry_save_into_this_local_file.pad5px
    @entry_save_into_this_local_file.use_this_font = smallest_font?
    # ======================================================================= #
    # === @entry_insert_this_text
    # ======================================================================= #
    @entry_insert_this_text = entry
    @entry_insert_this_text.align_to_the_middle
    @entry_insert_this_text.very_light_yellowish_background
    @entry_insert_this_text.bblack1
    @entry_insert_this_text.on_enter_key {
      insert_text(@entry_insert_this_text, textview?)
    }
  end

  # ========================================================================= #
  # === create_skeleton                                          (create tag)
  # ========================================================================= #
  def create_skeleton
    create_the_context_menu                # (1)
    create_the_status_bar                  # (2)
    create_the_labels                      # (3)
    create_the_top_bar                     # (4)
    create_the_notebook_tab                # (5)
    create_the_gtk_insert_character_widget # (6)
    create_the_buttons                     # (7)
    create_the_entries                     # (8)
  end

end; end