#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::CpuWidget
# =========================================================================== #
# require 'gtk_paradise/gui/gtk3/cpu_widget/cpu_widget.rb'
# Gtk::CpuWidget.run
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class CpuWidget < ::Gtk::Box # === ::Gtk::CpuWidget 

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'CPU Widget'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = '400'

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = '400'

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :dejavu_condensed_20

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = ARGV,
      run_already           = true
    )
    super(:horizontal)
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    infer_the_namespace
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, namespace?]
    title_width_height_font(TITLE, WIDTH, HEIGHT, USE_THIS_FONT)
    use_gtk_paradise_project_css_file
    infer_the_size_automatically
    # ======================================================================= #
    # === @percent
    #
    # Current CPU percentage value.
    # ======================================================================= #
    @percent = 0
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    4
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    2
  end

  # ========================================================================= #
  # === create_skeleton                                          (create tag)
  # ========================================================================= #
  def create_skeleton
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
  end

  # ========================================================================= #
  # === on_draw
  #
  # This is triggered by .initialize_the_drawing_area().
  # ========================================================================= #
  def on_draw
    cairo_context = @drawing_area.window.create_cairo_context  
    draw_shape(cairo_context)
  end

  # ========================================================================= #
  # === draw_the_green_rectangles
  # ========================================================================= #
  def draw_the_green_rectangles(
      i,
      left_position = 100
    )
    i.background_colour = :lightgreen
    i.rectangle(left_position, 250, 50, 10) # top-left-x, top-right-y, width, height
    i.fill
    i.rectangle(left_position, 230, 50, 10) # top-left-x, top-right-y, width, height
    i.fill
    i.rectangle(left_position, 210, 50, 10) # top-left-x, top-right-y, width, height
    i.fill
    i.rectangle(left_position, 190, 50, 10) # top-left-x, top-right-y, width, height
    i.fill
    i.rectangle(left_position, 170, 50, 10) # top-left-x, top-right-y, width, height
    i.fill
    i.rectangle(left_position, 150, 50, 10) # top-left-x, top-right-y, width, height
    i.fill
  end

  # ========================================================================= #
  # === draw_the_darkgreen_rectangles
  # ========================================================================= #
  def draw_the_darkgreen_rectangles(
      i,
      left_position = 100,
      y_modifier    = 100
    )
    i.background_colour = :darkgreen
    i.rectangle(left_position, 50+y_modifier, 50, 10) # top-left-x, top-right-y, width, height
    i.fill
    i.rectangle(left_position, 30+y_modifier, 50, 10) # top-left-x, top-right-y, width, height
    i.fill
    i.rectangle(left_position, 10+y_modifier, 50, 10) # top-left-x, top-right-y, width, height
    i.fill
    i.rectangle(left_position, 90+y_modifier, 50, 10) # top-left-x, top-right-y, width, height
    i.fill
    i.rectangle(left_position, 70+y_modifier, 50, 10) # top-left-x, top-right-y, width, height
    i.fill
    i.rectangle(left_position, 50+y_modifier, 50, 10) # top-left-x, top-right-y, width, height
    i.fill
  end

  # ========================================================================= #
  # === draw_shape
  # ========================================================================= #
  def draw_shape(i)
    # ======================================================================= #
    # First, draw the black background rectangle:
    # ======================================================================= #
    draw_the_black_background_rectangle(i)
    draw_the_green_rectangles(i)
    draw_the_darkgreen_rectangles(i)
  end

  # ========================================================================= #
  # === draw_the_black_background_rectangle                       (black tag)
  # ========================================================================= #
  def draw_the_black_background_rectangle(i)
    i.background_colour = :black
    i.rectangle(5, 5, 280, 280) # x, y, width, height
    i.fill
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    create_skeleton_then_connect_skeleton
    @drawing_area = Gtk::DrawingArea.new  
    @drawing_area.signal_connect(:draw) { on_draw }
    frame = gtk_frame(@drawing_area)
    frame.set_border_width(4)
    maximal(frame, 10)
    scale = vscale(0, 100, 1)
    scale.set_value(50)
    scale.set_inverted(true)
    add(scale)
  end

  # ========================================================================= #
  # === ::GUI::Gtk::CpuWidget.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = ::Gtk::CpuWidget.new(i)
    r = ::Gtk.run
    r << _
    r.automatic_size_then_automatic_title
    r.top_left_then_run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::CpuWidget.run
end