#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::ColouredSquare
# =========================================================================== #
# require 'gtk_paradise/widgets/gtk3/coloured_square/coloured_square.rb'
# include ::Gtk::ColouredSquare
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class ColouredSquare < ::Gtk::Box

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'ColouredSquare'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = 50

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = 50

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = ARGV,
      run_already           = true
    )
    super(:vertical)
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    infer_the_namespace
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, namespace?]
    # ======================================================================= #
    # === @title
    # ======================================================================= #
    @title  = TITLE
    # ======================================================================= #
    # === @width
    # ======================================================================= #
    set_width(WIDTH)
    # ======================================================================= #
    # === @height
    # ======================================================================= #
    set_height(HEIGHT)
    # ======================================================================= #
    # === @background_colour
    #
    # This will determine the background colour to use. Change it in
    # order to have another colour.
    # ======================================================================= #
    @background_colour = return_random_background_colour
    set_use_this_font(:dejavu_condensed_22)
    use_gtk_paradise_project_css_file
    infer_the_size_automatically
  end

  # ========================================================================= #
  # === return_random_background_colour
  # ========================================================================= #
  def return_random_background_colour
    ::Colours.random_html_colour.to_sym
  end

  # ========================================================================= #
  # === background_colour?
  # ========================================================================= #
  def background_colour?
    @background_colour
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    2
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    2
  end

  # ========================================================================= #
  # === create_skeleton
  # ========================================================================= #
  def create_skeleton
  end

  # ========================================================================= #
  # === transition_into_the_current_background_colour
  #
  # This method can be used to assign to another background colour for the
  # main box.
  # ========================================================================= #
  def transition_into_the_current_background_colour(
      i = @background_colour
    )
    e "LINE 130, colour chosen: #{i}"
    set_background_colour(i) # This will use override_background_color().
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
    transition_into_the_current_background_colour
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    parse_the_commandline_arguments
    create_skeleton_then_connect_skeleton
  end

  # ========================================================================= #
  # === parse_the_commandline_arguments
  # ========================================================================= #
  def parse_the_commandline_arguments
    if first_argument?
      _ = first_argument?.to_s.to_sym
      set_internal_background_colour(_)
    end
  end

  # ========================================================================= #
  # === set_internal_background_colour
  # ========================================================================= #
  def set_internal_background_colour(i)
    @background_colour = i
  end

  # ========================================================================= #
  # === Gtk::ColouredSquare.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = ::Gtk::ColouredSquare.new(i)
    r = ::Gtk.run
    r << _
    r.automatic
    r.resize_to_child_widget_dimension
    r.top_left_then_run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::ColouredSquare.run
end