#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::ButtonXorgBuffer
# =========================================================================== #
# require 'gtk_paradise/widgets/gtk3/button_xorg_buffer/button_xorg_buffer.rb'
# button_xorg_buffer = Gtk::ButtonXorgBuffer.new
# button_xorg_buffer = Gtk::ButtonXorgBuffer.new('Test_cyan')
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class ButtonXorgBuffer < ::Gtk::BaseModuleButton # === Gtk::ButtonXorgBuffer 

  begin
    require 'xorg_buffer'
  rescue LoadError; end

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Assign to the Xorg-Buffer'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = '10% or minimum 50px'

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = '10% or minimum 50px'

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :dejavu_condensed_18

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      optional_connect_to_this_widget = nil
    )
    super()
    reset
    if optional_connect_to_this_widget
      if optional_connect_to_this_widget.is_a? Hash
        _ = optional_connect_to_this_widget
        # === :label
        if _.has_key? :label
          set_my_title(_.delete(:label))
        end
      else
        # =================================================================== #
        # This here is actually the default path.
        # =================================================================== #
        @connect_to_this_widget = optional_connect_to_this_widget
      end
    end
    self.hint = '<b>Click</b> on this button to '\
                'assign to the <b>xorg-buffer</b>.'
    on_clicked {
      do_assign_this_text_to_the_xorg_buffer
    }
    # ======================================================================= #
    # === Handle blocks next
    # ======================================================================= #
    if block_given?
      yielded = yield
      case yielded
      # ===================================================================== #
      # === :split
      # ===================================================================== #
      when :split
        title?[14,0] = "\n"
      end
    end
    set_label(title?)
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, infer_the_namespace]
    # ======================================================================= #
    # === Set the title, width, height and the font in use.
    # ======================================================================= #
    title_width_height_font(TITLE, WIDTH, HEIGHT, USE_THIS_FONT)
    use_gtk_paradise_project_css_file 
    infer_the_size_automatically
    # ======================================================================= #
    # === @connect_to_this_widget
    # ======================================================================= #
    @connect_to_this_widget = nil
    # ======================================================================= #
    # === @debug
    #
    # If you want to debug this widget, set the following variable to true.
    # ======================================================================= #
    @debug = false
    # ======================================================================= #
    # === @this_text
    #
    # This is the text that will be used for this button.
    # ======================================================================= #
    @this_text = ''.dup
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    4
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    2
  end

  # ========================================================================= #
  # === set_this_text
  # ========================================================================= #
  def set_this_text(i)
    if i.is_a? Array
      i = i.join(' ').strip
    end
    @this_text = i
  end; alias assign_this_text set_this_text # === assign_this_text

  # ========================================================================= #
  # === attach                                                   (attach tag)
  #
  # This method does a set_this_text() call before then calling
  # do_assign_this_text_to_the_xorg_buffer().
  # ========================================================================= #
  def attach(i)
    set_this_text(i)
    do_assign_this_text_to_the_xorg_buffer
  end

  # ========================================================================= #
  # === do_assign_this_text_to_the_xorg_buffer
  #
  # The argument to this method should be the text you wish to assign
  # to the xorg-buffer.
  # ========================================================================= #
  def do_assign_this_text_to_the_xorg_buffer(
      this_text = @this_text
    )
    if Object.const_defined? :XorgBuffer
      if @connect_to_this_widget and
         @connect_to_this_widget.respond_to?(:selection_bound)
        # =================================================================== #
        # Connect it back to a widget, if one was provided.
        # =================================================================== #
        this_text = @connect_to_this_widget.selection_bound.buffer.text.to_s.strip
      end
      if @debug
        e "The text assigned is: #{this_text}"
      end
      XorgBuffer.copy(this_text)
    end
  end

  # ========================================================================= #
  # === Gtk::ButtonXorgBuffer.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    _ = Gtk::ButtonXorgBuffer.new
    _.attach(i) if i and !i.empty?
    r = ::Gtk.run
    r << _
    r.automatic_size_then_automatic_title
    r.top_left_then_run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::ButtonXorgBuffer.run('Testing 123')
end