#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::ButtonWithBorder
#
# This button has to display a coloured border around itself.
#
# Essentially the "base" is that of a gtk-frame.
# =========================================================================== #
# require 'gtk_paradise/gui/gtk3/button_with_border/button_with_border.rb'
# Gtk::ButtonWithBorder.run
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class ButtonWithBorder < ::Gtk::Frame # === Gtk::ButtonWithBorder 

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Button with border'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = '25% or minimum 200px'

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = '15% or minimum 100px'

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :dejavu_condensed_20

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = ARGV,
      run_already           = true
    )
    super()
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    set_border_colour
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    infer_the_namespace
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, namespace?]
    # ======================================================================= #
    # === Set the title, width, height and the font in use.
    # ======================================================================= #
    title_width_height_font(TITLE, WIDTH, HEIGHT, USE_THIS_FONT)
    use_gtk_paradise_project_css_file # or use use_project_css_file 
    infer_the_size_automatically
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    4
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    2
  end

  # ========================================================================= #
  # === create_skeleton                            (create tag, skeleton tag)
  # ========================================================================= #
  def create_skeleton
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
  end

  # ========================================================================= #
  # === set_border_colour
  #
  # Designate the colour of the border to use via this method. By default
  # this will be in the colour "steelblue".
  # ========================================================================= #
  def set_border_colour(i = :default)
    case i
    # ======================================================================= #
    # === :default
    # ======================================================================= #
    when :default
      i = :steelblue
    end
    @border_colour = i.to_sym
  end; alias set_border_color set_border_colour # === set_border_color
       alias border_colour=   set_border_colour # === border_colour=
       alias border_color=    set_border_colour # === border_color=

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    create_skeleton_then_connect_skeleton
    if respond_to? :modify_background
      modify_background(:normal, @border_colour)
      set_shadow_type(:in)
    else
      override_background_colour(:normal, @border_colour)
      set_shadow_type(:in)
    end
  end

  # ========================================================================= #
  # === Gtk::ButtonWithBorder.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = ::Gtk::ButtonWithBorder.new(i)
    r = ::Gtk.run
    r << _
    r.automatic_size_then_automatic_title
    # r.enable_quick_exit
    r.top_left_then_run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::ButtonWithBorder.run
end