#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::TreeViewDemo
# =========================================================================== #
require 'gtk_paradise/require_gtk2'

module Gtk

class TreeViewDemo < ::Gtk::VBox

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  # ========================================================================= #
  # === NAMESPACE
  # ========================================================================= #
  NAMESPACE = inspect

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH  = 600

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = 400

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      run_already = true
    )
    super()
    reset
    run if run_already
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, NAMESPACE]
    # ======================================================================= #
    # === @height
    # ======================================================================= #
    set_height(HEIGHT)
  end

  # ========================================================================= #
  # === connect_skeleton
  #
  # This method will connect the GUI parts together.
  # ========================================================================= #
  def connect_skeleton
    # Create data in treestore.
    @tree_store = ::Gtk::TreeStore.new(
      String, String, Gdk::Color, Float, GdkPixbuf::Pixbuf
    )
    # row 1
    @root_iter = @tree_store.append(nil)
    @root_iter[0] = 'Root'
    @root_iter[1] = 'red'
    @root_iter[2] = Gdk::Color.new(0, 65535, 0)
    @root_iter[3] = 5.0
    @root_iter[4] = self.render_icon(Gtk::Stock::NEW, Gtk::IconSize::DIALOG, 'icon1')
    # row 2
    @child_iter1 = @tree_store.append(@root_iter)
    @child_iter1[0] = '@child_iter1'
    @child_iter1[1] = 'green'
    @child_iter1[2] = Gdk::Color.new(65535, 0, 0)
    @child_iter1[3] = 3.0
    @child_iter1[4] = self.render_icon(Gtk::Stock::OPEN, Gtk::IconSize::MENU, 'icon2')
    # row 3
    @child_iter3 = @tree_store.append(@root_iter)
    @child_iter3[0] = '@child_iter2'
    @child_iter3[1] = 'yellow'
    @child_iter3[2] = Gdk::Color.new(0, 0, 65535)
    @child_iter3[3] = 0.9
    @child_iter3[4] = self.render_icon(Gtk::Stock::QUIT, Gtk::IconSize::BUTTON, 'icon3')
    # column 3
    @child_iter2 = @tree_store.append(@root_iter)
    @child_iter2[0] = '@child_iter2'
    @child_iter2[1] = 'green'
    @child_iter2[2] = Gdk::Color.new(0, 0, 65535)
    @child_iter2[3] = 0.2
    @child_iter2[4] = render_icon(::Gtk::Stock::ADD, ::Gtk::IconSize::BUTTON, 'icon4')
    # Create view
    @tree_view = ::Gtk::TreeView.new(@tree_store)
    create_renderer
    column = ::Gtk::TreeViewColumn.new('01) Gtk::CellRenderText', @renderer, {
      text: 0,
      background: 1,
      foreground_gdk: 2,
      scale: 3}
    )
    @tree_view.append_column(column)

    # ======================================================================= #
    # column 2
    # ======================================================================= #
    @renderer_pixbuf = gtk_cell_renderer_pixbuf

    # ======================================================================= #
    # === TreeViewColumn
    # ======================================================================= #
    column = gtk_tree_view_column(
      '02) Gtk::CellRenderPixbuf', @renderer_pixbuf, { pixbuf: 4}
    )
    @tree_view.append_column(column)
  end

  # ======================================================================== # 
  # === create_renderer
  # ======================================================================== #
  def create_renderer
    @renderer = gtk_cell_renderer_text
    @renderer.set_property('background', 'lemonchiffon')
    @renderer.set_property('foreground', 'black')
  end

  # ======================================================================== #
  # === run
  # ======================================================================== #
  def run
    connect_skeleton
    show_all
    add(@tree_view)
  end

end; end

if __FILE__ == $PROGRAM_NAME
  require 'gtk_paradise/run.rb'
  x = Gtk::TreeViewDemo.new
  r = Gtk.run('70%','60%',
    ENV['IMG'].to_s+'/STD/FAECHER.png')
  r.add_shortcut(1, 'focus_on(@entry_pid_number)', :alt)
  r.enable_quick_exit
  r << x
  r.top_left_then_run
end # treeviewdemo