#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::TimerWindow::TextField
# =========================================================================== #
# require 'gtk_paradise/classes/gtk2/timer_window/text_field.rb'
# =========================================================================== #
module Gtk

module TimerWindow

class TextField < ::Gtk::HBox

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(label_text, value)
    super(true, 10)
    @label = gtk_label(label_text)
    @entry = gtk_entry
    @entry.text = value
    connect_skeleton
  end

  # ========================================================================= #
  # === text
  # ========================================================================= #
  def text
    @entry.text
  end

  # ========================================================================= #
  # === connect_skeleton
  # ========================================================================= #
  def connect_skeleton
    add(@label)
    add(@entry)
  end

end; end; end