#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::TimerWindow::Panel
#
# This is the main panel that will hold the other widgets that belong
# to the TimerWindow module together.
# =========================================================================== #
# require 'gtk_paradise/widgets/timer_window/panel.rb'
# =========================================================================== #
require 'gtk_paradise/widgets/gtk2/timer_window/progress_bar.rb'
require 'gtk_paradise/widgets/gtk2/timer_window/text_field.rb'
require 'gtk_paradise/widgets/gtk2/timer_window/button_cancel.rb'
require 'gtk_paradise/widgets/gtk2/timer_window/button_start.rb'

module Gtk

module TimerWindow

class Panel < ::Gtk::VBox

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule
  
  attr_reader :tf_pomodoro
  attr_reader :tf_pause
  attr_reader :tf_break
  attr_reader :tf_cycles
  attr_reader :hb_start
  attr_reader :progress_bar
  attr_reader :button_start

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      run_already = true
    )
    super(true, 2)
    reset
    run if run_already
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    # === @button_start
    @button_start  = ButtonStart.new 'Start!'
    # The next variable keeps track of the cancel-button.
    @button_cancel = ButtonCancel.new 'Cancel'
    @progress_bar  = ProgressBar.new
    @tf_pomodoro   = TextField.new('Duration of the timer: ', '25')
    @tf_pause      = TextField.new('Pause time: ',  '5')
    @tf_break      = TextField.new('Break time: ', '30')
    @tf_cycles     = TextField.new('How many timers to run until break? ', '2')
  end

  # ========================================================================= #
  # === add_all_subwidgets
  # ========================================================================= #
  def add_all_subwidgets
    add @tf_pomodoro
    add @tf_pause
    add @tf_break
    add @tf_cycles
    add @hbox_button
    add @progress_bar
  end

  # ========================================================================= #
  # === create_skeleton
  # ========================================================================= #
  def create_skeleton
    @hbox_button = gtk_hbox
    @hbox_button.set_spacing(10)
    @hbox_button.add(@button_start)
    @hbox_button.add(@button_cancel)
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    create_skeleton
    add_all_subwidgets
  end

end; end; end