#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::ScaleThisImage
#
# This widget mostly just shows how to use GTK directly in order to
# scale an image.
# =========================================================================== #
require 'gtk_paradise/require_gtk2'

module Gtk

class ScaleThisImage < ::Gtk::VBox # === Gtk::ScaleThisImage

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  # ========================================================================= #
  # === NAMESPACE
  # ========================================================================= #
  NAMESPACE = inspect

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = 180

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH  = 180

  # ========================================================================= #
  # === DEFAULT_IMAGE
  # ========================================================================= #
  DEFAULT_IMAGE = '/home/x/DATA/images/GUESTBOOK2.jpg'

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      optional_use_this_image = nil
    )
    super()
    reset
    set_use_this_image(
      optional_use_this_image
    )
    gtk_image = gtk_image
    # ======================================================================= #
    # Create an empty pixbuf next:
    # ======================================================================= #
    main_pixbuf = ::GdkPixbuf::Pixbuf.new(
      colorspace: :rgb,
      has_alpha:  false,
      bits_per_sample: 8,
      width:  WIDTH,
      height: HEIGHT
    )
    main_pixbuf.fill! 0xffffffff # Fill the pixbuf with a colour.
    gtk_image.pixbuf = main_pixbuf
    # ======================================================================= #
    # Compute the scale factors, via the method get_file_info() next.
    # ======================================================================= #
    fileinfo = ::GdkPixbuf::Pixbuf.get_file_info(@use_this_image)
    if fileinfo[1] > fileinfo[2]
      width = WIDTH
      height = fileinfo[2].to_f / fileinfo[1].to_f * HEIGHT.to_f
      dest_y = (HEIGHT - height) / 2
      dest_x = 0
    else
      height = HEIGHT
      width = fileinfo[1].to_f / fileinfo[2].to_f * WIDTH.to_f
      dest_x = (WIDTH - width) / 2
      dest_y = 0
    end
    # ======================================================================= #
    # Get the image frome file at size.
    # ======================================================================= #
    overlay = ::GdkPixbuf::Pixbuf.new(
      file:   @use_this_image,
      width:  width,
      height: height
    )
    # ======================================================================= #
    # ...and render it to the empty pixbuf
    # ======================================================================= #
    overlay.copy_area(
      0, 0, width, height, main_pixbuf, dest_x, dest_y
    )
    add(gtk_image)
    add(
      gtk_label('Scaled to '+HEIGHT.to_s)
    )
    connect_skeleton
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, NAMESPACE]
    # ======================================================================= #
    # === @use_this_image
    #
    # Specify which image is to be used by default. This will only work
    # on my home system by default.
    # ======================================================================= #
    @use_this_image = DEFAULT_IMAGE
    use_gtk_paradise_project_css_file
  end

  # ========================================================================= #
  # === set_use_this_image
  # ========================================================================= #
  def set_use_this_image(i = nil)
    if i.is_a? Array
      i = i.first
    end
    case i
    when :default, nil
      i = DEFAULT_IMAGE
    end
    @use_this_image = i
  end

  # ========================================================================= #
  # === connect_skeleton
  # ========================================================================= #
  def connect_skeleton
  end

  # ========================================================================= #
  # === recommended_total_width?
  # ========================================================================= #
  def recommended_total_width?
    700
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    4
  end

end; end

if __FILE__ == $PROGRAM_NAME
  image_scaler = Gtk::ScaleThisImage.new(ARGV)
  r = Gtk.run(
    image_scaler.recommended_total_width?,
    660,
    :tabble,
    'Scale an image' 
  )
  r << image_scaler
  r.modify_background :grey
  r.top_left_then_run
end # gtkscalethisimage