#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::MiniClock
#
# This class is similar to SimpleClock, but it really does not support
# anything but simple text. That way you can quickly embed it into
# other gtk-widgets, without having to worry about anything else.
#
# Usage example:
#
#   Gtk::MiniClock.new(ARGV)
#
# =========================================================================== #
# require 'gtk_paradise/classes/gtk2/mini_clock/mini_clock.rb'
# Gtk.clock
# Gtk.return_simple_clock_widget
# Gtk::MiniClock.widget
# =========================================================================== #
require 'gtk_paradise/require_gtk2'

module Gtk

class MiniClock < ::Gtk::VBox # === Gtk::MiniClock

  require 'gtk_paradise/widgets/shared_code/mini_clock/mini_clock_module.rb'
  include ::Gtk::MiniClockModule

  # ========================================================================= #
  # === Gtk::MiniClock.run
  # ========================================================================= #
  def self.run
    Gtk::MiniClockModule.run
  end

  # ========================================================================= #
  # === Gtk::MiniClock.widget
  # ========================================================================= #
  def self.widget(&block)
    ::Gtk::MiniClockModule.widget(&block)
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::MiniClock.run
end # MiniClock