#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::MaximizeButton
#
# This button can be used to maximize a particular widget. The widget
# that is to be maximized has to be passed into .new() of this class.
# =========================================================================== #
# require 'gtk_paradise/classes/gtk2/maximize_button.rb'
# Gtk::MaximizeButton.new(widget)
# =========================================================================== #
require 'gtk_paradise/require_gtk2'

module Gtk

class MaximizeButton < ::Gtk::VBox # === Gtk::MaximizeButton

  require 'gtk_paradise/widgets/shared_code/maximize_button/maximize_button_module.rb'
  include ::Gtk::MaximizeButtonModule

  # ========================================================================= #
  # === Gtk::MaximizeButton.run
  # ========================================================================= #
  def self.run
    Gtk::MaximizeButtonModule.run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::MaximizeButtonModule.run
end # maximizebutton