#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::Animation
#
# This is just a small wrapper over Animations.
# =========================================================================== #
# require 'gtk_paradise/widgets/gtk2/animation.rb'
# =========================================================================== #
require 'gtk_paradise/require_gtk2'

module Gtk

class Animation < ::Gtk::VBox # === Gtk::Animation

  include Colours
  include ::Gtk::Colours

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  # ========================================================================= #
  # === NAMESPACE
  # ========================================================================= #
  NAMESPACE = inspect

  # ========================================================================= #
  # === THIS_IMAGE
  # ========================================================================= #
  THIS_IMAGE = ENV['IMG']+'/ANIMATIONS/Red_Dragon.gif'

  # ========================================================================= #
  # === FONT_TO_USE
  # ========================================================================= #
  FONT_TO_USE = 'Sans 20'

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'GTK-Animation'

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      run_already = true
    )
    super(TITLE)
    reset
    run if run_already
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, NAMESPACE]
    # ======================================================================= #
    # === @use_this_image
    #
    # This variable specifies the path to the animated image.
    # ======================================================================= #
    @use_this_image = THIS_IMAGE
  end

  # ========================================================================= #
  # === set_use_this_image
  # ========================================================================= #
  def set_use_this_image(i = THIS_IMAGE)
    @use_this_image = i
  end

  # ========================================================================= #
  # === animation_feedback
  # ========================================================================= #
  def show_animation_feedback
    line
    p @pixbuf_animation.width
    p @pixbuf_animation.height
    p @pixbuf_animation.static_image?
    line
  end

  # ========================================================================= #
  # === connect_skeleton
  # ========================================================================= #
  def connect_skeleton(box)
    add(box)
    show_all
  end

  # ========================================================================= #
  # === line
  # ========================================================================= #
  def line
    e '='*80
  end

  # ========================================================================= #
  # === create_the_pixbuf_animation
  # ========================================================================= #
  def create_the_pixbuf_animation
    @pixbuf_animation = GdkPixbuf::PixbufAnimation.new(@use_this_image)
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    create_the_pixbuf_animation
    box = gtk_vbox
pp @pixbuf_animation.class
    box.pack_start(
      gtk_image(@pixbuf_animation)
    )
    show_animation_feedback
    box.pack_start(
      gtk_image(@pixbuf_animation.static_image)
    )
    iter = @pixbuf_animation.get_iter
    line
    e 'Iter Info: '+iter.advance.to_s
    e 'Iter Delay Time: '+iter.delay_time.to_s
    p 'Loading frame? '+iter.on_currently_loading_frame?.to_s
    line
    image = gtk_image(iter.pixbuf)
    # ======================================================================= #
    # Add the image to the box next.
    # ======================================================================= #
    box.pack_start(image)
    connect_skeleton(box)
  end

end; end

if __FILE__ == $PROGRAM_NAME
  require 'gtk_paradise/run.rb'
  x = Gtk::Animation.new
  r = Gtk.run('50%','40%',:tabble)
  r.add_shortcut(1, 'focus_on(@entry_pid_number)', :alt)
  r.add_shortcut(2, 'focus_on(@entry_choose_pid)', :alt)
  r << x
  r.enable_quick_exit
  r.top_left_then_run
end # gtk_animation