#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This file will contain .rb files that can be required by ruby-gtk2,
# ruby-gtk3 and ruby-gtk4 just fine. The idea is to eventually be able
# to just do a "gtk_paradise/requires/require_gtk.rb", but this is for
# some time in the future.
# =========================================================================== #
# require 'gtk_paradise/requires/require_files_irrespective_of_the_gtk_version_at_hand.rb'
# =========================================================================== #
require 'gtk_paradise/requires/require_the_colours_gem.rb'
require 'gtk_paradise/project/project.rb'
require 'gtk_paradise/constants/constants.rb'

# =========================================================================== #
# Include all relevant gtk_classes next - this should happen before
# we require the Gtk::BaseModule, as the latter taps into some of
# the modifications stored under the gtk_classes/ subdirectory:
# =========================================================================== #
require 'gtk_paradise/requires/do_require_the_files_under_the_gtk_classes_subdirectory.rb'

require 'gtk_paradise/requires/require_the_base_module_the_app_module_and_the_toplevel_methods.rb'

require 'gtk_paradise/colours/gtk_colour_constants.rb'
require 'gtk_paradise/emojis/emojis.rb'

# =========================================================================== #
# Add commandline-support next.
# =========================================================================== #
require 'gtk_paradise/requires/require_the_gtk_paradise_commandline.rb'

# =========================================================================== #
# Next, require the small file version.rb:
# =========================================================================== #
require 'gtk_paradise/version/version.rb'
require 'gtk_paradise/version/upstream_gtk_version.rb'

require 'gtk_paradise/gdk/gdk.rb'

# =========================================================================== #
# Next, require the gtk_paradise/run/*rb files.
# =========================================================================== #
require 'gtk_paradise/requires/run_this_widget.rb'

require 'gtk_paradise/run/run.rb'

require 'gtk_paradise/colours/parse.rb'
# =========================================================================== #
# The next require is a bit problematic, so we are omitting it for now.
# require 'gtk_paradise/pango/pango.rb'
# =========================================================================== #
require 'gtk_paradise/base_module/base_module.rb'
