#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === FoobarParadise::GUI::Gtk::FoobarModule
# =========================================================================== #
# require 'foobar_paradise/gui/shared_code/foobar/foobar_module.rb'
# include ::FoobarParadise::GUI::Gtk::FoobarModule
# =========================================================================== #
module FoobarParadise

module GUI

module Gtk

module FoobarModule

  include ::Gtk::BaseModule

  # ========================================================================= #
  # === NAMESPACE
  # ========================================================================= #
  NAMESPACE = inspect

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Foobar'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = '80%'

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = '40%'

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :dejavu_condensed_20

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = ARGV,
      run_already           = true
    )
    super(:vertical)
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, NAMESPACE]
    # ======================================================================= #
    # === Set the title, width height and font in use.
    # ======================================================================= #
    title_width_height_font(TITLE, WIDTH, HEIGHT, USE_THIS_FONT)
    use_gtk_paradise_project_css_file # or use use_project_css_file 
    infer_the_size_automatically
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    4
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    2
  end

  # ========================================================================= #
  # === create_skeleton                                          (create tag)
  # ========================================================================= #
  def create_skeleton
  end; alias create_the_skeleton create_skeleton # === create_the_skeleton

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
    minimal(
      left_aligned_label('Hello world! This is a test.')
    )
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    super()
  end

  # ========================================================================= #
  # === FoobarParadise::GUI::Gtk::FoobarModule.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = ::FoobarParadise::GUI::Gtk::Foobar.new(i)
    r = ::Gtk.run
    r << _
    r.automatic_size_then_automatic_title
    # r.enable_quick_exit
    r.top_left_then_run
  end

end; end; end; end