#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === FoobarParadise::GUI::Gtk::Gtk4Standalone
# =========================================================================== #
# require 'foobar/gui/gtk4/gtk4_standalone/gtk4_standalone.rb'
# FoobarParadise::GUI::Gtk::Gtk4Standalone.run
# =========================================================================== #
require 'gtk_paradise/require_gtk4'

module FoobarParadise

module GUI

module Gtk

class Gtk4Standalone < ::Gtk::Box # === FoobarParadise::GUI::Gtk::Gtk4Standalone 

  include ::Gtk::BaseModule

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Pick a proper title here please.'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = '25% or minimum 200px'

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = '15% or minimum 100px'

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :dejavu_condensed_20

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = ARGV,
      run_already           = true
    )
    super(:vertical)
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_hash
    populate_the_internal_hash_with_the_default_values
    reset_the_shared_module
    infer_the_namespace
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, namespace?]
    # ======================================================================= #
    # === Set the title, width, height and the font in use.
    # ======================================================================= #
    title_width_height_font(TITLE, WIDTH, HEIGHT, USE_THIS_FONT)
    use_gtk_paradise_project_css_file # or use use_project_css_file 
    infer_the_size_automatically
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    4
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    2
  end

  # ========================================================================= #
  # === create_skeleton                            (create tag, skeleton tag)
  # ========================================================================= #
  def create_skeleton
    # create_the_entries
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
    minimal(gtk_left_aligned_label('Hello world! This is a simple test.'))
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    super()
  end

  # ========================================================================= #
  # === FoobarParadise::GUI::Gtk::Gtk4Standalone.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    ::Gtk.default_application('interactive.caesar.cipher') {{
      widget_to_use: Roebe::GUI::Gtk::InteractiveCaesarCipher.new
    }}
    # require 'gtk_paradise/run'
    # _ = ::FoobarParadise::GUI::Gtk::Gtk4Standalone.new(i)
    # r = ::Gtk.run
    # r << _
    # r.automatic_size_then_automatic_title
    # r.enable_quick_exit
    # r.top_left_then_run
  end

end; end; end; end

if __FILE__ == $PROGRAM_NAME
  FoobarParadise::GUI::Gtk::Gtk4Standalone.run
end