#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_paradise/project/project.rb'
# Gtk.project_base_directory?
# =========================================================================== #
module Gtk

  # ========================================================================= #
  # === Gtk::PROJECT_BASE_DIRECTORY
  #
  # The base directory of the project is stored here. It will point to
  # e. g. the gtk_paradise/ directory.
  # ========================================================================= #
  PROJECT_BASE_DIRECTORY =
    File.absolute_path("#{__dir__}/..")+'/'

  # ========================================================================= #
  # === Gtk.project_base_directory?
  #
  # This method should be used rather than the above constant.
  # ========================================================================= #
  def self.project_base_directory?
    PROJECT_BASE_DIRECTORY
  end; self.instance_eval { alias base_directory? project_base_directory? } # === Gtk.base_directory?

  # ========================================================================= #
  # === Gtk.project_yaml_directory?
  # ========================================================================= #
  def self.project_yaml_directory?
    "#{PROJECT_BASE_DIRECTORY}yaml/"
  end

end

if __FILE__ == $PROGRAM_NAME
  alias e puts
  e Gtk::PROJECT_BASE_DIRECTORY
  e Gtk.project_yaml_directory?
end # rb project.rb