#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This file is only useful for gtk2.
# =========================================================================== #
require 'gtk2'

include Gtk

# =========================================================================== #
# === RADIUS
# =========================================================================== #
RADIUS  = 122

# =========================================================================== #
# === N_WORDS
# =========================================================================== #
N_WORDS =  22 # 22 words shown

win = Window.new('Gdk::PangoRenderer sample')
win.set_default_size(800, 800)
win.realize

pango_matrix = Pango::Matrix.new

# =========================================================================== #
# Create the pango-renderer next:
# =========================================================================== #
pango_renderer = Gdk::PangoRenderer.default
pango_renderer.drawable = win.window
pango_renderer.gc = Gdk::GC.new(win.window)

width, height = win.size
device_radius = [width, height].min / 6.0
pango_matrix.translate!(device_radius + (width - 2 * device_radius) / 2.0,
device_radius + (height - 2 * device_radius) / 2.0)
pango_matrix.scale!(device_radius / RADIUS, device_radius / RADIUS)

context = Gdk::Pango.context

pango_layout = Pango::Layout.new(context)
# =========================================================================== #
# Which text to display.
# =========================================================================== #
pango_layout.text = 'Ruby-GNOME2'
pango_layout.font_description = Pango::FontDescription.new('Sans Bold 14')

background = Gdk::Color.new(65535, 65535, 65535)
Gdk::Colormap.system.alloc_color(background, false, true)
win.window.background = background
# =========================================================================== #
# Mouse-click event is also an expose_event.
# =========================================================================== #
win.signal_connect(:expose_event) {
  (0 ... N_WORDS).each { |i|
    rotated_matrix = pango_matrix.dup
    angle = 360 * i / N_WORDS.to_f
    color = Gdk::Color.new(65535 * rand, 65535 * rand, 65535 * rand)
    pango_renderer.set_override_color(
      Pango::Renderer::PART_FOREGROUND,
      color
    )
    rotated_matrix.rotate!(angle)
    context.set_matrix(rotated_matrix)
    pango_layout.context_changed
    width, height = pango_layout.size
    pango_renderer.draw_layout(pango_layout, width / 2, RADIUS * Pango::SCALE)
  }
}

pango_renderer.draw_layout(pango_layout, width / 2, Pango::SCALE)
button = Button.new('Testing')
vbox   = VBox.new
vbox.add(button).show_all
win.add(vbox)
win.show_all
Gtk.main