#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk3'

class HelloWorldGtk3

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    window = Gtk::Window.new('Hello world!')
    window.set_size_request(680, 680)
    window.set_border_width(2)

    button = Gtk::Button.new(label: 'Hello world!')
    button.signal_connect(:clicked) {|_widget|
      puts 'Hello World!'
    }

    window.add(button)
    window.signal_connect(:delete_event) { |_widget| Gtk.main_quit }
    window.move(0, 0)
    window.show_all
    Gtk.main
  end

end

if __FILE__ == $PROGRAM_NAME
  HelloWorldGtk3.new
end