#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk2'

class HelloWorldGtk2

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    window = Gtk::Window.new
    button = Gtk::Button.new('Hello World')
    button.signal_connect(:clicked) {|_widget|
      puts 'Hello World!'
    }
    window.add(button)
    window.set_size_request(680, 680)
    window.set_border_width(2)
    button.show
    window.move(0, 0)
    window.show_all
    Gtk.main
  end

end

if __FILE__ == $PROGRAM_NAME
  HelloWorldGtk2.new
end