#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_paradise/gnome/canvas.rb'
# =========================================================================== #
# require 'gnomecanvas2'
# =========================================================================== #
module Gnome

  # ========================================================================= #
  # === Gnome.create_canvas
  #
  # Create a new canvas through this method, from the Gnome namespace.
  #
  # @canvas = create_canvas
  # @canvas_group = create_canvas_group
  # ========================================================================= #
  def self.create_canvas
    Gnome::Canvas.new(true) if Object.const_defined? :Gnome
  end

  # ========================================================================= #
  # === Gnome.create_canvas_group
  #
  # @canvas_group = create_canvas_group
  # ========================================================================= #
  def self.create_canvas_group(x = 0.0, y = 0.0)
    return Gnome::CanvasGroup.new(@canvas.root, {x: x, y: y })
  end

  # ========================================================================= #
  # === create_canvas_rect
  #
  # should create more
  # create_canvas_rect(@canvas_group)
  # ========================================================================= #
  def self.create_canvas_rect(
      widget,x1=1.0,x_size=50,y1=1.0,y_size=55.0
    )
    return Gnome::CanvasRect.new(widget, 
      {
        :x1 => x1,
        :x2 => x1+x_size,
        :y1 => y1,
        :y2 => y1+y_size,
        :outline_color => 'black',
        :fill_color => 'green',
        :width_units => 2.0
      }
    )
  end

end