#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk4'

module Gtk

class ChangedEventsExample < ::Gtk::Box # === Gtk::ChangedEventsExample

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      run_already = true
    )
    super(:horizontal)
    reset
    run if run_already
  end

  # ========================================================================= #
  # === title?
  # ========================================================================= #
  def title?
    'Cahnged Events Example'
  end; alias title title? # === title

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    # ======================================================================= #
    # === @spinner
    # ======================================================================= #
    @spinner = ::Gtk::Spinner.new
    @spinner.set_spinning(true)
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    Thread.new {
      sleep 0.3 # Just to show how to activate it, via a slight delay.
      @spinner.set_spinning(true)
    }
    append(@spinner)

    text1 = Gtk::Label.new(
      ' This is a test. You can click on it via the mouse. '
    )
    click1 = Gtk::GestureClick.new
    click1.signal_connect(:pressed) { e 'The mouse button was clicked.' }
    text1.add_controller(click1)
    append(text1)
    set_halign(:center)
  end

end; end

if __FILE__ == $PROGRAM_NAME
  alias e puts
  application = Gtk::Application.new('org.gtk.changed_events_example', :flags_none)
  application.signal_connect(:activate) { |app|
    win = Gtk::ApplicationWindow.new(app)
    win.title = 'Showcasing Events' 
    win.set_default_size(600, 200)
    win.set_child(Gtk::ChangedEventsExample.new)
    win.signal_connect(:close_request) {
      e 'Exiting now.'
    }
    win.show
  }
  application.run
end