#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# $GTK_PARADISE/examples/gtk4/030_notebook_example.rb
# =========================================================================== #
require 'gtk4'

alias e puts

module Gtk

class NotebookExample < ::Gtk::Box # === Gtk::NotebookExample

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      run_already = true
    )
    super(:horizontal)
    reset
    run if run_already
  end

  # ========================================================================= #
  # === title?
  # ========================================================================= #
  def title?
    'Cahnged Events Example'
  end; alias title title? # === title

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    # ======================================================================= #
    # === @notebook
    # ======================================================================= #
    @notebook = ::Gtk::Notebook.new
    @notebook.set_show_tabs(true)
    @notebook.set_show_border(true)
    @notebook.set_scrollable(true)
    @notebook.set_tab_pos(:right) # This is just to demonstrate how this is done.
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    @notebook.append_page(Gtk::Label.new('#1'), Gtk::Button.new(label: 'OK'))
    @notebook.append_page(Gtk::Label.new('#2'), Gtk::Button.new(label: 'OK'))
    @notebook.page = 0
    @notebook.signal_connect(:switch_page) {|widget, event|
      puts 'page is switch'
      pp @notebook.page
      true
    }
pp @notebook.pages
    append(@notebook)
  end

end; end

Gtk::Settings.default.gtk_font_name = 'Sans 22'

if __FILE__ == $PROGRAM_NAME
  alias e puts
  application = Gtk::Application.new('org.gtk.changed_events_example', :flags_none)
  application.signal_connect(:activate) { |app|
    win = Gtk::ApplicationWindow.new(app)
    win.title = 'Showcasing Events' 
    win.set_default_size(600, 200)
    win.set_child(Gtk::NotebookExample.new)
    win.signal_connect(:close_request) {
      Gtk.main_quit
    }
    win.show
    win.signal_connect(:destroy){ Gtk.main_quit }
  }
  application.run
end