# Original example by Sami Sieranoja:
#
#   https://raw.githubusercontent.com/ruby-gnome/ruby-gnome/b65be1a44474dce55f89fe723a73b34dde676a05/gtk4/sample/examples/menubar.rb
#
require 'gtk4'

app = Gtk::Application.new('org.gtk.example', :flags_none)

app.signal_connect(:activate) {
  window = Gtk::ApplicationWindow.new(app)
  window.set_application(app)

  act_quit = Gio::SimpleAction.new('quit')
  app.add_action(act_quit)
  act_quit.signal_connect(:activate) { |_simple_action, _parameter|
    window.destroy
    exit!
  }

  menubar = Gio::Menu.new()
  menu_item_menu = Gio::MenuItem.new('Menu', nil)
  menu = Gio::Menu.new()
  menu_item_quit = Gio::MenuItem.new('Quit', 'app.quit')
  menu.append_item(menu_item_quit)
  menu_item_menu.set_submenu(menu)
  menubar.append_item(menu_item_menu)
  app.menubar = menubar
  window.set_show_menubar true

  window.show
}

if __FILE__ == $PROGRAM_NAME
  app.run  
end