#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk4'

module Gtk

class CalendarExample < ::Gtk::Box

  ::Gtk::Settings.default.gtk_font_name = 'Sans 25'

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    super(:horizontal)
    reset
    calendar = ::Gtk::Calendar.new
    # .select_month() has been deprecated.
    #calendar.select_month(@date.month, @date.year)
    # calendar.select_day(GLib::DateTime.now)
    # calendar.mark_day(GLib::DateTime.now)
    append(calendar)
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
  end

end; end

if __FILE__ == $PROGRAM_NAME

  application = Gtk::Application.new('org.gtk.calendar_example', :flags_none)
  application.signal_connect(:activate) { |app|
    win = ::Gtk::ApplicationWindow.new(app)
    win.title = 'Showcasing Ten vboxes' 
    win.set_default_size(100, 100)
    win.set_child(Gtk::CalendarExample.new)
    win.show
  }
  application.run

end